/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.evaluation.SimplifiedInvocationUnit;
import proguard.evaluation.Stack;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.TracedReferenceValue;
import proguard.evaluation.value.Value;

public class ReferenceTracingInvocationUnit
extends SimplifiedInvocationUnit {
    private final SimplifiedInvocationUnit invocationUnit;
    private int offset;

    public ReferenceTracingInvocationUnit(SimplifiedInvocationUnit simplifiedInvocationUnit) {
        this.invocationUnit = simplifiedInvocationUnit;
    }

    @Override
    public void enterExceptionHandler(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, int n2, Stack stack) {
        this.offset = n;
        super.enterExceptionHandler(clazz, method, codeAttribute, n, n2, stack);
    }

    @Override
    public void invokeMember(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction, Stack stack) {
        this.offset = n;
        super.invokeMember(clazz, method, codeAttribute, n, constantInstruction, stack);
    }

    @Override
    public Value getExceptionValue(Clazz clazz, ClassConstant classConstant) {
        return this.trace(this.invocationUnit.getExceptionValue(clazz, classConstant), this.offset | 0x20000000);
    }

    @Override
    public void setFieldClassValue(Clazz clazz, RefConstant refConstant, ReferenceValue referenceValue) {
        this.invocationUnit.setFieldClassValue(clazz, refConstant, referenceValue);
    }

    @Override
    public Value getFieldClassValue(Clazz clazz, RefConstant refConstant, String string) {
        return this.trace(this.invocationUnit.getFieldClassValue(clazz, refConstant, string), this.offset | 0x4000000);
    }

    @Override
    public void setFieldValue(Clazz clazz, RefConstant refConstant, Value value) {
        this.invocationUnit.setFieldValue(clazz, refConstant, value);
    }

    @Override
    public Value getFieldValue(Clazz clazz, RefConstant refConstant, String string) {
        return this.trace(this.invocationUnit.getFieldValue(clazz, refConstant, string), this.offset | 0x4000000);
    }

    @Override
    public void setMethodParameterValue(Clazz clazz, RefConstant refConstant, int n, Value value) {
        this.invocationUnit.setMethodParameterValue(clazz, refConstant, n, value);
    }

    @Override
    public Value getMethodParameterValue(Clazz clazz, Method method, int n, String string, Clazz clazz2) {
        Value value = this.invocationUnit.getMethodParameterValue(clazz, method, n, string, clazz2);
        return this.trace(value, n | 0x1000000);
    }

    @Override
    public void setMethodReturnValue(Clazz clazz, Method method, Value value) {
        this.invocationUnit.setMethodReturnValue(clazz, method, value);
    }

    @Override
    public Value getMethodReturnValue(Clazz clazz, RefConstant refConstant, String string) {
        Value value = this.invocationUnit.getMethodReturnValue(clazz, refConstant, string);
        return this.trace(value, this.offset | 0x2000000);
    }

    @Override
    public Value getMethodReturnValue(Clazz clazz, InvokeDynamicConstant invokeDynamicConstant, String string) {
        Value value = this.invocationUnit.getMethodReturnValue(clazz, invokeDynamicConstant, string);
        return this.trace(value, this.offset | 0x2000000);
    }

    protected Value trace(Value value, int n) {
        if (value.computationalType() != 5) {
            return value;
        }
        return this.trace(value, new InstructionOffsetValue(n));
    }

    protected Value trace(Value value, InstructionOffsetValue instructionOffsetValue) {
        return new TracedReferenceValue(this.untrace(value).referenceValue(), instructionOffsetValue);
    }

    private Value untrace(Value value) {
        return value instanceof TracedReferenceValue ? ((TracedReferenceValue)value).getReferenceValue() : value;
    }
}

