/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.NamedFieldVisitor;
import proguard.classfile.visitor.NamedMethodVisitor;

public class SimilarMemberVisitor
implements MemberVisitor {
    private final Clazz targetClass;
    private final boolean visitThisMember;
    private final boolean visitSuperMembers;
    private final boolean visitInterfaceMembers;
    private final boolean visitOverridingMembers;
    private final MemberVisitor memberVisitor;

    public SimilarMemberVisitor(boolean bl, boolean bl2, boolean bl3, boolean bl4, MemberVisitor memberVisitor) {
        this(null, bl, bl2, bl3, bl4, memberVisitor);
    }

    public SimilarMemberVisitor(Clazz clazz, boolean bl, boolean bl2, boolean bl3, boolean bl4, MemberVisitor memberVisitor) {
        this.targetClass = clazz;
        this.visitThisMember = bl;
        this.visitSuperMembers = bl2;
        this.visitInterfaceMembers = bl3;
        this.visitOverridingMembers = bl4;
        this.memberVisitor = memberVisitor;
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        Clazz clazz = this.targetClass(programClass);
        clazz.hierarchyAccept(this.visitThisMember, this.visitSuperMembers, this.visitInterfaceMembers, this.visitOverridingMembers, new NamedFieldVisitor(programField.getName(programClass), programField.getDescriptor(programClass), this.memberVisitor));
    }

    @Override
    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        Clazz clazz = this.targetClass(libraryClass);
        clazz.hierarchyAccept(this.visitThisMember, this.visitSuperMembers, this.visitInterfaceMembers, this.visitOverridingMembers, new NamedFieldVisitor(libraryField.getName(libraryClass), libraryField.getDescriptor(libraryClass), this.memberVisitor));
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        Clazz clazz = this.targetClass(programClass);
        clazz.hierarchyAccept(this.visitThisMember, this.visitSuperMembers, this.visitInterfaceMembers, this.visitOverridingMembers, new NamedMethodVisitor(programMethod.getName(programClass), programMethod.getDescriptor(programClass), this.memberVisitor));
    }

    @Override
    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        Clazz clazz = this.targetClass(libraryClass);
        clazz.hierarchyAccept(this.visitThisMember, this.visitSuperMembers, this.visitInterfaceMembers, this.visitOverridingMembers, new NamedMethodVisitor(libraryMethod.getName(libraryClass), libraryMethod.getDescriptor(libraryClass), this.memberVisitor));
    }

    private Clazz targetClass(Clazz clazz) {
        return this.targetClass != null ? this.targetClass : clazz;
    }
}

