/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.io;

import java.io.DataInput;
import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryMember;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.VisitorAccepter;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.BootstrapMethodInfo;
import proguard.classfile.attribute.BootstrapMethodsAttribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ConstantValueAttribute;
import proguard.classfile.attribute.DeprecatedAttribute;
import proguard.classfile.attribute.EnclosingMethodAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.ExceptionsAttribute;
import proguard.classfile.attribute.InnerClassesAttribute;
import proguard.classfile.attribute.InnerClassesInfo;
import proguard.classfile.attribute.LineNumberInfo;
import proguard.classfile.attribute.LineNumberTableAttribute;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.MethodParametersAttribute;
import proguard.classfile.attribute.ParameterInfo;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.SourceDirAttribute;
import proguard.classfile.attribute.SourceFileAttribute;
import proguard.classfile.attribute.SyntheticAttribute;
import proguard.classfile.attribute.UnknownAttribute;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttribute;
import proguard.classfile.attribute.annotation.AnnotationElementValue;
import proguard.classfile.attribute.annotation.AnnotationsAttribute;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ClassElementValue;
import proguard.classfile.attribute.annotation.ConstantElementValue;
import proguard.classfile.attribute.annotation.ElementValue;
import proguard.classfile.attribute.annotation.EnumConstantElementValue;
import proguard.classfile.attribute.annotation.ParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeInvisibleAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeInvisibleParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeInvisibleTypeAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeVisibleAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeVisibleParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeVisibleTypeAnnotationsAttribute;
import proguard.classfile.attribute.annotation.TypeAnnotation;
import proguard.classfile.attribute.annotation.TypeAnnotationsAttribute;
import proguard.classfile.attribute.annotation.TypePathInfo;
import proguard.classfile.attribute.annotation.target.CatchTargetInfo;
import proguard.classfile.attribute.annotation.target.EmptyTargetInfo;
import proguard.classfile.attribute.annotation.target.FormalParameterTargetInfo;
import proguard.classfile.attribute.annotation.target.LocalVariableTargetElement;
import proguard.classfile.attribute.annotation.target.LocalVariableTargetInfo;
import proguard.classfile.attribute.annotation.target.OffsetTargetInfo;
import proguard.classfile.attribute.annotation.target.SuperTypeTargetInfo;
import proguard.classfile.attribute.annotation.target.TargetInfo;
import proguard.classfile.attribute.annotation.target.ThrowsTargetInfo;
import proguard.classfile.attribute.annotation.target.TypeArgumentTargetInfo;
import proguard.classfile.attribute.annotation.target.TypeParameterBoundTargetInfo;
import proguard.classfile.attribute.annotation.target.TypeParameterTargetInfo;
import proguard.classfile.attribute.annotation.target.visitor.LocalVariableTargetElementVisitor;
import proguard.classfile.attribute.annotation.target.visitor.TargetInfoVisitor;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.ElementValueVisitor;
import proguard.classfile.attribute.annotation.visitor.TypeAnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.TypePathInfoVisitor;
import proguard.classfile.attribute.module.ExportsInfo;
import proguard.classfile.attribute.module.ModuleAttribute;
import proguard.classfile.attribute.module.ModuleMainClassAttribute;
import proguard.classfile.attribute.module.ModulePackagesAttribute;
import proguard.classfile.attribute.module.OpensInfo;
import proguard.classfile.attribute.module.ProvidesInfo;
import proguard.classfile.attribute.module.RequiresInfo;
import proguard.classfile.attribute.module.visitor.ExportsInfoVisitor;
import proguard.classfile.attribute.module.visitor.OpensInfoVisitor;
import proguard.classfile.attribute.module.visitor.ProvidesInfoVisitor;
import proguard.classfile.attribute.module.visitor.RequiresInfoVisitor;
import proguard.classfile.attribute.preverification.DoubleType;
import proguard.classfile.attribute.preverification.FloatType;
import proguard.classfile.attribute.preverification.FullFrame;
import proguard.classfile.attribute.preverification.IntegerType;
import proguard.classfile.attribute.preverification.LessZeroFrame;
import proguard.classfile.attribute.preverification.LongType;
import proguard.classfile.attribute.preverification.MoreZeroFrame;
import proguard.classfile.attribute.preverification.NullType;
import proguard.classfile.attribute.preverification.ObjectType;
import proguard.classfile.attribute.preverification.SameOneFrame;
import proguard.classfile.attribute.preverification.SameZeroFrame;
import proguard.classfile.attribute.preverification.StackMapAttribute;
import proguard.classfile.attribute.preverification.StackMapFrame;
import proguard.classfile.attribute.preverification.StackMapTableAttribute;
import proguard.classfile.attribute.preverification.TopType;
import proguard.classfile.attribute.preverification.UninitializedThisType;
import proguard.classfile.attribute.preverification.UninitializedType;
import proguard.classfile.attribute.preverification.VerificationType;
import proguard.classfile.attribute.preverification.visitor.StackMapFrameVisitor;
import proguard.classfile.attribute.preverification.visitor.VerificationTypeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.BootstrapMethodInfoVisitor;
import proguard.classfile.attribute.visitor.ExceptionInfoVisitor;
import proguard.classfile.attribute.visitor.InnerClassesInfoVisitor;
import proguard.classfile.attribute.visitor.LineNumberInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableTypeInfoVisitor;
import proguard.classfile.attribute.visitor.ParameterInfoVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.DoubleConstant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.FloatConstant;
import proguard.classfile.constant.IntegerConstant;
import proguard.classfile.constant.InterfaceMethodrefConstant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.constant.LongConstant;
import proguard.classfile.constant.MethodHandleConstant;
import proguard.classfile.constant.MethodTypeConstant;
import proguard.classfile.constant.MethodrefConstant;
import proguard.classfile.constant.ModuleConstant;
import proguard.classfile.constant.NameAndTypeConstant;
import proguard.classfile.constant.PackageConstant;
import proguard.classfile.constant.PrimitiveArrayConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.io.RuntimeDataInput;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;

public class ProgramClassReader
extends SimplifiedVisitor
implements ClassVisitor,
MemberVisitor,
ConstantVisitor,
AttributeVisitor,
BootstrapMethodInfoVisitor,
InnerClassesInfoVisitor,
ExceptionInfoVisitor,
StackMapFrameVisitor,
VerificationTypeVisitor,
LineNumberInfoVisitor,
ParameterInfoVisitor,
LocalVariableInfoVisitor,
LocalVariableTypeInfoVisitor,
RequiresInfoVisitor,
ExportsInfoVisitor,
OpensInfoVisitor,
ProvidesInfoVisitor,
AnnotationVisitor,
TypeAnnotationVisitor,
TargetInfoVisitor,
TypePathInfoVisitor,
LocalVariableTargetElementVisitor,
ElementValueVisitor {
    private final RuntimeDataInput dataInput;

    public ProgramClassReader(DataInput dataInput) {
        this.dataInput = new RuntimeDataInput(dataInput);
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        VisitorAccepter visitorAccepter;
        int n;
        int n2 = this.dataInput.readInt();
        ClassUtil.checkMagicNumber(n2);
        int n3 = this.dataInput.readUnsignedShort();
        int n4 = this.dataInput.readUnsignedShort();
        programClass.u4version = ClassUtil.internalClassVersion(n4, n3);
        ClassUtil.checkVersionNumbers(programClass.u4version);
        programClass.u2constantPoolCount = this.dataInput.readUnsignedShort();
        programClass.constantPool = new Constant[programClass.u2constantPoolCount];
        for (n = 1; n < programClass.u2constantPoolCount; ++n) {
            visitorAccepter = this.createConstant();
            ((Constant)visitorAccepter).accept(programClass, this);
            programClass.constantPool[n] = visitorAccepter;
            int n5 = ((Constant)visitorAccepter).getTag();
            if (n5 != 5 && n5 != 6) continue;
            programClass.constantPool[++n] = null;
        }
        programClass.u2accessFlags = this.dataInput.readUnsignedShort();
        programClass.u2thisClass = this.dataInput.readUnsignedShort();
        programClass.u2superClass = this.dataInput.readUnsignedShort();
        programClass.u2interfacesCount = this.dataInput.readUnsignedShort();
        programClass.u2interfaces = new int[programClass.u2interfacesCount];
        for (n = 0; n < programClass.u2interfacesCount; ++n) {
            programClass.u2interfaces[n] = this.dataInput.readUnsignedShort();
        }
        programClass.u2fieldsCount = this.dataInput.readUnsignedShort();
        programClass.fields = new ProgramField[programClass.u2fieldsCount];
        for (n = 0; n < programClass.u2fieldsCount; ++n) {
            visitorAccepter = new ProgramField();
            this.visitProgramField(programClass, (ProgramField)visitorAccepter);
            programClass.fields[n] = visitorAccepter;
        }
        programClass.u2methodsCount = this.dataInput.readUnsignedShort();
        programClass.methods = new ProgramMethod[programClass.u2methodsCount];
        for (n = 0; n < programClass.u2methodsCount; ++n) {
            visitorAccepter = new ProgramMethod();
            this.visitProgramMethod(programClass, (ProgramMethod)visitorAccepter);
            programClass.methods[n] = visitorAccepter;
        }
        programClass.u2attributesCount = this.dataInput.readUnsignedShort();
        programClass.attributes = new Attribute[programClass.u2attributesCount];
        for (n = 0; n < programClass.u2attributesCount; ++n) {
            visitorAccepter = this.createAttribute(programClass);
            ((Attribute)visitorAccepter).accept(programClass, this);
            programClass.attributes[n] = visitorAccepter;
        }
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        programField.u2accessFlags = this.dataInput.readUnsignedShort();
        programField.u2nameIndex = this.dataInput.readUnsignedShort();
        programField.u2descriptorIndex = this.dataInput.readUnsignedShort();
        programField.u2attributesCount = this.dataInput.readUnsignedShort();
        programField.attributes = new Attribute[programField.u2attributesCount];
        for (int i = 0; i < programField.u2attributesCount; ++i) {
            Attribute attribute = this.createAttribute(programClass);
            attribute.accept((Clazz)programClass, programField, (AttributeVisitor)this);
            programField.attributes[i] = attribute;
        }
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        programMethod.u2accessFlags = this.dataInput.readUnsignedShort();
        programMethod.u2nameIndex = this.dataInput.readUnsignedShort();
        programMethod.u2descriptorIndex = this.dataInput.readUnsignedShort();
        programMethod.u2attributesCount = this.dataInput.readUnsignedShort();
        programMethod.attributes = new Attribute[programMethod.u2attributesCount];
        for (int i = 0; i < programMethod.u2attributesCount; ++i) {
            Attribute attribute = this.createAttribute(programClass);
            attribute.accept((Clazz)programClass, programMethod, (AttributeVisitor)this);
            programMethod.attributes[i] = attribute;
        }
    }

    @Override
    public void visitLibraryMember(LibraryClass libraryClass, LibraryMember libraryMember) {
    }

    @Override
    public void visitIntegerConstant(Clazz clazz, IntegerConstant integerConstant) {
        integerConstant.u4value = this.dataInput.readInt();
    }

    @Override
    public void visitLongConstant(Clazz clazz, LongConstant longConstant) {
        longConstant.u8value = this.dataInput.readLong();
    }

    @Override
    public void visitFloatConstant(Clazz clazz, FloatConstant floatConstant) {
        floatConstant.f4value = this.dataInput.readFloat();
    }

    @Override
    public void visitDoubleConstant(Clazz clazz, DoubleConstant doubleConstant) {
        doubleConstant.f8value = this.dataInput.readDouble();
    }

    @Override
    public void visitPrimitiveArrayConstant(Clazz clazz, PrimitiveArrayConstant primitiveArrayConstant) {
        char c = this.dataInput.readChar();
        int n = this.dataInput.readInt();
        switch (c) {
            case 'Z': {
                boolean[] blArray = new boolean[n];
                for (int i = 0; i < n; ++i) {
                    blArray[i] = this.dataInput.readBoolean();
                }
                primitiveArrayConstant.values = blArray;
                break;
            }
            case 'B': {
                byte[] byArray = new byte[n];
                this.dataInput.readFully(byArray);
                primitiveArrayConstant.values = byArray;
                break;
            }
            case 'C': {
                char[] cArray = new char[n];
                for (int i = 0; i < n; ++i) {
                    cArray[i] = this.dataInput.readChar();
                }
                primitiveArrayConstant.values = cArray;
                break;
            }
            case 'S': {
                short[] sArray = new short[n];
                for (int i = 0; i < n; ++i) {
                    sArray[i] = this.dataInput.readShort();
                }
                primitiveArrayConstant.values = sArray;
                break;
            }
            case 'I': {
                int[] nArray = new int[n];
                for (int i = 0; i < n; ++i) {
                    nArray[i] = this.dataInput.readInt();
                }
                primitiveArrayConstant.values = nArray;
                break;
            }
            case 'F': {
                float[] fArray = new float[n];
                for (int i = 0; i < n; ++i) {
                    fArray[i] = this.dataInput.readFloat();
                }
                primitiveArrayConstant.values = fArray;
                break;
            }
            case 'J': {
                long[] lArray = new long[n];
                for (int i = 0; i < n; ++i) {
                    lArray[i] = this.dataInput.readLong();
                }
                primitiveArrayConstant.values = lArray;
                break;
            }
            case 'D': {
                double[] dArray = new double[n];
                for (int i = 0; i < n; ++i) {
                    dArray[i] = this.dataInput.readDouble();
                }
                primitiveArrayConstant.values = dArray;
                break;
            }
        }
    }

    @Override
    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        stringConstant.u2stringIndex = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitUtf8Constant(Clazz clazz, Utf8Constant utf8Constant) {
        int n = this.dataInput.readUnsignedShort();
        byte[] byArray = new byte[n];
        this.dataInput.readFully(byArray);
        utf8Constant.setBytes(byArray);
    }

    @Override
    public void visitInvokeDynamicConstant(Clazz clazz, InvokeDynamicConstant invokeDynamicConstant) {
        invokeDynamicConstant.u2bootstrapMethodAttributeIndex = this.dataInput.readUnsignedShort();
        invokeDynamicConstant.u2nameAndTypeIndex = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitMethodHandleConstant(Clazz clazz, MethodHandleConstant methodHandleConstant) {
        methodHandleConstant.u1referenceKind = this.dataInput.readUnsignedByte();
        methodHandleConstant.u2referenceIndex = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitModuleConstant(Clazz clazz, ModuleConstant moduleConstant) {
        moduleConstant.u2nameIndex = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitPackageConstant(Clazz clazz, PackageConstant packageConstant) {
        packageConstant.u2nameIndex = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
        refConstant.u2classIndex = this.dataInput.readUnsignedShort();
        refConstant.u2nameAndTypeIndex = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        classConstant.u2nameIndex = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitMethodTypeConstant(Clazz clazz, MethodTypeConstant methodTypeConstant) {
        methodTypeConstant.u2descriptorIndex = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitNameAndTypeConstant(Clazz clazz, NameAndTypeConstant nameAndTypeConstant) {
        nameAndTypeConstant.u2nameIndex = this.dataInput.readUnsignedShort();
        nameAndTypeConstant.u2descriptorIndex = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitUnknownAttribute(Clazz clazz, UnknownAttribute unknownAttribute) {
        byte[] byArray = new byte[unknownAttribute.u4attributeLength];
        this.dataInput.readFully(byArray);
        unknownAttribute.info = byArray;
    }

    @Override
    public void visitBootstrapMethodsAttribute(Clazz clazz, BootstrapMethodsAttribute bootstrapMethodsAttribute) {
        bootstrapMethodsAttribute.u2bootstrapMethodsCount = this.dataInput.readUnsignedShort();
        bootstrapMethodsAttribute.bootstrapMethods = new BootstrapMethodInfo[bootstrapMethodsAttribute.u2bootstrapMethodsCount];
        for (int i = 0; i < bootstrapMethodsAttribute.u2bootstrapMethodsCount; ++i) {
            BootstrapMethodInfo bootstrapMethodInfo = new BootstrapMethodInfo();
            this.visitBootstrapMethodInfo(clazz, bootstrapMethodInfo);
            bootstrapMethodsAttribute.bootstrapMethods[i] = bootstrapMethodInfo;
        }
    }

    @Override
    public void visitSourceFileAttribute(Clazz clazz, SourceFileAttribute sourceFileAttribute) {
        sourceFileAttribute.u2sourceFileIndex = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitSourceDirAttribute(Clazz clazz, SourceDirAttribute sourceDirAttribute) {
        sourceDirAttribute.u2sourceDirIndex = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitInnerClassesAttribute(Clazz clazz, InnerClassesAttribute innerClassesAttribute) {
        innerClassesAttribute.u2classesCount = this.dataInput.readUnsignedShort();
        innerClassesAttribute.classes = new InnerClassesInfo[innerClassesAttribute.u2classesCount];
        for (int i = 0; i < innerClassesAttribute.u2classesCount; ++i) {
            InnerClassesInfo innerClassesInfo = new InnerClassesInfo();
            this.visitInnerClassesInfo(clazz, innerClassesInfo);
            innerClassesAttribute.classes[i] = innerClassesInfo;
        }
    }

    @Override
    public void visitEnclosingMethodAttribute(Clazz clazz, EnclosingMethodAttribute enclosingMethodAttribute) {
        enclosingMethodAttribute.u2classIndex = this.dataInput.readUnsignedShort();
        enclosingMethodAttribute.u2nameAndTypeIndex = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitModuleAttribute(Clazz clazz, ModuleAttribute moduleAttribute) {
        VisitorAccepter visitorAccepter;
        int n;
        moduleAttribute.u2moduleNameIndex = this.dataInput.readUnsignedShort();
        moduleAttribute.u2moduleFlags = this.dataInput.readUnsignedShort();
        moduleAttribute.u2moduleVersionIndex = this.dataInput.readUnsignedShort();
        moduleAttribute.u2requiresCount = this.dataInput.readUnsignedShort();
        moduleAttribute.requires = new RequiresInfo[moduleAttribute.u2requiresCount];
        for (n = 0; n < moduleAttribute.u2requiresCount; ++n) {
            visitorAccepter = new RequiresInfo();
            this.visitRequiresInfo(clazz, (RequiresInfo)visitorAccepter);
            moduleAttribute.requires[n] = visitorAccepter;
        }
        moduleAttribute.u2exportsCount = this.dataInput.readUnsignedShort();
        moduleAttribute.exports = new ExportsInfo[moduleAttribute.u2exportsCount];
        for (n = 0; n < moduleAttribute.u2exportsCount; ++n) {
            visitorAccepter = new ExportsInfo();
            this.visitExportsInfo(clazz, (ExportsInfo)visitorAccepter);
            moduleAttribute.exports[n] = visitorAccepter;
        }
        moduleAttribute.u2opensCount = this.dataInput.readUnsignedShort();
        moduleAttribute.opens = new OpensInfo[moduleAttribute.u2opensCount];
        for (n = 0; n < moduleAttribute.u2opensCount; ++n) {
            visitorAccepter = new OpensInfo();
            this.visitOpensInfo(clazz, (OpensInfo)visitorAccepter);
            moduleAttribute.opens[n] = visitorAccepter;
        }
        moduleAttribute.u2usesCount = this.dataInput.readUnsignedShort();
        moduleAttribute.u2uses = new int[moduleAttribute.u2usesCount];
        for (n = 0; n < moduleAttribute.u2usesCount; ++n) {
            moduleAttribute.u2uses[n] = this.dataInput.readUnsignedShort();
        }
        moduleAttribute.u2providesCount = this.dataInput.readUnsignedShort();
        moduleAttribute.provides = new ProvidesInfo[moduleAttribute.u2providesCount];
        for (n = 0; n < moduleAttribute.u2providesCount; ++n) {
            visitorAccepter = new ProvidesInfo();
            this.visitProvidesInfo(clazz, (ProvidesInfo)visitorAccepter);
            moduleAttribute.provides[n] = visitorAccepter;
        }
    }

    @Override
    public void visitModuleMainClassAttribute(Clazz clazz, ModuleMainClassAttribute moduleMainClassAttribute) {
        moduleMainClassAttribute.u2mainClass = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitModulePackagesAttribute(Clazz clazz, ModulePackagesAttribute modulePackagesAttribute) {
        modulePackagesAttribute.u2packagesCount = this.dataInput.readUnsignedShort();
        modulePackagesAttribute.u2packages = new int[modulePackagesAttribute.u2packagesCount];
        for (int i = 0; i < modulePackagesAttribute.u2packagesCount; ++i) {
            modulePackagesAttribute.u2packages[i] = this.dataInput.readUnsignedShort();
        }
    }

    @Override
    public void visitDeprecatedAttribute(Clazz clazz, DeprecatedAttribute deprecatedAttribute) {
    }

    @Override
    public void visitSyntheticAttribute(Clazz clazz, SyntheticAttribute syntheticAttribute) {
    }

    @Override
    public void visitSignatureAttribute(Clazz clazz, SignatureAttribute signatureAttribute) {
        signatureAttribute.u2signatureIndex = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitConstantValueAttribute(Clazz clazz, Field field, ConstantValueAttribute constantValueAttribute) {
        constantValueAttribute.u2constantValueIndex = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitMethodParametersAttribute(Clazz clazz, Method method, MethodParametersAttribute methodParametersAttribute) {
        methodParametersAttribute.u1parametersCount = this.dataInput.readUnsignedByte();
        methodParametersAttribute.parameters = new ParameterInfo[methodParametersAttribute.u1parametersCount];
        for (int i = 0; i < methodParametersAttribute.u1parametersCount; ++i) {
            ParameterInfo parameterInfo = new ParameterInfo();
            this.visitParameterInfo(clazz, method, i, parameterInfo);
            methodParametersAttribute.parameters[i] = parameterInfo;
        }
    }

    @Override
    public void visitExceptionsAttribute(Clazz clazz, Method method, ExceptionsAttribute exceptionsAttribute) {
        exceptionsAttribute.u2exceptionIndexTableLength = this.dataInput.readUnsignedShort();
        exceptionsAttribute.u2exceptionIndexTable = new int[exceptionsAttribute.u2exceptionIndexTableLength];
        for (int i = 0; i < exceptionsAttribute.u2exceptionIndexTableLength; ++i) {
            exceptionsAttribute.u2exceptionIndexTable[i] = this.dataInput.readUnsignedShort();
        }
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        VisitorAccepter visitorAccepter;
        int n;
        codeAttribute.u2maxStack = this.dataInput.readUnsignedShort();
        codeAttribute.u2maxLocals = this.dataInput.readUnsignedShort();
        codeAttribute.u4codeLength = this.dataInput.readInt();
        byte[] byArray = new byte[codeAttribute.u4codeLength];
        this.dataInput.readFully(byArray);
        codeAttribute.code = byArray;
        codeAttribute.u2exceptionTableLength = this.dataInput.readUnsignedShort();
        codeAttribute.exceptionTable = new ExceptionInfo[codeAttribute.u2exceptionTableLength];
        for (n = 0; n < codeAttribute.u2exceptionTableLength; ++n) {
            visitorAccepter = new ExceptionInfo();
            this.visitExceptionInfo(clazz, method, codeAttribute, (ExceptionInfo)visitorAccepter);
            codeAttribute.exceptionTable[n] = visitorAccepter;
        }
        codeAttribute.u2attributesCount = this.dataInput.readUnsignedShort();
        codeAttribute.attributes = new Attribute[codeAttribute.u2attributesCount];
        for (n = 0; n < codeAttribute.u2attributesCount; ++n) {
            visitorAccepter = this.createAttribute(clazz);
            ((Attribute)visitorAccepter).accept(clazz, method, codeAttribute, this);
            codeAttribute.attributes[n] = visitorAccepter;
        }
    }

    @Override
    public void visitStackMapAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, StackMapAttribute stackMapAttribute) {
        stackMapAttribute.u2stackMapFramesCount = this.dataInput.readUnsignedShort();
        stackMapAttribute.stackMapFrames = new FullFrame[stackMapAttribute.u2stackMapFramesCount];
        for (int i = 0; i < stackMapAttribute.u2stackMapFramesCount; ++i) {
            FullFrame fullFrame = new FullFrame();
            this.visitFullFrame(clazz, method, codeAttribute, i, fullFrame);
            stackMapAttribute.stackMapFrames[i] = fullFrame;
        }
    }

    @Override
    public void visitStackMapTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, StackMapTableAttribute stackMapTableAttribute) {
        stackMapTableAttribute.u2stackMapFramesCount = this.dataInput.readUnsignedShort();
        stackMapTableAttribute.stackMapFrames = new StackMapFrame[stackMapTableAttribute.u2stackMapFramesCount];
        for (int i = 0; i < stackMapTableAttribute.u2stackMapFramesCount; ++i) {
            StackMapFrame stackMapFrame = this.createStackMapFrame();
            stackMapFrame.accept(clazz, method, codeAttribute, 0, this);
            stackMapTableAttribute.stackMapFrames[i] = stackMapFrame;
        }
    }

    @Override
    public void visitLineNumberTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberTableAttribute lineNumberTableAttribute) {
        lineNumberTableAttribute.u2lineNumberTableLength = this.dataInput.readUnsignedShort();
        lineNumberTableAttribute.lineNumberTable = new LineNumberInfo[lineNumberTableAttribute.u2lineNumberTableLength];
        for (int i = 0; i < lineNumberTableAttribute.u2lineNumberTableLength; ++i) {
            LineNumberInfo lineNumberInfo = new LineNumberInfo();
            this.visitLineNumberInfo(clazz, method, codeAttribute, lineNumberInfo);
            lineNumberTableAttribute.lineNumberTable[i] = lineNumberInfo;
        }
    }

    @Override
    public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
        localVariableTableAttribute.u2localVariableTableLength = this.dataInput.readUnsignedShort();
        localVariableTableAttribute.localVariableTable = new LocalVariableInfo[localVariableTableAttribute.u2localVariableTableLength];
        for (int i = 0; i < localVariableTableAttribute.u2localVariableTableLength; ++i) {
            LocalVariableInfo localVariableInfo = new LocalVariableInfo();
            this.visitLocalVariableInfo(clazz, method, codeAttribute, localVariableInfo);
            localVariableTableAttribute.localVariableTable[i] = localVariableInfo;
        }
    }

    @Override
    public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
        localVariableTypeTableAttribute.u2localVariableTypeTableLength = this.dataInput.readUnsignedShort();
        localVariableTypeTableAttribute.localVariableTypeTable = new LocalVariableTypeInfo[localVariableTypeTableAttribute.u2localVariableTypeTableLength];
        for (int i = 0; i < localVariableTypeTableAttribute.u2localVariableTypeTableLength; ++i) {
            LocalVariableTypeInfo localVariableTypeInfo = new LocalVariableTypeInfo();
            this.visitLocalVariableTypeInfo(clazz, method, codeAttribute, localVariableTypeInfo);
            localVariableTypeTableAttribute.localVariableTypeTable[i] = localVariableTypeInfo;
        }
    }

    @Override
    public void visitAnyAnnotationsAttribute(Clazz clazz, AnnotationsAttribute annotationsAttribute) {
        annotationsAttribute.u2annotationsCount = this.dataInput.readUnsignedShort();
        annotationsAttribute.annotations = new Annotation[annotationsAttribute.u2annotationsCount];
        for (int i = 0; i < annotationsAttribute.u2annotationsCount; ++i) {
            Annotation annotation = new Annotation();
            this.visitAnnotation(clazz, annotation);
            annotationsAttribute.annotations[i] = annotation;
        }
    }

    @Override
    public void visitAnyParameterAnnotationsAttribute(Clazz clazz, Method method, ParameterAnnotationsAttribute parameterAnnotationsAttribute) {
        int n;
        parameterAnnotationsAttribute.u1parametersCount = this.dataInput.readUnsignedByte();
        int n2 = 0;
        if (method.getName(clazz).equals("<init>")) {
            n = ClassUtil.internalMethodParameterCount(method.getDescriptor(clazz));
            n2 = n - parameterAnnotationsAttribute.u1parametersCount;
            parameterAnnotationsAttribute.u1parametersCount = n;
        }
        parameterAnnotationsAttribute.u2parameterAnnotationsCount = new int[parameterAnnotationsAttribute.u1parametersCount];
        parameterAnnotationsAttribute.parameterAnnotations = new Annotation[parameterAnnotationsAttribute.u1parametersCount][];
        for (n = n2; n < parameterAnnotationsAttribute.u1parametersCount; ++n) {
            int n3 = this.dataInput.readUnsignedShort();
            Annotation[] annotationArray = new Annotation[n3];
            for (int i = 0; i < n3; ++i) {
                Annotation annotation = new Annotation();
                this.visitAnnotation(clazz, annotation);
                annotationArray[i] = annotation;
            }
            parameterAnnotationsAttribute.u2parameterAnnotationsCount[n] = n3;
            parameterAnnotationsAttribute.parameterAnnotations[n] = annotationArray;
        }
    }

    @Override
    public void visitAnyTypeAnnotationsAttribute(Clazz clazz, TypeAnnotationsAttribute typeAnnotationsAttribute) {
        typeAnnotationsAttribute.u2annotationsCount = this.dataInput.readUnsignedShort();
        typeAnnotationsAttribute.annotations = new TypeAnnotation[typeAnnotationsAttribute.u2annotationsCount];
        for (int i = 0; i < typeAnnotationsAttribute.u2annotationsCount; ++i) {
            TypeAnnotation typeAnnotation = new TypeAnnotation();
            this.visitTypeAnnotation(clazz, typeAnnotation);
            typeAnnotationsAttribute.annotations[i] = typeAnnotation;
        }
    }

    @Override
    public void visitAnnotationDefaultAttribute(Clazz clazz, Method method, AnnotationDefaultAttribute annotationDefaultAttribute) {
        ElementValue elementValue = this.createElementValue();
        elementValue.accept(clazz, null, this);
        annotationDefaultAttribute.defaultValue = elementValue;
    }

    @Override
    public void visitBootstrapMethodInfo(Clazz clazz, BootstrapMethodInfo bootstrapMethodInfo) {
        bootstrapMethodInfo.u2methodHandleIndex = this.dataInput.readUnsignedShort();
        bootstrapMethodInfo.u2methodArgumentCount = this.dataInput.readUnsignedShort();
        bootstrapMethodInfo.u2methodArguments = new int[bootstrapMethodInfo.u2methodArgumentCount];
        for (int i = 0; i < bootstrapMethodInfo.u2methodArgumentCount; ++i) {
            bootstrapMethodInfo.u2methodArguments[i] = this.dataInput.readUnsignedShort();
        }
    }

    @Override
    public void visitInnerClassesInfo(Clazz clazz, InnerClassesInfo innerClassesInfo) {
        innerClassesInfo.u2innerClassIndex = this.dataInput.readUnsignedShort();
        innerClassesInfo.u2outerClassIndex = this.dataInput.readUnsignedShort();
        innerClassesInfo.u2innerNameIndex = this.dataInput.readUnsignedShort();
        innerClassesInfo.u2innerClassAccessFlags = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitExceptionInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, ExceptionInfo exceptionInfo) {
        exceptionInfo.u2startPC = this.dataInput.readUnsignedShort();
        exceptionInfo.u2endPC = this.dataInput.readUnsignedShort();
        exceptionInfo.u2handlerPC = this.dataInput.readUnsignedShort();
        exceptionInfo.u2catchType = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitSameZeroFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SameZeroFrame sameZeroFrame) {
        if (sameZeroFrame.getTag() == 251) {
            sameZeroFrame.u2offsetDelta = this.dataInput.readUnsignedShort();
        }
    }

    @Override
    public void visitSameOneFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SameOneFrame sameOneFrame) {
        if (sameOneFrame.getTag() == 247) {
            sameOneFrame.u2offsetDelta = this.dataInput.readUnsignedShort();
        }
        VerificationType verificationType = this.createVerificationType();
        verificationType.accept(clazz, method, codeAttribute, n, this);
        sameOneFrame.stackItem = verificationType;
    }

    @Override
    public void visitLessZeroFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, LessZeroFrame lessZeroFrame) {
        lessZeroFrame.u2offsetDelta = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitMoreZeroFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, MoreZeroFrame moreZeroFrame) {
        moreZeroFrame.u2offsetDelta = this.dataInput.readUnsignedShort();
        moreZeroFrame.additionalVariables = new VerificationType[moreZeroFrame.additionalVariablesCount];
        for (int i = 0; i < moreZeroFrame.additionalVariablesCount; ++i) {
            VerificationType verificationType = this.createVerificationType();
            verificationType.accept(clazz, method, codeAttribute, n, this);
            moreZeroFrame.additionalVariables[i] = verificationType;
        }
    }

    @Override
    public void visitFullFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, FullFrame fullFrame) {
        VerificationType verificationType;
        int n2;
        fullFrame.u2offsetDelta = this.dataInput.readUnsignedShort();
        fullFrame.variablesCount = this.dataInput.readUnsignedShort();
        fullFrame.variables = new VerificationType[fullFrame.variablesCount];
        for (n2 = 0; n2 < fullFrame.variablesCount; ++n2) {
            verificationType = this.createVerificationType();
            verificationType.variablesAccept(clazz, method, codeAttribute, n, n2, this);
            fullFrame.variables[n2] = verificationType;
        }
        fullFrame.stackCount = this.dataInput.readUnsignedShort();
        fullFrame.stack = new VerificationType[fullFrame.stackCount];
        for (n2 = 0; n2 < fullFrame.stackCount; ++n2) {
            verificationType = this.createVerificationType();
            verificationType.stackAccept(clazz, method, codeAttribute, n, n2, this);
            fullFrame.stack[n2] = verificationType;
        }
    }

    @Override
    public void visitAnyVerificationType(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, VerificationType verificationType) {
    }

    @Override
    public void visitObjectType(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ObjectType objectType) {
        objectType.u2classIndex = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitUninitializedType(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, UninitializedType uninitializedType) {
        uninitializedType.u2newInstructionOffset = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitLineNumberInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberInfo lineNumberInfo) {
        lineNumberInfo.u2startPC = this.dataInput.readUnsignedShort();
        lineNumberInfo.u2lineNumber = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitParameterInfo(Clazz clazz, Method method, int n, ParameterInfo parameterInfo) {
        parameterInfo.u2nameIndex = this.dataInput.readUnsignedShort();
        parameterInfo.u2accessFlags = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitLocalVariableInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableInfo localVariableInfo) {
        localVariableInfo.u2startPC = this.dataInput.readUnsignedShort();
        localVariableInfo.u2length = this.dataInput.readUnsignedShort();
        localVariableInfo.u2nameIndex = this.dataInput.readUnsignedShort();
        localVariableInfo.u2descriptorIndex = this.dataInput.readUnsignedShort();
        localVariableInfo.u2index = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitLocalVariableTypeInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeInfo localVariableTypeInfo) {
        localVariableTypeInfo.u2startPC = this.dataInput.readUnsignedShort();
        localVariableTypeInfo.u2length = this.dataInput.readUnsignedShort();
        localVariableTypeInfo.u2nameIndex = this.dataInput.readUnsignedShort();
        localVariableTypeInfo.u2signatureIndex = this.dataInput.readUnsignedShort();
        localVariableTypeInfo.u2index = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitRequiresInfo(Clazz clazz, RequiresInfo requiresInfo) {
        requiresInfo.u2requiresIndex = this.dataInput.readUnsignedShort();
        requiresInfo.u2requiresFlags = this.dataInput.readUnsignedShort();
        requiresInfo.u2requiresVersionIndex = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitExportsInfo(Clazz clazz, ExportsInfo exportsInfo) {
        exportsInfo.u2exportsIndex = this.dataInput.readUnsignedShort();
        exportsInfo.u2exportsFlags = this.dataInput.readUnsignedShort();
        exportsInfo.u2exportsToCount = this.dataInput.readUnsignedShort();
        exportsInfo.u2exportsToIndex = new int[exportsInfo.u2exportsToCount];
        for (int i = 0; i < exportsInfo.u2exportsToCount; ++i) {
            exportsInfo.u2exportsToIndex[i] = this.dataInput.readUnsignedShort();
        }
    }

    @Override
    public void visitOpensInfo(Clazz clazz, OpensInfo opensInfo) {
        opensInfo.u2opensIndex = this.dataInput.readUnsignedShort();
        opensInfo.u2opensFlags = this.dataInput.readUnsignedShort();
        opensInfo.u2opensToCount = this.dataInput.readUnsignedShort();
        opensInfo.u2opensToIndex = new int[opensInfo.u2opensToCount];
        for (int i = 0; i < opensInfo.u2opensToCount; ++i) {
            opensInfo.u2opensToIndex[i] = this.dataInput.readUnsignedShort();
        }
    }

    @Override
    public void visitProvidesInfo(Clazz clazz, ProvidesInfo providesInfo) {
        providesInfo.u2providesIndex = this.dataInput.readUnsignedShort();
        providesInfo.u2providesWithCount = this.dataInput.readUnsignedShort();
        providesInfo.u2providesWithIndex = new int[providesInfo.u2providesWithCount];
        for (int i = 0; i < providesInfo.u2providesWithCount; ++i) {
            providesInfo.u2providesWithIndex[i] = this.dataInput.readUnsignedShort();
        }
    }

    @Override
    public void visitAnnotation(Clazz clazz, Annotation annotation) {
        annotation.u2typeIndex = this.dataInput.readUnsignedShort();
        annotation.u2elementValuesCount = this.dataInput.readUnsignedShort();
        annotation.elementValues = new ElementValue[annotation.u2elementValuesCount];
        for (int i = 0; i < annotation.u2elementValuesCount; ++i) {
            int n = this.dataInput.readUnsignedShort();
            ElementValue elementValue = this.createElementValue();
            elementValue.u2elementNameIndex = n;
            elementValue.accept(clazz, annotation, this);
            annotation.elementValues[i] = elementValue;
        }
    }

    @Override
    public void visitTypeAnnotation(Clazz clazz, TypeAnnotation typeAnnotation) {
        TargetInfo targetInfo = this.createTargetInfo();
        targetInfo.accept(clazz, typeAnnotation, this);
        typeAnnotation.targetInfo = targetInfo;
        int n = this.dataInput.readUnsignedByte();
        typeAnnotation.typePath = new TypePathInfo[n];
        for (int i = 0; i < n; ++i) {
            TypePathInfo typePathInfo = new TypePathInfo();
            this.visitTypePathInfo(clazz, typeAnnotation, typePathInfo);
            typeAnnotation.typePath[i] = typePathInfo;
        }
        this.visitAnnotation(clazz, typeAnnotation);
    }

    @Override
    public void visitTypeParameterTargetInfo(Clazz clazz, TypeAnnotation typeAnnotation, TypeParameterTargetInfo typeParameterTargetInfo) {
        typeParameterTargetInfo.u1typeParameterIndex = this.dataInput.readUnsignedByte();
    }

    @Override
    public void visitSuperTypeTargetInfo(Clazz clazz, TypeAnnotation typeAnnotation, SuperTypeTargetInfo superTypeTargetInfo) {
        superTypeTargetInfo.u2superTypeIndex = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitTypeParameterBoundTargetInfo(Clazz clazz, TypeAnnotation typeAnnotation, TypeParameterBoundTargetInfo typeParameterBoundTargetInfo) {
        typeParameterBoundTargetInfo.u1typeParameterIndex = this.dataInput.readUnsignedByte();
        typeParameterBoundTargetInfo.u1boundIndex = this.dataInput.readUnsignedByte();
    }

    @Override
    public void visitEmptyTargetInfo(Clazz clazz, Member member, TypeAnnotation typeAnnotation, EmptyTargetInfo emptyTargetInfo) {
    }

    @Override
    public void visitFormalParameterTargetInfo(Clazz clazz, Method method, TypeAnnotation typeAnnotation, FormalParameterTargetInfo formalParameterTargetInfo) {
        formalParameterTargetInfo.u1formalParameterIndex = this.dataInput.readUnsignedByte();
    }

    @Override
    public void visitThrowsTargetInfo(Clazz clazz, Method method, TypeAnnotation typeAnnotation, ThrowsTargetInfo throwsTargetInfo) {
        throwsTargetInfo.u2throwsTypeIndex = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitLocalVariableTargetInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, TypeAnnotation typeAnnotation, LocalVariableTargetInfo localVariableTargetInfo) {
        localVariableTargetInfo.u2tableLength = this.dataInput.readUnsignedShort();
        localVariableTargetInfo.table = new LocalVariableTargetElement[localVariableTargetInfo.u2tableLength];
        for (int i = 0; i < localVariableTargetInfo.u2tableLength; ++i) {
            LocalVariableTargetElement localVariableTargetElement = new LocalVariableTargetElement();
            this.visitLocalVariableTargetElement(clazz, method, codeAttribute, typeAnnotation, localVariableTargetInfo, localVariableTargetElement);
            localVariableTargetInfo.table[i] = localVariableTargetElement;
        }
    }

    @Override
    public void visitCatchTargetInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, TypeAnnotation typeAnnotation, CatchTargetInfo catchTargetInfo) {
        catchTargetInfo.u2exceptionTableIndex = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitOffsetTargetInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, TypeAnnotation typeAnnotation, OffsetTargetInfo offsetTargetInfo) {
        offsetTargetInfo.u2offset = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitTypeArgumentTargetInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, TypeAnnotation typeAnnotation, TypeArgumentTargetInfo typeArgumentTargetInfo) {
        typeArgumentTargetInfo.u2offset = this.dataInput.readUnsignedShort();
        typeArgumentTargetInfo.u1typeArgumentIndex = this.dataInput.readUnsignedByte();
    }

    @Override
    public void visitTypePathInfo(Clazz clazz, TypeAnnotation typeAnnotation, TypePathInfo typePathInfo) {
        typePathInfo.u1typePathKind = this.dataInput.readUnsignedByte();
        typePathInfo.u1typeArgumentIndex = this.dataInput.readUnsignedByte();
    }

    @Override
    public void visitLocalVariableTargetElement(Clazz clazz, Method method, CodeAttribute codeAttribute, TypeAnnotation typeAnnotation, LocalVariableTargetInfo localVariableTargetInfo, LocalVariableTargetElement localVariableTargetElement) {
        localVariableTargetElement.u2startPC = this.dataInput.readShort();
        localVariableTargetElement.u2length = this.dataInput.readShort();
        localVariableTargetElement.u2index = this.dataInput.readShort();
    }

    @Override
    public void visitConstantElementValue(Clazz clazz, Annotation annotation, ConstantElementValue constantElementValue) {
        constantElementValue.u2constantValueIndex = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitEnumConstantElementValue(Clazz clazz, Annotation annotation, EnumConstantElementValue enumConstantElementValue) {
        enumConstantElementValue.u2typeNameIndex = this.dataInput.readUnsignedShort();
        enumConstantElementValue.u2constantNameIndex = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitClassElementValue(Clazz clazz, Annotation annotation, ClassElementValue classElementValue) {
        classElementValue.u2classInfoIndex = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitAnnotationElementValue(Clazz clazz, Annotation annotation, AnnotationElementValue annotationElementValue) {
        Annotation annotation2 = new Annotation();
        this.visitAnnotation(clazz, annotation2);
        annotationElementValue.annotationValue = annotation2;
    }

    @Override
    public void visitArrayElementValue(Clazz clazz, Annotation annotation, ArrayElementValue arrayElementValue) {
        arrayElementValue.u2elementValuesCount = this.dataInput.readUnsignedShort();
        arrayElementValue.elementValues = new ElementValue[arrayElementValue.u2elementValuesCount];
        for (int i = 0; i < arrayElementValue.u2elementValuesCount; ++i) {
            ElementValue elementValue = this.createElementValue();
            elementValue.accept(clazz, annotation, this);
            arrayElementValue.elementValues[i] = elementValue;
        }
    }

    private Constant createConstant() {
        int n = this.dataInput.readUnsignedByte();
        switch (n) {
            case 3: {
                return new IntegerConstant();
            }
            case 4: {
                return new FloatConstant();
            }
            case 5: {
                return new LongConstant();
            }
            case 6: {
                return new DoubleConstant();
            }
            case 21: {
                return new PrimitiveArrayConstant();
            }
            case 8: {
                return new StringConstant();
            }
            case 1: {
                return new Utf8Constant();
            }
            case 18: {
                return new InvokeDynamicConstant();
            }
            case 15: {
                return new MethodHandleConstant();
            }
            case 9: {
                return new FieldrefConstant();
            }
            case 10: {
                return new MethodrefConstant();
            }
            case 11: {
                return new InterfaceMethodrefConstant();
            }
            case 7: {
                return new ClassConstant();
            }
            case 16: {
                return new MethodTypeConstant();
            }
            case 12: {
                return new NameAndTypeConstant();
            }
            case 19: {
                return new ModuleConstant();
            }
            case 20: {
                return new PackageConstant();
            }
        }
        throw new RuntimeException("Unknown constant type [" + n + "] in constant pool");
    }

    private Attribute createAttribute(Clazz clazz) {
        int n = this.dataInput.readUnsignedShort();
        int n2 = this.dataInput.readInt();
        String string = clazz.getString(n);
        BootstrapMethodsAttribute bootstrapMethodsAttribute = string.equals("BootstrapMethods") ? new BootstrapMethodsAttribute() : (string.equals("SourceFile") ? new SourceFileAttribute() : (string.equals("SourceDir") ? new SourceDirAttribute() : (string.equals("InnerClasses") ? new InnerClassesAttribute() : (string.equals("EnclosingMethod") ? new EnclosingMethodAttribute() : (string.equals("Deprecated") ? new DeprecatedAttribute() : (string.equals("Synthetic") ? new SyntheticAttribute() : (string.equals("Signature") ? new SignatureAttribute() : (string.equals("ConstantValue") ? new ConstantValueAttribute() : (string.equals("MethodParameters") ? new MethodParametersAttribute() : (string.equals("Exceptions") ? new ExceptionsAttribute() : (string.equals("Code") ? new CodeAttribute() : (string.equals("StackMap") ? new StackMapAttribute() : (string.equals("StackMapTable") ? new StackMapTableAttribute() : (string.equals("LineNumberTable") ? new LineNumberTableAttribute() : (string.equals("LocalVariableTable") ? new LocalVariableTableAttribute() : (string.equals("LocalVariableTypeTable") ? new LocalVariableTypeTableAttribute() : (string.equals("RuntimeVisibleAnnotations") ? new RuntimeVisibleAnnotationsAttribute() : (string.equals("RuntimeInvisibleAnnotations") ? new RuntimeInvisibleAnnotationsAttribute() : (string.equals("RuntimeVisibleParameterAnnotations") ? new RuntimeVisibleParameterAnnotationsAttribute() : (string.equals("RuntimeInvisibleParameterAnnotations") ? new RuntimeInvisibleParameterAnnotationsAttribute() : (string.equals("RuntimeVisibleTypeAnnotations") ? new RuntimeVisibleTypeAnnotationsAttribute() : (string.equals("RuntimeInvisibleTypeAnnotations") ? new RuntimeInvisibleTypeAnnotationsAttribute() : (string.equals("AnnotationDefault") ? new AnnotationDefaultAttribute() : (string.equals("Module") ? new ModuleAttribute() : (string.equals("ModuleMainClass") ? new ModuleMainClassAttribute() : (string.equals("ModulePackages") ? new ModulePackagesAttribute() : new UnknownAttribute(n, n2)))))))))))))))))))))))))));
        bootstrapMethodsAttribute.u2attributeNameIndex = n;
        return bootstrapMethodsAttribute;
    }

    private StackMapFrame createStackMapFrame() {
        int n = this.dataInput.readUnsignedByte();
        return n < 64 ? new SameZeroFrame(n) : (n < 247 ? new SameOneFrame(n) : (n < 248 ? new SameOneFrame(n) : (n < 251 ? new LessZeroFrame(n) : (n < 252 ? new SameZeroFrame(n) : (n < 255 ? new MoreZeroFrame(n) : new FullFrame())))));
    }

    private VerificationType createVerificationType() {
        int n = this.dataInput.readUnsignedByte();
        switch (n) {
            case 1: {
                return new IntegerType();
            }
            case 2: {
                return new FloatType();
            }
            case 4: {
                return new LongType();
            }
            case 3: {
                return new DoubleType();
            }
            case 0: {
                return new TopType();
            }
            case 7: {
                return new ObjectType();
            }
            case 5: {
                return new NullType();
            }
            case 8: {
                return new UninitializedType();
            }
            case 6: {
                return new UninitializedThisType();
            }
        }
        throw new RuntimeException("Unknown verification type [" + n + "] in stack map frame");
    }

    private TargetInfo createTargetInfo() {
        byte by = this.dataInput.readByte();
        switch (by) {
            case 0: 
            case 1: {
                return new TypeParameterTargetInfo(by);
            }
            case 16: {
                return new SuperTypeTargetInfo(by);
            }
            case 17: 
            case 18: {
                return new TypeParameterBoundTargetInfo(by);
            }
            case 19: 
            case 20: 
            case 21: {
                return new EmptyTargetInfo(by);
            }
            case 22: {
                return new FormalParameterTargetInfo(by);
            }
            case 23: {
                return new ThrowsTargetInfo(by);
            }
            case 64: 
            case 65: {
                return new LocalVariableTargetInfo(by);
            }
            case 66: {
                return new CatchTargetInfo(by);
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                return new OffsetTargetInfo(by);
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                return new TypeArgumentTargetInfo(by);
            }
        }
        throw new RuntimeException("Unknown annotation target type [" + by + "]");
    }

    private ElementValue createElementValue() {
        int n = this.dataInput.readUnsignedByte();
        switch (n) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                return new ConstantElementValue((char)n);
            }
            case 101: {
                return new EnumConstantElementValue();
            }
            case 99: {
                return new ClassElementValue();
            }
            case 64: {
                return new AnnotationElementValue();
            }
            case 91: {
                return new ArrayElementValue();
            }
        }
        throw new IllegalArgumentException("Unknown element value tag [" + n + "]");
    }
}

