/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.goby.util.dynoptions;

import edu.cornell.med.icb.goby.util.dynoptions.DynamicOptionRegistry;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;

public class DynamicOptionClient
implements Comparable {
    String[] supportedKeys;
    private String[] helpMessages;
    String[] defaultValues;
    String[] values;
    Class enclosingClass;
    private static final Logger LOG = Logger.getLogger(DynamicOptionClient.class);

    public DynamicOptionClient(Class enclosingClass, String[] otherDefinitions, String ... optionDefinition) {
        this(enclosingClass, (String[])ArrayUtils.addAll(otherDefinitions, optionDefinition));
    }

    public DynamicOptionClient(Class enclosingClass, String ... optionDefinition) {
        this.enclosingClass = enclosingClass;
        this.supportedKeys = new String[optionDefinition.length];
        this.helpMessages = new String[optionDefinition.length];
        this.defaultValues = new String[optionDefinition.length];
        this.values = new String[optionDefinition.length];
        int index = 0;
        for (String def : optionDefinition) {
            String[] tuple = def.split("[:]");
            if (tuple.length < 2) {
                throw new RuntimeException("option definition must have three elements separated by colon: key:help:default");
            }
            this.supportedKeys[index] = tuple[0];
            this.helpMessages[index] = tuple[1];
            String string = this.defaultValues[index] = tuple.length >= 3 ? tuple[2] : null;
            if (this.defaultValues[index] != null && this.defaultValues[index].length() == 0) {
                this.defaultValues[index] = null;
            }
            ++index;
        }
        DynamicOptionRegistry.register(this);
    }

    public boolean acceptsOption(String option) {
        LOG.trace((Object)(this.getClass().getName() + " trying to accept option " + option));
        String[] tokens = option.split("[:=]");
        if (tokens.length != 3) {
            return false;
        }
        String shortClassname = this.enclosingClass.getSimpleName();
        if (!tokens[0].equals(shortClassname)) {
            return false;
        }
        int keyIndex = 0;
        for (String supportedId : this.supportedKeys) {
            if (tokens[1].equals(supportedId)) {
                this.values[keyIndex] = tokens[2];
                return true;
            }
            ++keyIndex;
        }
        return false;
    }

    public String getString(String key) {
        for (int keyIndex = 0; keyIndex < this.supportedKeys.length; ++keyIndex) {
            if (!key.equals(this.supportedKeys[keyIndex])) continue;
            String value = this.values[keyIndex];
            return value != null ? value : this.defaultValues[keyIndex];
        }
        return null;
    }

    public Integer getInteger(String key) {
        String val = this.getString(key);
        if (val != null) {
            return Integer.parseInt(val);
        }
        return null;
    }

    public Byte getByte(String key) {
        String val = this.getString(key);
        if (val != null) {
            return Byte.parseByte(val);
        }
        return null;
    }

    public Float getFloat(String key) {
        String val = this.getString(key);
        if (val != null) {
            return Float.valueOf(Float.parseFloat(val));
        }
        return null;
    }

    public Double getDouble(String key) {
        String val = this.getString(key);
        if (val != null) {
            return Double.parseDouble(val);
        }
        return null;
    }

    public Boolean getBoolean(String key) {
        String val = this.getString(key);
        if (val != null) {
            return Boolean.parseBoolean(val);
        }
        return null;
    }

    public void setValue(String key, Object value) {
        if (value == null) {
            return;
        }
        for (int keyIndex = 0; keyIndex < this.supportedKeys.length; ++keyIndex) {
            if (!key.equals(this.supportedKeys[keyIndex])) continue;
            this.values[keyIndex] = value.toString();
        }
    }

    public int compareTo(Object o) {
        if (!(o instanceof DynamicOptionClient)) {
            return 1;
        }
        DynamicOptionClient otherClient = (DynamicOptionClient)o;
        return this.enclosingClass.getCanonicalName().compareTo(((DynamicOptionClient)o).enclosingClass.getCanonicalName());
    }

    public String[] getHelpMessages() {
        return this.helpMessages;
    }

    public String[] getKeys() {
        return this.supportedKeys;
    }

    public String[] getDefaultValues() {
        return this.defaultValues;
    }

    public String getClassname() {
        return this.enclosingClass.getSimpleName();
    }
}

