/* $Id: path-solve.h 224749 2021-12-05 01:00:56Z twu $ */
#ifndef PATH_INCLUDED
#define PATH_INCLUDED

#include "types.h"
#include "genomicpos.h"
#include "univcoord.h"
#include "bool.h"
#include "list.h"
#include "univdiag.h"
#include "chrnum.h"
#include "compress.h"
#include "genome.h"
#include "regiondb.h"
#include "stage3hr.h"
#include "indel.h"
#include "splice.h"
#include "intlistpool.h"

#ifdef LARGE_GENOMES
#include "uint8listpool.h"
#else
#include "uintlistpool.h"
#endif

#include "listpool.h"
#include "hitlistpool.h"
#include "univdiagpool.h"
#include "mergeinfo.h"


/* Used by extension-search and segment-search */
extern void
Path_solve_from_diagonals (bool *foundp, int *found_score_overall, int *found_score_within_trims,
			   List_T *sense_hits, List_T *antisense_hits,
			   Univcoord_T middle_diagonal_univdiagonal, int middle_diagonal_qstart, int middle_diagonal_qend,
			   List_T qend_diagonals, List_T qstart_diagonals, char *queryptr, int querylength,
			   int *mismatch_positions_alloc, Indelinfo_T indelinfo,
			   Spliceinfo_T spliceinfo, Mergeinfo_T mergeinfo,
			   Univcoord_T **stream_alloc, int *streamsize_alloc, Compress_T query_compress, 
			   Chrnum_T chrnum, Univcoord_T chroffset, Univcoord_T chrhigh, Chrpos_T chrlength,
			   bool plusp, int genestrand,
			   int max_insertionlen, int max_deletionlen, Chrpos_T overall_end_distance_genome,
			   bool paired_end_p, bool first_read_p,
			   Intlistpool_T intlistpool, Univcoordlistpool_T univcoordlistpool,
			   Listpool_T listpool, Univdiagpool_T univdiagpool, Hitlistpool_T hitlistpool,
			   Method_T method, int level);

extern void
Path_solve_setup (bool *circularp_in,
		  Genome_T genomebits_in, Genome_T genomebits_alt_in,
		  Regiondb_T regiondb_in, Regiondb_T regiondb2_in, int min_intronlength_in,
		  bool novelsplicingp_in, bool knownsplicingp_in,
		  Univcoord_T *splicesites_in, Splicetype_T *splicetypes_in,
		  Chrpos_T *splicedists_in, int nsplicesites_in, 
		  int index1part_in, int index1interval_in, int local1part_in, int region1part_in);

#endif

