#!/bin/sh

#	getblock.sh
#   07/19/95 Added kidofwais.pl to be the indexed searcher, rather than 
#            the gopher link  -- BJA
#   01/10/96 Modified the Logo and LAMA links to not go past 80 cols -- BJA
#    3/ 6/97 Look in prints.dat for PR blocks
#    4/ 2/97 Revised directories
#    6/21/97 Remove $HOME variable, still uses blocks, assumes execution
#		from the bin/ directory.
#    6/10/00 IPB stuff


GETBLOCK="./blimps-bin/getblock"
IPBDIR="../data-blocks"
PRDIR="../data-prints"

BLOCKS=$IPBDIR/blocks.dat
PRINTS=$PRDIR/prints.dat

TMPFILE=../tmp/$$.tmp

echo Content-type: text/html
echo 

if [ -x $GETBLOCK ]; then
        if [ $# = 0 ]; then
                cat << EOM
<TITLE> Get Blocks - Block retrieval by number</TITLE>
<H1><IMG SRC="/blocks/icons/small-blocks.xbm"> Get Blocks by Number</H1>

<H2>Get Entries from the 
<A HREF="/blocks/help/blocks_release.html">Blocks Database</A><BR>
 or from the Prints Database in Blocks Format</H2>


<ISINDEX prompt="Enter a Block number (e.g. IPB001525 or PR00105) and press RETURN:  ">

<P>

<UL>
<LI>
<A HREF="kidofwais.pl">Keyword search of the Blocks Database </A>
</UL>
<P>

<HR>
<H2>Get Entries Directly from Other Databases</H2>

<UL>
<LI>
<A HREF="http://www.ebi.ac.uk/interpro/">InterPro Database of Protein Families and Domains</A>
<LI>
<A HREF="http://www.expasy.ch/prosite/">PROSITE Database of Protein Families and Domains</A>
<LI>
<A HREF="http://www.bioinf.man.ac.uk/dbbrowser/PRINTS/PRINTS.html">
   Prints Protein Motif Fingerprint Database</A>
<LI>
<A HREF="http://pfam.wustl.edu">Pfam Database of Protein Domains</A>
<LI>
<A HREF="http://www.toulouse.inra.fr/prodom/doc/prodom.html">ProDom Protein Domain Database</A>

</UL>


<HR>
<P>
<A HREF="/blocks">[Blocks Home]</A> 
<A HREF="/blocks/blocks_search.html">[Block Searcher]</A>
<A HREF="/blocks-bin/LAMA_search.sh">[LAMA Searcher]</A>
<A HREF="/blocks/make_blocks.html">[Block Maker]</A>
 
<HR>
<A href="contact.html">Contact us</A> <P>
Page last modified <MODIFICATION_DATE>Mar 2003</MODIFICATION_DATE>



EOM
        else

                echo \<PRE\>
		case "$*" in
 
		PR*)
		   DB=$PRINTS
		   ;;
		pr*)
		   DB=$PRINTS
		   ;;
		Pr*)
		   DB=$PRINTS
		   ;;
		pR*)
		   DB=$PRINTS
		   ;;
 
		*)
	           DB=$BLOCKS
		   ;;
		esac

#echo $GETBLOCK "$*" $DB 
                $GETBLOCK "$*" $DB | ./htmlize-getblock.pl 
		cat << END
</PRE>
<A HREF="/blocks">[Blocks home]</A>

END
        fi
else
        echo Cannot find getblock on this system.
fi
exit
