/* KeyValueMap.c generated by valac 0.40.4, the Vala compiler
 * generated from KeyValueMap.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_KEY_VALUE_MAP (key_value_map_get_type ())
#define KEY_VALUE_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KEY_VALUE_MAP, KeyValueMap))
#define KEY_VALUE_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KEY_VALUE_MAP, KeyValueMapClass))
#define IS_KEY_VALUE_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KEY_VALUE_MAP))
#define IS_KEY_VALUE_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KEY_VALUE_MAP))
#define KEY_VALUE_MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KEY_VALUE_MAP, KeyValueMapClass))

typedef struct _KeyValueMap KeyValueMap;
typedef struct _KeyValueMapClass KeyValueMapClass;
typedef struct _KeyValueMapPrivate KeyValueMapPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _key_value_map_unref0(var) ((var == NULL) ? NULL : (var = (key_value_map_unref (var), NULL)))
typedef struct _ParamSpecKeyValueMap ParamSpecKeyValueMap;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _KeyValueMap {
	GTypeInstance parent_instance;
	volatile int ref_count;
	KeyValueMapPrivate * priv;
};

struct _KeyValueMapClass {
	GTypeClass parent_class;
	void (*finalize) (KeyValueMap *self);
};

struct _KeyValueMapPrivate {
	gchar* group;
	GeeHashMap* map;
};

struct _ParamSpecKeyValueMap {
	GParamSpec parent_instance;
};


static gpointer key_value_map_parent_class = NULL;

gpointer key_value_map_ref (gpointer instance);
void key_value_map_unref (gpointer instance);
GParamSpec* param_spec_key_value_map (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
void value_set_key_value_map (GValue* value,
                              gpointer v_object);
void value_take_key_value_map (GValue* value,
                               gpointer v_object);
gpointer value_get_key_value_map (const GValue* value);
GType key_value_map_get_type (void) G_GNUC_CONST;
#define KEY_VALUE_MAP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_KEY_VALUE_MAP, KeyValueMapPrivate))
KeyValueMap* key_value_map_new (const gchar* group);
KeyValueMap* key_value_map_construct (GType object_type,
                                      const gchar* group);
KeyValueMap* key_value_map_copy (KeyValueMap* self);
gchar* key_value_map_get_group (KeyValueMap* self);
GeeSet* key_value_map_get_keys (KeyValueMap* self);
gboolean key_value_map_has_key (KeyValueMap* self,
                                const gchar* key);
void key_value_map_set_string (KeyValueMap* self,
                               const gchar* key,
                               const gchar* value);
void key_value_map_set_int (KeyValueMap* self,
                            const gchar* key,
                            gint value);
void key_value_map_set_double (KeyValueMap* self,
                               const gchar* key,
                               gdouble value);
void key_value_map_set_float (KeyValueMap* self,
                              const gchar* key,
                              gfloat value);
void key_value_map_set_bool (KeyValueMap* self,
                             const gchar* key,
                             gboolean value);
gchar* key_value_map_get_string (KeyValueMap* self,
                                 const gchar* key,
                                 const gchar* def);
gint key_value_map_get_int (KeyValueMap* self,
                            const gchar* key,
                            gint def);
gdouble key_value_map_get_double (KeyValueMap* self,
                                  const gchar* key,
                                  gdouble def);
gfloat key_value_map_get_float (KeyValueMap* self,
                                const gchar* key,
                                gfloat def);
gboolean key_value_map_get_bool (KeyValueMap* self,
                                 const gchar* key,
                                 gboolean def);
void key_value_map_get_point (KeyValueMap* self,
                              const gchar* key,
                              GdkPoint* def,
                              GdkPoint* result);
void key_value_map_set_point (KeyValueMap* self,
                              const gchar* key,
                              GdkPoint* point);
static void key_value_map_finalize (KeyValueMap * obj);


KeyValueMap*
key_value_map_construct (GType object_type,
                         const gchar* group)
{
	KeyValueMap* self = NULL;
	gchar* _tmp0_;
#line 11 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	self = (KeyValueMap*) g_type_create_instance (object_type);
#line 12 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_tmp0_ = g_strdup (group);
#line 12 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_g_free0 (self->priv->group);
#line 12 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	self->priv->group = _tmp0_;
#line 11 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	return self;
#line 144 "KeyValueMap.c"
}


KeyValueMap*
key_value_map_new (const gchar* group)
{
#line 11 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	return key_value_map_construct (TYPE_KEY_VALUE_MAP, group);
#line 153 "KeyValueMap.c"
}


KeyValueMap*
key_value_map_copy (KeyValueMap* self)
{
	KeyValueMap* result = NULL;
	KeyValueMap* clone = NULL;
	const gchar* _tmp0_;
	KeyValueMap* _tmp1_;
#line 16 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_tmp0_ = self->priv->group;
#line 16 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_tmp1_ = key_value_map_new (_tmp0_);
#line 16 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	clone = _tmp1_;
#line 170 "KeyValueMap.c"
	{
		GeeIterator* _key_it = NULL;
		GeeHashMap* _tmp2_;
		GeeSet* _tmp3_;
		GeeSet* _tmp4_;
		GeeSet* _tmp5_;
		GeeIterator* _tmp6_;
		GeeIterator* _tmp7_;
#line 17 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		_tmp2_ = self->priv->map;
#line 17 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		_tmp3_ = gee_abstract_map_get_keys (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 17 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		_tmp4_ = _tmp3_;
#line 17 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		_tmp5_ = _tmp4_;
#line 17 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		_tmp6_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ITERABLE, GeeIterable));
#line 17 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		_tmp7_ = _tmp6_;
#line 17 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		_g_object_unref0 (_tmp5_);
#line 17 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		_key_it = _tmp7_;
#line 17 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		while (TRUE) {
#line 197 "KeyValueMap.c"
			GeeIterator* _tmp8_;
			gchar* key = NULL;
			GeeIterator* _tmp9_;
			gpointer _tmp10_;
			KeyValueMap* _tmp11_;
			GeeHashMap* _tmp12_;
			const gchar* _tmp13_;
			GeeHashMap* _tmp14_;
			const gchar* _tmp15_;
			gpointer _tmp16_;
			gchar* _tmp17_;
#line 17 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
			_tmp8_ = _key_it;
#line 17 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
			if (!gee_iterator_next (_tmp8_)) {
#line 17 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
				break;
#line 215 "KeyValueMap.c"
			}
#line 17 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
			_tmp9_ = _key_it;
#line 17 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
			_tmp10_ = gee_iterator_get (_tmp9_);
#line 17 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
			key = (gchar*) _tmp10_;
#line 18 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
			_tmp11_ = clone;
#line 18 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
			_tmp12_ = _tmp11_->priv->map;
#line 18 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
			_tmp13_ = key;
#line 18 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
			_tmp14_ = self->priv->map;
#line 18 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
			_tmp15_ = key;
#line 18 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
			_tmp16_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp15_);
#line 18 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
			_tmp17_ = (gchar*) _tmp16_;
#line 18 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
			gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp13_, _tmp17_);
#line 18 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
			_g_free0 (_tmp17_);
#line 17 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
			_g_free0 (key);
#line 243 "KeyValueMap.c"
		}
#line 17 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		_g_object_unref0 (_key_it);
#line 247 "KeyValueMap.c"
	}
#line 20 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	result = clone;
#line 20 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	return result;
#line 253 "KeyValueMap.c"
}


gchar*
key_value_map_get_group (KeyValueMap* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 24 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_tmp0_ = self->priv->group;
#line 24 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 24 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	result = _tmp1_;
#line 24 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	return result;
#line 271 "KeyValueMap.c"
}


GeeSet*
key_value_map_get_keys (KeyValueMap* self)
{
	GeeSet* result = NULL;
	GeeHashMap* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
#line 28 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_tmp0_ = self->priv->map;
#line 28 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_tmp1_ = gee_abstract_map_get_keys (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 28 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_tmp2_ = _tmp1_;
#line 28 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	result = _tmp2_;
#line 28 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	return result;
#line 292 "KeyValueMap.c"
}


gboolean
key_value_map_has_key (KeyValueMap* self,
                       const gchar* key)
{
	gboolean result = FALSE;
	GeeHashMap* _tmp0_;
#line 32 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_tmp0_ = self->priv->map;
#line 32 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	result = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), key);
#line 32 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	return result;
#line 308 "KeyValueMap.c"
}


void
key_value_map_set_string (KeyValueMap* self,
                          const gchar* key,
                          const gchar* value)
{
	GeeHashMap* _tmp0_;
#line 36 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_vala_assert (key != NULL, "key != null");
#line 38 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_tmp0_ = self->priv->map;
#line 38 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), key, value);
#line 324 "KeyValueMap.c"
}


void
key_value_map_set_int (KeyValueMap* self,
                       const gchar* key,
                       gint value)
{
	GeeHashMap* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
#line 42 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_vala_assert (key != NULL, "key != null");
#line 44 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_tmp0_ = self->priv->map;
#line 44 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_tmp1_ = g_strdup_printf ("%i", value);
#line 44 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_tmp2_ = _tmp1_;
#line 44 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), key, _tmp2_);
#line 44 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_g_free0 (_tmp2_);
#line 348 "KeyValueMap.c"
}


static gchar*
double_to_string (gdouble self)
{
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
#line 883 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
#line 883 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 883 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
#line 883 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp2_ = g_ascii_dtostr (_tmp1_, G_ASCII_DTOSTR_BUF_SIZE, self);
#line 883 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp3_ = g_strdup (_tmp2_);
#line 883 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp4_ = _tmp3_;
#line 883 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp1_ = (g_free (_tmp1_), NULL);
#line 883 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _tmp4_;
#line 883 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 380 "KeyValueMap.c"
}


void
key_value_map_set_double (KeyValueMap* self,
                          const gchar* key,
                          gdouble value)
{
	GeeHashMap* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
#line 48 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_vala_assert (key != NULL, "key != null");
#line 50 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_tmp0_ = self->priv->map;
#line 50 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_tmp1_ = double_to_string (value);
#line 50 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_tmp2_ = _tmp1_;
#line 50 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), key, _tmp2_);
#line 50 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_g_free0 (_tmp2_);
#line 404 "KeyValueMap.c"
}


void
key_value_map_set_float (KeyValueMap* self,
                         const gchar* key,
                         gfloat value)
{
	GeeHashMap* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
#line 54 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_vala_assert (key != NULL, "key != null");
#line 56 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_tmp0_ = self->priv->map;
#line 56 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_tmp1_ = g_strdup_printf ("%g", value);
#line 56 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_tmp2_ = _tmp1_;
#line 56 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), key, _tmp2_);
#line 56 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_g_free0 (_tmp2_);
#line 428 "KeyValueMap.c"
}


static gchar*
bool_to_string (gboolean self)
{
	gchar* result = NULL;
#line 37 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (self) {
#line 438 "KeyValueMap.c"
		gchar* _tmp0_;
#line 38 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp0_ = g_strdup ("true");
#line 38 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = _tmp0_;
#line 38 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 446 "KeyValueMap.c"
	} else {
		gchar* _tmp1_;
#line 40 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp1_ = g_strdup ("false");
#line 40 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = _tmp1_;
#line 40 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 455 "KeyValueMap.c"
	}
}


void
key_value_map_set_bool (KeyValueMap* self,
                        const gchar* key,
                        gboolean value)
{
	GeeHashMap* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
#line 60 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_vala_assert (key != NULL, "key != null");
#line 62 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_tmp0_ = self->priv->map;
#line 62 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_tmp1_ = bool_to_string (value);
#line 62 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_tmp2_ = _tmp1_;
#line 62 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), key, _tmp2_);
#line 62 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_g_free0 (_tmp2_);
#line 480 "KeyValueMap.c"
}


gchar*
key_value_map_get_string (KeyValueMap* self,
                          const gchar* key,
                          const gchar* def)
{
	gchar* result = NULL;
	gchar* value = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_;
	gchar* _tmp5_;
#line 66 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_tmp0_ = self->priv->map;
#line 66 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), key);
#line 66 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	value = (gchar*) _tmp1_;
#line 68 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_tmp3_ = value;
#line 68 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	if (_tmp3_ != NULL) {
#line 506 "KeyValueMap.c"
		const gchar* _tmp4_;
#line 68 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		_tmp4_ = value;
#line 68 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		_tmp2_ = _tmp4_;
#line 512 "KeyValueMap.c"
	} else {
#line 68 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		_tmp2_ = def;
#line 516 "KeyValueMap.c"
	}
#line 68 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_tmp5_ = g_strdup (_tmp2_);
#line 68 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	result = _tmp5_;
#line 68 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_g_free0 (value);
#line 68 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	return result;
#line 526 "KeyValueMap.c"
}


gint
key_value_map_get_int (KeyValueMap* self,
                       const gchar* key,
                       gint def)
{
	gint result = 0;
	gchar* value = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	gint _tmp2_ = 0;
	const gchar* _tmp3_;
#line 72 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_tmp0_ = self->priv->map;
#line 72 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), key);
#line 72 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	value = (gchar*) _tmp1_;
#line 74 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_tmp3_ = value;
#line 74 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	if (_tmp3_ != NULL) {
#line 551 "KeyValueMap.c"
		const gchar* _tmp4_;
#line 74 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		_tmp4_ = value;
#line 74 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		_tmp2_ = atoi (_tmp4_);
#line 557 "KeyValueMap.c"
	} else {
#line 74 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		_tmp2_ = def;
#line 561 "KeyValueMap.c"
	}
#line 74 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	result = _tmp2_;
#line 74 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_g_free0 (value);
#line 74 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	return result;
#line 569 "KeyValueMap.c"
}


static gdouble
double_parse (const gchar* str)
{
	gdouble result = 0.0;
	gdouble _tmp0_;
#line 890 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = g_ascii_strtod (str, NULL);
#line 890 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _tmp0_;
#line 890 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 584 "KeyValueMap.c"
}


gdouble
key_value_map_get_double (KeyValueMap* self,
                          const gchar* key,
                          gdouble def)
{
	gdouble result = 0.0;
	gchar* value = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	gdouble _tmp2_ = 0.0;
	const gchar* _tmp3_;
#line 78 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_tmp0_ = self->priv->map;
#line 78 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), key);
#line 78 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	value = (gchar*) _tmp1_;
#line 80 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_tmp3_ = value;
#line 80 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	if (_tmp3_ != NULL) {
#line 609 "KeyValueMap.c"
		const gchar* _tmp4_;
#line 80 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		_tmp4_ = value;
#line 80 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		_tmp2_ = double_parse (_tmp4_);
#line 615 "KeyValueMap.c"
	} else {
#line 80 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		_tmp2_ = def;
#line 619 "KeyValueMap.c"
	}
#line 80 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	result = _tmp2_;
#line 80 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_g_free0 (value);
#line 80 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	return result;
#line 627 "KeyValueMap.c"
}


gfloat
key_value_map_get_float (KeyValueMap* self,
                         const gchar* key,
                         gfloat def)
{
	gfloat result = 0.0F;
	gchar* value = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	gfloat _tmp2_ = 0.0F;
	const gchar* _tmp3_;
#line 84 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_tmp0_ = self->priv->map;
#line 84 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), key);
#line 84 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	value = (gchar*) _tmp1_;
#line 86 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_tmp3_ = value;
#line 86 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	if (_tmp3_ != NULL) {
#line 652 "KeyValueMap.c"
		const gchar* _tmp4_;
#line 86 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		_tmp4_ = value;
#line 86 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		_tmp2_ = (gfloat) double_parse (_tmp4_);
#line 658 "KeyValueMap.c"
	} else {
#line 86 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		_tmp2_ = def;
#line 662 "KeyValueMap.c"
	}
#line 86 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	result = _tmp2_;
#line 86 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_g_free0 (value);
#line 86 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	return result;
#line 670 "KeyValueMap.c"
}


static gboolean
bool_parse (const gchar* str)
{
	gboolean result = FALSE;
#line 45 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (g_strcmp0 (str, "true") == 0) {
#line 46 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = TRUE;
#line 46 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 684 "KeyValueMap.c"
	} else {
#line 48 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = FALSE;
#line 48 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 690 "KeyValueMap.c"
	}
}


gboolean
key_value_map_get_bool (KeyValueMap* self,
                        const gchar* key,
                        gboolean def)
{
	gboolean result = FALSE;
	gchar* value = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
#line 90 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_tmp0_ = self->priv->map;
#line 90 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), key);
#line 90 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	value = (gchar*) _tmp1_;
#line 92 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_tmp3_ = value;
#line 92 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	if (_tmp3_ != NULL) {
#line 716 "KeyValueMap.c"
		const gchar* _tmp4_;
#line 92 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		_tmp4_ = value;
#line 92 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		_tmp2_ = bool_parse (_tmp4_);
#line 722 "KeyValueMap.c"
	} else {
#line 92 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		_tmp2_ = def;
#line 726 "KeyValueMap.c"
	}
#line 92 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	result = _tmp2_;
#line 92 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_g_free0 (value);
#line 92 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	return result;
#line 734 "KeyValueMap.c"
}


void
key_value_map_get_point (KeyValueMap* self,
                         const gchar* key,
                         GdkPoint* def,
                         GdkPoint* result)
{
	gchar* value = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	const gchar* _tmp2_;
#line 101 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_tmp0_ = self->priv->map;
#line 101 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), key);
#line 101 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	value = (gchar*) _tmp1_;
#line 103 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_tmp2_ = value;
#line 103 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	if (_tmp2_ == NULL) {
#line 758 "KeyValueMap.c"
		GdkPoint _tmp3_;
#line 104 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		_tmp3_ = *def;
#line 104 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		*result = _tmp3_;
#line 104 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		_g_free0 (value);
#line 104 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		return;
#line 768 "KeyValueMap.c"
	} else {
		GdkPoint _result_ = {0};
		GdkPoint _tmp4_ = {0};
		const gchar* _tmp5_;
#line 106 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		_tmp4_.x = 0;
#line 106 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		_result_ = _tmp4_;
#line 107 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		_tmp5_ = value;
#line 107 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		if (sscanf (_tmp5_, "(%d, %d)", &_result_.x, &_result_.y) == 2) {
#line 108 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
			*result = _result_;
#line 108 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
			_g_free0 (value);
#line 108 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
			return;
#line 787 "KeyValueMap.c"
		} else {
			GdkPoint _tmp6_;
#line 110 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
			_tmp6_ = *def;
#line 110 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
			*result = _tmp6_;
#line 110 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
			_g_free0 (value);
#line 110 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
			return;
#line 798 "KeyValueMap.c"
		}
	}
#line 100 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_g_free0 (value);
#line 803 "KeyValueMap.c"
}


void
key_value_map_set_point (KeyValueMap* self,
                         const gchar* key,
                         GdkPoint* point)
{
	GeeHashMap* _tmp0_;
	GdkPoint _tmp1_;
	gint _tmp2_;
	GdkPoint _tmp3_;
	gint _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
#line 115 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_tmp0_ = self->priv->map;
#line 115 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_tmp1_ = *point;
#line 115 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_tmp2_ = _tmp1_.x;
#line 115 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_tmp3_ = *point;
#line 115 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_tmp4_ = _tmp3_.y;
#line 115 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_tmp5_ = g_strdup_printf ("(%d, %d)", _tmp2_, _tmp4_);
#line 115 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_tmp6_ = _tmp5_;
#line 115 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), key, _tmp6_);
#line 115 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_g_free0 (_tmp6_);
#line 837 "KeyValueMap.c"
}


static void
value_key_value_map_init (GValue* value)
{
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	value->data[0].v_pointer = NULL;
#line 846 "KeyValueMap.c"
}


static void
value_key_value_map_free_value (GValue* value)
{
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	if (value->data[0].v_pointer) {
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		key_value_map_unref (value->data[0].v_pointer);
#line 857 "KeyValueMap.c"
	}
}


static void
value_key_value_map_copy_value (const GValue* src_value,
                                GValue* dest_value)
{
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	if (src_value->data[0].v_pointer) {
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		dest_value->data[0].v_pointer = key_value_map_ref (src_value->data[0].v_pointer);
#line 870 "KeyValueMap.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		dest_value->data[0].v_pointer = NULL;
#line 874 "KeyValueMap.c"
	}
}


static gpointer
value_key_value_map_peek_pointer (const GValue* value)
{
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	return value->data[0].v_pointer;
#line 884 "KeyValueMap.c"
}


static gchar*
value_key_value_map_collect_value (GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	if (collect_values[0].v_pointer) {
#line 896 "KeyValueMap.c"
		KeyValueMap * object;
		object = collect_values[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		if (object->parent_instance.g_class == NULL) {
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 903 "KeyValueMap.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 907 "KeyValueMap.c"
		}
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		value->data[0].v_pointer = key_value_map_ref (object);
#line 911 "KeyValueMap.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		value->data[0].v_pointer = NULL;
#line 915 "KeyValueMap.c"
	}
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	return NULL;
#line 919 "KeyValueMap.c"
}


static gchar*
value_key_value_map_lcopy_value (const GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	KeyValueMap ** object_p;
	object_p = collect_values[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	if (!object_p) {
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 935 "KeyValueMap.c"
	}
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	if (!value->data[0].v_pointer) {
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		*object_p = NULL;
#line 941 "KeyValueMap.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		*object_p = value->data[0].v_pointer;
#line 945 "KeyValueMap.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		*object_p = key_value_map_ref (value->data[0].v_pointer);
#line 949 "KeyValueMap.c"
	}
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	return NULL;
#line 953 "KeyValueMap.c"
}


GParamSpec*
param_spec_key_value_map (const gchar* name,
                          const gchar* nick,
                          const gchar* blurb,
                          GType object_type,
                          GParamFlags flags)
{
	ParamSpecKeyValueMap* spec;
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_KEY_VALUE_MAP), NULL);
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	return G_PARAM_SPEC (spec);
#line 973 "KeyValueMap.c"
}


gpointer
value_get_key_value_map (const GValue* value)
{
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_KEY_VALUE_MAP), NULL);
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	return value->data[0].v_pointer;
#line 984 "KeyValueMap.c"
}


void
value_set_key_value_map (GValue* value,
                         gpointer v_object)
{
	KeyValueMap * old;
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_KEY_VALUE_MAP));
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	old = value->data[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	if (v_object) {
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_KEY_VALUE_MAP));
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		value->data[0].v_pointer = v_object;
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		key_value_map_ref (value->data[0].v_pointer);
#line 1007 "KeyValueMap.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		value->data[0].v_pointer = NULL;
#line 1011 "KeyValueMap.c"
	}
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	if (old) {
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		key_value_map_unref (old);
#line 1017 "KeyValueMap.c"
	}
}


void
value_take_key_value_map (GValue* value,
                          gpointer v_object)
{
	KeyValueMap * old;
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_KEY_VALUE_MAP));
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	old = value->data[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	if (v_object) {
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_KEY_VALUE_MAP));
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		value->data[0].v_pointer = v_object;
#line 1039 "KeyValueMap.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		value->data[0].v_pointer = NULL;
#line 1043 "KeyValueMap.c"
	}
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	if (old) {
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		key_value_map_unref (old);
#line 1049 "KeyValueMap.c"
	}
}


static void
key_value_map_class_init (KeyValueMapClass * klass)
{
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	key_value_map_parent_class = g_type_class_peek_parent (klass);
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	((KeyValueMapClass *) klass)->finalize = key_value_map_finalize;
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	g_type_class_add_private (klass, sizeof (KeyValueMapPrivate));
#line 1063 "KeyValueMap.c"
}


static void
key_value_map_instance_init (KeyValueMap * self)
{
	GeeHashMap* _tmp0_;
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	self->priv = KEY_VALUE_MAP_GET_PRIVATE (self);
#line 9 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 9 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	self->priv->map = _tmp0_;
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	self->ref_count = 1;
#line 1079 "KeyValueMap.c"
}


static void
key_value_map_finalize (KeyValueMap * obj)
{
	KeyValueMap * self;
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_KEY_VALUE_MAP, KeyValueMap);
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	g_signal_handlers_destroy (self);
#line 8 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_g_free0 (self->priv->group);
#line 9 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	_g_object_unref0 (self->priv->map);
#line 1095 "KeyValueMap.c"
}


GType
key_value_map_get_type (void)
{
	static volatile gsize key_value_map_type_id__volatile = 0;
	if (g_once_init_enter (&key_value_map_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_key_value_map_init, value_key_value_map_free_value, value_key_value_map_copy_value, value_key_value_map_peek_pointer, "p", value_key_value_map_collect_value, "p", value_key_value_map_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (KeyValueMapClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) key_value_map_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KeyValueMap), 0, (GInstanceInitFunc) key_value_map_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType key_value_map_type_id;
		key_value_map_type_id = g_type_register_fundamental (g_type_fundamental_next (), "KeyValueMap", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&key_value_map_type_id__volatile, key_value_map_type_id);
	}
	return key_value_map_type_id__volatile;
}


gpointer
key_value_map_ref (gpointer instance)
{
	KeyValueMap * self;
	self = instance;
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	g_atomic_int_inc (&self->ref_count);
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	return instance;
#line 1124 "KeyValueMap.c"
}


void
key_value_map_unref (gpointer instance)
{
	KeyValueMap * self;
	self = instance;
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		KEY_VALUE_MAP_GET_CLASS (self)->finalize (self);
#line 7 "/home/jens/Source/shotwell/src/util/KeyValueMap.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1139 "KeyValueMap.c"
	}
}



