/* GRaw.c generated by valac 0.36.6, the Vala compiler
 * generated from GRaw.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <libraw/libraw.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>


#define GRAW_TYPE_COLORSPACE (graw_colorspace_get_type ())

#define GRAW_TYPE_FLIP (graw_flip_get_type ())

#define GRAW_TYPE_FUJI_ROTATE (graw_fuji_rotate_get_type ())

#define GRAW_TYPE_HIGHLIGHT_MODE (graw_highlight_mode_get_type ())

#define GRAW_TYPE_INTERPOLATION_QUALITY (graw_interpolation_quality_get_type ())

#define GRAW_TYPE_USE_CAMERA_MATRIX (graw_use_camera_matrix_get_type ())

#define GRAW_TYPE_PROCESSED_IMAGE (graw_processed_image_get_type ())
#define GRAW_PROCESSED_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRAW_TYPE_PROCESSED_IMAGE, GRawProcessedImage))
#define GRAW_PROCESSED_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GRAW_TYPE_PROCESSED_IMAGE, GRawProcessedImageClass))
#define GRAW_IS_PROCESSED_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRAW_TYPE_PROCESSED_IMAGE))
#define GRAW_IS_PROCESSED_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GRAW_TYPE_PROCESSED_IMAGE))
#define GRAW_PROCESSED_IMAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GRAW_TYPE_PROCESSED_IMAGE, GRawProcessedImageClass))

typedef struct _GRawProcessedImage GRawProcessedImage;
typedef struct _GRawProcessedImageClass GRawProcessedImageClass;
typedef struct _GRawProcessedImagePrivate GRawProcessedImagePrivate;
#define _free0(var) ((var == NULL) ? NULL : (var = (free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _graw_processed_image_unref0(var) ((var == NULL) ? NULL : (var = (graw_processed_image_unref (var), NULL)))
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GRawParamSpecProcessedImage GRawParamSpecProcessedImage;

#define GRAW_TYPE_PROCESSOR (graw_processor_get_type ())
#define GRAW_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRAW_TYPE_PROCESSOR, GRawProcessor))
#define GRAW_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GRAW_TYPE_PROCESSOR, GRawProcessorClass))
#define GRAW_IS_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRAW_TYPE_PROCESSOR))
#define GRAW_IS_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GRAW_TYPE_PROCESSOR))
#define GRAW_PROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GRAW_TYPE_PROCESSOR, GRawProcessorClass))

typedef struct _GRawProcessor GRawProcessor;
typedef struct _GRawProcessorClass GRawProcessorClass;
typedef struct _GRawProcessorPrivate GRawProcessorPrivate;
#define _libraw_close0(var) ((var == NULL) ? NULL : (var = (libraw_close (var), NULL)))
typedef struct _GRawParamSpecProcessor GRawParamSpecProcessor;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	GRAW_COLORSPACE_RAW = 0,
	GRAW_COLORSPACE_SRGB = 1,
	GRAW_COLORSPACE_ADOBE = 2,
	GRAW_COLORSPACE_WIDE = 3,
	GRAW_COLORSPACE_PROPHOTO = 4,
	GRAW_COLORSPACE_XYZ = 5
} GRawColorspace;

typedef enum  {
	GRAW_EXCEPTION_UNSPECIFIED,
	GRAW_EXCEPTION_UNSUPPORTED_FILE,
	GRAW_EXCEPTION_NONEXISTANT_IMAGE,
	GRAW_EXCEPTION_OUT_OF_ORDER_CALL,
	GRAW_EXCEPTION_NO_THUMBNAIL,
	GRAW_EXCEPTION_UNSUPPORTED_THUMBNAIL,
	GRAW_EXCEPTION_OUT_OF_MEMORY,
	GRAW_EXCEPTION_DATA_ERROR,
	GRAW_EXCEPTION_IO_ERROR,
	GRAW_EXCEPTION_CANCELLED_BY_CALLBACK,
	GRAW_EXCEPTION_BAD_CROP,
	GRAW_EXCEPTION_SYSTEM_ERROR
} GRawException;
#define GRAW_EXCEPTION graw_exception_quark ()
typedef enum  {
	GRAW_FLIP_FROM_SOURCE = -1,
	GRAW_FLIP_NONE = 0,
	GRAW_FLIP_UPSIDE_DOWN = 3,
	GRAW_FLIP_COUNTERCLOCKWISE = 5,
	GRAW_FLIP_CLOCKWISE = 6
} GRawFlip;

typedef enum  {
	GRAW_FUJI_ROTATE_USE = -1,
	GRAW_FUJI_ROTATE_DONT_USE = 0
} GRawFujiRotate;

typedef enum  {
	GRAW_HIGHLIGHT_MODE_CLIP = 0,
	GRAW_HIGHLIGHT_MODE_UNCLIP = 1,
	GRAW_HIGHLIGHT_MODE_BLEND = 2,
	GRAW_HIGHLIGHT_MODE_REBUILD = 3
} GRawHighlightMode;

typedef enum  {
	GRAW_INTERPOLATION_QUALITY_LINEAR = 0,
	GRAW_INTERPOLATION_QUALITY_VNG = 1,
	GRAW_INTERPOLATION_QUALITY_PPG = 2,
	GRAW_INTERPOLATION_QUALITY_AHD = 3
} GRawInterpolationQuality;

typedef enum  {
	GRAW_USE_CAMERA_MATRIX_IGNORE = 0,
	GRAW_USE_CAMERA_MATRIX_EMBEDDED_COLOR_PROFILE = 1,
	GRAW_USE_CAMERA_MATRIX_EMBEDDED_COLOR_DATA = 3
} GRawUseCameraMatrix;

struct _GRawProcessedImage {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GRawProcessedImagePrivate * priv;
};

struct _GRawProcessedImageClass {
	GTypeClass parent_class;
	void (*finalize) (GRawProcessedImage *self);
};

struct _GRawProcessedImagePrivate {
	libraw_processed_image_t* image;
	GdkPixbuf* pixbuf;
};

struct _GRawParamSpecProcessedImage {
	GParamSpec parent_instance;
};

struct _GRawProcessor {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GRawProcessorPrivate * priv;
};

struct _GRawProcessorClass {
	GTypeClass parent_class;
	void (*finalize) (GRawProcessor *self);
};

struct _GRawProcessorPrivate {
	libraw_data_t* proc;
};

struct _GRawParamSpecProcessor {
	GParamSpec parent_instance;
};


static gpointer graw_processed_image_parent_class = NULL;
static gpointer graw_processor_parent_class = NULL;

#define GRAW_HD_POWER 2.222
#define GRAW_HD_SLOPE 4.5
#define GRAW_SRGB_POWER 2.4
#define GRAW_SRGB_SLOPE 12.92
GType graw_colorspace_get_type (void) G_GNUC_CONST;
GQuark graw_exception_quark (void);
GType graw_flip_get_type (void) G_GNUC_CONST;
GType graw_fuji_rotate_get_type (void) G_GNUC_CONST;
GType graw_highlight_mode_get_type (void) G_GNUC_CONST;
GType graw_interpolation_quality_get_type (void) G_GNUC_CONST;
GType graw_use_camera_matrix_get_type (void) G_GNUC_CONST;
gpointer graw_processed_image_ref (gpointer instance);
void graw_processed_image_unref (gpointer instance);
GParamSpec* graw_param_spec_processed_image (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void graw_value_set_processed_image (GValue* value, gpointer v_object);
void graw_value_take_processed_image (GValue* value, gpointer v_object);
gpointer graw_value_get_processed_image (const GValue* value);
GType graw_processed_image_get_type (void) G_GNUC_CONST;
#define GRAW_PROCESSED_IMAGE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GRAW_TYPE_PROCESSED_IMAGE, GRawProcessedImagePrivate))
enum  {
	GRAW_PROCESSED_IMAGE_DUMMY_PROPERTY
};
GRawProcessedImage* graw_processed_image_new (libraw_data_t* proc, GError** error);
GRawProcessedImage* graw_processed_image_construct (GType object_type, libraw_data_t* proc, GError** error);
void graw_throw_exception (const gchar* caller, enum LibRaw_errors _result_, GError** error);
GRawProcessedImage* graw_processed_image_new_from_thumb (libraw_data_t* proc, GError** error);
GRawProcessedImage* graw_processed_image_construct_from_thumb (GType object_type, libraw_data_t* proc, GError** error);
GdkPixbuf* graw_processed_image_get_pixbuf_copy (GRawProcessedImage* self);
gushort graw_processed_image_get_width (GRawProcessedImage* self);
gushort graw_processed_image_get_height (GRawProcessedImage* self);
gushort graw_processed_image_get_colors (GRawProcessedImage* self);
gushort graw_processed_image_get_bits (GRawProcessedImage* self);
guint8* graw_processed_image_get_data (GRawProcessedImage* self);
guint graw_processed_image_get_data_size (GRawProcessedImage* self);
static void graw_processed_image_finalize (GRawProcessedImage * obj);
gpointer graw_processor_ref (gpointer instance);
void graw_processor_unref (gpointer instance);
GParamSpec* graw_param_spec_processor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void graw_value_set_processor (GValue* value, gpointer v_object);
void graw_value_take_processor (GValue* value, gpointer v_object);
gpointer graw_value_get_processor (const GValue* value);
GType graw_processor_get_type (void) G_GNUC_CONST;
#define GRAW_PROCESSOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GRAW_TYPE_PROCESSOR, GRawProcessorPrivate))
enum  {
	GRAW_PROCESSOR_DUMMY_PROPERTY
};
GRawProcessor* graw_processor_new (enum LibRaw_constructor_flags options);
GRawProcessor* graw_processor_construct (GType object_type, enum LibRaw_constructor_flags options);
void graw_processor_adjust_sizes_info_only (GRawProcessor* self, GError** error);
libraw_imgother_t graw_processor_get_image_other (GRawProcessor* self);
libraw_iparams_t graw_processor_get_image_params (GRawProcessor* self);
libraw_image_sizes_t graw_processor_get_sizes (GRawProcessor* self);
libraw_thumbnail_t graw_processor_get_thumbnail (GRawProcessor* self);
GRawProcessedImage* graw_processor_make_mem_image (GRawProcessor* self, GError** error);
GRawProcessedImage* graw_processor_make_thumb_image (GRawProcessor* self, GError** error);
void graw_processor_open_buffer (GRawProcessor* self, guint8* buffer, int buffer_length1, GError** error);
void graw_processor_open_file (GRawProcessor* self, const gchar* filename, GError** error);
void graw_processor_process (GRawProcessor* self, GError** error);
void graw_processor_ppm_tiff_writer (GRawProcessor* self, const gchar* filename, GError** error);
void graw_processor_thumb_writer (GRawProcessor* self, const gchar* filename, GError** error);
void graw_processor_recycle (GRawProcessor* self);
void graw_processor_unpack (GRawProcessor* self, GError** error);
void graw_processor_unpack_thumb (GRawProcessor* self, GError** error);
void graw_processor_configure_for_rgb_display (GRawProcessor* self, gboolean half_size);
libraw_output_params_t* graw_processor_get_output_params (GRawProcessor* self);
static void graw_processor_finalize (GRawProcessor * obj);


GType graw_colorspace_get_type (void) {
	static volatile gsize graw_colorspace_type_id__volatile = 0;
	if (g_once_init_enter (&graw_colorspace_type_id__volatile)) {
		static const GEnumValue values[] = {{GRAW_COLORSPACE_RAW, "GRAW_COLORSPACE_RAW", "raw"}, {GRAW_COLORSPACE_SRGB, "GRAW_COLORSPACE_SRGB", "srgb"}, {GRAW_COLORSPACE_ADOBE, "GRAW_COLORSPACE_ADOBE", "adobe"}, {GRAW_COLORSPACE_WIDE, "GRAW_COLORSPACE_WIDE", "wide"}, {GRAW_COLORSPACE_PROPHOTO, "GRAW_COLORSPACE_PROPHOTO", "prophoto"}, {GRAW_COLORSPACE_XYZ, "GRAW_COLORSPACE_XYZ", "xyz"}, {0, NULL, NULL}};
		GType graw_colorspace_type_id;
		graw_colorspace_type_id = g_enum_register_static ("GRawColorspace", values);
		g_once_init_leave (&graw_colorspace_type_id__volatile, graw_colorspace_type_id);
	}
	return graw_colorspace_type_id__volatile;
}


GQuark graw_exception_quark (void) {
	return g_quark_from_static_string ("graw_exception-quark");
}


GType graw_flip_get_type (void) {
	static volatile gsize graw_flip_type_id__volatile = 0;
	if (g_once_init_enter (&graw_flip_type_id__volatile)) {
		static const GEnumValue values[] = {{GRAW_FLIP_FROM_SOURCE, "GRAW_FLIP_FROM_SOURCE", "from-source"}, {GRAW_FLIP_NONE, "GRAW_FLIP_NONE", "none"}, {GRAW_FLIP_UPSIDE_DOWN, "GRAW_FLIP_UPSIDE_DOWN", "upside-down"}, {GRAW_FLIP_COUNTERCLOCKWISE, "GRAW_FLIP_COUNTERCLOCKWISE", "counterclockwise"}, {GRAW_FLIP_CLOCKWISE, "GRAW_FLIP_CLOCKWISE", "clockwise"}, {0, NULL, NULL}};
		GType graw_flip_type_id;
		graw_flip_type_id = g_enum_register_static ("GRawFlip", values);
		g_once_init_leave (&graw_flip_type_id__volatile, graw_flip_type_id);
	}
	return graw_flip_type_id__volatile;
}


GType graw_fuji_rotate_get_type (void) {
	static volatile gsize graw_fuji_rotate_type_id__volatile = 0;
	if (g_once_init_enter (&graw_fuji_rotate_type_id__volatile)) {
		static const GEnumValue values[] = {{GRAW_FUJI_ROTATE_USE, "GRAW_FUJI_ROTATE_USE", "use"}, {GRAW_FUJI_ROTATE_DONT_USE, "GRAW_FUJI_ROTATE_DONT_USE", "dont-use"}, {0, NULL, NULL}};
		GType graw_fuji_rotate_type_id;
		graw_fuji_rotate_type_id = g_enum_register_static ("GRawFujiRotate", values);
		g_once_init_leave (&graw_fuji_rotate_type_id__volatile, graw_fuji_rotate_type_id);
	}
	return graw_fuji_rotate_type_id__volatile;
}


GType graw_highlight_mode_get_type (void) {
	static volatile gsize graw_highlight_mode_type_id__volatile = 0;
	if (g_once_init_enter (&graw_highlight_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{GRAW_HIGHLIGHT_MODE_CLIP, "GRAW_HIGHLIGHT_MODE_CLIP", "clip"}, {GRAW_HIGHLIGHT_MODE_UNCLIP, "GRAW_HIGHLIGHT_MODE_UNCLIP", "unclip"}, {GRAW_HIGHLIGHT_MODE_BLEND, "GRAW_HIGHLIGHT_MODE_BLEND", "blend"}, {GRAW_HIGHLIGHT_MODE_REBUILD, "GRAW_HIGHLIGHT_MODE_REBUILD", "rebuild"}, {0, NULL, NULL}};
		GType graw_highlight_mode_type_id;
		graw_highlight_mode_type_id = g_enum_register_static ("GRawHighlightMode", values);
		g_once_init_leave (&graw_highlight_mode_type_id__volatile, graw_highlight_mode_type_id);
	}
	return graw_highlight_mode_type_id__volatile;
}


GType graw_interpolation_quality_get_type (void) {
	static volatile gsize graw_interpolation_quality_type_id__volatile = 0;
	if (g_once_init_enter (&graw_interpolation_quality_type_id__volatile)) {
		static const GEnumValue values[] = {{GRAW_INTERPOLATION_QUALITY_LINEAR, "GRAW_INTERPOLATION_QUALITY_LINEAR", "linear"}, {GRAW_INTERPOLATION_QUALITY_VNG, "GRAW_INTERPOLATION_QUALITY_VNG", "vng"}, {GRAW_INTERPOLATION_QUALITY_PPG, "GRAW_INTERPOLATION_QUALITY_PPG", "ppg"}, {GRAW_INTERPOLATION_QUALITY_AHD, "GRAW_INTERPOLATION_QUALITY_AHD", "ahd"}, {0, NULL, NULL}};
		GType graw_interpolation_quality_type_id;
		graw_interpolation_quality_type_id = g_enum_register_static ("GRawInterpolationQuality", values);
		g_once_init_leave (&graw_interpolation_quality_type_id__volatile, graw_interpolation_quality_type_id);
	}
	return graw_interpolation_quality_type_id__volatile;
}


GType graw_use_camera_matrix_get_type (void) {
	static volatile gsize graw_use_camera_matrix_type_id__volatile = 0;
	if (g_once_init_enter (&graw_use_camera_matrix_type_id__volatile)) {
		static const GEnumValue values[] = {{GRAW_USE_CAMERA_MATRIX_IGNORE, "GRAW_USE_CAMERA_MATRIX_IGNORE", "ignore"}, {GRAW_USE_CAMERA_MATRIX_EMBEDDED_COLOR_PROFILE, "GRAW_USE_CAMERA_MATRIX_EMBEDDED_COLOR_PROFILE", "embedded-color-profile"}, {GRAW_USE_CAMERA_MATRIX_EMBEDDED_COLOR_DATA, "GRAW_USE_CAMERA_MATRIX_EMBEDDED_COLOR_DATA", "embedded-color-data"}, {0, NULL, NULL}};
		GType graw_use_camera_matrix_type_id;
		graw_use_camera_matrix_type_id = g_enum_register_static ("GRawUseCameraMatrix", values);
		g_once_init_leave (&graw_use_camera_matrix_type_id__volatile, graw_use_camera_matrix_type_id);
	}
	return graw_use_camera_matrix_type_id__volatile;
}


GRawProcessedImage* graw_processed_image_construct (GType object_type, libraw_data_t* proc, GError** error) {
	GRawProcessedImage* self = NULL;
	enum LibRaw_errors _result_ = 0;
	libraw_data_t* _tmp0_;
	libraw_processed_image_t* _tmp1_;
	enum LibRaw_errors _tmp2_;
	libraw_processed_image_t* _tmp3_;
	libraw_processed_image_t* _tmp4_;
	guint8* _tmp5_;
	gint _tmp5__length1;
	libraw_processed_image_t* _tmp6_;
	gushort _tmp7_;
	libraw_processed_image_t* _tmp8_;
	gushort _tmp9_;
	libraw_processed_image_t* _tmp10_;
	gushort _tmp11_;
	libraw_processed_image_t* _tmp12_;
	gushort _tmp13_;
	libraw_processed_image_t* _tmp14_;
	gushort _tmp15_;
	GdkPixbuf* _tmp16_;
	GError * _inner_error_ = NULL;
#line 112 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_val_if_fail (proc != NULL, NULL);
#line 112 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	self = (GRawProcessedImage*) g_type_create_instance (object_type);
#line 113 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_result_ = LIBRAW_SUCCESS;
#line 114 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = proc;
#line 114 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp1_ = libraw_dcraw_make_mem_image (_tmp0_, &_result_);
#line 114 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_free0 (self->priv->image);
#line 114 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	self->priv->image = _tmp1_;
#line 115 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp2_ = _result_;
#line 115 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	graw_throw_exception ("ProcessedImage", _tmp2_, &_inner_error_);
#line 115 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 115 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 115 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_propagate_error (error, _inner_error_);
#line 115 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_graw_processed_image_unref0 (self);
#line 115 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return NULL;
#line 365 "GRaw.c"
		} else {
#line 115 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 115 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_clear_error (&_inner_error_);
#line 115 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return NULL;
#line 373 "GRaw.c"
		}
	}
#line 116 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp3_ = self->priv->image;
#line 116 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_vala_assert (_tmp3_ != NULL, "image != null");
#line 120 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp4_ = self->priv->image;
#line 120 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp5_ = _tmp4_->data;
#line 120 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp5__length1 = _tmp4_->data_size;
#line 120 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp6_ = self->priv->image;
#line 120 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp7_ = _tmp6_->bits;
#line 120 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp8_ = self->priv->image;
#line 120 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp9_ = _tmp8_->width;
#line 120 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp10_ = self->priv->image;
#line 120 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp11_ = _tmp10_->height;
#line 120 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp12_ = self->priv->image;
#line 120 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp13_ = _tmp12_->width;
#line 120 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp14_ = self->priv->image;
#line 120 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp15_ = _tmp14_->colors;
#line 120 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp16_ = gdk_pixbuf_new_from_data (_tmp5_, GDK_COLORSPACE_RGB, FALSE, (gint) _tmp7_, (gint) _tmp9_, (gint) _tmp11_, (gint) (_tmp13_ * _tmp15_), (GdkPixbufDestroyNotify) NULL, NULL);
#line 120 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_g_object_unref0 (self->priv->pixbuf);
#line 120 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	self->priv->pixbuf = _tmp16_;
#line 112 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return self;
#line 414 "GRaw.c"
}


GRawProcessedImage* graw_processed_image_new (libraw_data_t* proc, GError** error) {
#line 112 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return graw_processed_image_construct (GRAW_TYPE_PROCESSED_IMAGE, proc, error);
#line 421 "GRaw.c"
}


GRawProcessedImage* graw_processed_image_construct_from_thumb (GType object_type, libraw_data_t* proc, GError** error) {
	GRawProcessedImage* self = NULL;
	enum LibRaw_errors _result_ = 0;
	libraw_data_t* _tmp0_;
	libraw_processed_image_t* _tmp1_;
	enum LibRaw_errors _tmp2_;
	libraw_processed_image_t* _tmp3_;
	libraw_processed_image_t* _tmp17_;
	GdkPixbuf* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	libraw_processed_image_t* _tmp21_;
	GdkPixbuf* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	libraw_processed_image_t* _tmp25_;
	GdkPixbuf* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	libraw_processed_image_t* _tmp29_;
	GdkPixbuf* _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	GError * _inner_error_ = NULL;
#line 124 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_val_if_fail (proc != NULL, NULL);
#line 124 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	self = (GRawProcessedImage*) g_type_create_instance (object_type);
#line 125 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_result_ = LIBRAW_SUCCESS;
#line 126 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = proc;
#line 126 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp1_ = libraw_dcraw_make_mem_thumb (_tmp0_, &_result_);
#line 126 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_free0 (self->priv->image);
#line 126 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	self->priv->image = _tmp1_;
#line 127 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp2_ = _result_;
#line 127 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	graw_throw_exception ("ProcessedImage.from_thumb", _tmp2_, &_inner_error_);
#line 127 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 127 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 127 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_propagate_error (error, _inner_error_);
#line 127 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_graw_processed_image_unref0 (self);
#line 127 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return NULL;
#line 477 "GRaw.c"
		} else {
#line 127 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 127 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_clear_error (&_inner_error_);
#line 127 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return NULL;
#line 485 "GRaw.c"
		}
	}
#line 128 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp3_ = self->priv->image;
#line 128 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_vala_assert (_tmp3_ != NULL, "image != null");
#line 492 "GRaw.c"
	{
		GBytes* bytes = NULL;
		libraw_processed_image_t* _tmp4_;
		guint8* _tmp5_;
		gint _tmp5__length1;
		GBytes* _tmp6_;
		GdkPixbuf* _tmp7_ = NULL;
		GBytes* _tmp8_;
		GMemoryInputStream* _tmp9_;
		GMemoryInputStream* _tmp10_;
		GdkPixbuf* _tmp11_;
		GdkPixbuf* _tmp12_;
		GdkPixbuf* _tmp13_;
#line 134 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		_tmp4_ = self->priv->image;
#line 134 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		_tmp5_ = _tmp4_->data;
#line 134 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		_tmp5__length1 = _tmp4_->data_size;
#line 134 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		_tmp6_ = g_bytes_new_static (_tmp5_, _tmp5__length1);
#line 134 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		bytes = _tmp6_;
#line 135 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		_tmp8_ = bytes;
#line 135 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		_tmp9_ = (GMemoryInputStream*) g_memory_input_stream_new_from_bytes (_tmp8_);
#line 135 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		_tmp10_ = _tmp9_;
#line 135 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		_tmp11_ = gdk_pixbuf_new_from_stream (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, g_input_stream_get_type (), GInputStream), NULL, &_inner_error_);
#line 135 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		_tmp12_ = _tmp11_;
#line 135 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		_g_object_unref0 (_tmp10_);
#line 135 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		_tmp7_ = _tmp12_;
#line 135 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 135 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_g_bytes_unref0 (bytes);
#line 534 "GRaw.c"
			goto __catch33_g_error;
		}
#line 135 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		_tmp13_ = _tmp7_;
#line 135 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		_tmp7_ = NULL;
#line 135 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		_g_object_unref0 (self->priv->pixbuf);
#line 135 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		self->priv->pixbuf = _tmp13_;
#line 133 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		_g_object_unref0 (_tmp7_);
#line 133 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		_g_bytes_unref0 (bytes);
#line 549 "GRaw.c"
	}
	goto __finally33;
	__catch33_g_error:
	{
		GError* err = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
		GError* _tmp16_;
#line 133 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		err = _inner_error_;
#line 133 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		_inner_error_ = NULL;
#line 138 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		_tmp14_ = err;
#line 138 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		_tmp15_ = _tmp14_->message;
#line 138 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		_tmp16_ = g_error_new_literal (GRAW_EXCEPTION, GRAW_EXCEPTION_UNSUPPORTED_THUMBNAIL, _tmp15_);
#line 138 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		_inner_error_ = _tmp16_;
#line 138 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		_g_error_free0 (err);
#line 572 "GRaw.c"
		goto __finally33;
	}
	__finally33:
#line 133 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 133 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 133 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_propagate_error (error, _inner_error_);
#line 133 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_graw_processed_image_unref0 (self);
#line 133 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return NULL;
#line 586 "GRaw.c"
		} else {
#line 133 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 133 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_clear_error (&_inner_error_);
#line 133 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return NULL;
#line 594 "GRaw.c"
		}
	}
#line 142 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp17_ = self->priv->image;
#line 142 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp18_ = self->priv->pixbuf;
#line 142 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp19_ = gdk_pixbuf_get_width (_tmp18_);
#line 142 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp20_ = _tmp19_;
#line 142 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp17_->width = (gushort) _tmp20_;
#line 143 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp21_ = self->priv->image;
#line 143 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp22_ = self->priv->pixbuf;
#line 143 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp23_ = gdk_pixbuf_get_height (_tmp22_);
#line 143 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp24_ = _tmp23_;
#line 143 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp21_->height = (gushort) _tmp24_;
#line 144 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp25_ = self->priv->image;
#line 144 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp26_ = self->priv->pixbuf;
#line 144 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp27_ = gdk_pixbuf_get_n_channels (_tmp26_);
#line 144 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp28_ = _tmp27_;
#line 144 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp25_->colors = (gushort) _tmp28_;
#line 145 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp29_ = self->priv->image;
#line 145 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp30_ = self->priv->pixbuf;
#line 145 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp31_ = gdk_pixbuf_get_bits_per_sample (_tmp30_);
#line 145 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp32_ = _tmp31_;
#line 145 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp29_->bits = (gushort) _tmp32_;
#line 124 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return self;
#line 639 "GRaw.c"
}


GRawProcessedImage* graw_processed_image_new_from_thumb (libraw_data_t* proc, GError** error) {
#line 124 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return graw_processed_image_construct_from_thumb (GRAW_TYPE_PROCESSED_IMAGE, proc, error);
#line 646 "GRaw.c"
}


GdkPixbuf* graw_processed_image_get_pixbuf_copy (GRawProcessedImage* self) {
	GdkPixbuf* result = NULL;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
#line 149 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_val_if_fail (GRAW_IS_PROCESSED_IMAGE (self), NULL);
#line 150 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = self->priv->pixbuf;
#line 150 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp1_ = gdk_pixbuf_copy (_tmp0_);
#line 150 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	result = _tmp1_;
#line 150 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return result;
#line 664 "GRaw.c"
}


gushort graw_processed_image_get_width (GRawProcessedImage* self) {
	gushort result;
	libraw_processed_image_t* _tmp0_;
	gushort _tmp1_;
#line 77 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_val_if_fail (GRAW_IS_PROCESSED_IMAGE (self), 0U);
#line 78 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = self->priv->image;
#line 78 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp1_ = _tmp0_->width;
#line 78 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	result = _tmp1_;
#line 78 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return result;
#line 682 "GRaw.c"
}


gushort graw_processed_image_get_height (GRawProcessedImage* self) {
	gushort result;
	libraw_processed_image_t* _tmp0_;
	gushort _tmp1_;
#line 83 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_val_if_fail (GRAW_IS_PROCESSED_IMAGE (self), 0U);
#line 84 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = self->priv->image;
#line 84 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp1_ = _tmp0_->height;
#line 84 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	result = _tmp1_;
#line 84 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return result;
#line 700 "GRaw.c"
}


gushort graw_processed_image_get_colors (GRawProcessedImage* self) {
	gushort result;
	libraw_processed_image_t* _tmp0_;
	gushort _tmp1_;
#line 89 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_val_if_fail (GRAW_IS_PROCESSED_IMAGE (self), 0U);
#line 90 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = self->priv->image;
#line 90 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp1_ = _tmp0_->colors;
#line 90 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	result = _tmp1_;
#line 90 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return result;
#line 718 "GRaw.c"
}


gushort graw_processed_image_get_bits (GRawProcessedImage* self) {
	gushort result;
	libraw_processed_image_t* _tmp0_;
	gushort _tmp1_;
#line 95 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_val_if_fail (GRAW_IS_PROCESSED_IMAGE (self), 0U);
#line 96 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = self->priv->image;
#line 96 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp1_ = _tmp0_->bits;
#line 96 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	result = _tmp1_;
#line 96 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return result;
#line 736 "GRaw.c"
}


guint8* graw_processed_image_get_data (GRawProcessedImage* self) {
	guint8* result;
	libraw_processed_image_t* _tmp0_;
	guint8* _tmp1_;
	gint _tmp1__length1;
#line 101 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_val_if_fail (GRAW_IS_PROCESSED_IMAGE (self), NULL);
#line 102 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = self->priv->image;
#line 102 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp1_ = _tmp0_->data;
#line 102 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp1__length1 = _tmp0_->data_size;
#line 102 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	result = _tmp1_;
#line 102 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return result;
#line 757 "GRaw.c"
}


guint graw_processed_image_get_data_size (GRawProcessedImage* self) {
	guint result;
	libraw_processed_image_t* _tmp0_;
	guint _tmp1_;
#line 107 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_val_if_fail (GRAW_IS_PROCESSED_IMAGE (self), 0U);
#line 108 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = self->priv->image;
#line 108 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp1_ = _tmp0_->data_size;
#line 108 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	result = _tmp1_;
#line 108 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return result;
#line 775 "GRaw.c"
}


static void graw_value_processed_image_init (GValue* value) {
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	value->data[0].v_pointer = NULL;
#line 782 "GRaw.c"
}


static void graw_value_processed_image_free_value (GValue* value) {
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (value->data[0].v_pointer) {
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		graw_processed_image_unref (value->data[0].v_pointer);
#line 791 "GRaw.c"
	}
}


static void graw_value_processed_image_copy_value (const GValue* src_value, GValue* dest_value) {
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (src_value->data[0].v_pointer) {
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		dest_value->data[0].v_pointer = graw_processed_image_ref (src_value->data[0].v_pointer);
#line 801 "GRaw.c"
	} else {
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		dest_value->data[0].v_pointer = NULL;
#line 805 "GRaw.c"
	}
}


static gpointer graw_value_processed_image_peek_pointer (const GValue* value) {
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return value->data[0].v_pointer;
#line 813 "GRaw.c"
}


static gchar* graw_value_processed_image_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (collect_values[0].v_pointer) {
#line 820 "GRaw.c"
		GRawProcessedImage * object;
		object = collect_values[0].v_pointer;
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		if (object->parent_instance.g_class == NULL) {
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 827 "GRaw.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 831 "GRaw.c"
		}
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		value->data[0].v_pointer = graw_processed_image_ref (object);
#line 835 "GRaw.c"
	} else {
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		value->data[0].v_pointer = NULL;
#line 839 "GRaw.c"
	}
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return NULL;
#line 843 "GRaw.c"
}


static gchar* graw_value_processed_image_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GRawProcessedImage ** object_p;
	object_p = collect_values[0].v_pointer;
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (!object_p) {
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 854 "GRaw.c"
	}
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (!value->data[0].v_pointer) {
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		*object_p = NULL;
#line 860 "GRaw.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		*object_p = value->data[0].v_pointer;
#line 864 "GRaw.c"
	} else {
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		*object_p = graw_processed_image_ref (value->data[0].v_pointer);
#line 868 "GRaw.c"
	}
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return NULL;
#line 872 "GRaw.c"
}


GParamSpec* graw_param_spec_processed_image (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	GRawParamSpecProcessedImage* spec;
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_val_if_fail (g_type_is_a (object_type, GRAW_TYPE_PROCESSED_IMAGE), NULL);
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return G_PARAM_SPEC (spec);
#line 886 "GRaw.c"
}


gpointer graw_value_get_processed_image (const GValue* value) {
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GRAW_TYPE_PROCESSED_IMAGE), NULL);
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return value->data[0].v_pointer;
#line 895 "GRaw.c"
}


void graw_value_set_processed_image (GValue* value, gpointer v_object) {
	GRawProcessedImage * old;
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GRAW_TYPE_PROCESSED_IMAGE));
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	old = value->data[0].v_pointer;
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (v_object) {
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GRAW_TYPE_PROCESSED_IMAGE));
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		value->data[0].v_pointer = v_object;
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		graw_processed_image_ref (value->data[0].v_pointer);
#line 915 "GRaw.c"
	} else {
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		value->data[0].v_pointer = NULL;
#line 919 "GRaw.c"
	}
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (old) {
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		graw_processed_image_unref (old);
#line 925 "GRaw.c"
	}
}


void graw_value_take_processed_image (GValue* value, gpointer v_object) {
	GRawProcessedImage * old;
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GRAW_TYPE_PROCESSED_IMAGE));
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	old = value->data[0].v_pointer;
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (v_object) {
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GRAW_TYPE_PROCESSED_IMAGE));
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		value->data[0].v_pointer = v_object;
#line 944 "GRaw.c"
	} else {
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		value->data[0].v_pointer = NULL;
#line 948 "GRaw.c"
	}
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (old) {
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		graw_processed_image_unref (old);
#line 954 "GRaw.c"
	}
}


static void graw_processed_image_class_init (GRawProcessedImageClass * klass) {
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	graw_processed_image_parent_class = g_type_class_peek_parent (klass);
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	((GRawProcessedImageClass *) klass)->finalize = graw_processed_image_finalize;
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_type_class_add_private (klass, sizeof (GRawProcessedImagePrivate));
#line 966 "GRaw.c"
}


static void graw_processed_image_instance_init (GRawProcessedImage * self) {
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	self->priv = GRAW_PROCESSED_IMAGE_GET_PRIVATE (self);
#line 74 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	self->priv->pixbuf = NULL;
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	self->ref_count = 1;
#line 977 "GRaw.c"
}


static void graw_processed_image_finalize (GRawProcessedImage * obj) {
	GRawProcessedImage * self;
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRAW_TYPE_PROCESSED_IMAGE, GRawProcessedImage);
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_signal_handlers_destroy (self);
#line 73 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_free0 (self->priv->image);
#line 74 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_g_object_unref0 (self->priv->pixbuf);
#line 991 "GRaw.c"
}


GType graw_processed_image_get_type (void) {
	static volatile gsize graw_processed_image_type_id__volatile = 0;
	if (g_once_init_enter (&graw_processed_image_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { graw_value_processed_image_init, graw_value_processed_image_free_value, graw_value_processed_image_copy_value, graw_value_processed_image_peek_pointer, "p", graw_value_processed_image_collect_value, "p", graw_value_processed_image_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GRawProcessedImageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) graw_processed_image_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GRawProcessedImage), 0, (GInstanceInitFunc) graw_processed_image_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType graw_processed_image_type_id;
		graw_processed_image_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GRawProcessedImage", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&graw_processed_image_type_id__volatile, graw_processed_image_type_id);
	}
	return graw_processed_image_type_id__volatile;
}


gpointer graw_processed_image_ref (gpointer instance) {
	GRawProcessedImage * self;
	self = instance;
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_atomic_int_inc (&self->ref_count);
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return instance;
#line 1016 "GRaw.c"
}


void graw_processed_image_unref (gpointer instance) {
	GRawProcessedImage * self;
	self = instance;
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		GRAW_PROCESSED_IMAGE_GET_CLASS (self)->finalize (self);
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1029 "GRaw.c"
	}
}


GRawProcessor* graw_processor_construct (GType object_type, enum LibRaw_constructor_flags options) {
	GRawProcessor* self = NULL;
	enum LibRaw_constructor_flags _tmp0_;
	libraw_data_t* _tmp1_;
#line 163 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	self = (GRawProcessor*) g_type_create_instance (object_type);
#line 164 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = options;
#line 164 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp1_ = libraw_init (_tmp0_);
#line 164 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_libraw_close0 (self->priv->proc);
#line 164 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	self->priv->proc = _tmp1_;
#line 163 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return self;
#line 1050 "GRaw.c"
}


GRawProcessor* graw_processor_new (enum LibRaw_constructor_flags options) {
#line 163 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return graw_processor_construct (GRAW_TYPE_PROCESSOR, options);
#line 1057 "GRaw.c"
}


void graw_processor_adjust_sizes_info_only (GRawProcessor* self, GError** error) {
	libraw_data_t* _tmp0_;
	enum LibRaw_errors _tmp1_;
	GError * _inner_error_ = NULL;
#line 167 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_if_fail (GRAW_IS_PROCESSOR (self));
#line 168 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = self->priv->proc;
#line 168 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp1_ = libraw_adjust_sizes_info_only (_tmp0_);
#line 168 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	graw_throw_exception ("adjust_sizes_info_only", _tmp1_, &_inner_error_);
#line 168 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 168 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 168 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_propagate_error (error, _inner_error_);
#line 168 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return;
#line 1081 "GRaw.c"
		} else {
#line 168 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 168 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_clear_error (&_inner_error_);
#line 168 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return;
#line 1089 "GRaw.c"
		}
	}
}


static libraw_imgother_t libraw_get_image_other (libraw_data_t* self) {
	libraw_imgother_t result = {0};
	libraw_imgother_t _tmp0_;
#line 188 "/home/jens/Source/shotwell/vapi/libraw.vapi"
	_tmp0_ = self->other;
#line 188 "/home/jens/Source/shotwell/vapi/libraw.vapi"
	result = _tmp0_;
#line 188 "/home/jens/Source/shotwell/vapi/libraw.vapi"
	return result;
#line 1104 "GRaw.c"
}


libraw_imgother_t graw_processor_get_image_other (GRawProcessor* self) {
	libraw_imgother_t result = {0};
	libraw_data_t* _tmp0_;
	libraw_imgother_t _tmp1_;
#line 172 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = self->priv->proc;
#line 172 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp1_ = libraw_get_image_other (_tmp0_);
#line 172 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	result = _tmp1_;
#line 172 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return result;
#line 1120 "GRaw.c"
}


static libraw_iparams_t libraw_get_image_params (libraw_data_t* self) {
	libraw_iparams_t result = {0};
	libraw_iparams_t _tmp0_;
#line 189 "/home/jens/Source/shotwell/vapi/libraw.vapi"
	_tmp0_ = self->idata;
#line 189 "/home/jens/Source/shotwell/vapi/libraw.vapi"
	result = _tmp0_;
#line 189 "/home/jens/Source/shotwell/vapi/libraw.vapi"
	return result;
#line 1133 "GRaw.c"
}


libraw_iparams_t graw_processor_get_image_params (GRawProcessor* self) {
	libraw_iparams_t result = {0};
	libraw_data_t* _tmp0_;
	libraw_iparams_t _tmp1_;
#line 176 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = self->priv->proc;
#line 176 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp1_ = libraw_get_image_params (_tmp0_);
#line 176 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	result = _tmp1_;
#line 176 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return result;
#line 1149 "GRaw.c"
}


static libraw_image_sizes_t libraw_get_sizes (libraw_data_t* self) {
	libraw_image_sizes_t result = {0};
	libraw_image_sizes_t _tmp0_;
#line 192 "/home/jens/Source/shotwell/vapi/libraw.vapi"
	_tmp0_ = self->sizes;
#line 192 "/home/jens/Source/shotwell/vapi/libraw.vapi"
	result = _tmp0_;
#line 192 "/home/jens/Source/shotwell/vapi/libraw.vapi"
	return result;
#line 1162 "GRaw.c"
}


libraw_image_sizes_t graw_processor_get_sizes (GRawProcessor* self) {
	libraw_image_sizes_t result = {0};
	libraw_data_t* _tmp0_;
	libraw_image_sizes_t _tmp1_;
#line 180 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = self->priv->proc;
#line 180 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp1_ = libraw_get_sizes (_tmp0_);
#line 180 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	result = _tmp1_;
#line 180 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return result;
#line 1178 "GRaw.c"
}


static libraw_thumbnail_t libraw_get_thumbnail (libraw_data_t* self) {
	libraw_thumbnail_t result = {0};
	libraw_thumbnail_t _tmp0_;
#line 193 "/home/jens/Source/shotwell/vapi/libraw.vapi"
	_tmp0_ = self->thumbnail;
#line 193 "/home/jens/Source/shotwell/vapi/libraw.vapi"
	result = _tmp0_;
#line 193 "/home/jens/Source/shotwell/vapi/libraw.vapi"
	return result;
#line 1191 "GRaw.c"
}


libraw_thumbnail_t graw_processor_get_thumbnail (GRawProcessor* self) {
	libraw_thumbnail_t result = {0};
	libraw_data_t* _tmp0_;
	libraw_thumbnail_t _tmp1_;
#line 184 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = self->priv->proc;
#line 184 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp1_ = libraw_get_thumbnail (_tmp0_);
#line 184 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	result = _tmp1_;
#line 184 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return result;
#line 1207 "GRaw.c"
}


GRawProcessedImage* graw_processor_make_mem_image (GRawProcessor* self, GError** error) {
	GRawProcessedImage* result = NULL;
	GRawProcessedImage* _tmp0_ = NULL;
	libraw_data_t* _tmp1_;
	GRawProcessedImage* _tmp2_;
	GRawProcessedImage* _tmp3_;
	GError * _inner_error_ = NULL;
#line 187 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_val_if_fail (GRAW_IS_PROCESSOR (self), NULL);
#line 188 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp1_ = self->priv->proc;
#line 188 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp2_ = graw_processed_image_new (_tmp1_, &_inner_error_);
#line 188 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = _tmp2_;
#line 188 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 188 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 188 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_propagate_error (error, _inner_error_);
#line 188 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return NULL;
#line 1234 "GRaw.c"
		} else {
#line 188 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 188 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_clear_error (&_inner_error_);
#line 188 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return NULL;
#line 1242 "GRaw.c"
		}
	}
#line 188 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp3_ = _tmp0_;
#line 188 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = NULL;
#line 188 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	result = _tmp3_;
#line 188 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_graw_processed_image_unref0 (_tmp0_);
#line 188 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return result;
#line 1255 "GRaw.c"
}


GRawProcessedImage* graw_processor_make_thumb_image (GRawProcessor* self, GError** error) {
	GRawProcessedImage* result = NULL;
	GRawProcessedImage* _tmp0_ = NULL;
	libraw_data_t* _tmp1_;
	GRawProcessedImage* _tmp2_;
	GRawProcessedImage* _tmp3_;
	GError * _inner_error_ = NULL;
#line 191 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_val_if_fail (GRAW_IS_PROCESSOR (self), NULL);
#line 192 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp1_ = self->priv->proc;
#line 192 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp2_ = graw_processed_image_new_from_thumb (_tmp1_, &_inner_error_);
#line 192 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = _tmp2_;
#line 192 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 192 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 192 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_propagate_error (error, _inner_error_);
#line 192 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return NULL;
#line 1282 "GRaw.c"
		} else {
#line 192 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 192 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_clear_error (&_inner_error_);
#line 192 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return NULL;
#line 1290 "GRaw.c"
		}
	}
#line 192 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp3_ = _tmp0_;
#line 192 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = NULL;
#line 192 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	result = _tmp3_;
#line 192 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_graw_processed_image_unref0 (_tmp0_);
#line 192 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return result;
#line 1303 "GRaw.c"
}


void graw_processor_open_buffer (GRawProcessor* self, guint8* buffer, int buffer_length1, GError** error) {
	libraw_data_t* _tmp0_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	enum LibRaw_errors _tmp2_;
	GError * _inner_error_ = NULL;
#line 195 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_if_fail (GRAW_IS_PROCESSOR (self));
#line 196 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = self->priv->proc;
#line 196 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp1_ = buffer;
#line 196 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp1__length1 = buffer_length1;
#line 196 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp2_ = libraw_open_buffer (_tmp0_, _tmp1_, _tmp1__length1);
#line 196 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	graw_throw_exception ("open_buffer", _tmp2_, &_inner_error_);
#line 196 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 196 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 196 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_propagate_error (error, _inner_error_);
#line 196 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return;
#line 1333 "GRaw.c"
		} else {
#line 196 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 196 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_clear_error (&_inner_error_);
#line 196 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return;
#line 1341 "GRaw.c"
		}
	}
}


void graw_processor_open_file (GRawProcessor* self, const gchar* filename, GError** error) {
	libraw_data_t* _tmp0_;
	const gchar* _tmp1_;
	enum LibRaw_errors _tmp2_;
	GError * _inner_error_ = NULL;
#line 199 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_if_fail (GRAW_IS_PROCESSOR (self));
#line 199 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_if_fail (filename != NULL);
#line 200 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = self->priv->proc;
#line 200 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp1_ = filename;
#line 200 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp2_ = libraw_open_file (_tmp0_, _tmp1_);
#line 200 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	graw_throw_exception ("open_file", _tmp2_, &_inner_error_);
#line 200 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 200 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 200 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_propagate_error (error, _inner_error_);
#line 200 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return;
#line 1372 "GRaw.c"
		} else {
#line 200 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 200 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_clear_error (&_inner_error_);
#line 200 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return;
#line 1380 "GRaw.c"
		}
	}
}


void graw_processor_process (GRawProcessor* self, GError** error) {
	libraw_data_t* _tmp0_;
	enum LibRaw_errors _tmp1_;
	GError * _inner_error_ = NULL;
#line 203 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_if_fail (GRAW_IS_PROCESSOR (self));
#line 204 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = self->priv->proc;
#line 204 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp1_ = libraw_dcraw_process (_tmp0_);
#line 204 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	graw_throw_exception ("process", _tmp1_, &_inner_error_);
#line 204 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 204 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 204 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_propagate_error (error, _inner_error_);
#line 204 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return;
#line 1406 "GRaw.c"
		} else {
#line 204 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 204 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_clear_error (&_inner_error_);
#line 204 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return;
#line 1414 "GRaw.c"
		}
	}
}


void graw_processor_ppm_tiff_writer (GRawProcessor* self, const gchar* filename, GError** error) {
	libraw_data_t* _tmp0_;
	const gchar* _tmp1_;
	enum LibRaw_errors _tmp2_;
	GError * _inner_error_ = NULL;
#line 207 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_if_fail (GRAW_IS_PROCESSOR (self));
#line 207 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_if_fail (filename != NULL);
#line 208 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = self->priv->proc;
#line 208 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp1_ = filename;
#line 208 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp2_ = libraw_dcraw_ppm_tiff_writer (_tmp0_, _tmp1_);
#line 208 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	graw_throw_exception ("ppm_tiff_writer", _tmp2_, &_inner_error_);
#line 208 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 208 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 208 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_propagate_error (error, _inner_error_);
#line 208 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return;
#line 1445 "GRaw.c"
		} else {
#line 208 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 208 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_clear_error (&_inner_error_);
#line 208 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return;
#line 1453 "GRaw.c"
		}
	}
}


void graw_processor_thumb_writer (GRawProcessor* self, const gchar* filename, GError** error) {
	libraw_data_t* _tmp0_;
	const gchar* _tmp1_;
	enum LibRaw_errors _tmp2_;
	GError * _inner_error_ = NULL;
#line 211 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_if_fail (GRAW_IS_PROCESSOR (self));
#line 211 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_if_fail (filename != NULL);
#line 212 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = self->priv->proc;
#line 212 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp1_ = filename;
#line 212 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp2_ = libraw_dcraw_thumb_writer (_tmp0_, _tmp1_);
#line 212 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	graw_throw_exception ("thumb_writer", _tmp2_, &_inner_error_);
#line 212 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 212 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 212 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_propagate_error (error, _inner_error_);
#line 212 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return;
#line 1484 "GRaw.c"
		} else {
#line 212 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 212 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_clear_error (&_inner_error_);
#line 212 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return;
#line 1492 "GRaw.c"
		}
	}
}


void graw_processor_recycle (GRawProcessor* self) {
	libraw_data_t* _tmp0_;
#line 215 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_if_fail (GRAW_IS_PROCESSOR (self));
#line 216 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = self->priv->proc;
#line 216 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	libraw_recycle (_tmp0_);
#line 1506 "GRaw.c"
}


void graw_processor_unpack (GRawProcessor* self, GError** error) {
	libraw_data_t* _tmp0_;
	enum LibRaw_errors _tmp1_;
	GError * _inner_error_ = NULL;
#line 219 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_if_fail (GRAW_IS_PROCESSOR (self));
#line 220 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = self->priv->proc;
#line 220 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp1_ = libraw_unpack (_tmp0_);
#line 220 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	graw_throw_exception ("unpack", _tmp1_, &_inner_error_);
#line 220 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 220 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 220 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_propagate_error (error, _inner_error_);
#line 220 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return;
#line 1530 "GRaw.c"
		} else {
#line 220 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 220 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_clear_error (&_inner_error_);
#line 220 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return;
#line 1538 "GRaw.c"
		}
	}
}


void graw_processor_unpack_thumb (GRawProcessor* self, GError** error) {
	libraw_data_t* _tmp0_;
	enum LibRaw_errors _tmp1_;
	GError * _inner_error_ = NULL;
#line 223 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_if_fail (GRAW_IS_PROCESSOR (self));
#line 224 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = self->priv->proc;
#line 224 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp1_ = libraw_unpack_thumb (_tmp0_);
#line 224 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	graw_throw_exception ("unpack_thumb", _tmp1_, &_inner_error_);
#line 224 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 224 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 224 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_propagate_error (error, _inner_error_);
#line 224 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return;
#line 1564 "GRaw.c"
		} else {
#line 224 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 224 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_clear_error (&_inner_error_);
#line 224 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return;
#line 1572 "GRaw.c"
		}
	}
}


static void lib_raw_output_params_set_chromatic_aberrations (libraw_output_params_t* params, gdouble red_multiplier, gdouble green_multiplier) {
	libraw_output_params_t* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	libraw_output_params_t* _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
#line 148 "/home/jens/Source/shotwell/vapi/libraw.vapi"
	_tmp0_ = params;
#line 148 "/home/jens/Source/shotwell/vapi/libraw.vapi"
	_tmp1_ = red_multiplier;
#line 148 "/home/jens/Source/shotwell/vapi/libraw.vapi"
	(*_tmp0_).aber[0] = _tmp1_;
#line 148 "/home/jens/Source/shotwell/vapi/libraw.vapi"
	_tmp2_ = (*_tmp0_).aber[0];
#line 149 "/home/jens/Source/shotwell/vapi/libraw.vapi"
	_tmp3_ = params;
#line 149 "/home/jens/Source/shotwell/vapi/libraw.vapi"
	_tmp4_ = green_multiplier;
#line 149 "/home/jens/Source/shotwell/vapi/libraw.vapi"
	(*_tmp3_).aber[2] = _tmp4_;
#line 149 "/home/jens/Source/shotwell/vapi/libraw.vapi"
	_tmp5_ = (*_tmp3_).aber[2];
#line 1601 "GRaw.c"
}


static void lib_raw_output_params_set_gamma_curve (libraw_output_params_t* params, gdouble power, gdouble slope) {
	libraw_output_params_t* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	libraw_output_params_t* _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
#line 153 "/home/jens/Source/shotwell/vapi/libraw.vapi"
	_tmp0_ = params;
#line 153 "/home/jens/Source/shotwell/vapi/libraw.vapi"
	_tmp1_ = power;
#line 153 "/home/jens/Source/shotwell/vapi/libraw.vapi"
	(*_tmp0_).gamm[0] = 1.0 / _tmp1_;
#line 153 "/home/jens/Source/shotwell/vapi/libraw.vapi"
	_tmp2_ = (*_tmp0_).gamm[0];
#line 154 "/home/jens/Source/shotwell/vapi/libraw.vapi"
	_tmp3_ = params;
#line 154 "/home/jens/Source/shotwell/vapi/libraw.vapi"
	_tmp4_ = slope;
#line 154 "/home/jens/Source/shotwell/vapi/libraw.vapi"
	(*_tmp3_).gamm[1] = _tmp4_;
#line 154 "/home/jens/Source/shotwell/vapi/libraw.vapi"
	_tmp5_ = (*_tmp3_).gamm[1];
#line 1628 "GRaw.c"
}


void graw_processor_configure_for_rgb_display (GRawProcessor* self, gboolean half_size) {
	libraw_output_params_t* _tmp0_;
	libraw_output_params_t* _tmp1_;
	libraw_output_params_t* _tmp2_;
	libraw_output_params_t* _tmp3_;
	libraw_output_params_t* _tmp4_;
	libraw_output_params_t* _tmp5_;
	libraw_output_params_t* _tmp6_;
	libraw_output_params_t* _tmp7_;
	gboolean _tmp8_;
	libraw_output_params_t* _tmp9_;
	libraw_output_params_t* _tmp10_;
	libraw_output_params_t* _tmp11_;
	libraw_output_params_t* _tmp12_;
	libraw_output_params_t* _tmp13_;
	libraw_output_params_t* _tmp14_;
	libraw_output_params_t* _tmp15_;
	libraw_output_params_t* _tmp16_;
	libraw_output_params_t* _tmp17_;
	libraw_output_params_t* _tmp18_;
	libraw_output_params_t* _tmp19_;
	libraw_output_params_t* _tmp20_;
	libraw_output_params_t* _tmp21_;
	libraw_output_params_t* _tmp22_;
	libraw_output_params_t* _tmp23_;
	libraw_output_params_t* _tmp24_;
	libraw_output_params_t* _tmp25_;
	libraw_output_params_t* _tmp26_;
	libraw_output_params_t* _tmp27_;
	libraw_output_params_t* _tmp28_;
	libraw_output_params_t* _tmp29_;
	libraw_output_params_t* _tmp30_;
#line 230 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_if_fail (GRAW_IS_PROCESSOR (self));
#line 235 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = graw_processor_get_output_params (self);
#line 235 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp1_ = _tmp0_;
#line 235 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	lib_raw_output_params_set_chromatic_aberrations (_tmp1_, 1.0, 1.0);
#line 236 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp2_ = graw_processor_get_output_params (self);
#line 236 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp3_ = _tmp2_;
#line 236 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	lib_raw_output_params_set_gamma_curve (_tmp3_, GRAW_SRGB_POWER, GRAW_SRGB_SLOPE);
#line 240 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp4_ = graw_processor_get_output_params (self);
#line 240 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp5_ = _tmp4_;
#line 240 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	(*_tmp5_).bright = 1.0f;
#line 242 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp6_ = graw_processor_get_output_params (self);
#line 242 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp7_ = _tmp6_;
#line 242 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp8_ = half_size;
#line 242 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	(*_tmp7_).half_size = _tmp8_;
#line 244 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp9_ = graw_processor_get_output_params (self);
#line 244 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp10_ = _tmp9_;
#line 244 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	(*_tmp10_).highlight = (gint) GRAW_HIGHLIGHT_MODE_CLIP;
#line 245 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp11_ = graw_processor_get_output_params (self);
#line 245 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp12_ = _tmp11_;
#line 245 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	(*_tmp12_).use_auto_wb = TRUE;
#line 246 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp13_ = graw_processor_get_output_params (self);
#line 246 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp14_ = _tmp13_;
#line 246 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	(*_tmp14_).use_camera_wb = TRUE;
#line 247 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp15_ = graw_processor_get_output_params (self);
#line 247 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp16_ = _tmp15_;
#line 247 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	(*_tmp16_).use_camera_matrix = (gint) GRAW_USE_CAMERA_MATRIX_EMBEDDED_COLOR_PROFILE;
#line 248 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp17_ = graw_processor_get_output_params (self);
#line 248 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp18_ = _tmp17_;
#line 248 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	(*_tmp18_).output_color = (gint) GRAW_COLORSPACE_SRGB;
#line 253 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp19_ = graw_processor_get_output_params (self);
#line 253 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp20_ = _tmp19_;
#line 253 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	(*_tmp20_).output_bps = 8;
#line 255 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp21_ = graw_processor_get_output_params (self);
#line 255 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp22_ = _tmp21_;
#line 255 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	(*_tmp22_).user_flip = (gint) GRAW_FLIP_FROM_SOURCE;
#line 256 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp23_ = graw_processor_get_output_params (self);
#line 256 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp24_ = _tmp23_;
#line 256 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	(*_tmp24_).user_qual = (gint) GRAW_INTERPOLATION_QUALITY_PPG;
#line 260 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp25_ = graw_processor_get_output_params (self);
#line 260 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp26_ = _tmp25_;
#line 260 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	(*_tmp26_).no_auto_bright = TRUE;
#line 261 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp27_ = graw_processor_get_output_params (self);
#line 261 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp28_ = _tmp27_;
#line 261 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	(*_tmp28_).auto_bright_thr = 0.01f;
#line 262 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp29_ = graw_processor_get_output_params (self);
#line 262 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp30_ = _tmp29_;
#line 262 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	(*_tmp30_).use_fuji_rotate = (gint) GRAW_FUJI_ROTATE_USE;
#line 1758 "GRaw.c"
}


libraw_output_params_t* graw_processor_get_output_params (GRawProcessor* self) {
	libraw_output_params_t* result;
	libraw_data_t* _tmp0_;
#line 156 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_val_if_fail (GRAW_IS_PROCESSOR (self), NULL);
#line 157 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = self->priv->proc;
#line 157 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	result = &_tmp0_->params;
#line 157 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return result;
#line 1773 "GRaw.c"
}


static void graw_value_processor_init (GValue* value) {
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	value->data[0].v_pointer = NULL;
#line 1780 "GRaw.c"
}


static void graw_value_processor_free_value (GValue* value) {
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (value->data[0].v_pointer) {
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		graw_processor_unref (value->data[0].v_pointer);
#line 1789 "GRaw.c"
	}
}


static void graw_value_processor_copy_value (const GValue* src_value, GValue* dest_value) {
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (src_value->data[0].v_pointer) {
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		dest_value->data[0].v_pointer = graw_processor_ref (src_value->data[0].v_pointer);
#line 1799 "GRaw.c"
	} else {
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1803 "GRaw.c"
	}
}


static gpointer graw_value_processor_peek_pointer (const GValue* value) {
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return value->data[0].v_pointer;
#line 1811 "GRaw.c"
}


static gchar* graw_value_processor_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (collect_values[0].v_pointer) {
#line 1818 "GRaw.c"
		GRawProcessor * object;
		object = collect_values[0].v_pointer;
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		if (object->parent_instance.g_class == NULL) {
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1825 "GRaw.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1829 "GRaw.c"
		}
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		value->data[0].v_pointer = graw_processor_ref (object);
#line 1833 "GRaw.c"
	} else {
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		value->data[0].v_pointer = NULL;
#line 1837 "GRaw.c"
	}
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return NULL;
#line 1841 "GRaw.c"
}


static gchar* graw_value_processor_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GRawProcessor ** object_p;
	object_p = collect_values[0].v_pointer;
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (!object_p) {
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1852 "GRaw.c"
	}
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (!value->data[0].v_pointer) {
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		*object_p = NULL;
#line 1858 "GRaw.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		*object_p = value->data[0].v_pointer;
#line 1862 "GRaw.c"
	} else {
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		*object_p = graw_processor_ref (value->data[0].v_pointer);
#line 1866 "GRaw.c"
	}
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return NULL;
#line 1870 "GRaw.c"
}


GParamSpec* graw_param_spec_processor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	GRawParamSpecProcessor* spec;
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_val_if_fail (g_type_is_a (object_type, GRAW_TYPE_PROCESSOR), NULL);
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return G_PARAM_SPEC (spec);
#line 1884 "GRaw.c"
}


gpointer graw_value_get_processor (const GValue* value) {
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GRAW_TYPE_PROCESSOR), NULL);
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return value->data[0].v_pointer;
#line 1893 "GRaw.c"
}


void graw_value_set_processor (GValue* value, gpointer v_object) {
	GRawProcessor * old;
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GRAW_TYPE_PROCESSOR));
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	old = value->data[0].v_pointer;
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (v_object) {
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GRAW_TYPE_PROCESSOR));
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		value->data[0].v_pointer = v_object;
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		graw_processor_ref (value->data[0].v_pointer);
#line 1913 "GRaw.c"
	} else {
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		value->data[0].v_pointer = NULL;
#line 1917 "GRaw.c"
	}
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (old) {
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		graw_processor_unref (old);
#line 1923 "GRaw.c"
	}
}


void graw_value_take_processor (GValue* value, gpointer v_object) {
	GRawProcessor * old;
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GRAW_TYPE_PROCESSOR));
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	old = value->data[0].v_pointer;
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (v_object) {
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GRAW_TYPE_PROCESSOR));
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		value->data[0].v_pointer = v_object;
#line 1942 "GRaw.c"
	} else {
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		value->data[0].v_pointer = NULL;
#line 1946 "GRaw.c"
	}
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (old) {
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		graw_processor_unref (old);
#line 1952 "GRaw.c"
	}
}


static void graw_processor_class_init (GRawProcessorClass * klass) {
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	graw_processor_parent_class = g_type_class_peek_parent (klass);
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	((GRawProcessorClass *) klass)->finalize = graw_processor_finalize;
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_type_class_add_private (klass, sizeof (GRawProcessorPrivate));
#line 1964 "GRaw.c"
}


static void graw_processor_instance_init (GRawProcessor * self) {
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	self->priv = GRAW_PROCESSOR_GET_PRIVATE (self);
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	self->ref_count = 1;
#line 1973 "GRaw.c"
}


static void graw_processor_finalize (GRawProcessor * obj) {
	GRawProcessor * self;
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRAW_TYPE_PROCESSOR, GRawProcessor);
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_signal_handlers_destroy (self);
#line 161 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_libraw_close0 (self->priv->proc);
#line 1985 "GRaw.c"
}


GType graw_processor_get_type (void) {
	static volatile gsize graw_processor_type_id__volatile = 0;
	if (g_once_init_enter (&graw_processor_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { graw_value_processor_init, graw_value_processor_free_value, graw_value_processor_copy_value, graw_value_processor_peek_pointer, "p", graw_value_processor_collect_value, "p", graw_value_processor_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GRawProcessorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) graw_processor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GRawProcessor), 0, (GInstanceInitFunc) graw_processor_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType graw_processor_type_id;
		graw_processor_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GRawProcessor", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&graw_processor_type_id__volatile, graw_processor_type_id);
	}
	return graw_processor_type_id__volatile;
}


gpointer graw_processor_ref (gpointer instance) {
	GRawProcessor * self;
	self = instance;
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_atomic_int_inc (&self->ref_count);
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return instance;
#line 2010 "GRaw.c"
}


void graw_processor_unref (gpointer instance) {
	GRawProcessor * self;
	self = instance;
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		GRAW_PROCESSOR_GET_CLASS (self)->finalize (self);
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2023 "GRaw.c"
	}
}


void graw_throw_exception (const gchar* caller, enum LibRaw_errors _result_, GError** error) {
	enum LibRaw_errors _tmp0_;
	gchar* msg = NULL;
	const gchar* _tmp7_;
	enum LibRaw_errors _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	enum LibRaw_errors _tmp11_;
	GError * _inner_error_ = NULL;
#line 266 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_if_fail (caller != NULL);
#line 267 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = _result_;
#line 267 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (_tmp0_ == LIBRAW_SUCCESS) {
#line 268 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		return;
#line 2045 "GRaw.c"
	} else {
		enum LibRaw_errors _tmp1_;
#line 269 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		_tmp1_ = _result_;
#line 269 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		if (_tmp1_ > 0) {
#line 2052 "GRaw.c"
			const gchar* _tmp2_;
			enum LibRaw_errors _tmp3_;
			enum LibRaw_errors _tmp4_;
			const gchar* _tmp5_;
			GError* _tmp6_;
#line 270 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_tmp2_ = caller;
#line 270 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_tmp3_ = _result_;
#line 270 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_tmp4_ = _result_;
#line 270 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_tmp5_ = g_strerror ((gint) _tmp4_);
#line 270 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_tmp6_ = g_error_new (GRAW_EXCEPTION, GRAW_EXCEPTION_SYSTEM_ERROR, "%s: System error %d: %s", _tmp2_, (gint) _tmp3_, _tmp5_);
#line 270 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_inner_error_ = _tmp6_;
#line 270 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 270 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_propagate_error (error, _inner_error_);
#line 270 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				return;
#line 2076 "GRaw.c"
			} else {
#line 270 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 270 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_clear_error (&_inner_error_);
#line 270 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				return;
#line 2084 "GRaw.c"
			}
		}
	}
#line 272 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp7_ = caller;
#line 272 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp8_ = _result_;
#line 272 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp9_ = libraw_strerror (_tmp8_);
#line 272 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp10_ = g_strdup_printf ("%s: %s", _tmp7_, _tmp9_);
#line 272 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	msg = _tmp10_;
#line 274 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp11_ = _result_;
#line 274 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	switch (_tmp11_) {
#line 274 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		case LIBRAW_UNSPECIFIED_ERROR:
#line 2104 "GRaw.c"
		{
			const gchar* _tmp12_;
			GError* _tmp13_;
#line 276 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_tmp12_ = msg;
#line 276 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_tmp13_ = g_error_new_literal (GRAW_EXCEPTION, GRAW_EXCEPTION_UNSPECIFIED, _tmp12_);
#line 276 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_inner_error_ = _tmp13_;
#line 276 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 276 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_propagate_error (error, _inner_error_);
#line 276 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				_g_free0 (msg);
#line 276 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				return;
#line 2122 "GRaw.c"
			} else {
#line 276 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				_g_free0 (msg);
#line 276 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 276 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_clear_error (&_inner_error_);
#line 276 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				return;
#line 2132 "GRaw.c"
			}
		}
#line 274 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		case LIBRAW_FILE_UNSUPPORTED:
#line 2137 "GRaw.c"
		{
			const gchar* _tmp14_;
			GError* _tmp15_;
#line 279 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_tmp14_ = msg;
#line 279 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_tmp15_ = g_error_new_literal (GRAW_EXCEPTION, GRAW_EXCEPTION_UNSUPPORTED_FILE, _tmp14_);
#line 279 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_inner_error_ = _tmp15_;
#line 279 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 279 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_propagate_error (error, _inner_error_);
#line 279 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				_g_free0 (msg);
#line 279 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				return;
#line 2155 "GRaw.c"
			} else {
#line 279 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				_g_free0 (msg);
#line 279 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 279 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_clear_error (&_inner_error_);
#line 279 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				return;
#line 2165 "GRaw.c"
			}
		}
#line 274 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		case LIBRAW_REQUEST_FOR_NONEXISTENT_IMAGE:
#line 2170 "GRaw.c"
		{
			const gchar* _tmp16_;
			GError* _tmp17_;
#line 282 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_tmp16_ = msg;
#line 282 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_tmp17_ = g_error_new_literal (GRAW_EXCEPTION, GRAW_EXCEPTION_NONEXISTANT_IMAGE, _tmp16_);
#line 282 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_inner_error_ = _tmp17_;
#line 282 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 282 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_propagate_error (error, _inner_error_);
#line 282 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				_g_free0 (msg);
#line 282 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				return;
#line 2188 "GRaw.c"
			} else {
#line 282 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				_g_free0 (msg);
#line 282 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 282 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_clear_error (&_inner_error_);
#line 282 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				return;
#line 2198 "GRaw.c"
			}
		}
#line 274 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		case LIBRAW_OUT_OF_ORDER_CALL:
#line 2203 "GRaw.c"
		{
			const gchar* _tmp18_;
			GError* _tmp19_;
#line 285 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_tmp18_ = msg;
#line 285 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_tmp19_ = g_error_new_literal (GRAW_EXCEPTION, GRAW_EXCEPTION_OUT_OF_ORDER_CALL, _tmp18_);
#line 285 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_inner_error_ = _tmp19_;
#line 285 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 285 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_propagate_error (error, _inner_error_);
#line 285 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				_g_free0 (msg);
#line 285 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				return;
#line 2221 "GRaw.c"
			} else {
#line 285 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				_g_free0 (msg);
#line 285 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 285 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_clear_error (&_inner_error_);
#line 285 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				return;
#line 2231 "GRaw.c"
			}
		}
#line 274 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		case LIBRAW_NO_THUMBNAIL:
#line 2236 "GRaw.c"
		{
			const gchar* _tmp20_;
			GError* _tmp21_;
#line 288 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_tmp20_ = msg;
#line 288 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_tmp21_ = g_error_new_literal (GRAW_EXCEPTION, GRAW_EXCEPTION_NO_THUMBNAIL, _tmp20_);
#line 288 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_inner_error_ = _tmp21_;
#line 288 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 288 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_propagate_error (error, _inner_error_);
#line 288 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				_g_free0 (msg);
#line 288 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				return;
#line 2254 "GRaw.c"
			} else {
#line 288 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				_g_free0 (msg);
#line 288 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 288 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_clear_error (&_inner_error_);
#line 288 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				return;
#line 2264 "GRaw.c"
			}
		}
#line 274 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		case LIBRAW_UNSUPPORTED_THUMBNAIL:
#line 2269 "GRaw.c"
		{
			const gchar* _tmp22_;
			GError* _tmp23_;
#line 291 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_tmp22_ = msg;
#line 291 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_tmp23_ = g_error_new_literal (GRAW_EXCEPTION, GRAW_EXCEPTION_UNSUPPORTED_THUMBNAIL, _tmp22_);
#line 291 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_inner_error_ = _tmp23_;
#line 291 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 291 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_propagate_error (error, _inner_error_);
#line 291 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				_g_free0 (msg);
#line 291 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				return;
#line 2287 "GRaw.c"
			} else {
#line 291 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				_g_free0 (msg);
#line 291 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 291 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_clear_error (&_inner_error_);
#line 291 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				return;
#line 2297 "GRaw.c"
			}
		}
#line 274 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		case LIBRAW_UNSUFFICIENT_MEMORY:
#line 2302 "GRaw.c"
		{
			const gchar* _tmp24_;
			GError* _tmp25_;
#line 294 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_tmp24_ = msg;
#line 294 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_tmp25_ = g_error_new_literal (GRAW_EXCEPTION, GRAW_EXCEPTION_OUT_OF_MEMORY, _tmp24_);
#line 294 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_inner_error_ = _tmp25_;
#line 294 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 294 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_propagate_error (error, _inner_error_);
#line 294 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				_g_free0 (msg);
#line 294 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				return;
#line 2320 "GRaw.c"
			} else {
#line 294 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				_g_free0 (msg);
#line 294 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 294 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_clear_error (&_inner_error_);
#line 294 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				return;
#line 2330 "GRaw.c"
			}
		}
#line 274 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		case LIBRAW_DATA_ERROR:
#line 2335 "GRaw.c"
		{
			const gchar* _tmp26_;
			GError* _tmp27_;
#line 297 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_tmp26_ = msg;
#line 297 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_tmp27_ = g_error_new_literal (GRAW_EXCEPTION, GRAW_EXCEPTION_DATA_ERROR, _tmp26_);
#line 297 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_inner_error_ = _tmp27_;
#line 297 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 297 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_propagate_error (error, _inner_error_);
#line 297 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				_g_free0 (msg);
#line 297 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				return;
#line 2353 "GRaw.c"
			} else {
#line 297 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				_g_free0 (msg);
#line 297 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 297 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_clear_error (&_inner_error_);
#line 297 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				return;
#line 2363 "GRaw.c"
			}
		}
#line 274 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		case LIBRAW_IO_ERROR:
#line 2368 "GRaw.c"
		{
			const gchar* _tmp28_;
			GError* _tmp29_;
#line 300 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_tmp28_ = msg;
#line 300 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_tmp29_ = g_error_new_literal (GRAW_EXCEPTION, GRAW_EXCEPTION_IO_ERROR, _tmp28_);
#line 300 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_inner_error_ = _tmp29_;
#line 300 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 300 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_propagate_error (error, _inner_error_);
#line 300 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				_g_free0 (msg);
#line 300 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				return;
#line 2386 "GRaw.c"
			} else {
#line 300 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				_g_free0 (msg);
#line 300 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 300 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_clear_error (&_inner_error_);
#line 300 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				return;
#line 2396 "GRaw.c"
			}
		}
#line 274 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		case LIBRAW_CANCELLED_BY_CALLBACK:
#line 2401 "GRaw.c"
		{
			const gchar* _tmp30_;
			GError* _tmp31_;
#line 303 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_tmp30_ = msg;
#line 303 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_tmp31_ = g_error_new_literal (GRAW_EXCEPTION, GRAW_EXCEPTION_CANCELLED_BY_CALLBACK, _tmp30_);
#line 303 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_inner_error_ = _tmp31_;
#line 303 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 303 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_propagate_error (error, _inner_error_);
#line 303 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				_g_free0 (msg);
#line 303 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				return;
#line 2419 "GRaw.c"
			} else {
#line 303 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				_g_free0 (msg);
#line 303 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 303 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_clear_error (&_inner_error_);
#line 303 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				return;
#line 2429 "GRaw.c"
			}
		}
#line 274 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		case LIBRAW_BAD_CROP:
#line 2434 "GRaw.c"
		{
			const gchar* _tmp32_;
			GError* _tmp33_;
#line 306 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_tmp32_ = msg;
#line 306 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_tmp33_ = g_error_new_literal (GRAW_EXCEPTION, GRAW_EXCEPTION_BAD_CROP, _tmp32_);
#line 306 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_inner_error_ = _tmp33_;
#line 306 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 306 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_propagate_error (error, _inner_error_);
#line 306 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				_g_free0 (msg);
#line 306 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				return;
#line 2452 "GRaw.c"
			} else {
#line 306 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				_g_free0 (msg);
#line 306 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 306 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_clear_error (&_inner_error_);
#line 306 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				return;
#line 2462 "GRaw.c"
			}
		}
		default:
		{
#line 309 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_g_free0 (msg);
#line 309 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return;
#line 2471 "GRaw.c"
		}
	}
#line 266 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_g_free0 (msg);
#line 2476 "GRaw.c"
}



