# Auto-generated by asn1ate v.0.6.1.dev0 from rfc4120.asn1
# (last modified on 2022-05-13 20:03:06.039817)

# KerberosV5Spec2
from pyasn1.type import univ, char, namedtype, namedval, tag, constraint, useful


def _OID(*components):
    output = []
    for x in tuple(components):
        if isinstance(x, univ.ObjectIdentifier):
            output.extend(list(x))
        else:
            output.append(int(x))

    return univ.ObjectIdentifier(output)


class Int32(univ.Integer):
    pass


Int32.subtypeSpec = constraint.ValueRangeConstraint(-2147483648, 2147483647)


class AuthDataType(Int32):
    pass


class AuthorizationData(univ.SequenceOf):
    pass


AuthorizationData.componentType = univ.Sequence(componentType=namedtype.NamedTypes(
    namedtype.NamedType('ad-type', AuthDataType().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.NamedType('ad-data', univ.OctetString().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1)))
))


class AD_AND_OR(univ.Sequence):
    pass


AD_AND_OR.componentType = namedtype.NamedTypes(
    namedtype.NamedType('condition-count', Int32().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.NamedType('elements', AuthorizationData().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1)))
)


class AD_IF_RELEVANT(AuthorizationData):
    pass


class ChecksumType(Int32):
    pass


class Checksum(univ.Sequence):
    pass


Checksum.componentType = namedtype.NamedTypes(
    namedtype.NamedType('cksumtype', ChecksumType().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.NamedType('checksum', univ.OctetString().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1)))
)


class KerberosString(char.GeneralString):
    pass


class NameType(Int32):
    pass


class PrincipalName(univ.Sequence):
    pass


PrincipalName.componentType = namedtype.NamedTypes(
    namedtype.NamedType('name-type', NameType().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.NamedType('name-string', univ.SequenceOf(componentType=KerberosString()).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1)))
)


class Realm(KerberosString):
    pass


class AD_KDCIssued(univ.Sequence):
    pass


AD_KDCIssued.componentType = namedtype.NamedTypes(
    namedtype.NamedType('ad-checksum', Checksum().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 0))),
    namedtype.OptionalNamedType('i-realm', Realm().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.OptionalNamedType('i-sname', PrincipalName().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 2))),
    namedtype.NamedType('elements', AuthorizationData().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 3)))
)


class AD_MANDATORY_FOR_KDC(AuthorizationData):
    pass


class EncryptionType(Int32):
    pass


class UInt32(univ.Integer):
    pass


UInt32.subtypeSpec = constraint.ValueRangeConstraint(0, 4294967295)


class EncryptedData(univ.Sequence):
    pass


EncryptedData.componentType = namedtype.NamedTypes(
    namedtype.NamedType('etype', EncryptionType().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.OptionalNamedType('kvno', Int32().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.NamedType('cipher', univ.OctetString().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 2)))
)


class AP_REP(univ.Sequence):
    pass


AP_REP.tagSet = univ.Sequence.tagSet.tagExplicitly(tag.Tag(tag.tagClassApplication, tag.tagFormatConstructed, 15))
AP_REP.componentType = namedtype.NamedTypes(
    namedtype.NamedType('pvno', univ.Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(5)).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.NamedType('msg-type', univ.Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(15)).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.NamedType('enc-part', EncryptedData().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 2)))
)


class KerberosFlags(univ.BitString):
    pass


KerberosFlags.subtypeSpec=constraint.ValueSizeConstraint(1, 32)


class APOptions(KerberosFlags):
    pass


class Ticket(univ.Sequence):
    pass


Ticket.tagSet = univ.Sequence.tagSet.tagExplicitly(tag.Tag(tag.tagClassApplication, tag.tagFormatConstructed, 1))
Ticket.componentType = namedtype.NamedTypes(
    namedtype.NamedType('tkt-vno', univ.Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(5)).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.NamedType('realm', Realm().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.NamedType('sname', PrincipalName().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 2))),
    namedtype.NamedType('enc-part', EncryptedData().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 3)))
)


class AP_REQ(univ.Sequence):
    pass


AP_REQ.tagSet = univ.Sequence.tagSet.tagExplicitly(tag.Tag(tag.tagClassApplication, tag.tagFormatConstructed, 14))
AP_REQ.componentType = namedtype.NamedTypes(
    namedtype.NamedType('pvno', univ.Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(5)).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.NamedType('msg-type', univ.Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(14)).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.NamedType('ap-options', APOptions().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 2))),
    namedtype.NamedType('ticket', Ticket().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 3))),
    namedtype.NamedType('authenticator', EncryptedData().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 4)))
)


class APOptionsValues(univ.BitString):
    pass


APOptionsValues.namedValues = namedval.NamedValues(
    ('reserved', 0),
    ('use-session-key', 1),
    ('mutual-required', 2)
)


class APOptionsSequence(univ.Sequence):
    pass


APOptionsSequence.componentType = namedtype.NamedTypes(
    namedtype.NamedType('dummy', APOptionsValues().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0)))
)


class PADataType(Int32):
    pass


class PA_DATA(univ.Sequence):
    pass


PA_DATA.componentType = namedtype.NamedTypes(
    namedtype.NamedType('padata-type', PADataType().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.NamedType('padata-value', univ.OctetString().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 2)))
)


class KDC_REP(univ.Sequence):
    pass


KDC_REP.componentType = namedtype.NamedTypes(
    namedtype.NamedType('pvno', univ.Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(5)).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.NamedType('msg-type', univ.Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(11, 13)).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.OptionalNamedType('padata', univ.SequenceOf(componentType=PA_DATA()).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 2))),
    namedtype.NamedType('crealm', Realm().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 3))),
    namedtype.NamedType('cname', PrincipalName().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 4))),
    namedtype.NamedType('ticket', Ticket().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 5))),
    namedtype.NamedType('enc-part', EncryptedData().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 6)))
)


class AS_REP(KDC_REP):
    pass


AS_REP.tagSet = KDC_REP.tagSet.tagExplicitly(tag.Tag(tag.tagClassApplication, tag.tagFormatConstructed, 11))


class HostAddress(univ.Sequence):
    pass


HostAddress.componentType = namedtype.NamedTypes(
    namedtype.NamedType('addr-type', Int32().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.NamedType('address', univ.OctetString().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1)))
)


class HostAddresses(univ.SequenceOf):
    pass


HostAddresses.componentType = HostAddress()


class KDCOptions(KerberosFlags):
    pass


class KerberosTime(useful.GeneralizedTime):
    pass


class KDC_REQ_BODY(univ.Sequence):
    pass


KDC_REQ_BODY.componentType = namedtype.NamedTypes(
    namedtype.NamedType('kdc-options', KDCOptions().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.OptionalNamedType('cname', PrincipalName().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 1))),
    namedtype.NamedType('realm', Realm().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 2))),
    namedtype.OptionalNamedType('sname', PrincipalName().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 3))),
    namedtype.OptionalNamedType('from', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 4))),
    namedtype.NamedType('till', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 5))),
    namedtype.OptionalNamedType('rtime', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 6))),
    namedtype.NamedType('nonce', UInt32().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 7))),
    namedtype.NamedType('etype', univ.SequenceOf(componentType=EncryptionType()).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 8))),
    namedtype.OptionalNamedType('addresses', HostAddresses().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 9))),
    namedtype.OptionalNamedType('enc-authorization-data', EncryptedData().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 10))),
    namedtype.OptionalNamedType('additional-tickets', univ.SequenceOf(componentType=Ticket()).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 11)))
)


class KDC_REQ(univ.Sequence):
    pass


KDC_REQ.componentType = namedtype.NamedTypes(
    namedtype.NamedType('pvno', univ.Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(5)).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.NamedType('msg-type', univ.Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(10, 12)).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 2))),
    namedtype.OptionalNamedType('padata', univ.SequenceOf(componentType=PA_DATA()).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 3))),
    namedtype.NamedType('req-body', KDC_REQ_BODY().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 4)))
)


class AS_REQ(KDC_REQ):
    pass


AS_REQ.tagSet = KDC_REQ.tagSet.tagExplicitly(tag.Tag(tag.tagClassApplication, tag.tagFormatConstructed, 10))


class AuthDataTypeValues(univ.Integer):
    pass


AuthDataTypeValues.namedValues = namedval.NamedValues(
    ('kRB5-AUTHDATA-IF-RELEVANT', 1),
    ('kRB5-AUTHDATA-INTENDED-FOR-SERVER', 2),
    ('kRB5-AUTHDATA-INTENDED-FOR-APPLICATION-CLASS', 3),
    ('kRB5-AUTHDATA-KDC-ISSUED', 4),
    ('kRB5-AUTHDATA-AND-OR', 5),
    ('kRB5-AUTHDATA-MANDATORY-TICKET-EXTENSIONS', 6),
    ('kRB5-AUTHDATA-IN-TICKET-EXTENSIONS', 7),
    ('kRB5-AUTHDATA-MANDATORY-FOR-KDC', 8),
    ('kRB5-AUTHDATA-INITIAL-VERIFIED-CAS', 9),
    ('kRB5-AUTHDATA-OSF-DCE', 64),
    ('kRB5-AUTHDATA-SESAME', 65),
    ('kRB5-AUTHDATA-OSF-DCE-PKI-CERTID', 66),
    ('kRB5-AUTHDATA-WIN2K-PAC', 128),
    ('kRB5-AUTHDATA-GSS-API-ETYPE-NEGOTIATION', 129),
    ('kRB5-AUTHDATA-SIGNTICKET-OLDER', -17),
    ('kRB5-AUTHDATA-SIGNTICKET-OLD', 142),
    ('kRB5-AUTHDATA-SIGNTICKET', 512)
)


class AuthDataTypeSequence(univ.Sequence):
    pass


AuthDataTypeSequence.componentType = namedtype.NamedTypes(
    namedtype.NamedType('dummy', AuthDataTypeValues().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0)))
)


class EncryptionKey(univ.Sequence):
    pass


EncryptionKey.componentType = namedtype.NamedTypes(
    namedtype.NamedType('keytype', EncryptionType().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.NamedType('keyvalue', univ.OctetString().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1)))
)


class Microseconds(univ.Integer):
    pass


Microseconds.subtypeSpec = constraint.ValueRangeConstraint(0, 999999)


class Authenticator(univ.Sequence):
    pass


Authenticator.tagSet = univ.Sequence.tagSet.tagExplicitly(tag.Tag(tag.tagClassApplication, tag.tagFormatConstructed, 2))
Authenticator.componentType = namedtype.NamedTypes(
    namedtype.NamedType('authenticator-vno', univ.Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(5)).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.NamedType('crealm', Realm().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.NamedType('cname', PrincipalName().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 2))),
    namedtype.OptionalNamedType('cksum', Checksum().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 3))),
    namedtype.NamedType('cusec', Microseconds().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 4))),
    namedtype.NamedType('ctime', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 5))),
    namedtype.OptionalNamedType('subkey', EncryptionKey().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 6))),
    namedtype.OptionalNamedType('seq-number', UInt32().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 7))),
    namedtype.OptionalNamedType('authorization-data', AuthorizationData().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 8)))
)


class ChangePasswdDataMS(univ.Sequence):
    pass


ChangePasswdDataMS.componentType = namedtype.NamedTypes(
    namedtype.NamedType('newpasswd', univ.OctetString().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.OptionalNamedType('targname', PrincipalName().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 1))),
    namedtype.OptionalNamedType('targrealm', Realm().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 2)))
)


class ChecksumTypeValues(univ.Integer):
    pass


ChecksumTypeValues.namedValues = namedval.NamedValues(
    ('kRB5-CKSUMTYPE-NONE', 0),
    ('kRB5-CKSUMTYPE-CRC32', 1),
    ('kRB5-CKSUMTYPE-RSA-MD4', 2),
    ('kRB5-CKSUMTYPE-RSA-MD4-DES', 3),
    ('kRB5-CKSUMTYPE-DES-MAC', 4),
    ('kRB5-CKSUMTYPE-DES-MAC-K', 5),
    ('kRB5-CKSUMTYPE-RSA-MD4-DES-K', 6),
    ('kRB5-CKSUMTYPE-RSA-MD5', 7),
    ('kRB5-CKSUMTYPE-RSA-MD5-DES', 8),
    ('kRB5-CKSUMTYPE-RSA-MD5-DES3', 9),
    ('kRB5-CKSUMTYPE-SHA1-OTHER', 10),
    ('kRB5-CKSUMTYPE-HMAC-SHA1-DES3', 12),
    ('kRB5-CKSUMTYPE-SHA1', 14),
    ('kRB5-CKSUMTYPE-HMAC-SHA1-96-AES-128', 15),
    ('kRB5-CKSUMTYPE-HMAC-SHA1-96-AES-256', 16),
    ('kRB5-CKSUMTYPE-GSSAPI', 32771),
    ('kRB5-CKSUMTYPE-HMAC-MD5', -138),
    ('kRB5-CKSUMTYPE-HMAC-MD5-ENC', -1138)
)


class ChecksumTypeSequence(univ.Sequence):
    pass


ChecksumTypeSequence.componentType = namedtype.NamedTypes(
    namedtype.NamedType('dummy', ChecksumTypeValues().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0)))
)


class ETYPE_INFO_ENTRY(univ.Sequence):
    pass


ETYPE_INFO_ENTRY.componentType = namedtype.NamedTypes(
    namedtype.NamedType('etype', EncryptionType().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.OptionalNamedType('salt', univ.OctetString().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1)))
)


class ETYPE_INFO(univ.SequenceOf):
    pass


ETYPE_INFO.componentType = ETYPE_INFO_ENTRY()


class ETYPE_INFO2_ENTRY(univ.Sequence):
    pass


ETYPE_INFO2_ENTRY.componentType = namedtype.NamedTypes(
    namedtype.NamedType('etype', EncryptionType().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.OptionalNamedType('salt', KerberosString().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.OptionalNamedType('s2kparams', univ.OctetString().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 2)))
)


class ETYPE_INFO2(univ.SequenceOf):
    pass


ETYPE_INFO2.componentType = ETYPE_INFO2_ENTRY()
ETYPE_INFO2.subtypeSpec=constraint.ValueSizeConstraint(1, 256)


class EncAPRepPart(univ.Sequence):
    pass


EncAPRepPart.tagSet = univ.Sequence.tagSet.tagExplicitly(tag.Tag(tag.tagClassApplication, tag.tagFormatConstructed, 27))
EncAPRepPart.componentType = namedtype.NamedTypes(
    namedtype.NamedType('ctime', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.NamedType('cusec', Microseconds().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.OptionalNamedType('subkey', EncryptionKey().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 2))),
    namedtype.OptionalNamedType('seq-number', UInt32().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 3)))
)


class LastReq(univ.SequenceOf):
    pass


LastReq.componentType = univ.Sequence(componentType=namedtype.NamedTypes(
    namedtype.NamedType('lr-type', Int32().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.NamedType('lr-value', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1)))
))


class METHOD_DATA(univ.SequenceOf):
    pass


METHOD_DATA.componentType = PA_DATA()


class TicketFlags(KerberosFlags):
    pass


class EncKDCRepPart(univ.Sequence):
    pass


EncKDCRepPart.componentType = namedtype.NamedTypes(
    namedtype.NamedType('key', EncryptionKey().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 0))),
    namedtype.NamedType('last-req', LastReq().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.NamedType('nonce', UInt32().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 2))),
    namedtype.OptionalNamedType('key-expiration', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 3))),
    namedtype.NamedType('flags', TicketFlags().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 4))),
    namedtype.NamedType('authtime', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 5))),
    namedtype.OptionalNamedType('starttime', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 6))),
    namedtype.NamedType('endtime', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 7))),
    namedtype.OptionalNamedType('renew-till', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 8))),
    namedtype.NamedType('srealm', Realm().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 9))),
    namedtype.NamedType('sname', PrincipalName().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 10))),
    namedtype.OptionalNamedType('caddr', HostAddresses().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 11))),
    namedtype.OptionalNamedType('encrypted-pa-data', METHOD_DATA().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 12)))
)


class EncASRepPart(EncKDCRepPart):
    pass


EncASRepPart.tagSet = EncKDCRepPart.tagSet.tagExplicitly(tag.Tag(tag.tagClassApplication, tag.tagFormatConstructed, 25))


class KrbCredInfo(univ.Sequence):
    pass


KrbCredInfo.componentType = namedtype.NamedTypes(
    namedtype.NamedType('key', EncryptionKey().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 0))),
    namedtype.OptionalNamedType('prealm', Realm().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.OptionalNamedType('pname', PrincipalName().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 2))),
    namedtype.OptionalNamedType('flags', TicketFlags().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 3))),
    namedtype.OptionalNamedType('authtime', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 4))),
    namedtype.OptionalNamedType('starttime', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 5))),
    namedtype.OptionalNamedType('endtime', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 6))),
    namedtype.OptionalNamedType('renew-till', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 7))),
    namedtype.OptionalNamedType('srealm', Realm().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 8))),
    namedtype.OptionalNamedType('sname', PrincipalName().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 9))),
    namedtype.OptionalNamedType('caddr', HostAddresses().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 10)))
)


class EncKrbCredPart(univ.Sequence):
    pass


EncKrbCredPart.tagSet = univ.Sequence.tagSet.tagExplicitly(tag.Tag(tag.tagClassApplication, tag.tagFormatConstructed, 29))
EncKrbCredPart.componentType = namedtype.NamedTypes(
    namedtype.NamedType('ticket-info', univ.SequenceOf(componentType=KrbCredInfo()).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.OptionalNamedType('nonce', UInt32().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.OptionalNamedType('timestamp', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 2))),
    namedtype.OptionalNamedType('usec', Microseconds().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 3))),
    namedtype.OptionalNamedType('s-address', HostAddress().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 4))),
    namedtype.OptionalNamedType('r-address', HostAddress().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 5)))
)


class EncKrbPrivPart(univ.Sequence):
    pass


EncKrbPrivPart.tagSet = univ.Sequence.tagSet.tagExplicitly(tag.Tag(tag.tagClassApplication, tag.tagFormatConstructed, 28))
EncKrbPrivPart.componentType = namedtype.NamedTypes(
    namedtype.NamedType('user-data', univ.OctetString().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.OptionalNamedType('timestamp', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.OptionalNamedType('usec', Microseconds().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 2))),
    namedtype.OptionalNamedType('seq-number', UInt32().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 3))),
    namedtype.NamedType('s-address', HostAddress().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 4))),
    namedtype.OptionalNamedType('r-address', HostAddress().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 5)))
)


class EncTGSRepPart(EncKDCRepPart):
    pass


EncTGSRepPart.tagSet = EncKDCRepPart.tagSet.tagExplicitly(tag.Tag(tag.tagClassApplication, tag.tagFormatConstructed, 26))


class TransitedEncoding(univ.Sequence):
    pass


TransitedEncoding.componentType = namedtype.NamedTypes(
    namedtype.NamedType('tr-type', Int32().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.NamedType('contents', univ.OctetString().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1)))
)


class EncTicketPart(univ.Sequence):
    pass


EncTicketPart.tagSet = univ.Sequence.tagSet.tagExplicitly(tag.Tag(tag.tagClassApplication, tag.tagFormatConstructed, 3))
EncTicketPart.componentType = namedtype.NamedTypes(
    namedtype.NamedType('flags', TicketFlags().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.NamedType('key', EncryptionKey().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 1))),
    namedtype.NamedType('crealm', Realm().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 2))),
    namedtype.NamedType('cname', PrincipalName().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 3))),
    namedtype.NamedType('transited', TransitedEncoding().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 4))),
    namedtype.NamedType('authtime', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 5))),
    namedtype.OptionalNamedType('starttime', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 6))),
    namedtype.NamedType('endtime', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 7))),
    namedtype.OptionalNamedType('renew-till', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 8))),
    namedtype.OptionalNamedType('caddr', HostAddresses().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 9))),
    namedtype.OptionalNamedType('authorization-data', AuthorizationData().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 10)))
)


class EncryptionTypeValues(univ.Integer):
    pass


EncryptionTypeValues.namedValues = namedval.NamedValues(
    ('kRB5-ENCTYPE-NULL', 0),
    ('kRB5-ENCTYPE-DES-CBC-CRC', 1),
    ('kRB5-ENCTYPE-DES-CBC-MD4', 2),
    ('kRB5-ENCTYPE-DES-CBC-MD5', 3),
    ('kRB5-ENCTYPE-DES3-CBC-MD5', 5),
    ('kRB5-ENCTYPE-OLD-DES3-CBC-SHA1', 7),
    ('kRB5-ENCTYPE-SIGN-DSA-GENERATE', 8),
    ('kRB5-ENCTYPE-ENCRYPT-RSA-PRIV', 9),
    ('kRB5-ENCTYPE-ENCRYPT-RSA-PUB', 10),
    ('kRB5-ENCTYPE-DES3-CBC-SHA1', 16),
    ('kRB5-ENCTYPE-AES128-CTS-HMAC-SHA1-96', 17),
    ('kRB5-ENCTYPE-AES256-CTS-HMAC-SHA1-96', 18),
    ('kRB5-ENCTYPE-ARCFOUR-HMAC-MD5', 23),
    ('kRB5-ENCTYPE-ARCFOUR-HMAC-MD5-56', 24),
    ('kRB5-ENCTYPE-ENCTYPE-PK-CROSS', 48),
    ('kRB5-ENCTYPE-ARCFOUR-MD4', -128),
    ('kRB5-ENCTYPE-ARCFOUR-HMAC-OLD', -133),
    ('kRB5-ENCTYPE-ARCFOUR-HMAC-OLD-EXP', -135),
    ('kRB5-ENCTYPE-DUMMY', -1111)
)


class EncryptionTypeSequence(univ.Sequence):
    pass


EncryptionTypeSequence.componentType = namedtype.NamedTypes(
    namedtype.NamedType('dummy', EncryptionTypeValues().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0)))
)


class FastOptions(univ.BitString):
    pass


FastOptions.namedValues = namedval.NamedValues(
    ('reserved', 0),
    ('hide-client-names', 1),
    ('kdc-follow-referrals', 16)
)


class KDCOptionsValues(univ.BitString):
    pass


KDCOptionsValues.namedValues = namedval.NamedValues(
    ('reserved', 0),
    ('forwardable', 1),
    ('forwarded', 2),
    ('proxiable', 3),
    ('proxy', 4),
    ('allow-postdate', 5),
    ('postdated', 6),
    ('unused7', 7),
    ('renewable', 8),
    ('unused9', 9),
    ('unused10', 10),
    ('opt-hardware-auth', 11),
    ('unused12', 12),
    ('unused13', 13),
    ('cname-in-addl-tkt', 14),
    ('canonicalize', 15),
    ('disable-transited-check', 26),
    ('renewable-ok', 27),
    ('enc-tkt-in-skey', 28),
    ('renew', 30),
    ('validate', 31)
)


class KDCOptionsSequence(univ.Sequence):
    pass


KDCOptionsSequence.componentType = namedtype.NamedTypes(
    namedtype.NamedType('dummy', KDCOptionsValues().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0)))
)


class KERB_AD_RESTRICTION_ENTRY(univ.Sequence):
    pass


KERB_AD_RESTRICTION_ENTRY.componentType = namedtype.NamedTypes(
    namedtype.NamedType('restriction-type', Int32().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.NamedType('restriction', univ.OctetString().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1)))
)


class KerbErrorDataType(univ.Integer):
    pass


class KERB_ERROR_DATA(univ.Sequence):
    pass


KERB_ERROR_DATA.componentType = namedtype.NamedTypes(
    namedtype.NamedType('data-type', KerbErrorDataType().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.OptionalNamedType('data-value', univ.OctetString().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 2)))
)


class KERB_KEY_LIST_REP(univ.SequenceOf):
    pass


KERB_KEY_LIST_REP.componentType = EncryptionKey()


class KERB_KEY_LIST_REQ(univ.SequenceOf):
    pass


KERB_KEY_LIST_REQ.componentType = EncryptionType()


class KERB_LOCAL(univ.OctetString):
    pass


class KERB_PA_PAC_REQUEST(univ.Sequence):
    pass


KERB_PA_PAC_REQUEST.componentType = namedtype.NamedTypes(
    namedtype.NamedType('include-pac', univ.Boolean().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0)))
)


class KRB_CRED(univ.Sequence):
    pass


KRB_CRED.tagSet = univ.Sequence.tagSet.tagExplicitly(tag.Tag(tag.tagClassApplication, tag.tagFormatConstructed, 22))
KRB_CRED.componentType = namedtype.NamedTypes(
    namedtype.NamedType('pvno', univ.Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(5)).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.NamedType('msg-type', univ.Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(22)).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.NamedType('tickets', univ.SequenceOf(componentType=Ticket()).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 2))),
    namedtype.NamedType('enc-part', EncryptedData().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 3)))
)


class KRB_ERROR(univ.Sequence):
    pass


KRB_ERROR.tagSet = univ.Sequence.tagSet.tagExplicitly(tag.Tag(tag.tagClassApplication, tag.tagFormatConstructed, 30))
KRB_ERROR.componentType = namedtype.NamedTypes(
    namedtype.NamedType('pvno', univ.Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(5)).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.NamedType('msg-type', univ.Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(30)).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.OptionalNamedType('ctime', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 2))),
    namedtype.OptionalNamedType('cusec', Microseconds().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 3))),
    namedtype.NamedType('stime', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 4))),
    namedtype.NamedType('susec', Microseconds().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 5))),
    namedtype.NamedType('error-code', Int32().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 6))),
    namedtype.OptionalNamedType('crealm', Realm().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 7))),
    namedtype.OptionalNamedType('cname', PrincipalName().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 8))),
    namedtype.NamedType('realm', Realm().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 9))),
    namedtype.NamedType('sname', PrincipalName().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 10))),
    namedtype.OptionalNamedType('e-text', KerberosString().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 11))),
    namedtype.OptionalNamedType('e-data', univ.OctetString().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 12)))
)


class KRB_PRIV(univ.Sequence):
    pass


KRB_PRIV.tagSet = univ.Sequence.tagSet.tagExplicitly(tag.Tag(tag.tagClassApplication, tag.tagFormatConstructed, 21))
KRB_PRIV.componentType = namedtype.NamedTypes(
    namedtype.NamedType('pvno', univ.Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(5)).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.NamedType('msg-type', univ.Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(21)).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.NamedType('enc-part', EncryptedData().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 3)))
)


class KRB_SAFE_BODY(univ.Sequence):
    pass


KRB_SAFE_BODY.componentType = namedtype.NamedTypes(
    namedtype.NamedType('user-data', univ.OctetString().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.OptionalNamedType('timestamp', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.OptionalNamedType('usec', Microseconds().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 2))),
    namedtype.OptionalNamedType('seq-number', UInt32().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 3))),
    namedtype.NamedType('s-address', HostAddress().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 4))),
    namedtype.OptionalNamedType('r-address', HostAddress().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 5)))
)


class KRB_SAFE(univ.Sequence):
    pass


KRB_SAFE.tagSet = univ.Sequence.tagSet.tagExplicitly(tag.Tag(tag.tagClassApplication, tag.tagFormatConstructed, 20))
KRB_SAFE.componentType = namedtype.NamedTypes(
    namedtype.NamedType('pvno', univ.Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(5)).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.NamedType('msg-type', univ.Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(20)).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.NamedType('safe-body', KRB_SAFE_BODY().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 2))),
    namedtype.NamedType('cksum', Checksum().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 3)))
)


class KerbErrorDataTypeValues(univ.Integer):
    pass


KerbErrorDataTypeValues.namedValues = namedval.NamedValues(
    ('kERB-AP-ERR-TYPE-SKEW-RECOVERY', 2),
    ('kERB-ERR-TYPE-EXTENDED', 3)
)


class KerbErrorDataTypeSequence(univ.Sequence):
    pass


KerbErrorDataTypeSequence.componentType = namedtype.NamedTypes(
    namedtype.NamedType('dummy', KerbErrorDataTypeValues().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0)))
)


class KrbFastArmor(univ.Sequence):
    pass


KrbFastArmor.componentType = namedtype.NamedTypes(
    namedtype.NamedType('armor-type', Int32().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.NamedType('armor-value', univ.OctetString().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1)))
)


class KrbFastArmoredRep(univ.Sequence):
    pass


KrbFastArmoredRep.componentType = namedtype.NamedTypes(
    namedtype.NamedType('enc-fast-rep', EncryptedData().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 0)))
)


class KrbFastArmoredReq(univ.Sequence):
    pass


KrbFastArmoredReq.componentType = namedtype.NamedTypes(
    namedtype.OptionalNamedType('armor', KrbFastArmor().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 0))),
    namedtype.NamedType('req-checksum', Checksum().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 1))),
    namedtype.NamedType('enc-fast-req', EncryptedData().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 2)))
)


class KrbFastFinished(univ.Sequence):
    pass


KrbFastFinished.componentType = namedtype.NamedTypes(
    namedtype.NamedType('timestamp', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.NamedType('usec', Int32().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.NamedType('crealm', Realm().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 2))),
    namedtype.NamedType('cname', PrincipalName().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 3))),
    namedtype.NamedType('ticket-checksum', Checksum().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 4)))
)


class KrbFastReq(univ.Sequence):
    pass


KrbFastReq.componentType = namedtype.NamedTypes(
    namedtype.NamedType('fast-options', FastOptions().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.NamedType('padata', univ.SequenceOf(componentType=PA_DATA()).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.NamedType('req-body', KDC_REQ_BODY().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 2)))
)


class KrbFastResponse(univ.Sequence):
    pass


KrbFastResponse.componentType = namedtype.NamedTypes(
    namedtype.NamedType('padata', univ.SequenceOf(componentType=PA_DATA()).subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.OptionalNamedType('strengthen-key', EncryptionKey().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 1))),
    namedtype.OptionalNamedType('finished', KrbFastFinished().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 2))),
    namedtype.NamedType('nonce', UInt32().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 3)))
)


class MessageTypeValues(univ.Integer):
    pass


MessageTypeValues.namedValues = namedval.NamedValues(
    ('krb-as-req', 10),
    ('krb-as-rep', 11),
    ('krb-tgs-req', 12),
    ('krb-tgs-rep', 13),
    ('krb-ap-req', 14),
    ('krb-ap-rep', 15),
    ('krb-safe', 20),
    ('krb-priv', 21),
    ('krb-cred', 22),
    ('krb-error', 30)
)


class MessageTypeSequence(univ.Sequence):
    pass


MessageTypeSequence.componentType = namedtype.NamedTypes(
    namedtype.NamedType('dummy', MessageTypeValues().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0)))
)


class NameTypeValues(univ.Integer):
    pass


NameTypeValues.namedValues = namedval.NamedValues(
    ('kRB5-NT-UNKNOWN', 0),
    ('kRB5-NT-PRINCIPAL', 1),
    ('kRB5-NT-SRV-INST', 2),
    ('kRB5-NT-SRV-HST', 3),
    ('kRB5-NT-SRV-XHST', 4),
    ('kRB5-NT-UID', 5),
    ('kRB5-NT-X500-PRINCIPAL', 6),
    ('kRB5-NT-SMTP-NAME', 7),
    ('kRB5-NT-ENTERPRISE-PRINCIPAL', 10),
    ('kRB5-NT-WELLKNOWN', 11),
    ('kRB5-NT-ENT-PRINCIPAL-AND-ID', -130),
    ('kRB5-NT-MS-PRINCIPAL', -128),
    ('kRB5-NT-MS-PRINCIPAL-AND-ID', -129)
)


class NameTypeSequence(univ.Sequence):
    pass


NameTypeSequence.componentType = namedtype.NamedTypes(
    namedtype.NamedType('dummy', NameTypeValues().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0)))
)


class PA_ENC_TIMESTAMP(EncryptedData):
    pass


class PA_ENC_TS_ENC(univ.Sequence):
    pass


PA_ENC_TS_ENC.componentType = namedtype.NamedTypes(
    namedtype.NamedType('patimestamp', KerberosTime().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.OptionalNamedType('pausec', Microseconds().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1)))
)


class PA_FX_FAST_REPLY(univ.Choice):
    pass


PA_FX_FAST_REPLY.componentType = namedtype.NamedTypes(
    namedtype.NamedType('armored-data', KrbFastArmoredRep().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 0)))
)


class PA_FX_FAST_REQUEST(univ.Choice):
    pass


PA_FX_FAST_REQUEST.componentType = namedtype.NamedTypes(
    namedtype.NamedType('armored-data', KrbFastArmoredReq().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 0)))
)


class PACOptionFlags(KerberosFlags):
    pass


class PA_PAC_OPTIONS(univ.Sequence):
    pass


PA_PAC_OPTIONS.componentType = namedtype.NamedTypes(
    namedtype.NamedType('options', PACOptionFlags().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0)))
)


class PA_S4U2Self(univ.Sequence):
    pass


PA_S4U2Self.componentType = namedtype.NamedTypes(
    namedtype.NamedType('name', PrincipalName().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 0))),
    namedtype.NamedType('realm', Realm().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1))),
    namedtype.NamedType('cksum', Checksum().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatConstructed, 2))),
    namedtype.NamedType('auth', KerberosString().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 3)))
)


class PA_SUPPORTED_ENCTYPES(Int32):
    pass


class PACOptionFlagsValues(univ.BitString):
    pass


PACOptionFlagsValues.namedValues = namedval.NamedValues(
    ('claims', 0),
    ('branch-aware', 1),
    ('forward-to-full-dc', 2),
    ('resource-based-constrained-delegation', 3)
)


class PACOptionFlagsSequence(univ.Sequence):
    pass


PACOptionFlagsSequence.componentType = namedtype.NamedTypes(
    namedtype.NamedType('dummy', PACOptionFlagsValues().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0)))
)


class PADataTypeValues(univ.Integer):
    pass


PADataTypeValues.namedValues = namedval.NamedValues(
    ('kRB5-PADATA-NONE', 0),
    ('kRB5-PADATA-KDC-REQ', 1),
    ('kRB5-PADATA-ENC-TIMESTAMP', 2),
    ('kRB5-PADATA-PW-SALT', 3),
    ('kRB5-PADATA-ENC-UNIX-TIME', 5),
    ('kRB5-PADATA-SANDIA-SECUREID', 6),
    ('kRB5-PADATA-SESAME', 7),
    ('kRB5-PADATA-OSF-DCE', 8),
    ('kRB5-PADATA-CYBERSAFE-SECUREID', 9),
    ('kRB5-PADATA-AFS3-SALT', 10),
    ('kRB5-PADATA-ETYPE-INFO', 11),
    ('kRB5-PADATA-SAM-CHALLENGE', 12),
    ('kRB5-PADATA-SAM-RESPONSE', 13),
    ('kRB5-PADATA-PK-AS-REQ-19', 14),
    ('kRB5-PADATA-PK-AS-REP-19', 15),
    ('kRB5-PADATA-PK-AS-REQ', 16),
    ('kRB5-PADATA-PK-AS-REP', 17),
    ('kRB5-PADATA-PA-PK-OCSP-RESPONSE', 18),
    ('kRB5-PADATA-ETYPE-INFO2', 19),
    ('kRB5-PADATA-SVR-REFERRAL-INFO', 20),
    ('kRB5-PADATA-SAM-REDIRECT', 21),
    ('kRB5-PADATA-GET-FROM-TYPED-DATA', 22),
    ('kRB5-PADATA-SAM-ETYPE-INFO', 23),
    ('kRB5-PADATA-SERVER-REFERRAL', 25),
    ('kRB5-PADATA-ALT-PRINC', 24),
    ('kRB5-PADATA-SAM-CHALLENGE2', 30),
    ('kRB5-PADATA-SAM-RESPONSE2', 31),
    ('kRB5-PA-EXTRA-TGT', 41),
    ('kRB5-PADATA-TD-KRB-PRINCIPAL', 102),
    ('kRB5-PADATA-PK-TD-TRUSTED-CERTIFIERS', 104),
    ('kRB5-PADATA-PK-TD-CERTIFICATE-INDEX', 105),
    ('kRB5-PADATA-TD-APP-DEFINED-ERROR', 106),
    ('kRB5-PADATA-TD-REQ-NONCE', 107),
    ('kRB5-PADATA-TD-REQ-SEQ', 108),
    ('kRB5-PADATA-PA-PAC-REQUEST', 128),
    ('kRB5-PADATA-FOR-USER', 129),
    ('kRB5-PADATA-FOR-X509-USER', 130),
    ('kRB5-PADATA-FOR-CHECK-DUPS', 131),
    ('kRB5-PADATA-AS-CHECKSUM', 132),
    ('kRB5-PADATA-FX-COOKIE', 133),
    ('kRB5-PADATA-AUTHENTICATION-SET', 134),
    ('kRB5-PADATA-AUTH-SET-SELECTED', 135),
    ('kRB5-PADATA-FX-FAST', 136),
    ('kRB5-PADATA-FX-ERROR', 137),
    ('kRB5-PADATA-ENCRYPTED-CHALLENGE', 138),
    ('kRB5-PADATA-OTP-CHALLENGE', 141),
    ('kRB5-PADATA-OTP-REQUEST', 142),
    ('kBB5-PADATA-OTP-CONFIRM', 143),
    ('kRB5-PADATA-OTP-PIN-CHANGE', 144),
    ('kRB5-PADATA-EPAK-AS-REQ', 145),
    ('kRB5-PADATA-EPAK-AS-REP', 146),
    ('kRB5-PADATA-PKINIT-KX', 147),
    ('kRB5-PADATA-PKU2U-NAME', 148),
    ('kRB5-PADATA-REQ-ENC-PA-REP', 149),
    ('kRB5-PADATA-SUPPORTED-ETYPES', 165),
    ('kRB5-PADATA-PAC-OPTIONS', 167)
)


class PADataTypeSequence(univ.Sequence):
    pass


PADataTypeSequence.componentType = namedtype.NamedTypes(
    namedtype.NamedType('dummy', PADataTypeValues().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0)))
)


class TGS_REP(KDC_REP):
    pass


TGS_REP.tagSet = KDC_REP.tagSet.tagExplicitly(tag.Tag(tag.tagClassApplication, tag.tagFormatConstructed, 13))


class TGS_REQ(KDC_REQ):
    pass


TGS_REQ.tagSet = KDC_REQ.tagSet.tagExplicitly(tag.Tag(tag.tagClassApplication, tag.tagFormatConstructed, 12))


class TYPED_DATA(univ.SequenceOf):
    pass


TYPED_DATA.componentType = univ.Sequence(componentType=namedtype.NamedTypes(
    namedtype.NamedType('data-type', Int32().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0))),
    namedtype.OptionalNamedType('data-value', univ.OctetString().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 1)))
))

TYPED_DATA.subtypeSpec=constraint.ValueSizeConstraint(1, 256)


class TicketFlagsValues(univ.BitString):
    pass


TicketFlagsValues.namedValues = namedval.NamedValues(
    ('reserved', 0),
    ('forwardable', 1),
    ('forwarded', 2),
    ('proxiable', 3),
    ('proxy', 4),
    ('may-postdate', 5),
    ('postdated', 6),
    ('invalid', 7),
    ('renewable', 8),
    ('initial', 9),
    ('pre-authent', 10),
    ('hw-authent', 11),
    ('transited-policy-checked', 12),
    ('ok-as-delegate', 13)
)


class TicketFlagsSequence(univ.Sequence):
    pass


TicketFlagsSequence.componentType = namedtype.NamedTypes(
    namedtype.NamedType('dummy', TicketFlagsValues().subtype(explicitTag=tag.Tag(tag.tagClassContext, tag.tagFormatSimple, 0)))
)


id_krb5 = _OID(1, 3, 6, 1, 5, 2)


