# 0.0.17

**Version:** 0.0.17
**Published:** 2023-01-21T11:41:45Z

## Release Notes

## Highlights

* The minimum supported Rust version is now 1.60.
* Clap has been updated to version 4, bringing some changes in the formatting of help strings.
* `cp` has been gotten many small improvements that improve compatibility.
* `dd` has been simplified and has better compatibility.
* `env` now reraises signals from the child process.
* `ls -l` now shows more information on Windows.
* `uname` is now available for all supported platforms, instead of Unix-like platforms only.
* `cp` and `mv` can display a progress bar. This is an extension over GNU coreutils and inspired by [`advcpmv`](https://github.com/jarun/advcpmv).
* There have been refactors, fixes and performance improvements in many utils, see below for details.

## GNU test suite compatibility

Many utils have gotten minor changes to improve GNU compatibility. Below is a summary of the progress. See https://github.com/uutils/coreutils-tracking/ for more details

| result | 0.0.16 | 0.0.17 | change |
|--------|-------:|-------:|-------:|
| pass   |    322 |    338 |    +16 |
| skip   |     49 |     48 |     -1 |
| fail   |    217 |    204 |    -13 |
| error  |      5 |      3 |     -2 |

## Changes

The PR's listed below are a selection of all the contributions in this release.

### General

* Bump MSRV to 1.60 by @tertsdiepraam in https://github.com/uutils/coreutils/pull/3994
* Clap 4 by @tertsdiepraam in https://github.com/uutils/coreutils/pull/3991
* Migrate from `winapi` to `windows-sys` by @niyaznigmatullin in https://github.com/uutils/coreutils/pull/4065
* Run the toybox testsuite by @sylvestre in https://github.com/uutils/coreutils/pull/4222
* Use normal use declarations to import macros by @miles170 in https://github.com/uutils/coreutils/pull/4151
* Add installation page to docs with package managers by @tertsdiepraam in https://github.com/uutils/coreutils/pull/4048
* Test utilities
  * Add `UChild`, an abstraction for `std::process::Child` by @Joining7943 in https://github.com/uutils/coreutils/pull/4136
  * Add possibility to set timeout for UCommand and UChild. Add `rstest` with timeout macro to dev dependencies by @Joining7943 in https://github.com/uutils/coreutils/pull/4231
  * Put `#[track_caller]` on assertion functions in test utils by @tertsdiepraam in https://github.com/uutils/coreutils/pull/4252
* `uucore`
  * Add automatic conversion for `nix::Errno` by @orhun in https://github.com/uutils/coreutils/pull/4060
  * Add `prompt_yes` macro by @tertsdiepraam in https://github.com/uutils/coreutils/pull/4148
  * Add `sprintf()` function by @jfinkels in https://github.com/uutils/coreutils/pull/4185
  * Add options to parse_size::Parser by @trasua in https://github.com/uutils/coreutils/pull/4224

### `chown`
* Fails when `XXXX.` or `XXXX:` is provided (when XXXX is numeric value) by @sylvestre in https://github.com/uutils/coreutils/pull/4081

### `cp`
* Move `copy_directory()` to its own module by @jfinkels in https://github.com/uutils/coreutils/pull/3901
* Correctly copy ancestor dirs in `--parents` mode by @jfinkels in https://github.com/uutils/coreutils/pull/4071
* `cp -i --update source existing` should not do anything and exit 0 by @sylvestre in https://github.com/uutils/coreutils/pull/4078
* Implement `--copy-contents` option for fifos by @jfinkels in https://github.com/uutils/coreutils/pull/3978
* Remove interactive mode message on 'no' by @sssemil in https://github.com/uutils/coreutils/pull/4069
* Use sparse copy on `--sparse=always` by @jfinkels in https://github.com/uutils/coreutils/pull/4030
* Add progress bar by @tertsdiepraam in https://github.com/uutils/coreutils/pull/3903 and improved by @djedi23 in https://github.com/uutils/coreutils/pull/4179 and @ctsk in https://github.com/uutils/coreutils/pull/4221
* Restrict copy through dangling symlink with `-f` by @jfinkels in https://github.com/uutils/coreutils/pull/4074
* Force copying file to itself with `--backup` by @jfinkels in https://github.com/uutils/coreutils/pull/3966
* Make `--preserve` use the defaults when empty by @sssemil in https://github.com/uutils/coreutils/pull/4123
* Fix `cp --force --backup f f` fails on macOS by @miles170 in https://github.com/uutils/coreutils/pull/4166
* Preserve hard links when target already exists by @jfinkels in https://github.com/uutils/coreutils/pull/4208
* Fix `--verbose --parents` output for both files and directories by @jfinkels in https://github.com/uutils/coreutils/pull/4184
* Force link between two files that exist by @jfinkels in https://github.com/uutils/coreutils/pull/4213
* Remove empty line from version output by @cakebaker in https://github.com/uutils/coreutils/pull/4283
* Require preserve only certain attributes by @sssemil in https://github.com/uutils/coreutils/pull/4099
* Restrict permissions when copying FIFO by @jfinkels in https://github.com/uutils/coreutils/pull/4211

### `csplit`
* Rename var to simplify format strings by @cakebaker in https://github.com/uutils/coreutils/pull/4266

### `cut`
* Add whitespace option for separating fields by @TechHara in https://github.com/uutils/coreutils/pull/4232

### `date`
* Catch panic from invalid format string by @jaggededgedjustice in https://github.com/uutils/coreutils/pull/4240

### `dd`
* Allow B as a suffix for count, seek, and skip by @jfinkels in https://github.com/uutils/coreutils/pull/4137
* Create Dest enum and simpler Output struct by @jfinkels in https://github.com/uutils/coreutils/pull/4134
* Don't allocate buffer if count=0 by @jfinkels in https://github.com/uutils/coreutils/pull/4130
* Correctly set file size when conv=sparse by @jfinkels in https://github.com/uutils/coreutils/pull/4191
* Fix rendering of SI and IEC byte counts by @jfinkels in https://github.com/uutils/coreutils/pull/3653
* Fix progress line if 1 byte written by @jfinkels in https://github.com/uutils/coreutils/pull/4194

### `env`
* Reraise signal from child process by @tertsdiepraam in https://github.com/uutils/coreutils/pull/4011

### `expr`
* Multiple fixes and tests added by @rivy in https://github.com/uutils/coreutils/pull/4248

### `factor`
* Trim the input to fix some busybox results by @sylvestre in https://github.com/uutils/coreutils/pull/4215

### `hashsum`
* Warn on file not found rather than fail by @dmatos2012 in https://github.com/uutils/coreutils/pull/4064
* Enable testing `--no-names` by @tertsdiepraam and @huijeong-kim in https://github.com/uutils/coreutils/pull/4088

### `install`
* No longer fails when target directory does not exist by @bruecke in https://github.com/uutils/coreutils/pull/3950

### `ls`
* Show more info in long format on Windows by @tertsdiepraam in https://github.com/uutils/coreutils/pull/4014
* Use `libc::{major, minor}` to calculate device number by @SteveLauC in https://github.com/uutils/coreutils/pull/4120

### `mktemp`
* Allow default missing value by @dmatos2012 in https://github.com/uutils/coreutils/pull/4091

### `mv`
* `mv -i --update source existing` should not do anything and exit 0 by @sylvestre in https://github.com/uutils/coreutils/pull/4078
* Add progress bar by @ctsk in https://github.com/uutils/coreutils/pull/4220

### `numfmt`
* Handle negative zero values by @cakebaker in https://github.com/uutils/coreutils/pull/4076
* Allow hyphen values for `--field` option by @cakebaker in https://github.com/uutils/coreutils/pull/4090
* Round values if precision is 0 by @cakebaker in https://github.com/uutils/coreutils/pull/4089
* Allow `-` in field list by @cakebaker in https://github.com/uutils/coreutils/pull/4094
* Allow ` ` as field separator by @cakebaker in https://github.com/uutils/coreutils/pull/4096
* Add test for `--field -` (all fields) by @cakebaker in https://github.com/uutils/coreutils/pull/4093

### `pr`
* Simplify format strings by @cakebaker in https://github.com/uutils/coreutils/pull/4264
* Add missing `\` before line breaks by @cakebaker in https://github.com/uutils/coreutils/pull/4273

### `printenv`
* Weird env variable names should trigger an error. by @sylvestre in https://github.com/uutils/coreutils/pull/4113

### `pwd`
* Support the env variable `POSIXLY_CORRECT` by @sylvestre in https://github.com/uutils/coreutils/pull/4085

### `rm`
* GNU test `rm3` now passes by @palaster in https://github.com/uutils/coreutils/pull/4013

### `seq`
* Simplify format strings by @cakebaker in https://github.com/uutils/coreutils/pull/4264

### `sleep`
* Fix argument parsing and errors by @rivy in https://github.com/uutils/coreutils/pull/4268

### `sort`
* Allow a sort mode to appear multiple times by @tertsdiepraam in https://github.com/uutils/coreutils/pull/4132

### `split`
* Implement round-robin arg to `--number` by @jfinkels in https://github.com/uutils/coreutils/pull/3281
* Match GNU semantics for missing EOF by @andrewbaptist in https://github.com/uutils/coreutils/pull/4009
* Fix "backticks are unbalanced" warnings by @cakebaker in https://github.com/uutils/coreutils/pull/4181

### `stat`
* Show more info in long format on Windows by @tertsdiepraam in https://github.com/uutils/coreutils/pull/4014
* Refactor by @tertsdiepraam in https://github.com/uutils/coreutils/pull/4150

### `sum`
* Fix output of about string by @cakebaker in https://github.com/uutils/coreutils/pull/4274
* Fix output when using BSD sum algo (-r) by @cakebaker in https://github.com/uutils/coreutils/pull/4278

### `tail`
* Refactor handling of warnings and early exits by @Joining7943 in https://github.com/uutils/coreutils/pull/4135

### `touch`
* Add support for some relative times by @jfinkels in https://github.com/uutils/coreutils/pull/4193

### `uname`
* build: `uname` is WinOS-compatible; move to 'Tier1' feature by @rivy in https://github.com/uutils/coreutils/pull/4245
* change/uname ~ update and revise by @rivy in https://github.com/uutils/coreutils/pull/4279

## New Contributors
@huijeong-kim (https://github.com/uutils/coreutils/pull/4027), @orhun (https://github.com/uutils/coreutils/pull/4070), @SteveLauC (https://github.com/uutils/coreutils/pull/4120), @miles170 (https://github.com/uutils/coreutils/pull/4151), @djedi23 (https://github.com/uutils/coreutils/pull/4179), @bruecke (https://github.com/uutils/coreutils/pull/3950), @ctsk (https://github.com/uutils/coreutils/pull/4221), @trasua (https://github.com/uutils/coreutils/pull/4224), @TechHara (https://github.com/uutils/coreutils/pull/4232)

**Full Changelog**: https://github.com/uutils/coreutils/compare/0.0.16...0.0.17
