RabbitMQ `3.9.9` is a maintenance release in the `3.9.x` release series.

Please refer to the **Upgrading to 3.9** section from [v3.9.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.9.0) if upgrading from a version prior to 3.9.0.

This release requires at least Erlang 23.2, and supports the latest Erlang 24 version, 24.1.2 at the time of release. [RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on Erlang version requirements for RabbitMQ.



## Changes Worth Mentioning

Release notes are kept under [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.9.x/release-notes).
Contributors are encouraged to update them together with their changes. This helps with release automation and a more consistent release schedule.

### Core Server

#### Bug Fixes

 * Fixed an issue where node monitor could produce a false network partition when
   one of the cluster members was restarted

   GitHub issue: [#3631](https://github.com/rabbitmq/rabbitmq-server/pull/3631)

 * Message store resiliency improvements

   GitHub issue: [#3615](https://github.com/rabbitmq/rabbitmq-server/pull/3615)

 * Reduced log noise in certain scenarios where a new queue leader is elected

   GitHub issue: [#3628](https://github.com/rabbitmq/rabbitmq-server/pull/3628)

 * Queue leader rebalancing now logs less

   GitHub issue: [#3643](https://github.com/rabbitmq/rabbitmq-server/pull/3643)

#### Enhancements

 * `cluster_formation.target_cluster_size_hint` is a new configuration setting that can be used to specify expected initial cluster size.
   This can be used by features, plugins or tools that expect a certain minimum number of clusters nodes
   to join during initial cluster formation

   GitHub issue: [#3635](https://github.com/rabbitmq/rabbitmq-server/pull/3635)


### Prometheus Plugin

#### Enhancements

 * Metric rendering efficiency improvements (mostly latency)

   GitHub issue: [#3587](https://github.com/rabbitmq/rabbitmq-server/pull/3587)

#### Bug Fixes

 * TLS-enabled Prometheus endpoint listener port was not correctly stored internally

   GitHub issue: [#2975](https://github.com/rabbitmq/rabbitmq-server/issues/2975)


### Management Plugin

#### Bug Fixes

 * Persistent message count is now displayed correctly on individual queue pages

   GitHub issue: [#3598](https://github.com/rabbitmq/rabbitmq-server/pull/3598)

 * Restore compatibility with IE 11

   GitHub issue: [#3689](https://github.com/rabbitmq/rabbitmq-server/pull/3689)


### Consistent Hashing Exchange Plugin

#### Bug Fixes

 * Corrected deletion of duplicate bindings between an exchange and a queue

   Contributed by @FalconerTC

   GitHub issue: [#3594](https://github.com/rabbitmq/rabbitmq-server/pull/3594)


## Dependency Upgrades

* Ra was [upgraded to `2.0.2`](https://github.com/rabbitmq/ra/compare/v2.0.0...v2.0.2)

* Osiris was [upgraded to `1.2.3`](https://github.com/rabbitmq/osiris/compare/v1.2.2...v1.2.3)


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.9.9.tar.xz`
instead of the source tarball produced by GitHub.
