/*
 * Decompiled with CFR 0.152.
 */
package org.probatron.officeotron;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.probatron.officeotron.OOXMLContentTypeHandler;
import org.probatron.officeotron.OOXMLDefaultTypeMap;
import org.probatron.officeotron.OOXMLRelationshipPartHandler;
import org.probatron.officeotron.OOXMLTarget;
import org.probatron.officeotron.OOXMLTargetCollection;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class OPCPackage {
    static Logger logger = Logger.getLogger(OPCPackage.class);
    private OOXMLTargetCollection col = new OOXMLTargetCollection();
    private ArrayList<String> partsProbed = new ArrayList();
    OOXMLDefaultTypeMap dtm = new OOXMLDefaultTypeMap();
    private File uncompressed;

    public OPCPackage(File file) {
        this.uncompressed = file;
    }

    public void process() {
        this.procRels("_rels/.rels");
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            OOXMLContentTypeHandler oOXMLContentTypeHandler = new OOXMLContentTypeHandler(this.col, this.dtm);
            xMLReader.setContentHandler(oOXMLContentTypeHandler);
            String string = new File(this.uncompressed, "[Content_Types].xml").toURI().toString();
            xMLReader.parse(string);
        }
        catch (Exception exception) {
            logger.fatal("[Content_Types].xml parsing error", exception);
        }
    }

    private void procRels(String string) {
        String string2 = new File(this.uncompressed, string).getAbsolutePath();
        logger.debug("Retrieving relationship part from OPC package: " + string2);
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            OOXMLRelationshipPartHandler oOXMLRelationshipPartHandler = new OOXMLRelationshipPartHandler(string);
            xMLReader.setContentHandler(oOXMLRelationshipPartHandler);
            xMLReader.parse(string2);
            Iterator iterator = oOXMLRelationshipPartHandler.col.iterator();
            logger.trace("Number of Relationships found: " + oOXMLRelationshipPartHandler.col.size());
            while (iterator.hasNext()) {
                OOXMLTarget oOXMLTarget = (OOXMLTarget)iterator.next();
                String string3 = oOXMLTarget.getTargetAsPartName();
                if (this.partsProbed.contains(string3)) continue;
                this.partsProbed.add(string3);
                this.col.add(oOXMLTarget);
                String string4 = oOXMLTarget.getTargetFolder();
                String string5 = string4 + "_rels/" + oOXMLTarget.getFilename() + ".rels";
                logger.debug("*** Probing new possible target folder: " + string5);
                this.procRels(string5);
            }
        }
        catch (Exception exception) {
            logger.info(exception.getMessage());
        }
    }

    public OOXMLTargetCollection getEntryCollection() {
        return this.col;
    }
}

