---
title: Publications
---

# Citing SUMO

If your publication mentions SUMO please let us know!

!!! note
    When citing SUMO in general please use our current reference publication: ["Microscopic Traffic Simulation using SUMO"](https://ieeexplore.ieee.org/document/8569938); Pablo Alvarez Lopez, Michael Behrisch, Laura Bieker-Walz, Jakob Erdmann, Yun-Pang Flötteröd, Robert Hilbrich, Leonhard Lücken, Johannes Rummel, Peter Wagner, and Evamarie Wießner. IEEE Intelligent Transportation Systems Conference (ITSC), 2018.

BibTex:

```
@inproceedings{SUMO2018,
          title = {Microscopic Traffic Simulation using SUMO},
         author = {Pablo Alvarez Lopez and Michael Behrisch and Laura Bieker-Walz and Jakob Erdmann and Yun-Pang Fl{\"o}tter{\"o}d and Robert Hilbrich and Leonhard L{\"u}cken and Johannes Rummel and Peter Wagner and Evamarie Wie{\ss}ner},
      publisher = {IEEE},
      booktitle = {The 21st IEEE International Conference on Intelligent Transportation Systems},
           year = {2018},
        journal = {IEEE Intelligent Transportation Systems Conference (ITSC)},
       keywords = {traffic simulation, modelling, optimization},
            url = {https://elib.dlr.de/124092/}
 }
```

# Conference Proceedings

| Topic                                       | Authors          | Title            | Publication                        | Year |
| ------------------------------------------- | ---------------- | ---------------- | ---------------------------------- | ---- |
| SUMO Conference                                                    | [SUMO Conference Page](https://www.dlr.de/ts/en/desktopdefault.aspx/tabid-10042/17127_read-41437)                                                                                                               | [1st SUMO User Conference Proceedings](https://elib.dlr.de/93885/1/Proceeding_SUMO2013_15-17May%202013_Berlin-Adlershof.pdf)                                                                                                                                                               | Berichte aus dem DLR-Institut für Verkehrssystemtechnik, Band 21                                                                                                                                                            | 2013 { .cellNoWrap } |
| SUMO Conference                                                    | [SUMO Conference Page](https://sumo.dlr.de/2014/conference.html)                                                                                                                                               | [Proceedings](https://elib.dlr.de/94006/1/Proceeding_SUMO2014_15%2B16May2014_Berlin-Adlershof.pdf)                                                                                                                                                                                         | Berichte aus dem DLR-Institut für Verkehrssystemtechnik, Band 24                                                                                                                                                            | 2014 |
| SUMO Conference                                                    | [SUMO Conference Page](https://www.dlr.de/ts/en/desktopdefault.aspx/tabid-10490/18168_read-42578)                                                                                                               | [SUMO2015 - Intermodal Simulation for Intermodal Transport](https://elib.dlr.de/97714/1/SUMO2015_Proceeding.pdf)                                                                                                                                                                           | Berichte aus dem DLR-Institut für Verkehrssystemtechnik, Band 28                                                                                                                                                            | 2015 |
| SUMO Conference                                                    | [SUMO Conference Page](https://www.dlr.de/ts/en/desktopdefault.aspx/tabid-10848/18984_read-44970/)                                                                                                              | [SUMO2016 - Traffic, Mobility, and Logistics](https://elib.dlr.de/106342/1/SUMOconference_proceedings_2016.pdf)                                                                                                                                                                            | Berichte aus dem DLR-Institut für Verkehrssystemtechnik, Band 30                                                                                                                                                            | 2016 |
| SUMO Conference                                                    | [SUMO Conference Page](https://sumo.dlr.de/2017)                                                                                                                                                                | [SUMO 2017 Towards Simulation for Autonomous Mobility](https://elib.dlr.de/118438/1/SUMO_proceedings_online.pdf)                                                                                                                                                                          | Berichte aus dem DLR-Institut für Verkehrssystemtechnik, Band 31                                                                                                                                                            | 2017 |
| SUMO Conference    | [SUMO Conference Page](https://sumo.dlr.de/2018)    | [SUMO 2018- Simulating Autonomous and Intermodal Transport Systems](https://easychair.org/publications/volume/SUMO2018)          | EPiC Series in Engineering, Vol 2         | 2018 |
| SUMO Conference    | [SUMO Conference Page](https://sumo.dlr.de/2019)    | [SUMO 2019- Simulating Connected Urban Mobility](https://easychair.org/publications/volume/SUMO2019)          | EPiC Series in Computing, Vol 62         | 2019 |
| SUMO Conference    | [SUMO Conference Page](https://sumo.dlr.de/2020)    | [SUMO 2020- From Traffic Flow to Mobility Modeling](https://www.tib-op.org/ojs/index.php/scp/issue/view/4)          |     TIB Open Publishing     | 2020 |
| SUMO Conference    | [SUMO Conference Page](https://sumo.dlr.de/2021)    | [SUMO 2021](https://www.tib-op.org/ojs/index.php/scp/issue/view/5) |   TIB Open Publishing      | 2021 |
| SUMO Conference    | [SUMO Conference Page](https://sumo.dlr.de/2022)    | [SUMO 2022](https://www.tib-op.org/ojs/index.php/scp/issue/view/8)          | TIB Open Publishing       | 2022 |


# Publications on SUMO

| Topic                                       | Authors          | Title            | Publication                        | Year |
| ------------------------------------------- | ---------------- | ---------------- | ---------------------------------- | ---- |
| SUMO Software Description                                          | Behrisch, Michael and Laura Bieker, Jakob Erdmann, Daniel Krajzewicz                                                                                                                                           | [SUMO - Simulation of Urban MObility: An Overview](https://sumo.dlr.de/pdf/simul_2011_3_40_50150.pdf), [publications page](https://www.thinkmind.org/index.php?view=article&articleid=simul_2011_3_40_50150)                                                                               | SIMUL 2011, The Third International Conference on Advances in System Simulation, pp. 63-68                                                                                                                                    | 2011 { .cellNoWrap } |
| SUMO Software Description                                          | Krajzewicz, Daniel and Georg Hertkorn, Christian Rössel, Peter Wagner                                                                                                                                          | [SUMO (Simulation of Urban MObility); An open-source traffic simulation](https://sumo.dlr.de/pdf/dkrajzew_MESM2002_SUMO.pdf), [Presentation Slides](https://sumo.dlr.de/pdf/dkrajzew_mesm2002_SUMO_transparencies.pdf)                                                                    | Proceedings of the 4th Middle East Symposium on Simulation and Modelling (MESM2002), Sharjah (UAE), SCS European Publishing House, pp. 183-187                                                                                | 2002 |
| SUMO Software Description                                          | Krajzewicz, Daniel and Michael Bonert, Peter Wagner                                                                                                                                                            | [The Open Source Traffic Simulation Package SUMO](https://sumo.dlr.de/pdf/RoboCup2006_dkrajzew_SUMO.pdf)                                                                                                                                                                                  | RoboCup 2006 Infrastructure Simulation Competition, Bremen                                                                                                                                                                    | 2006 |
| SUMO Software Description                                          | Krajzewicz, Daniel and Michael Behrisch                                                                                                                                                                        | [Simulation of Urban MObility: SUMO - Eine freie Verkehrssimulation](https://sumo.dlr.de/pdf/de_SUMO_HU.pdf) (Presentation in German)                                                                                                                                                     |                                                                                                                                                                                                                               | 2008 |
| SUMO Software Description                                          | Krajzewicz, Daniel and Jakob Erdmann, Michael Behrisch, and Laura Bieker                                                                                                                                       | [Recent Development and Applications of SUMO - Simulation of Urban MObility](https://sumo.dlr.de/pdf/sysmea_v5_n34_2012_4.pdf), [Journal Page](https://www.iariajournals.org/systems_and_measurements/tocv5n34.html)                                                                       | International Journal On Advances in Systems and Measurements, 5 (3&4), pp. 128-138                                                                                                                                           | 2012 |


# Publications using SUMO

Most of the following entries and many more can also be found in this
[bibtex-file](https://sourceforge.net/projects/sumo/files/traffic_data/sumo.bib/download).
We advice to use [JabRef](https://jabref.sourceforge.net/) for editing
this list of publications.

| Topic                                       | Authors          | Title            | Publication                        | Year |
| ------------------------------------------- | ---------------- | ---------------- | ---------------------------------- | ---- |
| Simulation Theory                                                  | Chowdhury, D., L. Santen, A. Schadschneider                                                                                                                                                                    | [Statistical Physics of Vehicular Traffic and Some Related Systems](https://arxiv.org/abs/cond-mat/0007053)                                                                                                                                                                                | Physics Reports 329, (4-6), pp. 199-329, Elsevier, ISSN 0370-1573                                                                                                                                                             | 2000 { .cellNoWrap } |
| Car-Following Models                                               | Stefan Krauß, Peter Wagner, and Christian Gawron                                                                                                                                                               | [Metastable States in a Microscopic Model of Traffic Flow](https://sumo.dlr.de/pdf/sk.pdf)                                                                                                                                                                                                | Physical Review E 55, pp. 5597-5602                                                                                                                                                                                           | 1997 |
| Car-Following Models                                               | Krauß, Stefan                                                                                                                                                                                                  | [Microscopic Modeling of Traffic Flow: Investigation of Collision Free Vehicle Dynamics](https://sumo.dlr.de/pdf/KraussDiss.pdf)                                                                                                                                                          | Hauptabteilung Mobilität und Systemtechnik des DLR Köln, ISSN 1434-8454                                                                                                                                                       | 1998 |
| Lane-Change Models                                                 | Krajzewicz, Daniel                                                                                                                                                                                             | Kombination von taktischen und strategischen Einflüssen in einer mikroskopischen Verkehrsflusssimulation                                                                                                                                                                                 | Fahrermodellierung in Wissenschaft und Wirtschaft, 2. Berliner Fachtagung für Fahrermodellierung, VDI-Reihe 22 (Mensch-Maschine-Systeme), ISBN 978-3-18-302822-1                                                             | 2009 |
| Lane-Change Models                                                 | Erdmann, Jakob                                                                                                                                                                                                 | [Lane-Changing Model in SUMO](https://elib.dlr.de/89233)                                                                                                                                                                                                                                   | Proceedings of the SUMO2014 Modeling Mobility with Open Data, pp. 77-88, Berlin, ISSN 1866-721X                                                                                                                               | 2014 |
| Intermodality                                                      | Behrisch, Michael and Erdmann, Jakob and Krajzewicz, Daniel                                                                                                                                                    | [Adding intermodality to the microscopic simulation package SUMO](https://elib.dlr.de/65964)                                                                                                                                                                                               | MESM 2010, Alexandria (Egypt)                                                                                                                                                                                                 | 2010 |
| Traffic Assignment                                                 | Gawron, Christian                                                                                                                                                                                              | [Simulation-Based Traffic Assignment](https://sumo.dlr.de/pdf/GawronDiss.pdf)                                                                                                                                                                                                             | PhD thesis, University of Cologne                                                                                                                                                                                             | 1998 |
| Traffic Assignment                                                 | Gawron, Christian                                                                                                                                                                                              | [An Iterative Algorithm to Determine the Dynamic User Equilibrium in a Traffic Simulation Model](https://doi.org/10.1142/S0129183198000303)                                                                                                                                            | International Journal of Modern Physics C Vol. 9 (3), pp. 393-407                                                                                                                                                             | 1998 |
| Road Network Preparation                                           | Krajzewicz, Daniel and Georg Hertkorn, Julia Ringel, Peter Wagner                                                                                                                                              | [Preparation of Digital Maps for Traffic Simulation; Part 1: Approach and Algorithms](https://sumo.dlr.de/pdf/dkrajzew_TRAF5_DigitalMaps1.pdf)                                                                                                                                            | Proceedings of the 3rd Industrial Simulation Conference 2005, EUROSIS-ETI, pp. 285-290, Berlin, ISBN 90-77381-18-X                                                                                                            | 2005 |
| Validation, Calibration, and Tests                                 | Krajzewicz, Daniel and Georg Hertkorn, Christian Rössel, Peter Wagner                                                                                                                                          | [An Example of Microscopic Car Models Validation using the open source Traffic Simulation SUMO](https://sumo.dlr.de/pdf/dkrajzew_ESS2002_LOG14_Validation.pdf)                                                                                                                            | Proceedings of Simulation in Industry, 14th European Simulation Symposium 2002, SCS European Publishing House, pp. 318-322, Dresden                                                                                           | 2002 |
| Validation, Calibration, and Tests                                 | Heppner, Matthias                                                                                                                                                                                              | [Einführung von Unit Tests in das bestehende C++ Softwaresystem SUMO](https://web.archive.org/web/20140701052250/https://www2.informatik.hu-berlin.de/swt/dipl/MatthiasHeppner.2010.pdf)                                                                                                                                             | Diploma Thesis, Humboldt-Universität zu Berlin                                                                                                                                                                                | 2010 |
| Traffic Lights                                                     | Krajzewicz, Daniel and Elmar Brockfeld, Jürgen Mikat, Julia Ringel, Christian Rössel, Wolfram Tuchscheerer, Peter Wagner, Richard Woesler                                                                      | [Simulation of modern Traffic Lights Control Systems using the open source Traffic Simulation SUMO](https://sumo.dlr.de/pdf/dkrajzew_TRAF9_AgentbasedTLS.pdf)                                                                                                                             | Proceedings of the 3rd Industrial Simulation Conference 2005, EUROSIS-ETI, pp. 299-302, Berlin, ISBN 90-77381-18-X                                                                                                            | 2005 |
| Traffic Lights                                                     | Zubillaga D, Cruz G, Aguilar LD, Zapot‚catl J, Fern ndez N, Aguilar J, Rosenblueth DA, Gershenson C                                                                                                            | [Measuring the Complexity of Self-Organizing Traffic Lights](https://www.mdpi.com/1099-4300/16/5/2384)                                                                                                                                                                                     | Entropy 2014, 16(5), 2384-2407                                                                                                                                                                                                | 2014 |
| Car2Car Communication                                              | Bauza, R. and J. Gozalvez and M. Sepulcre                                                                                                                                                                      | [Operation and Performance of Vehicular Ad-hoc Routing Protocols in Realistic Environments](https://uwicore.umh.es/files/paper/2008_international/uwicore_WiVeC08_Operation%20and%20Performance%20of%20Vehicular%20Ad-hoc%20Routing%20Protocols%20in%20Realistic%20Environments.pdf)   | Proceedings of the 2nd IEEE International Symposium on Wireless Vehicular Communications (WiVeC), Calgary (Canada)                                                                                                            | 2008 |
| Car2Car Communication                                              | Cottingham, David N. and Jonathan J. Davies and Alastair R. Beresford                                                                                                                                          | [Congestion-Aware Vehicular Traffic Routing Using WiFi Hotspots](https://www.cl.cam.ac.uk/research/dtg/www/publications/public/jjd27/ciiHandout.pdf)                                                                                                                                                     | Proceedings of Communications Innovation Institute Workshop, Cambridge-MIT Institute, pp. 4-6                                                                                                                                 | 2005 |
| Car2Car Communication                                              | Kristianto Karnadi, Feliz and Zhi Hai Mo and Kun-chan Lan                                                                                                                                                      | [Rapid Generation of Realistic Mobility Models for VANET](https://web.archive.org/web/20070226210528/https://www.cse.unsw.edu.au/~klan/paper/sumo.pdf)                                                                                                                                                                                | ACM MOBICOMM                                                                                                                                                                                                                  | 2005 |
| Car2Car Communication                                              | Gozalvez, J. and M. Sepulcre                                                                                                                                                                                   | [Channel Efficiency of Adaptive Transmission Techniques for Wireless Vehicular Communications](https://uwicore.umh.es/files/paper/2008_international/uwicore_ITS08_Channel%20Efficiency%20of%20Adaptive%20Transmission%20Techniques%20for%20Wireless%20Vehicular%20Communications.pdf) | Proceedings of the 15th World Congress on Intelligent Transport Systems, New York (USA)                                                                                                                                       | 2008 |
| Car2Car Communication                                              | Honomichl, Clemens                                                                                                                                                                                             | Analyse und Simulation von Verkettbarkeitsmaßen in pseudonymer, mobiler Kommunikation                                                                                                                                                | Diploma Thesis                                                                                                                                                                                                                | 2008 |
| Car2Car Communication                                              | Lehr, Sebastian                                                                                                                                                                                                | [Optimierung der Kommunikation zwischen am Verkehr beteiligten Strukturen](https://sumo.dlr.de/pdf/DiplomarbeitSebastianLehr.pdf)                                                                                                                                                         | Diploma Thesis, Fachhochschule für Technik und Wirtschaft Berlin                                                                                                                                                             | 2005 |
| Car2Car Communication                                              | Piorkowski, Michal and Maxim Raya, Ada Lezama Lugo, Panos Papadimitratos, Matthias Grossglauser and Jean-Pierre Hubaux                                                                                         | [TraNS: Realistic Joint Traffic and Network Simulator for VANETs](https://infoscience.epfl.ch/record/113879)                                                                                                                                                                               | The 13th ACM Annual International Conference on Mobile Computing and Networking MobiCom'07, Montreal (Canada)                                                                                                                 | 2007 |
| Car2Car Communication                                              | Sommer, Christoph and Zheng Yao, Reinhard German and Falko Dressler                                                                                                                                            | [Simulating the Influence of IVC on Road Traffic using Bidirectionally Coupled Simulators](https://web.archive.org/web/20070716055158/http://univis.uni-erlangen.de/prg?url=http://www7.informatik.uni-erlangen.de/~sommer/publications/index.shtml?univis=true)                                                                                                                                   | Proceedings of 27th IEEE Conference on Computer Communications (IEEE INFOCOM 2008): Mobile Networking for Vehicular Environments (MOVE 2008), Phoenix, AZ                                                                     | 2008 |
| Car2Car Communication                                              | Sommer, Christoph and Zheng Yao, Reinhard German and Falko Dressler                                                                                                                                            | [On the Need for Bidirectional Coupling of Road Traffic Microsimulation and Network Simulation](https://web.archive.org/web/20070716055158/http://univis.uni-erlangen.de/prg?url=http://www7.informatik.uni-erlangen.de/~sommer/publications/index.shtml?univis=true)                                                                                                                              | Proceedings of 9th ACM International Symposium on Mobile Ad Hoc Networking and Computing (ACM Mobihoc 2008): 1st ACM International Workshop on Mobility Models for Networking Research (MobilityModels'08), Hong Kong (China) | 2008 |
| Car2Car Communication                                              | Wegener, Axel and Michal Piorkowski, Maxim Raya, Horst Hellbrck, Stefan Fischer, and Jean-Pierre Hubaux                                                                                                       | [TraCI: An Interface for Coupling Road Traffic and Network Simulators](https://infoscience.epfl.ch/record/115106)                                                                                                                                                                          | The 11th Communications and Networking Simulation Symposium CNS'08, Ottawa (Canada)                                                                                                                                           | 2008 |
| Car2Car Communication                                              | Wegener, Axel and Horst Hellbrck, Christian Wewetzer and Andreas Lbke                                                                                                                                        | VANET Simulation Environment with Feedback Loop and its Application to Traffic Light Assistance                                                                                                                                                                                           | Proceedings of the 3rd IEEE Workshop on Automotive Networking and Applications, New Orleans, LA (USA)                                                                                                                         | 2008 |
| Car2Car Communication                                              | Barber, Anthony                                                                                                                                                                                                | [Sharing the Roads Using Route Information Sharing](https://sumo.dlr.de/pdf/BarberThesis.pdf)                                                                                                                                                                                             | Master Thesis, The University of Tulsa                                                                                                                                                                                        | 2011 |
| Car2Car Communication, Vehicle Navigation, Road Network Generation | Edelkamp, Stefan and Shahidd Jabar, Tilman Mehrer                                                                                                                                                              | GPS-Route, Endbericht                                                                                                                                                                                                                   | Universität Dortmund, Fachbereich Informatik                                                                                                                                                                                 | 2004 |
| ITS - other topics                                                 | Morenz, Tino                                                                                                                                                                                                   | [iTranSIM - Simulation-based Vehicle Location](https://www.cs.tcd.ie/publications/tech-reports/reports.07/TCD-CS-2007-56.pdf)                                                                                                                                                             | Master thesis, University of Dublin                                                                                                                                                                                           | 2008 |
| ITS - other topics                                                 | Willigens, Michael                                                                                                                                                                                             | Development and Evaluation of a Centralized Traffic Information System using UMTS and GPS                                                                                                                                                                                                 | Master Thesis, Universität Düsseldorf                                                                                                                                                                                      | 2008 |
| ITS - other topics                                                 | Kerekes, John P. and Michael D. Presnar, Kenneth D. Fourspring, Zoran Ninkov, David R. Pogorzala, Alan D. Raisanen, Andrew C. Rice, Juan R. Vasquez, Jeffrey P. Patel, Robert T. MacIntyre, and Scott D. Brown | [Sensor modeling and demonstration of a multi-object spectrometer for performance-driven sensing](https://spie.org/x648.html?product_id=819265)                                                                                                                                            | Proc. SPIE 7334, 73340J, <DOI:10.1117/12.819265>                                                                                                                                                                              | 2009 |
| ITS - other topics                                                 | Pereira, Jos‚ Luis Ferr s                                                                                                                                                                                      | [An Integrated Architecture for Autonomous Vehicles Simulation](https://sumo.dlr.de/pdf/mieec1.pdf)                                                                                                                                                                                       | Master Thesis, Faculdade de Engenharia da Universidade do Porto                                                                                                                                                               | 2011 |
| ITS - other topics                                                 | Bajpai, Ashutosh and Tom V Mathew                                                                                                                                                                              | [Development of an Interface between Signal Controller and Traffic Simulator](https://sumo.dlr.de/pdf/CTRG_Interface-SUMO.pdf)                                                                                                                                                            | 1st Conference of Transportation Research Group of India (CTRG)                                                                                                                                                               | 2011 |
| ITS - other topics                                                 | Xie, X.-F. and Y. Feng, K. Larry Head                                                                                                                                                                          | [Unified route choice framework: Specification and application to urban traffic control](https://www.wiomax.com/team/xie/paper/TRB14RCTC.pdf)                                                                                                                                              | Transportation Research Record: Journal of the Transportation Research Board, 2466: 105-113                                                                                                                                   | 2014 |
| Traffic Lights                                                     | Xie, X.-F. et al.                                                                                                                                                                                              | [Schedule-driven intersection control](https://www.wiomax.com/team/xie/paper/TRC12.pdf)                                                                                                                                                                                                    | Transportation Research Part C: Emerging Technologies, 24: 168-189                                                                                                                                                            | 2012 |
| ITS - other topics                                                 | Xie, X.-F. et al.                                                                                                                                                                                              | [Schedule-driven coordination for real-time traffic network control](https://www.wiomax.com/team/xie/paper/ICAPS12.pdf)                                                                                                                                                                    | International Conference on Automated Planning and Scheduling (ICAPS), pp. 323-331, Sao Paulo (Brazil)                                                                                                                        | 2012 |
