//============================================================================
//
//   SSSS    tt          lll  lll
//  SS  SS   tt           ll   ll
//  SS     tttttt  eeee   ll   ll   aaaa
//   SSSS    tt   ee  ee  ll   ll      aa
//      SS   tt   eeeeee  ll   ll   aaaaa  --  "An Atari 2600 VCS Emulator"
//  SS  SS   tt   ee      ll   ll  aa  aa
//   SSSS     ttt  eeeee llll llll  aaaaa
//
// Copyright (c) 1995-2024 by Bradford W. Mott, Stephen Anthony
// and the stella Team
//
// See the file "License.txt" for information on usage and redistribution of
// this file, and for a DISCLAIMER OF ALL WARRANTIES.
//
// Generated by src/tools/convbdf on Sun Mar 15 08:31:37 2020.
//============================================================================

#ifndef STELLA12X24T_FONT_DATA_HXX
#define STELLA12X24T_FONT_DATA_HXX

#include "Font.hxx"

/* Font information:
   name: ter-u24b
   facename: -xos4-Terminus-Bold-R-Normal--24-240-72-72-C-120-ISO10646-1
   w x h: 12x24
   bbx: 12 24 0 -5
   size: 95
   ascent: 19
   descent: 5
   first char: 32 (0x20)
   last char: 126 (0x7e)
   default char: 32 (0x20)
   proportional: no
   Copyright (c) 2010-2014 Dimitar Toshkov Zhekov,
   with Reserved Font Name "Terminus Font".
   See Terminus-Font-License.txt for details.
*/

namespace GUI {

// Font character bitmap data.
static const uInt16 stella12x24t_font_bits[] = {  // NOLINT : too complicated to convert

/* Character 28 (0x1c):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0b0000111000000000,
0b0001101100000000,
0b0011000110000000,
0b0011000110000000,
0b0011000110000000,
0b0001101100000000,
0b0000111000000000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 29 (0x1d):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   | **  **  ** |
   | **  **  ** |
   | **  **  ** |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0b0110011001100000,
0b0110011001100000,
0b0110011001100000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 30 (0x1e):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 31 (0x1f):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |    ****    |
   |  ********  |
   |  ********  |
   | ********** |
   | ********** |
   | ********** |
   | ********** |
   |  ********  |
   |  ********  |
   |    ****    |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0b0000111100000000,
0b0011111110000000,
0b0011111110000000,
0b0111111111000000,
0b0111111111000000,
0b0111111111000000,
0b0111111111000000,
0b0011111110000000,
0b0011111110000000,
0b0000111100000000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 32 (0x20):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 33 (0x21):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |            |
   |            |
   |     **     |
   |     **     |
   |     **     |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0000,
0x0000,
0x0600,
0x0600,
0x0600,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 34 (0x22):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |   **  **   |
   |   **  **   |
   |   **  **   |
   |   **  **   |
   |   **  **   |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x1980,
0x1980,
0x1980,
0x1980,
0x1980,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 35 (0x23):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |   **  **   |
   |   **  **   |
   |   **  **   |
   |   **  **   |
   | ********** |
   |   **  **   |
   |   **  **   |
   |   **  **   |
   |   **  **   |
   |   **  **   |
   | ********** |
   |   **  **   |
   |   **  **   |
   |   **  **   |
   |   **  **   |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x1980,
0x1980,
0x1980,
0x1980,
0x7fe0,
0x1980,
0x1980,
0x1980,
0x1980,
0x1980,
0x7fe0,
0x1980,
0x1980,
0x1980,
0x1980,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 36 (0x24):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |     **     |
   |     **     |
   |   ******   |
   |  ** ** **  |
   | **  **  ** |
   | **  **     |
   | **  **     |
   |  ** **     |
   |   ******   |
   |     ** **  |
   |     **  ** |
   |     **  ** |
   | **  **  ** |
   |  ** ** **  |
   |   ******   |
   |     **     |
   |     **     |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0600,
0x0600,
0x1f80,
0x36c0,
0x6660,
0x6600,
0x6600,
0x3600,
0x1f80,
0x06c0,
0x0660,
0x0660,
0x6660,
0x36c0,
0x1f80,
0x0600,
0x0600,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 37 (0x25):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |            |
   |  ***   **  |
   | ** **  **  |
   | ** ** **   |
   |  ***  **   |
   |      **    |
   |      **    |
   |     **     |
   |     **     |
   |    **      |
   |    **      |
   |   **  ***  |
   |   ** ** ** |
   |  **  ** ** |
   |  **   ***  |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x38c0,
0x6cc0,
0x6d80,
0x3980,
0x0300,
0x0300,
0x0600,
0x0600,
0x0c00,
0x0c00,
0x19c0,
0x1b60,
0x3360,
0x31c0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 38 (0x26):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |    ***     |
   |   ** **    |
   |  **   **   |
   |  **   **   |
   |  **   **   |
   |   ** **    |
   |    ***     |
   |   ****  ** |
   |  **  ** ** |
   | **    ***  |
   | **     **  |
   | **     **  |
   | **    ***  |
   |  **  ** ** |
   |   ****  ** |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0e00,
0x1b00,
0x3180,
0x3180,
0x3180,
0x1b00,
0x0e00,
0x1e60,
0x3360,
0x61c0,
0x60c0,
0x60c0,
0x61c0,
0x3360,
0x1e60,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 39 (0x27):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 40 (0x28):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |      **    |
   |     **     |
   |    **      |
   |    **      |
   |   **       |
   |   **       |
   |   **       |
   |   **       |
   |   **       |
   |   **       |
   |   **       |
   |    **      |
   |    **      |
   |     **     |
   |      **    |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0300,
0x0600,
0x0c00,
0x0c00,
0x1800,
0x1800,
0x1800,
0x1800,
0x1800,
0x1800,
0x1800,
0x0c00,
0x0c00,
0x0600,
0x0300,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 41 (0x29):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |   **       |
   |    **      |
   |     **     |
   |     **     |
   |      **    |
   |      **    |
   |      **    |
   |      **    |
   |      **    |
   |      **    |
   |      **    |
   |     **     |
   |     **     |
   |    **      |
   |   **       |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x1800,
0x0c00,
0x0600,
0x0600,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0600,
0x0600,
0x0c00,
0x1800,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 42 (0x2a):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   | **     **  |
   |  **   **   |
   |   ** **    |
   |    ***     |
   |*********** |
   |    ***     |
   |   ** **    |
   |  **   **   |
   | **     **  |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x60c0,
0x3180,
0x1b00,
0x0e00,
0xffe0,
0x0e00,
0x1b00,
0x3180,
0x60c0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 43 (0x2b):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   | ********** |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0600,
0x0600,
0x0600,
0x0600,
0x7fe0,
0x0600,
0x0600,
0x0600,
0x0600,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 44 (0x2c):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |    **      |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0600,
0x0600,
0x0600,
0x0600,
0x0c00,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 45 (0x2d):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   | ********** |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x7fe0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 46 (0x2e):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |     **     |
   |     **     |
   |     **     |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0600,
0x0600,
0x0600,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 47 (0x2f):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |            |
   |        **  |
   |        **  |
   |       **   |
   |       **   |
   |      **    |
   |      **    |
   |     **     |
   |     **     |
   |    **      |
   |    **      |
   |   **       |
   |   **       |
   |  **        |
   |  **        |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x00c0,
0x00c0,
0x0180,
0x0180,
0x0300,
0x0300,
0x0600,
0x0600,
0x0c00,
0x0c00,
0x1800,
0x1800,
0x3000,
0x3000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 48 (0x30):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |   ******   |
   |  **    **  |
   | **      ** |
   | **      ** |
   | **     *** |
   | **    **** |
   | **   ** ** |
   | **  **  ** |
   | ** **   ** |
   | ****    ** |
   | ***     ** |
   | **      ** |
   | **      ** |
   |  **    **  |
   |   ******   |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x1f80,
0x30c0,
0x6060,
0x6060,
0x60e0,
0x61e0,
0x6360,
0x6660,
0x6c60,
0x7860,
0x7060,
0x6060,
0x6060,
0x30c0,
0x1f80,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 49 (0x31):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |     **     |
   |    ***     |
   |   ****     |
   |  ** **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |  ********  |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0600,
0x0e00,
0x1e00,
0x3600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x3fc0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 50 (0x32):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |   ******   |
   |  **    **  |
   | **      ** |
   | **      ** |
   | **      ** |
   |         ** |
   |        **  |
   |       **   |
   |      **    |
   |     **     |
   |    **      |
   |   **       |
   |  **        |
   | **         |
   | ********** |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x1f80,
0x30c0,
0x6060,
0x6060,
0x6060,
0x0060,
0x00c0,
0x0180,
0x0300,
0x0600,
0x0c00,
0x1800,
0x3000,
0x6000,
0x7fe0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 51 (0x33):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |   ******   |
   |  **    **  |
   | **      ** |
   |         ** |
   |         ** |
   |         ** |
   |        **  |
   |    *****   |
   |        **  |
   |         ** |
   |         ** |
   |         ** |
   | **      ** |
   |  **    **  |
   |   ******   |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x1f80,
0x30c0,
0x6060,
0x0060,
0x0060,
0x0060,
0x00c0,
0x0f80,
0x00c0,
0x0060,
0x0060,
0x0060,
0x6060,
0x30c0,
0x1f80,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 52 (0x34):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |         ** |
   |        *** |
   |       **** |
   |      ** ** |
   |     **  ** |
   |    **   ** |
   |   **    ** |
   |  **     ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | ********** |
   |         ** |
   |         ** |
   |         ** |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0060,
0x00e0,
0x01e0,
0x0360,
0x0660,
0x0c60,
0x1860,
0x3060,
0x6060,
0x6060,
0x6060,
0x7fe0,
0x0060,
0x0060,
0x0060,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 53 (0x35):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   | ********** |
   | **         |
   | **         |
   | **         |
   | **         |
   | **         |
   | ********   |
   |        **  |
   |         ** |
   |         ** |
   |         ** |
   |         ** |
   | **      ** |
   |  **    **  |
   |   ******   |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x7fe0,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x7f80,
0x00c0,
0x0060,
0x0060,
0x0060,
0x0060,
0x6060,
0x30c0,
0x1f80,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 54 (0x36):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |   *******  |
   |  **        |
   | **         |
   | **         |
   | **         |
   | **         |
   | ********   |
   | **     **  |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   |  **    **  |
   |   ******   |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x1fc0,
0x3000,
0x6000,
0x6000,
0x6000,
0x6000,
0x7f80,
0x60c0,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x30c0,
0x1f80,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 55 (0x37):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   | ********** |
   | **      ** |
   | **      ** |
   |         ** |
   |        **  |
   |        **  |
   |       **   |
   |       **   |
   |      **    |
   |      **    |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x7fe0,
0x6060,
0x6060,
0x0060,
0x00c0,
0x00c0,
0x0180,
0x0180,
0x0300,
0x0300,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 56 (0x38):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |   ******   |
   |  **    **  |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   |  **    **  |
   |   ******   |
   |  **    **  |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   |  **    **  |
   |   ******   |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x1f80,
0x30c0,
0x6060,
0x6060,
0x6060,
0x6060,
0x30c0,
0x1f80,
0x30c0,
0x6060,
0x6060,
0x6060,
0x6060,
0x30c0,
0x1f80,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 57 (0x39):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |   ******   |
   |  **    **  |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   |  **     ** |
   |   ******** |
   |         ** |
   |         ** |
   |         ** |
   |         ** |
   |        **  |
   |  *******   |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x1f80,
0x30c0,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x3060,
0x1fe0,
0x0060,
0x0060,
0x0060,
0x0060,
0x00c0,
0x3f80,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 58 (0x3a):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |     **     |
   |     **     |
   |     **     |
   |            |
   |            |
   |            |
   |            |
   |     **     |
   |     **     |
   |     **     |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0600,
0x0600,
0x0600,
0x0000,
0x0000,
0x0000,
0x0000,
0x0600,
0x0600,
0x0600,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 59 (0x3b):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |     **     |
   |     **     |
   |     **     |
   |            |
   |            |
   |            |
   |            |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |    **      |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0600,
0x0600,
0x0600,
0x0000,
0x0000,
0x0000,
0x0000,
0x0600,
0x0600,
0x0600,
0x0600,
0x0c00,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 60 (0x3c):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |        **  |
   |       **   |
   |      **    |
   |     **     |
   |    **      |
   |   **       |
   |  **        |
   | **         |
   |  **        |
   |   **       |
   |    **      |
   |     **     |
   |      **    |
   |       **   |
   |        **  |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x00c0,
0x0180,
0x0300,
0x0600,
0x0c00,
0x1800,
0x3000,
0x6000,
0x3000,
0x1800,
0x0c00,
0x0600,
0x0300,
0x0180,
0x00c0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 61 (0x3d):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   | ********** |
   |            |
   |            |
   |            |
   |            |
   | ********** |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x7fe0,
0x0000,
0x0000,
0x0000,
0x0000,
0x7fe0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 62 (0x3e):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   | **         |
   |  **        |
   |   **       |
   |    **      |
   |     **     |
   |      **    |
   |       **   |
   |        **  |
   |       **   |
   |      **    |
   |     **     |
   |    **      |
   |   **       |
   |  **        |
   | **         |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x6000,
0x3000,
0x1800,
0x0c00,
0x0600,
0x0300,
0x0180,
0x00c0,
0x0180,
0x0300,
0x0600,
0x0c00,
0x1800,
0x3000,
0x6000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 63 (0x3f):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |   ******   |
   |  **    **  |
   | **      ** |
   | **      ** |
   | **      ** |
   |        **  |
   |       **   |
   |      **    |
   |     **     |
   |     **     |
   |            |
   |            |
   |     **     |
   |     **     |
   |     **     |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x1f80,
0x30c0,
0x6060,
0x6060,
0x6060,
0x00c0,
0x0180,
0x0300,
0x0600,
0x0600,
0x0000,
0x0000,
0x0600,
0x0600,
0x0600,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 64 (0x40):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |  *******   |
   | **     **  |
   |**       ** |
   |**    ***** |
   |**   **  ** |
   |**  **   ** |
   |**  **   ** |
   |**  **   ** |
   |**  **   ** |
   |**  **   ** |
   |**   **  ** |
   |**    ***** |
   |**          |
   | **         |
   |  ********* |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x3f80,
0x60c0,
0xc060,
0xc3e0,
0xc660,
0xcc60,
0xcc60,
0xcc60,
0xcc60,
0xcc60,
0xc660,
0xc3e0,
0xc000,
0x6000,
0x3fe0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 65 (0x41):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |   ******   |
   |  **    **  |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | ********** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x1f80,
0x30c0,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x7fe0,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 66 (0x42):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   | ********   |
   | **     **  |
   | **      ** |
   | **      ** |
   | **      ** |
   | **     **  |
   | ********   |
   | **     **  |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **     **  |
   | ********   |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x7f80,
0x60c0,
0x6060,
0x6060,
0x6060,
0x60c0,
0x7f80,
0x60c0,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x60c0,
0x7f80,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 67 (0x43):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |   ******   |
   |  **    **  |
   | **      ** |
   | **      ** |
   | **         |
   | **         |
   | **         |
   | **         |
   | **         |
   | **         |
   | **         |
   | **      ** |
   | **      ** |
   |  **    **  |
   |   ******   |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x1f80,
0x30c0,
0x6060,
0x6060,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6060,
0x6060,
0x30c0,
0x1f80,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 68 (0x44):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   | ********   |
   | **     **  |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **     **  |
   | ********   |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x7f80,
0x60c0,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x60c0,
0x7f80,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 69 (0x45):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   | ********** |
   | **         |
   | **         |
   | **         |
   | **         |
   | **         |
   | **         |
   | ********   |
   | **         |
   | **         |
   | **         |
   | **         |
   | **         |
   | **         |
   | ********** |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x7fe0,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x7f80,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x7fe0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 70 (0x46):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   | ********** |
   | **         |
   | **         |
   | **         |
   | **         |
   | **         |
   | **         |
   | ********   |
   | **         |
   | **         |
   | **         |
   | **         |
   | **         |
   | **         |
   | **         |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x7fe0,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x7f80,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 71 (0x47):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |   ******   |
   |  **    **  |
   | **      ** |
   | **      ** |
   | **         |
   | **         |
   | **         |
   | **   ***** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   |  **    **  |
   |   ******   |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x1f80,
0x30c0,
0x6060,
0x6060,
0x6000,
0x6000,
0x6000,
0x63e0,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x30c0,
0x1f80,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 72 (0x48):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | ********** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x7fe0,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 73 (0x49):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |   ******   |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |   ******   |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x1f80,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x1f80,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 74 (0x4a):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |      ******|
   |        **  |
   |        **  |
   |        **  |
   |        **  |
   |        **  |
   |        **  |
   |        **  |
   |        **  |
   |        **  |
   | **     **  |
   | **     **  |
   | **     **  |
   |  **   **   |
   |   *****    |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x03f0,
0x00c0,
0x00c0,
0x00c0,
0x00c0,
0x00c0,
0x00c0,
0x00c0,
0x00c0,
0x00c0,
0x60c0,
0x60c0,
0x60c0,
0x3180,
0x1f00,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 75 (0x4b):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   | **      ** |
   | **     **  |
   | **    **   |
   | **   **    |
   | **  **     |
   | ** **      |
   | ****       |
   | ***        |
   | ****       |
   | ** **      |
   | **  **     |
   | **   **    |
   | **    **   |
   | **     **  |
   | **      ** |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x6060,
0x60c0,
0x6180,
0x6300,
0x6600,
0x6c00,
0x7800,
0x7000,
0x7800,
0x6c00,
0x6600,
0x6300,
0x6180,
0x60c0,
0x6060,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 76 (0x4c):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   | **         |
   | **         |
   | **         |
   | **         |
   | **         |
   | **         |
   | **         |
   | **         |
   | **         |
   | **         |
   | **         |
   | **         |
   | **         |
   | **         |
   | ********** |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x7fe0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 77 (0x4d):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |*         * |
   |**       ** |
   |***     *** |
   |****   **** |
   |** ** ** ** |
   |**  ***  ** |
   |**   *   ** |
   |**       ** |
   |**       ** |
   |**       ** |
   |**       ** |
   |**       ** |
   |**       ** |
   |**       ** |
   |**       ** |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x8020,
0xc060,
0xe0e0,
0xf1e0,
0xdb60,
0xce60,
0xc460,
0xc060,
0xc060,
0xc060,
0xc060,
0xc060,
0xc060,
0xc060,
0xc060,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 78 (0x4e):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | ***     ** |
   | ****    ** |
   | ** **   ** |
   | **  **  ** |
   | **   ** ** |
   | **    **** |
   | **     *** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x6060,
0x6060,
0x6060,
0x6060,
0x7060,
0x7860,
0x6c60,
0x6660,
0x6360,
0x61e0,
0x60e0,
0x6060,
0x6060,
0x6060,
0x6060,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 79 (0x4f):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |   ******   |
   |  **    **  |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   |  **    **  |
   |   ******   |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x1f80,
0x30c0,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x30c0,
0x1f80,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 80 (0x50):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   | ********   |
   | **     **  |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **     **  |
   | ********   |
   | **         |
   | **         |
   | **         |
   | **         |
   | **         |
   | **         |
   | **         |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x7f80,
0x60c0,
0x6060,
0x6060,
0x6060,
0x6060,
0x60c0,
0x7f80,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 81 (0x51):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |   ******   |
   |  **    **  |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **  **  ** |
   |  **  ****  |
   |   ******   |
   |        **  |
   |         ** |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x1f80,
0x30c0,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6660,
0x33c0,
0x1f80,
0x00c0,
0x0060,
0x0000,
0x0000,
0x0000,

/* Character 82 (0x52):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   | ********   |
   | **     **  |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **     **  |
   | ********   |
   | ****       |
   | ** **      |
   | **  **     |
   | **   **    |
   | **    **   |
   | **     **  |
   | **      ** |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x7f80,
0x60c0,
0x6060,
0x6060,
0x6060,
0x6060,
0x60c0,
0x7f80,
0x7800,
0x6c00,
0x6600,
0x6300,
0x6180,
0x60c0,
0x6060,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 83 (0x53):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |   ******   |
   |  **    **  |
   | **      ** |
   | **         |
   | **         |
   | **         |
   |  **        |
   |   ******   |
   |        **  |
   |         ** |
   |         ** |
   |         ** |
   | **      ** |
   |  **    **  |
   |   ******   |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x1f80,
0x30c0,
0x6060,
0x6000,
0x6000,
0x6000,
0x3000,
0x1f80,
0x00c0,
0x0060,
0x0060,
0x0060,
0x6060,
0x30c0,
0x1f80,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 84 (0x54):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   | ********** |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x7fe0,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 85 (0x55):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   |  **    **  |
   |   ******   |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x30c0,
0x1f80,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 86 (0x56):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   |  **    **  |
   |  **    **  |
   |  **    **  |
   |  **    **  |
   |   **  **   |
   |   **  **   |
   |   **  **   |
   |    ****    |
   |    ****    |
   |     **     |
   |     **     |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x6060,
0x6060,
0x6060,
0x6060,
0x30c0,
0x30c0,
0x30c0,
0x30c0,
0x1980,
0x1980,
0x1980,
0x0f00,
0x0f00,
0x0600,
0x0600,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 87 (0x57):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |**       ** |
   |**       ** |
   |**       ** |
   |**       ** |
   |**       ** |
   |**       ** |
   |**       ** |
   |**       ** |
   |**   *   ** |
   |**  ***  ** |
   |** ** ** ** |
   |****   **** |
   |***     *** |
   |**       ** |
   |*         * |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0xc060,
0xc060,
0xc060,
0xc060,
0xc060,
0xc060,
0xc060,
0xc060,
0xc460,
0xce60,
0xdb60,
0xf1e0,
0xe0e0,
0xc060,
0x8020,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 88 (0x58):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   | **      ** |
   | **      ** |
   |  **    **  |
   |  **    **  |
   |   **  **   |
   |   **  **   |
   |    ****    |
   |     **     |
   |    ****    |
   |   **  **   |
   |   **  **   |
   |  **    **  |
   |  **    **  |
   | **      ** |
   | **      ** |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x6060,
0x6060,
0x30c0,
0x30c0,
0x1980,
0x1980,
0x0f00,
0x0600,
0x0f00,
0x1980,
0x1980,
0x30c0,
0x30c0,
0x6060,
0x6060,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 89 (0x59):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   | **      ** |
   | **      ** |
   |  **    **  |
   |  **    **  |
   |   **  **   |
   |   **  **   |
   |    ****    |
   |    ****    |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x6060,
0x6060,
0x30c0,
0x30c0,
0x1980,
0x1980,
0x0f00,
0x0f00,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 90 (0x5a):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   | ********** |
   |         ** |
   |         ** |
   |         ** |
   |        **  |
   |       **   |
   |      **    |
   |     **     |
   |    **      |
   |   **       |
   |  **        |
   | **         |
   | **         |
   | **         |
   | ********** |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x7fe0,
0x0060,
0x0060,
0x0060,
0x00c0,
0x0180,
0x0300,
0x0600,
0x0c00,
0x1800,
0x3000,
0x6000,
0x6000,
0x6000,
0x7fe0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 91 (0x5b):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |   *****    |
   |   **       |
   |   **       |
   |   **       |
   |   **       |
   |   **       |
   |   **       |
   |   **       |
   |   **       |
   |   **       |
   |   **       |
   |   **       |
   |   **       |
   |   **       |
   |   *****    |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x1f00,
0x1800,
0x1800,
0x1800,
0x1800,
0x1800,
0x1800,
0x1800,
0x1800,
0x1800,
0x1800,
0x1800,
0x1800,
0x1800,
0x1f00,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 92 (0x5c):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |            |
   |  **        |
   |  **        |
   |   **       |
   |   **       |
   |    **      |
   |    **      |
   |     **     |
   |     **     |
   |      **    |
   |      **    |
   |       **   |
   |       **   |
   |        **  |
   |        **  |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x3000,
0x3000,
0x1800,
0x1800,
0x0c00,
0x0c00,
0x0600,
0x0600,
0x0300,
0x0300,
0x0180,
0x0180,
0x00c0,
0x00c0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 93 (0x5d):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |   *****    |
   |      **    |
   |      **    |
   |      **    |
   |      **    |
   |      **    |
   |      **    |
   |      **    |
   |      **    |
   |      **    |
   |      **    |
   |      **    |
   |      **    |
   |      **    |
   |   *****    |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x1f00,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x1f00,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 94 (0x5e):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |     **     |
   |    ****    |
   |   **  **   |
   |  **    **  |
   | **      ** |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0600,
0x0f00,
0x1980,
0x30c0,
0x6060,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 95 (0x5f):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   | ********** |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x7fe0,
0x0000,
0x0000,
0x0000,

/* Character 96 (0x60):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |   **       |
   |    **      |
   |     **     |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x1800,
0x0c00,
0x0600,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 97 (0x61):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |  *******   |
   |        **  |
   |         ** |
   |         ** |
   |   ******** |
   |  **     ** |
   | **      ** |
   | **      ** |
   | **      ** |
   |  **     ** |
   |   ******** |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x3f80,
0x00c0,
0x0060,
0x0060,
0x1fe0,
0x3060,
0x6060,
0x6060,
0x6060,
0x3060,
0x1fe0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 98 (0x62):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   | **         |
   | **         |
   | **         |
   | **         |
   | ********   |
   | **     **  |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **     **  |
   | ********   |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x6000,
0x6000,
0x6000,
0x6000,
0x7f80,
0x60c0,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x60c0,
0x7f80,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 99 (0x63):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |   ******   |
   |  **    **  |
   | **      ** |
   | **         |
   | **         |
   | **         |
   | **         |
   | **         |
   | **      ** |
   |  **    **  |
   |   ******   |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x1f80,
0x30c0,
0x6060,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6060,
0x30c0,
0x1f80,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 100 (0x64):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |         ** |
   |         ** |
   |         ** |
   |         ** |
   |   ******** |
   |  **     ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   |  **     ** |
   |   ******** |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0060,
0x0060,
0x0060,
0x0060,
0x1fe0,
0x3060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x3060,
0x1fe0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 101 (0x65):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |   ******   |
   |  **    **  |
   | **      ** |
   | **      ** |
   | **      ** |
   | ********** |
   | **         |
   | **         |
   | **         |
   |  **     ** |
   |   *******  |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x1f80,
0x30c0,
0x6060,
0x6060,
0x6060,
0x7fe0,
0x6000,
0x6000,
0x6000,
0x3060,
0x1fc0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 102 (0x66):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |      ***** |
   |     **     |
   |     **     |
   |     **     |
   |  ********  |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x03e0,
0x0600,
0x0600,
0x0600,
0x3fc0,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 103 (0x67):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |   ******** |
   |  **     ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   |  **    *** |
   |   ******** |
   |         ** |
   |         ** |
   |        **  |
   |  *******   |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x1fe0,
0x3060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x30e0,
0x1fe0,
0x0060,
0x0060,
0x00c0,
0x3f80,
0x0000,

/* Character 104 (0x68):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   | **         |
   | **         |
   | **         |
   | **         |
   | ********   |
   | **     **  |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x6000,
0x6000,
0x6000,
0x6000,
0x7f80,
0x60c0,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 105 (0x69):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |     **     |
   |     **     |
   |     **     |
   |            |
   |   ****     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |   ******   |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0600,
0x0600,
0x0600,
0x0000,
0x1e00,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x1f80,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 106 (0x6a):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |        **  |
   |        **  |
   |        **  |
   |            |
   |      ****  |
   |        **  |
   |        **  |
   |        **  |
   |        **  |
   |        **  |
   |        **  |
   |        **  |
   |        **  |
   |        **  |
   |        **  |
   |  **    **  |
   |  **    **  |
   |   **  **   |
   |    ****    |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x00c0,
0x00c0,
0x00c0,
0x0000,
0x03c0,
0x00c0,
0x00c0,
0x00c0,
0x00c0,
0x00c0,
0x00c0,
0x00c0,
0x00c0,
0x00c0,
0x00c0,
0x30c0,
0x30c0,
0x1980,
0x0f00,
0x0000,

/* Character 107 (0x6b):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |  **        |
   |  **        |
   |  **        |
   |  **        |
   |  **     ** |
   |  **    **  |
   |  **   **   |
   |  **  **    |
   |  ** **     |
   |  ****      |
   |  ** **     |
   |  **  **    |
   |  **   **   |
   |  **    **  |
   |  **     ** |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x3000,
0x3000,
0x3000,
0x3000,
0x3060,
0x30c0,
0x3180,
0x3300,
0x3600,
0x3c00,
0x3600,
0x3300,
0x3180,
0x30c0,
0x3060,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 108 (0x6c):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |   ****     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |   ******   |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x1e00,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x1f80,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 109 (0x6d):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   | ********   |
   | **  ** **  |
   | **  **  ** |
   | **  **  ** |
   | **  **  ** |
   | **  **  ** |
   | **  **  ** |
   | **  **  ** |
   | **  **  ** |
   | **  **  ** |
   | **  **  ** |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x7f80,
0x66c0,
0x6660,
0x6660,
0x6660,
0x6660,
0x6660,
0x6660,
0x6660,
0x6660,
0x6660,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 110 (0x6e):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   | ********   |
   | **     **  |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x7f80,
0x60c0,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 111 (0x6f):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |   ******   |
   |  **    **  |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   |  **    **  |
   |   ******   |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x1f80,
0x30c0,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x30c0,
0x1f80,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 112 (0x70):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   | ********   |
   | **     **  |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **     **  |
   | ********   |
   | **         |
   | **         |
   | **         |
   | **         |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x7f80,
0x60c0,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x60c0,
0x7f80,
0x6000,
0x6000,
0x6000,
0x6000,
0x0000,

/* Character 113 (0x71):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |   ******** |
   |  **     ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   |  **     ** |
   |   ******** |
   |         ** |
   |         ** |
   |         ** |
   |         ** |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x1fe0,
0x3060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x3060,
0x1fe0,
0x0060,
0x0060,
0x0060,
0x0060,
0x0000,

/* Character 114 (0x72):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   | **  ****** |
   | ** **      |
   | ****       |
   | ***        |
   | **         |
   | **         |
   | **         |
   | **         |
   | **         |
   | **         |
   | **         |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x67e0,
0x6c00,
0x7800,
0x7000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 115 (0x73):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |  ********  |
   | **      ** |
   | **         |
   | **         |
   | **         |
   |  ********  |
   |         ** |
   |         ** |
   |         ** |
   | **      ** |
   |  ********  |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x3fc0,
0x6060,
0x6000,
0x6000,
0x6000,
0x3fc0,
0x0060,
0x0060,
0x0060,
0x6060,
0x3fc0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 116 (0x74):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |    **      |
   |    **      |
   |    **      |
   |    **      |
   | ********   |
   |    **      |
   |    **      |
   |    **      |
   |    **      |
   |    **      |
   |    **      |
   |    **      |
   |    **      |
   |    **      |
   |     *****  |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x7f80,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x07c0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 117 (0x75):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   |  **     ** |
   |   ******** |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x3060,
0x1fe0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 118 (0x76):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   | **      ** |
   | **      ** |
   | **      ** |
   |  **    **  |
   |  **    **  |
   |   **  **   |
   |   **  **   |
   |    ****    |
   |    ****    |
   |     **     |
   |     **     |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x6060,
0x6060,
0x6060,
0x30c0,
0x30c0,
0x1980,
0x1980,
0x0f00,
0x0f00,
0x0600,
0x0600,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 119 (0x77):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **  **  ** |
   | **  **  ** |
   | **  **  ** |
   | **  **  ** |
   | **  **  ** |
   | **  **  ** |
   |  ********  |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x6060,
0x6060,
0x6060,
0x6060,
0x6660,
0x6660,
0x6660,
0x6660,
0x6660,
0x6660,
0x3fc0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 120 (0x78):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   | **      ** |
   | **      ** |
   |  **    **  |
   |   **  **   |
   |    ****    |
   |     **     |
   |    ****    |
   |   **  **   |
   |  **    **  |
   | **      ** |
   | **      ** |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x6060,
0x6060,
0x30c0,
0x1980,
0x0f00,
0x0600,
0x0f00,
0x1980,
0x30c0,
0x6060,
0x6060,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 121 (0x79):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   | **      ** |
   |  **    *** |
   |   ******** |
   |         ** |
   |         ** |
   |        **  |
   |  *******   |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x6060,
0x30e0,
0x1fe0,
0x0060,
0x0060,
0x00c0,
0x3f80,
0x0000,

/* Character 122 (0x7a):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   | ********** |
   |         ** |
   |        **  |
   |       **   |
   |      **    |
   |     **     |
   |    **      |
   |   **       |
   |  **        |
   | **         |
   | ********** |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x7fe0,
0x0060,
0x00c0,
0x0180,
0x0300,
0x0600,
0x0c00,
0x1800,
0x3000,
0x6000,
0x7fe0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 123 (0x7b):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |      ***   |
   |     **     |
   |    **      |
   |    **      |
   |    **      |
   |    **      |
   |    **      |
   |  ***       |
   |    **      |
   |    **      |
   |    **      |
   |    **      |
   |    **      |
   |     **     |
   |      ***   |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0380,
0x0600,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x3800,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0600,
0x0380,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 124 (0x7c):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 125 (0x7d):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |            |
   |            |
   |  ***       |
   |    **      |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |      ***   |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |     **     |
   |    **      |
   |  ***       |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x3800,
0x0c00,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0380,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0c00,
0x3800,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 126 (0x7e):
   width 12
   bbx ( 12, 24, 0, -5 )

   +------------+
   |            |
   |            |
   |  ****   ** |
   | **  **  ** |
   | **  **  ** |
   | **   ****  |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   |            |
   +------------+
*/
0x0000,
0x0000,
0x3c60,
0x6660,
0x6660,
0x63c0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
};

/* Exported structure definition. */
static const FontDesc stella12x24tDesc = {
  "ter-u24b",
  12,
  24,
  12, 24, 0, -5,
  19,
  28,
  99,
  stella12x24t_font_bits,
  nullptr,  /* no encode table*/
  nullptr,  /* fixed width*/
  nullptr,  /* fixed bbox*/
  32,
  sizeof(stella12x24t_font_bits)/sizeof(uInt16)
};

} // End of namespace GUI

#endif
