これは skk-tools に対するよくある質問と、それに対する回答集です。

skkdic-* コマンドの動作について
===============================

## skkdic-sort で辞書ファイルをソートしたら送りありエントリがちゃんとソートされません

辞書ファイルの文字コードは EUC になっていますか？

skkdic-sort などの C で実装されたコマンドは辞書ファイルの文字コードが
EUC であることを前提にしています。

ただし、ASCII の範囲外の文字において各バイトの８ビット目が１になってい
る文字コード（EUC-JP、EUC-JIS-2004、UTF-8 など）では正常に動作するよう
です。


辞書の形式について
==================

## 辞書の形式が良く分かりません

どんな小さな辞書でも必ず `;; okuri-ari entries.` と
`;; okuri-nasi entries.`の２行を含んでいます。前者の次行から送り仮
名を含むエントリが並びます。後者の前行までが送り仮名「あり」のエントリ
です。このエントリの集りを「送りありエントリ」と呼んだりします。

後者の次行から最終行までが「送りなしエントリ」です。
各行は

    さい /際/差異/才/再/最/歳/

のように、「見出し語 /候補0/候補1/候補2/.../候補n/」というような形式に
なっています。候補は前にある程優先して出力されます。

## 「エントリ」って何ですか？

見出し語と候補を合わせた 1 行を便宜上「エントリ」と呼んでいます。上記
の例ですと、

    さい /際/差異/才/再/最/歳/

がひとつのエントリです。

## 何故「送りありエントリ」と「送りなしエントリ」に分かれているのですか？

SKK では送り仮名があるかないかをユーザ側で明示して変換しますので、送り
仮名ありの変換を行なった場合は、「送りありエントリ」を、そうでない場合
は「送りなしエントリ」を検索します。

## ] だけの候補を含む妙なエントリがあります

    おおk /大/多/[き/大/]/[く/多/大/]/

のようなエントリのことをおしゃっているのでしょう。

このようなエントリは個人辞書の送りありエントリでしか見られません。

.skk で skk-henkan-okuri-strictly を t にセットすると、検索の際、送り
仮名の厳密なマッチを要求するようになります。このとき、検索の手順は、お
およそ次のようになります。例えば、`OoKi' とタイプすると、

(1) `おおk' を見出しとして個人辞書を検索。

(2) 見つかったら、次は同一行に `[き' があるかどうか検索する (あった!)。

(3) 見つかったら、次に現われる `]' までの間に挟まれている候補だけを出力す
   る (「大」だ!)。

従い、「多」については、候補として含まれているにもかかわらず、出力され
ません。

skk-henkan-okuri-strictly が nil の場合は、上記 (2), (3) のプロセスは
省略され、見出し語が見つかったら `[(送り仮名)' のような候補が出てくる
までの候補を全て出力します (上記の例ですと、「大」と「多」)。

skk-henkan-strict-okuri-precedence を t にセットすると、送り仮名がマッ
チするものを優先的に出力し、マッチしないものも劣後的に出力します。

## 個人辞書の見出し語がソートされていません

個人辞書は確定したもの順に並んでいます。比較的サイズが小さいことからリ
ニアサーチを前提にしていること (確定の度にきちんと見出し語をソートさせ
てバイナリサーチを行なうよりは効率が良いと判断しています)、また、見出
し語の補完で最近確定した見出しから順に出力するため、などの理由からこの
ような実装になっています。

## SKK-JISYO.{SML} の送りありエントリの見出し語のソートが逆順になっています

なんででしょう？  分かりません (^^;;。正確なところをご存知でしたら
skk@ring.gr.jp までご連絡下さい。

(1) 昔の個人辞書は送り仮名の自動処理のために、送りありエントリのみ見出
   し語を逆順ソートさせていたが、その名残り (現在は skk-auto.el の内部
   処理でこれと同等の作業を行なっています)。

(2) リニアサーチする際、`;; okuri-nasi entries.` の区切りを中心に、送
   りあり変換については上方に、送りなし変換については下方にサーチする
   ことでポイント移動を最小限に抑えることができるから。

なんてとこかな、と想像しているのですが。

[end of FAQ.txt]
