#encoding: utf-8
#- Name: SiSU
#
#  - Description: documents, structuring, processing, publishing, search
#    txt
#
#  - Author: Ralph Amissah
#    <ralph.amissah@gmail.com>
#
#  - Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
#    2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2019,
#    2020, 2021, Ralph Amissah,
#    All Rights Reserved.
#
#  - License: GPL 3 or later:
#
#    SiSU, a framework for document structuring, publishing and search
#
#    Copyright (C) Ralph Amissah
#
#    This program is free software: you can redistribute it and/or modify it
#    under the terms of the GNU General Public License as published by the Free
#    Software Foundation, either version 3 of the License, or (at your option)
#    any later version.
#
#    This program is distributed in the hope that it will be useful, but WITHOUT
#    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
#    FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
#    more details.
#
#    You should have received a copy of the GNU General Public License along with
#    this program. If not, see <http://www.gnu.org/licenses/>.
#
#    If you have Internet connection, the latest version of the GPL should be
#    available at these locations:
#    <http://www.fsf.org/licensing/licenses/gpl.html>
#    <http://www.gnu.org/licenses/gpl.html>
#
#    <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>
#
#  - SiSU uses:
#    - Standard SiSU markup syntax,
#    - Standard SiSU meta-markup syntax, and the
#    - Standard SiSU object citation numbering and system
#
#  - Homepages:
#    <http://www.sisudoc.org>
#
#  - Git
#    <https://git.sisudoc.org/projects/>
#    <https://git.sisudoc.org/projects/sisu>
#    <https://git.sisudoc.org/projects/sisu-markup>
module SiSU_Txt_Read
  require_relative 'se'                                 # se.rb
    include SiSU_Env
  def read_generic(opt,specific)
    begin
      env=SiSU_Env::InfoEnv.new(opt.fns)
      unless opt.act[:quiet][:set]==:on
        tool=(opt.act[:verbose][:set]==:on \
        || opt.act[:verbose_plus][:set]==:on \
        || opt.act[:maintenance][:set]==:on) \
        ? "#{env.program.text_editor} #{specific[:output_path]}/#{specific[:output_file]}"
        : "[#{opt.f_pth[:lng_is]}] #{opt.fno}"
        (opt.act[:verbose][:set]==:on \
        || opt.act[:verbose_plus][:set]==:on \
        || opt.act[:maintenance][:set]==:on) \
        ? SiSU_Screen::Ansi.new(
            opt.act[:color_state][:set],
            specific[:description],
            tool
          ).green_hi_blue
        : SiSU_Screen::Ansi.new(
            opt.act[:color_state][:set],
            specific[:description],
            tool
          ).green_title_hi
        if (opt.act[:verbose_plus][:set]==:on \
        || opt.act[:maintenance][:set]==:on)
          SiSU_Screen::Ansi.new(
            opt.act[:color_state][:set],
            opt.fns,
            "#{specific[:output_path]}/#{specific[:output_file]}"
          ).flow
        end
      end
      @ao_array=SiSU_AO::Source.new(opt).get # ao file drawn here
      @wrap_width=if defined? md.make.plaintext_wrap \
      and md.make.plaintext_wrap
        md.make.plaintext_wrap
      elsif defined? env.plaintext_wrap \
      and env.plaintext_wrap
        env.plaintext_wrap
      else 78
      end
      #wrap_width=(defined? md.make.plaintext_wrap) ? md.make.plaintext_wrap : 78
    rescue
      SiSU_Errors::Rescued.new($!,$@,opt.selections.str,opt.fns).location do
        __LINE__.to_s + ':' + __FILE__
      end
    ensure
    end
  end
end
__END__
