#encoding: utf-8
#- Name: SiSU
#
#  - Description: documents, structuring, processing, publishing, search
#    i18n
#
#  - Author: Ralph Amissah
#    <ralph.amissah@gmail.com>
#
#  - Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
#    2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2019,
#    2020, 2021, Ralph Amissah,
#    All Rights Reserved.
#
#  - License: GPL 3 or later:
#
#    SiSU, a framework for document structuring, publishing and search
#
#    Copyright (C) Ralph Amissah
#
#    This program is free software: you can redistribute it and/or modify it
#    under the terms of the GNU General Public License as published by the Free
#    Software Foundation, either version 3 of the License, or (at your option)
#    any later version.
#
#    This program is distributed in the hope that it will be useful, but WITHOUT
#    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
#    FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
#    more details.
#
#    You should have received a copy of the GNU General Public License along with
#    this program. If not, see <http://www.gnu.org/licenses/>.
#
#    If you have Internet connection, the latest version of the GPL should be
#    available at these locations:
#    <http://www.fsf.org/licensing/licenses/gpl.html>
#    <http://www.gnu.org/licenses/gpl.html>
#
#    <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>
#
#  - SiSU uses:
#    - Standard SiSU markup syntax,
#    - Standard SiSU meta-markup syntax, and the
#    - Standard SiSU object citation numbering and system
#
#  - Homepages:
#    <http://www.sisudoc.org>
#
#  - Git
#    <https://git.sisudoc.org/projects/>
#    <https://git.sisudoc.org/projects/?p=software/sisu.git;a=summary>
#    <https://git.sisudoc.org/projects/?p=markup/sisu-markup-samples.git;a=summary>
module SiSU_Translate
  require_relative 'se'                                 # se.rb
    include SiSU_Env; include SiSU_Param
  class Source
    def initialize(md,doc_lang,trans_str='')
      @md,@doc_lang,@trans_str=md,doc_lang,trans_str
      @lang_class=case @doc_lang
      when /American/i       then English.new(md,doc_lang,trans_str)    # tag depreciated, see iso 639-2
      when /English/i        then English.new(md,doc_lang,trans_str)
      when /French/i         then French.new(md,doc_lang,trans_str)
      when /German/i         then German.new(md,doc_lang,trans_str)
      when /Italian/i        then Italian.new(md,doc_lang,trans_str)
      when /Spanish/i        then Spanish.new(md,doc_lang,trans_str)
      when /Portuguese Brazil|Brazilian(?: Portuguese)?/i
                                  Portuguese.new(md,doc_lang,trans_str) # tag depreciated, see iso 639-2
      when /Portuguese/i     then Portuguese.new(md,doc_lang,trans_str)
      when /Swedish/i        then Swedish.new(md,doc_lang,trans_str)
      when /Danish/i         then Danish.new(md,doc_lang,trans_str)
      when /Finnish/i        then Finnish.new(md,doc_lang,trans_str)
      when /Norwegian/i      then Norwegian.new(md,doc_lang,trans_str)
      when /Icelandic/i      then Icelandic.new(md,doc_lang,trans_str)
      when /Dutch/i          then Dutch.new(md,doc_lang,trans_str)
      when /Estonian/i       then Estonian.new(md,doc_lang,trans_str)
      when /Hungarian/i      then Hungarian.new(md,doc_lang,trans_str)
      when /Polish/i         then Polish.new(md,doc_lang,trans_str)
      when /Romanian/i       then Romanian.new(md,doc_lang,trans_str)
      when /Russian/i        then Russian.new(md,doc_lang,trans_str)
      when /Greek/i          then Greek.new(md,doc_lang,trans_str)
      when /Ukranian/i       then Ukranian.new(md,doc_lang,trans_str)
      when /Turkish/i        then Turkish.new(md,doc_lang,trans_str)
      when /Slovenian/i      then Slovenian.new(md,doc_lang,trans_str)
      when /Croatian/i       then Croatian.new(md,doc_lang,trans_str)
      when /Slovak(?:ian)?/i then Slovak.new(md,doc_lang,trans_str)
      when /Czech/i          then Czech.new(md,doc_lang,trans_str)
      when /Bulgarian/i      then Bulgarian.new(md,doc_lang,trans_str)
      else                        English.new(md,doc_lang,trans_str)
      end
    end
    def filename
      @lang_class.filename
    end
    def metadata
      @lang_class.metadata
    end
    def filetype_description
      @lang_class.filetype_description
    end
    def file_size
      @lang_class.file_size
    end
    def sourcefile
      @lang_class.sourcefile
    end
    def sourcefile_digest
      @lang_class.sourcefile_digest
    end
    def full_title #dc
      @lang_class.full_title
    end
    def title
      @lang_class.title
    end
    def subtitle
      @lang_class.subtitle
    end
    def author
      @lang_class.author
    end
    def contributor
      @lang_class.contributor
    end
    def translator
      @lang_class.translator
    end
    def illustrator
      @lang_class.illustrator
    end
    def publisher
      @lang_class.publisher
    end
    def prepared_by
      @lang_class.prepared_by
    end
    def digitized_by
      @lang_class.digitized_by
    end
    def contents
      @lang_class.contents
    end
    def subject
      @lang_class.subject
    end
    def description #dc (watch)
      @lang_class.description
    end
    def abstract
      @lang_class.abstract
    end
    def type
      @lang_class.type
    end
    def rights
      @lang_class.rights
    end
    def date
      @lang_class.date
    end
    def date_created
      @lang_class.date_created
    end
    def date_available
      @lang_class.date_available
    end
    def date_valid
      @lang_class.date_valid
    end
    def date_modified
      @lang_class.date_modified
    end
    def date_issued
      @lang_class.date_issued
    end
    def language
      @lang_class.language
    end
    def language_original
      @lang_class.language_original
    end
    def format
      @lang_class.format
    end
    def identifier
      @lang_class.identifier
    end
    def source
      @lang_class.source
    end
    def relation
      @lang_class.relation
    end
    def coverage
      @lang_class.coverage
    end
    def keywords
      @lang_class.keywords
    end
    def comments
      @lang_class.comments
    end
    def cls_loc
      @lang_class.cls_loc
    end
    def cls_dewey
      @lang_class.cls_dewey
    end
    def cls_oclc
      @lang_class.cls_oclc
    end
    def cls_gutenberg
      @lang_class.cls_gutenberg
    end
    def cls_isbn
      @lang_class.cls_isbn
    end
    def prefix_a
      @lang_class.prefix_a
    end
    def prefix_b
      @lang_class.prefix_b
    end
    def topic_register
      @lang_class.topic_register
    end
    def fns
      @lang_class.fns
    end
    def word_count
      @lang_class.word_count
    end
    def dgst
      @lang_class.dgst
    end
    def sc_number
      @lang_class.sc_number
    end
    def sc_date
      @lang_class.sc_date
    end
    def last_generated
      @lang_class.last_generated
    end
    def sisu_version
      @lang_class.sisu_version
    end
    def ruby_version
      @lang_class.ruby_version
    end
    def suggested_links
      @lang_class.suggested_links
    end
    def language_version_list
      @lang_class.language_version_list
    end
    def language
      @lang_class.language
    end
    def manifest_description
      @lang_class.manifest_description
    end
    def manifest_description_output
      @lang_class.manifest_description_output
    end
    def manifest_description_metadata
      @lang_class.manifest_description_metadata
    end
    def language_list_translated
      @lang_class.language_list
    end
    def language_list
      case @trans_str
      when /American/i       then 'American English'                    # tag depreciated, see iso 639-2
      when /English/i        then 'English'
      when /French/i         then 'français'
      when /German/i         then 'Deutsch'
      when /Italian/i        then 'Italiano'
      when /Spanish/i        then 'español'
      when /Portuguese Brazil|Brazilian(?: Portuguese)?/i
                                  'Brazilian Português'                 # tag depreciated, see iso 639-2
      when /Portuguese/i     then 'Português'
      when /Swedish/i        then 'svenska'
      when /Danish/i         then 'dansk'
      when /Finnish/i        then 'suomi'
      when /Norwegian/i      then 'norsk'
      when /Icelandic/i      then 'Icelandic'
      when /Dutch/i          then 'Nederlands'
      when /Estonian/i       then 'Estonian'
      when /Hungarian/i      then 'Hungarian'
      when /Polish/i         then 'polski'
      when /Romanian/i       then 'română'
      when /Russian/i        then 'Русский (Russkij)'
      when /Greek/i          then 'Ελληνικά (Ellinika)'
      when /Ukranian/i       then 'українська (ukrajins\'ka)'
      when /Turkish/i        then 'Türkçe'
      when /Slovenian/i      then 'Slovenian'
      when /Croatian/i       then 'Croatian'
      when /Slovak(?:ian)?/i then 'slovensky'            #slovensky ?
      when /Czech/i          then 'česky'
      when /Bulgarian/i      then 'Български (Bəlgarski)'
      when /Japanese/i       then '日本語 (Nihongo)'
      when /Korean/i         then '한국어 (Hangul)'
     #when /Catalan/i        then 'català'
      else                         'English'
      end
      #check on 中文  and عربي
    end
  end
  class English
    def initialize(md,doc_lang,trans_str)
      @md,@doc_lang,@trans_str=md,doc_lang,trans_str
    end
    def filename
      'filename'
    end
    def filetype_description
      'filetype description'
    end
    def metadata
      'metadata'
    end
    def file_size
      'file size'
    end
    def full_title #dc
      'Title'
    end
    def title
      'Title'
    end
    def subtitle
      'Subtitle'
    end
    def author
      'Author'
    end
    def creator #dc
      'Creator'
    end
    def contributor #dc
      'Contributor'
    end
    def translator
      'Translator'
    end
    def illustrator
      'Illustrator'
    end
    def publisher #dc
      'Publisher'
    end
    def prepared_by
      'Prepared by'
    end
    def digitized_by
      'Digitized by'
    end
    def contents
      'Contents'
    end
    def subject #dc
      'Subject'
    end
    def description #dc (watch)
      'Description'
    end
    def abstract #dc
      'Abstract'
    end
    def type #dc
      'Type'
    end
    def rights #dc
      'Rights'
    end
    def date #dc
      'Date'
    end
    def date_created #dc
      'Date created'
    end
    def date_issued #dc
      'Date issued'
    end
    def date_available #dc
      'Date available'
    end
    def date_modified #dc
      'Date modified'
    end
    def date_valid #dc
      'Date valid'
    end
    def language #dc
      'Language'
    end
    def language_original
      'Original Language'
    end
    def format #dc
      'Format'
    end
    def identifier #dc
      'Identifier'
    end
    def source #dc
      'Source'
    end
    def relation #dc
      'Relation'
    end
    def coverage #dc
      'Coverage'
    end
    def keywords
      'Keywords'
    end
    def comments
      'Comments'
    end
    def cls_loc
      'Classify Library of Congress'
    end
    def cls_dewey
      'Classify Dewey'
    end
    def cls_oclc
      'Classify OCLC number'
    end
    def cls_gutenberg
      'Classify Project Gutenberg'
    end
    def cls_isbn
      'Classify ISBN'
    end
    def prefix_a
      'Prefix (a)'
    end
    def prefix_b
      'Prefix (b)'
    end
    def topic_register
      'Topics Registered'
    end
    def sourcefile
      'Sourcefile'
    end
    def word_count
      'Word Count approximate'
    end
    def sourcefile_digest
      'Sourcefile Digest'
    end
    def digest_md5
      'Sourcefile Digest (md5)'
    end
    def digest_sha256
      'Sourcefile Digest (sha256)'
    end
    def sc_number
      'Document (RCS/CVS) number'
    end
    def sc_date
      'Document (RCS/CVS) number'
    end
    def last_generated
      'Document (ao) last generated'
    end
    def sisu_version
      'Generated by'
    end
    def ruby_version
      'Ruby version'
    end
    def suggested_links
      'metadata suggested links'
    end
    def language_version_list
      'Document Language Versions, manifests'
    end
    def manifest_description
      'SiSU manifest of document filetypes and metadata'
    end
    def manifest_description_output
      'Available document filetypes'
    end
    def manifest_description_metadata
      'Document Metadata'
    end
    def language_list_translated
      case @trans_str
      when /American/i       then 'American English'                    # tag depreciated, see iso 639-2
      when /English/i        then 'English'
      when /French/i         then 'French'
      when /German/i         then 'German'
      when /Italian/i        then 'Italian'
      when /Spanish/i        then 'Spanish'
      when /Portuguese Brazil|Brazilian(?: Portuguese)?/i
                                  'Brazilian Portuguese'                # tag depreciated, see iso 639-2
      when /Portuguese/i     then 'Portuguese'
      when /Swedish/i        then 'Swedish'
      when /Danish/i         then 'Danish'
      when /Finnish/i        then 'Finnish'
      when /Norwegian/i      then 'Norwegian'
      when /Icelandic/i      then 'Icelandic'
      when /Dutch/i          then 'Dutch'
      when /Estonian/i       then 'Estonian'
      when /Hungarian/i      then 'Hungarian'
      when /Polish/i         then 'Polish'
      when /Romanian/i       then 'Romanian'
      when /Russian/i        then 'Russian'
      when /Greek/i          then 'Greek'
      when /Ukranian/i       then 'Ukranian'
      when /Turkish/i        then 'Turkish'
      when /Slovenian/i      then 'Slovenian'
      when /Croatian/i       then 'Croatian'
      when /Slovak(?:ian)?/i then 'Slovakian'
      when /Czech/i          then 'Czech'
      when /Bulgarian/i      then 'Bulgarian'
      else @trans_str
      end
    end
  end
  class French
    def initialize(md,doc_lang,trans_str)
      @md,@doc_lang,@trans_str=md,doc_lang,trans_str
    end
    def filename
      'nom de fichier'
    end
    def filetype_description
      description
    end
    def metadata
      'metadonnées'
    end
    def file_size
      'taille'
    end
    def full_title #dc
      'Titre'
    end
    def title
      'Titre'
    end
    def subtitle
      'Sous titre'
    end
    def author
      'Auteur'
    end
    def author #dc
      'Auteur'
    end
    def contributor #dc
      'Contributeur'
    end
    def translator
      'Traducteur'
    end
    def illustrator
      'Illustrateur'
    end
    def publisher #dc
      'Éditeur'
    end
    def prepared_by
      'Préparé par'
    end
    def digitized_by
      'Numérisé par'
    end
    def contents
      'Contents' #translate
    end
    def subject #dc
      'Sujet'
    end
    def description #dc (watch)
      'Description'
    end
    def abstract #dc
      'Résumé'
    end
    def type #dc
      'Type'
    end
    def rights #dc
      'Droits relatifs à la ressource'
    end
    def date #dc
      'Date'
    end
    def date_created #dc
      'Date de création'
    end
    def date_issued #dc
      'Date de publication'
    end
    def date_available #dc
      'Date de mise à disposition'
    end
    def date_modified #dc
      'Date de modification'
    end
    def date_valid #dc
      'Date de validité'
    end
    def language #dc
      'Langue'
    end
    def language_original
      'Langue originale'
    end
    def format #dc
      'Format'
    end
    def identifier #dc
      'Identifiant'
    end
    def source #dc
      'Source'
    end
    def relation #dc
      'Lien'
    end
    def coverage #dc
      'Portée du document'
    end
    def keywords
      'Mots clef'
    end
    def comments
      'Commentaires'
    end
    def cls_loc
      'Classification de la bibliothèque du congres'
    end
    def cls_dewey
      'Classification Dewey'
    end
    def cls_oclc # fix
      'Classify OCLC number'
    end
    def cls_gutenberg
      'Classification du project Gutenberg'
    end
    def cls_isbn
      'Classification ISBN'
    end
    def prefix_a
      'Préfixe (a)'
    end
    def prefix_b
      'Préfixe (b)'
    end
    def topic_register
      'Topics Registered'
    end
    def sourcefile
      'Fichier source'
    end
    def word_count
      'Nombre approximatif de mots'
    end
    def sourcefile_digest
      'Condensé du fichier source'
    end
    def digest_md5
      'Condensé du fichier source (md5)'
    end
    def digest_sha256
      'Condensé du fichier source (sha256)'
    end
    def sc_number
      'Numéro (RCS/CVS) du document'
    end
    def sc_date
      'Numéro (RCS/CVS) du document'
    end
    def last_generated
      'Dernière production du document (metaverse)'
    end
    def sisu_version
      'Généré par'
    end
    def ruby_version
      'Version de Ruby'
    end
    def suggested_links
      'Liens suggérés'
    end
    def language_version_list
      'Versions des langues du document, manifestes'
    end
    def manifest_description
      'SiSU manifest of document filetypes and metadata'
    end
    def manifest_description_output
      'Manifeste SiSU du document généré'
    end
    def manifest_description_metadata
      'Manifeste SiSU des métadonnées du document'
    end
    def language_list_translated
      case @trans_str
      when /American/i       then 'Anglais americain'                   # tag depreciated, see iso 639-2
      when /English/i        then 'Anglais'
      when /French/i         then 'Français'
      when /German/i         then 'Allemand'
      when /Italian/i        then 'Italien'
      when /Spanish/i        then 'Espagnol'
      when /Portuguese Brazil|Brazilian(?: Portuguese)?/i
                                  'Portugais brésilien'                 # tag depreciated, see iso 639-2
      when /Portuguese/i     then 'Portugais'
      when /Swedish/i        then 'Suédois'
      when /Danish/i         then 'Danois'
      when /Finnish/i        then 'Finnois'
      when /Norwegian/i      then 'Norvégien'
      when /Icelandic/i      then 'Islandais'
      when /Dutch/i          then 'Néerlandais'
      when /Estonian/i       then 'Estonien'
      when /Hungarian/i      then 'Hongrois'
      when /Polish/i         then 'Polonais'
      when /Romanian/i       then 'Roumain'
      when /Russian/i        then 'Russe'
      when /Greek/i          then 'Grec'
      when /Ukranian/i       then 'Ukrainien'
      when /Turkish/i        then 'Turc'
      when /Slovenian/i      then 'Slovène'
      when /Croatian/i       then 'Croate'
      when /Slovak(?:ian)?/i then 'Slovaque'
      when /Czech/i          then 'Tcheque'
      when /Bulgarian/i      then 'Bulgare'
      else @trans_str
      end
    end
  end
  class German
    def initialize(md,doc_lang,trans_str)
      @md,@doc_lang,@trans_str=md,doc_lang,trans_str
    end
    def filename
      'Dateiname'
    end
    def filetype_description
      description
    end
    def metadata
      'Metadata'
    end
    def file_size
      'Dateigrösse'
    end
    def full_title #dc
      'Titel'
    end
    def title
      'Titel'
    end
    def subtitle
      'Untertitel'
    end
    def author
      'Autor'
    end
    def contributor #dc
      'Mitautor'
    end
    def translator
      'Übersetzung'
    end
    def illustrator
      'Illustrator'
    end
    def publisher
      'Herausgeber'
    end
    def prepared_by
      'gesetzt von'
    end
    def digitized_by
      'digitalisiert von'
    end
    def contents
      'Contents' #translate
    end
    def subject
      'Titel'
    end
    def description #dc (watch)
      'Beschreibung'
    end
    def abstract #dc
      'Abstract'
    end
    def type
      'Typ'
    end
    def rights
      'Rechte'
    end
    def date
      'Datum'
    end
    def date_created
      'Erstellung'
    end
    def date_issued
      'Herausgabe'
    end
    def date_available
      'Veröffentlichung'
    end
    def date_modified
      'Modifikation'
    end
    def date_valid
      'Gültigkeit'
    end
    def language
      'Sprache'
    end
    def language_original
      'Ursprungssprache'
    end
    def format #dc
      'Format'
    end
    def identifier #dc
      'Bezeichnung'
    end
    def source #dc
      'Quelle'
    end
    def relation #dc
      'Beziehung'
    end
    def coverage #dc
      'Eingrenzung'
    end
    def keywords
      'Schlüsselwörter'
    end
    def comments
      'Kommentare'
    end
    def cls_loc
      'Klassifikation nach Library of Congress'
    end
    def cls_dewey
      'Klassifikation nach Dewey'
    end
    def cls_oclc # fix
      'Classify OCLC number'
    end
    def cls_gutenberg
      'Klassifikation nach Projekt Gutenberg'
    end
    def cls_isbn
      'Klassifikation nach ISBN'
    end
    def prefix_a
      'Präfix (a)'
    end
    def prefix_b
      'Präfix (b)'
    end
    def topic_register
      'Topics Registered'
    end
    def sourcefile
      'Quelldatei'
    end
    def word_count
      'Anzahl Wörter'
    end
    def sourcefile_digest
      'Quelldatei Digest'
    end
    def digest_md5
      'Prüfsumme der Quelldatei (MD5)'
    end
    def digest_sha256
      'Prüfsumme der Quelldatei (SHA256)'
    end
    def sc_number
      'Dokumentversion (RCS/CVS)'
    end
    def sc_date
      'Dokumentdatum (RCS/CVS)'
    end
    def last_generated
      'Letzte Erstellung (metaverse)'
    end
    def sisu_version
      'erstellt bei'
    end
    def ruby_version
      'Ruby Version'
    end
    def suggested_links
      'empfohlene Links'
    end
    def language_version_list
      'verfügbare Sprachen'
    end
    def manifest_description
      'SiSU manifest of document filetypes and metadata'
    end
    def manifest_description_output
      'SiSU Zusammenfassung des Dokumentes'
    end
    def manifest_description_metadata
      'SiSU Zusammenfassung der Metadaten'
    end
    def language_list_translated
      case @trans_str
      when /American/i       then 'Amerikanisch-Englisch'               # tag depreciated, see iso 639-2
      when /English/i        then 'Englisch'
      when /French/i         then 'Französisch'
      when /German/i         then 'Deutsch'
      when /Italian/i        then 'Italienisch'
      when /Spanish/i        then 'Spanisch'
      when /Portuguese Brazil|Brazilian(?: Portuguese)?/i
                                  'Brasilianisch-Portugiesisch'         # tag depreciated, see iso 639-2
      when /Portuguese/i     then 'Portugiesisch'
      when /Swedish/i        then 'Schwedisch'
      when /Danish/i         then 'Dänisch'
      when /Finnish/i        then 'Finnisch'
      when /Norwegian/i      then 'Norwegisch'
      when /Icelandic/i      then 'Isländisch'
      when /Dutch/i          then 'Niederländisch'
      when /Estonian/i       then 'Estnisch'
      when /Hungarian/i      then 'Ungarisch'
      when /Polish/i         then 'Polnisch'
      when /Romanian/i       then 'Rumänisch'
      when /Russian/i        then 'Russisch'
      when /Greek/i          then 'Griechisch'
      when /Ukranian/i       then 'Ukrainisch'
      when /Turkish/i        then 'Türkisch'
      when /Slovenian/i      then 'Slovenisch'
      when /Croatian/i       then 'Kroatisch'
      when /Slovak(?:ian)?/i then 'Slovakisch'
      when /Czech/i          then 'Tschechisch'
      when /Bulgarian/i      then 'Bulgarisch'
      else @trans_str
      end
    end
  end
  class Spanish
    def initialize(md,doc_lang,trans_str)
      @md,@doc_lang,@trans_str=md,doc_lang,trans_str
    end
    def filename
     'nombre del fichero'
    end
    def filetype_description
      description
    end
    def metadata
      'metadatos'
    end
    def file_size
      'tamaño del fichero'
    end
    def full_title #dc
      'Título'
    end
    def title
      'Título'
    end
    def subtitle
      'Subtítulo'
    end
    def author #dc
      'Creador'
    end
    def contributor #dc
      'Contribuidor'
    end
    def translator
      'Traductor'
    end
    def illustrator
      'Ilustrador'
    end
    def publisher #dc
      'Editor'
    end
    def prepared_by
      'Preparado por'
    end
    def digitized_by
      'Digitalizado por'
    end
    def contents
      'Contents' #translate
    end
    def subject #dc
      'Asunto'
    end
    def description #dc (watch)
      'Descripción'
    end
    def abstract #dc
      'Resumen'
    end
    def type #dc
      'Tipo'
    end
    def rights #dc
      'Derechos'
    end
    def date #dc
      'Fecha'
    end
    def date_created #dc
      'Fecha de creación'
    end
    def date_issued #dc
      'Fecha de publicación'
    end
    def date_available #dc
      'Fecha de disponibilidad'
    end
    def date_modified #dc
      'Fecha de modificación'
    end
    def date_valid #dc
      'Fecha de valided'
    end
    def language #dc
      'Idioma'
    end
    def language_original
      'Lenguaje original'
    end
    def format #dc
      'Formato'
    end
    def identifier #dc
      'Identificador'
    end
    def source #dc
      'Fuente'
    end
    def relation #dc
      'Relación'
    end
    def coverage #dc
      'Cobertura'
    end
    def keywords
      'Palabras claves'
    end
    def comments
      'Comentarios'
    end
    def cls_loc
      'Clasificación Biblioteca del Congreso'
    end
    def cls_dewey
      'Clasificación Dewey'
    end
     def cls_oclc # fix
       'Classify OCLC number'
     end
    def cls_gutenberg
      'Clasificación Proyecto Gutenberg'
    end
    def cls_isbn
      'Clasificación ISBN'
    end
    def prefix_a
      'Prefijo (a)'
    end
    def prefix_b
      'Prefijo (b)'
    end
     def topic_register
       'Topics Registered'
     end
    def sourcefile
      'Fichero fuente'
    end
    def word_count
      'Número de palabras apróximado'
    end
    def sourcefile_digest
      'Resumen del fichero fuente'
    end
    def digest_md5
      'Resumen del fichero fuente (md5)'
    end
    def digest_sha256
      'Resumen del fichero fuente (sha256)'
    end
    def sc_number
      'Versión (RCS/CVS) del documento'
    end
    def sc_date
      'Versión (RCS/CVS) del documento'
    end
    def last_generated
      'Última generación (metaverse) del documento'
    end
    def sisu_version
      'Generado por'
    end
    def ruby_version
      'Versión de Ruby'
    end
    def suggested_links
      'enlaces sugeridos de metadatos'
    end
    def language_version_list
      'Document Language Versions, manifests'
    end
     def manifest_description
       'SiSU manifest of document filetypes and metadata'
     end
    def manifest_description_output
      'Manifiesto SiSU de salida generada'
    end
    def manifest_description_metadata
      'Manifiesto SiSU de metadatos de documento'
    end
    def language_list_translated
      case @trans_str
      when /American/i       then 'Inglés Americano'                     # tag depreciated, see iso 639-2
      when /English/i        then 'Inglés'
      when /French/i         then 'Francés'
      when /German/i         then 'Alemán'
      when /Italian/i        then 'Italiano'
      when /Spanish/i        then 'Español'
      when /Portuguese Brazil|Brazilian(?: Portuguese)?/i
                                  'Portugués de Brasil'                  # tag depreciated, see iso 639-2
      when /Portuguese/i     then 'Portugués'
      when /Swedish/i        then 'Sueco'
      when /Danish/i         then 'Danés'
      when /Finnish/i        then 'Finés'
      when /Norwegian/i      then 'Noruego'
      when /Icelandic/i      then 'Islandés'
      when /Dutch/i          then 'Holandés'
      when /Estonian/i       then 'Estonio'
      when /Hungarian/i      then 'Húngaro'
      when /Polish/i         then 'Polaco'
      when /Romanian/i       then 'Rumano'
      when /Russian/i        then 'Ruso'
      when /Greek/i          then 'Griego'
      when /Ukranian/i       then 'Ucraniano'
      when /Turkish/i        then 'Turco'
      when /Slovenian/i      then 'Eslovaco'
      when /Croatian/i       then 'Croata'
      when /Slovak(?:ian)?/i then 'Eslovaco'
      when /Czech/i          then 'Checo'
      when /Bulgarian/i      then 'Búlgaro'
      else @trans_str
      end
    end
  end
  class Italian
    def initialize(md,doc_lang,trans_str)
      @md,@doc_lang,@trans_str=md,doc_lang,trans_str
    end
    def filename
      'nome del file'
    end
    def filetype_description
      description
    end
    def metadata
      'metadati'
    end
    def file_size
      'dimensione'
    end
    def full_title #dc
      'Titolo'
    end
    def title
      'Titolo'
    end
    def subtitle
      'Sottotitolo'
    end
    def author #dc
      'Autore'
    end
    def contributor #dc
      'Contributore'
    end
    def translator
      'Traduttore'
    end
    def illustrator
      'Illustratore'
    end
    def publisher #dc
      'Casa editrice'
    end
    def prepared_by
      'Preparato da'
    end
    def digitized_by
      'Convertito in digitale da'
    end
    def contents
      'Contents' #translate
    end
    def subject #dc
      'Oggetto'
    end
    def description #dc (watch)
      'Descrizione'
    end
    def abstract #dc
      'Abstract'
    end
    def type #dc
      'Tipo'
    end
    def rights #dc
      'Diritti del lettore'
    end
    def date #dc
      'Data'
    end
    def date_created #dc
      'Data di creazione'
    end
    def date_issued #dc
      'Data di pubblicazione'
    end
    def date_available #dc
      'Data di effettiva disponibilità'
    end
    def date_modified #dc
      'Data di ultima modifica'
    end
    def date_valid #dc
      'Data di inizo validità'
    end
    def language #dc
      'Lingua'
    end
    def language_original
      'Lingua originale'
    end
    def format #dc
      'Formato'
    end
    def identifier #dc
      'Indentificatore'
    end
    def source #dc
      'Fonte'
    end
    def relation #dc
      'Collegamento'
    end
    def coverage #dc
      'Ambito'
    end
    def keywords
      'Parole chiave'
    end
    def comments
      'Commenti'
    end
    def cls_loc
      'Classificazione della Library of Congress'
    end
    def cls_dewey
      'Classificazione Dewey'
    end
    def cls_oclc # fix
      'Classify OCLC number'
    end
    def cls_gutenberg
      'Classificazione del Progetto Gutenberg'
    end
    def cls_isbn
      'Numero ISBN'
    end
    def prefix_a
      'Premessa (a)'
    end
    def prefix_b
      'Premessa (b)'
    end
    def topic_register
      'Topics Registered'
    end
    def sourcefile
      'Sorgente'
    end
    def word_count
      'Numero approssimativo di parole'
    end
    def sourcefile_digest
      'Checksum file sorgente'
    end
    def digest_md5
      'Checksum file sorgente (md5)'
    end
    def digest_sha256
      'Checksum file sorgente (sha256)'
    end
    def sc_number
      'Numero di revisione (RCS/CVS)'
    end
    def sc_date
      'Numero di revisione (RCS/CVS)'
    end
    def last_generated
      'Data di ultima generazione (ao metaverse)'
    end
    def sisu_version
      'Generato da'
    end
    def ruby_version
      'Ruby versione'
    end
    def suggested_links
      'Link suggeriti'
    end
    def language_version_list
      'Traduzioni disponibili'
    end
    def manifest_description
      'SiSU manifest of document filetypes and metadata'
    end
    def manifest_description_output
      'Inventario SiSU dell\'output generato'
    end
    def manifest_description_metadata
      'Inventario SiSU dei metadati'
    end
    def language_list_translated
      case @trans_str
      when /American/i       then 'Inglese USA'                         # tag depreciated, see iso 639-2
      when /English/i        then 'Inglese'
      when /French/i         then 'Francese'
      when /German/i         then 'Tedesco'
      when /Italian/i        then 'Italiano'
      when /Spanish/i        then 'Spagnolo'
      when /Portuguese Brazil|Brazilian(?: Portuguese)?/i
                                  'Portoguese (Brasile)'                # tag depreciated, see iso 639-2
      when /Portuguese/i     then 'Portoguese'
      when /Swedish/i        then 'Svedese'
      when /Danish/i         then 'Danese'
      when /Finnish/i        then 'Finlandese'
      when /Norwegian/i      then 'Norvegese'
      when /Icelandic/i      then 'Islandese'
      when /Dutch/i          then 'Olandese'
      when /Estonian/i       then 'Estone'
      when /Hungarian/i      then 'Ungherese'
      when /Polish/i         then 'Polacco'
      when /Romanian/i       then 'Romeno'
      when /Russian/i        then 'Russo'
      when /Greek/i          then 'Greco'
      when /Ukranian/i       then 'Ucraino'
      when /Turkish/i        then 'Turco'
      when /Slovenian/i      then 'Sloveno'
      when /Croatian/i       then 'Croato'
      when /Slovak(?:ian)?/i then 'Slovacco'
      when /Czech/i          then 'Ceco'
      when /Bulgarian/i      then 'Bulgaro'
      else @trans_str
      end
    end
  end
  class Finnish
    def initialize(md,doc_lang,trans_str)
      @md,@doc_lang,@trans_str=md,doc_lang,trans_str
    end
    def filename
     'tiedostonimi'
    end
    def filetype_description
      description
    end
    def metadata
      'metadata'
    end
    def file_size
      'tiedoston koko'
    end
    def full_title #dc
      'otsikko'
    end
    def title
      'Otsikko'
    end
    def subtitle
      'Alaotsikko'
    end
    def author #dc
      'tekijä'
    end
    def contributor #dc
      'osallistuja'
    end
    def translator
      'Kääntäjä'
    end
    def illustrator
      'Kuvittaja'
    end
    def publisher #dc
      'julkaisija'
    end
    def prepared_by
      'Valmistaja'
    end
    def digitized_by
      'Digitalisoinut'
    end
    def contents
      'Contents' #translate
    end
    def subject #dc
      'aihe'
    end
    def description #dc (watch)
      'kuvaus'
    end
    def abstract #dc
      'tiivistelmä'
    end
    def type #dc
      'tyyppi'
    end
    def rights #dc
      'oikeudet'
    end
    def date #dc
      'päiväys'
    end
    def date_created #dc
      'luontipäivä'
    end
    def date_issued #dc
      'julkaisupäivä'
    end
    def date_available #dc
      'saantipäivä'
    end
    def date_modified #dc
      'muokkauspäivä'
    end
    def date_valid #dc
      'kelpoisuuspäivä'
    end
    def language #dc
      'kieli'
    end
    def language_original
      'Alkuperäiskieli'
    end
    def format #dc
      'muoto'
    end
    def identifier #dc
      'tunnus'
    end
    def source #dc
      'lähde'
    end
    def relation #dc
      'suhde'
    end
    def coverage #dc
      'kattavuus'
    end
    def keywords
      'Avainsanat'
    end
    def comments
      'Kommentit'
    end
    def cls_loc
      'Classify Library of Congress'
    end
    def cls_dewey
      'Classify Dewey'
    end
    def cls_oclc # fix
      'Classify OCLC number'
    end
    def cls_gutenberg
      'Classify Project Gutenberg'
    end
    def cls_isbn
      'Classify ISBN'
    end
    def prefix_a
      'Prefix (a)'
    end
    def prefix_b
      'Prefix (b)'
    end
    def topic_register
      'Topics Registered'
    end
    def sourcefile
      'Lähdetiedosto'
    end
    def word_count
      'Arvioitu sanamäärä'
    end
    def sourcefile_digest
      'Lähdetiedoston tiiviste'
    end
    def digest_md5
      'Lähdetiedoston tiiviste (md5)'
    end
    def digest_sha256
      'Lähdetiedoston tiiviste (sha256)'
    end
    def sc_number
      'Dokumentin RCS/CVS-numero'
    end
    def sc_date
      'Dokumentin RCS/CVS-päiväys'
    end
    def last_generated
      'Viimeksi tuotettu dokumentti (metaverse)'
    end
    def sisu_version
      'Generoinut'
    end
    def ruby_version
      'Ruby-versio'
    end
    def suggested_links
      'metadatan ehdottamat linkit'
    end
    def language_version_list
      'Dokumentin kieliversiot, manifestit'
    end
    def manifest_description
      'SiSU manifest of document filetypes and metadata'
    end
    def manifest_description_output
      'Tuotetun tuloksen SISU-manifesti'
    end
    def manifest_description_metadata
      'Dokumenttimetadatan SISU-manifesti'
    end
    def language_list_translated
      case @trans_str
      when /American/i       then 'Amerikanenglanti'                    # tag depreciated, see iso 639-2
      when /English/i        then 'Englanti'
      when /French/i         then 'Ranska'
      when /German/i         then 'Saksa'
      when /Italian/i        then 'Italia'
      when /Spanish/i        then 'Espanja'
      when /Portuguese Brazil|Brazilian(?: Portuguese)?/i
                                  'Brasilian portugali'                 # tag depreciated, see iso 639-2
      when /Portuguese/i     then 'Portugali'
      when /Swedish/i        then 'Ruotsi'
      when /Danish/i         then 'Tanska'
      when /Finnish/i        then 'Suomi'
      when /Norwegian/i      then 'Norja'
      when /Icelandic/i      then 'Islanti'
      when /Dutch/i          then 'Hollanti'
      when /Estonian/i       then 'Viro'
      when /Hungarian/i      then 'Unkari'
      when /Polish/i         then 'Puola'
      when /Romanian/i       then 'Romania'
      when /Russian/i        then 'Venäjä'
      when /Greek/i          then 'Kreikka'
      when /Ukranian/i       then 'Ukraina'
      when /Turkish/i        then 'Turkki'
      when /Slovenian/i      then 'Slovenia'
      when /Croatian/i       then 'Kroatia'
      when /Slovak(?:ian)?/i then 'Slovakki'
      when /Czech/i          then 'Tsekki'
      when /Bulgarian/i      then 'Bulgaria'
      else @trans_str
      end
    end
  end
  class Portuguese            < English
  end
  class Swedish               < English
    def contents
      'Innehåll'
    end
  end
  class Danish                < English
  end
  class Norwegian             < English
  end
  class Icelandic             < English
  end
  class Dutch                 < English
  end
  class Estonian              < English
  end
  class Hungarian             < English
  end
  class Polish                < English
  end
  class Romanian              < English
  end
  class Russian               < English
  end
  class Greek                 < English
  end
  class Ukranian              < English
  end
  class Turkish               < English
  end
  class Croatian              < English
  end
  class Slovakian             < English
  end
  class Czech                 < English
  end
  class Bulgarian             < English
  end
end
__END__
