/*
 * Copyright 2025 Marco Mastropaolo <marco@mastropaolo.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#pragma once

#include <adwaita.h>

#include "ptyxis-custom-link.h"
#include "ptyxis-profile.h"

G_BEGIN_DECLS

#define PTYXIS_TYPE_CUSTOM_LINK_EDITOR (ptyxis_custom_link_editor_get_type())

G_DECLARE_FINAL_TYPE (PtyxisCustomLinkEditor, ptyxis_custom_link_editor, PTYXIS, CUSTOM_LINK_EDITOR, AdwNavigationPage)

PtyxisCustomLinkEditor  *ptyxis_custom_link_editor_new  (PtyxisProfile    *profile,
                                                         PtyxisCustomLink *custom_link);

G_END_DECLS
