/* $Cambridge: hermes/src/prayer/cmd/cmd_passwd.c,v 1.8 2012/06/28 14:01:13 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

#include "prayer_session.h"

static void
generate_form(struct session *session, char *old, char *new, char *new2)
{
    struct template_vals *tvals = session->template_vals;
    struct config *config = session->config;
    struct request *request = session->request;
    struct buffer *b = request->write_buffer;
    char *delay = NIL;

    if (config->accountd_passwd_delay > (2 * 60 * 60))
        delay = pool_printf(tvals->pool, "%lu hours",
                            config->accountd_passwd_delay / (60 * 60));
    else if (config->accountd_passwd_delay > 120)
        delay = pool_printf(tvals->pool, "%lu minutes",
                            config->accountd_passwd_delay / 60);
    else if (config->accountd_passwd_delay > 1)
        delay = pool_printf(tvals->pool, "%lu seconds",
                            config->accountd_passwd_delay);

    if (config->raven_enable)
      template_vals_ulong(tvals, "raven_enable", 1);

    template_vals_string(tvals, "old", old);
    template_vals_string(tvals, "new", new);
    template_vals_string(tvals, "new2", new2);

    if (delay)
        template_vals_string(tvals, "delay", delay);

    session_seed_template(session, tvals);
    template_expand("passwd", tvals, b);
    response_html(request, 200);
}

static BOOL
process_form(struct session *session, char *old, char *new, char *new2)
{
    struct account *account = session->account;
    struct request *request = session->request;
    struct pool *pool = request->pool;

    if (!(old && old[0])) {
        session_alert(session, "Existing password not supplied");
        return (NIL);
    }

    if (!(new && new[0])) {
        session_alert(session, "New password not supplied");
        return (NIL);
    }

    if (!(new2 && new2[0])) {
        session_alert(session, "(Confirmed) New password not supplied");
        return (NIL);
    }

    if (strcmp(new, new2) != NIL) {
        session_alert(session, "New passwords do not match");
        return (NIL);
    }

    if (!account_change_password(session->account, pool, old, new)) {
        char *msg = account_fetch_message(account);

        session_alert(session, "Failed to change password: %s", msg);
        session_log(session,
                    "[cmd_passwd] Failed to change password: %s", msg);
        return (NIL);
    }

    session_message(session, "Password update successful");
    return (T);
}

void cmd_passwd(struct session *session)
{
    struct request *request = session->request;
    char *old, *new, *new2;

    if (request->method == POST) {
        struct assoc *h;

        request_decode_form(request);
        h = request->form;

        if (assoc_lookup(h, "sub_change")) {
            if ((old = assoc_lookup(h, "old")))
                old = string_trim_whitespace(old);

            if ((new = assoc_lookup(h, "new")))
                new = string_trim_whitespace(new);

            if ((new2 = assoc_lookup(h, "new2")))
                new2 = string_trim_whitespace(new2);

            if (!process_form(session, old, new, new2)) {
                generate_form(session, old, new, new2);
                return;
            }
        }
        session_redirect(session, request, "manage");
        return;
    }

    generate_form(session, NIL, NIL, NIL);
}
