/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.png;

import com.sixlegs.png.BasicPixelProcessor;
import com.sixlegs.png.Destination;

final class TransGammaPixelProcessor
extends BasicPixelProcessor {
    private final short[] gammaTable;
    private final int[] trans;
    private final int shift;
    private final int max;
    private final int samplesNoAlpha;
    private final int[] temp;

    public TransGammaPixelProcessor(Destination dst, short[] gammaTable, int[] trans, int shift) {
        super(dst, dst.getRaster().getNumBands());
        this.gammaTable = gammaTable;
        this.trans = trans;
        this.shift = shift;
        this.max = gammaTable.length - 1;
        this.samplesNoAlpha = this.samples - 1;
        this.temp = new int[this.samples * dst.getSourceWidth()];
    }

    public boolean process(int[] row, int xOffset, int xStep, int yStep, int y, int width) {
        int total = width * this.samplesNoAlpha;
        int i1 = 0;
        int i2 = 0;
        while (i1 < total) {
            boolean opaque = false;
            for (int j = 0; j < this.samplesNoAlpha; ++j) {
                int sample = row[i1 + j];
                opaque = opaque || sample != this.trans[j];
                this.temp[i2 + j] = 0xFFFF & this.gammaTable[sample >> this.shift];
            }
            this.temp[i2 + this.samplesNoAlpha] = opaque ? this.max : 0;
            i1 += this.samplesNoAlpha;
            i2 += this.samples;
        }
        return super.process(this.temp, xOffset, xStep, yStep, y, width);
    }
}

