/* SPDX-License-Identifier: Apache-2.0 */
/*
 * Copyright 2024 NXP
 */

{
	.algo = TEE_ALG_AES_GCM, .mode = TEE_MODE_ENCRYPT, .key_type = TEE_TYPE_AES,
	.key = (const uint8_t []){ 0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff, },
	.key_len = 16,
	.nonce = (const uint8_t []){ 0xf9, 0x5f, 0xde, 0x4a, 0x75, 0x19, 0x13, 0x20, 0x2a, 0xee, 0xee, 0x32, 0xa0, 0xb5, 0x57, 0x53, },
	.nonce_len = 16,
	.aad_incr = 0,
	.aad = NULL,
	.aad_len = 0,
	.in_incr = 0,
	.ptx = (const uint8_t []){ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, },
	.ptx_len = 40,
	.ctx = (const uint8_t []){ 0x00, 0x07, 0x8d, 0x10, 0x9d, 0x92, 0x14, 0x3f, 0xcd, 0x5d, 0xf5, 0x67, 0x21, 0xb8, 0x84, 0xfa, 0xc6, 0x4a, 0xc7, 0x76, 0x2c, 0xc0, 0x9e, 0xea, 0x2a, 0x3c, 0x68, 0xe9, 0x2a, 0x17, 0xbd, 0xb5, 0x75, 0xf8, 0x7b, 0xda, 0x18, 0xbe, 0x56, 0x4e, },
	.ctx_len = 40,
	.tag = (const uint8_t []){ 0x15, 0x2a, 0x65, 0x04, 0x5f, 0xe6, 0x74, 0xf9, 0x76, 0x27, 0x42, 0x7a, 0xf5, 0xbe, 0x22, 0xda, },
	.tag_len = 16,
	.line = __LINE__,
	.id = 77
},
{
	.algo = TEE_ALG_AES_GCM, .mode = TEE_MODE_ENCRYPT, .key_type = TEE_TYPE_AES,
	.key = (const uint8_t []){ 0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff, },
	.key_len = 16,
	.nonce = (const uint8_t []){ 0x7b, 0x95, 0xb8, 0xc3, 0x56, 0x81, 0x0a, 0x84, 0x71, 0x1d, 0x68, 0x15, 0x0a, 0x1b, 0x77, 0x50, },
	.nonce_len = 16,
	.aad_incr = 0,
	.aad = NULL,
	.aad_len = 0,
	.in_incr = 0,
	.ptx = (const uint8_t []){ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, },
	.ptx_len = 40,
	.ctx = (const uint8_t []){ 0x84, 0xd4, 0xc9, 0xc0, 0x8b, 0x4f, 0x48, 0x28, 0x61, 0xe3, 0xa9, 0xc6, 0xc3, 0x5b, 0xc4, 0xd9, 0x1d, 0xf9, 0x27, 0x37, 0x45, 0x13, 0xbf, 0xd4, 0x9f, 0x43, 0x6b, 0xd7, 0x3f, 0x32, 0x52, 0x85, 0xda, 0xef, 0x4f, 0xf7, 0xe1, 0x3d, 0x46, 0xa6, },
	.ctx_len = 40,
	.tag = (const uint8_t []){ 0x21, 0x3a, 0x3c, 0xb9, 0x38, 0x55, 0xd1, 0x8e, 0x69, 0x33, 0x7e, 0xee, 0x66, 0xae, 0xec, 0x07, },
	.tag_len = 16,
	.line = __LINE__,
	.id = 78
},
{
	.algo = TEE_ALG_AES_GCM, .mode = TEE_MODE_ENCRYPT, .key_type = TEE_TYPE_AES,
	.key = (const uint8_t []){ 0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff, },
	.key_len = 16,
	.nonce = (const uint8_t []){ 0x1a, 0x55, 0x2e, 0x67, 0xcd, 0xc4, 0xdc, 0x1a, 0x33, 0xb8, 0x24, 0x87, 0x4e, 0xbf, 0x0b, 0xed, },
	.nonce_len = 16,
	.aad_incr = 0,
	.aad = NULL,
	.aad_len = 0,
	.in_incr = 0,
	.ptx = (const uint8_t []){ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, },
	.ptx_len = 40,
	.ctx = (const uint8_t []){ 0x94, 0x8c, 0xa3, 0x7a, 0x8e, 0x66, 0x49, 0xe8, 0x8a, 0xef, 0xfb, 0x1c, 0x59, 0x8f, 0x36, 0x07, 0x00, 0x77, 0x02, 0x41, 0x7e, 0xa0, 0xe0, 0xbc, 0x3c, 0x60, 0xad, 0x5a, 0x94, 0x98, 0x86, 0xde, 0x96, 0x8c, 0xf5, 0x3e, 0xa6, 0x46, 0x2a, 0xed, },
	.ctx_len = 40,
	.tag = (const uint8_t []){ 0x99, 0xb3, 0x81, 0xbf, 0xa2, 0xaf, 0x97, 0x51, 0xc3, 0x9d, 0x1b, 0x6e, 0x86, 0xd1, 0xbe, 0x6a, },
	.tag_len = 16,
	.line = __LINE__,
	.id = 79
},
{
	.algo = TEE_ALG_AES_GCM, .mode = TEE_MODE_ENCRYPT, .key_type = TEE_TYPE_AES,
	.key = (const uint8_t []){ 0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff, },
	.key_len = 16,
	.nonce = (const uint8_t []){ 0xdd, 0x9d, 0x0b, 0x4a, 0x0c, 0x3d, 0x68, 0x15, 0x24, 0xbf, 0xfc, 0xa3, 0x1d, 0x90, 0x76, 0x61, },
	.nonce_len = 16,
	.aad_incr = 0,
	.aad = NULL,
	.aad_len = 0,
	.in_incr = 0,
	.ptx = (const uint8_t []){ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, },
	.ptx_len = 40,
	.ctx = (const uint8_t []){ 0x64, 0xb1, 0x93, 0x14, 0xc3, 0x1a, 0xf4, 0x5a, 0xcc, 0xdf, 0x7e, 0x3c, 0x4d, 0xb7, 0x9f, 0x0d, 0x94, 0x8c, 0xa3, 0x7a, 0x8e, 0x66, 0x49, 0xe8, 0x8a, 0xef, 0xfb, 0x1c, 0x59, 0x8f, 0x36, 0x07, 0x00, 0x77, 0x02, 0x41, 0x7e, 0xa0, 0xe0, 0xbc, },
	.ctx_len = 40,
	.tag = (const uint8_t []){ 0x52, 0x81, 0xef, 0xc7, 0xf1, 0x3a, 0xc8, 0xe1, 0x4c, 0xcf, 0x5d, 0xca, 0x7b, 0xfb, 0xfd, 0xd1, },
	.tag_len = 16,
	.line = __LINE__,
	.id = 80
},
{
	.algo = TEE_ALG_AES_GCM, .mode = TEE_MODE_ENCRYPT, .key_type = TEE_TYPE_AES,
	.key = (const uint8_t []){ 0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff, },
	.key_len = 16,
	.nonce = (const uint8_t []){ 0x57, 0xc5, 0x64, 0x3c, 0x4e, 0x37, 0xb4, 0x04, 0x1d, 0xb7, 0x94, 0xcf, 0xe8, 0xe1, 0xf0, 0xf4, },
	.nonce_len = 16,
	.aad_incr = 0,
	.aad = NULL,
	.aad_len = 0,
	.in_incr = 0,
	.ptx = (const uint8_t []){ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, },
	.ptx_len = 40,
	.ctx = (const uint8_t []){ 0x2b, 0xb6, 0x9c, 0x3e, 0x5d, 0x1f, 0x91, 0x81, 0x5c, 0x6b, 0x87, 0xa0, 0xd5, 0xbb, 0xea, 0x71, 0x64, 0xb1, 0x93, 0x14, 0xc3, 0x1a, 0xf4, 0x5a, 0xcc, 0xdf, 0x7e, 0x3c, 0x4d, 0xb7, 0x9f, 0x0d, 0x94, 0x8c, 0xa3, 0x7a, 0x8e, 0x66, 0x49, 0xe8, },
	.ctx_len = 40,
	.tag = (const uint8_t []){ 0xa3, 0xea, 0x2c, 0x09, 0xee, 0x4f, 0x8c, 0x8a, 0x12, 0xf4, 0x5c, 0xdd, 0xf9, 0xae, 0xff, 0x81, },
	.tag_len = 16,
	.line = __LINE__,
	.id = 81
},
{
	.algo = TEE_ALG_AES_GCM, .mode = TEE_MODE_ENCRYPT, .key_type = TEE_TYPE_AES,
	.key = (const uint8_t []){ 0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff, },
	.key_len = 16,
	.nonce = (const uint8_t []){ 0x99, 0x82, 0x1c, 0x2d, 0xd5, 0xda, 0xec, 0xde, 0xd0, 0x73, 0x00, 0xf5, 0x77, 0xf7, 0xaf, 0xf1, },
	.nonce_len = 16,
	.aad_incr = 0,
	.aad = NULL,
	.aad_len = 0,
	.in_incr = 0,
	.ptx = (const uint8_t []){ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, },
	.ptx_len = 40,
	.ctx = (const uint8_t []){ 0x12, 0x7a, 0xf9, 0xb3, 0x9e, 0xcd, 0xfc, 0x57, 0xbb, 0x11, 0xa2, 0x84, 0x7c, 0x7c, 0x2d, 0x3d, 0x8f, 0x93, 0x8f, 0x40, 0xf8, 0x77, 0xe0, 0xc4, 0xaf, 0x37, 0xd0, 0xfe, 0x9a, 0xf0, 0x33, 0x05, 0x2b, 0xd5, 0x37, 0xc4, 0xae, 0x97, 0x8f, 0x60, },
	.ctx_len = 40,
	.tag = (const uint8_t []){ 0x07, 0xeb, 0x2f, 0xe4, 0xa9, 0x58, 0xf8, 0x43, 0x4d, 0x40, 0x68, 0x48, 0x99, 0x50, 0x7c, 0x7c, },
	.tag_len = 16,
	.line = __LINE__,
	.id = 82
},
{
	.algo = TEE_ALG_AES_GCM, .mode = TEE_MODE_ENCRYPT, .key_type = TEE_TYPE_AES,
	.key = (const uint8_t []){ 0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff, },
	.key_len = 16,
	.nonce = (const uint8_t []){ 0x5e, 0x4a, 0x39, 0x00, 0x14, 0x23, 0x58, 0xd1, 0xc7, 0x74, 0xd8, 0xd1, 0x24, 0xd8, 0xd2, 0x7d, },
	.nonce_len = 16,
	.aad_incr = 0,
	.aad = NULL,
	.aad_len = 0,
	.in_incr = 0,
	.ptx = (const uint8_t []){ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, },
	.ptx_len = 40,
	.ctx = (const uint8_t []){ 0x0c, 0xf6, 0xae, 0x47, 0x15, 0x6b, 0x14, 0xdc, 0xe0, 0x3c, 0x8a, 0x07, 0xa2, 0xe1, 0x72, 0xb1, 0x12, 0x7a, 0xf9, 0xb3, 0x9e, 0xcd, 0xfc, 0x57, 0xbb, 0x11, 0xa2, 0x84, 0x7c, 0x7c, 0x2d, 0x3d, 0x8f, 0x93, 0x8f, 0x40, 0xf8, 0x77, 0xe0, 0xc4, },
	.ctx_len = 40,
	.tag = (const uint8_t []){ 0xf1, 0x45, 0xc2, 0xdc, 0xaf, 0x33, 0x9e, 0xed, 0xe4, 0x27, 0xbe, 0x93, 0x43, 0x57, 0xea, 0xc0, },
	.tag_len = 16,
	.line = __LINE__,
	.id = 83
},
{
	.algo = TEE_ALG_AES_GCM, .mode = TEE_MODE_ENCRYPT, .key_type = TEE_TYPE_AES,
	.key = (const uint8_t []){ 0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff, },
	.key_len = 16,
	.nonce = (const uint8_t []){ 0xd4, 0x12, 0x56, 0x76, 0x56, 0x29, 0x84, 0xc0, 0xfe, 0x7c, 0xb0, 0xbd, 0xd1, 0xa9, 0x54, 0xe8, },
	.nonce_len = 16,
	.aad_incr = 0,
	.aad = NULL,
	.aad_len = 0,
	.in_incr = 0,
	.ptx = (const uint8_t []){ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, },
	.ptx_len = 40,
	.ctx = (const uint8_t []){ 0xf0, 0xc6, 0xff, 0xc1, 0x8b, 0xd4, 0x6d, 0xf5, 0x56, 0x91, 0x85, 0xa9, 0xaf, 0xd1, 0x69, 0xeb, 0x0c, 0xf6, 0xae, 0x47, 0x15, 0x6b, 0x14, 0xdc, 0xe0, 0x3c, 0x8a, 0x07, 0xa2, 0xe1, 0x72, 0xb1, 0x12, 0x7a, 0xf9, 0xb3, 0x9e, 0xcd, 0xfc, 0x57, },
	.ctx_len = 40,
	.tag = (const uint8_t []){ 0xfa, 0xcd, 0x0b, 0xfe, 0x87, 0x01, 0xb7, 0xb4, 0xa2, 0xba, 0x96, 0xd9, 0x8a, 0xf5, 0x2b, 0xd9, },
	.tag_len = 16,
	.line = __LINE__,
	.id = 84
},
{
	.algo = TEE_ALG_AES_GCM, .mode = TEE_MODE_ENCRYPT, .key_type = TEE_TYPE_AES,
	.key = (const uint8_t []){ 0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff, },
	.key_len = 16,
	.nonce = (const uint8_t []){ 0xb9, 0x7e, 0xc6, 0x2a, 0x5e, 0x59, 0x00, 0xcc, 0xf9, 0xe4, 0xbe, 0x33, 0x2e, 0x33, 0x60, 0x91, },
	.nonce_len = 16,
	.aad_incr = 0,
	.aad = NULL,
	.aad_len = 0,
	.in_incr = 0,
	.ptx = (const uint8_t []){ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, },
	.ptx_len = 40,
	.ctx = (const uint8_t []){ 0xd6, 0x92, 0x8e, 0x09, 0x4c, 0x06, 0xe0, 0xa7, 0xc4, 0xdb, 0x42, 0x18, 0x4c, 0xf7, 0x52, 0x9e, 0x95, 0xde, 0x88, 0xb7, 0x67, 0xed, 0xeb, 0xe9, 0xb3, 0x43, 0x00, 0x0b, 0xe3, 0xda, 0xb4, 0x7e, 0xa0, 0x8b, 0x74, 0x42, 0x93, 0xee, 0xd6, 0x98, },
	.ctx_len = 40,
	.tag = (const uint8_t []){ 0xa0, 0x3e, 0x72, 0x9d, 0xcf, 0xd7, 0xa0, 0x31, 0x55, 0x65, 0x5f, 0xec, 0xe8, 0xaf, 0xfd, 0x7e, },
	.tag_len = 16,
	.line = __LINE__,
	.id = 85
},
{
	.algo = TEE_ALG_AES_GCM, .mode = TEE_MODE_ENCRYPT, .key_type = TEE_TYPE_AES,
	.key = (const uint8_t []){ 0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff, },
	.key_len = 16,
	.nonce = (const uint8_t []){ 0x7e, 0xb6, 0xe3, 0x07, 0x9f, 0xa0, 0xb4, 0xc3, 0xee, 0xe3, 0x66, 0x17, 0x7d, 0x1c, 0x1d, 0x1d, },
	.nonce_len = 16,
	.aad_incr = 0,
	.aad = NULL,
	.aad_len = 0,
	.in_incr = 0,
	.ptx = (const uint8_t []){ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, },
	.ptx_len = 40,
	.ctx = (const uint8_t []){ 0xd8, 0x2c, 0xe5, 0x87, 0x71, 0xbf, 0x64, 0x87, 0x11, 0x6b, 0xf8, 0xe9, 0x64, 0x21, 0x87, 0x7e, 0xd6, 0x92, 0x8e, 0x09, 0x4c, 0x06, 0xe0, 0xa7, 0xc4, 0xdb, 0x42, 0x18, 0x4c, 0xf7, 0x52, 0x9e, 0x95, 0xde, 0x88, 0xb7, 0x67, 0xed, 0xeb, 0xe9, },
	.ctx_len = 40,
	.tag = (const uint8_t []){ 0x1e, 0x43, 0x92, 0x68, 0x28, 0xbc, 0x9a, 0x16, 0x14, 0xc7, 0xb1, 0x63, 0x90, 0x96, 0xc1, 0x95, },
	.tag_len = 16,
	.line = __LINE__,
	.id = 86
},
{
	.algo = TEE_ALG_AES_GCM, .mode = TEE_MODE_ENCRYPT, .key_type = TEE_TYPE_AES,
	.key = (const uint8_t []){ 0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff, },
	.key_len = 16,
	.nonce = (const uint8_t []){ 0x03, 0x14, 0xfc, 0xd1, 0x0f, 0xdd, 0x67, 0x5d, 0x3c, 0x61, 0x29, 0x62, 0xc9, 0x31, 0xf6, 0x35, },
	.nonce_len = 16,
	.aad_incr = 0,
	.aad = NULL,
	.aad_len = 0,
	.in_incr = 0,
	.ptx = (const uint8_t []){ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, },
	.ptx_len = 40,
	.ctx = (const uint8_t []){ 0xa1, 0x97, 0xa3, 0x7a, 0x5d, 0x79, 0x69, 0x70, 0x78, 0x53, 0x6b, 0xc2, 0x7f, 0xe4, 0x6c, 0xd8, 0xd4, 0x75, 0x52, 0x6d, 0x90, 0x44, 0xaa, 0x94, 0xf0, 0x88, 0xa0, 0x54, 0xf8, 0xe3, 0x80, 0xc6, 0x4f, 0x79, 0x41, 0x47, 0x95, 0xc6, 0x14, 0x80, },
	.ctx_len = 40,
	.tag = (const uint8_t []){ 0xf0, 0x8b, 0xad, 0xdf, 0x0b, 0x52, 0x85, 0xc9, 0x1f, 0xc0, 0x6a, 0x67, 0xfe, 0x47, 0x08, 0xca, },
	.tag_len = 16,
	.line = __LINE__,
	.id = 87
},
{
	.algo = TEE_ALG_AES_GCM, .mode = TEE_MODE_ENCRYPT, .key_type = TEE_TYPE_AES,
	.key = (const uint8_t []){ 0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff, },
	.key_len = 16,
	.nonce = (const uint8_t []){ 0xc4, 0xdc, 0xd9, 0xfc, 0xce, 0x24, 0xd3, 0x52, 0x2b, 0x66, 0xf1, 0x46, 0x9a, 0x1e, 0x8b, 0xb9, },
	.nonce_len = 16,
	.aad_incr = 0,
	.aad = NULL,
	.aad_len = 0,
	.in_incr = 0,
	.ptx = (const uint8_t []){ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, },
	.ptx_len = 40,
	.ctx = (const uint8_t []){ 0x14, 0x9f, 0xde, 0x9a, 0xbb, 0xd3, 0xa4, 0x3c, 0x25, 0x48, 0x57, 0x5e, 0x0d, 0xb9, 0xfb, 0x84, 0xa1, 0x97, 0xa3, 0x7a, 0x5d, 0x79, 0x69, 0x70, 0x78, 0x53, 0x6b, 0xc2, 0x7f, 0xe4, 0x6c, 0xd8, 0xd4, 0x75, 0x52, 0x6d, 0x90, 0x44, 0xaa, 0x94, },
	.ctx_len = 40,
	.tag = (const uint8_t []){ 0x62, 0xa4, 0xb6, 0x87, 0x5c, 0x28, 0x83, 0x45, 0xd6, 0xa4, 0x54, 0x39, 0x9e, 0xac, 0x1a, 0xfa, },
	.tag_len = 16,
	.line = __LINE__,
	.id = 88
},
{
	.algo = TEE_ALG_AES_GCM, .mode = TEE_MODE_ENCRYPT, .key_type = TEE_TYPE_AES,
	.key = (const uint8_t []){ 0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff, 0x10, 0x21, 0x32, 0x43, 0x54, 0x65, 0x76, 0x87, },
	.key_len = 24,
	.nonce = (const uint8_t []){ 0x02, 0x9e, 0x0e, 0x77, 0x7d, 0xb0, 0x92, 0xb1, 0x25, 0x35, 0xd0, 0x43, 0x01, 0x2f, 0x09, 0xba, },
	.nonce_len = 16,
	.aad_incr = 0,
	.aad = NULL,
	.aad_len = 0,
	.in_incr = 0,
	.ptx = (const uint8_t []){ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, },
	.ptx_len = 40,
	.ctx = (const uint8_t []){ 0xf8, 0x3c, 0xee, 0x46, 0x73, 0x36, 0xe1, 0xa0, 0x9b, 0x75, 0xf2, 0x4e, 0x9b, 0x43, 0x85, 0xc9, 0x9c, 0x13, 0xe6, 0xaf, 0x72, 0x22, 0x56, 0xa6, 0x61, 0x29, 0xec, 0xe9, 0x61, 0xfe, 0x80, 0x3b, 0x16, 0x7b, 0xad, 0x20, 0x6f, 0x50, 0x17, 0xfb, },
	.ctx_len = 40,
	.tag = (const uint8_t []){ 0x09, 0x33, 0x8a, 0x42, 0xf0, 0xac, 0xc1, 0x4f, 0x97, 0xc0, 0x64, 0xf5, 0x2f, 0x5f, 0x16, 0x88, },
	.tag_len = 16,
	.line = __LINE__,
	.id = 157
},
{
	.algo = TEE_ALG_AES_GCM, .mode = TEE_MODE_ENCRYPT, .key_type = TEE_TYPE_AES,
	.key = (const uint8_t []){ 0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff, 0x10, 0x21, 0x32, 0x43, 0x54, 0x65, 0x76, 0x87, },
	.key_len = 24,
	.nonce = (const uint8_t []){ 0xf1, 0xbe, 0x3b, 0x06, 0xb7, 0xfe, 0xac, 0x07, 0xe7, 0xea, 0xb6, 0x29, 0xf5, 0x56, 0x04, 0x7b, },
	.nonce_len = 16,
	.aad_incr = 0,
	.aad = NULL,
	.aad_len = 0,
	.in_incr = 0,
	.ptx = (const uint8_t []){ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, },
	.ptx_len = 40,
	.ctx = (const uint8_t []){ 0x0b, 0x32, 0xb6, 0x48, 0xa2, 0xc2, 0x8e, 0x9e, 0xdd, 0x7c, 0xee, 0x08, 0xee, 0xeb, 0x90, 0x00, 0x34, 0xca, 0xe7, 0x21, 0x5e, 0x5a, 0xb1, 0xe2, 0x01, 0xbd, 0x2e, 0xed, 0x10, 0x32, 0xc5, 0xa9, 0x78, 0x66, 0xba, 0x58, 0x2a, 0x34, 0x58, 0xa4, },
	.ctx_len = 40,
	.tag = (const uint8_t []){ 0x90, 0xbe, 0x36, 0x06, 0xde, 0x58, 0xbd, 0x77, 0x8f, 0xa5, 0xbe, 0xff, 0x4a, 0x41, 0x02, 0xbd, },
	.tag_len = 16,
	.line = __LINE__,
	.id = 158
},
{
	.algo = TEE_ALG_AES_GCM, .mode = TEE_MODE_ENCRYPT, .key_type = TEE_TYPE_AES,
	.key = (const uint8_t []){ 0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff, 0x10, 0x21, 0x32, 0x43, 0x54, 0x65, 0x76, 0x87, },
	.key_len = 24,
	.nonce = (const uint8_t []){ 0xde, 0x9e, 0xb6, 0x3b, 0x1d, 0xae, 0xd3, 0x21, 0xa1, 0x1b, 0x75, 0x47, 0xcc, 0x9e, 0x22, 0x3c, },
	.nonce_len = 16,
	.aad_incr = 0,
	.aad = NULL,
	.aad_len = 0,
	.in_incr = 0,
	.ptx = (const uint8_t []){ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, },
	.ptx_len = 40,
	.ctx = (const uint8_t []){ 0x57, 0x5e, 0x2e, 0xce, 0xc2, 0xb3, 0xc7, 0x2d, 0x4e, 0x80, 0x83, 0x0d, 0x0d, 0x85, 0x9a, 0xd9, 0xe4, 0x2c, 0x29, 0xc4, 0xa6, 0x8d, 0x8d, 0x9d, 0x8d, 0x23, 0x43, 0x4d, 0xe2, 0xcd, 0x07, 0x73, 0x3b, 0xe4, 0x9d, 0x62, 0xac, 0x1a, 0xe0, 0x85, },
	.ctx_len = 40,
	.tag = (const uint8_t []){ 0x6e, 0x4d, 0x63, 0x96, 0x12, 0x5a, 0x10, 0xdf, 0x54, 0x43, 0xbd, 0x0c, 0xbc, 0x85, 0x66, 0xd1, },
	.tag_len = 16,
	.line = __LINE__,
	.id = 159
},
{
	.algo = TEE_ALG_AES_GCM, .mode = TEE_MODE_ENCRYPT, .key_type = TEE_TYPE_AES,
	.key = (const uint8_t []){ 0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff, 0x10, 0x21, 0x32, 0x43, 0x54, 0x65, 0x76, 0x87, },
	.key_len = 24,
	.nonce = (const uint8_t []){ 0x40, 0xbb, 0x0a, 0xbe, 0xbc, 0x48, 0x3f, 0xf6, 0xd5, 0x67, 0x12, 0x41, 0xff, 0x5d, 0x66, 0xc6, },
	.nonce_len = 16,
	.aad_incr = 0,
	.aad = NULL,
	.aad_len = 0,
	.in_incr = 0,
	.ptx = (const uint8_t []){ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, },
	.ptx_len = 40,
	.ctx = (const uint8_t []){ 0x2a, 0x81, 0x88, 0x88, 0xd1, 0xf0, 0x9f, 0x32, 0xaa, 0x7b, 0xee, 0xdd, 0x28, 0x69, 0xb4, 0x46, 0x57, 0x5e, 0x2e, 0xce, 0xc2, 0xb3, 0xc7, 0x2d, 0x4e, 0x80, 0x83, 0x0d, 0x0d, 0x85, 0x9a, 0xd9, 0xe4, 0x2c, 0x29, 0xc4, 0xa6, 0x8d, 0x8d, 0x9d, },
	.ctx_len = 40,
	.tag = (const uint8_t []){ 0xdc, 0x48, 0x1f, 0x17, 0x25, 0x45, 0x26, 0x8e, 0xff, 0x63, 0xab, 0x04, 0x90, 0x40, 0x3d, 0xc3, },
	.tag_len = 16,
	.line = __LINE__,
	.id = 160
},
{
	.algo = TEE_ALG_AES_GCM, .mode = TEE_MODE_ENCRYPT, .key_type = TEE_TYPE_AES,
	.key = (const uint8_t []){ 0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff, 0x10, 0x21, 0x32, 0x43, 0x54, 0x65, 0x76, 0x87, },
	.key_len = 24,
	.nonce = (const uint8_t []){ 0x20, 0xd5, 0xcf, 0x30, 0x5e, 0x63, 0x0a, 0x8f, 0x49, 0xe3, 0xbb, 0x4b, 0xab, 0x18, 0xab, 0xc9, },
	.nonce_len = 16,
	.aad_incr = 0,
	.aad = NULL,
	.aad_len = 0,
	.in_incr = 0,
	.ptx = (const uint8_t []){ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, },
	.ptx_len = 40,
	.ctx = (const uint8_t []){ 0x96, 0xd3, 0x6b, 0x79, 0x5f, 0x8e, 0x7e, 0xdf, 0x6a, 0x8e, 0x0d, 0xbc, 0xd2, 0x0d, 0x6c, 0x07, 0x2a, 0x81, 0x88, 0x88, 0xd1, 0xf0, 0x9f, 0x32, 0xaa, 0x7b, 0xee, 0xdd, 0x28, 0x69, 0xb4, 0x46, 0x57, 0x5e, 0x2e, 0xce, 0xc2, 0xb3, 0xc7, 0x2d, },
	.ctx_len = 40,
	.tag = (const uint8_t []){ 0x8a, 0x3a, 0x22, 0xbf, 0x25, 0x92, 0x95, 0x8b, 0x93, 0x02, 0x92, 0xaa, 0x47, 0xf5, 0x90, 0xe8, },
	.tag_len = 16,
	.line = __LINE__,
	.id = 161
},
{
	.algo = TEE_ALG_AES_GCM, .mode = TEE_MODE_ENCRYPT, .key_type = TEE_TYPE_AES,
	.key = (const uint8_t []){ 0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff, 0x10, 0x21, 0x32, 0x43, 0x54, 0x65, 0x76, 0x87, },
	.key_len = 24,
	.nonce = (const uint8_t []){ 0x25, 0x53, 0x58, 0xa7, 0x1a, 0x0e, 0x57, 0x31, 0xf6, 0xdd, 0x6c, 0xe2, 0x8e, 0x15, 0x8a, 0xe6, },
	.nonce_len = 16,
	.aad_incr = 0,
	.aad = NULL,
	.aad_len = 0,
	.in_incr = 0,
	.ptx = (const uint8_t []){ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, },
	.ptx_len = 40,
	.ctx = (const uint8_t []){ 0xcf, 0xce, 0x3d, 0x92, 0x0f, 0x0e, 0x01, 0xf0, 0xbb, 0x49, 0xa7, 0x51, 0x95, 0x5b, 0x23, 0x6d, 0x1b, 0x88, 0x7b, 0xae, 0xfd, 0x25, 0xc4, 0x7f, 0x41, 0x30, 0x3c, 0x46, 0xd5, 0xc7, 0xbf, 0x9c, 0xa4, 0xc2, 0xc4, 0x5a, 0x8f, 0x1e, 0x66, 0x56, },
	.ctx_len = 40,
	.tag = (const uint8_t []){ 0x2d, 0xb9, 0xdc, 0x1b, 0x7f, 0xd3, 0x15, 0xdf, 0x1c, 0x95, 0x43, 0x24, 0x32, 0xfc, 0xf4, 0x74, },
	.tag_len = 16,
	.line = __LINE__,
	.id = 162
},
{
	.algo = TEE_ALG_AES_GCM, .mode = TEE_MODE_ENCRYPT, .key_type = TEE_TYPE_AES,
	.key = (const uint8_t []){ 0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff, 0x10, 0x21, 0x32, 0x43, 0x54, 0x65, 0x76, 0x87, },
	.key_len = 24,
	.nonce = (const uint8_t []){ 0xbb, 0x76, 0xe4, 0x22, 0xbb, 0xe8, 0xbb, 0xe6, 0x82, 0xa1, 0x0b, 0xe4, 0xbd, 0xd6, 0xce, 0x1c, },
	.nonce_len = 16,
	.aad_incr = 0,
	.aad = NULL,
	.aad_len = 0,
	.in_incr = 0,
	.ptx = (const uint8_t []){ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, },
	.ptx_len = 40,
	.ctx = (const uint8_t []){ 0x69, 0xa2, 0x41, 0x69, 0x79, 0x2e, 0x9a, 0x07, 0xf6, 0xe6, 0xf4, 0x73, 0x6f, 0xa9, 0x72, 0xdc, 0xcf, 0xce, 0x3d, 0x92, 0x0f, 0x0e, 0x01, 0xf0, 0xbb, 0x49, 0xa7, 0x51, 0x95, 0x5b, 0x23, 0x6d, 0x1b, 0x88, 0x7b, 0xae, 0xfd, 0x25, 0xc4, 0x7f, },
	.ctx_len = 40,
	.tag = (const uint8_t []){ 0x82, 0xad, 0x96, 0x7f, 0x7a, 0xc1, 0x90, 0x84, 0x35, 0x4f, 0x69, 0xa7, 0x51, 0x44, 0x3f, 0xb2, },
	.tag_len = 16,
	.line = __LINE__,
	.id = 163
},
{
	.algo = TEE_ALG_AES_GCM, .mode = TEE_MODE_ENCRYPT, .key_type = TEE_TYPE_AES,
	.key = (const uint8_t []){ 0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff, 0x10, 0x21, 0x32, 0x43, 0x54, 0x65, 0x76, 0x87, },
	.key_len = 24,
	.nonce = (const uint8_t []){ 0xdb, 0x18, 0x21, 0xac, 0x59, 0xc3, 0x8e, 0x9f, 0x1e, 0x25, 0xa2, 0xee, 0xe9, 0x93, 0x03, 0x13, },
	.nonce_len = 16,
	.aad_incr = 0,
	.aad = NULL,
	.aad_len = 0,
	.in_incr = 0,
	.ptx = (const uint8_t []){ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, },
	.ptx_len = 40,
	.ctx = (const uint8_t []){ 0x4e, 0x44, 0x17, 0xa8, 0x3b, 0xea, 0xc1, 0xeb, 0x7e, 0x24, 0x45, 0x6a, 0x05, 0xf6, 0xba, 0x55, 0x69, 0xa2, 0x41, 0x69, 0x79, 0x2e, 0x9a, 0x07, 0xf6, 0xe6, 0xf4, 0x73, 0x6f, 0xa9, 0x72, 0xdc, 0xcf, 0xce, 0x3d, 0x92, 0x0f, 0x0e, 0x01, 0xf0, },
	.ctx_len = 40,
	.tag = (const uint8_t []){ 0x47, 0x2d, 0x5d, 0xd5, 0x82, 0xdc, 0x05, 0xef, 0x5f, 0xc4, 0x96, 0xb6, 0x12, 0x02, 0x3c, 0xb2, },
	.tag_len = 16,
	.line = __LINE__,
	.id = 164
},
{
	.algo = TEE_ALG_AES_GCM, .mode = TEE_MODE_ENCRYPT, .key_type = TEE_TYPE_AES,
	.key = (const uint8_t []){ 0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff, 0x10, 0x21, 0x32, 0x43, 0x54, 0x65, 0x76, 0x87, },
	.key_len = 24,
	.nonce = (const uint8_t []){ 0xf7, 0xa0, 0x2e, 0xcc, 0xa0, 0x30, 0x64, 0xb2, 0xef, 0x3c, 0xce, 0x9f, 0xea, 0xb7, 0x9f, 0x07, },
	.nonce_len = 16,
	.aad_incr = 0,
	.aad = NULL,
	.aad_len = 0,
	.in_incr = 0,
	.ptx = (const uint8_t []){ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, },
	.ptx_len = 40,
	.ctx = (const uint8_t []){ 0x6f, 0x8e, 0x17, 0x4e, 0xfc, 0xa3, 0x09, 0x72, 0x99, 0xf7, 0x84, 0xef, 0xd4, 0xca, 0xff, 0x0b, 0xf1, 0x68, 0xc3, 0xe5, 0x16, 0x5b, 0x9a, 0xd3, 0xd2, 0x00, 0x62, 0x00, 0x98, 0x48, 0x04, 0x4e, 0xef, 0x8f, 0x31, 0xf7, 0xd2, 0xfe, 0xad, 0x05, },
	.ctx_len = 40,
	.tag = (const uint8_t []){ 0xca, 0xff, 0x72, 0x38, 0x26, 0xdf, 0x15, 0x09, 0x34, 0xae, 0xe3, 0x20, 0x1b, 0xa1, 0x75, 0xe7, },
	.tag_len = 16,
	.line = __LINE__,
	.id = 165
},
{
	.algo = TEE_ALG_AES_GCM, .mode = TEE_MODE_ENCRYPT, .key_type = TEE_TYPE_AES,
	.key = (const uint8_t []){ 0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff, 0x10, 0x21, 0x32, 0x43, 0x54, 0x65, 0x76, 0x87, },
	.key_len = 24,
	.nonce = (const uint8_t []){ 0x69, 0x85, 0x92, 0x49, 0x01, 0xd6, 0x88, 0x65, 0x9b, 0x40, 0xa9, 0x99, 0xd9, 0x74, 0xdb, 0xfd, },
	.nonce_len = 16,
	.aad_incr = 0,
	.aad = NULL,
	.aad_len = 0,
	.in_incr = 0,
	.ptx = (const uint8_t []){ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, },
	.ptx_len = 40,
	.ctx = (const uint8_t []){ 0xaf, 0x19, 0x30, 0x90, 0xce, 0x3d, 0x43, 0xa3, 0x88, 0xa1, 0xd2, 0x94, 0xa0, 0x96, 0x16, 0x90, 0x6f, 0x8e, 0x17, 0x4e, 0xfc, 0xa3, 0x09, 0x72, 0x99, 0xf7, 0x84, 0xef, 0xd4, 0xca, 0xff, 0x0b, 0xf1, 0x68, 0xc3, 0xe5, 0x16, 0x5b, 0x9a, 0xd3, },
	.ctx_len = 40,
	.tag = (const uint8_t []){ 0x3b, 0x08, 0x95, 0x8b, 0xe1, 0x28, 0x6c, 0x2b, 0x4a, 0xcb, 0xa0, 0x2b, 0x36, 0x74, 0xad, 0xb2, },
	.tag_len = 16,
	.line = __LINE__,
	.id = 166
},
{
	.algo = TEE_ALG_AES_GCM, .mode = TEE_MODE_ENCRYPT, .key_type = TEE_TYPE_AES,
	.key = (const uint8_t []){ 0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff, 0x10, 0x21, 0x32, 0x43, 0x54, 0x65, 0x76, 0x87, },
	.key_len = 24,
	.nonce = (const uint8_t []){ 0x3f, 0x11, 0x88, 0x54, 0x6c, 0x65, 0xed, 0x0f, 0xc5, 0x5e, 0x75, 0x03, 0x2c, 0x68, 0xee, 0x44, },
	.nonce_len = 16,
	.aad_incr = 0,
	.aad = NULL,
	.aad_len = 0,
	.in_incr = 0,
	.ptx = (const uint8_t []){ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, },
	.ptx_len = 40,
	.ctx = (const uint8_t []){ 0x5d, 0xec, 0xcf, 0x83, 0x8b, 0x2c, 0xf5, 0xf8, 0x69, 0xc9, 0x0d, 0x2a, 0x61, 0x11, 0x60, 0xb1, 0xe5, 0x78, 0xab, 0x81, 0x21, 0xb9, 0x37, 0x35, 0xcb, 0xa4, 0xa1, 0x93, 0x06, 0x47, 0xb8, 0xc4, 0xc8, 0x4b, 0xf7, 0x76, 0x33, 0x3e, 0xe4, 0x5a, },
	.ctx_len = 40,
	.tag = (const uint8_t []){ 0xc1, 0x4d, 0x52, 0x20, 0x8f, 0x0f, 0x51, 0xb8, 0x16, 0xa4, 0x89, 0x71, 0xea, 0xf8, 0xff, 0x7e, },
	.tag_len = 16,
	.line = __LINE__,
	.id = 167
},
{
	.algo = TEE_ALG_AES_GCM, .mode = TEE_MODE_ENCRYPT, .key_type = TEE_TYPE_AES,
	.key = (const uint8_t []){ 0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff, 0x10, 0x21, 0x32, 0x43, 0x54, 0x65, 0x76, 0x87, },
	.key_len = 24,
	.nonce = (const uint8_t []){ 0xa1, 0x34, 0x34, 0xd1, 0xcd, 0x83, 0x01, 0xd8, 0xb1, 0x22, 0x12, 0x05, 0x1f, 0xab, 0xaa, 0xbe, },
	.nonce_len = 16,
	.aad_incr = 0,
	.aad = NULL,
	.aad_len = 0,
	.in_incr = 0,
	.ptx = (const uint8_t []){ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, },
	.ptx_len = 40,
	.ctx = (const uint8_t []){ 0xd2, 0xca, 0xe1, 0x68, 0x4a, 0xa4, 0x07, 0xa1, 0x3a, 0x2e, 0x2d, 0xa5, 0x35, 0x7e, 0x29, 0xf5, 0x5d, 0xec, 0xcf, 0x83, 0x8b, 0x2c, 0xf5, 0xf8, 0x69, 0xc9, 0x0d, 0x2a, 0x61, 0x11, 0x60, 0xb1, 0xe5, 0x78, 0xab, 0x81, 0x21, 0xb9, 0x37, 0x35, },
	.ctx_len = 40,
	.tag = (const uint8_t []){ 0xea, 0x2d, 0x01, 0x80, 0x99, 0xcd, 0x79, 0x25, 0xc5, 0x07, 0xce, 0xf0, 0xce, 0xdd, 0xb0, 0xae, },
	.tag_len = 16,
	.line = __LINE__,
	.id = 168
},
{
	.algo = TEE_ALG_AES_GCM, .mode = TEE_MODE_ENCRYPT, .key_type = TEE_TYPE_AES,
	.key = (const uint8_t []){ 0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff, 0x10, 0x21, 0x32, 0x43, 0x54, 0x65, 0x76, 0x87, 0x98, 0xa9, 0xba, 0xcb, 0xdc, 0xed, 0xfe, 0x0f, },
	.key_len = 32,
	.nonce = (const uint8_t []){ 0x5c, 0x2e, 0xa9, 0xb6, 0x95, 0xfc, 0xf6, 0xe2, 0x64, 0xb9, 0x60, 0x74, 0xd6, 0xbf, 0xa5, 0x72, },
	.nonce_len = 16,
	.aad_incr = 0,
	.aad = NULL,
	.aad_len = 0,
	.in_incr = 0,
	.ptx = (const uint8_t []){ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, },
	.ptx_len = 40,
	.ctx = (const uint8_t []){ 0x28, 0xe1, 0xc5, 0x23, 0x2f, 0x4e, 0xe8, 0x16, 0x1d, 0xbe, 0x4c, 0x03, 0x63, 0x09, 0xe0, 0xb3, 0x25, 0x4e, 0x92, 0x12, 0xbe, 0xf0, 0xa9, 0x34, 0x31, 0xce, 0x5e, 0x56, 0x04, 0xc8, 0xf6, 0xa7, 0x3c, 0x18, 0xa3, 0x18, 0x30, 0x18, 0xb7, 0x70, },
	.ctx_len = 40,
	.tag = (const uint8_t []){ 0xd5, 0x80, 0x8a, 0x1b, 0xd1, 0x1a, 0x01, 0x12, 0x9b, 0xf3, 0xc6, 0x91, 0x9a, 0xff, 0x23, 0x39, },
	.tag_len = 16,
	.line = __LINE__,
	.id = 240
},
{
	.algo = TEE_ALG_AES_GCM, .mode = TEE_MODE_ENCRYPT, .key_type = TEE_TYPE_AES,
	.key = (const uint8_t []){ 0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff, 0x10, 0x21, 0x32, 0x43, 0x54, 0x65, 0x76, 0x87, 0x98, 0xa9, 0xba, 0xcb, 0xdc, 0xed, 0xfe, 0x0f, },
	.key_len = 32,
	.nonce = (const uint8_t []){ 0x57, 0xb3, 0xa8, 0x1f, 0x2c, 0x36, 0xb6, 0xb0, 0x65, 0x77, 0xca, 0x0f, 0xba, 0xb8, 0xfa, 0x8e, },
	.nonce_len = 16,
	.aad_incr = 0,
	.aad = NULL,
	.aad_len = 0,
	.in_incr = 0,
	.ptx = (const uint8_t []){ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, },
	.ptx_len = 40,
	.ctx = (const uint8_t []){ 0xcc, 0xee, 0xbe, 0xb4, 0xfe, 0x4c, 0xd9, 0x0c, 0x51, 0x4e, 0x52, 0xd2, 0x32, 0x7a, 0x2e, 0xcd, 0x75, 0x39, 0x36, 0x61, 0x00, 0x6c, 0xf2, 0x47, 0x6d, 0x86, 0x20, 0x14, 0x9a, 0xef, 0x3d, 0x1c, 0xdc, 0xe4, 0x91, 0xff, 0xf3, 0xe7, 0xa7, 0xa3, },
	.ctx_len = 40,
	.tag = (const uint8_t []){ 0x81, 0x32, 0xe8, 0x65, 0xb6, 0x9d, 0x64, 0xef, 0x37, 0xdb, 0x26, 0x1f, 0x80, 0xcb, 0xbe, 0x24, },
	.tag_len = 16,
	.line = __LINE__,
	.id = 241
},
{
	.algo = TEE_ALG_AES_GCM, .mode = TEE_MODE_ENCRYPT, .key_type = TEE_TYPE_AES,
	.key = (const uint8_t []){ 0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff, 0x10, 0x21, 0x32, 0x43, 0x54, 0x65, 0x76, 0x87, 0x98, 0xa9, 0xba, 0xcb, 0xdc, 0xed, 0xfe, 0x0f, },
	.key_len = 32,
	.nonce = (const uint8_t []){ 0xce, 0x20, 0xa7, 0xe8, 0x70, 0x69, 0x6a, 0x5e, 0x68, 0x53, 0x3c, 0x46, 0x5b, 0xad, 0x2b, 0xa1, },
	.nonce_len = 16,
	.aad_incr = 0,
	.aad = NULL,
	.aad_len = 0,
	.in_incr = 0,
	.ptx = (const uint8_t []){ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, },
	.ptx_len = 40,
	.ctx = (const uint8_t []){ 0x4f, 0x43, 0x50, 0x56, 0x5d, 0x91, 0xd9, 0xaa, 0x8c, 0x5f, 0x40, 0x48, 0x55, 0x04, 0x92, 0xad, 0x6d, 0x6f, 0xda, 0xbf, 0x66, 0xda, 0x5d, 0x1e, 0x2a, 0xf7, 0xbf, 0xe1, 0xa8, 0xaa, 0xda, 0xa0, 0xba, 0xa3, 0xde, 0x38, 0xa4, 0x1d, 0x97, 0x13, },
	.ctx_len = 40,
	.tag = (const uint8_t []){ 0x15, 0x5d, 0xa6, 0x44, 0x1e, 0xc0, 0x71, 0xef, 0x2d, 0x8e, 0x6c, 0xff, 0xba, 0xcc, 0x1c, 0x7c, },
	.tag_len = 16,
	.line = __LINE__,
	.id = 242
},
{
	.algo = TEE_ALG_AES_GCM, .mode = TEE_MODE_ENCRYPT, .key_type = TEE_TYPE_AES,
	.key = (const uint8_t []){ 0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff, 0x10, 0x21, 0x32, 0x43, 0x54, 0x65, 0x76, 0x87, 0x98, 0xa9, 0xba, 0xcb, 0xdc, 0xed, 0xfe, 0x0f, },
	.key_len = 32,
	.nonce = (const uint8_t []){ 0x91, 0x8e, 0x3c, 0x19, 0xdb, 0xdf, 0xee, 0x2d, 0xb1, 0x81, 0x56, 0xc5, 0xb9, 0x3f, 0x3d, 0x75, },
	.nonce_len = 16,
	.aad_incr = 0,
	.aad = NULL,
	.aad_len = 0,
	.in_incr = 0,
	.ptx = (const uint8_t []){ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, },
	.ptx_len = 40,
	.ctx = (const uint8_t []){ 0x83, 0x16, 0xa5, 0x31, 0x67, 0xb6, 0xde, 0x1a, 0x75, 0x75, 0x70, 0x06, 0x93, 0xff, 0xef, 0x27, 0x4f, 0x43, 0x50, 0x56, 0x5d, 0x91, 0xd9, 0xaa, 0x8c, 0x5f, 0x40, 0x48, 0x55, 0x04, 0x92, 0xad, 0x6d, 0x6f, 0xda, 0xbf, 0x66, 0xda, 0x5d, 0x1e, },
	.ctx_len = 40,
	.tag = (const uint8_t []){ 0x6c, 0x57, 0x4a, 0xa6, 0xa2, 0x49, 0x0c, 0xc3, 0xb2, 0xf2, 0xf8, 0xf0, 0xff, 0xbc, 0x56, 0xc4, },
	.tag_len = 16,
	.line = __LINE__,
	.id = 243
},
{
	.algo = TEE_ALG_AES_GCM, .mode = TEE_MODE_ENCRYPT, .key_type = TEE_TYPE_AES,
	.key = (const uint8_t []){ 0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff, 0x10, 0x21, 0x32, 0x43, 0x54, 0x65, 0x76, 0x87, 0x98, 0xa9, 0xba, 0xcb, 0xdc, 0xed, 0xfe, 0x0f, },
	.key_len = 32,
	.nonce = (const uint8_t []){ 0x71, 0x7d, 0x90, 0x0b, 0x27, 0x04, 0x62, 0xb9, 0xdb, 0xf7, 0xe9, 0x41, 0x9e, 0x89, 0x06, 0x09, },
	.nonce_len = 16,
	.aad_incr = 0,
	.aad = NULL,
	.aad_len = 0,
	.in_incr = 0,
	.ptx = (const uint8_t []){ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, },
	.ptx_len = 40,
	.ctx = (const uint8_t []){ 0x51, 0x75, 0x92, 0x75, 0x13, 0xe7, 0x51, 0xeb, 0x30, 0x9f, 0x45, 0xbc, 0x2e, 0xf2, 0x25, 0xf2, 0x83, 0x16, 0xa5, 0x31, 0x67, 0xb6, 0xde, 0x1a, 0x75, 0x75, 0x70, 0x06, 0x93, 0xff, 0xef, 0x27, 0x4f, 0x43, 0x50, 0x56, 0x5d, 0x91, 0xd9, 0xaa, },
	.ctx_len = 40,
	.tag = (const uint8_t []){ 0x80, 0x82, 0xa7, 0x61, 0xe1, 0xd7, 0x55, 0x34, 0x4b, 0xf2, 0x96, 0x22, 0x14, 0x4e, 0x7d, 0x39, },
	.tag_len = 16,
	.line = __LINE__,
	.id = 244
},
{
	.algo = TEE_ALG_AES_GCM, .mode = TEE_MODE_ENCRYPT, .key_type = TEE_TYPE_AES,
	.key = (const uint8_t []){ 0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff, 0x10, 0x21, 0x32, 0x43, 0x54, 0x65, 0x76, 0x87, 0x98, 0xa9, 0xba, 0xcb, 0xdc, 0xed, 0xfe, 0x0f, },
	.key_len = 32,
	.nonce = (const uint8_t []){ 0xec, 0xd5, 0x21, 0x20, 0xaf, 0x24, 0x0e, 0x9b, 0x4b, 0xf3, 0xb9, 0xd1, 0xee, 0xb4, 0x94, 0x34, },
	.nonce_len = 16,
	.aad_incr = 0,
	.aad = NULL,
	.aad_len = 0,
	.in_incr = 0,
	.ptx = (const uint8_t []){ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, },
	.ptx_len = 40,
	.ctx = (const uint8_t []){ 0x36, 0xb3, 0xfb, 0xec, 0xd0, 0x91, 0x78, 0xd0, 0x45, 0x27, 0xfb, 0x37, 0x54, 0x4f, 0x55, 0x79, 0xd2, 0x0d, 0x60, 0xa4, 0x12, 0x66, 0xf6, 0x85, 0xc4, 0x80, 0x98, 0xe1, 0xa5, 0x28, 0x04, 0xca, 0x38, 0x7d, 0x90, 0x70, 0x9d, 0x32, 0x68, 0xdd, },
	.ctx_len = 40,
	.tag = (const uint8_t []){ 0x03, 0x3e, 0x0e, 0xf2, 0x95, 0x3e, 0xbf, 0xd8, 0x42, 0x57, 0x37, 0xc7, 0xd3, 0x93, 0xf8, 0x9a, },
	.tag_len = 16,
	.line = __LINE__,
	.id = 245
},
{
	.algo = TEE_ALG_AES_GCM, .mode = TEE_MODE_ENCRYPT, .key_type = TEE_TYPE_AES,
	.key = (const uint8_t []){ 0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff, 0x10, 0x21, 0x32, 0x43, 0x54, 0x65, 0x76, 0x87, 0x98, 0xa9, 0xba, 0xcb, 0xdc, 0xed, 0xfe, 0x0f, },
	.key_len = 32,
	.nonce = (const uint8_t []){ 0xb3, 0x7b, 0xba, 0xd1, 0x04, 0x92, 0x8a, 0xe8, 0x92, 0x21, 0xd3, 0x52, 0x0c, 0x26, 0x82, 0xe0, },
	.nonce_len = 16,
	.aad_incr = 0,
	.aad = NULL,
	.aad_len = 0,
	.in_incr = 0,
	.ptx = (const uint8_t []){ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, },
	.ptx_len = 40,
	.ctx = (const uint8_t []){ 0x16, 0x92, 0x9b, 0x77, 0x30, 0x51, 0xf1, 0x2b, 0x0a, 0xda, 0xc9, 0x5f, 0x65, 0xe2, 0x1a, 0x7f, 0x36, 0xb3, 0xfb, 0xec, 0xd0, 0x91, 0x78, 0xd0, 0x45, 0x27, 0xfb, 0x37, 0x54, 0x4f, 0x55, 0x79, 0xd2, 0x0d, 0x60, 0xa4, 0x12, 0x66, 0xf6, 0x85, },
	.ctx_len = 40,
	.tag = (const uint8_t []){ 0xca, 0x44, 0x8b, 0xb7, 0xe5, 0x2e, 0x89, 0x7e, 0xca, 0x23, 0x4e, 0xf3, 0x43, 0xd0, 0x57, 0xd0, },
	.tag_len = 16,
	.line = __LINE__,
	.id = 246
},
{
	.algo = TEE_ALG_AES_GCM, .mode = TEE_MODE_ENCRYPT, .key_type = TEE_TYPE_AES,
	.key = (const uint8_t []){ 0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff, 0x10, 0x21, 0x32, 0x43, 0x54, 0x65, 0x76, 0x87, 0x98, 0xa9, 0xba, 0xcb, 0xdc, 0xed, 0xfe, 0x0f, },
	.key_len = 32,
	.nonce = (const uint8_t []){ 0x53, 0x88, 0x16, 0xc3, 0xf8, 0x49, 0x06, 0x7c, 0xf8, 0x57, 0x6c, 0xd6, 0x2b, 0x90, 0xb9, 0x9c, },
	.nonce_len = 16,
	.aad_incr = 0,
	.aad = NULL,
	.aad_len = 0,
	.in_incr = 0,
	.ptx = (const uint8_t []){ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, },
	.ptx_len = 40,
	.ctx = (const uint8_t []){ 0x6d, 0x3f, 0xae, 0xfa, 0xf6, 0x91, 0xd5, 0x81, 0x63, 0x84, 0x6f, 0x8d, 0x4b, 0x9f, 0xfd, 0x59, 0x16, 0x92, 0x9b, 0x77, 0x30, 0x51, 0xf1, 0x2b, 0x0a, 0xda, 0xc9, 0x5f, 0x65, 0xe2, 0x1a, 0x7f, 0x36, 0xb3, 0xfb, 0xec, 0xd0, 0x91, 0x78, 0xd0, },
	.ctx_len = 40,
	.tag = (const uint8_t []){ 0x84, 0xf4, 0x97, 0x40, 0xe6, 0x75, 0x7f, 0x63, 0xdd, 0x0d, 0xf7, 0xcb, 0x76, 0x56, 0xd0, 0xef, },
	.tag_len = 16,
	.line = __LINE__,
	.id = 247
},
{
	.algo = TEE_ALG_AES_GCM, .mode = TEE_MODE_ENCRYPT, .key_type = TEE_TYPE_AES,
	.key = (const uint8_t []){ 0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff, 0x10, 0x21, 0x32, 0x43, 0x54, 0x65, 0x76, 0x87, 0x98, 0xa9, 0xba, 0xcb, 0xdc, 0xed, 0xfe, 0x0f, },
	.key_len = 32,
	.nonce = (const uint8_t []){ 0xd1, 0x0e, 0x63, 0x19, 0x43, 0xcd, 0x3b, 0xda, 0xba, 0xba, 0xb2, 0xbb, 0xd1, 0x39, 0x51, 0xc0, },
	.nonce_len = 16,
	.aad_incr = 0,
	.aad = NULL,
	.aad_len = 0,
	.in_incr = 0,
	.ptx = (const uint8_t []){ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, },
	.ptx_len = 40,
	.ctx = (const uint8_t []){ 0xd6, 0x01, 0x96, 0xc2, 0xd1, 0x4f, 0xcf, 0x30, 0xc0, 0x99, 0x1d, 0x27, 0x21, 0xdd, 0xc5, 0x2d, 0x38, 0x5f, 0x40, 0x7a, 0x16, 0x69, 0x1d, 0xad, 0xe8, 0x2c, 0x90, 0x23, 0xc8, 0x55, 0xfd, 0x8e, 0x2e, 0x8f, 0xbb, 0x56, 0x21, 0x02, 0xf0, 0x18, },
	.ctx_len = 40,
	.tag = (const uint8_t []){ 0x87, 0x7e, 0x15, 0xd9, 0x88, 0x9e, 0x69, 0xa9, 0x9f, 0xcc, 0x6d, 0x72, 0x74, 0x65, 0xc3, 0x91, },
	.tag_len = 16,
	.line = __LINE__,
	.id = 248
},
{
	.algo = TEE_ALG_AES_GCM, .mode = TEE_MODE_ENCRYPT, .key_type = TEE_TYPE_AES,
	.key = (const uint8_t []){ 0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff, 0x10, 0x21, 0x32, 0x43, 0x54, 0x65, 0x76, 0x87, 0x98, 0xa9, 0xba, 0xcb, 0xdc, 0xed, 0xfe, 0x0f, },
	.key_len = 32,
	.nonce = (const uint8_t []){ 0x8e, 0xa0, 0xf8, 0xe8, 0xe8, 0x7b, 0xbf, 0xa9, 0x63, 0x68, 0xd8, 0x38, 0x33, 0xab, 0x47, 0x14, },
	.nonce_len = 16,
	.aad_incr = 0,
	.aad = NULL,
	.aad_len = 0,
	.in_incr = 0,
	.ptx = (const uint8_t []){ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, },
	.ptx_len = 40,
	.ctx = (const uint8_t []){ 0x94, 0x8f, 0xbc, 0xec, 0xa1, 0x2a, 0x6e, 0x4f, 0xab, 0xb7, 0x9b, 0x6d, 0x96, 0x5e, 0x33, 0x6f, 0xd6, 0x01, 0x96, 0xc2, 0xd1, 0x4f, 0xcf, 0x30, 0xc0, 0x99, 0x1d, 0x27, 0x21, 0xdd, 0xc5, 0x2d, 0x38, 0x5f, 0x40, 0x7a, 0x16, 0x69, 0x1d, 0xad, },
	.ctx_len = 40,
	.tag = (const uint8_t []){ 0xcd, 0x57, 0x57, 0x62, 0x69, 0x45, 0x97, 0x6b, 0xa9, 0xf0, 0x26, 0x4b, 0xd6, 0xbe, 0xe8, 0x94, },
	.tag_len = 16,
	.line = __LINE__,
	.id = 249
},
{
	.algo = TEE_ALG_AES_GCM, .mode = TEE_MODE_ENCRYPT, .key_type = TEE_TYPE_AES,
	.key = (const uint8_t []){ 0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff, 0x10, 0x21, 0x32, 0x43, 0x54, 0x65, 0x76, 0x87, 0x98, 0xa9, 0xba, 0xcb, 0xdc, 0xed, 0xfe, 0x0f, },
	.key_len = 32,
	.nonce = (const uint8_t []){ 0x7b, 0x2d, 0xf4, 0xfb, 0xed, 0x1d, 0xe2, 0x72, 0x7e, 0xb2, 0x48, 0x98, 0xe5, 0xde, 0xab, 0xb9, },
	.nonce_len = 16,
	.aad_incr = 0,
	.aad = NULL,
	.aad_len = 0,
	.in_incr = 0,
	.ptx = (const uint8_t []){ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, },
	.ptx_len = 40,
	.ctx = (const uint8_t []){ 0xa1, 0xa0, 0x12, 0x06, 0x60, 0xff, 0x52, 0xe6, 0xb1, 0x70, 0x0b, 0x12, 0xc5, 0x4d, 0x2d, 0x33, 0xb9, 0x4b, 0x00, 0xcd, 0x78, 0x82, 0xd8, 0x85, 0x7d, 0x84, 0xe6, 0xe1, 0x83, 0xa1, 0xde, 0xa6, 0xee, 0x85, 0xa7, 0xda, 0x84, 0xfb, 0xc3, 0x5d, },
	.ctx_len = 40,
	.tag = (const uint8_t []){ 0xb0, 0x15, 0xd7, 0x2d, 0xa6, 0x2c, 0x81, 0xcb, 0x4d, 0x26, 0x72, 0x53, 0xb2, 0x0d, 0xb9, 0xe5, },
	.tag_len = 16,
	.line = __LINE__,
	.id = 250
},
{
	.algo = TEE_ALG_AES_GCM, .mode = TEE_MODE_ENCRYPT, .key_type = TEE_TYPE_AES,
	.key = (const uint8_t []){ 0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff, 0x10, 0x21, 0x32, 0x43, 0x54, 0x65, 0x76, 0x87, 0x98, 0xa9, 0xba, 0xcb, 0xdc, 0xed, 0xfe, 0x0f, },
	.key_len = 32,
	.nonce = (const uint8_t []){ 0x24, 0x83, 0x6f, 0x0a, 0x46, 0xab, 0x66, 0x01, 0xa7, 0x60, 0x22, 0x1b, 0x07, 0x4c, 0xbd, 0x6d, },
	.nonce_len = 16,
	.aad_incr = 0,
	.aad = NULL,
	.aad_len = 0,
	.in_incr = 0,
	.ptx = (const uint8_t []){ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, },
	.ptx_len = 40,
	.ctx = (const uint8_t []){ 0x5e, 0x34, 0x34, 0xb4, 0x5e, 0xdb, 0xf0, 0xd1, 0xf6, 0xe0, 0x2d, 0x11, 0x44, 0xdb, 0xf8, 0x67, 0xa1, 0xa0, 0x12, 0x06, 0x60, 0xff, 0x52, 0xe6, 0xb1, 0x70, 0x0b, 0x12, 0xc5, 0x4d, 0x2d, 0x33, 0xb9, 0x4b, 0x00, 0xcd, 0x78, 0x82, 0xd8, 0x85, },
	.ctx_len = 40,
	.tag = (const uint8_t []){ 0xee, 0x74, 0xcc, 0xb3, 0x0d, 0x64, 0x9e, 0xbf, 0x69, 0x16, 0xd0, 0x5a, 0x7d, 0xbe, 0x56, 0x96, },
	.tag_len = 16,
	.line = __LINE__,
	.id = 251
},
