/*
 * Decompiled with CFR 0.152.
 */
package org.scidac.cmcs.tools.bse.translators;

import com.sourceforge.knecs.util.converters.FormatException;
import java.io.IOException;
import java.util.Vector;
import org.jdom.Element;
import org.scidac.cmcs.tools.bse.BSEProperties;
import org.scidac.cmcs.tools.bse.Matrix;
import org.scidac.cmcs.tools.bse.translators.AbstractBasisSetXmlToText;

public class BasisXmlToNWChemLibrary
extends AbstractBasisSetXmlToText {
    protected boolean specifics = true;
    protected Element root = null;

    public BasisXmlToNWChemLibrary() {
    }

    public BasisXmlToNWChemLibrary(boolean includeSpecifics) {
        this.specifics = includeSpecifics;
    }

    @Override
    public String convert(String data, Vector elementList, boolean optimize) throws IOException, FormatException {
        return this.readBasisSet(data, elementList, optimize);
    }

    @Override
    protected void addHeader(StringBuffer output, Element root) throws FormatException {
        this.root = root;
    }

    @Override
    protected void addFooter(StringBuffer output) throws FormatException {
        this.addECPNameToOuput(output);
    }

    @Override
    protected void addElementDescription(StringBuffer output, String element, Element contractions) {
        String header = "";
        String title = this.root.getChildText("title", BSEProperties.mDcNs);
        String harmonicType = this.root.getChildText("harmonicType", BSEProperties.mBseNs);
        if (harmonicType == null) {
            harmonicType = "";
        }
        header = "basis \"" + element + "_" + title + "\" " + harmonicType.toUpperCase() + "\n";
        output.append(header);
    }

    @Override
    protected void addElementFooter(StringBuffer output, String element, Element contractions) {
        output.append("end\n");
    }

    @Override
    protected void readCmlMatrix(StringBuffer output, Vector matrices, String element, String shell) throws FormatException {
        for (int k = 0; k < matrices.size(); ++k) {
            Matrix matrix = (Matrix)matrices.get(k);
            int rows = matrix.getNumRows();
            int columns = matrix.getNumColumns();
            output.append(element + "    " + shell + "\n");
            try {
                for (int i = 0; i < rows; ++i) {
                    for (int j = 0; j < columns; ++j) {
                        String value = this.formattedValue(matrix.getValue(i, j));
                        output.append(value);
                    }
                    output.append("\n");
                }
                continue;
            }
            catch (IndexOutOfBoundsException ie) {
                throw new FormatException(ie.getMessage());
            }
        }
    }

    protected void addECPNameToOuput(StringBuffer output) throws FormatException {
        Element epLink = this.root.getChild("effectivePotentialsLink", BSEProperties.mEmslNs);
        if (epLink != null) {
            String epHREF = epLink.getAttributeValue("href", BSEProperties.mXlinkNs);
            if (epHREF != null && epHREF.endsWith("-ECP.xml")) {
                String ecpFile = epHREF.substring(0, epHREF.indexOf(".xml"));
                output.append("ASSOCIATED_ECP \"" + ecpFile + "\"\n");
            } else {
                throw new FormatException("Could not determine ECP link file!");
            }
        }
    }
}

