/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service.component;

import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Stack;
import java.util.Vector;
import javax.servlet.ServletConfig;
import org.apache.jetspeed.services.statemanager.SessionStateBindingListener;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.chefproject.core.Edit;
import org.chefproject.core.Event;
import org.chefproject.core.Notification;
import org.chefproject.core.NotificationAction;
import org.chefproject.core.NotificationEdit;
import org.chefproject.core.Resource;
import org.chefproject.core.ResourceProperties;
import org.chefproject.core.ResourcePropertiesEdit;
import org.chefproject.core.StorageUser;
import org.chefproject.core.component.BaseResourcePropertiesEdit;
import org.chefproject.exception.IdUnusedException;
import org.chefproject.exception.InUseException;
import org.chefproject.service.EventTrackingService;
import org.chefproject.service.IdService;
import org.chefproject.service.NotificationService;
import org.chefproject.service.ServerConfigurationService;
import org.chefproject.service.generic.GenericNotificationService;
import org.chefproject.util.CacheRefresher;
import org.chefproject.util.NotificationCache;
import org.chefproject.util.StringUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class BaseNotificationService
extends TurbineBaseService
implements GenericNotificationService,
Observer,
StorageUser,
CacheRefresher {
    protected Storage m_storage = null;
    protected NotificationCache m_cache = null;
    protected String m_accessPoint = null;
    protected String m_relativeAccessPoint = null;

    protected abstract Storage newStorage();

    protected boolean match(String filter, String ref) {
        if (filter == null) {
            return true;
        }
        if (filter.length() == 0) {
            return true;
        }
        return ref.startsWith(filter);
    }

    protected String getAccessPoint(boolean relative) {
        return relative ? this.m_relativeAccessPoint : this.m_accessPoint;
    }

    protected String notificationId(String ref) {
        String start = this.getAccessPoint(true) + "/";
        int i = ref.indexOf(start);
        if (i == -1) {
            return ref;
        }
        String id = ref.substring(i + start.length());
        return id;
    }

    protected String notificationUrl(String id) {
        return this.getAccessPoint(false) + "/" + id;
    }

    public void init(ServletConfig config) throws InitializationException {
        super.init(config);
        Log.info("chef", this + ".init(ServletConfig)");
    }

    public void init(RunData data) throws InitializationException {
        super.init(data);
        Log.info("chef", this + ".init(RunData)");
        this.m_relativeAccessPoint = "/notification";
        this.m_accessPoint = ServerConfigurationService.getAccessUrl() + this.m_relativeAccessPoint;
        NotificationService.getInstance();
    }

    public void init() throws InitializationException {
        super.init();
        this.m_storage = this.newStorage();
        this.m_storage.open();
        this.m_cache = new NotificationCache(this, this.notificationReference(""));
        EventTrackingService.addLocalObserver(this);
        Log.info("chef", this + ".init()");
    }

    public void shutdown() {
        EventTrackingService.deleteObserver(this);
        this.m_cache.clear();
        this.m_cache = null;
        this.m_storage.close();
        this.m_storage = null;
        Log.info("chef", this + ".shutdown()");
        super.shutdown();
    }

    public NotificationEdit addNotification() {
        String id = IdService.getUniqueId();
        NotificationEdit notification = this.m_storage.put(id);
        ((BaseNotificationEdit)notification).setEvent("notification.add");
        return notification;
    }

    public Notification getNotification(String id) throws IdUnusedException {
        Notification notification = null;
        String key = this.notificationReference(id);
        if (this.m_cache.containsKey(key)) {
            notification = this.m_cache.get(key);
        } else {
            notification = this.m_storage.get(id);
            this.m_cache.put(notification);
        }
        if (notification == null) {
            throw new IdUnusedException(id);
        }
        return notification;
    }

    public String notificationReference(String id) {
        return this.getAccessPoint(true) + "/" + id;
    }

    public NotificationEdit editNotification(String id) throws IdUnusedException, InUseException {
        if (this.m_cache.get(this.notificationReference(id)) == null && !this.m_storage.check(id)) {
            throw new IdUnusedException(id);
        }
        NotificationEdit notification = this.m_storage.edit(id);
        if (notification == null) {
            throw new InUseException(id);
        }
        ((BaseNotificationEdit)notification).setEvent("notification.update");
        return notification;
    }

    public void commitEdit(NotificationEdit notification) {
        if (!notification.isActiveEdit()) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                Log.warn("chef", this + ".commitEdit(): closed NotificationEdit", (Throwable)e);
                return;
            }
        }
        this.m_storage.commit(notification);
        EventTrackingService.post(EventTrackingService.newEvent(((BaseNotificationEdit)notification).getEvent(), notification.getReference(), true));
        ((BaseNotificationEdit)notification).closeEdit();
    }

    public void cancelEdit(NotificationEdit notification) {
        if (!notification.isActiveEdit()) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                Log.warn("chef", this + ".cancelEdit(): closed NotificationEdit", (Throwable)e);
                return;
            }
        }
        this.m_storage.cancel(notification);
        ((BaseNotificationEdit)notification).closeEdit();
    }

    public void removeNotification(NotificationEdit notification) {
        if (!notification.isActiveEdit()) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                Log.warn("chef", this + ".removeNotification(): closed NotificationEdit", (Throwable)e);
                return;
            }
        }
        this.m_storage.remove(notification);
        EventTrackingService.post(EventTrackingService.newEvent("notification.remove", notification.getReference(), true));
        ((BaseNotificationEdit)notification).closeEdit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getNotifications(String function) {
        List notifications = null;
        if (this.m_cache.disabled()) {
            notifications = this.m_storage.getAll(function);
        } else if (this.m_cache.isComplete()) {
            notifications = this.m_cache.getAll(function);
        } else {
            NotificationCache notificationCache = this.m_cache;
            synchronized (notificationCache) {
                if (this.m_cache.isComplete()) {
                    notifications = this.m_cache.getAll(function);
                } else {
                    this.m_cache.holdEvents();
                    List all = this.m_storage.getAll();
                    int i = 0;
                    while (i < all.size()) {
                        Notification notification = (Notification)all.get(i);
                        this.m_cache.put(notification);
                        ++i;
                    }
                    this.m_cache.setComplete();
                    notifications = this.m_cache.getAll(function);
                    this.m_cache.processEvents();
                }
            }
        }
        if (notifications == null) {
            notifications = new Vector();
        }
        return notifications;
    }

    public void update(Observable o, Object arg) {
        if (!(arg instanceof Event)) {
            return;
        }
        Event event = (Event)arg;
        String function = event.getEvent();
        List notifications = this.getNotifications(function);
        Iterator it = notifications.iterator();
        while (it.hasNext()) {
            Notification notification = (Notification)it.next();
            if (!this.match(notification.getResourceFilter(), event.getResource())) continue;
            notification.notify(event);
        }
    }

    public Resource newContainer(String ref) {
        return null;
    }

    public Resource newContainer(Element element) {
        return null;
    }

    public Resource newContainer(Resource other) {
        return null;
    }

    public Resource newResource(Resource container, String id, Object[] others) {
        return new BaseNotification(id);
    }

    public Resource newResource(Resource container, Element element) {
        return new BaseNotification(element);
    }

    public Resource newResource(Resource container, Resource other) {
        return new BaseNotification((Notification)other);
    }

    public Edit newContainerEdit(String ref) {
        return null;
    }

    public Edit newContainerEdit(Element element) {
        return null;
    }

    public Edit newContainerEdit(Resource other) {
        return null;
    }

    public Edit newResourceEdit(Resource container, String id, Object[] others) {
        BaseNotificationEdit e = new BaseNotificationEdit(id);
        e.activate();
        return e;
    }

    public Edit newResourceEdit(Resource container, Element element) {
        BaseNotificationEdit e = new BaseNotificationEdit(element);
        e.activate();
        return e;
    }

    public Edit newResourceEdit(Resource container, Resource other) {
        BaseNotificationEdit e = new BaseNotificationEdit((Notification)other);
        e.activate();
        return e;
    }

    public Object[] storageFields(Resource r) {
        return null;
    }

    public Object refresh(Object key, Object oldValue, Event event) {
        String id = this.notificationId((String)key);
        Notification notification = this.m_storage.get(id);
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", this + ".refresh(): " + key + " : " + id);
        }
        return notification;
    }

    public class BaseNotificationEdit
    extends BaseNotification
    implements NotificationEdit,
    SessionStateBindingListener {
        protected String m_event = null;
        protected boolean m_active = false;

        public BaseNotificationEdit(String id) {
            super(id);
        }

        public BaseNotificationEdit(Element el) {
            super(el);
        }

        public BaseNotificationEdit(Notification other) {
            super(other);
        }

        protected void finalize() {
            if (this.m_active) {
                BaseNotificationService.this.cancelEdit(this);
            }
        }

        public void setFunction(String function) {
            this.m_function = function;
        }

        public void setResourceFilter(String filter) {
            this.m_filter = filter;
        }

        public void setAction(NotificationAction action) {
            this.m_action = action;
        }

        protected void set(Notification other) {
            this.setAll(other);
        }

        protected String getEvent() {
            return this.m_event;
        }

        protected void setEvent(String event) {
            this.m_event = event;
        }

        public ResourcePropertiesEdit getPropertiesEdit() {
            return this.m_properties;
        }

        protected void activate() {
            this.m_active = true;
        }

        public boolean isActiveEdit() {
            return this.m_active;
        }

        protected void closeEdit() {
            this.m_active = false;
        }

        public void valueBound(String sessionStateKey, String attributeName) {
        }

        public void valueUnbound(String sessionStateKey, String attributeName) {
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", this + ".valueUnbound()");
            }
            if (this.m_active) {
                BaseNotificationService.this.cancelEdit(this);
            }
        }
    }

    public class BaseNotification
    implements Notification {
        protected String m_function = null;
        protected String m_filter = null;
        protected String m_id = null;
        protected ResourcePropertiesEdit m_properties = null;
        protected NotificationAction m_action = null;

        public BaseNotification(String id) {
            this.m_id = id;
            this.m_properties = new BaseResourcePropertiesEdit();
        }

        public BaseNotification(Notification other) {
            this.setAll(other);
        }

        public BaseNotification(Element el) {
            this.m_properties = new BaseResourcePropertiesEdit();
            this.m_id = el.getAttribute("id");
            this.m_function = StringUtil.trimToNull(el.getAttribute("function"));
            this.m_filter = StringUtil.trimToNull(el.getAttribute("filter"));
            NodeList children = el.getChildNodes();
            int length = children.getLength();
            int i = 0;
            while (i < length) {
                Node child = children.item(i);
                if (child.getNodeType() == 1) {
                    String className;
                    Element element = (Element)child;
                    if (element.getTagName().equals("properties")) {
                        this.m_properties = new BaseResourcePropertiesEdit(element);
                    } else if (element.getTagName().equals("action") && (className = StringUtil.trimToNull(element.getAttribute("class"))) != null) {
                        try {
                            this.m_action = (NotificationAction)Class.forName(className).newInstance();
                            this.m_action.set(element);
                        }
                        catch (Exception e) {
                            Log.warn("chef", this + " exception creating action helper: " + e.toString());
                        }
                    }
                }
                ++i;
            }
        }

        protected void setAll(Notification other) {
            BaseNotification bOther = (BaseNotification)other;
            this.m_id = bOther.m_id;
            this.m_function = bOther.m_function;
            this.m_filter = bOther.m_filter;
            this.m_properties = new BaseResourcePropertiesEdit();
            this.m_properties.addAll(bOther.m_properties);
            if (bOther.m_action != null) {
                this.m_action = bOther.m_action.getClone();
            }
        }

        public void notify(Event event) {
            if (this.m_action != null) {
                this.m_action.notify(event);
            }
        }

        public String getFunction() {
            return this.m_function;
        }

        public String getResourceFilter() {
            return this.m_filter;
        }

        public NotificationAction getAction() {
            return this.m_action;
        }

        public String getUrl() {
            return BaseNotificationService.this.notificationUrl(this.m_id);
        }

        public String getReference() {
            return BaseNotificationService.this.notificationReference(this.m_id);
        }

        public String getId() {
            return this.m_id;
        }

        public ResourceProperties getProperties() {
            return this.m_properties;
        }

        public Element toXml(Document doc, Stack stack) {
            Element notification = doc.createElement("notification");
            if (stack.isEmpty()) {
                doc.appendChild(notification);
            } else {
                ((Element)stack.peek()).appendChild(notification);
            }
            stack.push(notification);
            notification.setAttribute("id", this.getId());
            if (this.m_function != null) {
                notification.setAttribute("function", this.m_function);
            }
            if (this.m_filter != null) {
                notification.setAttribute("filter", this.m_filter);
            }
            this.m_properties.toXml(doc, stack);
            if (this.m_action != null) {
                Element action = doc.createElement("action");
                notification.appendChild(action);
                action.setAttribute("class", this.m_action.getClass().getName());
                this.m_action.toXml(action);
            }
            stack.pop();
            return notification;
        }
    }

    protected static interface Storage {
        public void open();

        public void close();

        public boolean check(String var1);

        public NotificationEdit put(String var1);

        public Notification get(String var1);

        public List getAll(String var1);

        public List getAll();

        public NotificationEdit edit(String var1);

        public void commit(NotificationEdit var1);

        public void cancel(NotificationEdit var1);

        public void remove(NotificationEdit var1);
    }
}

