/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.dsm.resourceobject;

import com.sourceforge.knecs.dsm.resourceobject.ChefObject;
import java.util.HashSet;

public class Group
extends ChefObject {
    public static final String NAME = "http://purl.oclc.org/NET/cmcs/internal/schema/:name";
    public static final String ICON = "http://purl.oclc.org/NET/cmcs/internal/schema/:icon";
    public static final String GROUPURL = "http://purl.oclc.org/NET/cmcs/schema/:url";
    public static final String DESCRIPTION = "http://purl.org/dc/elements/1.1/:description";
    public static final String JOINABLE = "http://purl.oclc.org/NET/cmcs/internal/schema/:openmembership";
    public static final String ROLEMEM = "http://purl.oclc.org/NET/cmcs/internal/schema/:rolemem";

    public Group() {
        this.setAttributeTypes();
        try {
            this.add("http://purl.org/dc/elements/1.1/:type", this.getClass().getName());
        }
        catch (Exception dsme) {
            this.mLog.severe("Exception creating User class: " + dsme.toString());
        }
    }

    private void setAttributeTypes() {
        this.mAttributeTypes.put(NAME, String.class);
        this.mAttributeTypes.put(DESCRIPTION, String.class);
        this.mAttributeTypes.put(JOINABLE, Boolean.class);
        this.mAttributeTypes.put(GROUPURL, String.class);
        this.mAttributeTypes.put(ICON, String.class);
        this.mAttributeTypes.put(ROLEMEM, String[].class);
    }

    public String getDisplayName() {
        return (String)this.mResourceEntry.get(NAME);
    }

    public String getDescription() {
        return (String)this.mResourceEntry.get(DESCRIPTION);
    }

    public Boolean isOpen() {
        return (Boolean)this.mResourceEntry.get(JOINABLE);
    }

    public String getIconUrl() {
        return (String)this.mResourceEntry.get(ICON);
    }

    public String getGroupUrl() {
        return (String)this.mResourceEntry.get(GROUPURL);
    }

    public String[] getRolesWithMembers() {
        return this.getAsStringArray(ROLEMEM);
    }

    public void setDisplayName(String value) {
        this.mResourceEntry.put(NAME, value);
    }

    public void setDescription(String value) {
        this.mResourceEntry.put(DESCRIPTION, value);
    }

    public void setIconUrl(String value) {
        this.mResourceEntry.put(ICON, value);
    }

    public void setOpen(Boolean value) {
        this.mResourceEntry.put(JOINABLE, value);
    }

    public void setGroupUrl(String value) {
        this.mResourceEntry.put(GROUPURL, value);
    }

    public void setRolesWithMembers(String[] values) {
        this.mResourceEntry.put(ROLEMEM, values);
    }

    public String[] getMembers() {
        String[] rolemem = this.getRolesWithMembers();
        HashSet<String> users = new HashSet<String>();
        for (int idx = 0; idx < rolemem.length; ++idx) {
            String user = this.parseUser(rolemem[idx]);
            if (user == null) continue;
            users.add(user);
        }
        return users.toArray(new String[users.size()]);
    }

    protected String parseUser(String source) {
        int pos = source.indexOf("%");
        if (pos >= 0) {
            return source.substring(0, pos);
        }
        return source;
    }
}

