/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service.component;

import java.util.List;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.util.Log;
import org.chefproject.core.StorageUser;
import org.chefproject.core.UserEdit;
import org.chefproject.service.component.BaseDbSingleStorage;
import org.chefproject.service.component.BaseUserDirectoryService;

public class DbCachedUserService
extends BaseUserDirectoryService {
    protected String m_userTableName = "CHEF_USER";
    protected boolean m_locksInDb = true;

    public void init() throws InitializationException {
        this.m_userTableName = this.getProperties().getProperty("userTable", this.m_userTableName);
        this.m_locksInDb = new Boolean(this.getProperties().getProperty("locks-db", "true"));
        super.init();
        Log.info("chef", this + ".init(): user table: " + this.m_userTableName);
    }

    protected BaseUserDirectoryService.Storage newStorage() {
        return new DbCachedStorage(this);
    }

    protected class DbCachedStorage
    extends BaseDbSingleStorage
    implements BaseUserDirectoryService.Storage {
        public DbCachedStorage(StorageUser user) {
            super(DbCachedUserService.this.m_userTableName, "USER_ID", null, DbCachedUserService.this.m_locksInDb, "user", user);
        }

        public boolean check(String id) {
            return super.checkResource(id);
        }

        public UserEdit get(String id) {
            return (UserEdit)super.getResource(id);
        }

        public List getAll() {
            return super.getAllResources();
        }

        public UserEdit put(String id) {
            return (UserEdit)super.putResource(id, null);
        }

        public UserEdit edit(String id) {
            return (UserEdit)super.editResource(id);
        }

        public void commit(UserEdit edit) {
            super.commitResource(edit);
        }

        public void cancel(UserEdit edit) {
            super.cancelResource(edit);
        }

        public void remove(UserEdit edit) {
            super.removeResource(edit);
        }
    }
}

