/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service.component;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import javax.servlet.ServletConfig;
import org.apache.jetspeed.services.statemanager.SessionStateBindingListener;
import org.apache.jetspeed.util.template.ContentTemplateLink;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.chefproject.core.CandidateInfo;
import org.chefproject.core.CandidateInfoEdit;
import org.chefproject.core.CandidatePath;
import org.chefproject.core.CandidatePathEdit;
import org.chefproject.core.Dissertation;
import org.chefproject.core.DissertationEdit;
import org.chefproject.core.DissertationStep;
import org.chefproject.core.DissertationStepEdit;
import org.chefproject.core.Edit;
import org.chefproject.core.Event;
import org.chefproject.core.Resource;
import org.chefproject.core.ResourceProperties;
import org.chefproject.core.ResourcePropertiesEdit;
import org.chefproject.core.StepStatus;
import org.chefproject.core.StepStatusEdit;
import org.chefproject.core.StorageUser;
import org.chefproject.core.User;
import org.chefproject.core.component.BaseResourcePropertiesEdit;
import org.chefproject.exception.IdInvalidException;
import org.chefproject.exception.IdUnusedException;
import org.chefproject.exception.IdUsedException;
import org.chefproject.exception.InUseException;
import org.chefproject.exception.PermissionException;
import org.chefproject.service.EventTrackingService;
import org.chefproject.service.IdService;
import org.chefproject.service.SecurityService;
import org.chefproject.service.UsageSessionService;
import org.chefproject.service.UserDirectoryService;
import org.chefproject.service.generic.GenericDissertationService;
import org.chefproject.util.Cache;
import org.chefproject.util.CacheRefresher;
import org.chefproject.util.FlexStringArray;
import org.chefproject.util.Time;
import org.chefproject.util.Validator;
import org.chefproject.util.Xml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class BaseDissertationService
extends TurbineBaseService
implements GenericDissertationService {
    protected DissertationStorage m_dissertationStorage = null;
    protected DissertationStepStorage m_stepStorage = null;
    protected CandidatePathStorage m_pathStorage = null;
    protected StepStatusStorage m_statusStorage = null;
    protected CandidateInfoStorage m_infoStorage = null;
    protected Cache m_dissertationCache = null;
    protected Cache m_stepCache = null;
    protected Cache m_pathCache = null;
    protected Cache m_statusCache = null;
    protected Cache m_infoCache = null;
    protected String m_accessPoint = null;
    protected String m_relativeAccessPoint = null;
    protected boolean m_initialized = false;
    protected String m_schoolSite = null;
    protected long m_lastQuery = -1L;
    protected Hashtable m_schoolGroups = null;

    protected abstract DissertationStorage newDissertationStorage();

    protected abstract DissertationStepStorage newDissertationStepStorage();

    protected abstract CandidatePathStorage newCandidatePathStorage();

    protected abstract StepStatusStorage newStepStatusStorage();

    protected abstract CandidateInfoStorage newCandidateInfoStorage();

    protected String getAccessPoint(boolean relative) {
        return relative ? this.getReferenceRoot() : this.m_accessPoint;
    }

    protected String dissertationReference(String site, String id) {
        String retVal = null;
        retVal = site == null ? this.getAccessPoint(true) + "/" + "d" + "/" + id : this.getAccessPoint(true) + "/" + "d" + "/" + this.getSchoolSite() + "/" + site + "/" + id;
        return retVal;
    }

    protected String stepReference(String site, String id) {
        String retVal = null;
        retVal = site == null ? this.getAccessPoint(true) + "/" + "s" + "/" + id : this.getAccessPoint(true) + "/" + "s" + "/" + this.getSchoolSite() + "/" + site + "/" + id;
        return retVal;
    }

    protected String statusReference(String site, String id) {
        String retVal = null;
        retVal = site == null ? this.getAccessPoint(true) + "/" + "ss" + "/" + id : this.getAccessPoint(true) + "/" + "ss" + "/" + this.getSchoolSite() + "/" + site + "/" + id;
        return retVal;
    }

    protected String pathReference(String site, String id) {
        String retVal = null;
        retVal = site == null ? this.getAccessPoint(true) + "/" + "p" + "/" + id : this.getAccessPoint(true) + "/" + "p" + "/" + this.getSchoolSite() + "/" + site + "/" + id;
        return retVal;
    }

    protected String infoReference(String site, String id) {
        String retVal = null;
        retVal = site == null ? this.getAccessPoint(true) + "/" + "i" + "/" + id : this.getAccessPoint(true) + "/" + "i" + "/" + this.getSchoolSite() + "/" + site + "/" + id;
        return retVal;
    }

    protected String dissertationId(String ref) {
        int i = ref.lastIndexOf("/");
        if (i == -1) {
            return ref;
        }
        String id = ref.substring(i + 1);
        return id;
    }

    protected String stepId(String ref) {
        int i = ref.lastIndexOf("/");
        if (i == -1) {
            return ref;
        }
        String id = ref.substring(i + 1);
        return id;
    }

    protected String pathId(String ref) {
        int i = ref.lastIndexOf("/");
        if (i == -1) {
            return ref;
        }
        String id = ref.substring(i + 1);
        return id;
    }

    protected String statusId(String ref) {
        int i = ref.lastIndexOf("/");
        if (i == -1) {
            return ref;
        }
        String id = ref.substring(i + 1);
        return id;
    }

    protected String infoId(String ref) {
        int i = ref.lastIndexOf("/");
        if (i == -1) {
            return ref;
        }
        String id = ref.substring(i + 1);
        return id;
    }

    protected boolean unlockCheck(String lock, String resource) {
        return SecurityService.unlock(lock, resource);
    }

    protected void unlock(String lock, String resource) throws PermissionException {
        if (!this.unlockCheck(lock, resource)) {
            throw new PermissionException(UsageSessionService.getSessionUser().getId(), lock, resource);
        }
    }

    public void init(ServletConfig config) throws InitializationException {
        super.init(config);
        Log.info("chef", this + ".init(ServletConfig)");
    }

    public void init(RunData data) throws InitializationException {
        this.m_schoolSite = this.getProperties().getProperty("schoolsite", this.m_schoolSite);
        this.m_relativeAccessPoint = "/dissertation";
        this.m_accessPoint = new ContentTemplateLink(data).getExternal().toString() + "access" + this.m_relativeAccessPoint;
        Log.info("chef", this + ".init(RunData): access point: " + this.m_accessPoint);
        super.init(data);
    }

    public void init() throws InitializationException {
        super.init();
        Log.info("chef", this + ".init()");
        this.m_dissertationStorage = this.newDissertationStorage();
        this.m_dissertationStorage.open();
        this.m_stepStorage = this.newDissertationStepStorage();
        this.m_stepStorage.open();
        this.m_pathStorage = this.newCandidatePathStorage();
        this.m_pathStorage.open();
        this.m_statusStorage = this.newStepStatusStorage();
        this.m_statusStorage.open();
        this.m_infoStorage = this.newCandidateInfoStorage();
        this.m_infoStorage.open();
        this.m_dissertationCache = new Cache((CacheRefresher)new DissertationCacheRefresher(), this.dissertationReference(null, ""));
        this.m_stepCache = new Cache((CacheRefresher)new DissertationStepCacheRefresher(), this.stepReference(null, ""));
        this.m_pathCache = new Cache((CacheRefresher)new CandidatePathCacheRefresher(), this.pathReference(null, ""));
        this.m_statusCache = new Cache((CacheRefresher)new StepStatusCacheRefresher(), this.statusReference(null, ""));
        this.m_infoCache = new Cache((CacheRefresher)new CandidateInfoCacheRefresher(), this.infoReference(null, ""));
        String fosString = null;
        String programString = null;
        String bggString = null;
        this.m_schoolGroups = new Hashtable();
        fosString = "0030";
        programString = "00043";
        bggString = "001";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "0100";
        programString = "00045";
        bggString = "001";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "0130";
        programString = "00047";
        bggString = "002";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "0190";
        programString = "00049";
        bggString = "022";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "0300";
        programString = "00051";
        bggString = "003";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "0310";
        programString = "00054";
        bggString = "004";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "0400";
        programString = "01733";
        bggString = "009";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "0420";
        programString = "01568";
        bggString = "154";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "0460";
        programString = "01573";
        bggString = "014";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "0480";
        programString = "00060";
        bggString = "006";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "0570";
        programString = "00066";
        bggString = "081";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "0590";
        programString = "00069";
        bggString = "007";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "0670";
        programString = "00075";
        bggString = "009";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "0680";
        programString = "00077";
        bggString = "009";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "0690";
        programString = "00079";
        bggString = "009";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "0700";
        programString = "00081";
        bggString = "014";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "0710";
        programString = "00084";
        bggString = "015";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "0790";
        programString = "00086";
        bggString = "018";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "0820";
        programString = "00088";
        bggString = "016";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "0840";
        programString = "00090";
        bggString = "017";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "0870";
        programString = "00092";
        bggString = "017";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "0880";
        programString = "00094";
        bggString = "018";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "0920";
        programString = "00097";
        bggString = "041";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "0930";
        programString = "00100";
        bggString = "019";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "0960";
        programString = "00104";
        bggString = "020";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "0990";
        programString = "00107";
        bggString = "017";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "1160";
        programString = "00109";
        bggString = "021";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "1220";
        programString = "00111";
        bggString = "023";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "1250";
        programString = "00114";
        bggString = "024";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "1260";
        programString = "00117";
        bggString = "022";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "1290";
        programString = "01611";
        bggString = "022";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "1380";
        programString = "00118";
        bggString = "025";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "1550";
        programString = "00121";
        bggString = "026";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "1580";
        programString = "00124";
        bggString = "028";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "1600";
        programString = "00126";
        bggString = "027";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "1720";
        programString = "00136";
        bggString = "031";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "1840";
        programString = "00140";
        bggString = "033";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "1890";
        programString = "00147";
        bggString = "036";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "1900";
        programString = "00150";
        bggString = "036";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "2570";
        programString = "01723";
        bggString = "171";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "2580";
        programString = "00165";
        bggString = "043";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "2630";
        programString = "00167";
        bggString = "044";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        programString = "00168";
        bggString = "044";
        this.m_schoolGroups.put(programString, bggString);
        programString = "01624";
        bggString = "044";
        this.m_schoolGroups.put(programString, bggString);
        programString = "01631";
        bggString = "044";
        this.m_schoolGroups.put(programString, bggString);
        fosString = "2750";
        programString = "00173";
        bggString = "045";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "2780";
        programString = "00175";
        bggString = "046";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "2800";
        programString = "00177";
        bggString = "047";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "2810";
        programString = "00181";
        bggString = "048";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "3090";
        programString = "00189";
        bggString = "049";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "3140";
        programString = "00190";
        bggString = "051";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "3150";
        programString = "00193";
        bggString = "050";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "3170";
        programString = "00194";
        bggString = "026";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "3200";
        programString = "00196";
        bggString = "052";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "3260";
        programString = "00198";
        bggString = "053";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "3310";
        programString = "00200";
        bggString = "009";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "3330";
        programString = "00202";
        bggString = "009";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "3350";
        programString = "00204";
        bggString = "009";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "3830";
        programString = "00216";
        bggString = "060";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "3940";
        programString = "00220";
        bggString = "061";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "4030";
        programString = "00222";
        bggString = "063";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "4050";
        programString = "00224";
        bggString = "066";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "4110";
        programString = "00228";
        bggString = "067";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "4190";
        programString = "00230";
        bggString = "065";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "4240";
        programString = "01571";
        bggString = "066";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "4340";
        programString = "00236";
        bggString = "069";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "4390";
        programString = "00239";
        bggString = "072";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "4420";
        programString = "00245";
        bggString = "052";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "4440";
        programString = "00247";
        bggString = "074";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "4470";
        programString = "01100";
        bggString = "074";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "4490";
        programString = "01563";
        bggString = "085";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "4510";
        programString = "00251";
        bggString = "105";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "4670";
        programString = "00255";
        bggString = "076";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "4680";
        programString = "00258";
        bggString = "090";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        programString = "00260";
        bggString = "090";
        this.m_schoolGroups.put(programString, bggString);
        fosString = "4740";
        programString = "01637";
        bggString = "150";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "4870";
        programString = "01596";
        bggString = "077";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "4880";
        programString = "01597";
        bggString = "077";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "4890";
        programString = "01598";
        bggString = "077";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "4900";
        programString = "00271";
        bggString = "077";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "4940";
        programString = "00273";
        bggString = "078";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "5000";
        programString = "00275";
        bggString = "032";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "5040";
        programString = "00276";
        bggString = "079";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "5080";
        programString = "00278";
        bggString = "080";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "5130";
        programString = "00281";
        bggString = "081";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "5140";
        programString = "00285";
        bggString = "065";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "5200";
        programString = "00290";
        bggString = "084";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "5230";
        programString = "00293";
        bggString = "079";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "5270";
        programString = "01726";
        bggString = "175";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "5330";
        programString = "00297";
        bggString = "085";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "5340";
        programString = "00299";
        bggString = "085";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "5350";
        programString = "00300";
        bggString = "060";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "5400";
        programString = "01067";
        bggString = "089";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        programString = "01068";
        bggString = "089";
        this.m_schoolGroups.put(programString, bggString);
        fosString = "5430";
        programString = "00309";
        bggString = "088";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "5440";
        programString = "01065";
        bggString = "088";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        programString = "01066";
        bggString = "088";
        this.m_schoolGroups.put(programString, bggString);
        fosString = "5460";
        programString = "00312";
        bggString = "088";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "5470";
        programString = "00313";
        bggString = "089";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "5640";
        programString = "01070";
        bggString = "089";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        programString = "01071";
        bggString = "089";
        this.m_schoolGroups.put(programString, bggString);
        programString = "01072";
        bggString = "089";
        this.m_schoolGroups.put(programString, bggString);
        programString = "01073";
        bggString = "089";
        this.m_schoolGroups.put(programString, bggString);
        programString = "01074";
        bggString = "089";
        this.m_schoolGroups.put(programString, bggString);
        programString = "01075";
        bggString = "089";
        this.m_schoolGroups.put(programString, bggString);
        programString = "01076";
        bggString = "089";
        this.m_schoolGroups.put(programString, bggString);
        programString = "01077";
        bggString = "089";
        this.m_schoolGroups.put(programString, bggString);
        programString = "01078";
        bggString = "089";
        this.m_schoolGroups.put(programString, bggString);
        programString = "01079";
        bggString = "089";
        this.m_schoolGroups.put(programString, bggString);
        programString = "01080";
        bggString = "089";
        this.m_schoolGroups.put(programString, bggString);
        programString = "01081";
        bggString = "089";
        this.m_schoolGroups.put(programString, bggString);
        programString = "01082";
        bggString = "089";
        this.m_schoolGroups.put(programString, bggString);
        programString = "01083";
        bggString = "089";
        this.m_schoolGroups.put(programString, bggString);
        programString = "01084";
        bggString = "089";
        this.m_schoolGroups.put(programString, bggString);
        programString = "01085";
        bggString = "089";
        this.m_schoolGroups.put(programString, bggString);
        programString = "01086";
        bggString = "089";
        this.m_schoolGroups.put(programString, bggString);
        programString = "01087";
        bggString = "089";
        this.m_schoolGroups.put(programString, bggString);
        programString = "01088";
        bggString = "089";
        this.m_schoolGroups.put(programString, bggString);
        programString = "01089";
        bggString = "089";
        this.m_schoolGroups.put(programString, bggString);
        programString = "01090";
        bggString = "089";
        this.m_schoolGroups.put(programString, bggString);
        programString = "01091";
        bggString = "089";
        this.m_schoolGroups.put(programString, bggString);
        programString = "01092";
        bggString = "089";
        this.m_schoolGroups.put(programString, bggString);
        programString = "01595";
        bggString = "089";
        this.m_schoolGroups.put(programString, bggString);
        fosString = "5670";
        programString = "00317";
        bggString = "088";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "5730";
        programString = "00318";
        bggString = "090";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "5740";
        programString = "00320";
        bggString = "090";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "5790";
        programString = "00323";
        bggString = "090";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "5810";
        programString = "00324";
        bggString = "091";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "5820";
        programString = "00329";
        bggString = "092";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "5830";
        programString = "00331";
        bggString = "092";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "5950";
        programString = "00336";
        bggString = "093";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "5980";
        programString = "00338";
        bggString = "094";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "6000";
        programString = "01565";
        bggString = "094";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "6100";
        programString = "00344";
        bggString = "094";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "6130";
        programString = "00347";
        bggString = "095";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "6160";
        programString = "00351";
        bggString = "015";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "6170";
        programString = "00353";
        bggString = "060";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "6180";
        programString = "00355";
        bggString = "015";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "6300";
        programString = "00358";
        bggString = "041";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "6340";
        programString = "00360";
        bggString = "041";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "6680";
        programString = "00367";
        bggString = "097";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "6810";
        programString = "00372";
        bggString = "099";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "6840";
        programString = "00374";
        bggString = "099";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "6890";
        programString = "00376";
        bggString = "099";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "6950";
        programString = "00378";
        bggString = "098";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "7010";
        programString = "00380";
        bggString = "099";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "7040";
        programString = "00384";
        bggString = "076";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "7060";
        programString = "00387";
        bggString = "100";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "7180";
        programString = "00389";
        bggString = "101";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "7350";
        programString = "00394";
        bggString = "103";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "7460";
        programString = "00397";
        bggString = "104";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "7490";
        programString = "00403";
        bggString = "105";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "7500";
        programString = "00404";
        bggString = "105";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "7720";
        programString = "01677";
        bggString = "151";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "7730";
        programString = "01679";
        bggString = "151";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "7740";
        programString = "00409";
        bggString = "106";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "7750";
        programString = "01681";
        bggString = "151";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "7770";
        programString = "00412";
        bggString = "107";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "7880";
        programString = "00415";
        bggString = "109";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "8030";
        programString = "00426";
        bggString = "111";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "8090";
        programString = "00456";
        bggString = "111";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "8170";
        programString = "00458";
        bggString = "111";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "8200";
        programString = "00460";
        bggString = "111";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "8350";
        programString = "00463";
        bggString = "026";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "8480";
        programString = "00467";
        bggString = "114";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "8890";
        programString = "00475";
        bggString = "116";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "8940";
        programString = "00476";
        bggString = "117";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "8950";
        programString = "00478";
        bggString = "118";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "9090";
        programString = "00483";
        bggString = "119";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "9280";
        programString = "00490";
        bggString = "120";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "9360";
        programString = "00498";
        bggString = "052";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "9380";
        programString = "00501";
        bggString = "123";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        fosString = "9990";
        programString = "00512";
        bggString = "071";
        this.m_schoolGroups.put(fosString, bggString);
        this.m_schoolGroups.put(programString, bggString);
        if (!this.m_infoStorage.check("testidone")) {
            CandidateInfoEdit idOne = this.m_infoStorage.put("testidone", "datalistener");
            idOne.setEmplid("11111111");
            idOne.setProgram("001");
            idOne.setChefId("aerocandid1");
            idOne.setParentSiteId("diss001");
            idOne.setSite("datalistener");
            this.m_infoStorage.commit(idOne);
        }
        if (!this.m_infoStorage.check("testidtwo")) {
            CandidateInfoEdit idTwo = this.m_infoStorage.put("testidtwo", "datalistener");
            idTwo.setEmplid("22221111");
            idTwo.setProgram("044");
            idTwo.setChefId("edcandid1");
            idTwo.setParentSiteId("diss044");
            idTwo.setSite("datalistener");
            this.m_infoStorage.commit(idTwo);
        }
        if (!this.m_infoStorage.check("testidthree")) {
            CandidateInfoEdit idThree = this.m_infoStorage.put("testidthree", "datalistener");
            idThree.setEmplid("11112222");
            idThree.setProgram("001");
            idThree.setChefId("aerocandid2");
            idThree.setParentSiteId("diss001");
            idThree.setSite("datalistener");
            this.m_infoStorage.commit(idThree);
        }
        if (!this.m_infoStorage.check("testidfour")) {
            CandidateInfoEdit idFour = this.m_infoStorage.put("testidfour", "datalistener");
            idFour.setEmplid("22222222");
            idFour.setProgram("044");
            idFour.setChefId("edcandid2");
            idFour.setParentSiteId("diss044");
            idFour.setSite("datalistener");
            this.m_infoStorage.commit(idFour);
        }
    }

    public void shutdown() {
        this.m_dissertationCache.clear();
        this.m_dissertationCache = null;
        this.m_stepCache.clear();
        this.m_stepCache = null;
        this.m_pathCache.clear();
        this.m_pathCache = null;
        this.m_statusCache.clear();
        this.m_statusCache = null;
        this.m_infoCache.clear();
        this.m_infoCache = null;
        this.m_dissertationStorage.close();
        this.m_dissertationStorage = null;
        this.m_stepStorage.close();
        this.m_stepStorage = null;
        this.m_pathStorage.close();
        this.m_pathStorage = null;
        this.m_statusStorage.close();
        this.m_statusStorage = null;
        this.m_infoStorage.close();
        this.m_infoStorage = null;
        Log.info("chef", this + ".shutdown()");
        super.shutdown();
    }

    public String getProgram(String fos) {
        String retVal = "";
        if (fos != null) {
            retVal = (String)this.m_schoolGroups.get(fos);
        }
        return retVal;
    }

    public boolean hasCandidateInfos() {
        boolean retVal = false;
        List keys = this.m_infoCache.getKeys();
        if (keys.size() > 0) {
            retVal = true;
        } else {
            List allInfos = this.m_infoStorage.getAll();
            if (allInfos.size() > 0) {
                retVal = true;
            }
        }
        return retVal;
    }

    public boolean getIsInitialized() {
        return this.m_initialized;
    }

    public void dumpData(Vector data) {
        boolean changed = false;
        CandidateInfoEdit info = null;
        CandidatePath path = null;
        CandidatePathEdit pathEdit = null;
        Hashtable orderedStatus = null;
        String statusId = null;
        String statusRef = null;
        String autoValidationId = null;
        String parentSite = null;
        String candidateSite = null;
        int autoValidNumber = 0;
        StepStatusEdit statusEdit = null;
        Time completionTime = null;
        int x = 0;
        while (x < data.size()) {
            try {
                info = (CandidateInfoEdit)data.get(x);
                path = this.getCandidatePathForCandidate(info.getChefId());
                if (path == null) {
                    try {
                        candidateSite = info.getChefId() + "diss";
                        parentSite = "diss" + info.getProgram();
                        Dissertation dissertation = this.getDissertationForSite(parentSite);
                        if (dissertation == null) {
                            dissertation = this.getDissertationForSite(this.getSchoolSite());
                            if (dissertation == null) {
                                return;
                            }
                            pathEdit = this.addCandidatePathFromListener(dissertation, candidateSite);
                            pathEdit.setCandidate(info.getChefId());
                            this.commitEdit(pathEdit);
                        } else {
                            pathEdit = this.addCandidatePathFromListener(dissertation, candidateSite);
                            pathEdit.setCandidate(info.getChefId());
                            this.commitEdit(pathEdit);
                        }
                        orderedStatus = pathEdit.getOrderedStatus();
                    }
                    catch (Exception e) {
                        Log.warn("chef", "DISSERTATION : BASE SERVICE : DUMP DATA : EXCEPTION : " + e);
                    }
                } else {
                    orderedStatus = path.getOrderedStatus();
                }
                int y = 1;
                while (y < orderedStatus.size() + 1) {
                    statusRef = (String)orderedStatus.get("" + y);
                    statusId = this.statusId(statusRef);
                    statusEdit = this.m_statusStorage.edit(statusId);
                    autoValidationId = statusEdit.getAutoValidationId();
                    if (autoValidationId != "" && autoValidationId != "None") {
                        try {
                            autoValidNumber = Integer.parseInt(autoValidationId);
                            completionTime = info.getExternalValidation(autoValidNumber);
                            if (completionTime != null && !statusEdit.getCompleted()) {
                                statusEdit.setCompleted(true);
                                statusEdit.setTimeCompleted(completionTime);
                                this.commitEdit(statusEdit);
                            }
                        }
                        catch (Exception nfe) {
                            Log.warn("chef", "DISSERTATION : BASE SERVICE : DUMP DATA : EXCEPTION PROCESSING AUTOVALID NUMBER : " + autoValidationId);
                            Log.warn("chef", "DISSERTATION : BASE SERVICE : DUMP DATA : EXCEPTION MESSAGE : " + nfe);
                        }
                    }
                    ++y;
                }
            }
            catch (Exception e) {
                Log.warn("chef", "DISSERTATION : BASE SERVICE : DUMP DATA : EXCEPTION STORING DATA FOR : " + info.getChefId());
                Log.warn("chef", "DISSERTATION : BASE SERVICE : DUMP DATA : EXCEPTION " + e);
            }
            ++x;
        }
        this.m_initialized = true;
    }

    protected String getSiteForProgram(String program) {
        String retVal = "diss" + program;
        return retVal;
    }

    public User[] getAllUsersForSite(String site) {
        User[] retVal = null;
        try {
            CandidatePath aPath = null;
            FlexStringArray userIds = new FlexStringArray();
            List paths = this.getCandidatePaths();
            Object aUser = null;
            int x = 0;
            while (x < paths.size()) {
                aPath = (CandidatePath)paths.get(x);
                if (site.equals(this.getSchoolSite())) {
                    userIds.add(aPath.getCandidate());
                } else if (site.equals(this.getParentSiteForUser(aPath.getCandidate()))) {
                    userIds.add(aPath.getCandidate());
                }
                ++x;
            }
            retVal = new User[userIds.size()];
            int x2 = 0;
            while (x2 < userIds.size()) {
                retVal[x2] = UserDirectoryService.getUser(userIds.get(x2));
                ++x2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    public boolean getIsCandidate(String userId) {
        boolean retVal = false;
        if (userId != null) {
            try {
                CandidateInfo info = null;
                List allInfos = this.getCandidateInfos();
                int x = 0;
                while (x < allInfos.size()) {
                    info = (CandidateInfo)allInfos.get(x);
                    if (userId.equals(info.getChefId())) {
                        retVal = true;
                    }
                    ++x;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return retVal;
    }

    public String getParentSiteForUser(String userId) {
        String retVal = "";
        List allInfos = null;
        CandidateInfo info = null;
        if (userId != null) {
            try {
                allInfos = this.getCandidateInfos();
                int x = 0;
                while (x < allInfos.size()) {
                    info = (CandidateInfo)allInfos.get(x);
                    if (userId.equals(info.getChefId())) {
                        retVal = this.getSiteForProgram(info.getProgram());
                    }
                    ++x;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return retVal;
    }

    public String getEmplidForUser(String userId) {
        String retVal = "";
        List allInfos = null;
        CandidateInfo info = null;
        if (userId != null) {
            try {
                allInfos = this.getCandidateInfos();
                int x = 0;
                while (x < allInfos.size()) {
                    info = (CandidateInfo)allInfos.get(x);
                    if (userId.equals(info.getChefId())) {
                        retVal = info.getEmplid();
                    }
                    ++x;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return retVal;
    }

    public DissertationEdit addDissertation(String site) throws PermissionException {
        String dissertationId = null;
        boolean badId = false;
        do {
            badId = false;
            dissertationId = IdService.getUniqueId();
            try {
                Validator.checkResourceId(dissertationId);
            }
            catch (IdInvalidException iie) {
                badId = true;
            }
            if (!this.m_dissertationStorage.check(dissertationId)) continue;
            badId = true;
        } while (badId);
        String key = this.dissertationReference(site, dissertationId);
        this.unlock("dis.dis.add", key);
        DissertationEdit dissertation = this.m_dissertationStorage.put(dissertationId, site);
        dissertation.setSite(site);
        EventTrackingService.post(EventTrackingService.newEvent("dis.dis.add", key, true));
        return dissertation;
    }

    public DissertationEdit mergeDissertation(Element el) throws IdInvalidException, IdUsedException, PermissionException {
        BaseDissertation dissertationFromXml = new BaseDissertation(el);
        Validator.checkResourceId(dissertationFromXml.getId());
        this.unlock("dis.dis.add", dissertationFromXml.getReference());
        DissertationEdit dissertation = this.m_dissertationStorage.put(dissertationFromXml.getId(), dissertationFromXml.getSite());
        if (dissertation == null) {
            throw new IdUsedException(dissertationFromXml.getId());
        }
        ((BaseDissertationEdit)dissertation).set(dissertationFromXml);
        ((BaseDissertationEdit)dissertation).setEvent("dis.dis.add");
        return dissertation;
    }

    public Dissertation getDissertation(String dissertationReference) throws IdUnusedException, PermissionException {
        Dissertation dissertation = null;
        String dissertationId = this.dissertationId(dissertationReference);
        if (this.m_dissertationCache.containsKey(dissertationReference)) {
            dissertation = (Dissertation)this.m_dissertationCache.get(dissertationReference);
        } else {
            dissertation = this.m_dissertationStorage.get(dissertationId);
            this.m_dissertationCache.put(dissertationReference, dissertation);
        }
        if (dissertation == null) {
            throw new IdUnusedException(dissertationId);
        }
        this.unlock("dis.dis.read", dissertationReference);
        EventTrackingService.post(EventTrackingService.newEvent("dis.dis.read", dissertation.getReference(), false));
        return dissertation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getDissertations() {
        List dissertations = new Vector();
        if (this.m_dissertationCache.disabled()) {
            dissertations = this.m_dissertationStorage.getAll();
        } else if (this.m_dissertationCache.isComplete()) {
            dissertations = this.m_dissertationCache.getAll();
        } else {
            Cache cache = this.m_dissertationCache;
            synchronized (cache) {
                block9: {
                    if (!this.m_dissertationCache.isComplete()) break block9;
                    dissertations = this.m_dissertationCache.getAll();
                    List list = dissertations;
                    return list;
                }
                this.m_dissertationCache.holdEvents();
                dissertations = this.m_dissertationStorage.getAll();
                int i = 0;
                while (i < dissertations.size()) {
                    Dissertation dissertation = (Dissertation)dissertations.get(i);
                    this.m_dissertationCache.put(dissertation.getReference(), dissertation);
                    ++i;
                }
                this.m_dissertationCache.setComplete();
                this.m_dissertationCache.processEvents();
            }
        }
        return dissertations;
    }

    public DissertationEdit editDissertation(String dissertationReference) throws IdUnusedException, PermissionException, InUseException {
        this.unlock("dis.dis.upd", dissertationReference);
        String dissertationId = this.dissertationId(dissertationReference);
        if (this.m_dissertationCache.get(dissertationReference) == null && !this.m_dissertationStorage.check(dissertationId)) {
            throw new IdUnusedException(dissertationId);
        }
        DissertationEdit dissertation = this.m_dissertationStorage.edit(dissertationId);
        if (dissertation == null) {
            throw new InUseException(dissertationId);
        }
        ((BaseDissertationEdit)dissertation).setEvent("dis.dis.upd");
        return dissertation;
    }

    public void commitEdit(DissertationEdit dissertation) {
        if (!dissertation.isActiveEdit()) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                Log.warn("chef", this + ".commitEdit(): closed DissertationEdit", (Throwable)e);
                return;
            }
        }
        this.addLiveUpdateProperties(dissertation.getPropertiesEdit());
        this.m_dissertationStorage.commit(dissertation);
        EventTrackingService.post(EventTrackingService.newEvent(((BaseDissertationEdit)dissertation).getEvent(), dissertation.getReference(), true));
        ((BaseDissertationEdit)dissertation).closeEdit();
    }

    public void cancelEdit(DissertationEdit dissertation) {
        if (!dissertation.isActiveEdit()) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                Log.warn("chef", this + ".cancelEdit(): closed DissertationEdit", (Throwable)e);
                return;
            }
        }
        this.m_dissertationStorage.cancel(dissertation);
        ((BaseDissertationEdit)dissertation).closeEdit();
    }

    public void removeDissertation(DissertationEdit dissertation) throws PermissionException {
        if (dissertation != null) {
            if (!dissertation.isActiveEdit()) {
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    Log.warn("chef", this + ".removeDissertation(): closed DissertationEdit", (Throwable)e);
                    return;
                }
            }
            this.unlock("dis.dis.del", dissertation.getReference());
            this.m_dissertationStorage.remove(dissertation);
            EventTrackingService.post(EventTrackingService.newEvent("dis.dis.del", dissertation.getReference(), true));
            ((BaseDissertationEdit)dissertation).closeEdit();
        }
    }

    public DissertationStepEdit addDissertationStep(String site) throws PermissionException {
        String stepId = null;
        boolean badId = false;
        do {
            badId = false;
            stepId = IdService.getUniqueId();
            try {
                Validator.checkResourceId(stepId);
            }
            catch (IdInvalidException iie) {
                badId = true;
            }
            if (!this.m_stepStorage.check(stepId)) continue;
            badId = true;
        } while (badId);
        String key = this.stepReference(site, stepId);
        this.unlock("dis.step.add", key);
        DissertationStepEdit step = this.m_stepStorage.put(stepId, site);
        step.setSite(site);
        EventTrackingService.post(EventTrackingService.newEvent("dis.step.add", key, true));
        return step;
    }

    public DissertationStepEdit mergeDissertationStep(Element el) throws IdInvalidException, IdUsedException, PermissionException {
        BaseDissertationStep stepFromXml = new BaseDissertationStep(el);
        Validator.checkResourceId(stepFromXml.getId());
        this.unlock("dis.step.add", stepFromXml.getReference());
        DissertationStepEdit step = this.m_stepStorage.put(stepFromXml.getId(), stepFromXml.getSite());
        if (step == null) {
            throw new IdUsedException(stepFromXml.getId());
        }
        ((BaseDissertationStepEdit)step).set(stepFromXml);
        ((BaseDissertationStepEdit)step).setEvent("dis.step.add");
        return step;
    }

    public DissertationStep getDissertationStep(String stepReference) throws IdUnusedException, PermissionException {
        DissertationStep step = null;
        String stepId = this.stepId(stepReference);
        if (this.m_stepCache.containsKey(stepReference)) {
            step = (DissertationStep)this.m_stepCache.get(stepReference);
        } else {
            step = this.m_stepStorage.get(stepId);
            this.m_stepCache.put(stepReference, step);
        }
        if (step == null) {
            throw new IdUnusedException(stepId);
        }
        this.unlock("dis.step.read", stepReference);
        EventTrackingService.post(EventTrackingService.newEvent("dis.step.read", step.getReference(), false));
        return step;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getDissertationSteps() {
        List steps = new Vector();
        if (this.m_stepCache.disabled()) {
            steps = this.m_stepStorage.getAll();
        } else if (this.m_stepCache.isComplete()) {
            steps = this.m_stepCache.getAll();
        } else {
            Cache cache = this.m_stepCache;
            synchronized (cache) {
                block9: {
                    if (!this.m_stepCache.isComplete()) break block9;
                    steps = this.m_stepCache.getAll();
                    List list = steps;
                    return list;
                }
                this.m_stepCache.holdEvents();
                steps = this.m_stepStorage.getAll();
                int i = 0;
                while (i < steps.size()) {
                    DissertationStep step = (DissertationStep)steps.get(i);
                    this.m_stepCache.put(step.getReference(), step);
                    ++i;
                }
                this.m_stepCache.setComplete();
                this.m_stepCache.processEvents();
            }
        }
        return steps;
    }

    public DissertationStepEdit editDissertationStep(String stepReference) throws IdUnusedException, PermissionException, InUseException {
        this.unlock("dis.step.upd", stepReference);
        String stepId = this.stepId(stepReference);
        if (this.m_stepCache.get(stepReference) == null && !this.m_stepStorage.check(stepId)) {
            throw new IdUnusedException(stepId);
        }
        DissertationStepEdit step = this.m_stepStorage.edit(stepId);
        if (step == null) {
            throw new InUseException(stepId);
        }
        ((BaseDissertationStepEdit)step).setEvent("dis.step.upd");
        return step;
    }

    public void commitEdit(DissertationStepEdit step) {
        if (!step.isActiveEdit()) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                Log.warn("chef", this + ".commitEdit(): closed DissertationStepEdit", (Throwable)e);
                return;
            }
        }
        this.addLiveUpdateProperties(step.getPropertiesEdit());
        this.m_stepStorage.commit(step);
        EventTrackingService.post(EventTrackingService.newEvent(((BaseDissertationStepEdit)step).getEvent(), step.getReference(), true));
        ((BaseDissertationStepEdit)step).closeEdit();
    }

    public void cancelEdit(DissertationStepEdit step) {
        if (!step.isActiveEdit()) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                Log.warn("chef", this + ".cancelEdit(): closed DissertationStepEdit", (Throwable)e);
                return;
            }
        }
        this.m_stepStorage.cancel(step);
        ((BaseDissertationStepEdit)step).closeEdit();
    }

    public void removeDissertationStep(DissertationStepEdit step) throws PermissionException {
        if (step != null) {
            if (!step.isActiveEdit()) {
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    Log.warn("chef", this + ".removeDissertationStep(): closed DissertationStepEdit", (Throwable)e);
                    return;
                }
            }
            this.unlock("dis.step.del", step.getReference());
            this.m_stepStorage.remove(step);
            EventTrackingService.post(EventTrackingService.newEvent("dis.step.del", step.getReference(), true));
            ((BaseDissertationStepEdit)step).closeEdit();
        }
    }

    public CandidatePathEdit addCandidatePath(Dissertation dissertation, String site) throws PermissionException {
        String pathId = null;
        boolean badId = false;
        do {
            badId = false;
            pathId = IdService.getUniqueId();
            try {
                Validator.checkResourceId(pathId);
            }
            catch (IdInvalidException iie) {
                badId = true;
            }
            if (!this.m_pathStorage.check(pathId)) continue;
            badId = true;
        } while (badId);
        String key = this.pathReference(site, pathId);
        this.unlock("dis.path.add", key);
        CandidatePathEdit path = this.m_pathStorage.put(pathId, site);
        dissertation.initializeCandidatePath(path, site);
        EventTrackingService.post(EventTrackingService.newEvent("dis.path.add", key, true));
        return path;
    }

    protected CandidatePathEdit addCandidatePathFromListener(Dissertation dissertation, String site) {
        String pathId = null;
        boolean badId = false;
        do {
            badId = false;
            pathId = IdService.getUniqueId();
            try {
                Validator.checkResourceId(pathId);
            }
            catch (IdInvalidException iie) {
                badId = true;
            }
            if (!this.m_pathStorage.check(pathId)) continue;
            badId = true;
        } while (badId);
        String key = this.pathReference(site, pathId);
        CandidatePathEdit path = this.m_pathStorage.put(pathId, site);
        dissertation.initializeCandidatePath(path, site);
        EventTrackingService.post(EventTrackingService.newEvent("dis.path.add", key, true));
        return path;
    }

    public CandidatePathEdit mergeCandidatePath(Element el) throws IdInvalidException, IdUsedException, PermissionException {
        BaseCandidatePath pathFromXml = new BaseCandidatePath(el);
        Validator.checkResourceId(pathFromXml.getId());
        this.unlock("dis.path.add", pathFromXml.getReference());
        CandidatePathEdit path = this.m_pathStorage.put(pathFromXml.getId(), pathFromXml.getSite());
        if (path == null) {
            throw new IdUsedException(pathFromXml.getId());
        }
        ((BaseCandidatePathEdit)path).set(pathFromXml);
        ((BaseCandidatePathEdit)path).setEvent("dis.path.add");
        return path;
    }

    public CandidatePath getCandidatePath(String pathReference) throws IdUnusedException, PermissionException {
        CandidatePath path = null;
        String pathId = this.pathId(pathReference);
        if (this.m_pathCache.containsKey(pathReference)) {
            path = (CandidatePath)this.m_pathCache.get(pathReference);
        } else {
            path = this.m_pathStorage.get(pathId);
            this.m_pathCache.put(pathReference, path);
        }
        if (path == null) {
            throw new IdUnusedException(pathId);
        }
        this.unlock("dis.path.read", pathReference);
        EventTrackingService.post(EventTrackingService.newEvent("dis.path.read", path.getReference(), false));
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getCandidatePaths() {
        List paths = new Vector();
        if (this.m_pathCache.disabled()) {
            paths = this.m_pathStorage.getAll();
        } else if (this.m_pathCache.isComplete()) {
            paths = this.m_pathCache.getAll();
        } else {
            Cache cache = this.m_pathCache;
            synchronized (cache) {
                block9: {
                    if (!this.m_pathCache.isComplete()) break block9;
                    paths = this.m_pathCache.getAll();
                    List list = paths;
                    return list;
                }
                this.m_pathCache.holdEvents();
                paths = this.m_pathStorage.getAll();
                int i = 0;
                while (i < paths.size()) {
                    CandidatePath path = (CandidatePath)paths.get(i);
                    this.m_pathCache.put(path.getReference(), path);
                    ++i;
                }
                this.m_pathCache.setComplete();
                this.m_pathCache.processEvents();
            }
        }
        return paths;
    }

    public CandidatePathEdit editCandidatePath(String pathReference) throws IdUnusedException, PermissionException, InUseException {
        this.unlock("dis.path.upd", pathReference);
        String pathId = this.pathId(pathReference);
        if (this.m_pathCache.get(pathReference) == null && !this.m_pathStorage.check(pathId)) {
            throw new IdUnusedException(pathId);
        }
        CandidatePathEdit path = this.m_pathStorage.edit(pathId);
        if (path == null) {
            throw new InUseException(pathId);
        }
        ((BaseCandidatePathEdit)path).setEvent("dis.path.upd");
        return path;
    }

    public void commitEdit(CandidatePathEdit path) {
        if (!path.isActiveEdit()) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                Log.warn("chef", this + ".commitEdit(): closed CandidatePathEdit", (Throwable)e);
                return;
            }
        }
        this.addLiveUpdateProperties(path.getPropertiesEdit());
        this.m_pathStorage.commit(path);
        EventTrackingService.post(EventTrackingService.newEvent(((BaseCandidatePathEdit)path).getEvent(), path.getReference(), true));
        ((BaseCandidatePathEdit)path).closeEdit();
    }

    public void cancelEdit(CandidatePathEdit path) {
        if (!path.isActiveEdit()) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                Log.warn("chef", this + ".cancelEdit(): closed CandidatePathEdit", (Throwable)e);
                return;
            }
        }
        this.m_pathStorage.cancel(path);
        ((BaseCandidatePathEdit)path).closeEdit();
    }

    public void removeCandidatePath(CandidatePathEdit path) throws PermissionException {
        if (path != null) {
            if (!path.isActiveEdit()) {
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    Log.warn("chef", this + ".removeCandidatePath(): closed CandidatePathEdit", (Throwable)e);
                    return;
                }
            }
            this.unlock("dis.path.del", path.getReference());
            this.m_pathStorage.remove(path);
            EventTrackingService.post(EventTrackingService.newEvent("dis.path.del", path.getReference(), true));
            ((BaseCandidatePathEdit)path).closeEdit();
        }
    }

    public StepStatusEdit addStepStatus(String site, DissertationStep step, boolean oardStep) throws PermissionException {
        String statusId = null;
        boolean badId = false;
        do {
            badId = false;
            statusId = IdService.getUniqueId();
            try {
                Validator.checkResourceId(statusId);
            }
            catch (IdInvalidException iie) {
                badId = true;
            }
            if (!this.m_statusStorage.check(statusId)) continue;
            badId = true;
        } while (badId);
        String key = this.statusReference(site, statusId);
        this.unlock("dis.status.add", key);
        StepStatusEdit status = this.m_statusStorage.put(statusId, site);
        status.initialize(site, step, oardStep);
        EventTrackingService.post(EventTrackingService.newEvent("dis.status.add", key, true));
        return status;
    }

    protected StepStatusEdit addStepStatusFromListener(String site, DissertationStep step, boolean oardStep) {
        String statusId = null;
        boolean badId = false;
        do {
            badId = false;
            statusId = IdService.getUniqueId();
            try {
                Validator.checkResourceId(statusId);
            }
            catch (IdInvalidException iie) {
                badId = true;
            }
            if (!this.m_statusStorage.check(statusId)) continue;
            badId = true;
        } while (badId);
        String key = this.statusReference(site, statusId);
        StepStatusEdit status = this.m_statusStorage.put(statusId, site);
        status.initialize(site, step, oardStep);
        EventTrackingService.post(EventTrackingService.newEvent("dis.status.add", key, true));
        return status;
    }

    public StepStatusEdit addStepStatus(String site) throws PermissionException {
        String statusId = null;
        boolean badId = false;
        do {
            badId = false;
            statusId = IdService.getUniqueId();
            try {
                Validator.checkResourceId(statusId);
            }
            catch (IdInvalidException iie) {
                badId = true;
            }
            if (!this.m_statusStorage.check(statusId)) continue;
            badId = true;
        } while (badId);
        String key = this.statusReference(site, statusId);
        this.unlock("dis.status.add", key);
        StepStatusEdit status = this.m_statusStorage.put(statusId, site);
        status.setSite(site);
        EventTrackingService.post(EventTrackingService.newEvent("dis.status.add", key, true));
        return status;
    }

    public StepStatusEdit mergeStepStatus(Element el) throws IdInvalidException, IdUsedException, PermissionException {
        BaseStepStatus statusFromXml = new BaseStepStatus(el);
        Validator.checkResourceId(statusFromXml.getId());
        this.unlock("dis.status.add", statusFromXml.getReference());
        StepStatusEdit status = this.m_statusStorage.put(statusFromXml.getId(), statusFromXml.getSite());
        if (status == null) {
            throw new IdUsedException(statusFromXml.getId());
        }
        ((BaseStepStatusEdit)status).set(statusFromXml);
        ((BaseStepStatusEdit)status).setEvent("dis.status.add");
        return status;
    }

    public StepStatus getStepStatus(String statusReference) throws IdUnusedException, PermissionException {
        StepStatus status = null;
        String statusId = this.statusId(statusReference);
        if (this.m_statusCache.containsKey(statusReference)) {
            status = (StepStatus)this.m_statusCache.get(statusReference);
        } else {
            status = this.m_statusStorage.get(statusId);
            this.m_statusCache.put(statusReference, status);
        }
        if (status == null) {
            throw new IdUnusedException(statusId);
        }
        this.unlock("dis.status.read", statusReference);
        EventTrackingService.post(EventTrackingService.newEvent("dis.status.read", status.getReference(), false));
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getStepStatus() {
        List statusi = new Vector();
        if (this.m_statusCache.disabled()) {
            statusi = this.m_statusStorage.getAll();
        } else if (this.m_statusCache.isComplete()) {
            statusi = this.m_statusCache.getAll();
        } else {
            Cache cache = this.m_statusCache;
            synchronized (cache) {
                block9: {
                    if (!this.m_statusCache.isComplete()) break block9;
                    statusi = this.m_statusCache.getAll();
                    List list = statusi;
                    return list;
                }
                this.m_statusCache.holdEvents();
                statusi = this.m_statusStorage.getAll();
                int i = 0;
                while (i < statusi.size()) {
                    StepStatus status = (StepStatus)statusi.get(i);
                    this.m_statusCache.put(status.getReference(), status);
                    ++i;
                }
                this.m_statusCache.setComplete();
                this.m_statusCache.processEvents();
            }
        }
        return statusi;
    }

    public StepStatusEdit editStepStatus(String statusReference) throws IdUnusedException, PermissionException, InUseException {
        this.unlock("dis.status.upd", statusReference);
        String statusId = this.statusId(statusReference);
        if (this.m_statusCache.get(statusReference) == null && !this.m_statusStorage.check(statusId)) {
            throw new IdUnusedException(statusId);
        }
        StepStatusEdit status = this.m_statusStorage.edit(statusId);
        if (status == null) {
            throw new InUseException(statusId);
        }
        ((BaseStepStatusEdit)status).setEvent("dis.status.upd");
        return status;
    }

    protected StepStatusEdit editStepStatusFromListener(String statusReference) throws IdUnusedException, InUseException {
        String statusId = this.statusId(statusReference);
        if (this.m_statusCache.get(statusReference) == null && !this.m_statusStorage.check(statusId)) {
            throw new IdUnusedException(statusId);
        }
        StepStatusEdit status = this.m_statusStorage.edit(statusId);
        if (status == null) {
            throw new InUseException(statusId);
        }
        ((BaseStepStatusEdit)status).setEvent("dis.status.upd");
        return status;
    }

    public void commitEdit(StepStatusEdit status) {
        if (!status.isActiveEdit()) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                Log.warn("chef", this + ".commitEdit(): closed StepStatusEdit", (Throwable)e);
                return;
            }
        }
        this.addLiveUpdateProperties(status.getPropertiesEdit());
        this.m_statusStorage.commit(status);
        EventTrackingService.post(EventTrackingService.newEvent(((BaseStepStatusEdit)status).getEvent(), status.getReference(), true));
        ((BaseStepStatusEdit)status).closeEdit();
    }

    public void cancelEdit(StepStatusEdit status) {
        if (!status.isActiveEdit()) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                Log.warn("chef", this + ".cancelEdit(): closed StepStatusEdit", (Throwable)e);
                return;
            }
        }
        this.m_statusStorage.cancel(status);
        ((BaseStepStatusEdit)status).closeEdit();
    }

    public void removeStepStatus(StepStatusEdit status) throws PermissionException {
        if (status != null) {
            if (!status.isActiveEdit()) {
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    Log.warn("chef", this + ".removeStepStatus(): closed StepStatusEdit", (Throwable)e);
                    return;
                }
            }
            this.unlock("dis.status.del", status.getReference());
            this.m_statusStorage.remove(status);
            EventTrackingService.post(EventTrackingService.newEvent("dis.status.del", status.getReference(), true));
            ((BaseStepStatusEdit)status).closeEdit();
        }
    }

    public CandidateInfoEdit addCandidateInfo(String site) throws PermissionException {
        String infoId = null;
        boolean badId = false;
        do {
            badId = false;
            infoId = IdService.getUniqueId();
            try {
                Validator.checkResourceId(infoId);
            }
            catch (IdInvalidException iie) {
                badId = true;
            }
            if (!this.m_infoStorage.check(infoId)) continue;
            badId = true;
        } while (badId);
        String key = this.infoReference(site, infoId);
        this.unlock("dis.info.add", key);
        CandidateInfoEdit info = this.m_infoStorage.put(infoId, site);
        info.setSite(site);
        try {
            EventTrackingService.post(EventTrackingService.newEvent("dis.info.add", key, true));
        }
        catch (Exception e) {
            Log.warn("chef", "DISSERTATION : BASE SERVICE : ADD CANDIDATE INFO : EXCEPTION TRACKING EVENT : " + e);
        }
        return info;
    }

    public CandidateInfoEdit addCandidateInfoFromListener(String site) {
        String infoId = null;
        boolean badId = false;
        do {
            badId = false;
            infoId = IdService.getUniqueId();
            try {
                Validator.checkResourceId(infoId);
            }
            catch (IdInvalidException iie) {
                badId = true;
            }
            if (!this.m_infoStorage.check(infoId)) continue;
            badId = true;
        } while (badId);
        String key = this.infoReference(site, infoId);
        CandidateInfoEdit info = this.m_infoStorage.put(infoId, site);
        info.setSite(site);
        EventTrackingService.post(EventTrackingService.newEvent("dis.info.add", key, true));
        return info;
    }

    public CandidateInfoEdit mergeCandidateInfo(Element el) throws IdInvalidException, IdUsedException, PermissionException {
        BaseCandidateInfo infoFromXml = new BaseCandidateInfo(el);
        Validator.checkResourceId(infoFromXml.getId());
        this.unlock("dis.info.add", infoFromXml.getReference());
        CandidateInfoEdit info = this.m_infoStorage.put(infoFromXml.getId(), infoFromXml.getSite());
        if (info == null) {
            throw new IdUsedException(infoFromXml.getId());
        }
        ((BaseCandidateInfoEdit)info).set(infoFromXml);
        ((BaseCandidateInfoEdit)info).setEvent("dis.info.add");
        return info;
    }

    public CandidateInfo getCandidateInfo(String infoReference) throws IdUnusedException, PermissionException {
        CandidateInfo info = null;
        String infoId = this.infoId(infoReference);
        if (this.m_infoCache.containsKey(infoReference)) {
            info = (CandidateInfo)this.m_infoCache.get(infoReference);
        } else {
            info = this.m_infoStorage.get(infoId);
            this.m_infoCache.put(infoReference, info);
        }
        if (info == null) {
            throw new IdUnusedException(infoId);
        }
        this.unlock("dis.info.read", infoReference);
        EventTrackingService.post(EventTrackingService.newEvent("dis.info.read", info.getReference(), false));
        return info;
    }

    public CandidateInfoEdit getCandidateInfoEditForEmplid(String emplid) throws PermissionException {
        Resource retVal = null;
        if (emplid != null) {
            CandidateInfo tempInfo = null;
            List allInfos = this.getCandidateInfos();
            int x = 0;
            while (x < allInfos.size()) {
                try {
                    tempInfo = (CandidateInfo)allInfos.get(x);
                    if (tempInfo.getEmplid().equals(emplid)) {
                        retVal = this.m_infoStorage.edit(tempInfo.getId());
                    }
                }
                catch (Exception e) {
                    Log.warn("chef", "DISSERTATION : BASE SERVICE : GET INFO EDIT FOR EMPLID : EXCEPTION " + e);
                }
                ++x;
            }
            if (retVal != null) {
                EventTrackingService.post(EventTrackingService.newEvent("dis.info.upd", retVal.getReference(), false));
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getCandidateInfos() {
        List infos = new Vector();
        if (this.m_infoCache.disabled()) {
            infos = this.m_infoStorage.getAll();
        } else if (this.m_infoCache.isComplete()) {
            infos = this.m_infoCache.getAll();
        } else {
            Cache cache = this.m_infoCache;
            synchronized (cache) {
                block9: {
                    if (!this.m_infoCache.isComplete()) break block9;
                    infos = this.m_infoCache.getAll();
                    List list = infos;
                    return list;
                }
                this.m_infoCache.holdEvents();
                infos = this.m_infoStorage.getAll();
                int i = 0;
                while (i < infos.size()) {
                    CandidateInfo info = (CandidateInfo)infos.get(i);
                    this.m_infoCache.put(info.getReference(), info);
                    ++i;
                }
                this.m_infoCache.setComplete();
                this.m_infoCache.processEvents();
            }
        }
        return infos;
    }

    public CandidateInfoEdit editCandidateInfo(String infoReference) throws IdUnusedException, PermissionException, InUseException {
        this.unlock("dis.info.upd", infoReference);
        String infoId = this.infoId(infoReference);
        if (this.m_infoCache.get(infoReference) == null && !this.m_infoStorage.check(infoId)) {
            throw new IdUnusedException(infoId);
        }
        CandidateInfoEdit info = this.m_infoStorage.edit(infoId);
        if (info == null) {
            throw new InUseException(infoId);
        }
        ((BaseCandidateInfoEdit)info).setEvent("dis.info.upd");
        return info;
    }

    public void commitEdit(CandidateInfoEdit info) {
        if (!info.isActiveEdit()) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                Log.warn("chef", this + ".commitEdit(): closed CandidateInfoEdit", (Throwable)e);
                return;
            }
        }
        this.addLiveUpdateProperties(info.getPropertiesEdit());
        this.m_infoStorage.commit(info);
        EventTrackingService.post(EventTrackingService.newEvent(((BaseCandidateInfoEdit)info).getEvent(), info.getReference(), true));
        ((BaseCandidateInfoEdit)info).closeEdit();
    }

    public void cancelEdit(CandidateInfoEdit info) {
        if (!info.isActiveEdit()) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                Log.warn("chef", this + ".cancelEdit(): closed CandidateInfoEdit", (Throwable)e);
                return;
            }
        }
        this.m_infoStorage.cancel(info);
        ((BaseCandidateInfoEdit)info).closeEdit();
    }

    public void removeCandidateInfo(CandidateInfoEdit info) throws PermissionException {
        if (info != null) {
            if (!info.isActiveEdit()) {
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    Log.warn("chef", this + ".removeCandidateInfo(): closed CandidateInfoEdit", (Throwable)e);
                    return;
                }
            }
            this.unlock("dis.info.del", info.getReference());
            this.m_infoStorage.remove(info);
            EventTrackingService.post(EventTrackingService.newEvent("dis.info.del", info.getReference(), true));
            ((BaseCandidateInfoEdit)info).closeEdit();
        }
    }

    public List getDissertationStepsForSite(String site) throws IdUnusedException, PermissionException {
        ArrayList<DissertationStep> retVal = new ArrayList<DissertationStep>();
        DissertationStep tempStep = null;
        if (site != null) {
            List allSteps = this.getDissertationSteps();
            int x = 0;
            while (x < allSteps.size()) {
                tempStep = (DissertationStep)allSteps.get(x);
                if (tempStep.getSite().equals(site)) {
                    retVal.add(tempStep);
                }
                ++x;
            }
        }
        return retVal;
    }

    public List getCandidatePathsForParentSite(String site) {
        ArrayList<CandidatePath> retVal = new ArrayList<CandidatePath>();
        if (site != null) {
            CandidatePath cp = null;
            List allPaths = this.getCandidatePaths();
            int x = 0;
            while (x < allPaths.size()) {
                cp = (CandidatePath)allPaths.get(x);
                if (site.equals(this.getParentSiteForUser(cp.getCandidate()))) {
                    retVal.add(cp);
                }
                ++x;
            }
        }
        return retVal;
    }

    public CandidatePath getCandidatePathForCandidate(String candidateId) throws PermissionException {
        CandidatePath retVal = null;
        CandidatePath tempPath = null;
        if (candidateId != null) {
            List allPaths = this.getCandidatePaths();
            int x = 0;
            while (x < allPaths.size()) {
                tempPath = (CandidatePath)allPaths.get(x);
                if (candidateId.equals(tempPath.getCandidate())) {
                    retVal = tempPath;
                }
                ++x;
            }
        }
        return retVal;
    }

    public Dissertation getDissertationForSite(String site) throws IdUnusedException, PermissionException {
        Dissertation retVal = null;
        Dissertation tempDiss = null;
        if (site != null) {
            try {
                List allDissertations = this.getDissertations();
                int x = 0;
                while (x < allDissertations.size()) {
                    tempDiss = (Dissertation)allDissertations.get(x);
                    if (site.equals(tempDiss.getSite())) {
                        retVal = tempDiss;
                    }
                    ++x;
                }
            }
            catch (Exception e) {
                Log.warn("chef", "DISSERTATION : BASE SERVICE : GET DISSERTATION FOR SITE : EXCEPTION : " + e);
            }
        }
        return retVal;
    }

    public boolean getActivePaths() {
        boolean retVal = false;
        List keys = this.m_pathCache.getKeys();
        if (keys.size() > 0) {
            retVal = true;
        } else {
            List paths = this.m_pathStorage.getAll();
            if (paths.size() > 0) {
                retVal = true;
            }
        }
        return retVal;
    }

    public boolean getActivePathsForSite(String site) {
        if (site != null) {
            CandidateInfo info = null;
            CandidatePath path = null;
            String candidateId = null;
            List allPaths = this.getCandidatePaths();
            int x = 0;
            while (x < allPaths.size()) {
                path = (CandidatePath)allPaths.get(x);
                candidateId = path.getCandidate();
                info = this.getCandidateInfoForCandidate(candidateId);
                if (site.equals(info.getParentSiteId())) {
                    return true;
                }
                ++x;
            }
        }
        return false;
    }

    protected CandidateInfo getCandidateInfoForCandidate(String id) {
        CandidateInfo retVal = null;
        if (id != null) {
            Object candidateId = null;
            CandidateInfo info = null;
            List allInfos = this.getCandidateInfos();
            int x = 0;
            while (x < allInfos.size()) {
                info = (CandidateInfo)allInfos.get(x);
                if (id.equals(info.getChefId())) {
                    retVal = info;
                }
                ++x;
            }
        }
        return retVal;
    }

    public String getSchoolSite() {
        return this.m_schoolSite;
    }

    protected String getReferenceRoot() {
        return "/dissertation";
    }

    protected void addLiveUpdateProperties(ResourcePropertiesEdit props) {
        props.addProperty("CHEF:modifiedby", UsageSessionService.getSessionUser().getId());
        props.addProperty("DAV:getlastmodified", new Time().toString());
    }

    protected void addLiveProperties(ResourcePropertiesEdit props) {
        String current = UsageSessionService.getSessionUser().getId();
        props.addProperty("CHEF:creator", current);
        props.addProperty("CHEF:modifiedby", current);
        String now = new Time().toString();
        props.addProperty("DAV:creationdate", now);
        props.addProperty("DAV:getlastmodified", now);
    }

    public boolean allowAddDissertation(String site) {
        String resourceString = this.dissertationReference(site, "");
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Entering allow add Dissertation with resource string : " + resourceString);
        }
        return this.unlockCheck("dis.dis.add", resourceString);
    }

    public boolean allowGetDissertation(String dissertationReference) {
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Entering allow get Dissertation with resource string : " + dissertationReference);
        }
        return this.unlockCheck("dis.dis.read", dissertationReference);
    }

    public boolean allowUpdateDissertation(String dissertationReference) {
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Entering allow update Dissertation with resource string : " + dissertationReference);
        }
        return this.unlockCheck("dis.dis.upd", dissertationReference);
    }

    public boolean allowRemoveDissertation(String dissertationReference) {
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Entering allow remove Dissertation with resource string : " + dissertationReference);
        }
        return this.unlockCheck("dis.dis.del", dissertationReference);
    }

    public boolean allowAddCandidatePath(String site) {
        String resourceString = this.pathReference(site, "");
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Entering allow add CandidatePath with resource string : " + resourceString);
        }
        return this.unlockCheck("dis.path.add", resourceString);
    }

    public boolean allowGetCandidatePath(String pathReference) {
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Entering allow get CandidatePath with resource string : " + pathReference);
        }
        return this.unlockCheck("dis.path.read", pathReference);
    }

    public boolean allowUpdateCandidatePath(String pathReference) {
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Entering allow update CandidatePath with resource string : " + pathReference);
        }
        return this.unlockCheck("dis.path.upd", pathReference);
    }

    public boolean allowUpdateCandidatePathComm(String pathReference) {
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Entering allow update CandidatePathComm with resource string : " + pathReference);
        }
        return this.unlockCheck("dis.path.upd.comm", pathReference);
    }

    public boolean allowRemoveCandidatePath(String pathReference) {
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Entering allow remove CandidatePath with resource string : " + pathReference);
        }
        return this.unlockCheck("dis.path.del", pathReference);
    }

    public boolean allowGetDissertationStep(String stepReference) {
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Entering allow get DissertationStep with resource string : " + stepReference);
        }
        return this.unlockCheck("dis.step.read", stepReference);
    }

    public boolean allowUpdateDissertationStep(String stepReference) {
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Entering allow update DissertationStep with resource string : " + stepReference);
        }
        return this.unlockCheck("dis.step.upd", stepReference);
    }

    public boolean allowAddDissertationStep(String site) {
        String resourceString = this.stepReference(site, "");
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Entering allow add DissertationStep with resource string : " + resourceString);
            Log.debug("chef", "                                           site string : " + site);
        }
        return this.unlockCheck("dis.step.add", resourceString);
    }

    public boolean allowRemoveDissertationStep(String stepReference) {
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Entering allow remove dissertation step with resource string : " + stepReference);
        }
        return this.unlockCheck("dis.step.del", stepReference);
    }

    public boolean allowGetStepStatus(String statusReference) {
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Entering allow get StepStatus with resource string : " + statusReference);
        }
        return this.unlockCheck("dis.step.read", statusReference);
    }

    public boolean allowUpdateStepStatus(String statusReference) {
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Entering allow update StepStatus with resource string : " + statusReference);
        }
        return this.unlockCheck("dis.step.upd", statusReference);
    }

    public boolean allowAddStepStatus(String site) {
        String resourceString = this.statusReference(site, "");
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Entering allow add StepStatus with resource string : " + resourceString);
        }
        return this.unlockCheck("dis.step.add", resourceString);
    }

    public boolean allowRemoveStepStatus(String statusReference) {
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Entering allow remove dissertation step with resource string : " + statusReference);
        }
        return this.unlockCheck("dis.step.del", statusReference);
    }

    public boolean allowAddCandidateInfo(String site) {
        String resourceString = this.infoReference(site, "");
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Entering allow add CandidateInfo with resource string : " + resourceString);
        }
        return this.unlockCheck("dis.info.add", resourceString);
    }

    public boolean allowGetCandidateInfo(String infoReference) {
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Entering allow get CandidateInfo with resource string : " + infoReference);
        }
        return this.unlockCheck("dis.info.read", infoReference);
    }

    public boolean allowUpdateCandidateInfo(String infoReference) {
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Entering allow update CandidateInfo with resource string : " + infoReference);
        }
        return this.unlockCheck("dis.info.upd", infoReference);
    }

    public boolean allowRemoveCandidateInfo(String infoReference) {
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", "Entering allow remove CandidateInfo with resource string : " + infoReference);
        }
        return this.unlockCheck("dis.info.del", infoReference);
    }

    protected String getTimeString(Time t) {
        String retVal = "";
        if (t != null) {
            retVal = String.valueOf(t.getTime());
        }
        return retVal;
    }

    protected String getBoolString(boolean b) {
        if (b) {
            return "true";
        }
        return "false";
    }

    protected String getUserId(User u) {
        String retVal = "";
        if (u != null) {
            retVal = u.getId();
        }
        return retVal;
    }

    protected boolean getBool(String s) {
        boolean retVal = false;
        if (s != null && s.equalsIgnoreCase("true")) {
            retVal = true;
        }
        return retVal;
    }

    protected User getUserObject(String id) {
        User retVal = null;
        if (id != "") {
            try {
                retVal = UserDirectoryService.getUser(id);
            }
            catch (IdUnusedException iue) {
                Log.warn("chef", this + " Exception getting user from user dir service with id : " + id + " : " + iue);
            }
        }
        return retVal;
    }

    protected Time getTimeObject(String timeString) {
        Time aTime = null;
        if (timeString != "") {
            try {
                long longTime = Long.parseLong(timeString);
                aTime = new Time(longTime);
            }
            catch (Exception e) {
                Log.warn("chef", this + " Exception creating time object from xml file : " + e);
            }
        }
        return aTime;
    }

    protected class CandidateInfoCacheRefresher
    implements CacheRefresher {
        protected CandidateInfoCacheRefresher() {
        }

        public Object refresh(Object key, Object oldValue, Event event) {
            String id = BaseDissertationService.this.infoId((String)key);
            CandidateInfo info = BaseDissertationService.this.m_infoStorage.get(id);
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", this + ".refresh(): " + key + " : " + id);
            }
            return info;
        }
    }

    protected class StepStatusCacheRefresher
    implements CacheRefresher {
        protected StepStatusCacheRefresher() {
        }

        public Object refresh(Object key, Object oldValue, Event event) {
            String id = BaseDissertationService.this.statusId((String)key);
            StepStatus status = BaseDissertationService.this.m_statusStorage.get(id);
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", this + ".refresh(): " + key + " : " + id);
            }
            return status;
        }
    }

    protected class CandidatePathCacheRefresher
    implements CacheRefresher {
        protected CandidatePathCacheRefresher() {
        }

        public Object refresh(Object key, Object oldValue, Event event) {
            String id = BaseDissertationService.this.pathId((String)key);
            CandidatePath path = BaseDissertationService.this.m_pathStorage.get(id);
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", this + ".refresh(): " + key + " : " + id);
            }
            return path;
        }
    }

    protected class DissertationStepCacheRefresher
    implements CacheRefresher {
        protected DissertationStepCacheRefresher() {
        }

        public Object refresh(Object key, Object oldValue, Event event) {
            String id = BaseDissertationService.this.stepId((String)key);
            DissertationStep step = BaseDissertationService.this.m_stepStorage.get(id);
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", this + ".refresh(): " + key + " : " + id);
            }
            return step;
        }
    }

    protected class DissertationCacheRefresher
    implements CacheRefresher {
        protected DissertationCacheRefresher() {
        }

        public Object refresh(Object key, Object oldValue, Event event) {
            String id = BaseDissertationService.this.dissertationId((String)key);
            Dissertation dissertation = BaseDissertationService.this.m_dissertationStorage.get(id);
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", this + ".refresh(): " + key + " : " + id);
            }
            return dissertation;
        }
    }

    protected class CandidateInfoStorageUser
    implements StorageUser {
        protected CandidateInfoStorageUser() {
        }

        public Resource newContainer(String ref) {
            return null;
        }

        public Resource newContainer(Element element) {
            return null;
        }

        public Resource newContainer(Resource other) {
            return null;
        }

        public Resource newResource(Resource container, String id, Object[] others) {
            return new BaseCandidateInfo(id, (String)others[0]);
        }

        public Resource newResource(Resource container, Element element) {
            return new BaseCandidateInfo(element);
        }

        public Resource newResource(Resource container, Resource other) {
            return new BaseCandidateInfo((CandidateInfo)other);
        }

        public Edit newContainerEdit(String ref) {
            return null;
        }

        public Edit newContainerEdit(Element element) {
            return null;
        }

        public Edit newContainerEdit(Resource other) {
            return null;
        }

        public Edit newResourceEdit(Resource container, String id, Object[] others) {
            BaseCandidateInfoEdit e = new BaseCandidateInfoEdit(id, (String)others[0]);
            e.activate();
            return e;
        }

        public Edit newResourceEdit(Resource container, Element element) {
            BaseCandidateInfoEdit e = new BaseCandidateInfoEdit(element);
            e.activate();
            return e;
        }

        public Edit newResourceEdit(Resource container, Resource other) {
            BaseCandidateInfoEdit e = new BaseCandidateInfoEdit((CandidateInfo)other);
            e.activate();
            return e;
        }

        public Object[] storageFields(Resource r) {
            return null;
        }
    }

    protected class StepStatusStorageUser
    implements StorageUser {
        protected StepStatusStorageUser() {
        }

        public Resource newContainer(String ref) {
            return null;
        }

        public Resource newContainer(Element element) {
            return null;
        }

        public Resource newContainer(Resource other) {
            return null;
        }

        public Resource newResource(Resource container, String id, Object[] others) {
            return new BaseStepStatus(id, (String)others[0]);
        }

        public Resource newResource(Resource container, Element element) {
            return new BaseStepStatus(element);
        }

        public Resource newResource(Resource container, Resource other) {
            return new BaseStepStatus((StepStatus)other);
        }

        public Edit newContainerEdit(String ref) {
            return null;
        }

        public Edit newContainerEdit(Element element) {
            return null;
        }

        public Edit newContainerEdit(Resource other) {
            return null;
        }

        public Edit newResourceEdit(Resource container, String id, Object[] others) {
            BaseStepStatusEdit e = new BaseStepStatusEdit(id, (String)others[0]);
            e.activate();
            return e;
        }

        public Edit newResourceEdit(Resource container, Element element) {
            BaseStepStatusEdit e = new BaseStepStatusEdit(element);
            e.activate();
            return e;
        }

        public Edit newResourceEdit(Resource container, Resource other) {
            BaseStepStatusEdit e = new BaseStepStatusEdit((StepStatus)other);
            e.activate();
            return e;
        }

        public Object[] storageFields(Resource r) {
            return null;
        }
    }

    protected class CandidatePathStorageUser
    implements StorageUser {
        protected CandidatePathStorageUser() {
        }

        public Resource newContainer(String ref) {
            return null;
        }

        public Resource newContainer(Element element) {
            return null;
        }

        public Resource newContainer(Resource other) {
            return null;
        }

        public Resource newResource(Resource container, String id, Object[] others) {
            return new BaseCandidatePath(id, (String)others[0]);
        }

        public Resource newResource(Resource container, Element element) {
            return new BaseCandidatePath(element);
        }

        public Resource newResource(Resource container, Resource other) {
            return new BaseCandidatePath((CandidatePath)other);
        }

        public Edit newContainerEdit(String ref) {
            return null;
        }

        public Edit newContainerEdit(Element element) {
            return null;
        }

        public Edit newContainerEdit(Resource other) {
            return null;
        }

        public Edit newResourceEdit(Resource container, String id, Object[] others) {
            BaseCandidatePathEdit e = new BaseCandidatePathEdit(id, (String)others[0]);
            e.activate();
            return e;
        }

        public Edit newResourceEdit(Resource container, Element element) {
            BaseCandidatePathEdit e = new BaseCandidatePathEdit(element);
            e.activate();
            return e;
        }

        public Edit newResourceEdit(Resource container, Resource other) {
            BaseCandidatePathEdit e = new BaseCandidatePathEdit((CandidatePath)other);
            e.activate();
            return e;
        }

        public Object[] storageFields(Resource r) {
            return null;
        }
    }

    protected class DissertationStepStorageUser
    implements StorageUser {
        protected DissertationStepStorageUser() {
        }

        public Resource newContainer(String ref) {
            return null;
        }

        public Resource newContainer(Element element) {
            return null;
        }

        public Resource newContainer(Resource other) {
            return null;
        }

        public Resource newResource(Resource container, String id, Object[] others) {
            return new BaseDissertationStep(id, (String)others[0]);
        }

        public Resource newResource(Resource container, Element element) {
            return new BaseDissertationStep(element);
        }

        public Resource newResource(Resource container, Resource other) {
            return new BaseDissertationStep((DissertationStep)other);
        }

        public Edit newContainerEdit(String ref) {
            return null;
        }

        public Edit newContainerEdit(Element element) {
            return null;
        }

        public Edit newContainerEdit(Resource other) {
            return null;
        }

        public Edit newResourceEdit(Resource container, String id, Object[] others) {
            BaseDissertationStepEdit e = new BaseDissertationStepEdit(id, (String)others[0]);
            e.activate();
            return e;
        }

        public Edit newResourceEdit(Resource container, Element element) {
            BaseDissertationStepEdit e = new BaseDissertationStepEdit(element);
            e.activate();
            return e;
        }

        public Edit newResourceEdit(Resource container, Resource other) {
            BaseDissertationStepEdit e = new BaseDissertationStepEdit((DissertationStep)other);
            e.activate();
            return e;
        }

        public Object[] storageFields(Resource r) {
            return null;
        }
    }

    protected class DissertationStorageUser
    implements StorageUser {
        protected DissertationStorageUser() {
        }

        public Resource newContainer(String ref) {
            return null;
        }

        public Resource newContainer(Element element) {
            return null;
        }

        public Resource newContainer(Resource other) {
            return null;
        }

        public Resource newResource(Resource container, String id, Object[] others) {
            return new BaseDissertation(id, (String)others[0]);
        }

        public Resource newResource(Resource container, Element element) {
            return new BaseDissertation(element);
        }

        public Resource newResource(Resource container, Resource other) {
            return new BaseDissertation((Dissertation)other);
        }

        public Edit newContainerEdit(String ref) {
            return null;
        }

        public Edit newContainerEdit(Element element) {
            return null;
        }

        public Edit newContainerEdit(Resource other) {
            return null;
        }

        public Edit newResourceEdit(Resource container, String id, Object[] others) {
            BaseDissertationEdit e = new BaseDissertationEdit(id, (String)others[0]);
            e.activate();
            return e;
        }

        public Edit newResourceEdit(Resource container, Element element) {
            BaseDissertationEdit e = new BaseDissertationEdit(element);
            e.activate();
            return e;
        }

        public Edit newResourceEdit(Resource container, Resource other) {
            BaseDissertationEdit e = new BaseDissertationEdit((Dissertation)other);
            e.activate();
            return e;
        }

        public Object[] storageFields(Resource r) {
            return null;
        }
    }

    protected static interface CandidateInfoStorage {
        public void open();

        public void close();

        public boolean check(String var1);

        public CandidateInfo get(String var1);

        public List getAll();

        public CandidateInfoEdit put(String var1, String var2);

        public CandidateInfoEdit edit(String var1);

        public void commit(CandidateInfoEdit var1);

        public void cancel(CandidateInfoEdit var1);

        public void remove(CandidateInfoEdit var1);
    }

    protected static interface StepStatusStorage {
        public void open();

        public void close();

        public boolean check(String var1);

        public StepStatus get(String var1);

        public List getAll();

        public StepStatusEdit put(String var1, String var2);

        public StepStatusEdit edit(String var1);

        public void commit(StepStatusEdit var1);

        public void cancel(StepStatusEdit var1);

        public void remove(StepStatusEdit var1);
    }

    protected static interface CandidatePathStorage {
        public void open();

        public void close();

        public boolean check(String var1);

        public CandidatePath get(String var1);

        public List getAll();

        public CandidatePathEdit put(String var1, String var2);

        public CandidatePathEdit edit(String var1);

        public void commit(CandidatePathEdit var1);

        public void cancel(CandidatePathEdit var1);

        public void remove(CandidatePathEdit var1);
    }

    protected static interface DissertationStepStorage {
        public void open();

        public void close();

        public boolean check(String var1);

        public DissertationStep get(String var1);

        public List getAll();

        public DissertationStepEdit put(String var1, String var2);

        public DissertationStepEdit edit(String var1);

        public void commit(DissertationStepEdit var1);

        public void cancel(DissertationStepEdit var1);

        public void remove(DissertationStepEdit var1);
    }

    protected static interface DissertationStorage {
        public void open();

        public void close();

        public boolean check(String var1);

        public Dissertation get(String var1);

        public List getAll();

        public DissertationEdit put(String var1, String var2);

        public DissertationEdit edit(String var1);

        public void commit(DissertationEdit var1);

        public void cancel(DissertationEdit var1);

        public void remove(DissertationEdit var1);
    }

    protected class BaseCandidateInfoEdit
    extends BaseCandidateInfo
    implements CandidateInfoEdit,
    SessionStateBindingListener {
        protected String m_event = null;
        protected boolean m_active = false;

        public BaseCandidateInfoEdit(String infoId, String site) {
            super(infoId, site);
        }

        public BaseCandidateInfoEdit(Element el) {
            super(el);
        }

        public BaseCandidateInfoEdit(CandidateInfo info) {
            super(info);
        }

        protected void finalize() {
            if (this.m_active) {
                BaseDissertationService.this.cancelEdit(this);
            }
        }

        public void setEmplid(String emplid) {
            this.m_emplid = emplid;
        }

        public void setChefId(String chefid) {
            this.m_chefId = chefid;
        }

        public void setProgram(String program) {
            this.m_program = program;
        }

        public void setParentSiteId(String parentSiteId) {
            this.m_parentSiteId = parentSiteId;
        }

        public void setSite(String site) {
            this.m_site = site;
        }

        public void setAdvCandDesc(String desc) {
            this.m_advCandDesc = desc;
        }

        public void setMilestone(String milestone) {
            this.m_milestone = milestone;
        }

        public void setTimeMilestoneCompleted(Time completed) {
            this.m_milestoneCompleted = completed;
        }

        public void setTimeCommitteeApproval(Time approval) {
            this.m_committeeApproval = approval;
        }

        public void setTimeOralExam(Time exam) {
            this.m_oralExam = exam;
        }

        public void setOralExamPlace(String place) {
            if (place != null) {
                this.m_oralExamPlace = place;
            }
        }

        public void setTimeFirstFormat(Time format) {
            this.m_firstFormat = format;
        }

        public void addTimeCommitteeEval(Time timeCompleted) {
            this.m_timeCommitteeEval.add(timeCompleted);
        }

        public void setTimeOralReportReturned(Time timeReturned) {
            this.m_oralReportReturned = timeReturned;
        }

        public void setTimeCommitteeCert(Time timeOfCert) {
            this.m_committeeCert = timeOfCert;
        }

        public void setFinalFormatRecorder(String recorder) {
            if (recorder != null) {
                this.m_finalFormatRecorder = recorder;
            }
        }

        public void setTimeBinderReceipt(Time receipt) {
            this.m_binderReceipt = receipt;
        }

        public void setFeeRequirementMet(boolean met) {
            this.m_feeRequirementMet = met;
        }

        public void setTimeReceiptSeen(Time seen) {
            this.m_receiptSeen = seen;
        }

        public void setTimePubFee(Time fee) {
            this.m_pubFee = fee;
        }

        public void setTimeUnbound(Time unbound) {
            this.m_unbound = unbound;
        }

        public void setTimeAbstract(Time abst) {
            this.m_abstract = abst;
        }

        public void setTimeBound(Time bound) {
            this.m_bound = bound;
        }

        public void setTimeDiplomaApp(Time app) {
            this.m_diplomaApp = app;
        }

        public void setTimeContract(Time contract) {
            this.m_contract = contract;
        }

        public void setTimeSurvey(Time survey) {
            this.m_survey = survey;
        }

        public void setTimeDegreeConferred(Time conferred) {
            this.m_degreeConferred = conferred;
        }

        public void setDegreeTermTrans(String trans) {
            if (trans != null) {
                this.m_degreeTermTrans = trans;
            }
        }

        protected void set(CandidateInfo info) {
            this.setAll(info);
        }

        protected String getEvent() {
            return this.m_event;
        }

        protected void setEvent(String event) {
            this.m_event = event;
        }

        public ResourcePropertiesEdit getPropertiesEdit() {
            return this.m_properties;
        }

        protected void activate() {
            this.m_active = true;
        }

        public boolean isActiveEdit() {
            return this.m_active;
        }

        protected void closeEdit() {
            this.m_active = false;
        }

        public void valueBound(String sessionStateKey, String attributeName) {
        }

        public void valueUnbound(String sessionStateKey, String attributeName) {
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", this + ".valueUnbound()");
            }
            if (this.m_active) {
                BaseDissertationService.this.cancelEdit(this);
            }
        }
    }

    protected class BaseCandidateInfo
    implements CandidateInfo {
        public String m_id;
        public String m_emplid;
        public String m_chefId;
        public String m_program;
        public String m_parentSiteId;
        public String m_site;
        public ResourcePropertiesEdit m_properties;
        public String m_advCandDesc;
        public String m_oralExamPlace;
        public String m_finalFormatRecorder;
        public String m_degreeTermTrans;
        public String m_milestone;
        public Time m_milestoneCompleted;
        public Time m_committeeApproval;
        public Time m_oralExam;
        public Time m_firstFormat;
        public Time m_oralReportReturned;
        public Time m_committeeCert;
        public Time m_binderReceipt;
        public Time m_receiptSeen;
        public Time m_pubFee;
        public Time m_unbound;
        public Time m_abstract;
        public Time m_bound;
        public Time m_diplomaApp;
        public Time m_contract;
        public Time m_survey;
        public Time m_degreeConferred;
        public boolean m_feeRequirementMet;
        protected Vector m_timeCommitteeEval;

        public BaseCandidateInfo(String infoId, String site) {
            this.m_id = infoId;
            this.m_site = site;
            this.m_chefId = "";
            this.m_program = "";
            this.m_parentSiteId = "";
            this.m_properties = new BaseResourcePropertiesEdit();
            BaseDissertationService.this.addLiveProperties(this.m_properties);
            this.m_feeRequirementMet = false;
            this.m_timeCommitteeEval = new Vector();
        }

        public BaseCandidateInfo(CandidateInfo info) {
            this.setAll(info);
        }

        public BaseCandidateInfo(Element el) {
            this.m_properties = new BaseResourcePropertiesEdit();
            this.m_id = el.getAttribute("id");
            this.m_emplid = el.getAttribute("emplid");
            this.m_chefId = el.getAttribute("chefid");
            this.m_program = el.getAttribute("program");
            this.m_parentSiteId = el.getAttribute("siteid");
            this.m_site = el.getAttribute("site");
            this.m_timeCommitteeEval = new Vector();
            NodeList children = el.getChildNodes();
            int length = children.getLength();
            int i = 0;
            while (i < length) {
                Element element;
                Node child = children.item(i);
                if (child.getNodeType() == 1 && (element = (Element)child).getTagName().equals("properties")) {
                    this.m_properties = new BaseResourcePropertiesEdit(element);
                }
                ++i;
            }
        }

        protected void setAll(CandidateInfo info) {
            this.m_id = info.getId();
            this.m_emplid = info.getEmplid();
            this.m_chefId = info.getChefId();
            this.m_program = info.getProgram();
            this.m_parentSiteId = info.getParentSiteId();
            this.m_site = info.getSite();
            this.m_timeCommitteeEval = new Vector();
            this.m_properties = new BaseResourcePropertiesEdit();
            this.m_properties.addAll(info.getProperties());
        }

        public Element toXml(Document doc, Stack stack) {
            Element info = doc.createElement("info");
            if (stack.isEmpty()) {
                doc.appendChild(info);
            } else {
                ((Element)stack.peek()).appendChild(info);
            }
            stack.push(info);
            info.setAttribute("id", this.m_id);
            info.setAttribute("chefid", this.m_chefId);
            info.setAttribute("emplid", this.m_emplid);
            info.setAttribute("siteid", this.m_parentSiteId);
            info.setAttribute("program", this.m_program);
            info.setAttribute("site", this.m_site);
            this.m_properties.toXml(doc, stack);
            stack.pop();
            return info;
        }

        public String getId() {
            return this.m_id;
        }

        public String getUrl() {
            return BaseDissertationService.this.getAccessPoint(false) + this.m_id;
        }

        public String getReference() {
            return BaseDissertationService.this.infoReference(this.m_site, this.m_id);
        }

        public ResourceProperties getProperties() {
            return this.m_properties;
        }

        public String getChefId() {
            return this.m_chefId;
        }

        public String getEmplid() {
            return this.m_emplid;
        }

        public String getProgram() {
            return this.m_program;
        }

        public String getParentSiteId() {
            return this.m_parentSiteId;
        }

        public String getSite() {
            return this.m_site;
        }

        public Time getTimeCommitteeEvalCompleted() {
            boolean completed = true;
            Time latestTime = null;
            Time aTime = null;
            int x = 0;
            while (x < this.m_timeCommitteeEval.size()) {
                aTime = (Time)this.m_timeCommitteeEval.get(x);
                if (aTime == null) {
                    completed = false;
                } else {
                    if (latestTime == null) {
                        latestTime = aTime;
                    }
                    if (latestTime.before(aTime)) {
                        latestTime = aTime;
                    }
                }
                ++x;
            }
            if (!completed) {
                latestTime = null;
            }
            return latestTime;
        }

        public boolean getCommitteeEvalCompleted() {
            boolean completed = true;
            Time aTime = null;
            int x = 0;
            while (x < this.m_timeCommitteeEval.size()) {
                aTime = (Time)this.m_timeCommitteeEval.get(x);
                if (aTime == null) {
                    completed = false;
                }
                ++x;
            }
            return completed;
        }

        public Time getExternalValidation(int stepNum) {
            Time retVal = null;
            switch (stepNum) {
                case 1: {
                    if ((!"prelim".equalsIgnoreCase(this.m_milestone) || this.m_milestoneCompleted == null) && !"advcand".equalsIgnoreCase(this.m_milestone)) break;
                    retVal = this.m_milestoneCompleted;
                    break;
                }
                case 2: {
                    if (!"advcand".equalsIgnoreCase(this.m_milestone) || this.m_milestoneCompleted == null || this.m_advCandDesc == null) break;
                    retVal = this.m_milestoneCompleted;
                    break;
                }
                case 3: {
                    retVal = this.m_committeeApproval;
                    break;
                }
                case 4: {
                    if (this.m_oralExam == null || this.m_oralExamPlace == null) break;
                    retVal = this.m_oralExam;
                    break;
                }
                case 5: {
                    retVal = this.m_firstFormat;
                    break;
                }
                case 6: {
                    retVal = this.getTimeCommitteeEvalCompleted();
                    break;
                }
                case 7: {
                    retVal = this.m_oralReportReturned;
                    break;
                }
                case 8: {
                    retVal = this.m_committeeCert;
                    break;
                }
                case 9: {
                    if (this.m_finalFormatRecorder == null) break;
                    retVal = new Time();
                    break;
                }
                case 10: {
                    if (this.m_committeeApproval == null || this.m_binderReceipt == null || !this.m_feeRequirementMet || this.m_receiptSeen == null || this.m_pubFee == null || this.m_oralReportReturned == null || this.m_bound == null || this.m_abstract == null || this.m_diplomaApp == null || this.m_contract == null || this.m_survey == null || this.m_committeeCert == null) break;
                    retVal = this.m_committeeCert;
                    break;
                }
                case 11: {
                    if (this.m_degreeTermTrans == null || this.m_degreeConferred == null) break;
                    retVal = this.m_degreeConferred;
                    break;
                }
                case 12: {
                    retVal = this.m_bound;
                }
            }
            return retVal;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CandidateInfo)) {
                return false;
            }
            return ((CandidateInfo)obj).getId().equals(this.getId());
        }

        public int compareTo(Object obj) {
            if (!(obj instanceof CandidateInfo)) {
                throw new ClassCastException();
            }
            if (obj == this) {
                return 0;
            }
            int compare = this.getChefId().compareTo(((CandidateInfo)obj).getChefId());
            if (compare == 0) {
                compare = this.getId().compareTo(((CandidateInfo)obj).getId());
            }
            return compare;
        }
    }

    public class BaseStepStatusEdit
    extends BaseStepStatus
    implements StepStatusEdit,
    SessionStateBindingListener {
        protected String m_event = null;
        protected boolean m_active = false;

        public BaseStepStatusEdit(String statusId, String site) {
            super(statusId, site);
        }

        public BaseStepStatusEdit(StepStatus status) {
            super(status);
        }

        public BaseStepStatusEdit(Element el) {
            super(el);
        }

        public void initialize(String site, DissertationStep step, boolean oardstep) {
            this.m_validator = "";
            this.m_parentStepReference = step.getReference();
            this.m_validationType = step.getValidationType();
            this.m_instructions = step.getInstructions();
            this.m_site = site;
            this.m_autoValidationId = step.getAutoValidationId();
            this.m_prereqStatus = new FlexStringArray();
            this.m_properties = new BaseResourcePropertiesEdit();
            this.m_completed = false;
            this.m_oardValidated = oardstep;
        }

        protected void finalize() {
            if (this.m_active) {
                BaseDissertationService.this.cancelEdit(this);
            }
        }

        public void setRecommendedDeadline(Time deadline) {
            this.m_recommendedDeadline = deadline;
        }

        public void setHardDeadline(Time hardDeadline) {
            this.m_hardDeadline = hardDeadline;
        }

        public void setTimeCompleted(Time time) {
            this.m_timeCompleted = time;
        }

        public void setValidator(String validator) {
            this.m_validator = validator;
        }

        public void setAutoValidationId(String validId) {
            if (validId != null) {
                this.m_autoValidationId = validId;
            }
        }

        public void setCompleted(boolean completed) {
            this.m_timeCompleted = new Time();
            this.m_completed = completed;
        }

        public void addPrerequisiteStatus(String statusReference) {
            if (statusReference != null) {
                this.m_prereqStatus.add(statusReference);
            }
        }

        public void removePrerequisiteStatus(String statusReference) {
            if (statusReference != null) {
                this.m_prereqStatus.remove(statusReference);
            }
        }

        public void setPrereqs(FlexStringArray prereqs) {
            if (prereqs != null) {
                this.m_prereqStatus = prereqs;
            }
        }

        public void setValidationType(String type) {
            this.m_validationType = type;
        }

        public void setInstructions(String instructions) {
            if (instructions != null) {
                this.m_instructions = Validator.escapeHtml(instructions);
            }
        }

        public void setSite(String site) {
            this.m_site = site;
        }

        protected void set(StepStatus status) {
            this.setAll(status);
        }

        protected String getEvent() {
            return this.m_event;
        }

        protected void setEvent(String event) {
            this.m_event = event;
        }

        public ResourcePropertiesEdit getPropertiesEdit() {
            return this.m_properties;
        }

        protected void activate() {
            this.m_active = true;
        }

        public boolean isActiveEdit() {
            return this.m_active;
        }

        protected void closeEdit() {
            this.m_active = false;
        }

        public void valueBound(String sessionStateKey, String attributeName) {
        }

        public void valueUnbound(String sessionStateKey, String attributeName) {
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", this + ".valueUnbound()");
            }
            if (this.m_active) {
                BaseDissertationService.this.cancelEdit(this);
            }
        }
    }

    public class BaseStepStatus
    implements StepStatus {
        protected String m_id;
        protected String m_validator;
        protected String m_instructions;
        protected String m_site;
        protected String m_parentStepReference;
        protected String m_autoValidationId;
        protected Time m_timeCompleted;
        protected Time m_recommendedDeadline;
        protected Time m_hardDeadline;
        protected String m_validationType;
        protected FlexStringArray m_prereqStatus;
        protected boolean m_completed;
        protected boolean m_oardValidated;
        protected ResourcePropertiesEdit m_properties;

        public BaseStepStatus(String statusId, String site) {
            this.m_id = statusId;
            this.m_site = site;
            this.m_validator = "";
            this.m_parentStepReference = "-1";
            this.m_validationType = "0";
            this.m_instructions = "";
            this.m_autoValidationId = "";
            this.m_prereqStatus = new FlexStringArray();
            this.m_completed = false;
            this.m_oardValidated = false;
            this.m_properties = new BaseResourcePropertiesEdit();
            BaseDissertationService.this.addLiveProperties(this.m_properties);
        }

        public BaseStepStatus(StepStatus status) {
            this.setAll(status);
        }

        public BaseStepStatus(Element el) {
            this.m_properties = new BaseResourcePropertiesEdit();
            String valueString = null;
            this.m_prereqStatus = new FlexStringArray();
            this.m_id = el.getAttribute("id");
            this.m_site = el.getAttribute("site");
            this.m_validator = el.getAttribute("validator");
            this.m_parentStepReference = el.getAttribute("parentstepreference");
            this.m_autoValidationId = el.getAttribute("autovalid");
            this.m_timeCompleted = BaseDissertationService.this.getTimeObject(el.getAttribute("timecompleted"));
            this.m_recommendedDeadline = BaseDissertationService.this.getTimeObject(el.getAttribute("recommendeddeadline"));
            this.m_hardDeadline = BaseDissertationService.this.getTimeObject(el.getAttribute("harddeadline"));
            this.m_completed = BaseDissertationService.this.getBool(el.getAttribute("completed"));
            this.m_oardValidated = BaseDissertationService.this.getBool(el.getAttribute("oardvalidated"));
            this.m_validationType = el.getAttribute("validtype");
            this.m_instructions = Xml.decodeAttribute(el, "instructions");
            NodeList children = el.getChildNodes();
            int length = children.getLength();
            int i = 0;
            while (i < length) {
                Node child = children.item(i);
                if (child.getNodeType() == 1) {
                    Element element = (Element)child;
                    if (element.getTagName().equals("properties")) {
                        this.m_properties = new BaseResourcePropertiesEdit(element);
                    } else if (element.getTagName().equals("prereqstatus")) {
                        NodeList ssChildren = element.getChildNodes();
                        int ssLength = ssChildren.getLength();
                        Node ssChild = null;
                        Element ssElement = null;
                        int x = 0;
                        while (x < ssLength) {
                            ssChild = ssChildren.item(x);
                            if (ssChild.getNodeType() == 1 && (ssElement = (Element)ssChild).getTagName().equals("prereq")) {
                                valueString = ssElement.getAttribute("prereqstatusreference");
                                this.m_prereqStatus.add(valueString);
                            }
                            ++x;
                        }
                    } else if (element.getTagName().equals("instructions")) {
                        if (element.getChildNodes() != null && element.getChildNodes().item(0) != null) {
                            this.m_instructions = element.getChildNodes().item(0).getNodeValue();
                        }
                        if (this.m_instructions == null) {
                            this.m_instructions = "";
                        }
                    }
                }
                ++i;
            }
        }

        protected void setAll(StepStatus status) {
            this.m_id = status.getId();
            this.m_validator = status.getValidator();
            this.m_instructions = status.getInstructions();
            this.m_site = status.getSite();
            this.m_parentStepReference = status.getParentStepReference();
            this.m_autoValidationId = status.getAutoValidationId();
            this.m_validationType = status.getValidationType();
            this.m_prereqStatus = status.getPrereqs();
            this.m_completed = status.getCompleted();
            this.m_timeCompleted = status.getTimeCompleted();
            this.m_recommendedDeadline = status.getRecommendedDeadline();
            this.m_hardDeadline = status.getHardDeadline();
            this.m_properties = new BaseResourcePropertiesEdit();
            this.m_properties.addAll(status.getProperties());
        }

        public Element toXml(Document doc, Stack stack) {
            Element status = doc.createElement("status");
            if (stack.isEmpty()) {
                doc.appendChild(status);
            } else {
                ((Element)stack.peek()).appendChild(status);
            }
            stack.push(status);
            status.setAttribute("id", this.m_id);
            status.setAttribute("site", this.m_site);
            status.setAttribute("validator", this.m_validator);
            status.setAttribute("parentstepreference", this.m_parentStepReference);
            status.setAttribute("validtype", this.m_validationType);
            status.setAttribute("autovalid", this.m_autoValidationId);
            status.setAttribute("timecompleted", BaseDissertationService.this.getTimeString(this.m_timeCompleted));
            status.setAttribute("recommendeddeadline", BaseDissertationService.this.getTimeString(this.m_recommendedDeadline));
            status.setAttribute("harddeadline", BaseDissertationService.this.getTimeString(this.m_hardDeadline));
            status.setAttribute("completed", BaseDissertationService.this.getBoolString(this.m_completed));
            status.setAttribute("oardvalidated", BaseDissertationService.this.getBoolString(this.m_oardValidated));
            Element prereq = null;
            Element prereqStatus = doc.createElement("prereqstatus");
            int x = 0;
            while (x < this.m_prereqStatus.size()) {
                prereq = doc.createElement("prereq");
                prereq.setAttribute("prereqstatusreference", this.m_prereqStatus.get(x));
                prereqStatus.appendChild(prereq);
                ++x;
            }
            status.appendChild(prereqStatus);
            Xml.encodeAttribute(status, "instructions", this.m_instructions);
            this.m_properties.toXml(doc, stack);
            stack.pop();
            return status;
        }

        public String getId() {
            return this.m_id;
        }

        public String getUrl() {
            return BaseDissertationService.this.getAccessPoint(false) + this.m_id;
        }

        public String getReference() {
            return BaseDissertationService.this.statusReference(this.m_site, this.m_id);
        }

        public ResourceProperties getProperties() {
            return this.m_properties;
        }

        public String getParentStepReference() {
            return this.m_parentStepReference;
        }

        public String getCreator() {
            return this.m_properties.getProperty("CHEF:creator");
        }

        public Time getRecommendedDeadline() {
            return this.m_recommendedDeadline;
        }

        public Time getHardDeadline() {
            return this.m_hardDeadline;
        }

        public Time getTimeCompleted() {
            return this.m_timeCompleted;
        }

        public String getValidator() {
            return this.m_validator;
        }

        public String getAutoValidationId() {
            return this.m_autoValidationId;
        }

        public boolean getCompleted() {
            return this.m_completed;
        }

        public boolean getOardValidated() {
            return this.m_oardValidated;
        }

        public FlexStringArray getPrereqs() {
            return this.m_prereqStatus;
        }

        public boolean hasPrerequisite(String statusRef) {
            boolean retVal = false;
            if (statusRef != null) {
                int x = 0;
                while (x < this.m_prereqStatus.size()) {
                    if (statusRef.equals(this.m_prereqStatus.get(x))) {
                        retVal = true;
                    }
                    ++x;
                }
            }
            return retVal;
        }

        public String getValidationType() {
            return this.m_validationType;
        }

        public String getInstructions() {
            StringBuffer retVal = new StringBuffer();
            boolean goodSyntax = true;
            String tempString = null;
            String linkString = null;
            String linkTextString = null;
            String fullLinkString = null;
            int midIndex = -1;
            int endIndex = -1;
            int beginIndex = this.m_instructions.indexOf("http://");
            if (beginIndex == -1) {
                retVal.append(this.m_instructions);
            } else {
                do {
                    retVal.append(this.m_instructions.substring(endIndex + 1, beginIndex));
                    midIndex = this.m_instructions.indexOf("{", beginIndex);
                    if (midIndex == -1) {
                        goodSyntax = false;
                        beginIndex = -1;
                    } else {
                        endIndex = this.m_instructions.indexOf("}", midIndex);
                        if (endIndex == -1) {
                            goodSyntax = false;
                            beginIndex = -1;
                        } else {
                            linkString = this.m_instructions.substring(beginIndex, midIndex);
                            linkTextString = this.m_instructions.substring(midIndex + 1, endIndex);
                            fullLinkString = "<a href='" + linkString + "'>" + linkTextString + "</a>";
                            retVal.append(fullLinkString);
                            beginIndex = this.m_instructions.indexOf("http://", endIndex);
                        }
                    }
                    if (beginIndex != -1) continue;
                    tempString = this.m_instructions.substring(endIndex + 1, this.m_instructions.length());
                    retVal.append(tempString);
                } while (beginIndex != -1);
            }
            if (!goodSyntax) {
                retVal = new StringBuffer();
                retVal.append(this.m_instructions);
            }
            return retVal.toString();
        }

        public String getInstructionsText() {
            return this.m_instructions;
        }

        public String getShortInstructionsText() {
            String retVal = null;
            retVal = this.m_instructions.length() > 80 ? this.m_instructions.substring(0, 79) + " . . . " : this.m_instructions;
            return retVal;
        }

        public String getSite() {
            return this.m_site;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof StepStatus)) {
                return false;
            }
            return ((StepStatus)obj).getId().equals(this.getId());
        }

        public int compareTo(Object obj) {
            if (!(obj instanceof StepStatus)) {
                throw new ClassCastException();
            }
            if (obj == this) {
                return 0;
            }
            int compare = this.getInstructions().compareTo(((StepStatus)obj).getInstructions());
            if (compare == 0) {
                compare = this.getId().compareTo(((StepStatus)obj).getId());
            }
            return compare;
        }
    }

    public class BaseCandidatePathEdit
    extends BaseCandidatePath
    implements CandidatePathEdit,
    SessionStateBindingListener {
        protected String m_event = null;
        protected boolean m_active = false;

        public BaseCandidatePathEdit(String pathId, String site) {
            super(pathId, site);
        }

        public BaseCandidatePathEdit(CandidatePath path) {
            super(path);
        }

        public BaseCandidatePathEdit(Element el) {
            super(el);
        }

        protected void finalize() {
            if (this.m_active) {
                BaseDissertationService.this.cancelEdit(this);
            }
        }

        public void setCandidate(String candidateId) {
            this.m_candidate = candidateId;
        }

        public void setAdvisor(String advisor) {
            this.m_advisor = advisor;
        }

        public void setSite(String siteId) {
            this.m_site = siteId;
        }

        public void setOrderedStatus(Hashtable hash) {
            if (hash != null) {
                this.m_orderedStatus = hash;
            }
        }

        public void setSchoolPrereqs(Hashtable schoolPrereqs) {
            if (schoolPrereqs != null) {
                this.m_schoolPrereqs = schoolPrereqs;
            }
        }

        public void addToOrderedStatus(StepStatus newStatus, int locationInt) {
            Hashtable<String, String> newOrder = new Hashtable<String, String>();
            String keyString = null;
            String statusReference = null;
            int x = 1;
            while (x < this.m_orderedStatus.size() + 2) {
                if (locationInt == x) {
                    keyString = "" + x;
                    newOrder.put(keyString, newStatus.getReference());
                } else if (locationInt < x) {
                    keyString = "" + (x - 1);
                    statusReference = (String)this.m_orderedStatus.get(keyString);
                    keyString = "" + x;
                    newOrder.put(keyString, statusReference);
                } else {
                    keyString = "" + x;
                    statusReference = (String)this.m_orderedStatus.get(keyString);
                    newOrder.put(keyString, statusReference);
                }
                ++x;
            }
            this.m_orderedStatus = newOrder;
        }

        public void removeFromOrderedStatus(String statusToRemoveReference) {
            if (statusToRemoveReference != null) {
                Hashtable<String, String> newOrder = new Hashtable<String, String>();
                Object schoolStepPrereqs = null;
                String keyString = null;
                String statusId = null;
                boolean foundIt = false;
                int y = 1;
                while (y < this.m_orderedStatus.size() + 1) {
                    keyString = "" + y;
                    statusId = (String)this.m_orderedStatus.get(keyString);
                    if (statusId.equals(statusToRemoveReference)) {
                        foundIt = true;
                    } else if (foundIt) {
                        keyString = "" + (y - 1);
                        newOrder.put(keyString, statusId);
                    } else {
                        newOrder.put(keyString, statusId);
                    }
                    ++y;
                }
                this.m_orderedStatus = newOrder;
            }
        }

        public void moveStatus(String statusToMoveReference, String location) {
            Hashtable<String, String> newOrder = new Hashtable<String, String>();
            String keyString = null;
            String statusReference = null;
            int oldPosition = -1;
            int newPosition = -1;
            String aKey = null;
            String aValue = null;
            Enumeration keys = this.m_orderedStatus.keys();
            if (location.equals("start")) {
                newPosition = 1;
            }
            while (keys.hasMoreElements()) {
                aKey = (String)keys.nextElement();
                aValue = (String)this.m_orderedStatus.get(aKey);
                if (aValue.equals(statusToMoveReference)) {
                    try {
                        oldPosition = Integer.parseInt(aKey);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (!aValue.equals(location)) continue;
                try {
                    newPosition = Integer.parseInt(aKey);
                    ++newPosition;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (oldPosition != -1 && newPosition != -1) {
                if (newPosition > oldPosition) {
                    --newPosition;
                    int x = 1;
                    while (x < this.m_orderedStatus.size() + 1) {
                        if (x < oldPosition || x > newPosition) {
                            keyString = "" + x;
                            statusReference = (String)this.m_orderedStatus.get(keyString);
                            newOrder.put(keyString, statusReference);
                        } else if (x == newPosition) {
                            keyString = "" + x;
                            newOrder.put(keyString, statusToMoveReference);
                        } else {
                            keyString = "" + (x + 1);
                            statusReference = (String)this.m_orderedStatus.get(keyString);
                            keyString = "" + x;
                            newOrder.put(keyString, statusReference);
                        }
                        ++x;
                    }
                    this.m_orderedStatus = newOrder;
                } else if (oldPosition > newPosition) {
                    int x = 1;
                    while (x < this.m_orderedStatus.size() + 1) {
                        if (x < newPosition || x > oldPosition) {
                            keyString = "" + x;
                            statusReference = (String)this.m_orderedStatus.get(keyString);
                            newOrder.put(keyString, statusReference);
                        } else if (x == newPosition) {
                            keyString = "" + x;
                            newOrder.put(keyString, statusToMoveReference);
                        } else {
                            keyString = "" + (x - 1);
                            statusReference = (String)this.m_orderedStatus.get(keyString);
                            keyString = "" + x;
                            newOrder.put(keyString, statusReference);
                        }
                        ++x;
                    }
                    this.m_orderedStatus = newOrder;
                }
                int y = 1;
                while (y < newOrder.size() + 1) {
                    keyString = "" + y;
                    statusReference = (String)newOrder.get(keyString);
                    ++y;
                }
            }
        }

        public void liveAddStep(DissertationStep step, String[] previousStepReferences, String siteId) {
            try {
                int numPrevSteps = 0;
                if (previousStepReferences != null) {
                    numPrevSteps = previousStepReferences.length;
                }
                if (step != null) {
                    boolean oardValidated = false;
                    if (!step.getAutoValidationId().equals("")) {
                        oardValidated = true;
                    }
                    StepStatusEdit statusEdit = BaseDissertationService.this.addStepStatus(siteId, step, oardValidated);
                    List stepPrereqs = step.getPrerequisiteSteps();
                    String statusPrereq = null;
                    DissertationStep tempStep = null;
                    if (stepPrereqs.size() > 0) {
                        int x = 0;
                        while (x < stepPrereqs.size()) {
                            tempStep = (DissertationStep)stepPrereqs.get(x);
                            statusPrereq = this.matchStepWithStatus(tempStep);
                            if (statusPrereq != null) {
                                statusEdit.addPrerequisiteStatus(statusPrereq);
                            }
                            ++x;
                        }
                    }
                    BaseDissertationService.this.commitEdit(statusEdit);
                    if (statusEdit.getSite().equals(BaseDissertationService.this.getSchoolSite())) {
                        this.m_schoolPrereqs.put(statusEdit.getReference(), new FlexStringArray());
                    }
                    String previousStatusReference = null;
                    boolean notFound = true;
                    DissertationStep previousStep = null;
                    int x = numPrevSteps - 1;
                    while (x > -1) {
                        if (notFound) {
                            if (previousStepReferences[x].equals("start")) {
                                previousStatusReference = "start";
                                notFound = false;
                            } else {
                                previousStep = BaseDissertationService.this.getDissertationStep(previousStepReferences[x]);
                                previousStatusReference = this.matchStepWithStatus(previousStep);
                                if (previousStatusReference != null) {
                                    notFound = false;
                                }
                            }
                        }
                        --x;
                    }
                    int position = 0;
                    if (previousStatusReference == null) {
                        position = this.m_orderedStatus.size();
                        this.addToOrderedStatus(statusEdit, position + 1);
                    } else if (previousStatusReference.equals("start")) {
                        this.addToOrderedStatus(statusEdit, 1);
                    } else if (this.m_orderedStatus.contains(previousStatusReference)) {
                        String aKey = null;
                        String aValue = null;
                        String previousStepKey = null;
                        Enumeration keys = this.m_orderedStatus.keys();
                        while (keys.hasMoreElements()) {
                            aKey = (String)keys.nextElement();
                            aValue = (String)this.m_orderedStatus.get(aKey);
                            if (!aValue.equals(previousStatusReference)) continue;
                            previousStepKey = aKey;
                        }
                        position = Integer.parseInt(previousStepKey);
                        this.addToOrderedStatus(statusEdit, position + 1);
                    }
                }
            }
            catch (Exception e) {
                Log.warn("chef", "DISSERTATION : BASE SERVICE : BASE CANDIDATE PATH : LIVE ADD STEP : EXCEPTION : " + e);
            }
        }

        public void liveRemoveStep(DissertationStep step) {
            try {
                String statusReference = this.matchStepWithStatus(step);
                StepStatusEdit statusToRemoveEdit = BaseDissertationService.this.editStepStatus(statusReference);
                StepStatus status = null;
                StepStatusEdit statusEdit = null;
                FlexStringArray prereqs = null;
                Enumeration keys = this.m_orderedStatus.keys();
                String key = null;
                String value = null;
                while (keys.hasMoreElements()) {
                    key = (String)keys.nextElement();
                    value = (String)this.m_orderedStatus.get(key);
                    status = BaseDissertationService.this.getStepStatus(value);
                    prereqs = status.getPrereqs();
                    if (!prereqs.contains(statusReference)) continue;
                    statusEdit = BaseDissertationService.this.editStepStatus(status.getId());
                    prereqs.remove(statusReference);
                    BaseDissertationService.this.commitEdit(statusEdit);
                }
                keys = this.m_schoolPrereqs.keys();
                while (keys.hasMoreElements()) {
                    key = (String)keys.nextElement();
                    prereqs = (FlexStringArray)this.m_schoolPrereqs.get(key);
                    prereqs.remove(statusReference);
                }
                this.removeFromOrderedStatus(statusReference);
                this.m_schoolPrereqs.remove(statusReference);
                BaseDissertationService.this.removeStepStatus(statusToRemoveEdit);
            }
            catch (Exception e) {
                Log.warn("chef", "DISSERTATION : BASE SERVICE : BASE CP : LIVE REMOVE FROM ORDERED STATUS : EXCEPTION :" + e);
            }
        }

        public void liveUpdateStep(DissertationStep before, DissertationStepEdit after) {
            try {
                String statusReference = this.matchStepWithStatus(before);
                if (statusReference != null) {
                    StepStatusEdit statusEdit = BaseDissertationService.this.editStepStatus(statusReference);
                    statusEdit.setInstructions(after.getInstructionsText());
                    statusEdit.setValidationType(after.getValidationType());
                    FlexStringArray prereqStatus = new FlexStringArray();
                    FlexStringArray prereqSteps = after.getPrerequisiteStepReferences();
                    DissertationStep step = null;
                    String prereqStatusReference = null;
                    int x = 0;
                    while (x < prereqSteps.size()) {
                        step = BaseDissertationService.this.getDissertationStep(prereqSteps.get(x));
                        prereqStatusReference = this.matchStepWithStatus(step);
                        if (prereqStatusReference != null) {
                            prereqStatus.add(prereqStatusReference);
                        }
                        ++x;
                    }
                    statusEdit.setPrereqs(prereqStatus);
                    BaseDissertationService.this.commitEdit(statusEdit);
                }
            }
            catch (Exception e) {
                Log.warn("chef", "DISSERTATION : BASE SERVICE : BASE CP : LIVE UPDATE STEP : EXCEPTION :" + e);
            }
        }

        public void liveMoveStep(DissertationStep step, String location, String previousStepPosition) {
            try {
                String statusRef = this.matchStepWithStatus(step);
                DissertationStep locationStep = null;
                Hashtable<String, String> newOrder = new Hashtable<String, String>();
                String keyString = null;
                String stepRef = null;
                int oldPosition = -1;
                int newPosition = -1;
                String locationStatusRef = "";
                if (location.equals("start")) {
                    newPosition = 1;
                } else {
                    locationStep = BaseDissertationService.this.getDissertationStep(location);
                    locationStatusRef = this.matchStepWithStatus(locationStep);
                }
                String aKey = null;
                String aValue = null;
                Enumeration keys = this.m_orderedStatus.keys();
                while (keys.hasMoreElements()) {
                    aKey = (String)keys.nextElement();
                    aValue = (String)this.m_orderedStatus.get(aKey);
                    if (aValue.equals(statusRef)) {
                        try {
                            oldPosition = Integer.parseInt(aKey);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (!aValue.equals(locationStatusRef)) continue;
                    try {
                        newPosition = Integer.parseInt(aKey);
                        ++newPosition;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (oldPosition != -1 && newPosition != -1) {
                    if (newPosition > oldPosition) {
                        --newPosition;
                        int x = 1;
                        while (x < this.m_orderedStatus.size() + 1) {
                            if (x < oldPosition || x > newPosition) {
                                keyString = "" + x;
                                stepRef = (String)this.m_orderedStatus.get(keyString);
                                newOrder.put(keyString, stepRef);
                            } else if (x == newPosition) {
                                keyString = "" + x;
                                newOrder.put(keyString, statusRef);
                            } else {
                                keyString = "" + (x + 1);
                                stepRef = (String)this.m_orderedStatus.get(keyString);
                                keyString = "" + x;
                                newOrder.put(keyString, stepRef);
                            }
                            ++x;
                        }
                        this.m_orderedStatus = newOrder;
                    } else if (oldPosition > newPosition) {
                        int x = 1;
                        while (x < this.m_orderedStatus.size() + 1) {
                            if (x < newPosition || x > oldPosition) {
                                keyString = "" + x;
                                stepRef = (String)this.m_orderedStatus.get(keyString);
                                newOrder.put(keyString, stepRef);
                            } else if (x == newPosition) {
                                keyString = "" + x;
                                newOrder.put(keyString, statusRef);
                            } else {
                                keyString = "" + (x - 1);
                                stepRef = (String)this.m_orderedStatus.get(keyString);
                                keyString = "" + x;
                                newOrder.put(keyString, stepRef);
                            }
                            ++x;
                        }
                        this.m_orderedStatus = newOrder;
                    }
                    int y = 1;
                    while (y < newOrder.size() + 1) {
                        keyString = "" + y;
                        stepRef = (String)newOrder.get(keyString);
                        ++y;
                    }
                }
            }
            catch (Exception e) {
                Log.warn("chef", "DISSERTATION : BASE SERVICE : BASE CP : LIVE MOVE STEP : EXCEPTION :" + e);
            }
        }

        public void liveAddSchoolPrereq(String stepRef, String prereqRef) {
            try {
                DissertationStep step = BaseDissertationService.this.getDissertationStep(stepRef);
                DissertationStep prereq = BaseDissertationService.this.getDissertationStep(prereqRef);
                FlexStringArray schoolPrereqs = null;
                String statusRef = this.matchStepWithStatus(step);
                String prereqStatusReference = this.matchStepWithStatus(prereq);
                if (statusRef != null && prereqStatusReference != null) {
                    schoolPrereqs = (FlexStringArray)this.m_schoolPrereqs.get(statusRef);
                    if (schoolPrereqs == null) {
                        schoolPrereqs = new FlexStringArray();
                    }
                    if (schoolPrereqs != null) {
                        schoolPrereqs.add(prereqStatusReference);
                        this.m_schoolPrereqs.put(statusRef, schoolPrereqs);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void liveRemoveSchoolPrereq(String stepRef, String prereqRef) {
            try {
                DissertationStep step = BaseDissertationService.this.getDissertationStep(stepRef);
                DissertationStep prereq = BaseDissertationService.this.getDissertationStep(prereqRef);
                FlexStringArray schoolPrereqs = null;
                String statusRef = this.matchStepWithStatus(step);
                String prereqStatusReference = this.matchStepWithStatus(prereq);
                if (statusRef != null && prereqStatusReference != null && (schoolPrereqs = (FlexStringArray)this.m_schoolPrereqs.get(statusRef)) != null) {
                    schoolPrereqs.remove(prereqStatusReference);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        protected void set(CandidatePath path) {
            this.setAll(path);
        }

        protected String getEvent() {
            return this.m_event;
        }

        protected void setEvent(String event) {
            this.m_event = event;
        }

        public ResourcePropertiesEdit getPropertiesEdit() {
            return this.m_properties;
        }

        protected void activate() {
            this.m_active = true;
        }

        public boolean isActiveEdit() {
            return this.m_active;
        }

        protected void closeEdit() {
            this.m_active = false;
        }

        public void valueBound(String sessionStateKey, String attributeName) {
        }

        public void valueUnbound(String sessionStateKey, String attributeName) {
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", this + ".valueUnbound()");
            }
            if (this.m_active) {
                BaseDissertationService.this.cancelEdit(this);
            }
        }
    }

    public class BaseCandidatePath
    implements CandidatePath {
        protected String m_id;
        protected String m_candidate;
        protected String m_advisor;
        protected String m_site;
        protected Hashtable m_orderedStatus;
        protected Hashtable m_schoolPrereqs;
        protected ResourcePropertiesEdit m_properties;

        public BaseCandidatePath(String pathId, String site) {
            this.m_id = pathId;
            this.m_site = site;
            this.m_advisor = "";
            this.m_properties = new BaseResourcePropertiesEdit();
            this.m_orderedStatus = new Hashtable();
            this.m_schoolPrereqs = new Hashtable();
            User currentUser = UsageSessionService.getSessionUser();
            if (currentUser != null) {
                this.m_candidate = currentUser.getId();
            } else {
                this.m_candidate = "";
                Log.warn("chef", "In BaseDissertationService, BaseCandidatePath constructor : call to GenericUserDirectoryService.getSessionUser() returns null.");
            }
        }

        public BaseCandidatePath(CandidatePath path) {
            this.setAll(path);
        }

        public BaseCandidatePath(Element el) {
            this.m_properties = new BaseResourcePropertiesEdit();
            String keyString = null;
            String valueString = null;
            FlexStringArray schoolPrereqs = null;
            this.m_orderedStatus = new Hashtable();
            this.m_schoolPrereqs = new Hashtable();
            this.m_id = el.getAttribute("id");
            this.m_candidate = el.getAttribute("candidate");
            this.m_advisor = el.getAttribute("advisor");
            this.m_site = el.getAttribute("site");
            NodeList children = el.getChildNodes();
            int length = children.getLength();
            int i = 0;
            while (i < length) {
                Node child = children.item(i);
                if (child.getNodeType() == 1) {
                    int x;
                    Element element = (Element)child;
                    if (element.getTagName().equals("properties")) {
                        this.m_properties = new BaseResourcePropertiesEdit(element);
                    } else if (element.getTagName().equals("orderedstatus")) {
                        NodeList osChildren = element.getChildNodes();
                        int osLength = osChildren.getLength();
                        Node osChild = null;
                        Element osElement = null;
                        x = 0;
                        while (x < osLength) {
                            osChild = osChildren.item(x);
                            if (osChild.getNodeType() == 1 && (osElement = (Element)osChild).getTagName().equals("order")) {
                                keyString = osElement.getAttribute("ordernum");
                                valueString = osElement.getAttribute("statusid");
                                if (keyString != null && valueString != null) {
                                    this.m_orderedStatus.put(keyString, valueString);
                                }
                            }
                            ++x;
                        }
                    } else if (element.getTagName().equals("schoolstatusprereqs")) {
                        keyString = element.getAttribute("statusid");
                        schoolPrereqs = new FlexStringArray();
                        NodeList spChildren = element.getChildNodes();
                        int spLength = spChildren.getLength();
                        Node spChild = null;
                        Element spElement = null;
                        x = 0;
                        while (x < spLength) {
                            spChild = spChildren.item(x);
                            if (spChild.getNodeType() == 1 && (spElement = (Element)spChild).getTagName().equals("prereq") && (valueString = spElement.getAttribute("prereqstatusreference")) != null) {
                                schoolPrereqs.add(valueString);
                            }
                            ++x;
                        }
                        if (keyString != null) {
                            this.m_schoolPrereqs.put(keyString, schoolPrereqs);
                        }
                    }
                }
                ++i;
            }
        }

        protected void setAll(CandidatePath path) {
            this.m_id = path.getId();
            this.m_candidate = path.getCandidate();
            this.m_site = path.getSite();
            this.m_advisor = path.getAdvisor();
            this.m_orderedStatus = path.getOrderedStatus();
            this.m_schoolPrereqs = path.getSchoolPrereqs();
            this.m_properties = new BaseResourcePropertiesEdit();
            this.m_properties.addAll(path.getProperties());
        }

        public Element toXml(Document doc, Stack stack) {
            Element path = doc.createElement("path");
            if (stack.isEmpty()) {
                doc.appendChild(path);
            } else {
                ((Element)stack.peek()).appendChild(path);
            }
            stack.push(path);
            Object numItemsString = null;
            Object attributeString = null;
            String itemString = null;
            String keyString = null;
            Object intString = null;
            path.setAttribute("id", this.m_id);
            path.setAttribute("candidate", this.m_candidate);
            path.setAttribute("advisor", this.m_advisor);
            path.setAttribute("site", this.m_site);
            Element order = null;
            Element orderedStatus = doc.createElement("orderedstatus");
            Log.debug("chef", "DISSERTATION : BASE SERVICE : BASE DISSERTATION : TOXML : CREATED ORDERED STATUS ELEMENT");
            int x = 1;
            while (x < this.m_orderedStatus.size() + 1) {
                order = doc.createElement("order");
                keyString = "" + x;
                order.setAttribute("ordernum", keyString);
                itemString = (String)this.m_orderedStatus.get(keyString);
                if (itemString == null) {
                    itemString = "";
                }
                order.setAttribute("statusid", itemString);
                Log.debug("chef", "DISSERTATION : BASE SERVICE : BASE DISSERTATION : TOXML : ORDER ATTRIBUTE ORDERNUM  : " + keyString);
                Log.debug("chef", "DISSERTATION : BASE SERVICE : BASE DISSERTATION : TOXML : ORDER ATTRIBUTE STATUS ID : " + itemString);
                orderedStatus.appendChild(order);
                ++x;
            }
            path.appendChild(orderedStatus);
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", "DISSERTATION : BASE SERVICE : BASE DISSERTATION : TOXML : NUMBER OF SCHOOL PREREQS : " + this.m_schoolPrereqs.size());
            }
            Element schoolStatusPrereqs = null;
            Element prereq = null;
            Enumeration keys = this.m_schoolPrereqs.keys();
            FlexStringArray schoolPrereqs = null;
            while (keys.hasMoreElements()) {
                schoolStatusPrereqs = doc.createElement("schoolstatusprereqs");
                keyString = (String)keys.nextElement();
                schoolStatusPrereqs.setAttribute("statusid", keyString);
                schoolPrereqs = (FlexStringArray)this.m_schoolPrereqs.get(keyString);
                int x2 = 0;
                while (x2 < schoolPrereqs.size()) {
                    prereq = doc.createElement("prereq");
                    prereq.setAttribute("prereqstatusreference", schoolPrereqs.get(x2));
                    schoolStatusPrereqs.appendChild(prereq);
                    ++x2;
                }
                path.appendChild(schoolStatusPrereqs);
            }
            this.m_properties.toXml(doc, stack);
            stack.pop();
            return path;
        }

        public String getId() {
            return this.m_id;
        }

        public String getUrl() {
            return BaseDissertationService.this.getAccessPoint(false) + this.m_id;
        }

        public String getReference() {
            return BaseDissertationService.this.pathReference(this.m_site, this.m_id);
        }

        public ResourceProperties getProperties() {
            return this.m_properties;
        }

        public String getAdvisor() {
            return this.m_advisor;
        }

        public String getSite() {
            return this.m_site;
        }

        public String getCandidate() {
            return this.m_candidate;
        }

        public Hashtable getSchoolPrereqs() {
            return this.m_schoolPrereqs;
        }

        public String getStatusStatus(StepStatus status) {
            String retVal = "";
            FlexStringArray deptAddedPrereqs = null;
            StepStatus aStatus = null;
            if (status != null) {
                if (status.getCompleted()) {
                    retVal = "Step completed.";
                } else {
                    boolean prereqsCompleted = true;
                    FlexStringArray prereqs = status.getPrereqs();
                    int x = 0;
                    while (x < prereqs.size()) {
                        try {
                            aStatus = BaseDissertationService.this.getStepStatus(prereqs.get(x));
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (!aStatus.getCompleted()) {
                            prereqsCompleted = false;
                        }
                        ++x;
                    }
                    deptAddedPrereqs = this.getSchoolPrereqs(status.getReference());
                    if (deptAddedPrereqs != null) {
                        int x2 = 0;
                        while (x2 < deptAddedPrereqs.size()) {
                            try {
                                aStatus = BaseDissertationService.this.getStepStatus(deptAddedPrereqs.get(x2));
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            if (!aStatus.getCompleted()) {
                                prereqsCompleted = false;
                            }
                            ++x2;
                        }
                    }
                    retVal = prereqsCompleted ? "Prerequisites completed; step not completed." : "Prerequisites not completed.";
                }
            }
            return retVal;
        }

        public Hashtable getOrderedStatus() {
            return this.m_orderedStatus;
        }

        public String getStatusReferenceByOrder(String order) {
            if (order == null) {
                return null;
            }
            return (String)this.m_orderedStatus.get(order);
        }

        public int getOrderForStatus(String statusReference) {
            int retVal = 0;
            try {
                String keyString = null;
                String valueString = null;
                Enumeration keys = this.m_orderedStatus.keys();
                while (keys.hasMoreElements()) {
                    keyString = (String)keys.nextElement();
                    valueString = (String)this.m_orderedStatus.get(keyString);
                    if (!statusReference.equals(valueString)) continue;
                    retVal = Integer.parseInt(keyString);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return retVal;
        }

        public FlexStringArray getSchoolPrereqs(String schoolStepRef) {
            FlexStringArray retVal = null;
            if (this.m_schoolPrereqs != null) {
                retVal = (FlexStringArray)this.m_schoolPrereqs.get(schoolStepRef);
            }
            if (retVal == null) {
                retVal = new FlexStringArray();
            }
            return retVal;
        }

        public String matchStepWithStatus(DissertationStep step) {
            String retVal = null;
            String key = null;
            String value = null;
            StepStatus tempStatus = null;
            Enumeration keys = this.m_orderedStatus.keys();
            while (keys.hasMoreElements()) {
                try {
                    key = (String)keys.nextElement();
                    value = (String)this.m_orderedStatus.get(key);
                    tempStatus = BaseDissertationService.this.getStepStatus(value);
                    if (!this.matches(step, tempStatus)) continue;
                    retVal = value;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return retVal;
        }

        protected boolean matches(DissertationStep step, StepStatus status) {
            boolean retVal = false;
            if (step.getReference().equals(status.getParentStepReference())) {
                retVal = true;
            } else if (step != null && status != null) {
                int numMatches = 0;
                if (step.getInstructionsText().equals(status.getInstructions())) {
                    ++numMatches;
                }
                if (step.getValidationType() == status.getValidationType()) {
                    ++numMatches;
                }
                if (step.getSite().equals(status.getSite())) {
                    ++numMatches;
                }
                if (numMatches == 3) {
                    retVal = true;
                }
            }
            return retVal;
        }

        public String getPrerequisiteStepsDisplayString(StepStatus status) {
            StringBuffer retVal = new StringBuffer();
            if (status != null) {
                String keyString = "";
                String statusReference = "";
                boolean firstAdded = true;
                boolean addToString = false;
                FlexStringArray deptAddedPrereqs = (FlexStringArray)this.m_schoolPrereqs.get(status.getReference());
                int x = 1;
                while (x < this.m_orderedStatus.size() + 1) {
                    addToString = false;
                    keyString = "" + x;
                    statusReference = (String)this.m_orderedStatus.get(keyString);
                    if (status.hasPrerequisite(statusReference)) {
                        addToString = true;
                    } else if (deptAddedPrereqs != null && deptAddedPrereqs.contains(statusReference)) {
                        addToString = true;
                    }
                    if (addToString) {
                        if (firstAdded) {
                            retVal.append(keyString);
                            firstAdded = false;
                        } else {
                            retVal.append(", " + keyString);
                        }
                    }
                    ++x;
                }
            }
            return retVal.toString();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CandidatePath)) {
                return false;
            }
            return ((CandidatePath)obj).getId().equals(this.getId());
        }

        public int compareTo(Object obj) {
            if (!(obj instanceof CandidatePath)) {
                throw new ClassCastException();
            }
            if (obj == this) {
                return 0;
            }
            int compare = this.getCandidate().compareTo(((CandidatePath)obj).getCandidate());
            if (compare == 0) {
                compare = this.getId().compareTo(((CandidatePath)obj).getId());
            }
            return compare;
        }
    }

    public class BaseDissertationStepEdit
    extends BaseDissertationStep
    implements DissertationStepEdit,
    SessionStateBindingListener {
        protected String m_event = null;
        protected boolean m_active = false;

        public BaseDissertationStepEdit(String id, String site) {
            super(id, site);
        }

        public BaseDissertationStepEdit(DissertationStep step) {
            super(step);
        }

        public BaseDissertationStepEdit(Element el) {
            super(el);
        }

        protected void finalize() {
            if (this.m_active) {
                BaseDissertationService.this.cancelEdit(this);
            }
        }

        public void setSite(String site) {
            this.m_site = site;
        }

        public void setInstructionsText(String instructionsText) {
            if (instructionsText != null) {
                this.m_instructionsText = Validator.escapeHtml(instructionsText);
            }
        }

        public void addPrerequisiteStep(String stepReference) {
            this.m_prerequisiteSteps.add(stepReference);
        }

        public void removePrerequisiteStep(String stepReference) {
            this.m_prerequisiteSteps.remove(stepReference);
        }

        public void setValidationType(String type) {
            this.m_validationType = type;
        }

        public void setAutoValidationId(String validId) {
            if (validId != null) {
                this.m_autoValidationId = validId;
            }
        }

        protected void set(DissertationStep step) {
            this.setAll(step);
        }

        protected String getEvent() {
            return this.m_event;
        }

        protected void setEvent(String event) {
            this.m_event = event;
        }

        public ResourcePropertiesEdit getPropertiesEdit() {
            return this.m_properties;
        }

        protected void activate() {
            this.m_active = true;
        }

        public boolean isActiveEdit() {
            return this.m_active;
        }

        protected void closeEdit() {
            this.m_active = false;
        }

        public void valueBound(String sessionStateKey, String attributeName) {
        }

        public void valueUnbound(String sessionStateKey, String attributeName) {
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", this + ".valueUnbound()");
            }
            if (this.m_active) {
                BaseDissertationService.this.cancelEdit(this);
            }
        }
    }

    public class BaseDissertationStep
    implements DissertationStep {
        protected String m_id;
        protected String m_site;
        protected String m_instructionsText;
        protected String m_autoValidationId;
        protected Time m_timeLastModified;
        protected String m_validationType;
        protected FlexStringArray m_prerequisiteSteps;
        protected BaseResourcePropertiesEdit m_properties;

        public BaseDissertationStep(String stepId, String site) {
            this.m_id = stepId;
            this.m_site = site;
            this.m_instructionsText = "";
            this.m_autoValidationId = "";
            this.m_timeLastModified = new Time();
            this.m_validationType = "0";
            this.m_prerequisiteSteps = new FlexStringArray();
            this.m_properties = new BaseResourcePropertiesEdit();
            BaseDissertationService.this.addLiveProperties(this.m_properties);
        }

        public BaseDissertationStep(DissertationStep step) {
            this.setAll(step);
        }

        public BaseDissertationStep(Element el) {
            String valueString = null;
            this.m_properties = new BaseResourcePropertiesEdit();
            this.m_prerequisiteSteps = new FlexStringArray();
            this.m_id = el.getAttribute("id");
            this.m_site = el.getAttribute("site");
            this.m_autoValidationId = el.getAttribute("autovalid");
            this.m_timeLastModified = BaseDissertationService.this.getTimeObject(el.getAttribute("timelastmod"));
            this.m_validationType = el.getAttribute("validationtype");
            this.m_instructionsText = Xml.decodeAttribute(el, "instructionstext");
            NodeList children = el.getChildNodes();
            int length = children.getLength();
            int i = 0;
            while (i < length) {
                Node child = children.item(i);
                if (child.getNodeType() == 1) {
                    Element element = (Element)child;
                    if (element.getTagName().equals("properties")) {
                        this.m_properties = new BaseResourcePropertiesEdit(element);
                    } else if (element.getTagName().equals("prereqsteps")) {
                        NodeList psChildren = element.getChildNodes();
                        int psLength = psChildren.getLength();
                        Node psChild = null;
                        Element psElement = null;
                        int x = 0;
                        while (x < psLength) {
                            psChild = psChildren.item(x);
                            if (psChild.getNodeType() == 1 && (psElement = (Element)psChild).getTagName().equals("prereq") && (valueString = psElement.getAttribute("prereqstepreference")) != null) {
                                this.m_prerequisiteSteps.add(valueString);
                            }
                            ++x;
                        }
                    } else if (element.getTagName().equals("instructionstext")) {
                        if (element.getChildNodes() != null && element.getChildNodes().item(0) != null) {
                            this.m_instructionsText = element.getChildNodes().item(0).getNodeValue();
                        }
                        if (this.m_instructionsText == null) {
                            this.m_instructionsText = "";
                        }
                    }
                }
                ++i;
            }
        }

        protected void setAll(DissertationStep step) {
            this.m_id = step.getId();
            this.m_site = step.getSite();
            this.m_instructionsText = step.getInstructionsText();
            this.m_autoValidationId = step.getAutoValidationId();
            this.m_timeLastModified = step.getTimeLastModified();
            this.m_validationType = step.getValidationType();
            this.m_prerequisiteSteps = step.getPrerequisiteStepReferences();
            this.m_properties = new BaseResourcePropertiesEdit();
            this.m_properties.addAll(step.getProperties());
        }

        public Element toXml(Document doc, Stack stack) {
            Element step = doc.createElement("step");
            if (stack.isEmpty()) {
                doc.appendChild(step);
            } else {
                ((Element)stack.peek()).appendChild(step);
            }
            stack.push(step);
            Object attributeString = null;
            Object itemString = null;
            Object intString = null;
            step.setAttribute("id", this.m_id);
            step.setAttribute("site", this.m_site);
            step.setAttribute("validationtype", this.m_validationType);
            step.setAttribute("autovalid", this.m_autoValidationId);
            Element prereq = null;
            Element prereqsteps = doc.createElement("prereqsteps");
            int x = 0;
            while (x < this.m_prerequisiteSteps.size()) {
                prereq = doc.createElement("prereq");
                prereq.setAttribute("prereqstepreference", this.m_prerequisiteSteps.get(x));
                prereqsteps.appendChild(prereq);
                ++x;
            }
            step.appendChild(prereqsteps);
            Xml.encodeAttribute(step, "instructionstext", this.m_instructionsText);
            this.m_properties.toXml(doc, stack);
            stack.pop();
            return step;
        }

        public String getId() {
            return this.m_id;
        }

        public String getUrl() {
            return BaseDissertationService.this.getAccessPoint(false) + this.m_id;
        }

        public String getReference() {
            return BaseDissertationService.this.stepReference(this.m_site, this.m_id);
        }

        public ResourceProperties getProperties() {
            return this.m_properties;
        }

        public String getCreator() {
            return this.m_properties.getProperty("CHEF:creator");
        }

        public String getAuthorLastModified() {
            return this.m_properties.getProperty("CHEF:modifiedby");
        }

        public Time getTimeLastModified() {
            return this.m_timeLastModified;
        }

        public String getSite() {
            return this.m_site;
        }

        public String getInstructions() {
            StringBuffer retVal = new StringBuffer();
            boolean goodSyntax = true;
            String tempString = null;
            String linkString = null;
            String linkTextString = null;
            String fullLinkString = null;
            int midIndex = -1;
            int endIndex = -1;
            int beginIndex = this.m_instructionsText.indexOf("http://");
            if (beginIndex == -1) {
                retVal.append(this.m_instructionsText);
            } else {
                do {
                    retVal.append(this.m_instructionsText.substring(endIndex + 1, beginIndex));
                    midIndex = this.m_instructionsText.indexOf("{", beginIndex);
                    if (midIndex == -1) {
                        goodSyntax = false;
                        beginIndex = -1;
                    } else {
                        endIndex = this.m_instructionsText.indexOf("}", midIndex);
                        if (endIndex == -1) {
                            goodSyntax = false;
                            beginIndex = -1;
                        } else {
                            linkString = this.m_instructionsText.substring(beginIndex, midIndex);
                            linkTextString = this.m_instructionsText.substring(midIndex + 1, endIndex);
                            fullLinkString = "<a href='" + linkString + "'>" + linkTextString + "</a>";
                            retVal.append(fullLinkString);
                            beginIndex = this.m_instructionsText.indexOf("http://", endIndex);
                        }
                    }
                    if (beginIndex != -1) continue;
                    tempString = this.m_instructionsText.substring(endIndex + 1, this.m_instructionsText.length());
                    retVal.append(tempString);
                } while (beginIndex != -1);
            }
            if (!goodSyntax) {
                retVal = new StringBuffer();
                retVal.append(this.m_instructionsText);
            }
            return retVal.toString();
        }

        public String getInstructionsText() {
            return this.m_instructionsText;
        }

        public String getShortInstructionsText() {
            String retVal = null;
            retVal = this.m_instructionsText.length() > 80 ? this.m_instructionsText.substring(0, 79) + " . . . " : this.m_instructionsText;
            return retVal;
        }

        public String getAutoValidationId() {
            return this.m_autoValidationId;
        }

        public FlexStringArray getPrerequisiteStepReferences() {
            return this.m_prerequisiteSteps;
        }

        public List getPrerequisiteSteps() {
            Vector<DissertationStep> retVal = new Vector<DissertationStep>();
            DissertationStep tempStep = null;
            int x = 0;
            while (x < this.m_prerequisiteSteps.size()) {
                try {
                    tempStep = BaseDissertationService.this.getDissertationStep(this.m_prerequisiteSteps.get(x));
                    if (tempStep != null) {
                        retVal.add(tempStep);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                ++x;
            }
            return retVal;
        }

        public boolean hasPrerequisiteStep(String stepReference) {
            return this.m_prerequisiteSteps.contains(stepReference);
        }

        public boolean hasPrerequisites() {
            return this.m_prerequisiteSteps.size() > 0;
        }

        public String getValidationType() {
            return this.m_validationType;
        }

        public String getValidationTypeString() {
            String retVal = null;
            retVal = this.m_validationType.equals("1") ? "Student" : (this.m_validationType.equals("2") ? "Chair" : (this.m_validationType.equals("3") ? "Committee" : (this.m_validationType.equals("4") ? "Department" : (this.m_validationType.equals("5") ? "Rackham" : (this.m_validationType.equals("6") ? "Student / Chair" : (this.m_validationType.equals("7") ? "Student / Committee" : (this.m_validationType.equals("8") ? "Student / Department" : (this.m_validationType.equals("9") ? "Student / Rackham" : "Unknown Validation Type"))))))));
            return retVal;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DissertationStep)) {
                return false;
            }
            return ((DissertationStep)obj).getId().equals(this.getId());
        }

        public int compareTo(Object obj) {
            if (!(obj instanceof DissertationStep)) {
                throw new ClassCastException();
            }
            if (obj == this) {
                return 0;
            }
            int compare = this.getInstructionsText().compareTo(((DissertationStep)obj).getInstructionsText());
            if (compare == 0) {
                compare = this.getId().compareTo(((DissertationStep)obj).getId());
            }
            return compare;
        }
    }

    public class BaseDissertationEdit
    extends BaseDissertation
    implements DissertationEdit,
    SessionStateBindingListener {
        protected String m_event = null;
        protected boolean m_active;

        public BaseDissertationEdit(String dissertationId, String site) {
            super(dissertationId, site);
        }

        public BaseDissertationEdit(Dissertation d) {
            super(d);
        }

        public BaseDissertationEdit(Element el) {
            super(el);
        }

        protected void finalize() {
            if (this.m_active) {
                BaseDissertationService.this.cancelEdit(this);
            }
        }

        public void setOrderedSteps(Hashtable table) {
            if (table != null) {
                this.m_orderedSteps = table;
            }
        }

        public void setSite(String site) {
            this.m_site = site;
        }

        public void setSchoolPrereqs(String schoolStepReference, FlexStringArray prereqs) {
            if (schoolStepReference != null && prereqs != null) {
                this.m_schoolStepPrereqs.put(schoolStepReference, prereqs);
            }
        }

        public void addSchoolPrereq(String schoolStepReference, String prereqStepReference) {
            FlexStringArray prereqs = null;
            if (schoolStepReference != null && prereqStepReference != null) {
                prereqs = (FlexStringArray)this.m_schoolStepPrereqs.get(schoolStepReference);
                if (prereqs == null) {
                    prereqs = new FlexStringArray();
                }
                if (!prereqs.contains(prereqStepReference)) {
                    prereqs.add(prereqStepReference);
                }
                this.m_schoolStepPrereqs.put(schoolStepReference, prereqs);
            }
        }

        public void removeSchoolPrereq(String schoolStepReference, String prereqStepReference) {
            FlexStringArray prereqs = null;
            if (schoolStepReference != null && prereqStepReference != null) {
                prereqs = (FlexStringArray)this.m_schoolStepPrereqs.get(schoolStepReference);
                if (prereqs == null) {
                    prereqs = new FlexStringArray();
                }
                prereqs.remove(prereqStepReference);
            }
        }

        public void removeStep(String stepToRemoveReference) {
            if (stepToRemoveReference != null) {
                Hashtable<String, String> newOrder = new Hashtable<String, String>();
                FlexStringArray schoolStepPrereqs = null;
                String keyString = null;
                String stepReference = null;
                boolean foundIt = false;
                int y = 1;
                while (y < this.m_orderedSteps.size() + 1) {
                    keyString = "" + y;
                    stepReference = (String)this.m_orderedSteps.get(keyString);
                    schoolStepPrereqs = (FlexStringArray)this.m_schoolStepPrereqs.get(stepReference);
                    if (schoolStepPrereqs != null) {
                        schoolStepPrereqs.remove(stepToRemoveReference);
                    }
                    if (stepReference.equals(stepToRemoveReference)) {
                        foundIt = true;
                    } else if (foundIt) {
                        keyString = "" + (y - 1);
                        newOrder.put(keyString, stepReference);
                    } else {
                        newOrder.put(keyString, stepReference);
                    }
                    ++y;
                }
                this.m_orderedSteps = newOrder;
            }
        }

        public void addStep(DissertationStep step, String previousstepReference) {
            if (step != null) {
                int position = 0;
                if (previousstepReference != null) {
                    try {
                        FlexStringArray prereqs = step.getPrerequisiteStepReferences();
                        int x = 0;
                        while (x < prereqs.size()) {
                            if (this.getOrderForStep(prereqs.get(x)) == null) {
                                DissertationStepEdit stepEdit = BaseDissertationService.this.editDissertationStep(step.getReference());
                                stepEdit.removePrerequisiteStep(prereqs.get(x));
                                BaseDissertationService.this.commitEdit(stepEdit);
                            }
                            ++x;
                        }
                        if (previousstepReference.equals("start")) {
                            this.addToOrderedSteps(step, 1);
                        } else if (this.m_orderedSteps.contains(previousstepReference)) {
                            String aKey = null;
                            String aValue = null;
                            String previousStepKey = null;
                            Enumeration keys = this.m_orderedSteps.keys();
                            while (keys.hasMoreElements()) {
                                aKey = (String)keys.nextElement();
                                aValue = (String)this.m_orderedSteps.get(aKey);
                                if (!aValue.equals(previousstepReference)) continue;
                                previousStepKey = aKey;
                            }
                            position = Integer.parseInt(previousStepKey);
                            this.addToOrderedSteps(step, position + 1);
                        } else {
                            int stepPos = this.m_orderedSteps.size() + 1;
                            this.addToOrderedSteps(step, stepPos);
                        }
                    }
                    catch (Exception e) {
                        Log.warn("chef", "DISSERTATION : BASE SERVICE : BASE DISSERTATION : ADD STEP : EXCEPTION : " + e);
                    }
                }
            }
        }

        public void moveStep(String stepToMoveRef, String location) {
            Hashtable<String, String> newOrder = new Hashtable<String, String>();
            String keyString = null;
            String stepReference = null;
            int oldPosition = -1;
            int newPosition = -1;
            String aKey = null;
            String aValue = null;
            Enumeration keys = this.m_orderedSteps.keys();
            if (location.equals("start")) {
                newPosition = 1;
            }
            while (keys.hasMoreElements()) {
                aKey = (String)keys.nextElement();
                aValue = (String)this.m_orderedSteps.get(aKey);
                if (aValue.equals(stepToMoveRef)) {
                    try {
                        oldPosition = Integer.parseInt(aKey);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (!aValue.equals(location)) continue;
                try {
                    newPosition = Integer.parseInt(aKey);
                    ++newPosition;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (oldPosition != -1 && newPosition != -1) {
                if (newPosition > oldPosition) {
                    --newPosition;
                    int x = 1;
                    while (x < this.m_orderedSteps.size() + 1) {
                        if (x < oldPosition || x > newPosition) {
                            keyString = "" + x;
                            stepReference = (String)this.m_orderedSteps.get(keyString);
                            newOrder.put(keyString, stepReference);
                        } else if (x == newPosition) {
                            keyString = "" + x;
                            newOrder.put(keyString, stepToMoveRef);
                        } else {
                            keyString = "" + (x + 1);
                            stepReference = (String)this.m_orderedSteps.get(keyString);
                            keyString = "" + x;
                            newOrder.put(keyString, stepReference);
                        }
                        ++x;
                    }
                    this.m_orderedSteps = newOrder;
                } else if (oldPosition > newPosition) {
                    int x = 1;
                    while (x < this.m_orderedSteps.size() + 1) {
                        if (x < newPosition || x > oldPosition) {
                            keyString = "" + x;
                            stepReference = (String)this.m_orderedSteps.get(keyString);
                            newOrder.put(keyString, stepReference);
                        } else if (x == newPosition) {
                            keyString = "" + x;
                            newOrder.put(keyString, stepToMoveRef);
                        } else {
                            keyString = "" + (x - 1);
                            stepReference = (String)this.m_orderedSteps.get(keyString);
                            keyString = "" + x;
                            newOrder.put(keyString, stepReference);
                        }
                        ++x;
                    }
                    this.m_orderedSteps = newOrder;
                }
                int y = 1;
                while (y < newOrder.size() + 1) {
                    keyString = "" + y;
                    stepReference = (String)newOrder.get(keyString);
                    ++y;
                }
            }
        }

        protected void addToOrderedSteps(DissertationStep newStep, int locationInt) {
            Hashtable<String, String> newOrder = new Hashtable<String, String>();
            String keyString = null;
            String stepReference = null;
            int x = 1;
            while (x < this.m_orderedSteps.size() + 2) {
                if (locationInt == x) {
                    keyString = "" + x;
                    newOrder.put(keyString, newStep.getReference());
                } else if (locationInt < x) {
                    keyString = "" + (x - 1);
                    stepReference = (String)this.m_orderedSteps.get(keyString);
                    keyString = "" + x;
                    newOrder.put(keyString, stepReference);
                } else {
                    keyString = "" + x;
                    stepReference = (String)this.m_orderedSteps.get(keyString);
                    newOrder.put(keyString, stepReference);
                }
                ++x;
            }
            this.m_orderedSteps = newOrder;
        }

        protected void set(Dissertation dissertation) {
            this.setAll(dissertation);
        }

        protected String getEvent() {
            return this.m_event;
        }

        protected void setEvent(String event) {
            this.m_event = event;
        }

        public ResourcePropertiesEdit getPropertiesEdit() {
            return this.m_properties;
        }

        protected void activate() {
            this.m_active = true;
        }

        public boolean isActiveEdit() {
            return this.m_active;
        }

        protected void closeEdit() {
            this.m_active = false;
        }

        public void valueBound(String sessionStateKey, String attributeName) {
        }

        public void valueUnbound(String sessionStateKey, String attributeName) {
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", this + ".valueUnbound()");
            }
            if (this.m_active) {
                BaseDissertationService.this.cancelEdit(this);
            }
        }
    }

    public class BaseDissertation
    implements Dissertation {
        protected String m_id;
        protected ResourcePropertiesEdit m_properties;
        protected Hashtable m_orderedSteps;
        protected Hashtable m_schoolStepPrereqs;
        protected String m_site;
        protected Time m_timeLastModified;

        public BaseDissertation(String dissertationId, String site) {
            this.m_id = dissertationId;
            this.m_site = site;
            this.m_orderedSteps = new Hashtable();
            this.m_schoolStepPrereqs = new Hashtable();
            this.m_properties = new BaseResourcePropertiesEdit();
            BaseDissertationService.this.addLiveProperties(this.m_properties);
        }

        public BaseDissertation(Dissertation dissertation) {
            this.setAll(dissertation);
        }

        public BaseDissertation(Element el) {
            this("", "");
            String keyString = null;
            String valueString = null;
            FlexStringArray schoolPrereqs = null;
            this.m_id = el.getAttribute("id");
            this.m_site = el.getAttribute("site");
            this.m_timeLastModified = this$0.getTimeObject(el.getAttribute("lastmod"));
            NodeList children = el.getChildNodes();
            int length = children.getLength();
            int i = 0;
            while (i < length) {
                Node child = children.item(i);
                if (child.getNodeType() == 1) {
                    int x;
                    Element element = (Element)child;
                    if (element.getTagName().equals("properties")) {
                        this.m_properties = new BaseResourcePropertiesEdit(element);
                    } else if (element.getTagName().equals("orderedsteps")) {
                        NodeList osChildren = element.getChildNodes();
                        int osLength = osChildren.getLength();
                        Node osChild = null;
                        Element osElement = null;
                        x = 0;
                        while (x < osLength) {
                            osChild = osChildren.item(x);
                            if (osChild.getNodeType() == 1 && (osElement = (Element)osChild).getTagName().equals("order")) {
                                keyString = osElement.getAttribute("ordernum");
                                valueString = osElement.getAttribute("stepreference");
                                if (keyString != null && valueString != null) {
                                    this.m_orderedSteps.put(keyString, valueString);
                                }
                            }
                            ++x;
                        }
                    } else if (element.getTagName().equals("schoolstepprereqs")) {
                        keyString = element.getAttribute("stepreference");
                        schoolPrereqs = new FlexStringArray();
                        NodeList spChildren = element.getChildNodes();
                        int spLength = spChildren.getLength();
                        Node spChild = null;
                        Element spElement = null;
                        x = 0;
                        while (x < spLength) {
                            spChild = spChildren.item(x);
                            if (spChild.getNodeType() == 1 && (spElement = (Element)spChild).getTagName().equals("prereq") && (valueString = spElement.getAttribute("prereqstepreference")) != null) {
                                schoolPrereqs.add(valueString);
                            }
                            ++x;
                        }
                        if (keyString != null) {
                            this.m_schoolStepPrereqs.put(keyString, schoolPrereqs);
                        }
                    }
                }
                ++i;
            }
        }

        protected void setAll(Dissertation d) {
            this.m_id = d.getId();
            this.m_orderedSteps = d.getOrderedSteps();
            this.m_schoolStepPrereqs = d.getSchoolStepPrereqs();
            this.m_site = d.getSite();
            this.m_timeLastModified = d.getTimeLastModified();
            this.m_properties = new BaseResourcePropertiesEdit();
            this.m_properties.addAll(d.getProperties());
        }

        public Element toXml(Document doc, Stack stack) {
            Element dissertation = doc.createElement("dissertation");
            if (stack.isEmpty()) {
                doc.appendChild(dissertation);
            } else {
                ((Element)stack.peek()).appendChild(dissertation);
            }
            stack.push(dissertation);
            FlexStringArray schoolPrereqs = null;
            String itemString = null;
            String keyString = null;
            Enumeration keys = null;
            dissertation.setAttribute("id", this.m_id);
            dissertation.setAttribute("site", this.m_site);
            dissertation.setAttribute("lastmod", BaseDissertationService.this.getTimeString(this.m_timeLastModified));
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", "DISSERTATION : BASE SERVICE : BASE DISSERTATION : TOXML : NUMBER OF ORDERED STEPS : " + this.m_orderedSteps.size());
            }
            Element order = null;
            Element orderedSteps = doc.createElement("orderedsteps");
            int x = 1;
            while (x < this.m_orderedSteps.size() + 1) {
                order = doc.createElement("order");
                keyString = "" + x;
                order.setAttribute("ordernum", keyString);
                itemString = (String)this.m_orderedSteps.get(keyString);
                if (itemString == null) {
                    itemString = "";
                }
                order.setAttribute("stepreference", itemString);
                Log.debug("chef", "DISSERTATION : BASE SERVICE : BASE DISSERTATION : TOXML : ORDER ATTRIBUTE ORDERNUM : " + keyString);
                Log.debug("chef", "DISSERTATION : BASE SERVICE : BASE DISSERTATION : TOXML : ORDER ATTRIBUTE STEP ID  : " + itemString);
                orderedSteps.appendChild(order);
                ++x;
            }
            dissertation.appendChild(orderedSteps);
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", "DISSERTATION : BASE SERVICE : BASE DISSERTATION : TOXML : NUMBER OF SCHOOL PREREQS : " + this.m_schoolStepPrereqs.size());
            }
            Element schoolStepPrereqs = null;
            Element prereq = null;
            keys = this.m_schoolStepPrereqs.keys();
            while (keys.hasMoreElements()) {
                schoolStepPrereqs = doc.createElement("schoolstepprereqs");
                keyString = (String)keys.nextElement();
                Log.debug("chef", "DISSERTATION : BASE SERVICE : BASE DISSERTATION : TOXML : A KEY : " + keyString);
                schoolStepPrereqs.setAttribute("stepreference", keyString);
                schoolPrereqs = (FlexStringArray)this.m_schoolStepPrereqs.get(keyString);
                int x2 = 0;
                while (x2 < schoolPrereqs.size()) {
                    prereq = doc.createElement("prereq");
                    prereq.setAttribute("prereqstepreference", schoolPrereqs.get(x2));
                    schoolStepPrereqs.appendChild(prereq);
                    ++x2;
                }
                dissertation.appendChild(schoolStepPrereqs);
            }
            this.m_properties.toXml(doc, stack);
            stack.pop();
            return dissertation;
        }

        public String getId() {
            return this.m_id;
        }

        public String getUrl() {
            return BaseDissertationService.this.getAccessPoint(false) + this.m_id;
        }

        public String getReference() {
            return BaseDissertationService.this.dissertationReference(this.m_site, this.m_id);
        }

        public ResourceProperties getProperties() {
            return this.m_properties;
        }

        public String getStepReferenceByOrder(String order) {
            if (order == null) {
                return null;
            }
            return (String)this.m_orderedSteps.get(order);
        }

        public Hashtable getOrderedSteps() {
            return this.m_orderedSteps;
        }

        public String getOrderForStep(String stepReference) {
            String retVal = null;
            if (stepReference != null) {
                String key = null;
                String value = null;
                Enumeration keys = this.m_orderedSteps.keys();
                while (keys.hasMoreElements()) {
                    key = (String)keys.nextElement();
                    value = (String)this.m_orderedSteps.get(key);
                    if (!stepReference.equals(value)) continue;
                    retVal = key;
                }
            }
            return retVal;
        }

        public String getSite() {
            return this.m_site;
        }

        public FlexStringArray getSchoolPrereqs(String schoolStepReference) {
            FlexStringArray retVal = null;
            retVal = (FlexStringArray)this.m_schoolStepPrereqs.get(schoolStepReference);
            if (retVal == null) {
                retVal = new FlexStringArray();
            }
            return retVal;
        }

        public String getPrerequisiteStepsDisplayString(DissertationStep step) {
            StringBuffer retVal = new StringBuffer();
            if (step != null) {
                String keyString = "";
                String stepReference = "";
                boolean firstAdded = true;
                boolean addToString = false;
                FlexStringArray deptAddedPrereqs = (FlexStringArray)this.m_schoolStepPrereqs.get(step.getReference());
                int x = 1;
                while (x < this.m_orderedSteps.size() + 1) {
                    addToString = false;
                    keyString = "" + x;
                    stepReference = (String)this.m_orderedSteps.get(keyString);
                    if (step.hasPrerequisiteStep(stepReference)) {
                        addToString = true;
                    } else if (deptAddedPrereqs != null && deptAddedPrereqs.contains(stepReference)) {
                        addToString = true;
                    }
                    if (addToString) {
                        if (firstAdded) {
                            retVal.append(keyString);
                            firstAdded = false;
                        } else {
                            retVal.append(", " + keyString);
                        }
                    }
                    ++x;
                }
            }
            return retVal.toString();
        }

        public void initializeCandidatePath(CandidatePathEdit candidatePath, String siteString) {
            Hashtable<String, String> stepToStatus = new Hashtable<String, String>();
            FlexStringArray stepPrereqs = null;
            FlexStringArray statusPrereqs = null;
            FlexStringArray schoolPrereqStatus = null;
            FlexStringArray schoolPrereqSteps = null;
            String keyString = null;
            String stepId = null;
            String stepReference = null;
            String statusId = null;
            String statusReference = null;
            String tempStatusReference = null;
            DissertationStep aStep = null;
            StepStatusEdit aStatus = null;
            Hashtable<String, String> orderedStatus = new Hashtable<String, String>();
            Hashtable<String, FlexStringArray> schoolPrereqs = new Hashtable<String, FlexStringArray>();
            StepStatusEdit stepStatus = null;
            Enumeration keys = null;
            boolean oardStep = false;
            int x = 1;
            while (x < this.m_orderedSteps.size() + 1) {
                oardStep = false;
                keyString = "" + x;
                try {
                    stepReference = (String)this.m_orderedSteps.get(keyString);
                    stepId = BaseDissertationService.this.stepId(stepReference);
                    aStep = BaseDissertationService.this.m_stepStorage.get(stepId);
                    stepStatus = BaseDissertationService.this.addStepStatusFromListener(siteString, aStep, oardStep);
                    orderedStatus.put(keyString, stepStatus.getReference());
                    stepToStatus.put(stepReference, stepStatus.getReference());
                    BaseDissertationService.this.commitEdit(stepStatus);
                }
                catch (Exception e) {
                    Log.warn("chef", "DISSERTATION : BASE SERVICE : BASE DISS : initializeCandidatePath : EXCEPTION : " + e);
                }
                ++x;
            }
            candidatePath.setOrderedStatus(orderedStatus);
            keys = this.m_orderedSteps.keys();
            while (keys.hasMoreElements()) {
                statusPrereqs = new FlexStringArray();
                keyString = (String)keys.nextElement();
                try {
                    schoolPrereqStatus = new FlexStringArray();
                    stepReference = (String)this.m_orderedSteps.get(keyString);
                    stepId = BaseDissertationService.this.stepId(stepReference);
                    aStep = BaseDissertationService.this.m_stepStorage.get(stepId);
                    statusReference = candidatePath.getStatusReferenceByOrder(keyString);
                    schoolPrereqSteps = this.getSchoolPrereqs(aStep.getReference());
                    int y = 0;
                    while (y < schoolPrereqSteps.size()) {
                        tempStatusReference = (String)stepToStatus.get(schoolPrereqSteps.get(y));
                        schoolPrereqStatus.add(tempStatusReference);
                        ++y;
                    }
                    if (schoolPrereqStatus.size() > 0) {
                        schoolPrereqs.put(statusReference, schoolPrereqStatus);
                    }
                    statusId = BaseDissertationService.this.statusId(statusReference);
                    aStatus = BaseDissertationService.this.m_statusStorage.edit(statusId);
                    stepPrereqs = aStep.getPrerequisiteStepReferences();
                    int x2 = 0;
                    while (x2 < stepPrereqs.size()) {
                        statusReference = (String)stepToStatus.get(stepPrereqs.get(x2));
                        statusPrereqs.add(statusReference);
                        ++x2;
                    }
                    aStatus.setPrereqs(statusPrereqs);
                    BaseDissertationService.this.commitEdit(aStatus);
                }
                catch (Exception e) {
                    Log.warn("chef", "DISSERTATION : BASE SERVICE : BASE DISS : initializeCandidatePath : EXCEPTION : " + e);
                }
            }
            candidatePath.setSchoolPrereqs(schoolPrereqs);
            candidatePath.setSite(siteString);
        }

        public String getCreator() {
            return this.m_properties.getProperty("CHEF:creator");
        }

        public String getAuthorLastModified() {
            return this.m_properties.getProperty("CHEF:modifiedby");
        }

        public Time getTimeLastModified() {
            return this.m_timeLastModified;
        }

        public Hashtable getSchoolStepPrereqs() {
            return this.m_schoolStepPrereqs;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Dissertation)) {
                return false;
            }
            return ((Dissertation)obj).getId().equals(this.getId());
        }

        public int compareTo(Object obj) {
            if (!(obj instanceof Dissertation)) {
                throw new ClassCastException();
            }
            if (obj == this) {
                return 0;
            }
            int compare = this.getSite().compareTo(((Dissertation)obj).getSite());
            if (compare == 0) {
                compare = this.getId().compareTo(((Dissertation)obj).getId());
            }
            return compare;
        }
    }
}

