/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.notification.ris;

import com.sourceforge.knecs.dsm.resourceobject.IUserService;
import com.sourceforge.knecs.dsm.resourceobject.RISException;
import com.sourceforge.knecs.dsm.resourceobject.ResourceObject;
import com.sourceforge.knecs.dsm.resourceobject.User;
import com.sourceforge.knecs.notification.ris.JMSRISService;
import com.sourceforge.knecs.util.CMCSProperties;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class JMSRISUserService
extends JMSRISService
implements IUserService {
    private static String CLASSNAME = "com.sourceforge.knecs.dsm.resourceobject.User";
    private static Vector mClassNames = new Vector();

    public JMSRISUserService(String serviceURL) {
        super(serviceURL, mClassNames);
    }

    public synchronized Vector getURLFilters() {
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        String svr = props.getProperty("samserver");
        String path = props.getProperty("portalobjects");
        String users = props.getProperty("users");
        Vector<String> ret = new Vector<String>();
        ret.add("%" + path + "/" + users + "%");
        return ret;
    }

    public void logAllUsers() {
        try {
            User[] tmp = this.getUsers();
            if (tmp != null) {
                for (int idx = 0; idx < tmp.length; ++idx) {
                    this.mLogger.info("User-> " + tmp[idx]);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public User[] getUsers() throws IOException {
        Collection objects = this.getAllResourceObjects(CLASSNAME);
        Iterator it = objects.iterator();
        User[] ret = new User[objects.size()];
        int idx = 0;
        while (it.hasNext()) {
            ret[idx++] = (User)it.next();
        }
        return ret;
    }

    public User getUser(String owner) throws IOException {
        User ret = null;
        Collection objects = this.getResourceObjectsByOwner(owner, CLASSNAME);
        if (objects != null && objects.size() > 0) {
            Iterator it = objects.iterator();
            ret = (User)it.next();
        }
        return ret;
    }

    public void addUser(User data) throws IOException {
        try {
            this.save(data);
        }
        catch (RISException risex) {
            this.mLogger.severe("Unable to save user " + risex.getMessage());
            throw new IOException(risex.getMessage());
        }
    }

    public boolean deleteUser(User data) throws IOException {
        try {
            this.remove(data);
        }
        catch (RISException risex) {
            this.mLogger.severe("Unable to remove User " + risex.getMessage());
            throw new IOException(risex.getMessage());
        }
        return true;
    }

    public String save(ResourceObject obj) throws RISException {
        if (obj.getId() == null || obj.getId().equals("")) {
            String owner = new String(obj.getOwnerId());
            owner = "user-" + owner + ".txt";
            this.mLogger.info("trying to save user with id: " + owner);
            obj.setId(owner);
        }
        return super.save(obj);
    }

    static {
        mClassNames.add(CLASSNAME);
    }
}

