from typing import Dict

from typing import overload
import mrpt.pymrpt.mrpt.config
import mrpt.pymrpt.mrpt.math
import mrpt.pymrpt.mrpt.poses
import mrpt.pymrpt.mrpt.slam
import mrpt.pymrpt.std.chrono

class BaseAppDataSource:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: BaseAppDataSource) -> None: ...
    def assign(self) -> BaseAppDataSource: ...

class BaseAppInitializableCLI:
    def __init__(self, *args, **kwargs) -> None: ...
    def assign(self) -> BaseAppInitializableCLI: ...

class DataSourceRawlog(BaseAppDataSource):
    def __init__(self) -> None: ...

class ICP_SLAM_App_Base(BaseAppInitializableCLI, BaseAppDataSource):
    out_estimated_path: Dict[mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t,mrpt.pymrpt.mrpt.math.TPose3D]
    params: mrpt.pymrpt.mrpt.config.CConfigFileMemory
    quits_with_esc_key: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def assign(self) -> ICP_SLAM_App_Base: ...
    @overload
    def run(self) -> None: ...
    @overload
    def run() -> void: ...

class ICP_SLAM_App_Live(ICP_SLAM_App_Base):
    def __init__(self) -> None: ...

class ICP_SLAM_App_Rawlog(ICP_SLAM_App_Base, DataSourceRawlog):
    def __init__(self) -> None: ...

class KFSLAMApp:
    loc_error_wrt_gt: float
    params: mrpt.pymrpt.mrpt.config.CConfigFileMemory
    rawlogFileName: str
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: KFSLAMApp) -> None: ...
    def assign(self) -> KFSLAMApp: ...
    @overload
    def run(self) -> None: ...
    @overload
    def run() -> void: ...

class MonteCarloLocalization_Base(BaseAppInitializableCLI, BaseAppDataSource):
    allow_quit_on_esc_key: bool
    fill_out_estimated_path: bool
    out_estimated_path: mrpt.pymrpt.mrpt.poses.CPose3DInterpolator
    params: mrpt.pymrpt.mrpt.config.CConfigFileMemory
    def __init__(self, *args, **kwargs) -> None: ...
    def assign(self) -> MonteCarloLocalization_Base: ...
    @overload
    def run(self) -> None: ...
    @overload
    def run() -> void: ...

class MonteCarloLocalization_Rawlog(MonteCarloLocalization_Base, DataSourceRawlog):
    def __init__(self) -> None: ...

class RBPF_SLAM_App_Base(BaseAppInitializableCLI, BaseAppDataSource):
    mapBuilder: mrpt.pymrpt.mrpt.slam.CMetricMapBuilderRBPF
    out_estimated_path: Dict[mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t,mrpt.pymrpt.mrpt.math.TPose3D]
    params: mrpt.pymrpt.mrpt.config.CConfigFileMemory
    quits_with_esc_key: bool
    def __init__(self, *args, **kwargs) -> None: ...
    def assign(self) -> RBPF_SLAM_App_Base: ...
    @overload
    def run(self) -> None: ...
    @overload
    def run() -> void: ...

class RBPF_SLAM_App_Rawlog(RBPF_SLAM_App_Base, DataSourceRawlog):
    def __init__(self) -> None: ...
    def init(self, iniConfigFile: str, rawlogFile: str) -> None: ...

class RawlogEditApp:
    def __init__(self) -> None: ...

class RawlogGrabberApp:
    params: mrpt.pymrpt.mrpt.config.CConfigFileMemory
    rawlog_filename: str
    rawlog_saved_objects: int
    run_for_seconds: float
    show_sensor_thread_exceptions: bool
    def __init__(self) -> None: ...
    @overload
    def SensorThread(self, sensor_label: str) -> None: ...
    @overload
    def SensorThread(std) -> void: ...
    @overload
    def isRunning(self) -> bool: ...
    @overload
    def isRunning() -> bool: ...
    @overload
    def run(self) -> None: ...
    @overload
    def run() -> void: ...
