/*
 * Copyright 2023 Advanced Micro Devices, Inc.
 *
 * SPDX-License-Identifier: MIT
 */

#include "nir_opt_varyings_test.h"

class nir_opt_varyings_test_dead_output : public nir_opt_varyings_test
{};

#define TEST_DEAD_OUTPUT_REMOVED(producer_stage, consumer_stage, slot, bitsize) \
TEST_F(nir_opt_varyings_test_dead_output, \
       store_##producer_stage##_##consumer_stage##_##slot##_##bitsize) \
{ \
   create_shaders(MESA_SHADER_##producer_stage, MESA_SHADER_##consumer_stage); \
   nir_intrinsic_instr *intr = \
      store_output(b1, VARYING_SLOT_##slot, 0, nir_type_float##bitsize, \
                   nir_imm_floatN_t(b1, 0, bitsize), 0); \
   \
   ASSERT_TRUE(opt_varyings() == nir_progress_producer); \
   ASSERT_TRUE(b1->shader->info.outputs_written == 0 && \
               b1->shader->info.patch_outputs_written == 0 && \
               b1->shader->info.outputs_written_16bit == 0); \
   ASSERT_TRUE(!shader_contains_instr(b1, &intr->instr)); \
}

#define TEST_DEAD_OUTPUT_KEPT(producer_stage, consumer_stage, slot, bitsize) \
TEST_F(nir_opt_varyings_test_dead_output, \
       store_##producer_stage##_##consumer_stage##_##slot##_##bitsize) \
{ \
   create_shaders(MESA_SHADER_##producer_stage, MESA_SHADER_##consumer_stage); \
   nir_intrinsic_instr *intr = \
      store_output(b1, VARYING_SLOT_##slot, 0, nir_type_float##bitsize, \
                   nir_imm_floatN_t(b1, 0, bitsize), 0); \
   \
   ASSERT_TRUE(opt_varyings() == 0); \
   ASSERT_TRUE(b1->shader->info.outputs_written == VARYING_BIT_##slot); \
   ASSERT_TRUE(shader_contains_instr(b1, &intr->instr)); \
   ASSERT_TRUE(nir_intrinsic_io_semantics(intr).no_varying == \
               (VARYING_SLOT_##slot != VARYING_SLOT_POS && \
                VARYING_SLOT_##slot != VARYING_SLOT_PSIZ && \
                VARYING_SLOT_##slot != VARYING_SLOT_CLIP_VERTEX && \
                /* RADV mesh multiview workaround */ \
                (MESA_SHADER_##producer_stage != MESA_SHADER_MESH || VARYING_SLOT_##slot != VARYING_SLOT_LAYER))); \
}

#define TEST_DEAD_OUTPUT_KEPT_XFB(producer_stage, consumer_stage, slot, bitsize) \
TEST_F(nir_opt_varyings_test_dead_output, \
       xfb_store_##producer_stage##_##consumer_stage##_##slot##_##bitsize) \
{ \
   create_shaders(MESA_SHADER_##producer_stage, MESA_SHADER_##consumer_stage); \
   nir_intrinsic_instr *intr = \
      store_output(b1, VARYING_SLOT_##slot, 0, nir_type_float##bitsize, \
                   nir_imm_floatN_t(b1, 0, bitsize), 0); \
   \
   struct nir_io_xfb xfb; \
   memset(&xfb, 0, sizeof(xfb)); \
   xfb.out[0].num_components = 1; \
   nir_intrinsic_set_io_xfb(intr, xfb); \
   \
   /* Compaction moves COL1 to COL0. */ \
   unsigned index = VARYING_SLOT_##slot; \
   if (index == VARYING_SLOT_COL1 || index == VARYING_SLOT_BFC1) \
      index--; \
   \
   /* Compaction moves all these to VAR0. */ \
   /* It's correct for TEX0 because it's not used by FS. */ \
   if (index == VARYING_SLOT_FOGC || index == VARYING_SLOT_PRIMITIVE_ID || \
       index == VARYING_SLOT_TEX0 || index == VARYING_SLOT_VAR0_16BIT) \
      index = VARYING_SLOT_VAR0; \
   \
   ASSERT_TRUE(opt_varyings() == 0); \
   if (index >= VARYING_SLOT_VAR0_16BIT) { \
      ASSERT_TRUE(b1->shader->info.outputs_written_16bit == \
                  BITFIELD_BIT(index - VARYING_SLOT_VAR0_16BIT)); \
   } else { \
      ASSERT_TRUE(b1->shader->info.outputs_written == BITFIELD64_BIT(index)); \
   } \
   ASSERT_TRUE(shader_contains_instr(b1, &intr->instr)); \
   ASSERT_TRUE(nir_intrinsic_io_semantics(intr).no_varying == \
               (VARYING_SLOT_##slot != VARYING_SLOT_POS && \
                VARYING_SLOT_##slot != VARYING_SLOT_PSIZ && \
                VARYING_SLOT_##slot != VARYING_SLOT_CLIP_VERTEX)); \
   ASSERT_TRUE(nir_intrinsic_io_xfb(intr).out[0].num_components == 1); \
}

#define TEST_DEAD_OUTPUT_LOAD_TO_UNDEF(producer_stage, consumer_stage, slot, bitsize) \
TEST_F(nir_opt_varyings_test_dead_output, \
       load_##producer_stage##_##consumer_stage##_##slot##_##bitsize) \
{ \
   create_shaders(MESA_SHADER_##producer_stage, MESA_SHADER_##consumer_stage); \
   nir_def *output = load_output(b1, VARYING_SLOT_##slot, 0, nir_type_float##bitsize, 0); \
   store_ssbo(b1, output); \
   \
   ASSERT_TRUE(opt_varyings() == nir_progress_producer); \
   ASSERT_TRUE(b1->shader->info.outputs_read == 0 && \
               b1->shader->info.patch_outputs_read == 0 && \
               b1->shader->info.outputs_read_16bit == 0); \
   ASSERT_TRUE(!shader_contains_def(b1, output)); \
   ASSERT_TRUE(shader_contains_undef(b1, bitsize)); \
}

TEST_DEAD_OUTPUT_REMOVED(VERTEX, TESS_CTRL, POS, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, TESS_CTRL, COL0, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, TESS_CTRL, COL1, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, TESS_CTRL, FOGC, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, TESS_CTRL, TEX0, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, TESS_CTRL, PSIZ, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, TESS_CTRL, BFC0, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, TESS_CTRL, BFC1, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, TESS_CTRL, CLIP_VERTEX, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, TESS_CTRL, CLIP_DIST0, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, TESS_CTRL, CLIP_DIST1, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, TESS_CTRL, CULL_DIST0, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, TESS_CTRL, CULL_DIST1, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, TESS_CTRL, LAYER, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, TESS_CTRL, VIEWPORT, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, TESS_CTRL, VAR0, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, TESS_CTRL, VAR0, 16)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, TESS_CTRL, VAR0_16BIT, 16)

TEST_DEAD_OUTPUT_REMOVED(VERTEX, TESS_EVAL, POS, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, TESS_EVAL, COL0, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, TESS_EVAL, COL1, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, TESS_EVAL, FOGC, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, TESS_EVAL, TEX0, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, TESS_EVAL, PSIZ, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, TESS_EVAL, BFC0, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, TESS_EVAL, BFC1, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, TESS_EVAL, CLIP_VERTEX, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, TESS_EVAL, CLIP_DIST0, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, TESS_EVAL, CLIP_DIST1, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, TESS_EVAL, CULL_DIST0, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, TESS_EVAL, CULL_DIST1, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, TESS_EVAL, LAYER, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, TESS_EVAL, VIEWPORT, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, TESS_EVAL, VAR0, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, TESS_EVAL, VAR0, 16)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, TESS_EVAL, VAR0_16BIT, 16)

TEST_DEAD_OUTPUT_REMOVED(TESS_CTRL, TESS_EVAL, POS, 32)
TEST_DEAD_OUTPUT_REMOVED(TESS_CTRL, TESS_EVAL, COL0, 32)
TEST_DEAD_OUTPUT_REMOVED(TESS_CTRL, TESS_EVAL, COL1, 32)
TEST_DEAD_OUTPUT_REMOVED(TESS_CTRL, TESS_EVAL, FOGC, 32)
TEST_DEAD_OUTPUT_REMOVED(TESS_CTRL, TESS_EVAL, TEX0, 32)
TEST_DEAD_OUTPUT_REMOVED(TESS_CTRL, TESS_EVAL, PSIZ, 32)
TEST_DEAD_OUTPUT_REMOVED(TESS_CTRL, TESS_EVAL, BFC0, 32)
TEST_DEAD_OUTPUT_REMOVED(TESS_CTRL, TESS_EVAL, BFC1, 32)
TEST_DEAD_OUTPUT_REMOVED(TESS_CTRL, TESS_EVAL, CLIP_VERTEX, 32)
TEST_DEAD_OUTPUT_REMOVED(TESS_CTRL, TESS_EVAL, CLIP_DIST0, 32)
TEST_DEAD_OUTPUT_REMOVED(TESS_CTRL, TESS_EVAL, CLIP_DIST1, 32)
TEST_DEAD_OUTPUT_REMOVED(TESS_CTRL, TESS_EVAL, CULL_DIST0, 32)
TEST_DEAD_OUTPUT_REMOVED(TESS_CTRL, TESS_EVAL, CULL_DIST1, 32)
TEST_DEAD_OUTPUT_REMOVED(TESS_CTRL, TESS_EVAL, LAYER, 32)
TEST_DEAD_OUTPUT_REMOVED(TESS_CTRL, TESS_EVAL, VIEWPORT, 32)
TEST_DEAD_OUTPUT_KEPT(TESS_CTRL, TESS_EVAL, TESS_LEVEL_INNER, 32)
TEST_DEAD_OUTPUT_KEPT(TESS_CTRL, TESS_EVAL, TESS_LEVEL_OUTER, 32)
TEST_DEAD_OUTPUT_REMOVED(TESS_CTRL, TESS_EVAL, VAR0, 32)
TEST_DEAD_OUTPUT_REMOVED(TESS_CTRL, TESS_EVAL, VAR0, 16)
TEST_DEAD_OUTPUT_REMOVED(TESS_CTRL, TESS_EVAL, VAR0_16BIT, 16)
TEST_DEAD_OUTPUT_REMOVED(TESS_CTRL, TESS_EVAL, PATCH0, 32)
TEST_DEAD_OUTPUT_REMOVED(TESS_CTRL, TESS_EVAL, PATCH0, 16)

TEST_DEAD_OUTPUT_LOAD_TO_UNDEF(TESS_CTRL, TESS_EVAL, POS, 32)
TEST_DEAD_OUTPUT_LOAD_TO_UNDEF(TESS_CTRL, TESS_EVAL, COL0, 32)
TEST_DEAD_OUTPUT_LOAD_TO_UNDEF(TESS_CTRL, TESS_EVAL, COL1, 32)
TEST_DEAD_OUTPUT_LOAD_TO_UNDEF(TESS_CTRL, TESS_EVAL, FOGC, 32)
TEST_DEAD_OUTPUT_LOAD_TO_UNDEF(TESS_CTRL, TESS_EVAL, TEX0, 32)
TEST_DEAD_OUTPUT_LOAD_TO_UNDEF(TESS_CTRL, TESS_EVAL, PSIZ, 32)
TEST_DEAD_OUTPUT_LOAD_TO_UNDEF(TESS_CTRL, TESS_EVAL, BFC0, 32)
TEST_DEAD_OUTPUT_LOAD_TO_UNDEF(TESS_CTRL, TESS_EVAL, BFC1, 32)
TEST_DEAD_OUTPUT_LOAD_TO_UNDEF(TESS_CTRL, TESS_EVAL, CLIP_VERTEX, 32)
TEST_DEAD_OUTPUT_LOAD_TO_UNDEF(TESS_CTRL, TESS_EVAL, CLIP_DIST0, 32)
TEST_DEAD_OUTPUT_LOAD_TO_UNDEF(TESS_CTRL, TESS_EVAL, CLIP_DIST1, 32)
TEST_DEAD_OUTPUT_LOAD_TO_UNDEF(TESS_CTRL, TESS_EVAL, CULL_DIST0, 32)
TEST_DEAD_OUTPUT_LOAD_TO_UNDEF(TESS_CTRL, TESS_EVAL, CULL_DIST1, 32)
TEST_DEAD_OUTPUT_LOAD_TO_UNDEF(TESS_CTRL, TESS_EVAL, LAYER, 32)
TEST_DEAD_OUTPUT_LOAD_TO_UNDEF(TESS_CTRL, TESS_EVAL, VIEWPORT, 32)
TEST_DEAD_OUTPUT_LOAD_TO_UNDEF(TESS_CTRL, TESS_EVAL, TESS_LEVEL_INNER, 32)
TEST_DEAD_OUTPUT_LOAD_TO_UNDEF(TESS_CTRL, TESS_EVAL, TESS_LEVEL_OUTER, 32)
TEST_DEAD_OUTPUT_LOAD_TO_UNDEF(TESS_CTRL, TESS_EVAL, VAR0, 32)
TEST_DEAD_OUTPUT_LOAD_TO_UNDEF(TESS_CTRL, TESS_EVAL, VAR0, 16)
TEST_DEAD_OUTPUT_LOAD_TO_UNDEF(TESS_CTRL, TESS_EVAL, VAR0_16BIT, 16)
TEST_DEAD_OUTPUT_LOAD_TO_UNDEF(TESS_CTRL, TESS_EVAL, PATCH0, 32)
TEST_DEAD_OUTPUT_LOAD_TO_UNDEF(TESS_CTRL, TESS_EVAL, PATCH0, 16)

TEST_DEAD_OUTPUT_REMOVED(VERTEX, GEOMETRY, POS, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, GEOMETRY, COL0, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, GEOMETRY, COL1, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, GEOMETRY, FOGC, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, GEOMETRY, TEX0, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, GEOMETRY, PSIZ, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, GEOMETRY, BFC0, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, GEOMETRY, BFC1, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, GEOMETRY, CLIP_VERTEX, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, GEOMETRY, CLIP_DIST0, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, GEOMETRY, CLIP_DIST1, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, GEOMETRY, CULL_DIST0, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, GEOMETRY, CULL_DIST1, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, GEOMETRY, LAYER, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, GEOMETRY, VIEWPORT, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, GEOMETRY, VAR0, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, GEOMETRY, VAR0, 16)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, GEOMETRY, VAR0_16BIT, 16)

TEST_DEAD_OUTPUT_REMOVED(TESS_EVAL, GEOMETRY, POS, 32)
TEST_DEAD_OUTPUT_REMOVED(TESS_EVAL, GEOMETRY, COL0, 32)
TEST_DEAD_OUTPUT_REMOVED(TESS_EVAL, GEOMETRY, COL1, 32)
TEST_DEAD_OUTPUT_REMOVED(TESS_EVAL, GEOMETRY, FOGC, 32)
TEST_DEAD_OUTPUT_REMOVED(TESS_EVAL, GEOMETRY, TEX0, 32)
TEST_DEAD_OUTPUT_REMOVED(TESS_EVAL, GEOMETRY, PSIZ, 32)
TEST_DEAD_OUTPUT_REMOVED(TESS_EVAL, GEOMETRY, BFC0, 32)
TEST_DEAD_OUTPUT_REMOVED(TESS_EVAL, GEOMETRY, BFC1, 32)
TEST_DEAD_OUTPUT_REMOVED(TESS_EVAL, GEOMETRY, CLIP_VERTEX, 32)
TEST_DEAD_OUTPUT_REMOVED(TESS_EVAL, GEOMETRY, CLIP_DIST0, 32)
TEST_DEAD_OUTPUT_REMOVED(TESS_EVAL, GEOMETRY, CLIP_DIST1, 32)
TEST_DEAD_OUTPUT_REMOVED(TESS_EVAL, GEOMETRY, CULL_DIST0, 32)
TEST_DEAD_OUTPUT_REMOVED(TESS_EVAL, GEOMETRY, CULL_DIST1, 32)
TEST_DEAD_OUTPUT_REMOVED(TESS_EVAL, GEOMETRY, LAYER, 32)
TEST_DEAD_OUTPUT_REMOVED(TESS_EVAL, GEOMETRY, VIEWPORT, 32)
TEST_DEAD_OUTPUT_REMOVED(TESS_EVAL, GEOMETRY, VAR0, 32)
TEST_DEAD_OUTPUT_REMOVED(TESS_EVAL, GEOMETRY, VAR0, 16)
TEST_DEAD_OUTPUT_REMOVED(TESS_EVAL, GEOMETRY, VAR0_16BIT, 16)

TEST_DEAD_OUTPUT_KEPT(VERTEX, FRAGMENT, POS, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, FRAGMENT, COL0, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, FRAGMENT, COL1, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, FRAGMENT, FOGC, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, FRAGMENT, TEX0, 32)
TEST_DEAD_OUTPUT_KEPT(VERTEX, FRAGMENT, PSIZ, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, FRAGMENT, BFC0, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, FRAGMENT, BFC1, 32)
TEST_DEAD_OUTPUT_KEPT(VERTEX, FRAGMENT, CLIP_VERTEX, 32)
TEST_DEAD_OUTPUT_KEPT(VERTEX, FRAGMENT, CLIP_DIST0, 32)
TEST_DEAD_OUTPUT_KEPT(VERTEX, FRAGMENT, CLIP_DIST1, 32)
TEST_DEAD_OUTPUT_KEPT(VERTEX, FRAGMENT, CULL_DIST0, 32)
TEST_DEAD_OUTPUT_KEPT(VERTEX, FRAGMENT, CULL_DIST1, 32)
TEST_DEAD_OUTPUT_KEPT(VERTEX, FRAGMENT, LAYER, 32)
TEST_DEAD_OUTPUT_KEPT(VERTEX, FRAGMENT, VIEWPORT, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, FRAGMENT, VAR0, 32)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, FRAGMENT, VAR0, 16)
TEST_DEAD_OUTPUT_REMOVED(VERTEX, FRAGMENT, VAR0_16BIT, 16)

TEST_DEAD_OUTPUT_KEPT(TESS_EVAL, FRAGMENT, POS, 32)
TEST_DEAD_OUTPUT_REMOVED(TESS_EVAL, FRAGMENT, COL0, 32)
TEST_DEAD_OUTPUT_REMOVED(TESS_EVAL, FRAGMENT, COL1, 32)
TEST_DEAD_OUTPUT_REMOVED(TESS_EVAL, FRAGMENT, FOGC, 32)
TEST_DEAD_OUTPUT_REMOVED(TESS_EVAL, FRAGMENT, TEX0, 32)
TEST_DEAD_OUTPUT_KEPT(TESS_EVAL, FRAGMENT, PSIZ, 32)
TEST_DEAD_OUTPUT_REMOVED(TESS_EVAL, FRAGMENT, BFC0, 32)
TEST_DEAD_OUTPUT_REMOVED(TESS_EVAL, FRAGMENT, BFC1, 32)
TEST_DEAD_OUTPUT_KEPT(TESS_EVAL, FRAGMENT, CLIP_VERTEX, 32)
TEST_DEAD_OUTPUT_KEPT(TESS_EVAL, FRAGMENT, CLIP_DIST0, 32)
TEST_DEAD_OUTPUT_KEPT(TESS_EVAL, FRAGMENT, CLIP_DIST1, 32)
TEST_DEAD_OUTPUT_KEPT(TESS_EVAL, FRAGMENT, CULL_DIST0, 32)
TEST_DEAD_OUTPUT_KEPT(TESS_EVAL, FRAGMENT, CULL_DIST1, 32)
TEST_DEAD_OUTPUT_KEPT(TESS_EVAL, FRAGMENT, LAYER, 32)
TEST_DEAD_OUTPUT_KEPT(TESS_EVAL, FRAGMENT, VIEWPORT, 32)
TEST_DEAD_OUTPUT_REMOVED(TESS_EVAL, FRAGMENT, VAR0, 32)
TEST_DEAD_OUTPUT_REMOVED(TESS_EVAL, FRAGMENT, VAR0, 16)
TEST_DEAD_OUTPUT_REMOVED(TESS_EVAL, FRAGMENT, VAR0_16BIT, 16)

TEST_DEAD_OUTPUT_KEPT(GEOMETRY, FRAGMENT, POS, 32)
TEST_DEAD_OUTPUT_REMOVED(GEOMETRY, FRAGMENT, COL0, 32)
TEST_DEAD_OUTPUT_REMOVED(GEOMETRY, FRAGMENT, COL1, 32)
TEST_DEAD_OUTPUT_REMOVED(GEOMETRY, FRAGMENT, FOGC, 32)
TEST_DEAD_OUTPUT_REMOVED(GEOMETRY, FRAGMENT, TEX0, 32)
TEST_DEAD_OUTPUT_KEPT(GEOMETRY, FRAGMENT, PSIZ, 32)
TEST_DEAD_OUTPUT_REMOVED(GEOMETRY, FRAGMENT, BFC0, 32)
TEST_DEAD_OUTPUT_REMOVED(GEOMETRY, FRAGMENT, BFC1, 32)
TEST_DEAD_OUTPUT_KEPT(GEOMETRY, FRAGMENT, CLIP_VERTEX, 32)
TEST_DEAD_OUTPUT_KEPT(GEOMETRY, FRAGMENT, CLIP_DIST0, 32)
TEST_DEAD_OUTPUT_KEPT(GEOMETRY, FRAGMENT, CLIP_DIST1, 32)
TEST_DEAD_OUTPUT_KEPT(GEOMETRY, FRAGMENT, CULL_DIST0, 32)
TEST_DEAD_OUTPUT_KEPT(GEOMETRY, FRAGMENT, CULL_DIST1, 32)
TEST_DEAD_OUTPUT_REMOVED(GEOMETRY, FRAGMENT, PRIMITIVE_ID, 32)
TEST_DEAD_OUTPUT_KEPT(GEOMETRY, FRAGMENT, LAYER, 32)
TEST_DEAD_OUTPUT_KEPT(GEOMETRY, FRAGMENT, VIEWPORT, 32)
TEST_DEAD_OUTPUT_REMOVED(GEOMETRY, FRAGMENT, VAR0, 32)
TEST_DEAD_OUTPUT_REMOVED(GEOMETRY, FRAGMENT, VAR0, 16)
TEST_DEAD_OUTPUT_REMOVED(GEOMETRY, FRAGMENT, VAR0_16BIT, 16)

TEST_DEAD_OUTPUT_KEPT_XFB(VERTEX, FRAGMENT, POS, 32)
TEST_DEAD_OUTPUT_KEPT_XFB(VERTEX, FRAGMENT, COL0, 32)
TEST_DEAD_OUTPUT_KEPT_XFB(VERTEX, FRAGMENT, COL1, 32)
TEST_DEAD_OUTPUT_KEPT_XFB(VERTEX, FRAGMENT, FOGC, 32)
TEST_DEAD_OUTPUT_KEPT_XFB(VERTEX, FRAGMENT, TEX0, 32)
TEST_DEAD_OUTPUT_KEPT_XFB(VERTEX, FRAGMENT, PSIZ, 32)
TEST_DEAD_OUTPUT_KEPT_XFB(VERTEX, FRAGMENT, BFC0, 32)
TEST_DEAD_OUTPUT_KEPT_XFB(VERTEX, FRAGMENT, BFC1, 32)
TEST_DEAD_OUTPUT_KEPT_XFB(VERTEX, FRAGMENT, CLIP_VERTEX, 32)
TEST_DEAD_OUTPUT_KEPT_XFB(VERTEX, FRAGMENT, CLIP_DIST0, 32)
TEST_DEAD_OUTPUT_KEPT_XFB(VERTEX, FRAGMENT, CLIP_DIST1, 32)
TEST_DEAD_OUTPUT_KEPT_XFB(VERTEX, FRAGMENT, CULL_DIST0, 32)
TEST_DEAD_OUTPUT_KEPT_XFB(VERTEX, FRAGMENT, CULL_DIST1, 32)
TEST_DEAD_OUTPUT_KEPT_XFB(VERTEX, FRAGMENT, LAYER, 32)
TEST_DEAD_OUTPUT_KEPT_XFB(VERTEX, FRAGMENT, VIEWPORT, 32)
TEST_DEAD_OUTPUT_KEPT_XFB(VERTEX, FRAGMENT, VAR0, 32)
TEST_DEAD_OUTPUT_KEPT_XFB(VERTEX, FRAGMENT, VAR0, 16)
TEST_DEAD_OUTPUT_KEPT_XFB(VERTEX, FRAGMENT, VAR0_16BIT, 16)

TEST_DEAD_OUTPUT_KEPT_XFB(TESS_EVAL, FRAGMENT, POS, 32)
TEST_DEAD_OUTPUT_KEPT_XFB(TESS_EVAL, FRAGMENT, COL0, 32)
TEST_DEAD_OUTPUT_KEPT_XFB(TESS_EVAL, FRAGMENT, COL1, 32)
TEST_DEAD_OUTPUT_KEPT_XFB(TESS_EVAL, FRAGMENT, FOGC, 32)
TEST_DEAD_OUTPUT_KEPT_XFB(TESS_EVAL, FRAGMENT, TEX0, 32)
TEST_DEAD_OUTPUT_KEPT_XFB(TESS_EVAL, FRAGMENT, PSIZ, 32)
TEST_DEAD_OUTPUT_KEPT_XFB(TESS_EVAL, FRAGMENT, BFC0, 32)
TEST_DEAD_OUTPUT_KEPT_XFB(TESS_EVAL, FRAGMENT, BFC1, 32)
TEST_DEAD_OUTPUT_KEPT_XFB(TESS_EVAL, FRAGMENT, CLIP_VERTEX, 32)
TEST_DEAD_OUTPUT_KEPT_XFB(TESS_EVAL, FRAGMENT, CLIP_DIST0, 32)
TEST_DEAD_OUTPUT_KEPT_XFB(TESS_EVAL, FRAGMENT, CLIP_DIST1, 32)
TEST_DEAD_OUTPUT_KEPT_XFB(TESS_EVAL, FRAGMENT, CULL_DIST0, 32)
TEST_DEAD_OUTPUT_KEPT_XFB(TESS_EVAL, FRAGMENT, CULL_DIST1, 32)
TEST_DEAD_OUTPUT_KEPT_XFB(TESS_EVAL, FRAGMENT, LAYER, 32)
TEST_DEAD_OUTPUT_KEPT_XFB(TESS_EVAL, FRAGMENT, VIEWPORT, 32)
TEST_DEAD_OUTPUT_KEPT_XFB(TESS_EVAL, FRAGMENT, VAR0, 32)
TEST_DEAD_OUTPUT_KEPT_XFB(TESS_EVAL, FRAGMENT, VAR0, 16)
TEST_DEAD_OUTPUT_KEPT_XFB(TESS_EVAL, FRAGMENT, VAR0_16BIT, 16)

TEST_DEAD_OUTPUT_KEPT_XFB(GEOMETRY, FRAGMENT, POS, 32)
TEST_DEAD_OUTPUT_KEPT_XFB(GEOMETRY, FRAGMENT, COL0, 32)
TEST_DEAD_OUTPUT_KEPT_XFB(GEOMETRY, FRAGMENT, COL1, 32)
TEST_DEAD_OUTPUT_KEPT_XFB(GEOMETRY, FRAGMENT, FOGC, 32)
TEST_DEAD_OUTPUT_KEPT_XFB(GEOMETRY, FRAGMENT, TEX0, 32)
TEST_DEAD_OUTPUT_KEPT_XFB(GEOMETRY, FRAGMENT, PSIZ, 32)
TEST_DEAD_OUTPUT_KEPT_XFB(GEOMETRY, FRAGMENT, BFC0, 32)
TEST_DEAD_OUTPUT_KEPT_XFB(GEOMETRY, FRAGMENT, BFC1, 32)
TEST_DEAD_OUTPUT_KEPT_XFB(GEOMETRY, FRAGMENT, CLIP_VERTEX, 32)
TEST_DEAD_OUTPUT_KEPT_XFB(GEOMETRY, FRAGMENT, CLIP_DIST0, 32)
TEST_DEAD_OUTPUT_KEPT_XFB(GEOMETRY, FRAGMENT, CLIP_DIST1, 32)
TEST_DEAD_OUTPUT_KEPT_XFB(GEOMETRY, FRAGMENT, CULL_DIST0, 32)
TEST_DEAD_OUTPUT_KEPT_XFB(GEOMETRY, FRAGMENT, CULL_DIST1, 32)
TEST_DEAD_OUTPUT_KEPT_XFB(GEOMETRY, FRAGMENT, PRIMITIVE_ID, 32)
TEST_DEAD_OUTPUT_KEPT_XFB(GEOMETRY, FRAGMENT, LAYER, 32)
TEST_DEAD_OUTPUT_KEPT_XFB(GEOMETRY, FRAGMENT, VIEWPORT, 32)
TEST_DEAD_OUTPUT_KEPT_XFB(GEOMETRY, FRAGMENT, VAR0, 32)
TEST_DEAD_OUTPUT_KEPT_XFB(GEOMETRY, FRAGMENT, VAR0, 16)
TEST_DEAD_OUTPUT_KEPT_XFB(GEOMETRY, FRAGMENT, VAR0_16BIT, 16)

TEST_DEAD_OUTPUT_KEPT(MESH, FRAGMENT, POS, 32)
TEST_DEAD_OUTPUT_KEPT(MESH, FRAGMENT, PSIZ, 32)
TEST_DEAD_OUTPUT_KEPT(MESH, FRAGMENT, CLIP_DIST0, 32)
TEST_DEAD_OUTPUT_KEPT(MESH, FRAGMENT, CLIP_DIST1, 32)
TEST_DEAD_OUTPUT_KEPT(MESH, FRAGMENT, CULL_DIST0, 32)
TEST_DEAD_OUTPUT_KEPT(MESH, FRAGMENT, CULL_DIST1, 32)
TEST_DEAD_OUTPUT_KEPT(MESH, FRAGMENT, LAYER, 32)
TEST_DEAD_OUTPUT_KEPT(MESH, FRAGMENT, VIEWPORT, 32)
TEST_DEAD_OUTPUT_REMOVED(MESH, FRAGMENT, VAR0, 32)
TEST_DEAD_OUTPUT_REMOVED(MESH, FRAGMENT, VAR0, 16)
TEST_DEAD_OUTPUT_REMOVED(MESH, FRAGMENT, VAR0_16BIT, 16)

}
