/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.lucene.analysis.standard;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.junit.Ignore;

/**
 * This class was automatically generated by generateEmojiTokenizationTest.pl
 * from: http://www.unicode.org/Public/emoji/11.0/emoji-test.txt
 *
 * emoji-test.txt contains emoji char sequences, which are represented as
 * tokenization tests in this class.
 * 
 */
@Ignore
public class EmojiTokenizationTestUnicode_11_0 extends BaseTokenStreamTestCase {

  public void test(Analyzer analyzer) throws Exception {
    for (int i = 0 ; i < tests.length ; i += 2) {
      String test = tests[i + 1];
      try {
        assertAnalyzesTo(analyzer, test, new String[] { test }, new String[] { "<EMOJI>" });
      } catch (Throwable t) {
        throw new Exception("Failed to tokenize \"" + tests[i] + "\":", t);        
      }
    }
  }

  private String[] tests = new String[] {
    "1F600                                      ; fully-qualified     # 😀 grinning face",
    "\uD83D\uDE00",

    "1F601                                      ; fully-qualified     # 😁 beaming face with smiling eyes",
    "\uD83D\uDE01",

    "1F602                                      ; fully-qualified     # 😂 face with tears of joy",
    "\uD83D\uDE02",

    "1F923                                      ; fully-qualified     # 🤣 rolling on the floor laughing",
    "\uD83E\uDD23",

    "1F603                                      ; fully-qualified     # 😃 grinning face with big eyes",
    "\uD83D\uDE03",

    "1F604                                      ; fully-qualified     # 😄 grinning face with smiling eyes",
    "\uD83D\uDE04",

    "1F605                                      ; fully-qualified     # 😅 grinning face with sweat",
    "\uD83D\uDE05",

    "1F606                                      ; fully-qualified     # 😆 grinning squinting face",
    "\uD83D\uDE06",

    "1F609                                      ; fully-qualified     # 😉 winking face",
    "\uD83D\uDE09",

    "1F60A                                      ; fully-qualified     # 😊 smiling face with smiling eyes",
    "\uD83D\uDE0A",

    "1F60B                                      ; fully-qualified     # 😋 face savoring food",
    "\uD83D\uDE0B",

    "1F60E                                      ; fully-qualified     # 😎 smiling face with sunglasses",
    "\uD83D\uDE0E",

    "1F60D                                      ; fully-qualified     # 😍 smiling face with heart-eyes",
    "\uD83D\uDE0D",

    "1F618                                      ; fully-qualified     # 😘 face blowing a kiss",
    "\uD83D\uDE18",

    "1F970                                      ; fully-qualified     # 🥰 smiling face with 3 hearts",
    "\uD83E\uDD70",

    "1F617                                      ; fully-qualified     # 😗 kissing face",
    "\uD83D\uDE17",

    "1F619                                      ; fully-qualified     # 😙 kissing face with smiling eyes",
    "\uD83D\uDE19",

    "1F61A                                      ; fully-qualified     # 😚 kissing face with closed eyes",
    "\uD83D\uDE1A",

    "263A FE0F                                  ; fully-qualified     # ☺️ smiling face",
    "\u263A\uFE0F",

    "263A                                       ; non-fully-qualified # ☺ smiling face",
    "\u263A",

    "1F642                                      ; fully-qualified     # 🙂 slightly smiling face",
    "\uD83D\uDE42",

    "1F917                                      ; fully-qualified     # 🤗 hugging face",
    "\uD83E\uDD17",

    "1F929                                      ; fully-qualified     # 🤩 star-struck",
    "\uD83E\uDD29",

    "1F914                                      ; fully-qualified     # 🤔 thinking face",
    "\uD83E\uDD14",

    "1F928                                      ; fully-qualified     # 🤨 face with raised eyebrow",
    "\uD83E\uDD28",

    "1F610                                      ; fully-qualified     # 😐 neutral face",
    "\uD83D\uDE10",

    "1F611                                      ; fully-qualified     # 😑 expressionless face",
    "\uD83D\uDE11",

    "1F636                                      ; fully-qualified     # 😶 face without mouth",
    "\uD83D\uDE36",

    "1F644                                      ; fully-qualified     # 🙄 face with rolling eyes",
    "\uD83D\uDE44",

    "1F60F                                      ; fully-qualified     # 😏 smirking face",
    "\uD83D\uDE0F",

    "1F623                                      ; fully-qualified     # 😣 persevering face",
    "\uD83D\uDE23",

    "1F625                                      ; fully-qualified     # 😥 sad but relieved face",
    "\uD83D\uDE25",

    "1F62E                                      ; fully-qualified     # 😮 face with open mouth",
    "\uD83D\uDE2E",

    "1F910                                      ; fully-qualified     # 🤐 zipper-mouth face",
    "\uD83E\uDD10",

    "1F62F                                      ; fully-qualified     # 😯 hushed face",
    "\uD83D\uDE2F",

    "1F62A                                      ; fully-qualified     # 😪 sleepy face",
    "\uD83D\uDE2A",

    "1F62B                                      ; fully-qualified     # 😫 tired face",
    "\uD83D\uDE2B",

    "1F634                                      ; fully-qualified     # 😴 sleeping face",
    "\uD83D\uDE34",

    "1F60C                                      ; fully-qualified     # 😌 relieved face",
    "\uD83D\uDE0C",

    "1F61B                                      ; fully-qualified     # 😛 face with tongue",
    "\uD83D\uDE1B",

    "1F61C                                      ; fully-qualified     # 😜 winking face with tongue",
    "\uD83D\uDE1C",

    "1F61D                                      ; fully-qualified     # 😝 squinting face with tongue",
    "\uD83D\uDE1D",

    "1F924                                      ; fully-qualified     # 🤤 drooling face",
    "\uD83E\uDD24",

    "1F612                                      ; fully-qualified     # 😒 unamused face",
    "\uD83D\uDE12",

    "1F613                                      ; fully-qualified     # 😓 downcast face with sweat",
    "\uD83D\uDE13",

    "1F614                                      ; fully-qualified     # 😔 pensive face",
    "\uD83D\uDE14",

    "1F615                                      ; fully-qualified     # 😕 confused face",
    "\uD83D\uDE15",

    "1F643                                      ; fully-qualified     # 🙃 upside-down face",
    "\uD83D\uDE43",

    "1F911                                      ; fully-qualified     # 🤑 money-mouth face",
    "\uD83E\uDD11",

    "1F632                                      ; fully-qualified     # 😲 astonished face",
    "\uD83D\uDE32",

    "2639 FE0F                                  ; fully-qualified     # ☹️ frowning face",
    "\u2639\uFE0F",

    "2639                                       ; non-fully-qualified # ☹ frowning face",
    "\u2639",

    "1F641                                      ; fully-qualified     # 🙁 slightly frowning face",
    "\uD83D\uDE41",

    "1F616                                      ; fully-qualified     # 😖 confounded face",
    "\uD83D\uDE16",

    "1F61E                                      ; fully-qualified     # 😞 disappointed face",
    "\uD83D\uDE1E",

    "1F61F                                      ; fully-qualified     # 😟 worried face",
    "\uD83D\uDE1F",

    "1F624                                      ; fully-qualified     # 😤 face with steam from nose",
    "\uD83D\uDE24",

    "1F622                                      ; fully-qualified     # 😢 crying face",
    "\uD83D\uDE22",

    "1F62D                                      ; fully-qualified     # 😭 loudly crying face",
    "\uD83D\uDE2D",

    "1F626                                      ; fully-qualified     # 😦 frowning face with open mouth",
    "\uD83D\uDE26",

    "1F627                                      ; fully-qualified     # 😧 anguished face",
    "\uD83D\uDE27",

    "1F628                                      ; fully-qualified     # 😨 fearful face",
    "\uD83D\uDE28",

    "1F629                                      ; fully-qualified     # 😩 weary face",
    "\uD83D\uDE29",

    "1F92F                                      ; fully-qualified     # 🤯 exploding head",
    "\uD83E\uDD2F",

    "1F62C                                      ; fully-qualified     # 😬 grimacing face",
    "\uD83D\uDE2C",

    "1F630                                      ; fully-qualified     # 😰 anxious face with sweat",
    "\uD83D\uDE30",

    "1F631                                      ; fully-qualified     # 😱 face screaming in fear",
    "\uD83D\uDE31",

    "1F975                                      ; fully-qualified     # 🥵 hot face",
    "\uD83E\uDD75",

    "1F976                                      ; fully-qualified     # 🥶 cold face",
    "\uD83E\uDD76",

    "1F633                                      ; fully-qualified     # 😳 flushed face",
    "\uD83D\uDE33",

    "1F92A                                      ; fully-qualified     # 🤪 zany face",
    "\uD83E\uDD2A",

    "1F635                                      ; fully-qualified     # 😵 dizzy face",
    "\uD83D\uDE35",

    "1F621                                      ; fully-qualified     # 😡 pouting face",
    "\uD83D\uDE21",

    "1F620                                      ; fully-qualified     # 😠 angry face",
    "\uD83D\uDE20",

    "1F92C                                      ; fully-qualified     # 🤬 face with symbols on mouth",
    "\uD83E\uDD2C",

    "1F637                                      ; fully-qualified     # 😷 face with medical mask",
    "\uD83D\uDE37",

    "1F912                                      ; fully-qualified     # 🤒 face with thermometer",
    "\uD83E\uDD12",

    "1F915                                      ; fully-qualified     # 🤕 face with head-bandage",
    "\uD83E\uDD15",

    "1F922                                      ; fully-qualified     # 🤢 nauseated face",
    "\uD83E\uDD22",

    "1F92E                                      ; fully-qualified     # 🤮 face vomiting",
    "\uD83E\uDD2E",

    "1F927                                      ; fully-qualified     # 🤧 sneezing face",
    "\uD83E\uDD27",

    "1F607                                      ; fully-qualified     # 😇 smiling face with halo",
    "\uD83D\uDE07",

    "1F920                                      ; fully-qualified     # 🤠 cowboy hat face",
    "\uD83E\uDD20",

    "1F973                                      ; fully-qualified     # 🥳 partying face",
    "\uD83E\uDD73",

    "1F974                                      ; fully-qualified     # 🥴 woozy face",
    "\uD83E\uDD74",

    "1F97A                                      ; fully-qualified     # 🥺 pleading face",
    "\uD83E\uDD7A",

    "1F925                                      ; fully-qualified     # 🤥 lying face",
    "\uD83E\uDD25",

    "1F92B                                      ; fully-qualified     # 🤫 shushing face",
    "\uD83E\uDD2B",

    "1F92D                                      ; fully-qualified     # 🤭 face with hand over mouth",
    "\uD83E\uDD2D",

    "1F9D0                                      ; fully-qualified     # 🧐 face with monocle",
    "\uD83E\uDDD0",

    "1F913                                      ; fully-qualified     # 🤓 nerd face",
    "\uD83E\uDD13",

    "1F608                                      ; fully-qualified     # 😈 smiling face with horns",
    "\uD83D\uDE08",

    "1F47F                                      ; fully-qualified     # 👿 angry face with horns",
    "\uD83D\uDC7F",

    "1F921                                      ; fully-qualified     # 🤡 clown face",
    "\uD83E\uDD21",

    "1F479                                      ; fully-qualified     # 👹 ogre",
    "\uD83D\uDC79",

    "1F47A                                      ; fully-qualified     # 👺 goblin",
    "\uD83D\uDC7A",

    "1F480                                      ; fully-qualified     # 💀 skull",
    "\uD83D\uDC80",

    "2620 FE0F                                  ; fully-qualified     # ☠️ skull and crossbones",
    "\u2620\uFE0F",

    "2620                                       ; non-fully-qualified # ☠ skull and crossbones",
    "\u2620",

    "1F47B                                      ; fully-qualified     # 👻 ghost",
    "\uD83D\uDC7B",

    "1F47D                                      ; fully-qualified     # 👽 alien",
    "\uD83D\uDC7D",

    "1F47E                                      ; fully-qualified     # 👾 alien monster",
    "\uD83D\uDC7E",

    "1F916                                      ; fully-qualified     # 🤖 robot face",
    "\uD83E\uDD16",

    "1F4A9                                      ; fully-qualified     # 💩 pile of poo",
    "\uD83D\uDCA9",

    "1F63A                                      ; fully-qualified     # 😺 grinning cat face",
    "\uD83D\uDE3A",

    "1F638                                      ; fully-qualified     # 😸 grinning cat face with smiling eyes",
    "\uD83D\uDE38",

    "1F639                                      ; fully-qualified     # 😹 cat face with tears of joy",
    "\uD83D\uDE39",

    "1F63B                                      ; fully-qualified     # 😻 smiling cat face with heart-eyes",
    "\uD83D\uDE3B",

    "1F63C                                      ; fully-qualified     # 😼 cat face with wry smile",
    "\uD83D\uDE3C",

    "1F63D                                      ; fully-qualified     # 😽 kissing cat face",
    "\uD83D\uDE3D",

    "1F640                                      ; fully-qualified     # 🙀 weary cat face",
    "\uD83D\uDE40",

    "1F63F                                      ; fully-qualified     # 😿 crying cat face",
    "\uD83D\uDE3F",

    "1F63E                                      ; fully-qualified     # 😾 pouting cat face",
    "\uD83D\uDE3E",

    "1F648                                      ; fully-qualified     # 🙈 see-no-evil monkey",
    "\uD83D\uDE48",

    "1F649                                      ; fully-qualified     # 🙉 hear-no-evil monkey",
    "\uD83D\uDE49",

    "1F64A                                      ; fully-qualified     # 🙊 speak-no-evil monkey",
    "\uD83D\uDE4A",

    "1F3FB                                      ; fully-qualified     # 🏻 light skin tone",
    "\uD83C\uDFFB",

    "1F3FC                                      ; fully-qualified     # 🏼 medium-light skin tone",
    "\uD83C\uDFFC",

    "1F3FD                                      ; fully-qualified     # 🏽 medium skin tone",
    "\uD83C\uDFFD",

    "1F3FE                                      ; fully-qualified     # 🏾 medium-dark skin tone",
    "\uD83C\uDFFE",

    "1F3FF                                      ; fully-qualified     # 🏿 dark skin tone",
    "\uD83C\uDFFF",

    "1F476                                      ; fully-qualified     # 👶 baby",
    "\uD83D\uDC76",

    "1F476 1F3FB                                ; fully-qualified     # 👶🏻 baby: light skin tone",
    "\uD83D\uDC76\uD83C\uDFFB",

    "1F476 1F3FC                                ; fully-qualified     # 👶🏼 baby: medium-light skin tone",
    "\uD83D\uDC76\uD83C\uDFFC",

    "1F476 1F3FD                                ; fully-qualified     # 👶🏽 baby: medium skin tone",
    "\uD83D\uDC76\uD83C\uDFFD",

    "1F476 1F3FE                                ; fully-qualified     # 👶🏾 baby: medium-dark skin tone",
    "\uD83D\uDC76\uD83C\uDFFE",

    "1F476 1F3FF                                ; fully-qualified     # 👶🏿 baby: dark skin tone",
    "\uD83D\uDC76\uD83C\uDFFF",

    "1F9D2                                      ; fully-qualified     # 🧒 child",
    "\uD83E\uDDD2",

    "1F9D2 1F3FB                                ; fully-qualified     # 🧒🏻 child: light skin tone",
    "\uD83E\uDDD2\uD83C\uDFFB",

    "1F9D2 1F3FC                                ; fully-qualified     # 🧒🏼 child: medium-light skin tone",
    "\uD83E\uDDD2\uD83C\uDFFC",

    "1F9D2 1F3FD                                ; fully-qualified     # 🧒🏽 child: medium skin tone",
    "\uD83E\uDDD2\uD83C\uDFFD",

    "1F9D2 1F3FE                                ; fully-qualified     # 🧒🏾 child: medium-dark skin tone",
    "\uD83E\uDDD2\uD83C\uDFFE",

    "1F9D2 1F3FF                                ; fully-qualified     # 🧒🏿 child: dark skin tone",
    "\uD83E\uDDD2\uD83C\uDFFF",

    "1F466                                      ; fully-qualified     # 👦 boy",
    "\uD83D\uDC66",

    "1F466 1F3FB                                ; fully-qualified     # 👦🏻 boy: light skin tone",
    "\uD83D\uDC66\uD83C\uDFFB",

    "1F466 1F3FC                                ; fully-qualified     # 👦🏼 boy: medium-light skin tone",
    "\uD83D\uDC66\uD83C\uDFFC",

    "1F466 1F3FD                                ; fully-qualified     # 👦🏽 boy: medium skin tone",
    "\uD83D\uDC66\uD83C\uDFFD",

    "1F466 1F3FE                                ; fully-qualified     # 👦🏾 boy: medium-dark skin tone",
    "\uD83D\uDC66\uD83C\uDFFE",

    "1F466 1F3FF                                ; fully-qualified     # 👦🏿 boy: dark skin tone",
    "\uD83D\uDC66\uD83C\uDFFF",

    "1F467                                      ; fully-qualified     # 👧 girl",
    "\uD83D\uDC67",

    "1F467 1F3FB                                ; fully-qualified     # 👧🏻 girl: light skin tone",
    "\uD83D\uDC67\uD83C\uDFFB",

    "1F467 1F3FC                                ; fully-qualified     # 👧🏼 girl: medium-light skin tone",
    "\uD83D\uDC67\uD83C\uDFFC",

    "1F467 1F3FD                                ; fully-qualified     # 👧🏽 girl: medium skin tone",
    "\uD83D\uDC67\uD83C\uDFFD",

    "1F467 1F3FE                                ; fully-qualified     # 👧🏾 girl: medium-dark skin tone",
    "\uD83D\uDC67\uD83C\uDFFE",

    "1F467 1F3FF                                ; fully-qualified     # 👧🏿 girl: dark skin tone",
    "\uD83D\uDC67\uD83C\uDFFF",

    "1F9D1                                      ; fully-qualified     # 🧑 adult",
    "\uD83E\uDDD1",

    "1F9D1 1F3FB                                ; fully-qualified     # 🧑🏻 adult: light skin tone",
    "\uD83E\uDDD1\uD83C\uDFFB",

    "1F9D1 1F3FC                                ; fully-qualified     # 🧑🏼 adult: medium-light skin tone",
    "\uD83E\uDDD1\uD83C\uDFFC",

    "1F9D1 1F3FD                                ; fully-qualified     # 🧑🏽 adult: medium skin tone",
    "\uD83E\uDDD1\uD83C\uDFFD",

    "1F9D1 1F3FE                                ; fully-qualified     # 🧑🏾 adult: medium-dark skin tone",
    "\uD83E\uDDD1\uD83C\uDFFE",

    "1F9D1 1F3FF                                ; fully-qualified     # 🧑🏿 adult: dark skin tone",
    "\uD83E\uDDD1\uD83C\uDFFF",

    "1F468                                      ; fully-qualified     # 👨 man",
    "\uD83D\uDC68",

    "1F468 1F3FB                                ; fully-qualified     # 👨🏻 man: light skin tone",
    "\uD83D\uDC68\uD83C\uDFFB",

    "1F468 1F3FC                                ; fully-qualified     # 👨🏼 man: medium-light skin tone",
    "\uD83D\uDC68\uD83C\uDFFC",

    "1F468 1F3FD                                ; fully-qualified     # 👨🏽 man: medium skin tone",
    "\uD83D\uDC68\uD83C\uDFFD",

    "1F468 1F3FE                                ; fully-qualified     # 👨🏾 man: medium-dark skin tone",
    "\uD83D\uDC68\uD83C\uDFFE",

    "1F468 1F3FF                                ; fully-qualified     # 👨🏿 man: dark skin tone",
    "\uD83D\uDC68\uD83C\uDFFF",

    "1F469                                      ; fully-qualified     # 👩 woman",
    "\uD83D\uDC69",

    "1F469 1F3FB                                ; fully-qualified     # 👩🏻 woman: light skin tone",
    "\uD83D\uDC69\uD83C\uDFFB",

    "1F469 1F3FC                                ; fully-qualified     # 👩🏼 woman: medium-light skin tone",
    "\uD83D\uDC69\uD83C\uDFFC",

    "1F469 1F3FD                                ; fully-qualified     # 👩🏽 woman: medium skin tone",
    "\uD83D\uDC69\uD83C\uDFFD",

    "1F469 1F3FE                                ; fully-qualified     # 👩🏾 woman: medium-dark skin tone",
    "\uD83D\uDC69\uD83C\uDFFE",

    "1F469 1F3FF                                ; fully-qualified     # 👩🏿 woman: dark skin tone",
    "\uD83D\uDC69\uD83C\uDFFF",

    "1F9D3                                      ; fully-qualified     # 🧓 older adult",
    "\uD83E\uDDD3",

    "1F9D3 1F3FB                                ; fully-qualified     # 🧓🏻 older adult: light skin tone",
    "\uD83E\uDDD3\uD83C\uDFFB",

    "1F9D3 1F3FC                                ; fully-qualified     # 🧓🏼 older adult: medium-light skin tone",
    "\uD83E\uDDD3\uD83C\uDFFC",

    "1F9D3 1F3FD                                ; fully-qualified     # 🧓🏽 older adult: medium skin tone",
    "\uD83E\uDDD3\uD83C\uDFFD",

    "1F9D3 1F3FE                                ; fully-qualified     # 🧓🏾 older adult: medium-dark skin tone",
    "\uD83E\uDDD3\uD83C\uDFFE",

    "1F9D3 1F3FF                                ; fully-qualified     # 🧓🏿 older adult: dark skin tone",
    "\uD83E\uDDD3\uD83C\uDFFF",

    "1F474                                      ; fully-qualified     # 👴 old man",
    "\uD83D\uDC74",

    "1F474 1F3FB                                ; fully-qualified     # 👴🏻 old man: light skin tone",
    "\uD83D\uDC74\uD83C\uDFFB",

    "1F474 1F3FC                                ; fully-qualified     # 👴🏼 old man: medium-light skin tone",
    "\uD83D\uDC74\uD83C\uDFFC",

    "1F474 1F3FD                                ; fully-qualified     # 👴🏽 old man: medium skin tone",
    "\uD83D\uDC74\uD83C\uDFFD",

    "1F474 1F3FE                                ; fully-qualified     # 👴🏾 old man: medium-dark skin tone",
    "\uD83D\uDC74\uD83C\uDFFE",

    "1F474 1F3FF                                ; fully-qualified     # 👴🏿 old man: dark skin tone",
    "\uD83D\uDC74\uD83C\uDFFF",

    "1F475                                      ; fully-qualified     # 👵 old woman",
    "\uD83D\uDC75",

    "1F475 1F3FB                                ; fully-qualified     # 👵🏻 old woman: light skin tone",
    "\uD83D\uDC75\uD83C\uDFFB",

    "1F475 1F3FC                                ; fully-qualified     # 👵🏼 old woman: medium-light skin tone",
    "\uD83D\uDC75\uD83C\uDFFC",

    "1F475 1F3FD                                ; fully-qualified     # 👵🏽 old woman: medium skin tone",
    "\uD83D\uDC75\uD83C\uDFFD",

    "1F475 1F3FE                                ; fully-qualified     # 👵🏾 old woman: medium-dark skin tone",
    "\uD83D\uDC75\uD83C\uDFFE",

    "1F475 1F3FF                                ; fully-qualified     # 👵🏿 old woman: dark skin tone",
    "\uD83D\uDC75\uD83C\uDFFF",

    "1F468 200D 2695 FE0F                       ; fully-qualified     # 👨‍⚕️ man health worker",
    "\uD83D\uDC68\u200D\u2695\uFE0F",

    "1F468 200D 2695                            ; non-fully-qualified # 👨‍⚕ man health worker",
    "\uD83D\uDC68\u200D\u2695",

    "1F468 1F3FB 200D 2695 FE0F                 ; fully-qualified     # 👨🏻‍⚕️ man health worker: light skin tone",
    "\uD83D\uDC68\uD83C\uDFFB\u200D\u2695\uFE0F",

    "1F468 1F3FB 200D 2695                      ; non-fully-qualified # 👨🏻‍⚕ man health worker: light skin tone",
    "\uD83D\uDC68\uD83C\uDFFB\u200D\u2695",

    "1F468 1F3FC 200D 2695 FE0F                 ; fully-qualified     # 👨🏼‍⚕️ man health worker: medium-light skin tone",
    "\uD83D\uDC68\uD83C\uDFFC\u200D\u2695\uFE0F",

    "1F468 1F3FC 200D 2695                      ; non-fully-qualified # 👨🏼‍⚕ man health worker: medium-light skin tone",
    "\uD83D\uDC68\uD83C\uDFFC\u200D\u2695",

    "1F468 1F3FD 200D 2695 FE0F                 ; fully-qualified     # 👨🏽‍⚕️ man health worker: medium skin tone",
    "\uD83D\uDC68\uD83C\uDFFD\u200D\u2695\uFE0F",

    "1F468 1F3FD 200D 2695                      ; non-fully-qualified # 👨🏽‍⚕ man health worker: medium skin tone",
    "\uD83D\uDC68\uD83C\uDFFD\u200D\u2695",

    "1F468 1F3FE 200D 2695 FE0F                 ; fully-qualified     # 👨🏾‍⚕️ man health worker: medium-dark skin tone",
    "\uD83D\uDC68\uD83C\uDFFE\u200D\u2695\uFE0F",

    "1F468 1F3FE 200D 2695                      ; non-fully-qualified # 👨🏾‍⚕ man health worker: medium-dark skin tone",
    "\uD83D\uDC68\uD83C\uDFFE\u200D\u2695",

    "1F468 1F3FF 200D 2695 FE0F                 ; fully-qualified     # 👨🏿‍⚕️ man health worker: dark skin tone",
    "\uD83D\uDC68\uD83C\uDFFF\u200D\u2695\uFE0F",

    "1F468 1F3FF 200D 2695                      ; non-fully-qualified # 👨🏿‍⚕ man health worker: dark skin tone",
    "\uD83D\uDC68\uD83C\uDFFF\u200D\u2695",

    "1F469 200D 2695 FE0F                       ; fully-qualified     # 👩‍⚕️ woman health worker",
    "\uD83D\uDC69\u200D\u2695\uFE0F",

    "1F469 200D 2695                            ; non-fully-qualified # 👩‍⚕ woman health worker",
    "\uD83D\uDC69\u200D\u2695",

    "1F469 1F3FB 200D 2695 FE0F                 ; fully-qualified     # 👩🏻‍⚕️ woman health worker: light skin tone",
    "\uD83D\uDC69\uD83C\uDFFB\u200D\u2695\uFE0F",

    "1F469 1F3FB 200D 2695                      ; non-fully-qualified # 👩🏻‍⚕ woman health worker: light skin tone",
    "\uD83D\uDC69\uD83C\uDFFB\u200D\u2695",

    "1F469 1F3FC 200D 2695 FE0F                 ; fully-qualified     # 👩🏼‍⚕️ woman health worker: medium-light skin tone",
    "\uD83D\uDC69\uD83C\uDFFC\u200D\u2695\uFE0F",

    "1F469 1F3FC 200D 2695                      ; non-fully-qualified # 👩🏼‍⚕ woman health worker: medium-light skin tone",
    "\uD83D\uDC69\uD83C\uDFFC\u200D\u2695",

    "1F469 1F3FD 200D 2695 FE0F                 ; fully-qualified     # 👩🏽‍⚕️ woman health worker: medium skin tone",
    "\uD83D\uDC69\uD83C\uDFFD\u200D\u2695\uFE0F",

    "1F469 1F3FD 200D 2695                      ; non-fully-qualified # 👩🏽‍⚕ woman health worker: medium skin tone",
    "\uD83D\uDC69\uD83C\uDFFD\u200D\u2695",

    "1F469 1F3FE 200D 2695 FE0F                 ; fully-qualified     # 👩🏾‍⚕️ woman health worker: medium-dark skin tone",
    "\uD83D\uDC69\uD83C\uDFFE\u200D\u2695\uFE0F",

    "1F469 1F3FE 200D 2695                      ; non-fully-qualified # 👩🏾‍⚕ woman health worker: medium-dark skin tone",
    "\uD83D\uDC69\uD83C\uDFFE\u200D\u2695",

    "1F469 1F3FF 200D 2695 FE0F                 ; fully-qualified     # 👩🏿‍⚕️ woman health worker: dark skin tone",
    "\uD83D\uDC69\uD83C\uDFFF\u200D\u2695\uFE0F",

    "1F469 1F3FF 200D 2695                      ; non-fully-qualified # 👩🏿‍⚕ woman health worker: dark skin tone",
    "\uD83D\uDC69\uD83C\uDFFF\u200D\u2695",

    "1F468 200D 1F393                           ; fully-qualified     # 👨‍🎓 man student",
    "\uD83D\uDC68\u200D\uD83C\uDF93",

    "1F468 1F3FB 200D 1F393                     ; fully-qualified     # 👨🏻‍🎓 man student: light skin tone",
    "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83C\uDF93",

    "1F468 1F3FC 200D 1F393                     ; fully-qualified     # 👨🏼‍🎓 man student: medium-light skin tone",
    "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83C\uDF93",

    "1F468 1F3FD 200D 1F393                     ; fully-qualified     # 👨🏽‍🎓 man student: medium skin tone",
    "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83C\uDF93",

    "1F468 1F3FE 200D 1F393                     ; fully-qualified     # 👨🏾‍🎓 man student: medium-dark skin tone",
    "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83C\uDF93",

    "1F468 1F3FF 200D 1F393                     ; fully-qualified     # 👨🏿‍🎓 man student: dark skin tone",
    "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83C\uDF93",

    "1F469 200D 1F393                           ; fully-qualified     # 👩‍🎓 woman student",
    "\uD83D\uDC69\u200D\uD83C\uDF93",

    "1F469 1F3FB 200D 1F393                     ; fully-qualified     # 👩🏻‍🎓 woman student: light skin tone",
    "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83C\uDF93",

    "1F469 1F3FC 200D 1F393                     ; fully-qualified     # 👩🏼‍🎓 woman student: medium-light skin tone",
    "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83C\uDF93",

    "1F469 1F3FD 200D 1F393                     ; fully-qualified     # 👩🏽‍🎓 woman student: medium skin tone",
    "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83C\uDF93",

    "1F469 1F3FE 200D 1F393                     ; fully-qualified     # 👩🏾‍🎓 woman student: medium-dark skin tone",
    "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83C\uDF93",

    "1F469 1F3FF 200D 1F393                     ; fully-qualified     # 👩🏿‍🎓 woman student: dark skin tone",
    "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83C\uDF93",

    "1F468 200D 1F3EB                           ; fully-qualified     # 👨‍🏫 man teacher",
    "\uD83D\uDC68\u200D\uD83C\uDFEB",

    "1F468 1F3FB 200D 1F3EB                     ; fully-qualified     # 👨🏻‍🏫 man teacher: light skin tone",
    "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83C\uDFEB",

    "1F468 1F3FC 200D 1F3EB                     ; fully-qualified     # 👨🏼‍🏫 man teacher: medium-light skin tone",
    "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83C\uDFEB",

    "1F468 1F3FD 200D 1F3EB                     ; fully-qualified     # 👨🏽‍🏫 man teacher: medium skin tone",
    "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83C\uDFEB",

    "1F468 1F3FE 200D 1F3EB                     ; fully-qualified     # 👨🏾‍🏫 man teacher: medium-dark skin tone",
    "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83C\uDFEB",

    "1F468 1F3FF 200D 1F3EB                     ; fully-qualified     # 👨🏿‍🏫 man teacher: dark skin tone",
    "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83C\uDFEB",

    "1F469 200D 1F3EB                           ; fully-qualified     # 👩‍🏫 woman teacher",
    "\uD83D\uDC69\u200D\uD83C\uDFEB",

    "1F469 1F3FB 200D 1F3EB                     ; fully-qualified     # 👩🏻‍🏫 woman teacher: light skin tone",
    "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83C\uDFEB",

    "1F469 1F3FC 200D 1F3EB                     ; fully-qualified     # 👩🏼‍🏫 woman teacher: medium-light skin tone",
    "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83C\uDFEB",

    "1F469 1F3FD 200D 1F3EB                     ; fully-qualified     # 👩🏽‍🏫 woman teacher: medium skin tone",
    "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83C\uDFEB",

    "1F469 1F3FE 200D 1F3EB                     ; fully-qualified     # 👩🏾‍🏫 woman teacher: medium-dark skin tone",
    "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83C\uDFEB",

    "1F469 1F3FF 200D 1F3EB                     ; fully-qualified     # 👩🏿‍🏫 woman teacher: dark skin tone",
    "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83C\uDFEB",

    "1F468 200D 2696 FE0F                       ; fully-qualified     # 👨‍⚖️ man judge",
    "\uD83D\uDC68\u200D\u2696\uFE0F",

    "1F468 200D 2696                            ; non-fully-qualified # 👨‍⚖ man judge",
    "\uD83D\uDC68\u200D\u2696",

    "1F468 1F3FB 200D 2696 FE0F                 ; fully-qualified     # 👨🏻‍⚖️ man judge: light skin tone",
    "\uD83D\uDC68\uD83C\uDFFB\u200D\u2696\uFE0F",

    "1F468 1F3FB 200D 2696                      ; non-fully-qualified # 👨🏻‍⚖ man judge: light skin tone",
    "\uD83D\uDC68\uD83C\uDFFB\u200D\u2696",

    "1F468 1F3FC 200D 2696 FE0F                 ; fully-qualified     # 👨🏼‍⚖️ man judge: medium-light skin tone",
    "\uD83D\uDC68\uD83C\uDFFC\u200D\u2696\uFE0F",

    "1F468 1F3FC 200D 2696                      ; non-fully-qualified # 👨🏼‍⚖ man judge: medium-light skin tone",
    "\uD83D\uDC68\uD83C\uDFFC\u200D\u2696",

    "1F468 1F3FD 200D 2696 FE0F                 ; fully-qualified     # 👨🏽‍⚖️ man judge: medium skin tone",
    "\uD83D\uDC68\uD83C\uDFFD\u200D\u2696\uFE0F",

    "1F468 1F3FD 200D 2696                      ; non-fully-qualified # 👨🏽‍⚖ man judge: medium skin tone",
    "\uD83D\uDC68\uD83C\uDFFD\u200D\u2696",

    "1F468 1F3FE 200D 2696 FE0F                 ; fully-qualified     # 👨🏾‍⚖️ man judge: medium-dark skin tone",
    "\uD83D\uDC68\uD83C\uDFFE\u200D\u2696\uFE0F",

    "1F468 1F3FE 200D 2696                      ; non-fully-qualified # 👨🏾‍⚖ man judge: medium-dark skin tone",
    "\uD83D\uDC68\uD83C\uDFFE\u200D\u2696",

    "1F468 1F3FF 200D 2696 FE0F                 ; fully-qualified     # 👨🏿‍⚖️ man judge: dark skin tone",
    "\uD83D\uDC68\uD83C\uDFFF\u200D\u2696\uFE0F",

    "1F468 1F3FF 200D 2696                      ; non-fully-qualified # 👨🏿‍⚖ man judge: dark skin tone",
    "\uD83D\uDC68\uD83C\uDFFF\u200D\u2696",

    "1F469 200D 2696 FE0F                       ; fully-qualified     # 👩‍⚖️ woman judge",
    "\uD83D\uDC69\u200D\u2696\uFE0F",

    "1F469 200D 2696                            ; non-fully-qualified # 👩‍⚖ woman judge",
    "\uD83D\uDC69\u200D\u2696",

    "1F469 1F3FB 200D 2696 FE0F                 ; fully-qualified     # 👩🏻‍⚖️ woman judge: light skin tone",
    "\uD83D\uDC69\uD83C\uDFFB\u200D\u2696\uFE0F",

    "1F469 1F3FB 200D 2696                      ; non-fully-qualified # 👩🏻‍⚖ woman judge: light skin tone",
    "\uD83D\uDC69\uD83C\uDFFB\u200D\u2696",

    "1F469 1F3FC 200D 2696 FE0F                 ; fully-qualified     # 👩🏼‍⚖️ woman judge: medium-light skin tone",
    "\uD83D\uDC69\uD83C\uDFFC\u200D\u2696\uFE0F",

    "1F469 1F3FC 200D 2696                      ; non-fully-qualified # 👩🏼‍⚖ woman judge: medium-light skin tone",
    "\uD83D\uDC69\uD83C\uDFFC\u200D\u2696",

    "1F469 1F3FD 200D 2696 FE0F                 ; fully-qualified     # 👩🏽‍⚖️ woman judge: medium skin tone",
    "\uD83D\uDC69\uD83C\uDFFD\u200D\u2696\uFE0F",

    "1F469 1F3FD 200D 2696                      ; non-fully-qualified # 👩🏽‍⚖ woman judge: medium skin tone",
    "\uD83D\uDC69\uD83C\uDFFD\u200D\u2696",

    "1F469 1F3FE 200D 2696 FE0F                 ; fully-qualified     # 👩🏾‍⚖️ woman judge: medium-dark skin tone",
    "\uD83D\uDC69\uD83C\uDFFE\u200D\u2696\uFE0F",

    "1F469 1F3FE 200D 2696                      ; non-fully-qualified # 👩🏾‍⚖ woman judge: medium-dark skin tone",
    "\uD83D\uDC69\uD83C\uDFFE\u200D\u2696",

    "1F469 1F3FF 200D 2696 FE0F                 ; fully-qualified     # 👩🏿‍⚖️ woman judge: dark skin tone",
    "\uD83D\uDC69\uD83C\uDFFF\u200D\u2696\uFE0F",

    "1F469 1F3FF 200D 2696                      ; non-fully-qualified # 👩🏿‍⚖ woman judge: dark skin tone",
    "\uD83D\uDC69\uD83C\uDFFF\u200D\u2696",

    "1F468 200D 1F33E                           ; fully-qualified     # 👨‍🌾 man farmer",
    "\uD83D\uDC68\u200D\uD83C\uDF3E",

    "1F468 1F3FB 200D 1F33E                     ; fully-qualified     # 👨🏻‍🌾 man farmer: light skin tone",
    "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83C\uDF3E",

    "1F468 1F3FC 200D 1F33E                     ; fully-qualified     # 👨🏼‍🌾 man farmer: medium-light skin tone",
    "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83C\uDF3E",

    "1F468 1F3FD 200D 1F33E                     ; fully-qualified     # 👨🏽‍🌾 man farmer: medium skin tone",
    "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83C\uDF3E",

    "1F468 1F3FE 200D 1F33E                     ; fully-qualified     # 👨🏾‍🌾 man farmer: medium-dark skin tone",
    "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83C\uDF3E",

    "1F468 1F3FF 200D 1F33E                     ; fully-qualified     # 👨🏿‍🌾 man farmer: dark skin tone",
    "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83C\uDF3E",

    "1F469 200D 1F33E                           ; fully-qualified     # 👩‍🌾 woman farmer",
    "\uD83D\uDC69\u200D\uD83C\uDF3E",

    "1F469 1F3FB 200D 1F33E                     ; fully-qualified     # 👩🏻‍🌾 woman farmer: light skin tone",
    "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83C\uDF3E",

    "1F469 1F3FC 200D 1F33E                     ; fully-qualified     # 👩🏼‍🌾 woman farmer: medium-light skin tone",
    "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83C\uDF3E",

    "1F469 1F3FD 200D 1F33E                     ; fully-qualified     # 👩🏽‍🌾 woman farmer: medium skin tone",
    "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83C\uDF3E",

    "1F469 1F3FE 200D 1F33E                     ; fully-qualified     # 👩🏾‍🌾 woman farmer: medium-dark skin tone",
    "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83C\uDF3E",

    "1F469 1F3FF 200D 1F33E                     ; fully-qualified     # 👩🏿‍🌾 woman farmer: dark skin tone",
    "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83C\uDF3E",

    "1F468 200D 1F373                           ; fully-qualified     # 👨‍🍳 man cook",
    "\uD83D\uDC68\u200D\uD83C\uDF73",

    "1F468 1F3FB 200D 1F373                     ; fully-qualified     # 👨🏻‍🍳 man cook: light skin tone",
    "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83C\uDF73",

    "1F468 1F3FC 200D 1F373                     ; fully-qualified     # 👨🏼‍🍳 man cook: medium-light skin tone",
    "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83C\uDF73",

    "1F468 1F3FD 200D 1F373                     ; fully-qualified     # 👨🏽‍🍳 man cook: medium skin tone",
    "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83C\uDF73",

    "1F468 1F3FE 200D 1F373                     ; fully-qualified     # 👨🏾‍🍳 man cook: medium-dark skin tone",
    "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83C\uDF73",

    "1F468 1F3FF 200D 1F373                     ; fully-qualified     # 👨🏿‍🍳 man cook: dark skin tone",
    "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83C\uDF73",

    "1F469 200D 1F373                           ; fully-qualified     # 👩‍🍳 woman cook",
    "\uD83D\uDC69\u200D\uD83C\uDF73",

    "1F469 1F3FB 200D 1F373                     ; fully-qualified     # 👩🏻‍🍳 woman cook: light skin tone",
    "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83C\uDF73",

    "1F469 1F3FC 200D 1F373                     ; fully-qualified     # 👩🏼‍🍳 woman cook: medium-light skin tone",
    "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83C\uDF73",

    "1F469 1F3FD 200D 1F373                     ; fully-qualified     # 👩🏽‍🍳 woman cook: medium skin tone",
    "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83C\uDF73",

    "1F469 1F3FE 200D 1F373                     ; fully-qualified     # 👩🏾‍🍳 woman cook: medium-dark skin tone",
    "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83C\uDF73",

    "1F469 1F3FF 200D 1F373                     ; fully-qualified     # 👩🏿‍🍳 woman cook: dark skin tone",
    "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83C\uDF73",

    "1F468 200D 1F527                           ; fully-qualified     # 👨‍🔧 man mechanic",
    "\uD83D\uDC68\u200D\uD83D\uDD27",

    "1F468 1F3FB 200D 1F527                     ; fully-qualified     # 👨🏻‍🔧 man mechanic: light skin tone",
    "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83D\uDD27",

    "1F468 1F3FC 200D 1F527                     ; fully-qualified     # 👨🏼‍🔧 man mechanic: medium-light skin tone",
    "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83D\uDD27",

    "1F468 1F3FD 200D 1F527                     ; fully-qualified     # 👨🏽‍🔧 man mechanic: medium skin tone",
    "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83D\uDD27",

    "1F468 1F3FE 200D 1F527                     ; fully-qualified     # 👨🏾‍🔧 man mechanic: medium-dark skin tone",
    "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83D\uDD27",

    "1F468 1F3FF 200D 1F527                     ; fully-qualified     # 👨🏿‍🔧 man mechanic: dark skin tone",
    "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83D\uDD27",

    "1F469 200D 1F527                           ; fully-qualified     # 👩‍🔧 woman mechanic",
    "\uD83D\uDC69\u200D\uD83D\uDD27",

    "1F469 1F3FB 200D 1F527                     ; fully-qualified     # 👩🏻‍🔧 woman mechanic: light skin tone",
    "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83D\uDD27",

    "1F469 1F3FC 200D 1F527                     ; fully-qualified     # 👩🏼‍🔧 woman mechanic: medium-light skin tone",
    "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83D\uDD27",

    "1F469 1F3FD 200D 1F527                     ; fully-qualified     # 👩🏽‍🔧 woman mechanic: medium skin tone",
    "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83D\uDD27",

    "1F469 1F3FE 200D 1F527                     ; fully-qualified     # 👩🏾‍🔧 woman mechanic: medium-dark skin tone",
    "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83D\uDD27",

    "1F469 1F3FF 200D 1F527                     ; fully-qualified     # 👩🏿‍🔧 woman mechanic: dark skin tone",
    "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83D\uDD27",

    "1F468 200D 1F3ED                           ; fully-qualified     # 👨‍🏭 man factory worker",
    "\uD83D\uDC68\u200D\uD83C\uDFED",

    "1F468 1F3FB 200D 1F3ED                     ; fully-qualified     # 👨🏻‍🏭 man factory worker: light skin tone",
    "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83C\uDFED",

    "1F468 1F3FC 200D 1F3ED                     ; fully-qualified     # 👨🏼‍🏭 man factory worker: medium-light skin tone",
    "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83C\uDFED",

    "1F468 1F3FD 200D 1F3ED                     ; fully-qualified     # 👨🏽‍🏭 man factory worker: medium skin tone",
    "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83C\uDFED",

    "1F468 1F3FE 200D 1F3ED                     ; fully-qualified     # 👨🏾‍🏭 man factory worker: medium-dark skin tone",
    "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83C\uDFED",

    "1F468 1F3FF 200D 1F3ED                     ; fully-qualified     # 👨🏿‍🏭 man factory worker: dark skin tone",
    "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83C\uDFED",

    "1F469 200D 1F3ED                           ; fully-qualified     # 👩‍🏭 woman factory worker",
    "\uD83D\uDC69\u200D\uD83C\uDFED",

    "1F469 1F3FB 200D 1F3ED                     ; fully-qualified     # 👩🏻‍🏭 woman factory worker: light skin tone",
    "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83C\uDFED",

    "1F469 1F3FC 200D 1F3ED                     ; fully-qualified     # 👩🏼‍🏭 woman factory worker: medium-light skin tone",
    "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83C\uDFED",

    "1F469 1F3FD 200D 1F3ED                     ; fully-qualified     # 👩🏽‍🏭 woman factory worker: medium skin tone",
    "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83C\uDFED",

    "1F469 1F3FE 200D 1F3ED                     ; fully-qualified     # 👩🏾‍🏭 woman factory worker: medium-dark skin tone",
    "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83C\uDFED",

    "1F469 1F3FF 200D 1F3ED                     ; fully-qualified     # 👩🏿‍🏭 woman factory worker: dark skin tone",
    "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83C\uDFED",

    "1F468 200D 1F4BC                           ; fully-qualified     # 👨‍💼 man office worker",
    "\uD83D\uDC68\u200D\uD83D\uDCBC",

    "1F468 1F3FB 200D 1F4BC                     ; fully-qualified     # 👨🏻‍💼 man office worker: light skin tone",
    "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83D\uDCBC",

    "1F468 1F3FC 200D 1F4BC                     ; fully-qualified     # 👨🏼‍💼 man office worker: medium-light skin tone",
    "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83D\uDCBC",

    "1F468 1F3FD 200D 1F4BC                     ; fully-qualified     # 👨🏽‍💼 man office worker: medium skin tone",
    "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83D\uDCBC",

    "1F468 1F3FE 200D 1F4BC                     ; fully-qualified     # 👨🏾‍💼 man office worker: medium-dark skin tone",
    "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83D\uDCBC",

    "1F468 1F3FF 200D 1F4BC                     ; fully-qualified     # 👨🏿‍💼 man office worker: dark skin tone",
    "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83D\uDCBC",

    "1F469 200D 1F4BC                           ; fully-qualified     # 👩‍💼 woman office worker",
    "\uD83D\uDC69\u200D\uD83D\uDCBC",

    "1F469 1F3FB 200D 1F4BC                     ; fully-qualified     # 👩🏻‍💼 woman office worker: light skin tone",
    "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83D\uDCBC",

    "1F469 1F3FC 200D 1F4BC                     ; fully-qualified     # 👩🏼‍💼 woman office worker: medium-light skin tone",
    "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83D\uDCBC",

    "1F469 1F3FD 200D 1F4BC                     ; fully-qualified     # 👩🏽‍💼 woman office worker: medium skin tone",
    "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83D\uDCBC",

    "1F469 1F3FE 200D 1F4BC                     ; fully-qualified     # 👩🏾‍💼 woman office worker: medium-dark skin tone",
    "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83D\uDCBC",

    "1F469 1F3FF 200D 1F4BC                     ; fully-qualified     # 👩🏿‍💼 woman office worker: dark skin tone",
    "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83D\uDCBC",

    "1F468 200D 1F52C                           ; fully-qualified     # 👨‍🔬 man scientist",
    "\uD83D\uDC68\u200D\uD83D\uDD2C",

    "1F468 1F3FB 200D 1F52C                     ; fully-qualified     # 👨🏻‍🔬 man scientist: light skin tone",
    "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83D\uDD2C",

    "1F468 1F3FC 200D 1F52C                     ; fully-qualified     # 👨🏼‍🔬 man scientist: medium-light skin tone",
    "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83D\uDD2C",

    "1F468 1F3FD 200D 1F52C                     ; fully-qualified     # 👨🏽‍🔬 man scientist: medium skin tone",
    "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83D\uDD2C",

    "1F468 1F3FE 200D 1F52C                     ; fully-qualified     # 👨🏾‍🔬 man scientist: medium-dark skin tone",
    "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83D\uDD2C",

    "1F468 1F3FF 200D 1F52C                     ; fully-qualified     # 👨🏿‍🔬 man scientist: dark skin tone",
    "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83D\uDD2C",

    "1F469 200D 1F52C                           ; fully-qualified     # 👩‍🔬 woman scientist",
    "\uD83D\uDC69\u200D\uD83D\uDD2C",

    "1F469 1F3FB 200D 1F52C                     ; fully-qualified     # 👩🏻‍🔬 woman scientist: light skin tone",
    "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83D\uDD2C",

    "1F469 1F3FC 200D 1F52C                     ; fully-qualified     # 👩🏼‍🔬 woman scientist: medium-light skin tone",
    "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83D\uDD2C",

    "1F469 1F3FD 200D 1F52C                     ; fully-qualified     # 👩🏽‍🔬 woman scientist: medium skin tone",
    "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83D\uDD2C",

    "1F469 1F3FE 200D 1F52C                     ; fully-qualified     # 👩🏾‍🔬 woman scientist: medium-dark skin tone",
    "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83D\uDD2C",

    "1F469 1F3FF 200D 1F52C                     ; fully-qualified     # 👩🏿‍🔬 woman scientist: dark skin tone",
    "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83D\uDD2C",

    "1F468 200D 1F4BB                           ; fully-qualified     # 👨‍💻 man technologist",
    "\uD83D\uDC68\u200D\uD83D\uDCBB",

    "1F468 1F3FB 200D 1F4BB                     ; fully-qualified     # 👨🏻‍💻 man technologist: light skin tone",
    "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83D\uDCBB",

    "1F468 1F3FC 200D 1F4BB                     ; fully-qualified     # 👨🏼‍💻 man technologist: medium-light skin tone",
    "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83D\uDCBB",

    "1F468 1F3FD 200D 1F4BB                     ; fully-qualified     # 👨🏽‍💻 man technologist: medium skin tone",
    "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83D\uDCBB",

    "1F468 1F3FE 200D 1F4BB                     ; fully-qualified     # 👨🏾‍💻 man technologist: medium-dark skin tone",
    "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83D\uDCBB",

    "1F468 1F3FF 200D 1F4BB                     ; fully-qualified     # 👨🏿‍💻 man technologist: dark skin tone",
    "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83D\uDCBB",

    "1F469 200D 1F4BB                           ; fully-qualified     # 👩‍💻 woman technologist",
    "\uD83D\uDC69\u200D\uD83D\uDCBB",

    "1F469 1F3FB 200D 1F4BB                     ; fully-qualified     # 👩🏻‍💻 woman technologist: light skin tone",
    "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83D\uDCBB",

    "1F469 1F3FC 200D 1F4BB                     ; fully-qualified     # 👩🏼‍💻 woman technologist: medium-light skin tone",
    "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83D\uDCBB",

    "1F469 1F3FD 200D 1F4BB                     ; fully-qualified     # 👩🏽‍💻 woman technologist: medium skin tone",
    "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83D\uDCBB",

    "1F469 1F3FE 200D 1F4BB                     ; fully-qualified     # 👩🏾‍💻 woman technologist: medium-dark skin tone",
    "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83D\uDCBB",

    "1F469 1F3FF 200D 1F4BB                     ; fully-qualified     # 👩🏿‍💻 woman technologist: dark skin tone",
    "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83D\uDCBB",

    "1F468 200D 1F3A4                           ; fully-qualified     # 👨‍🎤 man singer",
    "\uD83D\uDC68\u200D\uD83C\uDFA4",

    "1F468 1F3FB 200D 1F3A4                     ; fully-qualified     # 👨🏻‍🎤 man singer: light skin tone",
    "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83C\uDFA4",

    "1F468 1F3FC 200D 1F3A4                     ; fully-qualified     # 👨🏼‍🎤 man singer: medium-light skin tone",
    "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83C\uDFA4",

    "1F468 1F3FD 200D 1F3A4                     ; fully-qualified     # 👨🏽‍🎤 man singer: medium skin tone",
    "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83C\uDFA4",

    "1F468 1F3FE 200D 1F3A4                     ; fully-qualified     # 👨🏾‍🎤 man singer: medium-dark skin tone",
    "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83C\uDFA4",

    "1F468 1F3FF 200D 1F3A4                     ; fully-qualified     # 👨🏿‍🎤 man singer: dark skin tone",
    "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83C\uDFA4",

    "1F469 200D 1F3A4                           ; fully-qualified     # 👩‍🎤 woman singer",
    "\uD83D\uDC69\u200D\uD83C\uDFA4",

    "1F469 1F3FB 200D 1F3A4                     ; fully-qualified     # 👩🏻‍🎤 woman singer: light skin tone",
    "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83C\uDFA4",

    "1F469 1F3FC 200D 1F3A4                     ; fully-qualified     # 👩🏼‍🎤 woman singer: medium-light skin tone",
    "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83C\uDFA4",

    "1F469 1F3FD 200D 1F3A4                     ; fully-qualified     # 👩🏽‍🎤 woman singer: medium skin tone",
    "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83C\uDFA4",

    "1F469 1F3FE 200D 1F3A4                     ; fully-qualified     # 👩🏾‍🎤 woman singer: medium-dark skin tone",
    "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83C\uDFA4",

    "1F469 1F3FF 200D 1F3A4                     ; fully-qualified     # 👩🏿‍🎤 woman singer: dark skin tone",
    "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83C\uDFA4",

    "1F468 200D 1F3A8                           ; fully-qualified     # 👨‍🎨 man artist",
    "\uD83D\uDC68\u200D\uD83C\uDFA8",

    "1F468 1F3FB 200D 1F3A8                     ; fully-qualified     # 👨🏻‍🎨 man artist: light skin tone",
    "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83C\uDFA8",

    "1F468 1F3FC 200D 1F3A8                     ; fully-qualified     # 👨🏼‍🎨 man artist: medium-light skin tone",
    "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83C\uDFA8",

    "1F468 1F3FD 200D 1F3A8                     ; fully-qualified     # 👨🏽‍🎨 man artist: medium skin tone",
    "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83C\uDFA8",

    "1F468 1F3FE 200D 1F3A8                     ; fully-qualified     # 👨🏾‍🎨 man artist: medium-dark skin tone",
    "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83C\uDFA8",

    "1F468 1F3FF 200D 1F3A8                     ; fully-qualified     # 👨🏿‍🎨 man artist: dark skin tone",
    "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83C\uDFA8",

    "1F469 200D 1F3A8                           ; fully-qualified     # 👩‍🎨 woman artist",
    "\uD83D\uDC69\u200D\uD83C\uDFA8",

    "1F469 1F3FB 200D 1F3A8                     ; fully-qualified     # 👩🏻‍🎨 woman artist: light skin tone",
    "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83C\uDFA8",

    "1F469 1F3FC 200D 1F3A8                     ; fully-qualified     # 👩🏼‍🎨 woman artist: medium-light skin tone",
    "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83C\uDFA8",

    "1F469 1F3FD 200D 1F3A8                     ; fully-qualified     # 👩🏽‍🎨 woman artist: medium skin tone",
    "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83C\uDFA8",

    "1F469 1F3FE 200D 1F3A8                     ; fully-qualified     # 👩🏾‍🎨 woman artist: medium-dark skin tone",
    "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83C\uDFA8",

    "1F469 1F3FF 200D 1F3A8                     ; fully-qualified     # 👩🏿‍🎨 woman artist: dark skin tone",
    "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83C\uDFA8",

    "1F468 200D 2708 FE0F                       ; fully-qualified     # 👨‍✈️ man pilot",
    "\uD83D\uDC68\u200D\u2708\uFE0F",

    "1F468 200D 2708                            ; non-fully-qualified # 👨‍✈ man pilot",
    "\uD83D\uDC68\u200D\u2708",

    "1F468 1F3FB 200D 2708 FE0F                 ; fully-qualified     # 👨🏻‍✈️ man pilot: light skin tone",
    "\uD83D\uDC68\uD83C\uDFFB\u200D\u2708\uFE0F",

    "1F468 1F3FB 200D 2708                      ; non-fully-qualified # 👨🏻‍✈ man pilot: light skin tone",
    "\uD83D\uDC68\uD83C\uDFFB\u200D\u2708",

    "1F468 1F3FC 200D 2708 FE0F                 ; fully-qualified     # 👨🏼‍✈️ man pilot: medium-light skin tone",
    "\uD83D\uDC68\uD83C\uDFFC\u200D\u2708\uFE0F",

    "1F468 1F3FC 200D 2708                      ; non-fully-qualified # 👨🏼‍✈ man pilot: medium-light skin tone",
    "\uD83D\uDC68\uD83C\uDFFC\u200D\u2708",

    "1F468 1F3FD 200D 2708 FE0F                 ; fully-qualified     # 👨🏽‍✈️ man pilot: medium skin tone",
    "\uD83D\uDC68\uD83C\uDFFD\u200D\u2708\uFE0F",

    "1F468 1F3FD 200D 2708                      ; non-fully-qualified # 👨🏽‍✈ man pilot: medium skin tone",
    "\uD83D\uDC68\uD83C\uDFFD\u200D\u2708",

    "1F468 1F3FE 200D 2708 FE0F                 ; fully-qualified     # 👨🏾‍✈️ man pilot: medium-dark skin tone",
    "\uD83D\uDC68\uD83C\uDFFE\u200D\u2708\uFE0F",

    "1F468 1F3FE 200D 2708                      ; non-fully-qualified # 👨🏾‍✈ man pilot: medium-dark skin tone",
    "\uD83D\uDC68\uD83C\uDFFE\u200D\u2708",

    "1F468 1F3FF 200D 2708 FE0F                 ; fully-qualified     # 👨🏿‍✈️ man pilot: dark skin tone",
    "\uD83D\uDC68\uD83C\uDFFF\u200D\u2708\uFE0F",

    "1F468 1F3FF 200D 2708                      ; non-fully-qualified # 👨🏿‍✈ man pilot: dark skin tone",
    "\uD83D\uDC68\uD83C\uDFFF\u200D\u2708",

    "1F469 200D 2708 FE0F                       ; fully-qualified     # 👩‍✈️ woman pilot",
    "\uD83D\uDC69\u200D\u2708\uFE0F",

    "1F469 200D 2708                            ; non-fully-qualified # 👩‍✈ woman pilot",
    "\uD83D\uDC69\u200D\u2708",

    "1F469 1F3FB 200D 2708 FE0F                 ; fully-qualified     # 👩🏻‍✈️ woman pilot: light skin tone",
    "\uD83D\uDC69\uD83C\uDFFB\u200D\u2708\uFE0F",

    "1F469 1F3FB 200D 2708                      ; non-fully-qualified # 👩🏻‍✈ woman pilot: light skin tone",
    "\uD83D\uDC69\uD83C\uDFFB\u200D\u2708",

    "1F469 1F3FC 200D 2708 FE0F                 ; fully-qualified     # 👩🏼‍✈️ woman pilot: medium-light skin tone",
    "\uD83D\uDC69\uD83C\uDFFC\u200D\u2708\uFE0F",

    "1F469 1F3FC 200D 2708                      ; non-fully-qualified # 👩🏼‍✈ woman pilot: medium-light skin tone",
    "\uD83D\uDC69\uD83C\uDFFC\u200D\u2708",

    "1F469 1F3FD 200D 2708 FE0F                 ; fully-qualified     # 👩🏽‍✈️ woman pilot: medium skin tone",
    "\uD83D\uDC69\uD83C\uDFFD\u200D\u2708\uFE0F",

    "1F469 1F3FD 200D 2708                      ; non-fully-qualified # 👩🏽‍✈ woman pilot: medium skin tone",
    "\uD83D\uDC69\uD83C\uDFFD\u200D\u2708",

    "1F469 1F3FE 200D 2708 FE0F                 ; fully-qualified     # 👩🏾‍✈️ woman pilot: medium-dark skin tone",
    "\uD83D\uDC69\uD83C\uDFFE\u200D\u2708\uFE0F",

    "1F469 1F3FE 200D 2708                      ; non-fully-qualified # 👩🏾‍✈ woman pilot: medium-dark skin tone",
    "\uD83D\uDC69\uD83C\uDFFE\u200D\u2708",

    "1F469 1F3FF 200D 2708 FE0F                 ; fully-qualified     # 👩🏿‍✈️ woman pilot: dark skin tone",
    "\uD83D\uDC69\uD83C\uDFFF\u200D\u2708\uFE0F",

    "1F469 1F3FF 200D 2708                      ; non-fully-qualified # 👩🏿‍✈ woman pilot: dark skin tone",
    "\uD83D\uDC69\uD83C\uDFFF\u200D\u2708",

    "1F468 200D 1F680                           ; fully-qualified     # 👨‍🚀 man astronaut",
    "\uD83D\uDC68\u200D\uD83D\uDE80",

    "1F468 1F3FB 200D 1F680                     ; fully-qualified     # 👨🏻‍🚀 man astronaut: light skin tone",
    "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83D\uDE80",

    "1F468 1F3FC 200D 1F680                     ; fully-qualified     # 👨🏼‍🚀 man astronaut: medium-light skin tone",
    "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83D\uDE80",

    "1F468 1F3FD 200D 1F680                     ; fully-qualified     # 👨🏽‍🚀 man astronaut: medium skin tone",
    "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83D\uDE80",

    "1F468 1F3FE 200D 1F680                     ; fully-qualified     # 👨🏾‍🚀 man astronaut: medium-dark skin tone",
    "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83D\uDE80",

    "1F468 1F3FF 200D 1F680                     ; fully-qualified     # 👨🏿‍🚀 man astronaut: dark skin tone",
    "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83D\uDE80",

    "1F469 200D 1F680                           ; fully-qualified     # 👩‍🚀 woman astronaut",
    "\uD83D\uDC69\u200D\uD83D\uDE80",

    "1F469 1F3FB 200D 1F680                     ; fully-qualified     # 👩🏻‍🚀 woman astronaut: light skin tone",
    "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83D\uDE80",

    "1F469 1F3FC 200D 1F680                     ; fully-qualified     # 👩🏼‍🚀 woman astronaut: medium-light skin tone",
    "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83D\uDE80",

    "1F469 1F3FD 200D 1F680                     ; fully-qualified     # 👩🏽‍🚀 woman astronaut: medium skin tone",
    "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83D\uDE80",

    "1F469 1F3FE 200D 1F680                     ; fully-qualified     # 👩🏾‍🚀 woman astronaut: medium-dark skin tone",
    "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83D\uDE80",

    "1F469 1F3FF 200D 1F680                     ; fully-qualified     # 👩🏿‍🚀 woman astronaut: dark skin tone",
    "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83D\uDE80",

    "1F468 200D 1F692                           ; fully-qualified     # 👨‍🚒 man firefighter",
    "\uD83D\uDC68\u200D\uD83D\uDE92",

    "1F468 1F3FB 200D 1F692                     ; fully-qualified     # 👨🏻‍🚒 man firefighter: light skin tone",
    "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83D\uDE92",

    "1F468 1F3FC 200D 1F692                     ; fully-qualified     # 👨🏼‍🚒 man firefighter: medium-light skin tone",
    "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83D\uDE92",

    "1F468 1F3FD 200D 1F692                     ; fully-qualified     # 👨🏽‍🚒 man firefighter: medium skin tone",
    "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83D\uDE92",

    "1F468 1F3FE 200D 1F692                     ; fully-qualified     # 👨🏾‍🚒 man firefighter: medium-dark skin tone",
    "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83D\uDE92",

    "1F468 1F3FF 200D 1F692                     ; fully-qualified     # 👨🏿‍🚒 man firefighter: dark skin tone",
    "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83D\uDE92",

    "1F469 200D 1F692                           ; fully-qualified     # 👩‍🚒 woman firefighter",
    "\uD83D\uDC69\u200D\uD83D\uDE92",

    "1F469 1F3FB 200D 1F692                     ; fully-qualified     # 👩🏻‍🚒 woman firefighter: light skin tone",
    "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83D\uDE92",

    "1F469 1F3FC 200D 1F692                     ; fully-qualified     # 👩🏼‍🚒 woman firefighter: medium-light skin tone",
    "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83D\uDE92",

    "1F469 1F3FD 200D 1F692                     ; fully-qualified     # 👩🏽‍🚒 woman firefighter: medium skin tone",
    "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83D\uDE92",

    "1F469 1F3FE 200D 1F692                     ; fully-qualified     # 👩🏾‍🚒 woman firefighter: medium-dark skin tone",
    "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83D\uDE92",

    "1F469 1F3FF 200D 1F692                     ; fully-qualified     # 👩🏿‍🚒 woman firefighter: dark skin tone",
    "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83D\uDE92",

    "1F46E                                      ; fully-qualified     # 👮 police officer",
    "\uD83D\uDC6E",

    "1F46E 1F3FB                                ; fully-qualified     # 👮🏻 police officer: light skin tone",
    "\uD83D\uDC6E\uD83C\uDFFB",

    "1F46E 1F3FC                                ; fully-qualified     # 👮🏼 police officer: medium-light skin tone",
    "\uD83D\uDC6E\uD83C\uDFFC",

    "1F46E 1F3FD                                ; fully-qualified     # 👮🏽 police officer: medium skin tone",
    "\uD83D\uDC6E\uD83C\uDFFD",

    "1F46E 1F3FE                                ; fully-qualified     # 👮🏾 police officer: medium-dark skin tone",
    "\uD83D\uDC6E\uD83C\uDFFE",

    "1F46E 1F3FF                                ; fully-qualified     # 👮🏿 police officer: dark skin tone",
    "\uD83D\uDC6E\uD83C\uDFFF",

    "1F46E 200D 2642 FE0F                       ; fully-qualified     # 👮‍♂️ man police officer",
    "\uD83D\uDC6E\u200D\u2642\uFE0F",

    "1F46E 200D 2642                            ; non-fully-qualified # 👮‍♂ man police officer",
    "\uD83D\uDC6E\u200D\u2642",

    "1F46E 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 👮🏻‍♂️ man police officer: light skin tone",
    "\uD83D\uDC6E\uD83C\uDFFB\u200D\u2642\uFE0F",

    "1F46E 1F3FB 200D 2642                      ; non-fully-qualified # 👮🏻‍♂ man police officer: light skin tone",
    "\uD83D\uDC6E\uD83C\uDFFB\u200D\u2642",

    "1F46E 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 👮🏼‍♂️ man police officer: medium-light skin tone",
    "\uD83D\uDC6E\uD83C\uDFFC\u200D\u2642\uFE0F",

    "1F46E 1F3FC 200D 2642                      ; non-fully-qualified # 👮🏼‍♂ man police officer: medium-light skin tone",
    "\uD83D\uDC6E\uD83C\uDFFC\u200D\u2642",

    "1F46E 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 👮🏽‍♂️ man police officer: medium skin tone",
    "\uD83D\uDC6E\uD83C\uDFFD\u200D\u2642\uFE0F",

    "1F46E 1F3FD 200D 2642                      ; non-fully-qualified # 👮🏽‍♂ man police officer: medium skin tone",
    "\uD83D\uDC6E\uD83C\uDFFD\u200D\u2642",

    "1F46E 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 👮🏾‍♂️ man police officer: medium-dark skin tone",
    "\uD83D\uDC6E\uD83C\uDFFE\u200D\u2642\uFE0F",

    "1F46E 1F3FE 200D 2642                      ; non-fully-qualified # 👮🏾‍♂ man police officer: medium-dark skin tone",
    "\uD83D\uDC6E\uD83C\uDFFE\u200D\u2642",

    "1F46E 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 👮🏿‍♂️ man police officer: dark skin tone",
    "\uD83D\uDC6E\uD83C\uDFFF\u200D\u2642\uFE0F",

    "1F46E 1F3FF 200D 2642                      ; non-fully-qualified # 👮🏿‍♂ man police officer: dark skin tone",
    "\uD83D\uDC6E\uD83C\uDFFF\u200D\u2642",

    "1F46E 200D 2640 FE0F                       ; fully-qualified     # 👮‍♀️ woman police officer",
    "\uD83D\uDC6E\u200D\u2640\uFE0F",

    "1F46E 200D 2640                            ; non-fully-qualified # 👮‍♀ woman police officer",
    "\uD83D\uDC6E\u200D\u2640",

    "1F46E 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 👮🏻‍♀️ woman police officer: light skin tone",
    "\uD83D\uDC6E\uD83C\uDFFB\u200D\u2640\uFE0F",

    "1F46E 1F3FB 200D 2640                      ; non-fully-qualified # 👮🏻‍♀ woman police officer: light skin tone",
    "\uD83D\uDC6E\uD83C\uDFFB\u200D\u2640",

    "1F46E 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 👮🏼‍♀️ woman police officer: medium-light skin tone",
    "\uD83D\uDC6E\uD83C\uDFFC\u200D\u2640\uFE0F",

    "1F46E 1F3FC 200D 2640                      ; non-fully-qualified # 👮🏼‍♀ woman police officer: medium-light skin tone",
    "\uD83D\uDC6E\uD83C\uDFFC\u200D\u2640",

    "1F46E 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 👮🏽‍♀️ woman police officer: medium skin tone",
    "\uD83D\uDC6E\uD83C\uDFFD\u200D\u2640\uFE0F",

    "1F46E 1F3FD 200D 2640                      ; non-fully-qualified # 👮🏽‍♀ woman police officer: medium skin tone",
    "\uD83D\uDC6E\uD83C\uDFFD\u200D\u2640",

    "1F46E 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 👮🏾‍♀️ woman police officer: medium-dark skin tone",
    "\uD83D\uDC6E\uD83C\uDFFE\u200D\u2640\uFE0F",

    "1F46E 1F3FE 200D 2640                      ; non-fully-qualified # 👮🏾‍♀ woman police officer: medium-dark skin tone",
    "\uD83D\uDC6E\uD83C\uDFFE\u200D\u2640",

    "1F46E 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 👮🏿‍♀️ woman police officer: dark skin tone",
    "\uD83D\uDC6E\uD83C\uDFFF\u200D\u2640\uFE0F",

    "1F46E 1F3FF 200D 2640                      ; non-fully-qualified # 👮🏿‍♀ woman police officer: dark skin tone",
    "\uD83D\uDC6E\uD83C\uDFFF\u200D\u2640",

    "1F575 FE0F                                 ; fully-qualified     # 🕵️ detective",
    "\uD83D\uDD75\uFE0F",

    "1F575                                      ; non-fully-qualified # 🕵 detective",
    "\uD83D\uDD75",

    "1F575 1F3FB                                ; fully-qualified     # 🕵🏻 detective: light skin tone",
    "\uD83D\uDD75\uD83C\uDFFB",

    "1F575 1F3FC                                ; fully-qualified     # 🕵🏼 detective: medium-light skin tone",
    "\uD83D\uDD75\uD83C\uDFFC",

    "1F575 1F3FD                                ; fully-qualified     # 🕵🏽 detective: medium skin tone",
    "\uD83D\uDD75\uD83C\uDFFD",

    "1F575 1F3FE                                ; fully-qualified     # 🕵🏾 detective: medium-dark skin tone",
    "\uD83D\uDD75\uD83C\uDFFE",

    "1F575 1F3FF                                ; fully-qualified     # 🕵🏿 detective: dark skin tone",
    "\uD83D\uDD75\uD83C\uDFFF",

    "1F575 FE0F 200D 2642 FE0F                  ; fully-qualified     # 🕵️‍♂️ man detective",
    "\uD83D\uDD75\uFE0F\u200D\u2642\uFE0F",

    "1F575 200D 2642 FE0F                       ; non-fully-qualified # 🕵‍♂️ man detective",
    "\uD83D\uDD75\u200D\u2642\uFE0F",

    "1F575 FE0F 200D 2642                       ; non-fully-qualified # 🕵️‍♂ man detective",
    "\uD83D\uDD75\uFE0F\u200D\u2642",

    "1F575 200D 2642                            ; non-fully-qualified # 🕵‍♂ man detective",
    "\uD83D\uDD75\u200D\u2642",

    "1F575 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🕵🏻‍♂️ man detective: light skin tone",
    "\uD83D\uDD75\uD83C\uDFFB\u200D\u2642\uFE0F",

    "1F575 1F3FB 200D 2642                      ; non-fully-qualified # 🕵🏻‍♂ man detective: light skin tone",
    "\uD83D\uDD75\uD83C\uDFFB\u200D\u2642",

    "1F575 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🕵🏼‍♂️ man detective: medium-light skin tone",
    "\uD83D\uDD75\uD83C\uDFFC\u200D\u2642\uFE0F",

    "1F575 1F3FC 200D 2642                      ; non-fully-qualified # 🕵🏼‍♂ man detective: medium-light skin tone",
    "\uD83D\uDD75\uD83C\uDFFC\u200D\u2642",

    "1F575 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🕵🏽‍♂️ man detective: medium skin tone",
    "\uD83D\uDD75\uD83C\uDFFD\u200D\u2642\uFE0F",

    "1F575 1F3FD 200D 2642                      ; non-fully-qualified # 🕵🏽‍♂ man detective: medium skin tone",
    "\uD83D\uDD75\uD83C\uDFFD\u200D\u2642",

    "1F575 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🕵🏾‍♂️ man detective: medium-dark skin tone",
    "\uD83D\uDD75\uD83C\uDFFE\u200D\u2642\uFE0F",

    "1F575 1F3FE 200D 2642                      ; non-fully-qualified # 🕵🏾‍♂ man detective: medium-dark skin tone",
    "\uD83D\uDD75\uD83C\uDFFE\u200D\u2642",

    "1F575 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🕵🏿‍♂️ man detective: dark skin tone",
    "\uD83D\uDD75\uD83C\uDFFF\u200D\u2642\uFE0F",

    "1F575 1F3FF 200D 2642                      ; non-fully-qualified # 🕵🏿‍♂ man detective: dark skin tone",
    "\uD83D\uDD75\uD83C\uDFFF\u200D\u2642",

    "1F575 FE0F 200D 2640 FE0F                  ; fully-qualified     # 🕵️‍♀️ woman detective",
    "\uD83D\uDD75\uFE0F\u200D\u2640\uFE0F",

    "1F575 200D 2640 FE0F                       ; non-fully-qualified # 🕵‍♀️ woman detective",
    "\uD83D\uDD75\u200D\u2640\uFE0F",

    "1F575 FE0F 200D 2640                       ; non-fully-qualified # 🕵️‍♀ woman detective",
    "\uD83D\uDD75\uFE0F\u200D\u2640",

    "1F575 200D 2640                            ; non-fully-qualified # 🕵‍♀ woman detective",
    "\uD83D\uDD75\u200D\u2640",

    "1F575 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🕵🏻‍♀️ woman detective: light skin tone",
    "\uD83D\uDD75\uD83C\uDFFB\u200D\u2640\uFE0F",

    "1F575 1F3FB 200D 2640                      ; non-fully-qualified # 🕵🏻‍♀ woman detective: light skin tone",
    "\uD83D\uDD75\uD83C\uDFFB\u200D\u2640",

    "1F575 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🕵🏼‍♀️ woman detective: medium-light skin tone",
    "\uD83D\uDD75\uD83C\uDFFC\u200D\u2640\uFE0F",

    "1F575 1F3FC 200D 2640                      ; non-fully-qualified # 🕵🏼‍♀ woman detective: medium-light skin tone",
    "\uD83D\uDD75\uD83C\uDFFC\u200D\u2640",

    "1F575 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🕵🏽‍♀️ woman detective: medium skin tone",
    "\uD83D\uDD75\uD83C\uDFFD\u200D\u2640\uFE0F",

    "1F575 1F3FD 200D 2640                      ; non-fully-qualified # 🕵🏽‍♀ woman detective: medium skin tone",
    "\uD83D\uDD75\uD83C\uDFFD\u200D\u2640",

    "1F575 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🕵🏾‍♀️ woman detective: medium-dark skin tone",
    "\uD83D\uDD75\uD83C\uDFFE\u200D\u2640\uFE0F",

    "1F575 1F3FE 200D 2640                      ; non-fully-qualified # 🕵🏾‍♀ woman detective: medium-dark skin tone",
    "\uD83D\uDD75\uD83C\uDFFE\u200D\u2640",

    "1F575 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🕵🏿‍♀️ woman detective: dark skin tone",
    "\uD83D\uDD75\uD83C\uDFFF\u200D\u2640\uFE0F",

    "1F575 1F3FF 200D 2640                      ; non-fully-qualified # 🕵🏿‍♀ woman detective: dark skin tone",
    "\uD83D\uDD75\uD83C\uDFFF\u200D\u2640",

    "1F482                                      ; fully-qualified     # 💂 guard",
    "\uD83D\uDC82",

    "1F482 1F3FB                                ; fully-qualified     # 💂🏻 guard: light skin tone",
    "\uD83D\uDC82\uD83C\uDFFB",

    "1F482 1F3FC                                ; fully-qualified     # 💂🏼 guard: medium-light skin tone",
    "\uD83D\uDC82\uD83C\uDFFC",

    "1F482 1F3FD                                ; fully-qualified     # 💂🏽 guard: medium skin tone",
    "\uD83D\uDC82\uD83C\uDFFD",

    "1F482 1F3FE                                ; fully-qualified     # 💂🏾 guard: medium-dark skin tone",
    "\uD83D\uDC82\uD83C\uDFFE",

    "1F482 1F3FF                                ; fully-qualified     # 💂🏿 guard: dark skin tone",
    "\uD83D\uDC82\uD83C\uDFFF",

    "1F482 200D 2642 FE0F                       ; fully-qualified     # 💂‍♂️ man guard",
    "\uD83D\uDC82\u200D\u2642\uFE0F",

    "1F482 200D 2642                            ; non-fully-qualified # 💂‍♂ man guard",
    "\uD83D\uDC82\u200D\u2642",

    "1F482 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 💂🏻‍♂️ man guard: light skin tone",
    "\uD83D\uDC82\uD83C\uDFFB\u200D\u2642\uFE0F",

    "1F482 1F3FB 200D 2642                      ; non-fully-qualified # 💂🏻‍♂ man guard: light skin tone",
    "\uD83D\uDC82\uD83C\uDFFB\u200D\u2642",

    "1F482 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 💂🏼‍♂️ man guard: medium-light skin tone",
    "\uD83D\uDC82\uD83C\uDFFC\u200D\u2642\uFE0F",

    "1F482 1F3FC 200D 2642                      ; non-fully-qualified # 💂🏼‍♂ man guard: medium-light skin tone",
    "\uD83D\uDC82\uD83C\uDFFC\u200D\u2642",

    "1F482 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 💂🏽‍♂️ man guard: medium skin tone",
    "\uD83D\uDC82\uD83C\uDFFD\u200D\u2642\uFE0F",

    "1F482 1F3FD 200D 2642                      ; non-fully-qualified # 💂🏽‍♂ man guard: medium skin tone",
    "\uD83D\uDC82\uD83C\uDFFD\u200D\u2642",

    "1F482 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 💂🏾‍♂️ man guard: medium-dark skin tone",
    "\uD83D\uDC82\uD83C\uDFFE\u200D\u2642\uFE0F",

    "1F482 1F3FE 200D 2642                      ; non-fully-qualified # 💂🏾‍♂ man guard: medium-dark skin tone",
    "\uD83D\uDC82\uD83C\uDFFE\u200D\u2642",

    "1F482 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 💂🏿‍♂️ man guard: dark skin tone",
    "\uD83D\uDC82\uD83C\uDFFF\u200D\u2642\uFE0F",

    "1F482 1F3FF 200D 2642                      ; non-fully-qualified # 💂🏿‍♂ man guard: dark skin tone",
    "\uD83D\uDC82\uD83C\uDFFF\u200D\u2642",

    "1F482 200D 2640 FE0F                       ; fully-qualified     # 💂‍♀️ woman guard",
    "\uD83D\uDC82\u200D\u2640\uFE0F",

    "1F482 200D 2640                            ; non-fully-qualified # 💂‍♀ woman guard",
    "\uD83D\uDC82\u200D\u2640",

    "1F482 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 💂🏻‍♀️ woman guard: light skin tone",
    "\uD83D\uDC82\uD83C\uDFFB\u200D\u2640\uFE0F",

    "1F482 1F3FB 200D 2640                      ; non-fully-qualified # 💂🏻‍♀ woman guard: light skin tone",
    "\uD83D\uDC82\uD83C\uDFFB\u200D\u2640",

    "1F482 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 💂🏼‍♀️ woman guard: medium-light skin tone",
    "\uD83D\uDC82\uD83C\uDFFC\u200D\u2640\uFE0F",

    "1F482 1F3FC 200D 2640                      ; non-fully-qualified # 💂🏼‍♀ woman guard: medium-light skin tone",
    "\uD83D\uDC82\uD83C\uDFFC\u200D\u2640",

    "1F482 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 💂🏽‍♀️ woman guard: medium skin tone",
    "\uD83D\uDC82\uD83C\uDFFD\u200D\u2640\uFE0F",

    "1F482 1F3FD 200D 2640                      ; non-fully-qualified # 💂🏽‍♀ woman guard: medium skin tone",
    "\uD83D\uDC82\uD83C\uDFFD\u200D\u2640",

    "1F482 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 💂🏾‍♀️ woman guard: medium-dark skin tone",
    "\uD83D\uDC82\uD83C\uDFFE\u200D\u2640\uFE0F",

    "1F482 1F3FE 200D 2640                      ; non-fully-qualified # 💂🏾‍♀ woman guard: medium-dark skin tone",
    "\uD83D\uDC82\uD83C\uDFFE\u200D\u2640",

    "1F482 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 💂🏿‍♀️ woman guard: dark skin tone",
    "\uD83D\uDC82\uD83C\uDFFF\u200D\u2640\uFE0F",

    "1F482 1F3FF 200D 2640                      ; non-fully-qualified # 💂🏿‍♀ woman guard: dark skin tone",
    "\uD83D\uDC82\uD83C\uDFFF\u200D\u2640",

    "1F477                                      ; fully-qualified     # 👷 construction worker",
    "\uD83D\uDC77",

    "1F477 1F3FB                                ; fully-qualified     # 👷🏻 construction worker: light skin tone",
    "\uD83D\uDC77\uD83C\uDFFB",

    "1F477 1F3FC                                ; fully-qualified     # 👷🏼 construction worker: medium-light skin tone",
    "\uD83D\uDC77\uD83C\uDFFC",

    "1F477 1F3FD                                ; fully-qualified     # 👷🏽 construction worker: medium skin tone",
    "\uD83D\uDC77\uD83C\uDFFD",

    "1F477 1F3FE                                ; fully-qualified     # 👷🏾 construction worker: medium-dark skin tone",
    "\uD83D\uDC77\uD83C\uDFFE",

    "1F477 1F3FF                                ; fully-qualified     # 👷🏿 construction worker: dark skin tone",
    "\uD83D\uDC77\uD83C\uDFFF",

    "1F477 200D 2642 FE0F                       ; fully-qualified     # 👷‍♂️ man construction worker",
    "\uD83D\uDC77\u200D\u2642\uFE0F",

    "1F477 200D 2642                            ; non-fully-qualified # 👷‍♂ man construction worker",
    "\uD83D\uDC77\u200D\u2642",

    "1F477 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 👷🏻‍♂️ man construction worker: light skin tone",
    "\uD83D\uDC77\uD83C\uDFFB\u200D\u2642\uFE0F",

    "1F477 1F3FB 200D 2642                      ; non-fully-qualified # 👷🏻‍♂ man construction worker: light skin tone",
    "\uD83D\uDC77\uD83C\uDFFB\u200D\u2642",

    "1F477 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 👷🏼‍♂️ man construction worker: medium-light skin tone",
    "\uD83D\uDC77\uD83C\uDFFC\u200D\u2642\uFE0F",

    "1F477 1F3FC 200D 2642                      ; non-fully-qualified # 👷🏼‍♂ man construction worker: medium-light skin tone",
    "\uD83D\uDC77\uD83C\uDFFC\u200D\u2642",

    "1F477 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 👷🏽‍♂️ man construction worker: medium skin tone",
    "\uD83D\uDC77\uD83C\uDFFD\u200D\u2642\uFE0F",

    "1F477 1F3FD 200D 2642                      ; non-fully-qualified # 👷🏽‍♂ man construction worker: medium skin tone",
    "\uD83D\uDC77\uD83C\uDFFD\u200D\u2642",

    "1F477 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 👷🏾‍♂️ man construction worker: medium-dark skin tone",
    "\uD83D\uDC77\uD83C\uDFFE\u200D\u2642\uFE0F",

    "1F477 1F3FE 200D 2642                      ; non-fully-qualified # 👷🏾‍♂ man construction worker: medium-dark skin tone",
    "\uD83D\uDC77\uD83C\uDFFE\u200D\u2642",

    "1F477 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 👷🏿‍♂️ man construction worker: dark skin tone",
    "\uD83D\uDC77\uD83C\uDFFF\u200D\u2642\uFE0F",

    "1F477 1F3FF 200D 2642                      ; non-fully-qualified # 👷🏿‍♂ man construction worker: dark skin tone",
    "\uD83D\uDC77\uD83C\uDFFF\u200D\u2642",

    "1F477 200D 2640 FE0F                       ; fully-qualified     # 👷‍♀️ woman construction worker",
    "\uD83D\uDC77\u200D\u2640\uFE0F",

    "1F477 200D 2640                            ; non-fully-qualified # 👷‍♀ woman construction worker",
    "\uD83D\uDC77\u200D\u2640",

    "1F477 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 👷🏻‍♀️ woman construction worker: light skin tone",
    "\uD83D\uDC77\uD83C\uDFFB\u200D\u2640\uFE0F",

    "1F477 1F3FB 200D 2640                      ; non-fully-qualified # 👷🏻‍♀ woman construction worker: light skin tone",
    "\uD83D\uDC77\uD83C\uDFFB\u200D\u2640",

    "1F477 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 👷🏼‍♀️ woman construction worker: medium-light skin tone",
    "\uD83D\uDC77\uD83C\uDFFC\u200D\u2640\uFE0F",

    "1F477 1F3FC 200D 2640                      ; non-fully-qualified # 👷🏼‍♀ woman construction worker: medium-light skin tone",
    "\uD83D\uDC77\uD83C\uDFFC\u200D\u2640",

    "1F477 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 👷🏽‍♀️ woman construction worker: medium skin tone",
    "\uD83D\uDC77\uD83C\uDFFD\u200D\u2640\uFE0F",

    "1F477 1F3FD 200D 2640                      ; non-fully-qualified # 👷🏽‍♀ woman construction worker: medium skin tone",
    "\uD83D\uDC77\uD83C\uDFFD\u200D\u2640",

    "1F477 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 👷🏾‍♀️ woman construction worker: medium-dark skin tone",
    "\uD83D\uDC77\uD83C\uDFFE\u200D\u2640\uFE0F",

    "1F477 1F3FE 200D 2640                      ; non-fully-qualified # 👷🏾‍♀ woman construction worker: medium-dark skin tone",
    "\uD83D\uDC77\uD83C\uDFFE\u200D\u2640",

    "1F477 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 👷🏿‍♀️ woman construction worker: dark skin tone",
    "\uD83D\uDC77\uD83C\uDFFF\u200D\u2640\uFE0F",

    "1F477 1F3FF 200D 2640                      ; non-fully-qualified # 👷🏿‍♀ woman construction worker: dark skin tone",
    "\uD83D\uDC77\uD83C\uDFFF\u200D\u2640",

    "1F934                                      ; fully-qualified     # 🤴 prince",
    "\uD83E\uDD34",

    "1F934 1F3FB                                ; fully-qualified     # 🤴🏻 prince: light skin tone",
    "\uD83E\uDD34\uD83C\uDFFB",

    "1F934 1F3FC                                ; fully-qualified     # 🤴🏼 prince: medium-light skin tone",
    "\uD83E\uDD34\uD83C\uDFFC",

    "1F934 1F3FD                                ; fully-qualified     # 🤴🏽 prince: medium skin tone",
    "\uD83E\uDD34\uD83C\uDFFD",

    "1F934 1F3FE                                ; fully-qualified     # 🤴🏾 prince: medium-dark skin tone",
    "\uD83E\uDD34\uD83C\uDFFE",

    "1F934 1F3FF                                ; fully-qualified     # 🤴🏿 prince: dark skin tone",
    "\uD83E\uDD34\uD83C\uDFFF",

    "1F478                                      ; fully-qualified     # 👸 princess",
    "\uD83D\uDC78",

    "1F478 1F3FB                                ; fully-qualified     # 👸🏻 princess: light skin tone",
    "\uD83D\uDC78\uD83C\uDFFB",

    "1F478 1F3FC                                ; fully-qualified     # 👸🏼 princess: medium-light skin tone",
    "\uD83D\uDC78\uD83C\uDFFC",

    "1F478 1F3FD                                ; fully-qualified     # 👸🏽 princess: medium skin tone",
    "\uD83D\uDC78\uD83C\uDFFD",

    "1F478 1F3FE                                ; fully-qualified     # 👸🏾 princess: medium-dark skin tone",
    "\uD83D\uDC78\uD83C\uDFFE",

    "1F478 1F3FF                                ; fully-qualified     # 👸🏿 princess: dark skin tone",
    "\uD83D\uDC78\uD83C\uDFFF",

    "1F473                                      ; fully-qualified     # 👳 person wearing turban",
    "\uD83D\uDC73",

    "1F473 1F3FB                                ; fully-qualified     # 👳🏻 person wearing turban: light skin tone",
    "\uD83D\uDC73\uD83C\uDFFB",

    "1F473 1F3FC                                ; fully-qualified     # 👳🏼 person wearing turban: medium-light skin tone",
    "\uD83D\uDC73\uD83C\uDFFC",

    "1F473 1F3FD                                ; fully-qualified     # 👳🏽 person wearing turban: medium skin tone",
    "\uD83D\uDC73\uD83C\uDFFD",

    "1F473 1F3FE                                ; fully-qualified     # 👳🏾 person wearing turban: medium-dark skin tone",
    "\uD83D\uDC73\uD83C\uDFFE",

    "1F473 1F3FF                                ; fully-qualified     # 👳🏿 person wearing turban: dark skin tone",
    "\uD83D\uDC73\uD83C\uDFFF",

    "1F473 200D 2642 FE0F                       ; fully-qualified     # 👳‍♂️ man wearing turban",
    "\uD83D\uDC73\u200D\u2642\uFE0F",

    "1F473 200D 2642                            ; non-fully-qualified # 👳‍♂ man wearing turban",
    "\uD83D\uDC73\u200D\u2642",

    "1F473 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 👳🏻‍♂️ man wearing turban: light skin tone",
    "\uD83D\uDC73\uD83C\uDFFB\u200D\u2642\uFE0F",

    "1F473 1F3FB 200D 2642                      ; non-fully-qualified # 👳🏻‍♂ man wearing turban: light skin tone",
    "\uD83D\uDC73\uD83C\uDFFB\u200D\u2642",

    "1F473 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 👳🏼‍♂️ man wearing turban: medium-light skin tone",
    "\uD83D\uDC73\uD83C\uDFFC\u200D\u2642\uFE0F",

    "1F473 1F3FC 200D 2642                      ; non-fully-qualified # 👳🏼‍♂ man wearing turban: medium-light skin tone",
    "\uD83D\uDC73\uD83C\uDFFC\u200D\u2642",

    "1F473 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 👳🏽‍♂️ man wearing turban: medium skin tone",
    "\uD83D\uDC73\uD83C\uDFFD\u200D\u2642\uFE0F",

    "1F473 1F3FD 200D 2642                      ; non-fully-qualified # 👳🏽‍♂ man wearing turban: medium skin tone",
    "\uD83D\uDC73\uD83C\uDFFD\u200D\u2642",

    "1F473 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 👳🏾‍♂️ man wearing turban: medium-dark skin tone",
    "\uD83D\uDC73\uD83C\uDFFE\u200D\u2642\uFE0F",

    "1F473 1F3FE 200D 2642                      ; non-fully-qualified # 👳🏾‍♂ man wearing turban: medium-dark skin tone",
    "\uD83D\uDC73\uD83C\uDFFE\u200D\u2642",

    "1F473 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 👳🏿‍♂️ man wearing turban: dark skin tone",
    "\uD83D\uDC73\uD83C\uDFFF\u200D\u2642\uFE0F",

    "1F473 1F3FF 200D 2642                      ; non-fully-qualified # 👳🏿‍♂ man wearing turban: dark skin tone",
    "\uD83D\uDC73\uD83C\uDFFF\u200D\u2642",

    "1F473 200D 2640 FE0F                       ; fully-qualified     # 👳‍♀️ woman wearing turban",
    "\uD83D\uDC73\u200D\u2640\uFE0F",

    "1F473 200D 2640                            ; non-fully-qualified # 👳‍♀ woman wearing turban",
    "\uD83D\uDC73\u200D\u2640",

    "1F473 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 👳🏻‍♀️ woman wearing turban: light skin tone",
    "\uD83D\uDC73\uD83C\uDFFB\u200D\u2640\uFE0F",

    "1F473 1F3FB 200D 2640                      ; non-fully-qualified # 👳🏻‍♀ woman wearing turban: light skin tone",
    "\uD83D\uDC73\uD83C\uDFFB\u200D\u2640",

    "1F473 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 👳🏼‍♀️ woman wearing turban: medium-light skin tone",
    "\uD83D\uDC73\uD83C\uDFFC\u200D\u2640\uFE0F",

    "1F473 1F3FC 200D 2640                      ; non-fully-qualified # 👳🏼‍♀ woman wearing turban: medium-light skin tone",
    "\uD83D\uDC73\uD83C\uDFFC\u200D\u2640",

    "1F473 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 👳🏽‍♀️ woman wearing turban: medium skin tone",
    "\uD83D\uDC73\uD83C\uDFFD\u200D\u2640\uFE0F",

    "1F473 1F3FD 200D 2640                      ; non-fully-qualified # 👳🏽‍♀ woman wearing turban: medium skin tone",
    "\uD83D\uDC73\uD83C\uDFFD\u200D\u2640",

    "1F473 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 👳🏾‍♀️ woman wearing turban: medium-dark skin tone",
    "\uD83D\uDC73\uD83C\uDFFE\u200D\u2640\uFE0F",

    "1F473 1F3FE 200D 2640                      ; non-fully-qualified # 👳🏾‍♀ woman wearing turban: medium-dark skin tone",
    "\uD83D\uDC73\uD83C\uDFFE\u200D\u2640",

    "1F473 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 👳🏿‍♀️ woman wearing turban: dark skin tone",
    "\uD83D\uDC73\uD83C\uDFFF\u200D\u2640\uFE0F",

    "1F473 1F3FF 200D 2640                      ; non-fully-qualified # 👳🏿‍♀ woman wearing turban: dark skin tone",
    "\uD83D\uDC73\uD83C\uDFFF\u200D\u2640",

    "1F472                                      ; fully-qualified     # 👲 man with Chinese cap",
    "\uD83D\uDC72",

    "1F472 1F3FB                                ; fully-qualified     # 👲🏻 man with Chinese cap: light skin tone",
    "\uD83D\uDC72\uD83C\uDFFB",

    "1F472 1F3FC                                ; fully-qualified     # 👲🏼 man with Chinese cap: medium-light skin tone",
    "\uD83D\uDC72\uD83C\uDFFC",

    "1F472 1F3FD                                ; fully-qualified     # 👲🏽 man with Chinese cap: medium skin tone",
    "\uD83D\uDC72\uD83C\uDFFD",

    "1F472 1F3FE                                ; fully-qualified     # 👲🏾 man with Chinese cap: medium-dark skin tone",
    "\uD83D\uDC72\uD83C\uDFFE",

    "1F472 1F3FF                                ; fully-qualified     # 👲🏿 man with Chinese cap: dark skin tone",
    "\uD83D\uDC72\uD83C\uDFFF",

    "1F9D5                                      ; fully-qualified     # 🧕 woman with headscarf",
    "\uD83E\uDDD5",

    "1F9D5 1F3FB                                ; fully-qualified     # 🧕🏻 woman with headscarf: light skin tone",
    "\uD83E\uDDD5\uD83C\uDFFB",

    "1F9D5 1F3FC                                ; fully-qualified     # 🧕🏼 woman with headscarf: medium-light skin tone",
    "\uD83E\uDDD5\uD83C\uDFFC",

    "1F9D5 1F3FD                                ; fully-qualified     # 🧕🏽 woman with headscarf: medium skin tone",
    "\uD83E\uDDD5\uD83C\uDFFD",

    "1F9D5 1F3FE                                ; fully-qualified     # 🧕🏾 woman with headscarf: medium-dark skin tone",
    "\uD83E\uDDD5\uD83C\uDFFE",

    "1F9D5 1F3FF                                ; fully-qualified     # 🧕🏿 woman with headscarf: dark skin tone",
    "\uD83E\uDDD5\uD83C\uDFFF",

    "1F9D4                                      ; fully-qualified     # 🧔 bearded person",
    "\uD83E\uDDD4",

    "1F9D4 1F3FB                                ; fully-qualified     # 🧔🏻 bearded person: light skin tone",
    "\uD83E\uDDD4\uD83C\uDFFB",

    "1F9D4 1F3FC                                ; fully-qualified     # 🧔🏼 bearded person: medium-light skin tone",
    "\uD83E\uDDD4\uD83C\uDFFC",

    "1F9D4 1F3FD                                ; fully-qualified     # 🧔🏽 bearded person: medium skin tone",
    "\uD83E\uDDD4\uD83C\uDFFD",

    "1F9D4 1F3FE                                ; fully-qualified     # 🧔🏾 bearded person: medium-dark skin tone",
    "\uD83E\uDDD4\uD83C\uDFFE",

    "1F9D4 1F3FF                                ; fully-qualified     # 🧔🏿 bearded person: dark skin tone",
    "\uD83E\uDDD4\uD83C\uDFFF",

    "1F471                                      ; fully-qualified     # 👱 blond-haired person",
    "\uD83D\uDC71",

    "1F471 1F3FB                                ; fully-qualified     # 👱🏻 blond-haired person: light skin tone",
    "\uD83D\uDC71\uD83C\uDFFB",

    "1F471 1F3FC                                ; fully-qualified     # 👱🏼 blond-haired person: medium-light skin tone",
    "\uD83D\uDC71\uD83C\uDFFC",

    "1F471 1F3FD                                ; fully-qualified     # 👱🏽 blond-haired person: medium skin tone",
    "\uD83D\uDC71\uD83C\uDFFD",

    "1F471 1F3FE                                ; fully-qualified     # 👱🏾 blond-haired person: medium-dark skin tone",
    "\uD83D\uDC71\uD83C\uDFFE",

    "1F471 1F3FF                                ; fully-qualified     # 👱🏿 blond-haired person: dark skin tone",
    "\uD83D\uDC71\uD83C\uDFFF",

    "1F471 200D 2642 FE0F                       ; fully-qualified     # 👱‍♂️ blond-haired man",
    "\uD83D\uDC71\u200D\u2642\uFE0F",

    "1F471 200D 2642                            ; non-fully-qualified # 👱‍♂ blond-haired man",
    "\uD83D\uDC71\u200D\u2642",

    "1F471 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 👱🏻‍♂️ blond-haired man: light skin tone",
    "\uD83D\uDC71\uD83C\uDFFB\u200D\u2642\uFE0F",

    "1F471 1F3FB 200D 2642                      ; non-fully-qualified # 👱🏻‍♂ blond-haired man: light skin tone",
    "\uD83D\uDC71\uD83C\uDFFB\u200D\u2642",

    "1F471 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 👱🏼‍♂️ blond-haired man: medium-light skin tone",
    "\uD83D\uDC71\uD83C\uDFFC\u200D\u2642\uFE0F",

    "1F471 1F3FC 200D 2642                      ; non-fully-qualified # 👱🏼‍♂ blond-haired man: medium-light skin tone",
    "\uD83D\uDC71\uD83C\uDFFC\u200D\u2642",

    "1F471 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 👱🏽‍♂️ blond-haired man: medium skin tone",
    "\uD83D\uDC71\uD83C\uDFFD\u200D\u2642\uFE0F",

    "1F471 1F3FD 200D 2642                      ; non-fully-qualified # 👱🏽‍♂ blond-haired man: medium skin tone",
    "\uD83D\uDC71\uD83C\uDFFD\u200D\u2642",

    "1F471 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 👱🏾‍♂️ blond-haired man: medium-dark skin tone",
    "\uD83D\uDC71\uD83C\uDFFE\u200D\u2642\uFE0F",

    "1F471 1F3FE 200D 2642                      ; non-fully-qualified # 👱🏾‍♂ blond-haired man: medium-dark skin tone",
    "\uD83D\uDC71\uD83C\uDFFE\u200D\u2642",

    "1F471 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 👱🏿‍♂️ blond-haired man: dark skin tone",
    "\uD83D\uDC71\uD83C\uDFFF\u200D\u2642\uFE0F",

    "1F471 1F3FF 200D 2642                      ; non-fully-qualified # 👱🏿‍♂ blond-haired man: dark skin tone",
    "\uD83D\uDC71\uD83C\uDFFF\u200D\u2642",

    "1F471 200D 2640 FE0F                       ; fully-qualified     # 👱‍♀️ blond-haired woman",
    "\uD83D\uDC71\u200D\u2640\uFE0F",

    "1F471 200D 2640                            ; non-fully-qualified # 👱‍♀ blond-haired woman",
    "\uD83D\uDC71\u200D\u2640",

    "1F471 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 👱🏻‍♀️ blond-haired woman: light skin tone",
    "\uD83D\uDC71\uD83C\uDFFB\u200D\u2640\uFE0F",

    "1F471 1F3FB 200D 2640                      ; non-fully-qualified # 👱🏻‍♀ blond-haired woman: light skin tone",
    "\uD83D\uDC71\uD83C\uDFFB\u200D\u2640",

    "1F471 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 👱🏼‍♀️ blond-haired woman: medium-light skin tone",
    "\uD83D\uDC71\uD83C\uDFFC\u200D\u2640\uFE0F",

    "1F471 1F3FC 200D 2640                      ; non-fully-qualified # 👱🏼‍♀ blond-haired woman: medium-light skin tone",
    "\uD83D\uDC71\uD83C\uDFFC\u200D\u2640",

    "1F471 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 👱🏽‍♀️ blond-haired woman: medium skin tone",
    "\uD83D\uDC71\uD83C\uDFFD\u200D\u2640\uFE0F",

    "1F471 1F3FD 200D 2640                      ; non-fully-qualified # 👱🏽‍♀ blond-haired woman: medium skin tone",
    "\uD83D\uDC71\uD83C\uDFFD\u200D\u2640",

    "1F471 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 👱🏾‍♀️ blond-haired woman: medium-dark skin tone",
    "\uD83D\uDC71\uD83C\uDFFE\u200D\u2640\uFE0F",

    "1F471 1F3FE 200D 2640                      ; non-fully-qualified # 👱🏾‍♀ blond-haired woman: medium-dark skin tone",
    "\uD83D\uDC71\uD83C\uDFFE\u200D\u2640",

    "1F471 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 👱🏿‍♀️ blond-haired woman: dark skin tone",
    "\uD83D\uDC71\uD83C\uDFFF\u200D\u2640\uFE0F",

    "1F471 1F3FF 200D 2640                      ; non-fully-qualified # 👱🏿‍♀ blond-haired woman: dark skin tone",
    "\uD83D\uDC71\uD83C\uDFFF\u200D\u2640",

    "1F468 200D 1F9B0                           ; fully-qualified     # 👨‍🦰 man, red haired",
    "\uD83D\uDC68\u200D\uD83E\uDDB0",

    "1F468 1F3FB 200D 1F9B0                     ; fully-qualified     # 👨🏻‍🦰 man, red haired: light skin tone",
    "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83E\uDDB0",

    "1F468 1F3FC 200D 1F9B0                     ; fully-qualified     # 👨🏼‍🦰 man, red haired: medium-light skin tone",
    "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83E\uDDB0",

    "1F468 1F3FD 200D 1F9B0                     ; fully-qualified     # 👨🏽‍🦰 man, red haired: medium skin tone",
    "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83E\uDDB0",

    "1F468 1F3FE 200D 1F9B0                     ; fully-qualified     # 👨🏾‍🦰 man, red haired: medium-dark skin tone",
    "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83E\uDDB0",

    "1F468 1F3FF 200D 1F9B0                     ; fully-qualified     # 👨🏿‍🦰 man, red haired: dark skin tone",
    "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83E\uDDB0",

    "1F469 200D 1F9B0                           ; fully-qualified     # 👩‍🦰 woman, red haired",
    "\uD83D\uDC69\u200D\uD83E\uDDB0",

    "1F469 1F3FB 200D 1F9B0                     ; fully-qualified     # 👩🏻‍🦰 woman, red haired: light skin tone",
    "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDDB0",

    "1F469 1F3FC 200D 1F9B0                     ; fully-qualified     # 👩🏼‍🦰 woman, red haired: medium-light skin tone",
    "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDDB0",

    "1F469 1F3FD 200D 1F9B0                     ; fully-qualified     # 👩🏽‍🦰 woman, red haired: medium skin tone",
    "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDDB0",

    "1F469 1F3FE 200D 1F9B0                     ; fully-qualified     # 👩🏾‍🦰 woman, red haired: medium-dark skin tone",
    "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDDB0",

    "1F469 1F3FF 200D 1F9B0                     ; fully-qualified     # 👩🏿‍🦰 woman, red haired: dark skin tone",
    "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDDB0",

    "1F468 200D 1F9B1                           ; fully-qualified     # 👨‍🦱 man, curly haired",
    "\uD83D\uDC68\u200D\uD83E\uDDB1",

    "1F468 1F3FB 200D 1F9B1                     ; fully-qualified     # 👨🏻‍🦱 man, curly haired: light skin tone",
    "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83E\uDDB1",

    "1F468 1F3FC 200D 1F9B1                     ; fully-qualified     # 👨🏼‍🦱 man, curly haired: medium-light skin tone",
    "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83E\uDDB1",

    "1F468 1F3FD 200D 1F9B1                     ; fully-qualified     # 👨🏽‍🦱 man, curly haired: medium skin tone",
    "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83E\uDDB1",

    "1F468 1F3FE 200D 1F9B1                     ; fully-qualified     # 👨🏾‍🦱 man, curly haired: medium-dark skin tone",
    "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83E\uDDB1",

    "1F468 1F3FF 200D 1F9B1                     ; fully-qualified     # 👨🏿‍🦱 man, curly haired: dark skin tone",
    "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83E\uDDB1",

    "1F469 200D 1F9B1                           ; fully-qualified     # 👩‍🦱 woman, curly haired",
    "\uD83D\uDC69\u200D\uD83E\uDDB1",

    "1F469 1F3FB 200D 1F9B1                     ; fully-qualified     # 👩🏻‍🦱 woman, curly haired: light skin tone",
    "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDDB1",

    "1F469 1F3FC 200D 1F9B1                     ; fully-qualified     # 👩🏼‍🦱 woman, curly haired: medium-light skin tone",
    "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDDB1",

    "1F469 1F3FD 200D 1F9B1                     ; fully-qualified     # 👩🏽‍🦱 woman, curly haired: medium skin tone",
    "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDDB1",

    "1F469 1F3FE 200D 1F9B1                     ; fully-qualified     # 👩🏾‍🦱 woman, curly haired: medium-dark skin tone",
    "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDDB1",

    "1F469 1F3FF 200D 1F9B1                     ; fully-qualified     # 👩🏿‍🦱 woman, curly haired: dark skin tone",
    "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDDB1",

    "1F468 200D 1F9B2                           ; fully-qualified     # 👨‍🦲 man, bald",
    "\uD83D\uDC68\u200D\uD83E\uDDB2",

    "1F468 1F3FB 200D 1F9B2                     ; fully-qualified     # 👨🏻‍🦲 man, bald: light skin tone",
    "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83E\uDDB2",

    "1F468 1F3FC 200D 1F9B2                     ; fully-qualified     # 👨🏼‍🦲 man, bald: medium-light skin tone",
    "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83E\uDDB2",

    "1F468 1F3FD 200D 1F9B2                     ; fully-qualified     # 👨🏽‍🦲 man, bald: medium skin tone",
    "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83E\uDDB2",

    "1F468 1F3FE 200D 1F9B2                     ; fully-qualified     # 👨🏾‍🦲 man, bald: medium-dark skin tone",
    "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83E\uDDB2",

    "1F468 1F3FF 200D 1F9B2                     ; fully-qualified     # 👨🏿‍🦲 man, bald: dark skin tone",
    "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83E\uDDB2",

    "1F469 200D 1F9B2                           ; fully-qualified     # 👩‍🦲 woman, bald",
    "\uD83D\uDC69\u200D\uD83E\uDDB2",

    "1F469 1F3FB 200D 1F9B2                     ; fully-qualified     # 👩🏻‍🦲 woman, bald: light skin tone",
    "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDDB2",

    "1F469 1F3FC 200D 1F9B2                     ; fully-qualified     # 👩🏼‍🦲 woman, bald: medium-light skin tone",
    "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDDB2",

    "1F469 1F3FD 200D 1F9B2                     ; fully-qualified     # 👩🏽‍🦲 woman, bald: medium skin tone",
    "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDDB2",

    "1F469 1F3FE 200D 1F9B2                     ; fully-qualified     # 👩🏾‍🦲 woman, bald: medium-dark skin tone",
    "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDDB2",

    "1F469 1F3FF 200D 1F9B2                     ; fully-qualified     # 👩🏿‍🦲 woman, bald: dark skin tone",
    "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDDB2",

    "1F468 200D 1F9B3                           ; fully-qualified     # 👨‍🦳 man, white haired",
    "\uD83D\uDC68\u200D\uD83E\uDDB3",

    "1F468 1F3FB 200D 1F9B3                     ; fully-qualified     # 👨🏻‍🦳 man, white haired: light skin tone",
    "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83E\uDDB3",

    "1F468 1F3FC 200D 1F9B3                     ; fully-qualified     # 👨🏼‍🦳 man, white haired: medium-light skin tone",
    "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83E\uDDB3",

    "1F468 1F3FD 200D 1F9B3                     ; fully-qualified     # 👨🏽‍🦳 man, white haired: medium skin tone",
    "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83E\uDDB3",

    "1F468 1F3FE 200D 1F9B3                     ; fully-qualified     # 👨🏾‍🦳 man, white haired: medium-dark skin tone",
    "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83E\uDDB3",

    "1F468 1F3FF 200D 1F9B3                     ; fully-qualified     # 👨🏿‍🦳 man, white haired: dark skin tone",
    "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83E\uDDB3",

    "1F469 200D 1F9B3                           ; fully-qualified     # 👩‍🦳 woman, white haired",
    "\uD83D\uDC69\u200D\uD83E\uDDB3",

    "1F469 1F3FB 200D 1F9B3                     ; fully-qualified     # 👩🏻‍🦳 woman, white haired: light skin tone",
    "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDDB3",

    "1F469 1F3FC 200D 1F9B3                     ; fully-qualified     # 👩🏼‍🦳 woman, white haired: medium-light skin tone",
    "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDDB3",

    "1F469 1F3FD 200D 1F9B3                     ; fully-qualified     # 👩🏽‍🦳 woman, white haired: medium skin tone",
    "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDDB3",

    "1F469 1F3FE 200D 1F9B3                     ; fully-qualified     # 👩🏾‍🦳 woman, white haired: medium-dark skin tone",
    "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDDB3",

    "1F469 1F3FF 200D 1F9B3                     ; fully-qualified     # 👩🏿‍🦳 woman, white haired: dark skin tone",
    "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDDB3",

    "1F935                                      ; fully-qualified     # 🤵 man in tuxedo",
    "\uD83E\uDD35",

    "1F935 1F3FB                                ; fully-qualified     # 🤵🏻 man in tuxedo: light skin tone",
    "\uD83E\uDD35\uD83C\uDFFB",

    "1F935 1F3FC                                ; fully-qualified     # 🤵🏼 man in tuxedo: medium-light skin tone",
    "\uD83E\uDD35\uD83C\uDFFC",

    "1F935 1F3FD                                ; fully-qualified     # 🤵🏽 man in tuxedo: medium skin tone",
    "\uD83E\uDD35\uD83C\uDFFD",

    "1F935 1F3FE                                ; fully-qualified     # 🤵🏾 man in tuxedo: medium-dark skin tone",
    "\uD83E\uDD35\uD83C\uDFFE",

    "1F935 1F3FF                                ; fully-qualified     # 🤵🏿 man in tuxedo: dark skin tone",
    "\uD83E\uDD35\uD83C\uDFFF",

    "1F470                                      ; fully-qualified     # 👰 bride with veil",
    "\uD83D\uDC70",

    "1F470 1F3FB                                ; fully-qualified     # 👰🏻 bride with veil: light skin tone",
    "\uD83D\uDC70\uD83C\uDFFB",

    "1F470 1F3FC                                ; fully-qualified     # 👰🏼 bride with veil: medium-light skin tone",
    "\uD83D\uDC70\uD83C\uDFFC",

    "1F470 1F3FD                                ; fully-qualified     # 👰🏽 bride with veil: medium skin tone",
    "\uD83D\uDC70\uD83C\uDFFD",

    "1F470 1F3FE                                ; fully-qualified     # 👰🏾 bride with veil: medium-dark skin tone",
    "\uD83D\uDC70\uD83C\uDFFE",

    "1F470 1F3FF                                ; fully-qualified     # 👰🏿 bride with veil: dark skin tone",
    "\uD83D\uDC70\uD83C\uDFFF",

    "1F930                                      ; fully-qualified     # 🤰 pregnant woman",
    "\uD83E\uDD30",

    "1F930 1F3FB                                ; fully-qualified     # 🤰🏻 pregnant woman: light skin tone",
    "\uD83E\uDD30\uD83C\uDFFB",

    "1F930 1F3FC                                ; fully-qualified     # 🤰🏼 pregnant woman: medium-light skin tone",
    "\uD83E\uDD30\uD83C\uDFFC",

    "1F930 1F3FD                                ; fully-qualified     # 🤰🏽 pregnant woman: medium skin tone",
    "\uD83E\uDD30\uD83C\uDFFD",

    "1F930 1F3FE                                ; fully-qualified     # 🤰🏾 pregnant woman: medium-dark skin tone",
    "\uD83E\uDD30\uD83C\uDFFE",

    "1F930 1F3FF                                ; fully-qualified     # 🤰🏿 pregnant woman: dark skin tone",
    "\uD83E\uDD30\uD83C\uDFFF",

    "1F931                                      ; fully-qualified     # 🤱 breast-feeding",
    "\uD83E\uDD31",

    "1F931 1F3FB                                ; fully-qualified     # 🤱🏻 breast-feeding: light skin tone",
    "\uD83E\uDD31\uD83C\uDFFB",

    "1F931 1F3FC                                ; fully-qualified     # 🤱🏼 breast-feeding: medium-light skin tone",
    "\uD83E\uDD31\uD83C\uDFFC",

    "1F931 1F3FD                                ; fully-qualified     # 🤱🏽 breast-feeding: medium skin tone",
    "\uD83E\uDD31\uD83C\uDFFD",

    "1F931 1F3FE                                ; fully-qualified     # 🤱🏾 breast-feeding: medium-dark skin tone",
    "\uD83E\uDD31\uD83C\uDFFE",

    "1F931 1F3FF                                ; fully-qualified     # 🤱🏿 breast-feeding: dark skin tone",
    "\uD83E\uDD31\uD83C\uDFFF",

    "1F47C                                      ; fully-qualified     # 👼 baby angel",
    "\uD83D\uDC7C",

    "1F47C 1F3FB                                ; fully-qualified     # 👼🏻 baby angel: light skin tone",
    "\uD83D\uDC7C\uD83C\uDFFB",

    "1F47C 1F3FC                                ; fully-qualified     # 👼🏼 baby angel: medium-light skin tone",
    "\uD83D\uDC7C\uD83C\uDFFC",

    "1F47C 1F3FD                                ; fully-qualified     # 👼🏽 baby angel: medium skin tone",
    "\uD83D\uDC7C\uD83C\uDFFD",

    "1F47C 1F3FE                                ; fully-qualified     # 👼🏾 baby angel: medium-dark skin tone",
    "\uD83D\uDC7C\uD83C\uDFFE",

    "1F47C 1F3FF                                ; fully-qualified     # 👼🏿 baby angel: dark skin tone",
    "\uD83D\uDC7C\uD83C\uDFFF",

    "1F385                                      ; fully-qualified     # 🎅 Santa Claus",
    "\uD83C\uDF85",

    "1F385 1F3FB                                ; fully-qualified     # 🎅🏻 Santa Claus: light skin tone",
    "\uD83C\uDF85\uD83C\uDFFB",

    "1F385 1F3FC                                ; fully-qualified     # 🎅🏼 Santa Claus: medium-light skin tone",
    "\uD83C\uDF85\uD83C\uDFFC",

    "1F385 1F3FD                                ; fully-qualified     # 🎅🏽 Santa Claus: medium skin tone",
    "\uD83C\uDF85\uD83C\uDFFD",

    "1F385 1F3FE                                ; fully-qualified     # 🎅🏾 Santa Claus: medium-dark skin tone",
    "\uD83C\uDF85\uD83C\uDFFE",

    "1F385 1F3FF                                ; fully-qualified     # 🎅🏿 Santa Claus: dark skin tone",
    "\uD83C\uDF85\uD83C\uDFFF",

    "1F936                                      ; fully-qualified     # 🤶 Mrs. Claus",
    "\uD83E\uDD36",

    "1F936 1F3FB                                ; fully-qualified     # 🤶🏻 Mrs. Claus: light skin tone",
    "\uD83E\uDD36\uD83C\uDFFB",

    "1F936 1F3FC                                ; fully-qualified     # 🤶🏼 Mrs. Claus: medium-light skin tone",
    "\uD83E\uDD36\uD83C\uDFFC",

    "1F936 1F3FD                                ; fully-qualified     # 🤶🏽 Mrs. Claus: medium skin tone",
    "\uD83E\uDD36\uD83C\uDFFD",

    "1F936 1F3FE                                ; fully-qualified     # 🤶🏾 Mrs. Claus: medium-dark skin tone",
    "\uD83E\uDD36\uD83C\uDFFE",

    "1F936 1F3FF                                ; fully-qualified     # 🤶🏿 Mrs. Claus: dark skin tone",
    "\uD83E\uDD36\uD83C\uDFFF",

    "1F9B8                                      ; fully-qualified     # 🦸 superhero",
    "\uD83E\uDDB8",

    "1F9B8 1F3FB                                ; fully-qualified     # 🦸🏻 superhero: light skin tone",
    "\uD83E\uDDB8\uD83C\uDFFB",

    "1F9B8 1F3FC                                ; fully-qualified     # 🦸🏼 superhero: medium-light skin tone",
    "\uD83E\uDDB8\uD83C\uDFFC",

    "1F9B8 1F3FD                                ; fully-qualified     # 🦸🏽 superhero: medium skin tone",
    "\uD83E\uDDB8\uD83C\uDFFD",

    "1F9B8 1F3FE                                ; fully-qualified     # 🦸🏾 superhero: medium-dark skin tone",
    "\uD83E\uDDB8\uD83C\uDFFE",

    "1F9B8 1F3FF                                ; fully-qualified     # 🦸🏿 superhero: dark skin tone",
    "\uD83E\uDDB8\uD83C\uDFFF",

    "1F9B8 200D 2640 FE0F                       ; fully-qualified     # 🦸‍♀️ woman superhero",
    "\uD83E\uDDB8\u200D\u2640\uFE0F",

    "1F9B8 200D 2640                            ; non-fully-qualified # 🦸‍♀ woman superhero",
    "\uD83E\uDDB8\u200D\u2640",

    "1F9B8 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🦸🏻‍♀️ woman superhero: light skin tone",
    "\uD83E\uDDB8\uD83C\uDFFB\u200D\u2640\uFE0F",

    "1F9B8 1F3FB 200D 2640                      ; non-fully-qualified # 🦸🏻‍♀ woman superhero: light skin tone",
    "\uD83E\uDDB8\uD83C\uDFFB\u200D\u2640",

    "1F9B8 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🦸🏼‍♀️ woman superhero: medium-light skin tone",
    "\uD83E\uDDB8\uD83C\uDFFC\u200D\u2640\uFE0F",

    "1F9B8 1F3FC 200D 2640                      ; non-fully-qualified # 🦸🏼‍♀ woman superhero: medium-light skin tone",
    "\uD83E\uDDB8\uD83C\uDFFC\u200D\u2640",

    "1F9B8 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🦸🏽‍♀️ woman superhero: medium skin tone",
    "\uD83E\uDDB8\uD83C\uDFFD\u200D\u2640\uFE0F",

    "1F9B8 1F3FD 200D 2640                      ; non-fully-qualified # 🦸🏽‍♀ woman superhero: medium skin tone",
    "\uD83E\uDDB8\uD83C\uDFFD\u200D\u2640",

    "1F9B8 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🦸🏾‍♀️ woman superhero: medium-dark skin tone",
    "\uD83E\uDDB8\uD83C\uDFFE\u200D\u2640\uFE0F",

    "1F9B8 1F3FE 200D 2640                      ; non-fully-qualified # 🦸🏾‍♀ woman superhero: medium-dark skin tone",
    "\uD83E\uDDB8\uD83C\uDFFE\u200D\u2640",

    "1F9B8 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🦸🏿‍♀️ woman superhero: dark skin tone",
    "\uD83E\uDDB8\uD83C\uDFFF\u200D\u2640\uFE0F",

    "1F9B8 1F3FF 200D 2640                      ; non-fully-qualified # 🦸🏿‍♀ woman superhero: dark skin tone",
    "\uD83E\uDDB8\uD83C\uDFFF\u200D\u2640",

    "1F9B8 200D 2642 FE0F                       ; fully-qualified     # 🦸‍♂️ man superhero",
    "\uD83E\uDDB8\u200D\u2642\uFE0F",

    "1F9B8 200D 2642                            ; non-fully-qualified # 🦸‍♂ man superhero",
    "\uD83E\uDDB8\u200D\u2642",

    "1F9B8 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🦸🏻‍♂️ man superhero: light skin tone",
    "\uD83E\uDDB8\uD83C\uDFFB\u200D\u2642\uFE0F",

    "1F9B8 1F3FB 200D 2642                      ; non-fully-qualified # 🦸🏻‍♂ man superhero: light skin tone",
    "\uD83E\uDDB8\uD83C\uDFFB\u200D\u2642",

    "1F9B8 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🦸🏼‍♂️ man superhero: medium-light skin tone",
    "\uD83E\uDDB8\uD83C\uDFFC\u200D\u2642\uFE0F",

    "1F9B8 1F3FC 200D 2642                      ; non-fully-qualified # 🦸🏼‍♂ man superhero: medium-light skin tone",
    "\uD83E\uDDB8\uD83C\uDFFC\u200D\u2642",

    "1F9B8 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🦸🏽‍♂️ man superhero: medium skin tone",
    "\uD83E\uDDB8\uD83C\uDFFD\u200D\u2642\uFE0F",

    "1F9B8 1F3FD 200D 2642                      ; non-fully-qualified # 🦸🏽‍♂ man superhero: medium skin tone",
    "\uD83E\uDDB8\uD83C\uDFFD\u200D\u2642",

    "1F9B8 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🦸🏾‍♂️ man superhero: medium-dark skin tone",
    "\uD83E\uDDB8\uD83C\uDFFE\u200D\u2642\uFE0F",

    "1F9B8 1F3FE 200D 2642                      ; non-fully-qualified # 🦸🏾‍♂ man superhero: medium-dark skin tone",
    "\uD83E\uDDB8\uD83C\uDFFE\u200D\u2642",

    "1F9B8 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🦸🏿‍♂️ man superhero: dark skin tone",
    "\uD83E\uDDB8\uD83C\uDFFF\u200D\u2642\uFE0F",

    "1F9B8 1F3FF 200D 2642                      ; non-fully-qualified # 🦸🏿‍♂ man superhero: dark skin tone",
    "\uD83E\uDDB8\uD83C\uDFFF\u200D\u2642",

    "1F9B9                                      ; fully-qualified     # 🦹 supervillain",
    "\uD83E\uDDB9",

    "1F9B9 1F3FB                                ; fully-qualified     # 🦹🏻 supervillain: light skin tone",
    "\uD83E\uDDB9\uD83C\uDFFB",

    "1F9B9 1F3FC                                ; fully-qualified     # 🦹🏼 supervillain: medium-light skin tone",
    "\uD83E\uDDB9\uD83C\uDFFC",

    "1F9B9 1F3FD                                ; fully-qualified     # 🦹🏽 supervillain: medium skin tone",
    "\uD83E\uDDB9\uD83C\uDFFD",

    "1F9B9 1F3FE                                ; fully-qualified     # 🦹🏾 supervillain: medium-dark skin tone",
    "\uD83E\uDDB9\uD83C\uDFFE",

    "1F9B9 1F3FF                                ; fully-qualified     # 🦹🏿 supervillain: dark skin tone",
    "\uD83E\uDDB9\uD83C\uDFFF",

    "1F9B9 200D 2640 FE0F                       ; fully-qualified     # 🦹‍♀️ woman supervillain",
    "\uD83E\uDDB9\u200D\u2640\uFE0F",

    "1F9B9 200D 2640                            ; non-fully-qualified # 🦹‍♀ woman supervillain",
    "\uD83E\uDDB9\u200D\u2640",

    "1F9B9 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🦹🏻‍♀️ woman supervillain: light skin tone",
    "\uD83E\uDDB9\uD83C\uDFFB\u200D\u2640\uFE0F",

    "1F9B9 1F3FB 200D 2640                      ; non-fully-qualified # 🦹🏻‍♀ woman supervillain: light skin tone",
    "\uD83E\uDDB9\uD83C\uDFFB\u200D\u2640",

    "1F9B9 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🦹🏼‍♀️ woman supervillain: medium-light skin tone",
    "\uD83E\uDDB9\uD83C\uDFFC\u200D\u2640\uFE0F",

    "1F9B9 1F3FC 200D 2640                      ; non-fully-qualified # 🦹🏼‍♀ woman supervillain: medium-light skin tone",
    "\uD83E\uDDB9\uD83C\uDFFC\u200D\u2640",

    "1F9B9 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🦹🏽‍♀️ woman supervillain: medium skin tone",
    "\uD83E\uDDB9\uD83C\uDFFD\u200D\u2640\uFE0F",

    "1F9B9 1F3FD 200D 2640                      ; non-fully-qualified # 🦹🏽‍♀ woman supervillain: medium skin tone",
    "\uD83E\uDDB9\uD83C\uDFFD\u200D\u2640",

    "1F9B9 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🦹🏾‍♀️ woman supervillain: medium-dark skin tone",
    "\uD83E\uDDB9\uD83C\uDFFE\u200D\u2640\uFE0F",

    "1F9B9 1F3FE 200D 2640                      ; non-fully-qualified # 🦹🏾‍♀ woman supervillain: medium-dark skin tone",
    "\uD83E\uDDB9\uD83C\uDFFE\u200D\u2640",

    "1F9B9 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🦹🏿‍♀️ woman supervillain: dark skin tone",
    "\uD83E\uDDB9\uD83C\uDFFF\u200D\u2640\uFE0F",

    "1F9B9 1F3FF 200D 2640                      ; non-fully-qualified # 🦹🏿‍♀ woman supervillain: dark skin tone",
    "\uD83E\uDDB9\uD83C\uDFFF\u200D\u2640",

    "1F9B9 200D 2642 FE0F                       ; fully-qualified     # 🦹‍♂️ man supervillain",
    "\uD83E\uDDB9\u200D\u2642\uFE0F",

    "1F9B9 200D 2642                            ; non-fully-qualified # 🦹‍♂ man supervillain",
    "\uD83E\uDDB9\u200D\u2642",

    "1F9B9 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🦹🏻‍♂️ man supervillain: light skin tone",
    "\uD83E\uDDB9\uD83C\uDFFB\u200D\u2642\uFE0F",

    "1F9B9 1F3FB 200D 2642                      ; non-fully-qualified # 🦹🏻‍♂ man supervillain: light skin tone",
    "\uD83E\uDDB9\uD83C\uDFFB\u200D\u2642",

    "1F9B9 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🦹🏼‍♂️ man supervillain: medium-light skin tone",
    "\uD83E\uDDB9\uD83C\uDFFC\u200D\u2642\uFE0F",

    "1F9B9 1F3FC 200D 2642                      ; non-fully-qualified # 🦹🏼‍♂ man supervillain: medium-light skin tone",
    "\uD83E\uDDB9\uD83C\uDFFC\u200D\u2642",

    "1F9B9 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🦹🏽‍♂️ man supervillain: medium skin tone",
    "\uD83E\uDDB9\uD83C\uDFFD\u200D\u2642\uFE0F",

    "1F9B9 1F3FD 200D 2642                      ; non-fully-qualified # 🦹🏽‍♂ man supervillain: medium skin tone",
    "\uD83E\uDDB9\uD83C\uDFFD\u200D\u2642",

    "1F9B9 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🦹🏾‍♂️ man supervillain: medium-dark skin tone",
    "\uD83E\uDDB9\uD83C\uDFFE\u200D\u2642\uFE0F",

    "1F9B9 1F3FE 200D 2642                      ; non-fully-qualified # 🦹🏾‍♂ man supervillain: medium-dark skin tone",
    "\uD83E\uDDB9\uD83C\uDFFE\u200D\u2642",

    "1F9B9 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🦹🏿‍♂️ man supervillain: dark skin tone",
    "\uD83E\uDDB9\uD83C\uDFFF\u200D\u2642\uFE0F",

    "1F9B9 1F3FF 200D 2642                      ; non-fully-qualified # 🦹🏿‍♂ man supervillain: dark skin tone",
    "\uD83E\uDDB9\uD83C\uDFFF\u200D\u2642",

    "1F9D9                                      ; fully-qualified     # 🧙 mage",
    "\uD83E\uDDD9",

    "1F9D9 1F3FB                                ; fully-qualified     # 🧙🏻 mage: light skin tone",
    "\uD83E\uDDD9\uD83C\uDFFB",

    "1F9D9 1F3FC                                ; fully-qualified     # 🧙🏼 mage: medium-light skin tone",
    "\uD83E\uDDD9\uD83C\uDFFC",

    "1F9D9 1F3FD                                ; fully-qualified     # 🧙🏽 mage: medium skin tone",
    "\uD83E\uDDD9\uD83C\uDFFD",

    "1F9D9 1F3FE                                ; fully-qualified     # 🧙🏾 mage: medium-dark skin tone",
    "\uD83E\uDDD9\uD83C\uDFFE",

    "1F9D9 1F3FF                                ; fully-qualified     # 🧙🏿 mage: dark skin tone",
    "\uD83E\uDDD9\uD83C\uDFFF",

    "1F9D9 200D 2640 FE0F                       ; fully-qualified     # 🧙‍♀️ woman mage",
    "\uD83E\uDDD9\u200D\u2640\uFE0F",

    "1F9D9 200D 2640                            ; non-fully-qualified # 🧙‍♀ woman mage",
    "\uD83E\uDDD9\u200D\u2640",

    "1F9D9 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🧙🏻‍♀️ woman mage: light skin tone",
    "\uD83E\uDDD9\uD83C\uDFFB\u200D\u2640\uFE0F",

    "1F9D9 1F3FB 200D 2640                      ; non-fully-qualified # 🧙🏻‍♀ woman mage: light skin tone",
    "\uD83E\uDDD9\uD83C\uDFFB\u200D\u2640",

    "1F9D9 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🧙🏼‍♀️ woman mage: medium-light skin tone",
    "\uD83E\uDDD9\uD83C\uDFFC\u200D\u2640\uFE0F",

    "1F9D9 1F3FC 200D 2640                      ; non-fully-qualified # 🧙🏼‍♀ woman mage: medium-light skin tone",
    "\uD83E\uDDD9\uD83C\uDFFC\u200D\u2640",

    "1F9D9 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🧙🏽‍♀️ woman mage: medium skin tone",
    "\uD83E\uDDD9\uD83C\uDFFD\u200D\u2640\uFE0F",

    "1F9D9 1F3FD 200D 2640                      ; non-fully-qualified # 🧙🏽‍♀ woman mage: medium skin tone",
    "\uD83E\uDDD9\uD83C\uDFFD\u200D\u2640",

    "1F9D9 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🧙🏾‍♀️ woman mage: medium-dark skin tone",
    "\uD83E\uDDD9\uD83C\uDFFE\u200D\u2640\uFE0F",

    "1F9D9 1F3FE 200D 2640                      ; non-fully-qualified # 🧙🏾‍♀ woman mage: medium-dark skin tone",
    "\uD83E\uDDD9\uD83C\uDFFE\u200D\u2640",

    "1F9D9 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🧙🏿‍♀️ woman mage: dark skin tone",
    "\uD83E\uDDD9\uD83C\uDFFF\u200D\u2640\uFE0F",

    "1F9D9 1F3FF 200D 2640                      ; non-fully-qualified # 🧙🏿‍♀ woman mage: dark skin tone",
    "\uD83E\uDDD9\uD83C\uDFFF\u200D\u2640",

    "1F9D9 200D 2642 FE0F                       ; fully-qualified     # 🧙‍♂️ man mage",
    "\uD83E\uDDD9\u200D\u2642\uFE0F",

    "1F9D9 200D 2642                            ; non-fully-qualified # 🧙‍♂ man mage",
    "\uD83E\uDDD9\u200D\u2642",

    "1F9D9 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🧙🏻‍♂️ man mage: light skin tone",
    "\uD83E\uDDD9\uD83C\uDFFB\u200D\u2642\uFE0F",

    "1F9D9 1F3FB 200D 2642                      ; non-fully-qualified # 🧙🏻‍♂ man mage: light skin tone",
    "\uD83E\uDDD9\uD83C\uDFFB\u200D\u2642",

    "1F9D9 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🧙🏼‍♂️ man mage: medium-light skin tone",
    "\uD83E\uDDD9\uD83C\uDFFC\u200D\u2642\uFE0F",

    "1F9D9 1F3FC 200D 2642                      ; non-fully-qualified # 🧙🏼‍♂ man mage: medium-light skin tone",
    "\uD83E\uDDD9\uD83C\uDFFC\u200D\u2642",

    "1F9D9 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🧙🏽‍♂️ man mage: medium skin tone",
    "\uD83E\uDDD9\uD83C\uDFFD\u200D\u2642\uFE0F",

    "1F9D9 1F3FD 200D 2642                      ; non-fully-qualified # 🧙🏽‍♂ man mage: medium skin tone",
    "\uD83E\uDDD9\uD83C\uDFFD\u200D\u2642",

    "1F9D9 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🧙🏾‍♂️ man mage: medium-dark skin tone",
    "\uD83E\uDDD9\uD83C\uDFFE\u200D\u2642\uFE0F",

    "1F9D9 1F3FE 200D 2642                      ; non-fully-qualified # 🧙🏾‍♂ man mage: medium-dark skin tone",
    "\uD83E\uDDD9\uD83C\uDFFE\u200D\u2642",

    "1F9D9 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🧙🏿‍♂️ man mage: dark skin tone",
    "\uD83E\uDDD9\uD83C\uDFFF\u200D\u2642\uFE0F",

    "1F9D9 1F3FF 200D 2642                      ; non-fully-qualified # 🧙🏿‍♂ man mage: dark skin tone",
    "\uD83E\uDDD9\uD83C\uDFFF\u200D\u2642",

    "1F9DA                                      ; fully-qualified     # 🧚 fairy",
    "\uD83E\uDDDA",

    "1F9DA 1F3FB                                ; fully-qualified     # 🧚🏻 fairy: light skin tone",
    "\uD83E\uDDDA\uD83C\uDFFB",

    "1F9DA 1F3FC                                ; fully-qualified     # 🧚🏼 fairy: medium-light skin tone",
    "\uD83E\uDDDA\uD83C\uDFFC",

    "1F9DA 1F3FD                                ; fully-qualified     # 🧚🏽 fairy: medium skin tone",
    "\uD83E\uDDDA\uD83C\uDFFD",

    "1F9DA 1F3FE                                ; fully-qualified     # 🧚🏾 fairy: medium-dark skin tone",
    "\uD83E\uDDDA\uD83C\uDFFE",

    "1F9DA 1F3FF                                ; fully-qualified     # 🧚🏿 fairy: dark skin tone",
    "\uD83E\uDDDA\uD83C\uDFFF",

    "1F9DA 200D 2640 FE0F                       ; fully-qualified     # 🧚‍♀️ woman fairy",
    "\uD83E\uDDDA\u200D\u2640\uFE0F",

    "1F9DA 200D 2640                            ; non-fully-qualified # 🧚‍♀ woman fairy",
    "\uD83E\uDDDA\u200D\u2640",

    "1F9DA 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🧚🏻‍♀️ woman fairy: light skin tone",
    "\uD83E\uDDDA\uD83C\uDFFB\u200D\u2640\uFE0F",

    "1F9DA 1F3FB 200D 2640                      ; non-fully-qualified # 🧚🏻‍♀ woman fairy: light skin tone",
    "\uD83E\uDDDA\uD83C\uDFFB\u200D\u2640",

    "1F9DA 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🧚🏼‍♀️ woman fairy: medium-light skin tone",
    "\uD83E\uDDDA\uD83C\uDFFC\u200D\u2640\uFE0F",

    "1F9DA 1F3FC 200D 2640                      ; non-fully-qualified # 🧚🏼‍♀ woman fairy: medium-light skin tone",
    "\uD83E\uDDDA\uD83C\uDFFC\u200D\u2640",

    "1F9DA 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🧚🏽‍♀️ woman fairy: medium skin tone",
    "\uD83E\uDDDA\uD83C\uDFFD\u200D\u2640\uFE0F",

    "1F9DA 1F3FD 200D 2640                      ; non-fully-qualified # 🧚🏽‍♀ woman fairy: medium skin tone",
    "\uD83E\uDDDA\uD83C\uDFFD\u200D\u2640",

    "1F9DA 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🧚🏾‍♀️ woman fairy: medium-dark skin tone",
    "\uD83E\uDDDA\uD83C\uDFFE\u200D\u2640\uFE0F",

    "1F9DA 1F3FE 200D 2640                      ; non-fully-qualified # 🧚🏾‍♀ woman fairy: medium-dark skin tone",
    "\uD83E\uDDDA\uD83C\uDFFE\u200D\u2640",

    "1F9DA 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🧚🏿‍♀️ woman fairy: dark skin tone",
    "\uD83E\uDDDA\uD83C\uDFFF\u200D\u2640\uFE0F",

    "1F9DA 1F3FF 200D 2640                      ; non-fully-qualified # 🧚🏿‍♀ woman fairy: dark skin tone",
    "\uD83E\uDDDA\uD83C\uDFFF\u200D\u2640",

    "1F9DA 200D 2642 FE0F                       ; fully-qualified     # 🧚‍♂️ man fairy",
    "\uD83E\uDDDA\u200D\u2642\uFE0F",

    "1F9DA 200D 2642                            ; non-fully-qualified # 🧚‍♂ man fairy",
    "\uD83E\uDDDA\u200D\u2642",

    "1F9DA 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🧚🏻‍♂️ man fairy: light skin tone",
    "\uD83E\uDDDA\uD83C\uDFFB\u200D\u2642\uFE0F",

    "1F9DA 1F3FB 200D 2642                      ; non-fully-qualified # 🧚🏻‍♂ man fairy: light skin tone",
    "\uD83E\uDDDA\uD83C\uDFFB\u200D\u2642",

    "1F9DA 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🧚🏼‍♂️ man fairy: medium-light skin tone",
    "\uD83E\uDDDA\uD83C\uDFFC\u200D\u2642\uFE0F",

    "1F9DA 1F3FC 200D 2642                      ; non-fully-qualified # 🧚🏼‍♂ man fairy: medium-light skin tone",
    "\uD83E\uDDDA\uD83C\uDFFC\u200D\u2642",

    "1F9DA 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🧚🏽‍♂️ man fairy: medium skin tone",
    "\uD83E\uDDDA\uD83C\uDFFD\u200D\u2642\uFE0F",

    "1F9DA 1F3FD 200D 2642                      ; non-fully-qualified # 🧚🏽‍♂ man fairy: medium skin tone",
    "\uD83E\uDDDA\uD83C\uDFFD\u200D\u2642",

    "1F9DA 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🧚🏾‍♂️ man fairy: medium-dark skin tone",
    "\uD83E\uDDDA\uD83C\uDFFE\u200D\u2642\uFE0F",

    "1F9DA 1F3FE 200D 2642                      ; non-fully-qualified # 🧚🏾‍♂ man fairy: medium-dark skin tone",
    "\uD83E\uDDDA\uD83C\uDFFE\u200D\u2642",

    "1F9DA 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🧚🏿‍♂️ man fairy: dark skin tone",
    "\uD83E\uDDDA\uD83C\uDFFF\u200D\u2642\uFE0F",

    "1F9DA 1F3FF 200D 2642                      ; non-fully-qualified # 🧚🏿‍♂ man fairy: dark skin tone",
    "\uD83E\uDDDA\uD83C\uDFFF\u200D\u2642",

    "1F9DB                                      ; fully-qualified     # 🧛 vampire",
    "\uD83E\uDDDB",

    "1F9DB 1F3FB                                ; fully-qualified     # 🧛🏻 vampire: light skin tone",
    "\uD83E\uDDDB\uD83C\uDFFB",

    "1F9DB 1F3FC                                ; fully-qualified     # 🧛🏼 vampire: medium-light skin tone",
    "\uD83E\uDDDB\uD83C\uDFFC",

    "1F9DB 1F3FD                                ; fully-qualified     # 🧛🏽 vampire: medium skin tone",
    "\uD83E\uDDDB\uD83C\uDFFD",

    "1F9DB 1F3FE                                ; fully-qualified     # 🧛🏾 vampire: medium-dark skin tone",
    "\uD83E\uDDDB\uD83C\uDFFE",

    "1F9DB 1F3FF                                ; fully-qualified     # 🧛🏿 vampire: dark skin tone",
    "\uD83E\uDDDB\uD83C\uDFFF",

    "1F9DB 200D 2640 FE0F                       ; fully-qualified     # 🧛‍♀️ woman vampire",
    "\uD83E\uDDDB\u200D\u2640\uFE0F",

    "1F9DB 200D 2640                            ; non-fully-qualified # 🧛‍♀ woman vampire",
    "\uD83E\uDDDB\u200D\u2640",

    "1F9DB 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🧛🏻‍♀️ woman vampire: light skin tone",
    "\uD83E\uDDDB\uD83C\uDFFB\u200D\u2640\uFE0F",

    "1F9DB 1F3FB 200D 2640                      ; non-fully-qualified # 🧛🏻‍♀ woman vampire: light skin tone",
    "\uD83E\uDDDB\uD83C\uDFFB\u200D\u2640",

    "1F9DB 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🧛🏼‍♀️ woman vampire: medium-light skin tone",
    "\uD83E\uDDDB\uD83C\uDFFC\u200D\u2640\uFE0F",

    "1F9DB 1F3FC 200D 2640                      ; non-fully-qualified # 🧛🏼‍♀ woman vampire: medium-light skin tone",
    "\uD83E\uDDDB\uD83C\uDFFC\u200D\u2640",

    "1F9DB 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🧛🏽‍♀️ woman vampire: medium skin tone",
    "\uD83E\uDDDB\uD83C\uDFFD\u200D\u2640\uFE0F",

    "1F9DB 1F3FD 200D 2640                      ; non-fully-qualified # 🧛🏽‍♀ woman vampire: medium skin tone",
    "\uD83E\uDDDB\uD83C\uDFFD\u200D\u2640",

    "1F9DB 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🧛🏾‍♀️ woman vampire: medium-dark skin tone",
    "\uD83E\uDDDB\uD83C\uDFFE\u200D\u2640\uFE0F",

    "1F9DB 1F3FE 200D 2640                      ; non-fully-qualified # 🧛🏾‍♀ woman vampire: medium-dark skin tone",
    "\uD83E\uDDDB\uD83C\uDFFE\u200D\u2640",

    "1F9DB 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🧛🏿‍♀️ woman vampire: dark skin tone",
    "\uD83E\uDDDB\uD83C\uDFFF\u200D\u2640\uFE0F",

    "1F9DB 1F3FF 200D 2640                      ; non-fully-qualified # 🧛🏿‍♀ woman vampire: dark skin tone",
    "\uD83E\uDDDB\uD83C\uDFFF\u200D\u2640",

    "1F9DB 200D 2642 FE0F                       ; fully-qualified     # 🧛‍♂️ man vampire",
    "\uD83E\uDDDB\u200D\u2642\uFE0F",

    "1F9DB 200D 2642                            ; non-fully-qualified # 🧛‍♂ man vampire",
    "\uD83E\uDDDB\u200D\u2642",

    "1F9DB 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🧛🏻‍♂️ man vampire: light skin tone",
    "\uD83E\uDDDB\uD83C\uDFFB\u200D\u2642\uFE0F",

    "1F9DB 1F3FB 200D 2642                      ; non-fully-qualified # 🧛🏻‍♂ man vampire: light skin tone",
    "\uD83E\uDDDB\uD83C\uDFFB\u200D\u2642",

    "1F9DB 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🧛🏼‍♂️ man vampire: medium-light skin tone",
    "\uD83E\uDDDB\uD83C\uDFFC\u200D\u2642\uFE0F",

    "1F9DB 1F3FC 200D 2642                      ; non-fully-qualified # 🧛🏼‍♂ man vampire: medium-light skin tone",
    "\uD83E\uDDDB\uD83C\uDFFC\u200D\u2642",

    "1F9DB 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🧛🏽‍♂️ man vampire: medium skin tone",
    "\uD83E\uDDDB\uD83C\uDFFD\u200D\u2642\uFE0F",

    "1F9DB 1F3FD 200D 2642                      ; non-fully-qualified # 🧛🏽‍♂ man vampire: medium skin tone",
    "\uD83E\uDDDB\uD83C\uDFFD\u200D\u2642",

    "1F9DB 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🧛🏾‍♂️ man vampire: medium-dark skin tone",
    "\uD83E\uDDDB\uD83C\uDFFE\u200D\u2642\uFE0F",

    "1F9DB 1F3FE 200D 2642                      ; non-fully-qualified # 🧛🏾‍♂ man vampire: medium-dark skin tone",
    "\uD83E\uDDDB\uD83C\uDFFE\u200D\u2642",

    "1F9DB 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🧛🏿‍♂️ man vampire: dark skin tone",
    "\uD83E\uDDDB\uD83C\uDFFF\u200D\u2642\uFE0F",

    "1F9DB 1F3FF 200D 2642                      ; non-fully-qualified # 🧛🏿‍♂ man vampire: dark skin tone",
    "\uD83E\uDDDB\uD83C\uDFFF\u200D\u2642",

    "1F9DC                                      ; fully-qualified     # 🧜 merperson",
    "\uD83E\uDDDC",

    "1F9DC 1F3FB                                ; fully-qualified     # 🧜🏻 merperson: light skin tone",
    "\uD83E\uDDDC\uD83C\uDFFB",

    "1F9DC 1F3FC                                ; fully-qualified     # 🧜🏼 merperson: medium-light skin tone",
    "\uD83E\uDDDC\uD83C\uDFFC",

    "1F9DC 1F3FD                                ; fully-qualified     # 🧜🏽 merperson: medium skin tone",
    "\uD83E\uDDDC\uD83C\uDFFD",

    "1F9DC 1F3FE                                ; fully-qualified     # 🧜🏾 merperson: medium-dark skin tone",
    "\uD83E\uDDDC\uD83C\uDFFE",

    "1F9DC 1F3FF                                ; fully-qualified     # 🧜🏿 merperson: dark skin tone",
    "\uD83E\uDDDC\uD83C\uDFFF",

    "1F9DC 200D 2640 FE0F                       ; fully-qualified     # 🧜‍♀️ mermaid",
    "\uD83E\uDDDC\u200D\u2640\uFE0F",

    "1F9DC 200D 2640                            ; non-fully-qualified # 🧜‍♀ mermaid",
    "\uD83E\uDDDC\u200D\u2640",

    "1F9DC 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🧜🏻‍♀️ mermaid: light skin tone",
    "\uD83E\uDDDC\uD83C\uDFFB\u200D\u2640\uFE0F",

    "1F9DC 1F3FB 200D 2640                      ; non-fully-qualified # 🧜🏻‍♀ mermaid: light skin tone",
    "\uD83E\uDDDC\uD83C\uDFFB\u200D\u2640",

    "1F9DC 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🧜🏼‍♀️ mermaid: medium-light skin tone",
    "\uD83E\uDDDC\uD83C\uDFFC\u200D\u2640\uFE0F",

    "1F9DC 1F3FC 200D 2640                      ; non-fully-qualified # 🧜🏼‍♀ mermaid: medium-light skin tone",
    "\uD83E\uDDDC\uD83C\uDFFC\u200D\u2640",

    "1F9DC 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🧜🏽‍♀️ mermaid: medium skin tone",
    "\uD83E\uDDDC\uD83C\uDFFD\u200D\u2640\uFE0F",

    "1F9DC 1F3FD 200D 2640                      ; non-fully-qualified # 🧜🏽‍♀ mermaid: medium skin tone",
    "\uD83E\uDDDC\uD83C\uDFFD\u200D\u2640",

    "1F9DC 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🧜🏾‍♀️ mermaid: medium-dark skin tone",
    "\uD83E\uDDDC\uD83C\uDFFE\u200D\u2640\uFE0F",

    "1F9DC 1F3FE 200D 2640                      ; non-fully-qualified # 🧜🏾‍♀ mermaid: medium-dark skin tone",
    "\uD83E\uDDDC\uD83C\uDFFE\u200D\u2640",

    "1F9DC 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🧜🏿‍♀️ mermaid: dark skin tone",
    "\uD83E\uDDDC\uD83C\uDFFF\u200D\u2640\uFE0F",

    "1F9DC 1F3FF 200D 2640                      ; non-fully-qualified # 🧜🏿‍♀ mermaid: dark skin tone",
    "\uD83E\uDDDC\uD83C\uDFFF\u200D\u2640",

    "1F9DC 200D 2642 FE0F                       ; fully-qualified     # 🧜‍♂️ merman",
    "\uD83E\uDDDC\u200D\u2642\uFE0F",

    "1F9DC 200D 2642                            ; non-fully-qualified # 🧜‍♂ merman",
    "\uD83E\uDDDC\u200D\u2642",

    "1F9DC 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🧜🏻‍♂️ merman: light skin tone",
    "\uD83E\uDDDC\uD83C\uDFFB\u200D\u2642\uFE0F",

    "1F9DC 1F3FB 200D 2642                      ; non-fully-qualified # 🧜🏻‍♂ merman: light skin tone",
    "\uD83E\uDDDC\uD83C\uDFFB\u200D\u2642",

    "1F9DC 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🧜🏼‍♂️ merman: medium-light skin tone",
    "\uD83E\uDDDC\uD83C\uDFFC\u200D\u2642\uFE0F",

    "1F9DC 1F3FC 200D 2642                      ; non-fully-qualified # 🧜🏼‍♂ merman: medium-light skin tone",
    "\uD83E\uDDDC\uD83C\uDFFC\u200D\u2642",

    "1F9DC 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🧜🏽‍♂️ merman: medium skin tone",
    "\uD83E\uDDDC\uD83C\uDFFD\u200D\u2642\uFE0F",

    "1F9DC 1F3FD 200D 2642                      ; non-fully-qualified # 🧜🏽‍♂ merman: medium skin tone",
    "\uD83E\uDDDC\uD83C\uDFFD\u200D\u2642",

    "1F9DC 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🧜🏾‍♂️ merman: medium-dark skin tone",
    "\uD83E\uDDDC\uD83C\uDFFE\u200D\u2642\uFE0F",

    "1F9DC 1F3FE 200D 2642                      ; non-fully-qualified # 🧜🏾‍♂ merman: medium-dark skin tone",
    "\uD83E\uDDDC\uD83C\uDFFE\u200D\u2642",

    "1F9DC 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🧜🏿‍♂️ merman: dark skin tone",
    "\uD83E\uDDDC\uD83C\uDFFF\u200D\u2642\uFE0F",

    "1F9DC 1F3FF 200D 2642                      ; non-fully-qualified # 🧜🏿‍♂ merman: dark skin tone",
    "\uD83E\uDDDC\uD83C\uDFFF\u200D\u2642",

    "1F9DD                                      ; fully-qualified     # 🧝 elf",
    "\uD83E\uDDDD",

    "1F9DD 1F3FB                                ; fully-qualified     # 🧝🏻 elf: light skin tone",
    "\uD83E\uDDDD\uD83C\uDFFB",

    "1F9DD 1F3FC                                ; fully-qualified     # 🧝🏼 elf: medium-light skin tone",
    "\uD83E\uDDDD\uD83C\uDFFC",

    "1F9DD 1F3FD                                ; fully-qualified     # 🧝🏽 elf: medium skin tone",
    "\uD83E\uDDDD\uD83C\uDFFD",

    "1F9DD 1F3FE                                ; fully-qualified     # 🧝🏾 elf: medium-dark skin tone",
    "\uD83E\uDDDD\uD83C\uDFFE",

    "1F9DD 1F3FF                                ; fully-qualified     # 🧝🏿 elf: dark skin tone",
    "\uD83E\uDDDD\uD83C\uDFFF",

    "1F9DD 200D 2640 FE0F                       ; fully-qualified     # 🧝‍♀️ woman elf",
    "\uD83E\uDDDD\u200D\u2640\uFE0F",

    "1F9DD 200D 2640                            ; non-fully-qualified # 🧝‍♀ woman elf",
    "\uD83E\uDDDD\u200D\u2640",

    "1F9DD 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🧝🏻‍♀️ woman elf: light skin tone",
    "\uD83E\uDDDD\uD83C\uDFFB\u200D\u2640\uFE0F",

    "1F9DD 1F3FB 200D 2640                      ; non-fully-qualified # 🧝🏻‍♀ woman elf: light skin tone",
    "\uD83E\uDDDD\uD83C\uDFFB\u200D\u2640",

    "1F9DD 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🧝🏼‍♀️ woman elf: medium-light skin tone",
    "\uD83E\uDDDD\uD83C\uDFFC\u200D\u2640\uFE0F",

    "1F9DD 1F3FC 200D 2640                      ; non-fully-qualified # 🧝🏼‍♀ woman elf: medium-light skin tone",
    "\uD83E\uDDDD\uD83C\uDFFC\u200D\u2640",

    "1F9DD 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🧝🏽‍♀️ woman elf: medium skin tone",
    "\uD83E\uDDDD\uD83C\uDFFD\u200D\u2640\uFE0F",

    "1F9DD 1F3FD 200D 2640                      ; non-fully-qualified # 🧝🏽‍♀ woman elf: medium skin tone",
    "\uD83E\uDDDD\uD83C\uDFFD\u200D\u2640",

    "1F9DD 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🧝🏾‍♀️ woman elf: medium-dark skin tone",
    "\uD83E\uDDDD\uD83C\uDFFE\u200D\u2640\uFE0F",

    "1F9DD 1F3FE 200D 2640                      ; non-fully-qualified # 🧝🏾‍♀ woman elf: medium-dark skin tone",
    "\uD83E\uDDDD\uD83C\uDFFE\u200D\u2640",

    "1F9DD 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🧝🏿‍♀️ woman elf: dark skin tone",
    "\uD83E\uDDDD\uD83C\uDFFF\u200D\u2640\uFE0F",

    "1F9DD 1F3FF 200D 2640                      ; non-fully-qualified # 🧝🏿‍♀ woman elf: dark skin tone",
    "\uD83E\uDDDD\uD83C\uDFFF\u200D\u2640",

    "1F9DD 200D 2642 FE0F                       ; fully-qualified     # 🧝‍♂️ man elf",
    "\uD83E\uDDDD\u200D\u2642\uFE0F",

    "1F9DD 200D 2642                            ; non-fully-qualified # 🧝‍♂ man elf",
    "\uD83E\uDDDD\u200D\u2642",

    "1F9DD 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🧝🏻‍♂️ man elf: light skin tone",
    "\uD83E\uDDDD\uD83C\uDFFB\u200D\u2642\uFE0F",

    "1F9DD 1F3FB 200D 2642                      ; non-fully-qualified # 🧝🏻‍♂ man elf: light skin tone",
    "\uD83E\uDDDD\uD83C\uDFFB\u200D\u2642",

    "1F9DD 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🧝🏼‍♂️ man elf: medium-light skin tone",
    "\uD83E\uDDDD\uD83C\uDFFC\u200D\u2642\uFE0F",

    "1F9DD 1F3FC 200D 2642                      ; non-fully-qualified # 🧝🏼‍♂ man elf: medium-light skin tone",
    "\uD83E\uDDDD\uD83C\uDFFC\u200D\u2642",

    "1F9DD 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🧝🏽‍♂️ man elf: medium skin tone",
    "\uD83E\uDDDD\uD83C\uDFFD\u200D\u2642\uFE0F",

    "1F9DD 1F3FD 200D 2642                      ; non-fully-qualified # 🧝🏽‍♂ man elf: medium skin tone",
    "\uD83E\uDDDD\uD83C\uDFFD\u200D\u2642",

    "1F9DD 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🧝🏾‍♂️ man elf: medium-dark skin tone",
    "\uD83E\uDDDD\uD83C\uDFFE\u200D\u2642\uFE0F",

    "1F9DD 1F3FE 200D 2642                      ; non-fully-qualified # 🧝🏾‍♂ man elf: medium-dark skin tone",
    "\uD83E\uDDDD\uD83C\uDFFE\u200D\u2642",

    "1F9DD 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🧝🏿‍♂️ man elf: dark skin tone",
    "\uD83E\uDDDD\uD83C\uDFFF\u200D\u2642\uFE0F",

    "1F9DD 1F3FF 200D 2642                      ; non-fully-qualified # 🧝🏿‍♂ man elf: dark skin tone",
    "\uD83E\uDDDD\uD83C\uDFFF\u200D\u2642",

    "1F9DE                                      ; fully-qualified     # 🧞 genie",
    "\uD83E\uDDDE",

    "1F9DE 200D 2640 FE0F                       ; fully-qualified     # 🧞‍♀️ woman genie",
    "\uD83E\uDDDE\u200D\u2640\uFE0F",

    "1F9DE 200D 2640                            ; non-fully-qualified # 🧞‍♀ woman genie",
    "\uD83E\uDDDE\u200D\u2640",

    "1F9DE 200D 2642 FE0F                       ; fully-qualified     # 🧞‍♂️ man genie",
    "\uD83E\uDDDE\u200D\u2642\uFE0F",

    "1F9DE 200D 2642                            ; non-fully-qualified # 🧞‍♂ man genie",
    "\uD83E\uDDDE\u200D\u2642",

    "1F9DF                                      ; fully-qualified     # 🧟 zombie",
    "\uD83E\uDDDF",

    "1F9DF 200D 2640 FE0F                       ; fully-qualified     # 🧟‍♀️ woman zombie",
    "\uD83E\uDDDF\u200D\u2640\uFE0F",

    "1F9DF 200D 2640                            ; non-fully-qualified # 🧟‍♀ woman zombie",
    "\uD83E\uDDDF\u200D\u2640",

    "1F9DF 200D 2642 FE0F                       ; fully-qualified     # 🧟‍♂️ man zombie",
    "\uD83E\uDDDF\u200D\u2642\uFE0F",

    "1F9DF 200D 2642                            ; non-fully-qualified # 🧟‍♂ man zombie",
    "\uD83E\uDDDF\u200D\u2642",

    "1F64D                                      ; fully-qualified     # 🙍 person frowning",
    "\uD83D\uDE4D",

    "1F64D 1F3FB                                ; fully-qualified     # 🙍🏻 person frowning: light skin tone",
    "\uD83D\uDE4D\uD83C\uDFFB",

    "1F64D 1F3FC                                ; fully-qualified     # 🙍🏼 person frowning: medium-light skin tone",
    "\uD83D\uDE4D\uD83C\uDFFC",

    "1F64D 1F3FD                                ; fully-qualified     # 🙍🏽 person frowning: medium skin tone",
    "\uD83D\uDE4D\uD83C\uDFFD",

    "1F64D 1F3FE                                ; fully-qualified     # 🙍🏾 person frowning: medium-dark skin tone",
    "\uD83D\uDE4D\uD83C\uDFFE",

    "1F64D 1F3FF                                ; fully-qualified     # 🙍🏿 person frowning: dark skin tone",
    "\uD83D\uDE4D\uD83C\uDFFF",

    "1F64D 200D 2642 FE0F                       ; fully-qualified     # 🙍‍♂️ man frowning",
    "\uD83D\uDE4D\u200D\u2642\uFE0F",

    "1F64D 200D 2642                            ; non-fully-qualified # 🙍‍♂ man frowning",
    "\uD83D\uDE4D\u200D\u2642",

    "1F64D 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🙍🏻‍♂️ man frowning: light skin tone",
    "\uD83D\uDE4D\uD83C\uDFFB\u200D\u2642\uFE0F",

    "1F64D 1F3FB 200D 2642                      ; non-fully-qualified # 🙍🏻‍♂ man frowning: light skin tone",
    "\uD83D\uDE4D\uD83C\uDFFB\u200D\u2642",

    "1F64D 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🙍🏼‍♂️ man frowning: medium-light skin tone",
    "\uD83D\uDE4D\uD83C\uDFFC\u200D\u2642\uFE0F",

    "1F64D 1F3FC 200D 2642                      ; non-fully-qualified # 🙍🏼‍♂ man frowning: medium-light skin tone",
    "\uD83D\uDE4D\uD83C\uDFFC\u200D\u2642",

    "1F64D 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🙍🏽‍♂️ man frowning: medium skin tone",
    "\uD83D\uDE4D\uD83C\uDFFD\u200D\u2642\uFE0F",

    "1F64D 1F3FD 200D 2642                      ; non-fully-qualified # 🙍🏽‍♂ man frowning: medium skin tone",
    "\uD83D\uDE4D\uD83C\uDFFD\u200D\u2642",

    "1F64D 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🙍🏾‍♂️ man frowning: medium-dark skin tone",
    "\uD83D\uDE4D\uD83C\uDFFE\u200D\u2642\uFE0F",

    "1F64D 1F3FE 200D 2642                      ; non-fully-qualified # 🙍🏾‍♂ man frowning: medium-dark skin tone",
    "\uD83D\uDE4D\uD83C\uDFFE\u200D\u2642",

    "1F64D 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🙍🏿‍♂️ man frowning: dark skin tone",
    "\uD83D\uDE4D\uD83C\uDFFF\u200D\u2642\uFE0F",

    "1F64D 1F3FF 200D 2642                      ; non-fully-qualified # 🙍🏿‍♂ man frowning: dark skin tone",
    "\uD83D\uDE4D\uD83C\uDFFF\u200D\u2642",

    "1F64D 200D 2640 FE0F                       ; fully-qualified     # 🙍‍♀️ woman frowning",
    "\uD83D\uDE4D\u200D\u2640\uFE0F",

    "1F64D 200D 2640                            ; non-fully-qualified # 🙍‍♀ woman frowning",
    "\uD83D\uDE4D\u200D\u2640",

    "1F64D 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🙍🏻‍♀️ woman frowning: light skin tone",
    "\uD83D\uDE4D\uD83C\uDFFB\u200D\u2640\uFE0F",

    "1F64D 1F3FB 200D 2640                      ; non-fully-qualified # 🙍🏻‍♀ woman frowning: light skin tone",
    "\uD83D\uDE4D\uD83C\uDFFB\u200D\u2640",

    "1F64D 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🙍🏼‍♀️ woman frowning: medium-light skin tone",
    "\uD83D\uDE4D\uD83C\uDFFC\u200D\u2640\uFE0F",

    "1F64D 1F3FC 200D 2640                      ; non-fully-qualified # 🙍🏼‍♀ woman frowning: medium-light skin tone",
    "\uD83D\uDE4D\uD83C\uDFFC\u200D\u2640",

    "1F64D 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🙍🏽‍♀️ woman frowning: medium skin tone",
    "\uD83D\uDE4D\uD83C\uDFFD\u200D\u2640\uFE0F",

    "1F64D 1F3FD 200D 2640                      ; non-fully-qualified # 🙍🏽‍♀ woman frowning: medium skin tone",
    "\uD83D\uDE4D\uD83C\uDFFD\u200D\u2640",

    "1F64D 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🙍🏾‍♀️ woman frowning: medium-dark skin tone",
    "\uD83D\uDE4D\uD83C\uDFFE\u200D\u2640\uFE0F",

    "1F64D 1F3FE 200D 2640                      ; non-fully-qualified # 🙍🏾‍♀ woman frowning: medium-dark skin tone",
    "\uD83D\uDE4D\uD83C\uDFFE\u200D\u2640",

    "1F64D 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🙍🏿‍♀️ woman frowning: dark skin tone",
    "\uD83D\uDE4D\uD83C\uDFFF\u200D\u2640\uFE0F",

    "1F64D 1F3FF 200D 2640                      ; non-fully-qualified # 🙍🏿‍♀ woman frowning: dark skin tone",
    "\uD83D\uDE4D\uD83C\uDFFF\u200D\u2640",

    "1F64E                                      ; fully-qualified     # 🙎 person pouting",
    "\uD83D\uDE4E",

    "1F64E 1F3FB                                ; fully-qualified     # 🙎🏻 person pouting: light skin tone",
    "\uD83D\uDE4E\uD83C\uDFFB",

    "1F64E 1F3FC                                ; fully-qualified     # 🙎🏼 person pouting: medium-light skin tone",
    "\uD83D\uDE4E\uD83C\uDFFC",

    "1F64E 1F3FD                                ; fully-qualified     # 🙎🏽 person pouting: medium skin tone",
    "\uD83D\uDE4E\uD83C\uDFFD",

    "1F64E 1F3FE                                ; fully-qualified     # 🙎🏾 person pouting: medium-dark skin tone",
    "\uD83D\uDE4E\uD83C\uDFFE",

    "1F64E 1F3FF                                ; fully-qualified     # 🙎🏿 person pouting: dark skin tone",
    "\uD83D\uDE4E\uD83C\uDFFF",

    "1F64E 200D 2642 FE0F                       ; fully-qualified     # 🙎‍♂️ man pouting",
    "\uD83D\uDE4E\u200D\u2642\uFE0F",

    "1F64E 200D 2642                            ; non-fully-qualified # 🙎‍♂ man pouting",
    "\uD83D\uDE4E\u200D\u2642",

    "1F64E 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🙎🏻‍♂️ man pouting: light skin tone",
    "\uD83D\uDE4E\uD83C\uDFFB\u200D\u2642\uFE0F",

    "1F64E 1F3FB 200D 2642                      ; non-fully-qualified # 🙎🏻‍♂ man pouting: light skin tone",
    "\uD83D\uDE4E\uD83C\uDFFB\u200D\u2642",

    "1F64E 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🙎🏼‍♂️ man pouting: medium-light skin tone",
    "\uD83D\uDE4E\uD83C\uDFFC\u200D\u2642\uFE0F",

    "1F64E 1F3FC 200D 2642                      ; non-fully-qualified # 🙎🏼‍♂ man pouting: medium-light skin tone",
    "\uD83D\uDE4E\uD83C\uDFFC\u200D\u2642",

    "1F64E 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🙎🏽‍♂️ man pouting: medium skin tone",
    "\uD83D\uDE4E\uD83C\uDFFD\u200D\u2642\uFE0F",

    "1F64E 1F3FD 200D 2642                      ; non-fully-qualified # 🙎🏽‍♂ man pouting: medium skin tone",
    "\uD83D\uDE4E\uD83C\uDFFD\u200D\u2642",

    "1F64E 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🙎🏾‍♂️ man pouting: medium-dark skin tone",
    "\uD83D\uDE4E\uD83C\uDFFE\u200D\u2642\uFE0F",

    "1F64E 1F3FE 200D 2642                      ; non-fully-qualified # 🙎🏾‍♂ man pouting: medium-dark skin tone",
    "\uD83D\uDE4E\uD83C\uDFFE\u200D\u2642",

    "1F64E 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🙎🏿‍♂️ man pouting: dark skin tone",
    "\uD83D\uDE4E\uD83C\uDFFF\u200D\u2642\uFE0F",

    "1F64E 1F3FF 200D 2642                      ; non-fully-qualified # 🙎🏿‍♂ man pouting: dark skin tone",
    "\uD83D\uDE4E\uD83C\uDFFF\u200D\u2642",

    "1F64E 200D 2640 FE0F                       ; fully-qualified     # 🙎‍♀️ woman pouting",
    "\uD83D\uDE4E\u200D\u2640\uFE0F",

    "1F64E 200D 2640                            ; non-fully-qualified # 🙎‍♀ woman pouting",
    "\uD83D\uDE4E\u200D\u2640",

    "1F64E 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🙎🏻‍♀️ woman pouting: light skin tone",
    "\uD83D\uDE4E\uD83C\uDFFB\u200D\u2640\uFE0F",

    "1F64E 1F3FB 200D 2640                      ; non-fully-qualified # 🙎🏻‍♀ woman pouting: light skin tone",
    "\uD83D\uDE4E\uD83C\uDFFB\u200D\u2640",

    "1F64E 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🙎🏼‍♀️ woman pouting: medium-light skin tone",
    "\uD83D\uDE4E\uD83C\uDFFC\u200D\u2640\uFE0F",

    "1F64E 1F3FC 200D 2640                      ; non-fully-qualified # 🙎🏼‍♀ woman pouting: medium-light skin tone",
    "\uD83D\uDE4E\uD83C\uDFFC\u200D\u2640",

    "1F64E 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🙎🏽‍♀️ woman pouting: medium skin tone",
    "\uD83D\uDE4E\uD83C\uDFFD\u200D\u2640\uFE0F",

    "1F64E 1F3FD 200D 2640                      ; non-fully-qualified # 🙎🏽‍♀ woman pouting: medium skin tone",
    "\uD83D\uDE4E\uD83C\uDFFD\u200D\u2640",

    "1F64E 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🙎🏾‍♀️ woman pouting: medium-dark skin tone",
    "\uD83D\uDE4E\uD83C\uDFFE\u200D\u2640\uFE0F",

    "1F64E 1F3FE 200D 2640                      ; non-fully-qualified # 🙎🏾‍♀ woman pouting: medium-dark skin tone",
    "\uD83D\uDE4E\uD83C\uDFFE\u200D\u2640",

    "1F64E 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🙎🏿‍♀️ woman pouting: dark skin tone",
    "\uD83D\uDE4E\uD83C\uDFFF\u200D\u2640\uFE0F",

    "1F64E 1F3FF 200D 2640                      ; non-fully-qualified # 🙎🏿‍♀ woman pouting: dark skin tone",
    "\uD83D\uDE4E\uD83C\uDFFF\u200D\u2640",

    "1F645                                      ; fully-qualified     # 🙅 person gesturing NO",
    "\uD83D\uDE45",

    "1F645 1F3FB                                ; fully-qualified     # 🙅🏻 person gesturing NO: light skin tone",
    "\uD83D\uDE45\uD83C\uDFFB",

    "1F645 1F3FC                                ; fully-qualified     # 🙅🏼 person gesturing NO: medium-light skin tone",
    "\uD83D\uDE45\uD83C\uDFFC",

    "1F645 1F3FD                                ; fully-qualified     # 🙅🏽 person gesturing NO: medium skin tone",
    "\uD83D\uDE45\uD83C\uDFFD",

    "1F645 1F3FE                                ; fully-qualified     # 🙅🏾 person gesturing NO: medium-dark skin tone",
    "\uD83D\uDE45\uD83C\uDFFE",

    "1F645 1F3FF                                ; fully-qualified     # 🙅🏿 person gesturing NO: dark skin tone",
    "\uD83D\uDE45\uD83C\uDFFF",

    "1F645 200D 2642 FE0F                       ; fully-qualified     # 🙅‍♂️ man gesturing NO",
    "\uD83D\uDE45\u200D\u2642\uFE0F",

    "1F645 200D 2642                            ; non-fully-qualified # 🙅‍♂ man gesturing NO",
    "\uD83D\uDE45\u200D\u2642",

    "1F645 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🙅🏻‍♂️ man gesturing NO: light skin tone",
    "\uD83D\uDE45\uD83C\uDFFB\u200D\u2642\uFE0F",

    "1F645 1F3FB 200D 2642                      ; non-fully-qualified # 🙅🏻‍♂ man gesturing NO: light skin tone",
    "\uD83D\uDE45\uD83C\uDFFB\u200D\u2642",

    "1F645 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🙅🏼‍♂️ man gesturing NO: medium-light skin tone",
    "\uD83D\uDE45\uD83C\uDFFC\u200D\u2642\uFE0F",

    "1F645 1F3FC 200D 2642                      ; non-fully-qualified # 🙅🏼‍♂ man gesturing NO: medium-light skin tone",
    "\uD83D\uDE45\uD83C\uDFFC\u200D\u2642",

    "1F645 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🙅🏽‍♂️ man gesturing NO: medium skin tone",
    "\uD83D\uDE45\uD83C\uDFFD\u200D\u2642\uFE0F",

    "1F645 1F3FD 200D 2642                      ; non-fully-qualified # 🙅🏽‍♂ man gesturing NO: medium skin tone",
    "\uD83D\uDE45\uD83C\uDFFD\u200D\u2642",

    "1F645 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🙅🏾‍♂️ man gesturing NO: medium-dark skin tone",
    "\uD83D\uDE45\uD83C\uDFFE\u200D\u2642\uFE0F",

    "1F645 1F3FE 200D 2642                      ; non-fully-qualified # 🙅🏾‍♂ man gesturing NO: medium-dark skin tone",
    "\uD83D\uDE45\uD83C\uDFFE\u200D\u2642",

    "1F645 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🙅🏿‍♂️ man gesturing NO: dark skin tone",
    "\uD83D\uDE45\uD83C\uDFFF\u200D\u2642\uFE0F",

    "1F645 1F3FF 200D 2642                      ; non-fully-qualified # 🙅🏿‍♂ man gesturing NO: dark skin tone",
    "\uD83D\uDE45\uD83C\uDFFF\u200D\u2642",

    "1F645 200D 2640 FE0F                       ; fully-qualified     # 🙅‍♀️ woman gesturing NO",
    "\uD83D\uDE45\u200D\u2640\uFE0F",

    "1F645 200D 2640                            ; non-fully-qualified # 🙅‍♀ woman gesturing NO",
    "\uD83D\uDE45\u200D\u2640",

    "1F645 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🙅🏻‍♀️ woman gesturing NO: light skin tone",
    "\uD83D\uDE45\uD83C\uDFFB\u200D\u2640\uFE0F",

    "1F645 1F3FB 200D 2640                      ; non-fully-qualified # 🙅🏻‍♀ woman gesturing NO: light skin tone",
    "\uD83D\uDE45\uD83C\uDFFB\u200D\u2640",

    "1F645 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🙅🏼‍♀️ woman gesturing NO: medium-light skin tone",
    "\uD83D\uDE45\uD83C\uDFFC\u200D\u2640\uFE0F",

    "1F645 1F3FC 200D 2640                      ; non-fully-qualified # 🙅🏼‍♀ woman gesturing NO: medium-light skin tone",
    "\uD83D\uDE45\uD83C\uDFFC\u200D\u2640",

    "1F645 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🙅🏽‍♀️ woman gesturing NO: medium skin tone",
    "\uD83D\uDE45\uD83C\uDFFD\u200D\u2640\uFE0F",

    "1F645 1F3FD 200D 2640                      ; non-fully-qualified # 🙅🏽‍♀ woman gesturing NO: medium skin tone",
    "\uD83D\uDE45\uD83C\uDFFD\u200D\u2640",

    "1F645 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🙅🏾‍♀️ woman gesturing NO: medium-dark skin tone",
    "\uD83D\uDE45\uD83C\uDFFE\u200D\u2640\uFE0F",

    "1F645 1F3FE 200D 2640                      ; non-fully-qualified # 🙅🏾‍♀ woman gesturing NO: medium-dark skin tone",
    "\uD83D\uDE45\uD83C\uDFFE\u200D\u2640",

    "1F645 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🙅🏿‍♀️ woman gesturing NO: dark skin tone",
    "\uD83D\uDE45\uD83C\uDFFF\u200D\u2640\uFE0F",

    "1F645 1F3FF 200D 2640                      ; non-fully-qualified # 🙅🏿‍♀ woman gesturing NO: dark skin tone",
    "\uD83D\uDE45\uD83C\uDFFF\u200D\u2640",

    "1F646                                      ; fully-qualified     # 🙆 person gesturing OK",
    "\uD83D\uDE46",

    "1F646 1F3FB                                ; fully-qualified     # 🙆🏻 person gesturing OK: light skin tone",
    "\uD83D\uDE46\uD83C\uDFFB",

    "1F646 1F3FC                                ; fully-qualified     # 🙆🏼 person gesturing OK: medium-light skin tone",
    "\uD83D\uDE46\uD83C\uDFFC",

    "1F646 1F3FD                                ; fully-qualified     # 🙆🏽 person gesturing OK: medium skin tone",
    "\uD83D\uDE46\uD83C\uDFFD",

    "1F646 1F3FE                                ; fully-qualified     # 🙆🏾 person gesturing OK: medium-dark skin tone",
    "\uD83D\uDE46\uD83C\uDFFE",

    "1F646 1F3FF                                ; fully-qualified     # 🙆🏿 person gesturing OK: dark skin tone",
    "\uD83D\uDE46\uD83C\uDFFF",

    "1F646 200D 2642 FE0F                       ; fully-qualified     # 🙆‍♂️ man gesturing OK",
    "\uD83D\uDE46\u200D\u2642\uFE0F",

    "1F646 200D 2642                            ; non-fully-qualified # 🙆‍♂ man gesturing OK",
    "\uD83D\uDE46\u200D\u2642",

    "1F646 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🙆🏻‍♂️ man gesturing OK: light skin tone",
    "\uD83D\uDE46\uD83C\uDFFB\u200D\u2642\uFE0F",

    "1F646 1F3FB 200D 2642                      ; non-fully-qualified # 🙆🏻‍♂ man gesturing OK: light skin tone",
    "\uD83D\uDE46\uD83C\uDFFB\u200D\u2642",

    "1F646 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🙆🏼‍♂️ man gesturing OK: medium-light skin tone",
    "\uD83D\uDE46\uD83C\uDFFC\u200D\u2642\uFE0F",

    "1F646 1F3FC 200D 2642                      ; non-fully-qualified # 🙆🏼‍♂ man gesturing OK: medium-light skin tone",
    "\uD83D\uDE46\uD83C\uDFFC\u200D\u2642",

    "1F646 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🙆🏽‍♂️ man gesturing OK: medium skin tone",
    "\uD83D\uDE46\uD83C\uDFFD\u200D\u2642\uFE0F",

    "1F646 1F3FD 200D 2642                      ; non-fully-qualified # 🙆🏽‍♂ man gesturing OK: medium skin tone",
    "\uD83D\uDE46\uD83C\uDFFD\u200D\u2642",

    "1F646 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🙆🏾‍♂️ man gesturing OK: medium-dark skin tone",
    "\uD83D\uDE46\uD83C\uDFFE\u200D\u2642\uFE0F",

    "1F646 1F3FE 200D 2642                      ; non-fully-qualified # 🙆🏾‍♂ man gesturing OK: medium-dark skin tone",
    "\uD83D\uDE46\uD83C\uDFFE\u200D\u2642",

    "1F646 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🙆🏿‍♂️ man gesturing OK: dark skin tone",
    "\uD83D\uDE46\uD83C\uDFFF\u200D\u2642\uFE0F",

    "1F646 1F3FF 200D 2642                      ; non-fully-qualified # 🙆🏿‍♂ man gesturing OK: dark skin tone",
    "\uD83D\uDE46\uD83C\uDFFF\u200D\u2642",

    "1F646 200D 2640 FE0F                       ; fully-qualified     # 🙆‍♀️ woman gesturing OK",
    "\uD83D\uDE46\u200D\u2640\uFE0F",

    "1F646 200D 2640                            ; non-fully-qualified # 🙆‍♀ woman gesturing OK",
    "\uD83D\uDE46\u200D\u2640",

    "1F646 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🙆🏻‍♀️ woman gesturing OK: light skin tone",
    "\uD83D\uDE46\uD83C\uDFFB\u200D\u2640\uFE0F",

    "1F646 1F3FB 200D 2640                      ; non-fully-qualified # 🙆🏻‍♀ woman gesturing OK: light skin tone",
    "\uD83D\uDE46\uD83C\uDFFB\u200D\u2640",

    "1F646 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🙆🏼‍♀️ woman gesturing OK: medium-light skin tone",
    "\uD83D\uDE46\uD83C\uDFFC\u200D\u2640\uFE0F",

    "1F646 1F3FC 200D 2640                      ; non-fully-qualified # 🙆🏼‍♀ woman gesturing OK: medium-light skin tone",
    "\uD83D\uDE46\uD83C\uDFFC\u200D\u2640",

    "1F646 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🙆🏽‍♀️ woman gesturing OK: medium skin tone",
    "\uD83D\uDE46\uD83C\uDFFD\u200D\u2640\uFE0F",

    "1F646 1F3FD 200D 2640                      ; non-fully-qualified # 🙆🏽‍♀ woman gesturing OK: medium skin tone",
    "\uD83D\uDE46\uD83C\uDFFD\u200D\u2640",

    "1F646 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🙆🏾‍♀️ woman gesturing OK: medium-dark skin tone",
    "\uD83D\uDE46\uD83C\uDFFE\u200D\u2640\uFE0F",

    "1F646 1F3FE 200D 2640                      ; non-fully-qualified # 🙆🏾‍♀ woman gesturing OK: medium-dark skin tone",
    "\uD83D\uDE46\uD83C\uDFFE\u200D\u2640",

    "1F646 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🙆🏿‍♀️ woman gesturing OK: dark skin tone",
    "\uD83D\uDE46\uD83C\uDFFF\u200D\u2640\uFE0F",

    "1F646 1F3FF 200D 2640                      ; non-fully-qualified # 🙆🏿‍♀ woman gesturing OK: dark skin tone",
    "\uD83D\uDE46\uD83C\uDFFF\u200D\u2640",

    "1F481                                      ; fully-qualified     # 💁 person tipping hand",
    "\uD83D\uDC81",

    "1F481 1F3FB                                ; fully-qualified     # 💁🏻 person tipping hand: light skin tone",
    "\uD83D\uDC81\uD83C\uDFFB",

    "1F481 1F3FC                                ; fully-qualified     # 💁🏼 person tipping hand: medium-light skin tone",
    "\uD83D\uDC81\uD83C\uDFFC",

    "1F481 1F3FD                                ; fully-qualified     # 💁🏽 person tipping hand: medium skin tone",
    "\uD83D\uDC81\uD83C\uDFFD",

    "1F481 1F3FE                                ; fully-qualified     # 💁🏾 person tipping hand: medium-dark skin tone",
    "\uD83D\uDC81\uD83C\uDFFE",

    "1F481 1F3FF                                ; fully-qualified     # 💁🏿 person tipping hand: dark skin tone",
    "\uD83D\uDC81\uD83C\uDFFF",

    "1F481 200D 2642 FE0F                       ; fully-qualified     # 💁‍♂️ man tipping hand",
    "\uD83D\uDC81\u200D\u2642\uFE0F",

    "1F481 200D 2642                            ; non-fully-qualified # 💁‍♂ man tipping hand",
    "\uD83D\uDC81\u200D\u2642",

    "1F481 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 💁🏻‍♂️ man tipping hand: light skin tone",
    "\uD83D\uDC81\uD83C\uDFFB\u200D\u2642\uFE0F",

    "1F481 1F3FB 200D 2642                      ; non-fully-qualified # 💁🏻‍♂ man tipping hand: light skin tone",
    "\uD83D\uDC81\uD83C\uDFFB\u200D\u2642",

    "1F481 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 💁🏼‍♂️ man tipping hand: medium-light skin tone",
    "\uD83D\uDC81\uD83C\uDFFC\u200D\u2642\uFE0F",

    "1F481 1F3FC 200D 2642                      ; non-fully-qualified # 💁🏼‍♂ man tipping hand: medium-light skin tone",
    "\uD83D\uDC81\uD83C\uDFFC\u200D\u2642",

    "1F481 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 💁🏽‍♂️ man tipping hand: medium skin tone",
    "\uD83D\uDC81\uD83C\uDFFD\u200D\u2642\uFE0F",

    "1F481 1F3FD 200D 2642                      ; non-fully-qualified # 💁🏽‍♂ man tipping hand: medium skin tone",
    "\uD83D\uDC81\uD83C\uDFFD\u200D\u2642",

    "1F481 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 💁🏾‍♂️ man tipping hand: medium-dark skin tone",
    "\uD83D\uDC81\uD83C\uDFFE\u200D\u2642\uFE0F",

    "1F481 1F3FE 200D 2642                      ; non-fully-qualified # 💁🏾‍♂ man tipping hand: medium-dark skin tone",
    "\uD83D\uDC81\uD83C\uDFFE\u200D\u2642",

    "1F481 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 💁🏿‍♂️ man tipping hand: dark skin tone",
    "\uD83D\uDC81\uD83C\uDFFF\u200D\u2642\uFE0F",

    "1F481 1F3FF 200D 2642                      ; non-fully-qualified # 💁🏿‍♂ man tipping hand: dark skin tone",
    "\uD83D\uDC81\uD83C\uDFFF\u200D\u2642",

    "1F481 200D 2640 FE0F                       ; fully-qualified     # 💁‍♀️ woman tipping hand",
    "\uD83D\uDC81\u200D\u2640\uFE0F",

    "1F481 200D 2640                            ; non-fully-qualified # 💁‍♀ woman tipping hand",
    "\uD83D\uDC81\u200D\u2640",

    "1F481 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 💁🏻‍♀️ woman tipping hand: light skin tone",
    "\uD83D\uDC81\uD83C\uDFFB\u200D\u2640\uFE0F",

    "1F481 1F3FB 200D 2640                      ; non-fully-qualified # 💁🏻‍♀ woman tipping hand: light skin tone",
    "\uD83D\uDC81\uD83C\uDFFB\u200D\u2640",

    "1F481 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 💁🏼‍♀️ woman tipping hand: medium-light skin tone",
    "\uD83D\uDC81\uD83C\uDFFC\u200D\u2640\uFE0F",

    "1F481 1F3FC 200D 2640                      ; non-fully-qualified # 💁🏼‍♀ woman tipping hand: medium-light skin tone",
    "\uD83D\uDC81\uD83C\uDFFC\u200D\u2640",

    "1F481 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 💁🏽‍♀️ woman tipping hand: medium skin tone",
    "\uD83D\uDC81\uD83C\uDFFD\u200D\u2640\uFE0F",

    "1F481 1F3FD 200D 2640                      ; non-fully-qualified # 💁🏽‍♀ woman tipping hand: medium skin tone",
    "\uD83D\uDC81\uD83C\uDFFD\u200D\u2640",

    "1F481 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 💁🏾‍♀️ woman tipping hand: medium-dark skin tone",
    "\uD83D\uDC81\uD83C\uDFFE\u200D\u2640\uFE0F",

    "1F481 1F3FE 200D 2640                      ; non-fully-qualified # 💁🏾‍♀ woman tipping hand: medium-dark skin tone",
    "\uD83D\uDC81\uD83C\uDFFE\u200D\u2640",

    "1F481 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 💁🏿‍♀️ woman tipping hand: dark skin tone",
    "\uD83D\uDC81\uD83C\uDFFF\u200D\u2640\uFE0F",

    "1F481 1F3FF 200D 2640                      ; non-fully-qualified # 💁🏿‍♀ woman tipping hand: dark skin tone",
    "\uD83D\uDC81\uD83C\uDFFF\u200D\u2640",

    "1F64B                                      ; fully-qualified     # 🙋 person raising hand",
    "\uD83D\uDE4B",

    "1F64B 1F3FB                                ; fully-qualified     # 🙋🏻 person raising hand: light skin tone",
    "\uD83D\uDE4B\uD83C\uDFFB",

    "1F64B 1F3FC                                ; fully-qualified     # 🙋🏼 person raising hand: medium-light skin tone",
    "\uD83D\uDE4B\uD83C\uDFFC",

    "1F64B 1F3FD                                ; fully-qualified     # 🙋🏽 person raising hand: medium skin tone",
    "\uD83D\uDE4B\uD83C\uDFFD",

    "1F64B 1F3FE                                ; fully-qualified     # 🙋🏾 person raising hand: medium-dark skin tone",
    "\uD83D\uDE4B\uD83C\uDFFE",

    "1F64B 1F3FF                                ; fully-qualified     # 🙋🏿 person raising hand: dark skin tone",
    "\uD83D\uDE4B\uD83C\uDFFF",

    "1F64B 200D 2642 FE0F                       ; fully-qualified     # 🙋‍♂️ man raising hand",
    "\uD83D\uDE4B\u200D\u2642\uFE0F",

    "1F64B 200D 2642                            ; non-fully-qualified # 🙋‍♂ man raising hand",
    "\uD83D\uDE4B\u200D\u2642",

    "1F64B 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🙋🏻‍♂️ man raising hand: light skin tone",
    "\uD83D\uDE4B\uD83C\uDFFB\u200D\u2642\uFE0F",

    "1F64B 1F3FB 200D 2642                      ; non-fully-qualified # 🙋🏻‍♂ man raising hand: light skin tone",
    "\uD83D\uDE4B\uD83C\uDFFB\u200D\u2642",

    "1F64B 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🙋🏼‍♂️ man raising hand: medium-light skin tone",
    "\uD83D\uDE4B\uD83C\uDFFC\u200D\u2642\uFE0F",

    "1F64B 1F3FC 200D 2642                      ; non-fully-qualified # 🙋🏼‍♂ man raising hand: medium-light skin tone",
    "\uD83D\uDE4B\uD83C\uDFFC\u200D\u2642",

    "1F64B 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🙋🏽‍♂️ man raising hand: medium skin tone",
    "\uD83D\uDE4B\uD83C\uDFFD\u200D\u2642\uFE0F",

    "1F64B 1F3FD 200D 2642                      ; non-fully-qualified # 🙋🏽‍♂ man raising hand: medium skin tone",
    "\uD83D\uDE4B\uD83C\uDFFD\u200D\u2642",

    "1F64B 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🙋🏾‍♂️ man raising hand: medium-dark skin tone",
    "\uD83D\uDE4B\uD83C\uDFFE\u200D\u2642\uFE0F",

    "1F64B 1F3FE 200D 2642                      ; non-fully-qualified # 🙋🏾‍♂ man raising hand: medium-dark skin tone",
    "\uD83D\uDE4B\uD83C\uDFFE\u200D\u2642",

    "1F64B 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🙋🏿‍♂️ man raising hand: dark skin tone",
    "\uD83D\uDE4B\uD83C\uDFFF\u200D\u2642\uFE0F",

    "1F64B 1F3FF 200D 2642                      ; non-fully-qualified # 🙋🏿‍♂ man raising hand: dark skin tone",
    "\uD83D\uDE4B\uD83C\uDFFF\u200D\u2642",

    "1F64B 200D 2640 FE0F                       ; fully-qualified     # 🙋‍♀️ woman raising hand",
    "\uD83D\uDE4B\u200D\u2640\uFE0F",

    "1F64B 200D 2640                            ; non-fully-qualified # 🙋‍♀ woman raising hand",
    "\uD83D\uDE4B\u200D\u2640",

    "1F64B 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🙋🏻‍♀️ woman raising hand: light skin tone",
    "\uD83D\uDE4B\uD83C\uDFFB\u200D\u2640\uFE0F",

    "1F64B 1F3FB 200D 2640                      ; non-fully-qualified # 🙋🏻‍♀ woman raising hand: light skin tone",
    "\uD83D\uDE4B\uD83C\uDFFB\u200D\u2640",

    "1F64B 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🙋🏼‍♀️ woman raising hand: medium-light skin tone",
    "\uD83D\uDE4B\uD83C\uDFFC\u200D\u2640\uFE0F",

    "1F64B 1F3FC 200D 2640                      ; non-fully-qualified # 🙋🏼‍♀ woman raising hand: medium-light skin tone",
    "\uD83D\uDE4B\uD83C\uDFFC\u200D\u2640",

    "1F64B 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🙋🏽‍♀️ woman raising hand: medium skin tone",
    "\uD83D\uDE4B\uD83C\uDFFD\u200D\u2640\uFE0F",

    "1F64B 1F3FD 200D 2640                      ; non-fully-qualified # 🙋🏽‍♀ woman raising hand: medium skin tone",
    "\uD83D\uDE4B\uD83C\uDFFD\u200D\u2640",

    "1F64B 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🙋🏾‍♀️ woman raising hand: medium-dark skin tone",
    "\uD83D\uDE4B\uD83C\uDFFE\u200D\u2640\uFE0F",

    "1F64B 1F3FE 200D 2640                      ; non-fully-qualified # 🙋🏾‍♀ woman raising hand: medium-dark skin tone",
    "\uD83D\uDE4B\uD83C\uDFFE\u200D\u2640",

    "1F64B 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🙋🏿‍♀️ woman raising hand: dark skin tone",
    "\uD83D\uDE4B\uD83C\uDFFF\u200D\u2640\uFE0F",

    "1F64B 1F3FF 200D 2640                      ; non-fully-qualified # 🙋🏿‍♀ woman raising hand: dark skin tone",
    "\uD83D\uDE4B\uD83C\uDFFF\u200D\u2640",

    "1F647                                      ; fully-qualified     # 🙇 person bowing",
    "\uD83D\uDE47",

    "1F647 1F3FB                                ; fully-qualified     # 🙇🏻 person bowing: light skin tone",
    "\uD83D\uDE47\uD83C\uDFFB",

    "1F647 1F3FC                                ; fully-qualified     # 🙇🏼 person bowing: medium-light skin tone",
    "\uD83D\uDE47\uD83C\uDFFC",

    "1F647 1F3FD                                ; fully-qualified     # 🙇🏽 person bowing: medium skin tone",
    "\uD83D\uDE47\uD83C\uDFFD",

    "1F647 1F3FE                                ; fully-qualified     # 🙇🏾 person bowing: medium-dark skin tone",
    "\uD83D\uDE47\uD83C\uDFFE",

    "1F647 1F3FF                                ; fully-qualified     # 🙇🏿 person bowing: dark skin tone",
    "\uD83D\uDE47\uD83C\uDFFF",

    "1F647 200D 2642 FE0F                       ; fully-qualified     # 🙇‍♂️ man bowing",
    "\uD83D\uDE47\u200D\u2642\uFE0F",

    "1F647 200D 2642                            ; non-fully-qualified # 🙇‍♂ man bowing",
    "\uD83D\uDE47\u200D\u2642",

    "1F647 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🙇🏻‍♂️ man bowing: light skin tone",
    "\uD83D\uDE47\uD83C\uDFFB\u200D\u2642\uFE0F",

    "1F647 1F3FB 200D 2642                      ; non-fully-qualified # 🙇🏻‍♂ man bowing: light skin tone",
    "\uD83D\uDE47\uD83C\uDFFB\u200D\u2642",

    "1F647 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🙇🏼‍♂️ man bowing: medium-light skin tone",
    "\uD83D\uDE47\uD83C\uDFFC\u200D\u2642\uFE0F",

    "1F647 1F3FC 200D 2642                      ; non-fully-qualified # 🙇🏼‍♂ man bowing: medium-light skin tone",
    "\uD83D\uDE47\uD83C\uDFFC\u200D\u2642",

    "1F647 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🙇🏽‍♂️ man bowing: medium skin tone",
    "\uD83D\uDE47\uD83C\uDFFD\u200D\u2642\uFE0F",

    "1F647 1F3FD 200D 2642                      ; non-fully-qualified # 🙇🏽‍♂ man bowing: medium skin tone",
    "\uD83D\uDE47\uD83C\uDFFD\u200D\u2642",

    "1F647 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🙇🏾‍♂️ man bowing: medium-dark skin tone",
    "\uD83D\uDE47\uD83C\uDFFE\u200D\u2642\uFE0F",

    "1F647 1F3FE 200D 2642                      ; non-fully-qualified # 🙇🏾‍♂ man bowing: medium-dark skin tone",
    "\uD83D\uDE47\uD83C\uDFFE\u200D\u2642",

    "1F647 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🙇🏿‍♂️ man bowing: dark skin tone",
    "\uD83D\uDE47\uD83C\uDFFF\u200D\u2642\uFE0F",

    "1F647 1F3FF 200D 2642                      ; non-fully-qualified # 🙇🏿‍♂ man bowing: dark skin tone",
    "\uD83D\uDE47\uD83C\uDFFF\u200D\u2642",

    "1F647 200D 2640 FE0F                       ; fully-qualified     # 🙇‍♀️ woman bowing",
    "\uD83D\uDE47\u200D\u2640\uFE0F",

    "1F647 200D 2640                            ; non-fully-qualified # 🙇‍♀ woman bowing",
    "\uD83D\uDE47\u200D\u2640",

    "1F647 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🙇🏻‍♀️ woman bowing: light skin tone",
    "\uD83D\uDE47\uD83C\uDFFB\u200D\u2640\uFE0F",

    "1F647 1F3FB 200D 2640                      ; non-fully-qualified # 🙇🏻‍♀ woman bowing: light skin tone",
    "\uD83D\uDE47\uD83C\uDFFB\u200D\u2640",

    "1F647 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🙇🏼‍♀️ woman bowing: medium-light skin tone",
    "\uD83D\uDE47\uD83C\uDFFC\u200D\u2640\uFE0F",

    "1F647 1F3FC 200D 2640                      ; non-fully-qualified # 🙇🏼‍♀ woman bowing: medium-light skin tone",
    "\uD83D\uDE47\uD83C\uDFFC\u200D\u2640",

    "1F647 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🙇🏽‍♀️ woman bowing: medium skin tone",
    "\uD83D\uDE47\uD83C\uDFFD\u200D\u2640\uFE0F",

    "1F647 1F3FD 200D 2640                      ; non-fully-qualified # 🙇🏽‍♀ woman bowing: medium skin tone",
    "\uD83D\uDE47\uD83C\uDFFD\u200D\u2640",

    "1F647 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🙇🏾‍♀️ woman bowing: medium-dark skin tone",
    "\uD83D\uDE47\uD83C\uDFFE\u200D\u2640\uFE0F",

    "1F647 1F3FE 200D 2640                      ; non-fully-qualified # 🙇🏾‍♀ woman bowing: medium-dark skin tone",
    "\uD83D\uDE47\uD83C\uDFFE\u200D\u2640",

    "1F647 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🙇🏿‍♀️ woman bowing: dark skin tone",
    "\uD83D\uDE47\uD83C\uDFFF\u200D\u2640\uFE0F",

    "1F647 1F3FF 200D 2640                      ; non-fully-qualified # 🙇🏿‍♀ woman bowing: dark skin tone",
    "\uD83D\uDE47\uD83C\uDFFF\u200D\u2640",

    "1F926                                      ; fully-qualified     # 🤦 person facepalming",
    "\uD83E\uDD26",

    "1F926 1F3FB                                ; fully-qualified     # 🤦🏻 person facepalming: light skin tone",
    "\uD83E\uDD26\uD83C\uDFFB",

    "1F926 1F3FC                                ; fully-qualified     # 🤦🏼 person facepalming: medium-light skin tone",
    "\uD83E\uDD26\uD83C\uDFFC",

    "1F926 1F3FD                                ; fully-qualified     # 🤦🏽 person facepalming: medium skin tone",
    "\uD83E\uDD26\uD83C\uDFFD",

    "1F926 1F3FE                                ; fully-qualified     # 🤦🏾 person facepalming: medium-dark skin tone",
    "\uD83E\uDD26\uD83C\uDFFE",

    "1F926 1F3FF                                ; fully-qualified     # 🤦🏿 person facepalming: dark skin tone",
    "\uD83E\uDD26\uD83C\uDFFF",

    "1F926 200D 2642 FE0F                       ; fully-qualified     # 🤦‍♂️ man facepalming",
    "\uD83E\uDD26\u200D\u2642\uFE0F",

    "1F926 200D 2642                            ; non-fully-qualified # 🤦‍♂ man facepalming",
    "\uD83E\uDD26\u200D\u2642",

    "1F926 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🤦🏻‍♂️ man facepalming: light skin tone",
    "\uD83E\uDD26\uD83C\uDFFB\u200D\u2642\uFE0F",

    "1F926 1F3FB 200D 2642                      ; non-fully-qualified # 🤦🏻‍♂ man facepalming: light skin tone",
    "\uD83E\uDD26\uD83C\uDFFB\u200D\u2642",

    "1F926 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🤦🏼‍♂️ man facepalming: medium-light skin tone",
    "\uD83E\uDD26\uD83C\uDFFC\u200D\u2642\uFE0F",

    "1F926 1F3FC 200D 2642                      ; non-fully-qualified # 🤦🏼‍♂ man facepalming: medium-light skin tone",
    "\uD83E\uDD26\uD83C\uDFFC\u200D\u2642",

    "1F926 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🤦🏽‍♂️ man facepalming: medium skin tone",
    "\uD83E\uDD26\uD83C\uDFFD\u200D\u2642\uFE0F",

    "1F926 1F3FD 200D 2642                      ; non-fully-qualified # 🤦🏽‍♂ man facepalming: medium skin tone",
    "\uD83E\uDD26\uD83C\uDFFD\u200D\u2642",

    "1F926 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🤦🏾‍♂️ man facepalming: medium-dark skin tone",
    "\uD83E\uDD26\uD83C\uDFFE\u200D\u2642\uFE0F",

    "1F926 1F3FE 200D 2642                      ; non-fully-qualified # 🤦🏾‍♂ man facepalming: medium-dark skin tone",
    "\uD83E\uDD26\uD83C\uDFFE\u200D\u2642",

    "1F926 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🤦🏿‍♂️ man facepalming: dark skin tone",
    "\uD83E\uDD26\uD83C\uDFFF\u200D\u2642\uFE0F",

    "1F926 1F3FF 200D 2642                      ; non-fully-qualified # 🤦🏿‍♂ man facepalming: dark skin tone",
    "\uD83E\uDD26\uD83C\uDFFF\u200D\u2642",

    "1F926 200D 2640 FE0F                       ; fully-qualified     # 🤦‍♀️ woman facepalming",
    "\uD83E\uDD26\u200D\u2640\uFE0F",

    "1F926 200D 2640                            ; non-fully-qualified # 🤦‍♀ woman facepalming",
    "\uD83E\uDD26\u200D\u2640",

    "1F926 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🤦🏻‍♀️ woman facepalming: light skin tone",
    "\uD83E\uDD26\uD83C\uDFFB\u200D\u2640\uFE0F",

    "1F926 1F3FB 200D 2640                      ; non-fully-qualified # 🤦🏻‍♀ woman facepalming: light skin tone",
    "\uD83E\uDD26\uD83C\uDFFB\u200D\u2640",

    "1F926 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🤦🏼‍♀️ woman facepalming: medium-light skin tone",
    "\uD83E\uDD26\uD83C\uDFFC\u200D\u2640\uFE0F",

    "1F926 1F3FC 200D 2640                      ; non-fully-qualified # 🤦🏼‍♀ woman facepalming: medium-light skin tone",
    "\uD83E\uDD26\uD83C\uDFFC\u200D\u2640",

    "1F926 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🤦🏽‍♀️ woman facepalming: medium skin tone",
    "\uD83E\uDD26\uD83C\uDFFD\u200D\u2640\uFE0F",

    "1F926 1F3FD 200D 2640                      ; non-fully-qualified # 🤦🏽‍♀ woman facepalming: medium skin tone",
    "\uD83E\uDD26\uD83C\uDFFD\u200D\u2640",

    "1F926 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🤦🏾‍♀️ woman facepalming: medium-dark skin tone",
    "\uD83E\uDD26\uD83C\uDFFE\u200D\u2640\uFE0F",

    "1F926 1F3FE 200D 2640                      ; non-fully-qualified # 🤦🏾‍♀ woman facepalming: medium-dark skin tone",
    "\uD83E\uDD26\uD83C\uDFFE\u200D\u2640",

    "1F926 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🤦🏿‍♀️ woman facepalming: dark skin tone",
    "\uD83E\uDD26\uD83C\uDFFF\u200D\u2640\uFE0F",

    "1F926 1F3FF 200D 2640                      ; non-fully-qualified # 🤦🏿‍♀ woman facepalming: dark skin tone",
    "\uD83E\uDD26\uD83C\uDFFF\u200D\u2640",

    "1F937                                      ; fully-qualified     # 🤷 person shrugging",
    "\uD83E\uDD37",

    "1F937 1F3FB                                ; fully-qualified     # 🤷🏻 person shrugging: light skin tone",
    "\uD83E\uDD37\uD83C\uDFFB",

    "1F937 1F3FC                                ; fully-qualified     # 🤷🏼 person shrugging: medium-light skin tone",
    "\uD83E\uDD37\uD83C\uDFFC",

    "1F937 1F3FD                                ; fully-qualified     # 🤷🏽 person shrugging: medium skin tone",
    "\uD83E\uDD37\uD83C\uDFFD",

    "1F937 1F3FE                                ; fully-qualified     # 🤷🏾 person shrugging: medium-dark skin tone",
    "\uD83E\uDD37\uD83C\uDFFE",

    "1F937 1F3FF                                ; fully-qualified     # 🤷🏿 person shrugging: dark skin tone",
    "\uD83E\uDD37\uD83C\uDFFF",

    "1F937 200D 2642 FE0F                       ; fully-qualified     # 🤷‍♂️ man shrugging",
    "\uD83E\uDD37\u200D\u2642\uFE0F",

    "1F937 200D 2642                            ; non-fully-qualified # 🤷‍♂ man shrugging",
    "\uD83E\uDD37\u200D\u2642",

    "1F937 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🤷🏻‍♂️ man shrugging: light skin tone",
    "\uD83E\uDD37\uD83C\uDFFB\u200D\u2642\uFE0F",

    "1F937 1F3FB 200D 2642                      ; non-fully-qualified # 🤷🏻‍♂ man shrugging: light skin tone",
    "\uD83E\uDD37\uD83C\uDFFB\u200D\u2642",

    "1F937 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🤷🏼‍♂️ man shrugging: medium-light skin tone",
    "\uD83E\uDD37\uD83C\uDFFC\u200D\u2642\uFE0F",

    "1F937 1F3FC 200D 2642                      ; non-fully-qualified # 🤷🏼‍♂ man shrugging: medium-light skin tone",
    "\uD83E\uDD37\uD83C\uDFFC\u200D\u2642",

    "1F937 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🤷🏽‍♂️ man shrugging: medium skin tone",
    "\uD83E\uDD37\uD83C\uDFFD\u200D\u2642\uFE0F",

    "1F937 1F3FD 200D 2642                      ; non-fully-qualified # 🤷🏽‍♂ man shrugging: medium skin tone",
    "\uD83E\uDD37\uD83C\uDFFD\u200D\u2642",

    "1F937 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🤷🏾‍♂️ man shrugging: medium-dark skin tone",
    "\uD83E\uDD37\uD83C\uDFFE\u200D\u2642\uFE0F",

    "1F937 1F3FE 200D 2642                      ; non-fully-qualified # 🤷🏾‍♂ man shrugging: medium-dark skin tone",
    "\uD83E\uDD37\uD83C\uDFFE\u200D\u2642",

    "1F937 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🤷🏿‍♂️ man shrugging: dark skin tone",
    "\uD83E\uDD37\uD83C\uDFFF\u200D\u2642\uFE0F",

    "1F937 1F3FF 200D 2642                      ; non-fully-qualified # 🤷🏿‍♂ man shrugging: dark skin tone",
    "\uD83E\uDD37\uD83C\uDFFF\u200D\u2642",

    "1F937 200D 2640 FE0F                       ; fully-qualified     # 🤷‍♀️ woman shrugging",
    "\uD83E\uDD37\u200D\u2640\uFE0F",

    "1F937 200D 2640                            ; non-fully-qualified # 🤷‍♀ woman shrugging",
    "\uD83E\uDD37\u200D\u2640",

    "1F937 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🤷🏻‍♀️ woman shrugging: light skin tone",
    "\uD83E\uDD37\uD83C\uDFFB\u200D\u2640\uFE0F",

    "1F937 1F3FB 200D 2640                      ; non-fully-qualified # 🤷🏻‍♀ woman shrugging: light skin tone",
    "\uD83E\uDD37\uD83C\uDFFB\u200D\u2640",

    "1F937 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🤷🏼‍♀️ woman shrugging: medium-light skin tone",
    "\uD83E\uDD37\uD83C\uDFFC\u200D\u2640\uFE0F",

    "1F937 1F3FC 200D 2640                      ; non-fully-qualified # 🤷🏼‍♀ woman shrugging: medium-light skin tone",
    "\uD83E\uDD37\uD83C\uDFFC\u200D\u2640",

    "1F937 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🤷🏽‍♀️ woman shrugging: medium skin tone",
    "\uD83E\uDD37\uD83C\uDFFD\u200D\u2640\uFE0F",

    "1F937 1F3FD 200D 2640                      ; non-fully-qualified # 🤷🏽‍♀ woman shrugging: medium skin tone",
    "\uD83E\uDD37\uD83C\uDFFD\u200D\u2640",

    "1F937 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🤷🏾‍♀️ woman shrugging: medium-dark skin tone",
    "\uD83E\uDD37\uD83C\uDFFE\u200D\u2640\uFE0F",

    "1F937 1F3FE 200D 2640                      ; non-fully-qualified # 🤷🏾‍♀ woman shrugging: medium-dark skin tone",
    "\uD83E\uDD37\uD83C\uDFFE\u200D\u2640",

    "1F937 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🤷🏿‍♀️ woman shrugging: dark skin tone",
    "\uD83E\uDD37\uD83C\uDFFF\u200D\u2640\uFE0F",

    "1F937 1F3FF 200D 2640                      ; non-fully-qualified # 🤷🏿‍♀ woman shrugging: dark skin tone",
    "\uD83E\uDD37\uD83C\uDFFF\u200D\u2640",

    "1F486                                      ; fully-qualified     # 💆 person getting massage",
    "\uD83D\uDC86",

    "1F486 1F3FB                                ; fully-qualified     # 💆🏻 person getting massage: light skin tone",
    "\uD83D\uDC86\uD83C\uDFFB",

    "1F486 1F3FC                                ; fully-qualified     # 💆🏼 person getting massage: medium-light skin tone",
    "\uD83D\uDC86\uD83C\uDFFC",

    "1F486 1F3FD                                ; fully-qualified     # 💆🏽 person getting massage: medium skin tone",
    "\uD83D\uDC86\uD83C\uDFFD",

    "1F486 1F3FE                                ; fully-qualified     # 💆🏾 person getting massage: medium-dark skin tone",
    "\uD83D\uDC86\uD83C\uDFFE",

    "1F486 1F3FF                                ; fully-qualified     # 💆🏿 person getting massage: dark skin tone",
    "\uD83D\uDC86\uD83C\uDFFF",

    "1F486 200D 2642 FE0F                       ; fully-qualified     # 💆‍♂️ man getting massage",
    "\uD83D\uDC86\u200D\u2642\uFE0F",

    "1F486 200D 2642                            ; non-fully-qualified # 💆‍♂ man getting massage",
    "\uD83D\uDC86\u200D\u2642",

    "1F486 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 💆🏻‍♂️ man getting massage: light skin tone",
    "\uD83D\uDC86\uD83C\uDFFB\u200D\u2642\uFE0F",

    "1F486 1F3FB 200D 2642                      ; non-fully-qualified # 💆🏻‍♂ man getting massage: light skin tone",
    "\uD83D\uDC86\uD83C\uDFFB\u200D\u2642",

    "1F486 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 💆🏼‍♂️ man getting massage: medium-light skin tone",
    "\uD83D\uDC86\uD83C\uDFFC\u200D\u2642\uFE0F",

    "1F486 1F3FC 200D 2642                      ; non-fully-qualified # 💆🏼‍♂ man getting massage: medium-light skin tone",
    "\uD83D\uDC86\uD83C\uDFFC\u200D\u2642",

    "1F486 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 💆🏽‍♂️ man getting massage: medium skin tone",
    "\uD83D\uDC86\uD83C\uDFFD\u200D\u2642\uFE0F",

    "1F486 1F3FD 200D 2642                      ; non-fully-qualified # 💆🏽‍♂ man getting massage: medium skin tone",
    "\uD83D\uDC86\uD83C\uDFFD\u200D\u2642",

    "1F486 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 💆🏾‍♂️ man getting massage: medium-dark skin tone",
    "\uD83D\uDC86\uD83C\uDFFE\u200D\u2642\uFE0F",

    "1F486 1F3FE 200D 2642                      ; non-fully-qualified # 💆🏾‍♂ man getting massage: medium-dark skin tone",
    "\uD83D\uDC86\uD83C\uDFFE\u200D\u2642",

    "1F486 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 💆🏿‍♂️ man getting massage: dark skin tone",
    "\uD83D\uDC86\uD83C\uDFFF\u200D\u2642\uFE0F",

    "1F486 1F3FF 200D 2642                      ; non-fully-qualified # 💆🏿‍♂ man getting massage: dark skin tone",
    "\uD83D\uDC86\uD83C\uDFFF\u200D\u2642",

    "1F486 200D 2640 FE0F                       ; fully-qualified     # 💆‍♀️ woman getting massage",
    "\uD83D\uDC86\u200D\u2640\uFE0F",

    "1F486 200D 2640                            ; non-fully-qualified # 💆‍♀ woman getting massage",
    "\uD83D\uDC86\u200D\u2640",

    "1F486 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 💆🏻‍♀️ woman getting massage: light skin tone",
    "\uD83D\uDC86\uD83C\uDFFB\u200D\u2640\uFE0F",

    "1F486 1F3FB 200D 2640                      ; non-fully-qualified # 💆🏻‍♀ woman getting massage: light skin tone",
    "\uD83D\uDC86\uD83C\uDFFB\u200D\u2640",

    "1F486 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 💆🏼‍♀️ woman getting massage: medium-light skin tone",
    "\uD83D\uDC86\uD83C\uDFFC\u200D\u2640\uFE0F",

    "1F486 1F3FC 200D 2640                      ; non-fully-qualified # 💆🏼‍♀ woman getting massage: medium-light skin tone",
    "\uD83D\uDC86\uD83C\uDFFC\u200D\u2640",

    "1F486 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 💆🏽‍♀️ woman getting massage: medium skin tone",
    "\uD83D\uDC86\uD83C\uDFFD\u200D\u2640\uFE0F",

    "1F486 1F3FD 200D 2640                      ; non-fully-qualified # 💆🏽‍♀ woman getting massage: medium skin tone",
    "\uD83D\uDC86\uD83C\uDFFD\u200D\u2640",

    "1F486 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 💆🏾‍♀️ woman getting massage: medium-dark skin tone",
    "\uD83D\uDC86\uD83C\uDFFE\u200D\u2640\uFE0F",

    "1F486 1F3FE 200D 2640                      ; non-fully-qualified # 💆🏾‍♀ woman getting massage: medium-dark skin tone",
    "\uD83D\uDC86\uD83C\uDFFE\u200D\u2640",

    "1F486 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 💆🏿‍♀️ woman getting massage: dark skin tone",
    "\uD83D\uDC86\uD83C\uDFFF\u200D\u2640\uFE0F",

    "1F486 1F3FF 200D 2640                      ; non-fully-qualified # 💆🏿‍♀ woman getting massage: dark skin tone",
    "\uD83D\uDC86\uD83C\uDFFF\u200D\u2640",

    "1F487                                      ; fully-qualified     # 💇 person getting haircut",
    "\uD83D\uDC87",

    "1F487 1F3FB                                ; fully-qualified     # 💇🏻 person getting haircut: light skin tone",
    "\uD83D\uDC87\uD83C\uDFFB",

    "1F487 1F3FC                                ; fully-qualified     # 💇🏼 person getting haircut: medium-light skin tone",
    "\uD83D\uDC87\uD83C\uDFFC",

    "1F487 1F3FD                                ; fully-qualified     # 💇🏽 person getting haircut: medium skin tone",
    "\uD83D\uDC87\uD83C\uDFFD",

    "1F487 1F3FE                                ; fully-qualified     # 💇🏾 person getting haircut: medium-dark skin tone",
    "\uD83D\uDC87\uD83C\uDFFE",

    "1F487 1F3FF                                ; fully-qualified     # 💇🏿 person getting haircut: dark skin tone",
    "\uD83D\uDC87\uD83C\uDFFF",

    "1F487 200D 2642 FE0F                       ; fully-qualified     # 💇‍♂️ man getting haircut",
    "\uD83D\uDC87\u200D\u2642\uFE0F",

    "1F487 200D 2642                            ; non-fully-qualified # 💇‍♂ man getting haircut",
    "\uD83D\uDC87\u200D\u2642",

    "1F487 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 💇🏻‍♂️ man getting haircut: light skin tone",
    "\uD83D\uDC87\uD83C\uDFFB\u200D\u2642\uFE0F",

    "1F487 1F3FB 200D 2642                      ; non-fully-qualified # 💇🏻‍♂ man getting haircut: light skin tone",
    "\uD83D\uDC87\uD83C\uDFFB\u200D\u2642",

    "1F487 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 💇🏼‍♂️ man getting haircut: medium-light skin tone",
    "\uD83D\uDC87\uD83C\uDFFC\u200D\u2642\uFE0F",

    "1F487 1F3FC 200D 2642                      ; non-fully-qualified # 💇🏼‍♂ man getting haircut: medium-light skin tone",
    "\uD83D\uDC87\uD83C\uDFFC\u200D\u2642",

    "1F487 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 💇🏽‍♂️ man getting haircut: medium skin tone",
    "\uD83D\uDC87\uD83C\uDFFD\u200D\u2642\uFE0F",

    "1F487 1F3FD 200D 2642                      ; non-fully-qualified # 💇🏽‍♂ man getting haircut: medium skin tone",
    "\uD83D\uDC87\uD83C\uDFFD\u200D\u2642",

    "1F487 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 💇🏾‍♂️ man getting haircut: medium-dark skin tone",
    "\uD83D\uDC87\uD83C\uDFFE\u200D\u2642\uFE0F",

    "1F487 1F3FE 200D 2642                      ; non-fully-qualified # 💇🏾‍♂ man getting haircut: medium-dark skin tone",
    "\uD83D\uDC87\uD83C\uDFFE\u200D\u2642",

    "1F487 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 💇🏿‍♂️ man getting haircut: dark skin tone",
    "\uD83D\uDC87\uD83C\uDFFF\u200D\u2642\uFE0F",

    "1F487 1F3FF 200D 2642                      ; non-fully-qualified # 💇🏿‍♂ man getting haircut: dark skin tone",
    "\uD83D\uDC87\uD83C\uDFFF\u200D\u2642",

    "1F487 200D 2640 FE0F                       ; fully-qualified     # 💇‍♀️ woman getting haircut",
    "\uD83D\uDC87\u200D\u2640\uFE0F",

    "1F487 200D 2640                            ; non-fully-qualified # 💇‍♀ woman getting haircut",
    "\uD83D\uDC87\u200D\u2640",

    "1F487 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 💇🏻‍♀️ woman getting haircut: light skin tone",
    "\uD83D\uDC87\uD83C\uDFFB\u200D\u2640\uFE0F",

    "1F487 1F3FB 200D 2640                      ; non-fully-qualified # 💇🏻‍♀ woman getting haircut: light skin tone",
    "\uD83D\uDC87\uD83C\uDFFB\u200D\u2640",

    "1F487 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 💇🏼‍♀️ woman getting haircut: medium-light skin tone",
    "\uD83D\uDC87\uD83C\uDFFC\u200D\u2640\uFE0F",

    "1F487 1F3FC 200D 2640                      ; non-fully-qualified # 💇🏼‍♀ woman getting haircut: medium-light skin tone",
    "\uD83D\uDC87\uD83C\uDFFC\u200D\u2640",

    "1F487 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 💇🏽‍♀️ woman getting haircut: medium skin tone",
    "\uD83D\uDC87\uD83C\uDFFD\u200D\u2640\uFE0F",

    "1F487 1F3FD 200D 2640                      ; non-fully-qualified # 💇🏽‍♀ woman getting haircut: medium skin tone",
    "\uD83D\uDC87\uD83C\uDFFD\u200D\u2640",

    "1F487 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 💇🏾‍♀️ woman getting haircut: medium-dark skin tone",
    "\uD83D\uDC87\uD83C\uDFFE\u200D\u2640\uFE0F",

    "1F487 1F3FE 200D 2640                      ; non-fully-qualified # 💇🏾‍♀ woman getting haircut: medium-dark skin tone",
    "\uD83D\uDC87\uD83C\uDFFE\u200D\u2640",

    "1F487 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 💇🏿‍♀️ woman getting haircut: dark skin tone",
    "\uD83D\uDC87\uD83C\uDFFF\u200D\u2640\uFE0F",

    "1F487 1F3FF 200D 2640                      ; non-fully-qualified # 💇🏿‍♀ woman getting haircut: dark skin tone",
    "\uD83D\uDC87\uD83C\uDFFF\u200D\u2640",

    "1F6B6                                      ; fully-qualified     # 🚶 person walking",
    "\uD83D\uDEB6",

    "1F6B6 1F3FB                                ; fully-qualified     # 🚶🏻 person walking: light skin tone",
    "\uD83D\uDEB6\uD83C\uDFFB",

    "1F6B6 1F3FC                                ; fully-qualified     # 🚶🏼 person walking: medium-light skin tone",
    "\uD83D\uDEB6\uD83C\uDFFC",

    "1F6B6 1F3FD                                ; fully-qualified     # 🚶🏽 person walking: medium skin tone",
    "\uD83D\uDEB6\uD83C\uDFFD",

    "1F6B6 1F3FE                                ; fully-qualified     # 🚶🏾 person walking: medium-dark skin tone",
    "\uD83D\uDEB6\uD83C\uDFFE",

    "1F6B6 1F3FF                                ; fully-qualified     # 🚶🏿 person walking: dark skin tone",
    "\uD83D\uDEB6\uD83C\uDFFF",

    "1F6B6 200D 2642 FE0F                       ; fully-qualified     # 🚶‍♂️ man walking",
    "\uD83D\uDEB6\u200D\u2642\uFE0F",

    "1F6B6 200D 2642                            ; non-fully-qualified # 🚶‍♂ man walking",
    "\uD83D\uDEB6\u200D\u2642",

    "1F6B6 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🚶🏻‍♂️ man walking: light skin tone",
    "\uD83D\uDEB6\uD83C\uDFFB\u200D\u2642\uFE0F",

    "1F6B6 1F3FB 200D 2642                      ; non-fully-qualified # 🚶🏻‍♂ man walking: light skin tone",
    "\uD83D\uDEB6\uD83C\uDFFB\u200D\u2642",

    "1F6B6 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🚶🏼‍♂️ man walking: medium-light skin tone",
    "\uD83D\uDEB6\uD83C\uDFFC\u200D\u2642\uFE0F",

    "1F6B6 1F3FC 200D 2642                      ; non-fully-qualified # 🚶🏼‍♂ man walking: medium-light skin tone",
    "\uD83D\uDEB6\uD83C\uDFFC\u200D\u2642",

    "1F6B6 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🚶🏽‍♂️ man walking: medium skin tone",
    "\uD83D\uDEB6\uD83C\uDFFD\u200D\u2642\uFE0F",

    "1F6B6 1F3FD 200D 2642                      ; non-fully-qualified # 🚶🏽‍♂ man walking: medium skin tone",
    "\uD83D\uDEB6\uD83C\uDFFD\u200D\u2642",

    "1F6B6 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🚶🏾‍♂️ man walking: medium-dark skin tone",
    "\uD83D\uDEB6\uD83C\uDFFE\u200D\u2642\uFE0F",

    "1F6B6 1F3FE 200D 2642                      ; non-fully-qualified # 🚶🏾‍♂ man walking: medium-dark skin tone",
    "\uD83D\uDEB6\uD83C\uDFFE\u200D\u2642",

    "1F6B6 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🚶🏿‍♂️ man walking: dark skin tone",
    "\uD83D\uDEB6\uD83C\uDFFF\u200D\u2642\uFE0F",

    "1F6B6 1F3FF 200D 2642                      ; non-fully-qualified # 🚶🏿‍♂ man walking: dark skin tone",
    "\uD83D\uDEB6\uD83C\uDFFF\u200D\u2642",

    "1F6B6 200D 2640 FE0F                       ; fully-qualified     # 🚶‍♀️ woman walking",
    "\uD83D\uDEB6\u200D\u2640\uFE0F",

    "1F6B6 200D 2640                            ; non-fully-qualified # 🚶‍♀ woman walking",
    "\uD83D\uDEB6\u200D\u2640",

    "1F6B6 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🚶🏻‍♀️ woman walking: light skin tone",
    "\uD83D\uDEB6\uD83C\uDFFB\u200D\u2640\uFE0F",

    "1F6B6 1F3FB 200D 2640                      ; non-fully-qualified # 🚶🏻‍♀ woman walking: light skin tone",
    "\uD83D\uDEB6\uD83C\uDFFB\u200D\u2640",

    "1F6B6 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🚶🏼‍♀️ woman walking: medium-light skin tone",
    "\uD83D\uDEB6\uD83C\uDFFC\u200D\u2640\uFE0F",

    "1F6B6 1F3FC 200D 2640                      ; non-fully-qualified # 🚶🏼‍♀ woman walking: medium-light skin tone",
    "\uD83D\uDEB6\uD83C\uDFFC\u200D\u2640",

    "1F6B6 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🚶🏽‍♀️ woman walking: medium skin tone",
    "\uD83D\uDEB6\uD83C\uDFFD\u200D\u2640\uFE0F",

    "1F6B6 1F3FD 200D 2640                      ; non-fully-qualified # 🚶🏽‍♀ woman walking: medium skin tone",
    "\uD83D\uDEB6\uD83C\uDFFD\u200D\u2640",

    "1F6B6 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🚶🏾‍♀️ woman walking: medium-dark skin tone",
    "\uD83D\uDEB6\uD83C\uDFFE\u200D\u2640\uFE0F",

    "1F6B6 1F3FE 200D 2640                      ; non-fully-qualified # 🚶🏾‍♀ woman walking: medium-dark skin tone",
    "\uD83D\uDEB6\uD83C\uDFFE\u200D\u2640",

    "1F6B6 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🚶🏿‍♀️ woman walking: dark skin tone",
    "\uD83D\uDEB6\uD83C\uDFFF\u200D\u2640\uFE0F",

    "1F6B6 1F3FF 200D 2640                      ; non-fully-qualified # 🚶🏿‍♀ woman walking: dark skin tone",
    "\uD83D\uDEB6\uD83C\uDFFF\u200D\u2640",

    "1F3C3                                      ; fully-qualified     # 🏃 person running",
    "\uD83C\uDFC3",

    "1F3C3 1F3FB                                ; fully-qualified     # 🏃🏻 person running: light skin tone",
    "\uD83C\uDFC3\uD83C\uDFFB",

    "1F3C3 1F3FC                                ; fully-qualified     # 🏃🏼 person running: medium-light skin tone",
    "\uD83C\uDFC3\uD83C\uDFFC",

    "1F3C3 1F3FD                                ; fully-qualified     # 🏃🏽 person running: medium skin tone",
    "\uD83C\uDFC3\uD83C\uDFFD",

    "1F3C3 1F3FE                                ; fully-qualified     # 🏃🏾 person running: medium-dark skin tone",
    "\uD83C\uDFC3\uD83C\uDFFE",

    "1F3C3 1F3FF                                ; fully-qualified     # 🏃🏿 person running: dark skin tone",
    "\uD83C\uDFC3\uD83C\uDFFF",

    "1F3C3 200D 2642 FE0F                       ; fully-qualified     # 🏃‍♂️ man running",
    "\uD83C\uDFC3\u200D\u2642\uFE0F",

    "1F3C3 200D 2642                            ; non-fully-qualified # 🏃‍♂ man running",
    "\uD83C\uDFC3\u200D\u2642",

    "1F3C3 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🏃🏻‍♂️ man running: light skin tone",
    "\uD83C\uDFC3\uD83C\uDFFB\u200D\u2642\uFE0F",

    "1F3C3 1F3FB 200D 2642                      ; non-fully-qualified # 🏃🏻‍♂ man running: light skin tone",
    "\uD83C\uDFC3\uD83C\uDFFB\u200D\u2642",

    "1F3C3 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🏃🏼‍♂️ man running: medium-light skin tone",
    "\uD83C\uDFC3\uD83C\uDFFC\u200D\u2642\uFE0F",

    "1F3C3 1F3FC 200D 2642                      ; non-fully-qualified # 🏃🏼‍♂ man running: medium-light skin tone",
    "\uD83C\uDFC3\uD83C\uDFFC\u200D\u2642",

    "1F3C3 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🏃🏽‍♂️ man running: medium skin tone",
    "\uD83C\uDFC3\uD83C\uDFFD\u200D\u2642\uFE0F",

    "1F3C3 1F3FD 200D 2642                      ; non-fully-qualified # 🏃🏽‍♂ man running: medium skin tone",
    "\uD83C\uDFC3\uD83C\uDFFD\u200D\u2642",

    "1F3C3 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🏃🏾‍♂️ man running: medium-dark skin tone",
    "\uD83C\uDFC3\uD83C\uDFFE\u200D\u2642\uFE0F",

    "1F3C3 1F3FE 200D 2642                      ; non-fully-qualified # 🏃🏾‍♂ man running: medium-dark skin tone",
    "\uD83C\uDFC3\uD83C\uDFFE\u200D\u2642",

    "1F3C3 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🏃🏿‍♂️ man running: dark skin tone",
    "\uD83C\uDFC3\uD83C\uDFFF\u200D\u2642\uFE0F",

    "1F3C3 1F3FF 200D 2642                      ; non-fully-qualified # 🏃🏿‍♂ man running: dark skin tone",
    "\uD83C\uDFC3\uD83C\uDFFF\u200D\u2642",

    "1F3C3 200D 2640 FE0F                       ; fully-qualified     # 🏃‍♀️ woman running",
    "\uD83C\uDFC3\u200D\u2640\uFE0F",

    "1F3C3 200D 2640                            ; non-fully-qualified # 🏃‍♀ woman running",
    "\uD83C\uDFC3\u200D\u2640",

    "1F3C3 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🏃🏻‍♀️ woman running: light skin tone",
    "\uD83C\uDFC3\uD83C\uDFFB\u200D\u2640\uFE0F",

    "1F3C3 1F3FB 200D 2640                      ; non-fully-qualified # 🏃🏻‍♀ woman running: light skin tone",
    "\uD83C\uDFC3\uD83C\uDFFB\u200D\u2640",

    "1F3C3 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🏃🏼‍♀️ woman running: medium-light skin tone",
    "\uD83C\uDFC3\uD83C\uDFFC\u200D\u2640\uFE0F",

    "1F3C3 1F3FC 200D 2640                      ; non-fully-qualified # 🏃🏼‍♀ woman running: medium-light skin tone",
    "\uD83C\uDFC3\uD83C\uDFFC\u200D\u2640",

    "1F3C3 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🏃🏽‍♀️ woman running: medium skin tone",
    "\uD83C\uDFC3\uD83C\uDFFD\u200D\u2640\uFE0F",

    "1F3C3 1F3FD 200D 2640                      ; non-fully-qualified # 🏃🏽‍♀ woman running: medium skin tone",
    "\uD83C\uDFC3\uD83C\uDFFD\u200D\u2640",

    "1F3C3 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🏃🏾‍♀️ woman running: medium-dark skin tone",
    "\uD83C\uDFC3\uD83C\uDFFE\u200D\u2640\uFE0F",

    "1F3C3 1F3FE 200D 2640                      ; non-fully-qualified # 🏃🏾‍♀ woman running: medium-dark skin tone",
    "\uD83C\uDFC3\uD83C\uDFFE\u200D\u2640",

    "1F3C3 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🏃🏿‍♀️ woman running: dark skin tone",
    "\uD83C\uDFC3\uD83C\uDFFF\u200D\u2640\uFE0F",

    "1F3C3 1F3FF 200D 2640                      ; non-fully-qualified # 🏃🏿‍♀ woman running: dark skin tone",
    "\uD83C\uDFC3\uD83C\uDFFF\u200D\u2640",

    "1F483                                      ; fully-qualified     # 💃 woman dancing",
    "\uD83D\uDC83",

    "1F483 1F3FB                                ; fully-qualified     # 💃🏻 woman dancing: light skin tone",
    "\uD83D\uDC83\uD83C\uDFFB",

    "1F483 1F3FC                                ; fully-qualified     # 💃🏼 woman dancing: medium-light skin tone",
    "\uD83D\uDC83\uD83C\uDFFC",

    "1F483 1F3FD                                ; fully-qualified     # 💃🏽 woman dancing: medium skin tone",
    "\uD83D\uDC83\uD83C\uDFFD",

    "1F483 1F3FE                                ; fully-qualified     # 💃🏾 woman dancing: medium-dark skin tone",
    "\uD83D\uDC83\uD83C\uDFFE",

    "1F483 1F3FF                                ; fully-qualified     # 💃🏿 woman dancing: dark skin tone",
    "\uD83D\uDC83\uD83C\uDFFF",

    "1F57A                                      ; fully-qualified     # 🕺 man dancing",
    "\uD83D\uDD7A",

    "1F57A 1F3FB                                ; fully-qualified     # 🕺🏻 man dancing: light skin tone",
    "\uD83D\uDD7A\uD83C\uDFFB",

    "1F57A 1F3FC                                ; fully-qualified     # 🕺🏼 man dancing: medium-light skin tone",
    "\uD83D\uDD7A\uD83C\uDFFC",

    "1F57A 1F3FD                                ; fully-qualified     # 🕺🏽 man dancing: medium skin tone",
    "\uD83D\uDD7A\uD83C\uDFFD",

    "1F57A 1F3FE                                ; fully-qualified     # 🕺🏾 man dancing: medium-dark skin tone",
    "\uD83D\uDD7A\uD83C\uDFFE",

    "1F57A 1F3FF                                ; fully-qualified     # 🕺🏿 man dancing: dark skin tone",
    "\uD83D\uDD7A\uD83C\uDFFF",

    "1F46F                                      ; fully-qualified     # 👯 people with bunny ears",
    "\uD83D\uDC6F",

    "1F46F 200D 2642 FE0F                       ; fully-qualified     # 👯‍♂️ men with bunny ears",
    "\uD83D\uDC6F\u200D\u2642\uFE0F",

    "1F46F 200D 2642                            ; non-fully-qualified # 👯‍♂ men with bunny ears",
    "\uD83D\uDC6F\u200D\u2642",

    "1F46F 200D 2640 FE0F                       ; fully-qualified     # 👯‍♀️ women with bunny ears",
    "\uD83D\uDC6F\u200D\u2640\uFE0F",

    "1F46F 200D 2640                            ; non-fully-qualified # 👯‍♀ women with bunny ears",
    "\uD83D\uDC6F\u200D\u2640",

    "1F9D6                                      ; fully-qualified     # 🧖 person in steamy room",
    "\uD83E\uDDD6",

    "1F9D6 1F3FB                                ; fully-qualified     # 🧖🏻 person in steamy room: light skin tone",
    "\uD83E\uDDD6\uD83C\uDFFB",

    "1F9D6 1F3FC                                ; fully-qualified     # 🧖🏼 person in steamy room: medium-light skin tone",
    "\uD83E\uDDD6\uD83C\uDFFC",

    "1F9D6 1F3FD                                ; fully-qualified     # 🧖🏽 person in steamy room: medium skin tone",
    "\uD83E\uDDD6\uD83C\uDFFD",

    "1F9D6 1F3FE                                ; fully-qualified     # 🧖🏾 person in steamy room: medium-dark skin tone",
    "\uD83E\uDDD6\uD83C\uDFFE",

    "1F9D6 1F3FF                                ; fully-qualified     # 🧖🏿 person in steamy room: dark skin tone",
    "\uD83E\uDDD6\uD83C\uDFFF",

    "1F9D6 200D 2640 FE0F                       ; fully-qualified     # 🧖‍♀️ woman in steamy room",
    "\uD83E\uDDD6\u200D\u2640\uFE0F",

    "1F9D6 200D 2640                            ; non-fully-qualified # 🧖‍♀ woman in steamy room",
    "\uD83E\uDDD6\u200D\u2640",

    "1F9D6 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🧖🏻‍♀️ woman in steamy room: light skin tone",
    "\uD83E\uDDD6\uD83C\uDFFB\u200D\u2640\uFE0F",

    "1F9D6 1F3FB 200D 2640                      ; non-fully-qualified # 🧖🏻‍♀ woman in steamy room: light skin tone",
    "\uD83E\uDDD6\uD83C\uDFFB\u200D\u2640",

    "1F9D6 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🧖🏼‍♀️ woman in steamy room: medium-light skin tone",
    "\uD83E\uDDD6\uD83C\uDFFC\u200D\u2640\uFE0F",

    "1F9D6 1F3FC 200D 2640                      ; non-fully-qualified # 🧖🏼‍♀ woman in steamy room: medium-light skin tone",
    "\uD83E\uDDD6\uD83C\uDFFC\u200D\u2640",

    "1F9D6 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🧖🏽‍♀️ woman in steamy room: medium skin tone",
    "\uD83E\uDDD6\uD83C\uDFFD\u200D\u2640\uFE0F",

    "1F9D6 1F3FD 200D 2640                      ; non-fully-qualified # 🧖🏽‍♀ woman in steamy room: medium skin tone",
    "\uD83E\uDDD6\uD83C\uDFFD\u200D\u2640",

    "1F9D6 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🧖🏾‍♀️ woman in steamy room: medium-dark skin tone",
    "\uD83E\uDDD6\uD83C\uDFFE\u200D\u2640\uFE0F",

    "1F9D6 1F3FE 200D 2640                      ; non-fully-qualified # 🧖🏾‍♀ woman in steamy room: medium-dark skin tone",
    "\uD83E\uDDD6\uD83C\uDFFE\u200D\u2640",

    "1F9D6 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🧖🏿‍♀️ woman in steamy room: dark skin tone",
    "\uD83E\uDDD6\uD83C\uDFFF\u200D\u2640\uFE0F",

    "1F9D6 1F3FF 200D 2640                      ; non-fully-qualified # 🧖🏿‍♀ woman in steamy room: dark skin tone",
    "\uD83E\uDDD6\uD83C\uDFFF\u200D\u2640",

    "1F9D6 200D 2642 FE0F                       ; fully-qualified     # 🧖‍♂️ man in steamy room",
    "\uD83E\uDDD6\u200D\u2642\uFE0F",

    "1F9D6 200D 2642                            ; non-fully-qualified # 🧖‍♂ man in steamy room",
    "\uD83E\uDDD6\u200D\u2642",

    "1F9D6 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🧖🏻‍♂️ man in steamy room: light skin tone",
    "\uD83E\uDDD6\uD83C\uDFFB\u200D\u2642\uFE0F",

    "1F9D6 1F3FB 200D 2642                      ; non-fully-qualified # 🧖🏻‍♂ man in steamy room: light skin tone",
    "\uD83E\uDDD6\uD83C\uDFFB\u200D\u2642",

    "1F9D6 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🧖🏼‍♂️ man in steamy room: medium-light skin tone",
    "\uD83E\uDDD6\uD83C\uDFFC\u200D\u2642\uFE0F",

    "1F9D6 1F3FC 200D 2642                      ; non-fully-qualified # 🧖🏼‍♂ man in steamy room: medium-light skin tone",
    "\uD83E\uDDD6\uD83C\uDFFC\u200D\u2642",

    "1F9D6 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🧖🏽‍♂️ man in steamy room: medium skin tone",
    "\uD83E\uDDD6\uD83C\uDFFD\u200D\u2642\uFE0F",

    "1F9D6 1F3FD 200D 2642                      ; non-fully-qualified # 🧖🏽‍♂ man in steamy room: medium skin tone",
    "\uD83E\uDDD6\uD83C\uDFFD\u200D\u2642",

    "1F9D6 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🧖🏾‍♂️ man in steamy room: medium-dark skin tone",
    "\uD83E\uDDD6\uD83C\uDFFE\u200D\u2642\uFE0F",

    "1F9D6 1F3FE 200D 2642                      ; non-fully-qualified # 🧖🏾‍♂ man in steamy room: medium-dark skin tone",
    "\uD83E\uDDD6\uD83C\uDFFE\u200D\u2642",

    "1F9D6 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🧖🏿‍♂️ man in steamy room: dark skin tone",
    "\uD83E\uDDD6\uD83C\uDFFF\u200D\u2642\uFE0F",

    "1F9D6 1F3FF 200D 2642                      ; non-fully-qualified # 🧖🏿‍♂ man in steamy room: dark skin tone",
    "\uD83E\uDDD6\uD83C\uDFFF\u200D\u2642",

    "1F9D7                                      ; fully-qualified     # 🧗 person climbing",
    "\uD83E\uDDD7",

    "1F9D7 1F3FB                                ; fully-qualified     # 🧗🏻 person climbing: light skin tone",
    "\uD83E\uDDD7\uD83C\uDFFB",

    "1F9D7 1F3FC                                ; fully-qualified     # 🧗🏼 person climbing: medium-light skin tone",
    "\uD83E\uDDD7\uD83C\uDFFC",

    "1F9D7 1F3FD                                ; fully-qualified     # 🧗🏽 person climbing: medium skin tone",
    "\uD83E\uDDD7\uD83C\uDFFD",

    "1F9D7 1F3FE                                ; fully-qualified     # 🧗🏾 person climbing: medium-dark skin tone",
    "\uD83E\uDDD7\uD83C\uDFFE",

    "1F9D7 1F3FF                                ; fully-qualified     # 🧗🏿 person climbing: dark skin tone",
    "\uD83E\uDDD7\uD83C\uDFFF",

    "1F9D7 200D 2640 FE0F                       ; fully-qualified     # 🧗‍♀️ woman climbing",
    "\uD83E\uDDD7\u200D\u2640\uFE0F",

    "1F9D7 200D 2640                            ; non-fully-qualified # 🧗‍♀ woman climbing",
    "\uD83E\uDDD7\u200D\u2640",

    "1F9D7 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🧗🏻‍♀️ woman climbing: light skin tone",
    "\uD83E\uDDD7\uD83C\uDFFB\u200D\u2640\uFE0F",

    "1F9D7 1F3FB 200D 2640                      ; non-fully-qualified # 🧗🏻‍♀ woman climbing: light skin tone",
    "\uD83E\uDDD7\uD83C\uDFFB\u200D\u2640",

    "1F9D7 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🧗🏼‍♀️ woman climbing: medium-light skin tone",
    "\uD83E\uDDD7\uD83C\uDFFC\u200D\u2640\uFE0F",

    "1F9D7 1F3FC 200D 2640                      ; non-fully-qualified # 🧗🏼‍♀ woman climbing: medium-light skin tone",
    "\uD83E\uDDD7\uD83C\uDFFC\u200D\u2640",

    "1F9D7 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🧗🏽‍♀️ woman climbing: medium skin tone",
    "\uD83E\uDDD7\uD83C\uDFFD\u200D\u2640\uFE0F",

    "1F9D7 1F3FD 200D 2640                      ; non-fully-qualified # 🧗🏽‍♀ woman climbing: medium skin tone",
    "\uD83E\uDDD7\uD83C\uDFFD\u200D\u2640",

    "1F9D7 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🧗🏾‍♀️ woman climbing: medium-dark skin tone",
    "\uD83E\uDDD7\uD83C\uDFFE\u200D\u2640\uFE0F",

    "1F9D7 1F3FE 200D 2640                      ; non-fully-qualified # 🧗🏾‍♀ woman climbing: medium-dark skin tone",
    "\uD83E\uDDD7\uD83C\uDFFE\u200D\u2640",

    "1F9D7 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🧗🏿‍♀️ woman climbing: dark skin tone",
    "\uD83E\uDDD7\uD83C\uDFFF\u200D\u2640\uFE0F",

    "1F9D7 1F3FF 200D 2640                      ; non-fully-qualified # 🧗🏿‍♀ woman climbing: dark skin tone",
    "\uD83E\uDDD7\uD83C\uDFFF\u200D\u2640",

    "1F9D7 200D 2642 FE0F                       ; fully-qualified     # 🧗‍♂️ man climbing",
    "\uD83E\uDDD7\u200D\u2642\uFE0F",

    "1F9D7 200D 2642                            ; non-fully-qualified # 🧗‍♂ man climbing",
    "\uD83E\uDDD7\u200D\u2642",

    "1F9D7 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🧗🏻‍♂️ man climbing: light skin tone",
    "\uD83E\uDDD7\uD83C\uDFFB\u200D\u2642\uFE0F",

    "1F9D7 1F3FB 200D 2642                      ; non-fully-qualified # 🧗🏻‍♂ man climbing: light skin tone",
    "\uD83E\uDDD7\uD83C\uDFFB\u200D\u2642",

    "1F9D7 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🧗🏼‍♂️ man climbing: medium-light skin tone",
    "\uD83E\uDDD7\uD83C\uDFFC\u200D\u2642\uFE0F",

    "1F9D7 1F3FC 200D 2642                      ; non-fully-qualified # 🧗🏼‍♂ man climbing: medium-light skin tone",
    "\uD83E\uDDD7\uD83C\uDFFC\u200D\u2642",

    "1F9D7 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🧗🏽‍♂️ man climbing: medium skin tone",
    "\uD83E\uDDD7\uD83C\uDFFD\u200D\u2642\uFE0F",

    "1F9D7 1F3FD 200D 2642                      ; non-fully-qualified # 🧗🏽‍♂ man climbing: medium skin tone",
    "\uD83E\uDDD7\uD83C\uDFFD\u200D\u2642",

    "1F9D7 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🧗🏾‍♂️ man climbing: medium-dark skin tone",
    "\uD83E\uDDD7\uD83C\uDFFE\u200D\u2642\uFE0F",

    "1F9D7 1F3FE 200D 2642                      ; non-fully-qualified # 🧗🏾‍♂ man climbing: medium-dark skin tone",
    "\uD83E\uDDD7\uD83C\uDFFE\u200D\u2642",

    "1F9D7 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🧗🏿‍♂️ man climbing: dark skin tone",
    "\uD83E\uDDD7\uD83C\uDFFF\u200D\u2642\uFE0F",

    "1F9D7 1F3FF 200D 2642                      ; non-fully-qualified # 🧗🏿‍♂ man climbing: dark skin tone",
    "\uD83E\uDDD7\uD83C\uDFFF\u200D\u2642",

    "1F9D8                                      ; fully-qualified     # 🧘 person in lotus position",
    "\uD83E\uDDD8",

    "1F9D8 1F3FB                                ; fully-qualified     # 🧘🏻 person in lotus position: light skin tone",
    "\uD83E\uDDD8\uD83C\uDFFB",

    "1F9D8 1F3FC                                ; fully-qualified     # 🧘🏼 person in lotus position: medium-light skin tone",
    "\uD83E\uDDD8\uD83C\uDFFC",

    "1F9D8 1F3FD                                ; fully-qualified     # 🧘🏽 person in lotus position: medium skin tone",
    "\uD83E\uDDD8\uD83C\uDFFD",

    "1F9D8 1F3FE                                ; fully-qualified     # 🧘🏾 person in lotus position: medium-dark skin tone",
    "\uD83E\uDDD8\uD83C\uDFFE",

    "1F9D8 1F3FF                                ; fully-qualified     # 🧘🏿 person in lotus position: dark skin tone",
    "\uD83E\uDDD8\uD83C\uDFFF",

    "1F9D8 200D 2640 FE0F                       ; fully-qualified     # 🧘‍♀️ woman in lotus position",
    "\uD83E\uDDD8\u200D\u2640\uFE0F",

    "1F9D8 200D 2640                            ; non-fully-qualified # 🧘‍♀ woman in lotus position",
    "\uD83E\uDDD8\u200D\u2640",

    "1F9D8 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🧘🏻‍♀️ woman in lotus position: light skin tone",
    "\uD83E\uDDD8\uD83C\uDFFB\u200D\u2640\uFE0F",

    "1F9D8 1F3FB 200D 2640                      ; non-fully-qualified # 🧘🏻‍♀ woman in lotus position: light skin tone",
    "\uD83E\uDDD8\uD83C\uDFFB\u200D\u2640",

    "1F9D8 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🧘🏼‍♀️ woman in lotus position: medium-light skin tone",
    "\uD83E\uDDD8\uD83C\uDFFC\u200D\u2640\uFE0F",

    "1F9D8 1F3FC 200D 2640                      ; non-fully-qualified # 🧘🏼‍♀ woman in lotus position: medium-light skin tone",
    "\uD83E\uDDD8\uD83C\uDFFC\u200D\u2640",

    "1F9D8 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🧘🏽‍♀️ woman in lotus position: medium skin tone",
    "\uD83E\uDDD8\uD83C\uDFFD\u200D\u2640\uFE0F",

    "1F9D8 1F3FD 200D 2640                      ; non-fully-qualified # 🧘🏽‍♀ woman in lotus position: medium skin tone",
    "\uD83E\uDDD8\uD83C\uDFFD\u200D\u2640",

    "1F9D8 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🧘🏾‍♀️ woman in lotus position: medium-dark skin tone",
    "\uD83E\uDDD8\uD83C\uDFFE\u200D\u2640\uFE0F",

    "1F9D8 1F3FE 200D 2640                      ; non-fully-qualified # 🧘🏾‍♀ woman in lotus position: medium-dark skin tone",
    "\uD83E\uDDD8\uD83C\uDFFE\u200D\u2640",

    "1F9D8 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🧘🏿‍♀️ woman in lotus position: dark skin tone",
    "\uD83E\uDDD8\uD83C\uDFFF\u200D\u2640\uFE0F",

    "1F9D8 1F3FF 200D 2640                      ; non-fully-qualified # 🧘🏿‍♀ woman in lotus position: dark skin tone",
    "\uD83E\uDDD8\uD83C\uDFFF\u200D\u2640",

    "1F9D8 200D 2642 FE0F                       ; fully-qualified     # 🧘‍♂️ man in lotus position",
    "\uD83E\uDDD8\u200D\u2642\uFE0F",

    "1F9D8 200D 2642                            ; non-fully-qualified # 🧘‍♂ man in lotus position",
    "\uD83E\uDDD8\u200D\u2642",

    "1F9D8 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🧘🏻‍♂️ man in lotus position: light skin tone",
    "\uD83E\uDDD8\uD83C\uDFFB\u200D\u2642\uFE0F",

    "1F9D8 1F3FB 200D 2642                      ; non-fully-qualified # 🧘🏻‍♂ man in lotus position: light skin tone",
    "\uD83E\uDDD8\uD83C\uDFFB\u200D\u2642",

    "1F9D8 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🧘🏼‍♂️ man in lotus position: medium-light skin tone",
    "\uD83E\uDDD8\uD83C\uDFFC\u200D\u2642\uFE0F",

    "1F9D8 1F3FC 200D 2642                      ; non-fully-qualified # 🧘🏼‍♂ man in lotus position: medium-light skin tone",
    "\uD83E\uDDD8\uD83C\uDFFC\u200D\u2642",

    "1F9D8 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🧘🏽‍♂️ man in lotus position: medium skin tone",
    "\uD83E\uDDD8\uD83C\uDFFD\u200D\u2642\uFE0F",

    "1F9D8 1F3FD 200D 2642                      ; non-fully-qualified # 🧘🏽‍♂ man in lotus position: medium skin tone",
    "\uD83E\uDDD8\uD83C\uDFFD\u200D\u2642",

    "1F9D8 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🧘🏾‍♂️ man in lotus position: medium-dark skin tone",
    "\uD83E\uDDD8\uD83C\uDFFE\u200D\u2642\uFE0F",

    "1F9D8 1F3FE 200D 2642                      ; non-fully-qualified # 🧘🏾‍♂ man in lotus position: medium-dark skin tone",
    "\uD83E\uDDD8\uD83C\uDFFE\u200D\u2642",

    "1F9D8 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🧘🏿‍♂️ man in lotus position: dark skin tone",
    "\uD83E\uDDD8\uD83C\uDFFF\u200D\u2642\uFE0F",

    "1F9D8 1F3FF 200D 2642                      ; non-fully-qualified # 🧘🏿‍♂ man in lotus position: dark skin tone",
    "\uD83E\uDDD8\uD83C\uDFFF\u200D\u2642",

    "1F6C0                                      ; fully-qualified     # 🛀 person taking bath",
    "\uD83D\uDEC0",

    "1F6C0 1F3FB                                ; fully-qualified     # 🛀🏻 person taking bath: light skin tone",
    "\uD83D\uDEC0\uD83C\uDFFB",

    "1F6C0 1F3FC                                ; fully-qualified     # 🛀🏼 person taking bath: medium-light skin tone",
    "\uD83D\uDEC0\uD83C\uDFFC",

    "1F6C0 1F3FD                                ; fully-qualified     # 🛀🏽 person taking bath: medium skin tone",
    "\uD83D\uDEC0\uD83C\uDFFD",

    "1F6C0 1F3FE                                ; fully-qualified     # 🛀🏾 person taking bath: medium-dark skin tone",
    "\uD83D\uDEC0\uD83C\uDFFE",

    "1F6C0 1F3FF                                ; fully-qualified     # 🛀🏿 person taking bath: dark skin tone",
    "\uD83D\uDEC0\uD83C\uDFFF",

    "1F6CC                                      ; fully-qualified     # 🛌 person in bed",
    "\uD83D\uDECC",

    "1F6CC 1F3FB                                ; fully-qualified     # 🛌🏻 person in bed: light skin tone",
    "\uD83D\uDECC\uD83C\uDFFB",

    "1F6CC 1F3FC                                ; fully-qualified     # 🛌🏼 person in bed: medium-light skin tone",
    "\uD83D\uDECC\uD83C\uDFFC",

    "1F6CC 1F3FD                                ; fully-qualified     # 🛌🏽 person in bed: medium skin tone",
    "\uD83D\uDECC\uD83C\uDFFD",

    "1F6CC 1F3FE                                ; fully-qualified     # 🛌🏾 person in bed: medium-dark skin tone",
    "\uD83D\uDECC\uD83C\uDFFE",

    "1F6CC 1F3FF                                ; fully-qualified     # 🛌🏿 person in bed: dark skin tone",
    "\uD83D\uDECC\uD83C\uDFFF",

    "1F574 FE0F                                 ; fully-qualified     # 🕴️ man in suit levitating",
    "\uD83D\uDD74\uFE0F",

    "1F574                                      ; non-fully-qualified # 🕴 man in suit levitating",
    "\uD83D\uDD74",

    "1F574 1F3FB                                ; fully-qualified     # 🕴🏻 man in suit levitating: light skin tone",
    "\uD83D\uDD74\uD83C\uDFFB",

    "1F574 1F3FC                                ; fully-qualified     # 🕴🏼 man in suit levitating: medium-light skin tone",
    "\uD83D\uDD74\uD83C\uDFFC",

    "1F574 1F3FD                                ; fully-qualified     # 🕴🏽 man in suit levitating: medium skin tone",
    "\uD83D\uDD74\uD83C\uDFFD",

    "1F574 1F3FE                                ; fully-qualified     # 🕴🏾 man in suit levitating: medium-dark skin tone",
    "\uD83D\uDD74\uD83C\uDFFE",

    "1F574 1F3FF                                ; fully-qualified     # 🕴🏿 man in suit levitating: dark skin tone",
    "\uD83D\uDD74\uD83C\uDFFF",

    "1F5E3 FE0F                                 ; fully-qualified     # 🗣️ speaking head",
    "\uD83D\uDDE3\uFE0F",

    "1F5E3                                      ; non-fully-qualified # 🗣 speaking head",
    "\uD83D\uDDE3",

    "1F464                                      ; fully-qualified     # 👤 bust in silhouette",
    "\uD83D\uDC64",

    "1F465                                      ; fully-qualified     # 👥 busts in silhouette",
    "\uD83D\uDC65",

    "1F93A                                      ; fully-qualified     # 🤺 person fencing",
    "\uD83E\uDD3A",

    "1F3C7                                      ; fully-qualified     # 🏇 horse racing",
    "\uD83C\uDFC7",

    "1F3C7 1F3FB                                ; fully-qualified     # 🏇🏻 horse racing: light skin tone",
    "\uD83C\uDFC7\uD83C\uDFFB",

    "1F3C7 1F3FC                                ; fully-qualified     # 🏇🏼 horse racing: medium-light skin tone",
    "\uD83C\uDFC7\uD83C\uDFFC",

    "1F3C7 1F3FD                                ; fully-qualified     # 🏇🏽 horse racing: medium skin tone",
    "\uD83C\uDFC7\uD83C\uDFFD",

    "1F3C7 1F3FE                                ; fully-qualified     # 🏇🏾 horse racing: medium-dark skin tone",
    "\uD83C\uDFC7\uD83C\uDFFE",

    "1F3C7 1F3FF                                ; fully-qualified     # 🏇🏿 horse racing: dark skin tone",
    "\uD83C\uDFC7\uD83C\uDFFF",

    "26F7 FE0F                                  ; fully-qualified     # ⛷️ skier",
    "\u26F7\uFE0F",

    "26F7                                       ; non-fully-qualified # ⛷ skier",
    "\u26F7",

    "1F3C2                                      ; fully-qualified     # 🏂 snowboarder",
    "\uD83C\uDFC2",

    "1F3C2 1F3FB                                ; fully-qualified     # 🏂🏻 snowboarder: light skin tone",
    "\uD83C\uDFC2\uD83C\uDFFB",

    "1F3C2 1F3FC                                ; fully-qualified     # 🏂🏼 snowboarder: medium-light skin tone",
    "\uD83C\uDFC2\uD83C\uDFFC",

    "1F3C2 1F3FD                                ; fully-qualified     # 🏂🏽 snowboarder: medium skin tone",
    "\uD83C\uDFC2\uD83C\uDFFD",

    "1F3C2 1F3FE                                ; fully-qualified     # 🏂🏾 snowboarder: medium-dark skin tone",
    "\uD83C\uDFC2\uD83C\uDFFE",

    "1F3C2 1F3FF                                ; fully-qualified     # 🏂🏿 snowboarder: dark skin tone",
    "\uD83C\uDFC2\uD83C\uDFFF",

    "1F3CC FE0F                                 ; fully-qualified     # 🏌️ person golfing",
    "\uD83C\uDFCC\uFE0F",

    "1F3CC                                      ; non-fully-qualified # 🏌 person golfing",
    "\uD83C\uDFCC",

    "1F3CC 1F3FB                                ; fully-qualified     # 🏌🏻 person golfing: light skin tone",
    "\uD83C\uDFCC\uD83C\uDFFB",

    "1F3CC 1F3FC                                ; fully-qualified     # 🏌🏼 person golfing: medium-light skin tone",
    "\uD83C\uDFCC\uD83C\uDFFC",

    "1F3CC 1F3FD                                ; fully-qualified     # 🏌🏽 person golfing: medium skin tone",
    "\uD83C\uDFCC\uD83C\uDFFD",

    "1F3CC 1F3FE                                ; fully-qualified     # 🏌🏾 person golfing: medium-dark skin tone",
    "\uD83C\uDFCC\uD83C\uDFFE",

    "1F3CC 1F3FF                                ; fully-qualified     # 🏌🏿 person golfing: dark skin tone",
    "\uD83C\uDFCC\uD83C\uDFFF",

    "1F3CC FE0F 200D 2642 FE0F                  ; fully-qualified     # 🏌️‍♂️ man golfing",
    "\uD83C\uDFCC\uFE0F\u200D\u2642\uFE0F",

    "1F3CC 200D 2642 FE0F                       ; non-fully-qualified # 🏌‍♂️ man golfing",
    "\uD83C\uDFCC\u200D\u2642\uFE0F",

    "1F3CC FE0F 200D 2642                       ; non-fully-qualified # 🏌️‍♂ man golfing",
    "\uD83C\uDFCC\uFE0F\u200D\u2642",

    "1F3CC 200D 2642                            ; non-fully-qualified # 🏌‍♂ man golfing",
    "\uD83C\uDFCC\u200D\u2642",

    "1F3CC 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🏌🏻‍♂️ man golfing: light skin tone",
    "\uD83C\uDFCC\uD83C\uDFFB\u200D\u2642\uFE0F",

    "1F3CC 1F3FB 200D 2642                      ; non-fully-qualified # 🏌🏻‍♂ man golfing: light skin tone",
    "\uD83C\uDFCC\uD83C\uDFFB\u200D\u2642",

    "1F3CC 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🏌🏼‍♂️ man golfing: medium-light skin tone",
    "\uD83C\uDFCC\uD83C\uDFFC\u200D\u2642\uFE0F",

    "1F3CC 1F3FC 200D 2642                      ; non-fully-qualified # 🏌🏼‍♂ man golfing: medium-light skin tone",
    "\uD83C\uDFCC\uD83C\uDFFC\u200D\u2642",

    "1F3CC 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🏌🏽‍♂️ man golfing: medium skin tone",
    "\uD83C\uDFCC\uD83C\uDFFD\u200D\u2642\uFE0F",

    "1F3CC 1F3FD 200D 2642                      ; non-fully-qualified # 🏌🏽‍♂ man golfing: medium skin tone",
    "\uD83C\uDFCC\uD83C\uDFFD\u200D\u2642",

    "1F3CC 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🏌🏾‍♂️ man golfing: medium-dark skin tone",
    "\uD83C\uDFCC\uD83C\uDFFE\u200D\u2642\uFE0F",

    "1F3CC 1F3FE 200D 2642                      ; non-fully-qualified # 🏌🏾‍♂ man golfing: medium-dark skin tone",
    "\uD83C\uDFCC\uD83C\uDFFE\u200D\u2642",

    "1F3CC 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🏌🏿‍♂️ man golfing: dark skin tone",
    "\uD83C\uDFCC\uD83C\uDFFF\u200D\u2642\uFE0F",

    "1F3CC 1F3FF 200D 2642                      ; non-fully-qualified # 🏌🏿‍♂ man golfing: dark skin tone",
    "\uD83C\uDFCC\uD83C\uDFFF\u200D\u2642",

    "1F3CC FE0F 200D 2640 FE0F                  ; fully-qualified     # 🏌️‍♀️ woman golfing",
    "\uD83C\uDFCC\uFE0F\u200D\u2640\uFE0F",

    "1F3CC 200D 2640 FE0F                       ; non-fully-qualified # 🏌‍♀️ woman golfing",
    "\uD83C\uDFCC\u200D\u2640\uFE0F",

    "1F3CC FE0F 200D 2640                       ; non-fully-qualified # 🏌️‍♀ woman golfing",
    "\uD83C\uDFCC\uFE0F\u200D\u2640",

    "1F3CC 200D 2640                            ; non-fully-qualified # 🏌‍♀ woman golfing",
    "\uD83C\uDFCC\u200D\u2640",

    "1F3CC 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🏌🏻‍♀️ woman golfing: light skin tone",
    "\uD83C\uDFCC\uD83C\uDFFB\u200D\u2640\uFE0F",

    "1F3CC 1F3FB 200D 2640                      ; non-fully-qualified # 🏌🏻‍♀ woman golfing: light skin tone",
    "\uD83C\uDFCC\uD83C\uDFFB\u200D\u2640",

    "1F3CC 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🏌🏼‍♀️ woman golfing: medium-light skin tone",
    "\uD83C\uDFCC\uD83C\uDFFC\u200D\u2640\uFE0F",

    "1F3CC 1F3FC 200D 2640                      ; non-fully-qualified # 🏌🏼‍♀ woman golfing: medium-light skin tone",
    "\uD83C\uDFCC\uD83C\uDFFC\u200D\u2640",

    "1F3CC 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🏌🏽‍♀️ woman golfing: medium skin tone",
    "\uD83C\uDFCC\uD83C\uDFFD\u200D\u2640\uFE0F",

    "1F3CC 1F3FD 200D 2640                      ; non-fully-qualified # 🏌🏽‍♀ woman golfing: medium skin tone",
    "\uD83C\uDFCC\uD83C\uDFFD\u200D\u2640",

    "1F3CC 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🏌🏾‍♀️ woman golfing: medium-dark skin tone",
    "\uD83C\uDFCC\uD83C\uDFFE\u200D\u2640\uFE0F",

    "1F3CC 1F3FE 200D 2640                      ; non-fully-qualified # 🏌🏾‍♀ woman golfing: medium-dark skin tone",
    "\uD83C\uDFCC\uD83C\uDFFE\u200D\u2640",

    "1F3CC 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🏌🏿‍♀️ woman golfing: dark skin tone",
    "\uD83C\uDFCC\uD83C\uDFFF\u200D\u2640\uFE0F",

    "1F3CC 1F3FF 200D 2640                      ; non-fully-qualified # 🏌🏿‍♀ woman golfing: dark skin tone",
    "\uD83C\uDFCC\uD83C\uDFFF\u200D\u2640",

    "1F3C4                                      ; fully-qualified     # 🏄 person surfing",
    "\uD83C\uDFC4",

    "1F3C4 1F3FB                                ; fully-qualified     # 🏄🏻 person surfing: light skin tone",
    "\uD83C\uDFC4\uD83C\uDFFB",

    "1F3C4 1F3FC                                ; fully-qualified     # 🏄🏼 person surfing: medium-light skin tone",
    "\uD83C\uDFC4\uD83C\uDFFC",

    "1F3C4 1F3FD                                ; fully-qualified     # 🏄🏽 person surfing: medium skin tone",
    "\uD83C\uDFC4\uD83C\uDFFD",

    "1F3C4 1F3FE                                ; fully-qualified     # 🏄🏾 person surfing: medium-dark skin tone",
    "\uD83C\uDFC4\uD83C\uDFFE",

    "1F3C4 1F3FF                                ; fully-qualified     # 🏄🏿 person surfing: dark skin tone",
    "\uD83C\uDFC4\uD83C\uDFFF",

    "1F3C4 200D 2642 FE0F                       ; fully-qualified     # 🏄‍♂️ man surfing",
    "\uD83C\uDFC4\u200D\u2642\uFE0F",

    "1F3C4 200D 2642                            ; non-fully-qualified # 🏄‍♂ man surfing",
    "\uD83C\uDFC4\u200D\u2642",

    "1F3C4 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🏄🏻‍♂️ man surfing: light skin tone",
    "\uD83C\uDFC4\uD83C\uDFFB\u200D\u2642\uFE0F",

    "1F3C4 1F3FB 200D 2642                      ; non-fully-qualified # 🏄🏻‍♂ man surfing: light skin tone",
    "\uD83C\uDFC4\uD83C\uDFFB\u200D\u2642",

    "1F3C4 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🏄🏼‍♂️ man surfing: medium-light skin tone",
    "\uD83C\uDFC4\uD83C\uDFFC\u200D\u2642\uFE0F",

    "1F3C4 1F3FC 200D 2642                      ; non-fully-qualified # 🏄🏼‍♂ man surfing: medium-light skin tone",
    "\uD83C\uDFC4\uD83C\uDFFC\u200D\u2642",

    "1F3C4 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🏄🏽‍♂️ man surfing: medium skin tone",
    "\uD83C\uDFC4\uD83C\uDFFD\u200D\u2642\uFE0F",

    "1F3C4 1F3FD 200D 2642                      ; non-fully-qualified # 🏄🏽‍♂ man surfing: medium skin tone",
    "\uD83C\uDFC4\uD83C\uDFFD\u200D\u2642",

    "1F3C4 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🏄🏾‍♂️ man surfing: medium-dark skin tone",
    "\uD83C\uDFC4\uD83C\uDFFE\u200D\u2642\uFE0F",

    "1F3C4 1F3FE 200D 2642                      ; non-fully-qualified # 🏄🏾‍♂ man surfing: medium-dark skin tone",
    "\uD83C\uDFC4\uD83C\uDFFE\u200D\u2642",

    "1F3C4 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🏄🏿‍♂️ man surfing: dark skin tone",
    "\uD83C\uDFC4\uD83C\uDFFF\u200D\u2642\uFE0F",

    "1F3C4 1F3FF 200D 2642                      ; non-fully-qualified # 🏄🏿‍♂ man surfing: dark skin tone",
    "\uD83C\uDFC4\uD83C\uDFFF\u200D\u2642",

    "1F3C4 200D 2640 FE0F                       ; fully-qualified     # 🏄‍♀️ woman surfing",
    "\uD83C\uDFC4\u200D\u2640\uFE0F",

    "1F3C4 200D 2640                            ; non-fully-qualified # 🏄‍♀ woman surfing",
    "\uD83C\uDFC4\u200D\u2640",

    "1F3C4 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🏄🏻‍♀️ woman surfing: light skin tone",
    "\uD83C\uDFC4\uD83C\uDFFB\u200D\u2640\uFE0F",

    "1F3C4 1F3FB 200D 2640                      ; non-fully-qualified # 🏄🏻‍♀ woman surfing: light skin tone",
    "\uD83C\uDFC4\uD83C\uDFFB\u200D\u2640",

    "1F3C4 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🏄🏼‍♀️ woman surfing: medium-light skin tone",
    "\uD83C\uDFC4\uD83C\uDFFC\u200D\u2640\uFE0F",

    "1F3C4 1F3FC 200D 2640                      ; non-fully-qualified # 🏄🏼‍♀ woman surfing: medium-light skin tone",
    "\uD83C\uDFC4\uD83C\uDFFC\u200D\u2640",

    "1F3C4 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🏄🏽‍♀️ woman surfing: medium skin tone",
    "\uD83C\uDFC4\uD83C\uDFFD\u200D\u2640\uFE0F",

    "1F3C4 1F3FD 200D 2640                      ; non-fully-qualified # 🏄🏽‍♀ woman surfing: medium skin tone",
    "\uD83C\uDFC4\uD83C\uDFFD\u200D\u2640",

    "1F3C4 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🏄🏾‍♀️ woman surfing: medium-dark skin tone",
    "\uD83C\uDFC4\uD83C\uDFFE\u200D\u2640\uFE0F",

    "1F3C4 1F3FE 200D 2640                      ; non-fully-qualified # 🏄🏾‍♀ woman surfing: medium-dark skin tone",
    "\uD83C\uDFC4\uD83C\uDFFE\u200D\u2640",

    "1F3C4 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🏄🏿‍♀️ woman surfing: dark skin tone",
    "\uD83C\uDFC4\uD83C\uDFFF\u200D\u2640\uFE0F",

    "1F3C4 1F3FF 200D 2640                      ; non-fully-qualified # 🏄🏿‍♀ woman surfing: dark skin tone",
    "\uD83C\uDFC4\uD83C\uDFFF\u200D\u2640",

    "1F6A3                                      ; fully-qualified     # 🚣 person rowing boat",
    "\uD83D\uDEA3",

    "1F6A3 1F3FB                                ; fully-qualified     # 🚣🏻 person rowing boat: light skin tone",
    "\uD83D\uDEA3\uD83C\uDFFB",

    "1F6A3 1F3FC                                ; fully-qualified     # 🚣🏼 person rowing boat: medium-light skin tone",
    "\uD83D\uDEA3\uD83C\uDFFC",

    "1F6A3 1F3FD                                ; fully-qualified     # 🚣🏽 person rowing boat: medium skin tone",
    "\uD83D\uDEA3\uD83C\uDFFD",

    "1F6A3 1F3FE                                ; fully-qualified     # 🚣🏾 person rowing boat: medium-dark skin tone",
    "\uD83D\uDEA3\uD83C\uDFFE",

    "1F6A3 1F3FF                                ; fully-qualified     # 🚣🏿 person rowing boat: dark skin tone",
    "\uD83D\uDEA3\uD83C\uDFFF",

    "1F6A3 200D 2642 FE0F                       ; fully-qualified     # 🚣‍♂️ man rowing boat",
    "\uD83D\uDEA3\u200D\u2642\uFE0F",

    "1F6A3 200D 2642                            ; non-fully-qualified # 🚣‍♂ man rowing boat",
    "\uD83D\uDEA3\u200D\u2642",

    "1F6A3 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🚣🏻‍♂️ man rowing boat: light skin tone",
    "\uD83D\uDEA3\uD83C\uDFFB\u200D\u2642\uFE0F",

    "1F6A3 1F3FB 200D 2642                      ; non-fully-qualified # 🚣🏻‍♂ man rowing boat: light skin tone",
    "\uD83D\uDEA3\uD83C\uDFFB\u200D\u2642",

    "1F6A3 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🚣🏼‍♂️ man rowing boat: medium-light skin tone",
    "\uD83D\uDEA3\uD83C\uDFFC\u200D\u2642\uFE0F",

    "1F6A3 1F3FC 200D 2642                      ; non-fully-qualified # 🚣🏼‍♂ man rowing boat: medium-light skin tone",
    "\uD83D\uDEA3\uD83C\uDFFC\u200D\u2642",

    "1F6A3 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🚣🏽‍♂️ man rowing boat: medium skin tone",
    "\uD83D\uDEA3\uD83C\uDFFD\u200D\u2642\uFE0F",

    "1F6A3 1F3FD 200D 2642                      ; non-fully-qualified # 🚣🏽‍♂ man rowing boat: medium skin tone",
    "\uD83D\uDEA3\uD83C\uDFFD\u200D\u2642",

    "1F6A3 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🚣🏾‍♂️ man rowing boat: medium-dark skin tone",
    "\uD83D\uDEA3\uD83C\uDFFE\u200D\u2642\uFE0F",

    "1F6A3 1F3FE 200D 2642                      ; non-fully-qualified # 🚣🏾‍♂ man rowing boat: medium-dark skin tone",
    "\uD83D\uDEA3\uD83C\uDFFE\u200D\u2642",

    "1F6A3 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🚣🏿‍♂️ man rowing boat: dark skin tone",
    "\uD83D\uDEA3\uD83C\uDFFF\u200D\u2642\uFE0F",

    "1F6A3 1F3FF 200D 2642                      ; non-fully-qualified # 🚣🏿‍♂ man rowing boat: dark skin tone",
    "\uD83D\uDEA3\uD83C\uDFFF\u200D\u2642",

    "1F6A3 200D 2640 FE0F                       ; fully-qualified     # 🚣‍♀️ woman rowing boat",
    "\uD83D\uDEA3\u200D\u2640\uFE0F",

    "1F6A3 200D 2640                            ; non-fully-qualified # 🚣‍♀ woman rowing boat",
    "\uD83D\uDEA3\u200D\u2640",

    "1F6A3 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🚣🏻‍♀️ woman rowing boat: light skin tone",
    "\uD83D\uDEA3\uD83C\uDFFB\u200D\u2640\uFE0F",

    "1F6A3 1F3FB 200D 2640                      ; non-fully-qualified # 🚣🏻‍♀ woman rowing boat: light skin tone",
    "\uD83D\uDEA3\uD83C\uDFFB\u200D\u2640",

    "1F6A3 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🚣🏼‍♀️ woman rowing boat: medium-light skin tone",
    "\uD83D\uDEA3\uD83C\uDFFC\u200D\u2640\uFE0F",

    "1F6A3 1F3FC 200D 2640                      ; non-fully-qualified # 🚣🏼‍♀ woman rowing boat: medium-light skin tone",
    "\uD83D\uDEA3\uD83C\uDFFC\u200D\u2640",

    "1F6A3 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🚣🏽‍♀️ woman rowing boat: medium skin tone",
    "\uD83D\uDEA3\uD83C\uDFFD\u200D\u2640\uFE0F",

    "1F6A3 1F3FD 200D 2640                      ; non-fully-qualified # 🚣🏽‍♀ woman rowing boat: medium skin tone",
    "\uD83D\uDEA3\uD83C\uDFFD\u200D\u2640",

    "1F6A3 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🚣🏾‍♀️ woman rowing boat: medium-dark skin tone",
    "\uD83D\uDEA3\uD83C\uDFFE\u200D\u2640\uFE0F",

    "1F6A3 1F3FE 200D 2640                      ; non-fully-qualified # 🚣🏾‍♀ woman rowing boat: medium-dark skin tone",
    "\uD83D\uDEA3\uD83C\uDFFE\u200D\u2640",

    "1F6A3 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🚣🏿‍♀️ woman rowing boat: dark skin tone",
    "\uD83D\uDEA3\uD83C\uDFFF\u200D\u2640\uFE0F",

    "1F6A3 1F3FF 200D 2640                      ; non-fully-qualified # 🚣🏿‍♀ woman rowing boat: dark skin tone",
    "\uD83D\uDEA3\uD83C\uDFFF\u200D\u2640",

    "1F3CA                                      ; fully-qualified     # 🏊 person swimming",
    "\uD83C\uDFCA",

    "1F3CA 1F3FB                                ; fully-qualified     # 🏊🏻 person swimming: light skin tone",
    "\uD83C\uDFCA\uD83C\uDFFB",

    "1F3CA 1F3FC                                ; fully-qualified     # 🏊🏼 person swimming: medium-light skin tone",
    "\uD83C\uDFCA\uD83C\uDFFC",

    "1F3CA 1F3FD                                ; fully-qualified     # 🏊🏽 person swimming: medium skin tone",
    "\uD83C\uDFCA\uD83C\uDFFD",

    "1F3CA 1F3FE                                ; fully-qualified     # 🏊🏾 person swimming: medium-dark skin tone",
    "\uD83C\uDFCA\uD83C\uDFFE",

    "1F3CA 1F3FF                                ; fully-qualified     # 🏊🏿 person swimming: dark skin tone",
    "\uD83C\uDFCA\uD83C\uDFFF",

    "1F3CA 200D 2642 FE0F                       ; fully-qualified     # 🏊‍♂️ man swimming",
    "\uD83C\uDFCA\u200D\u2642\uFE0F",

    "1F3CA 200D 2642                            ; non-fully-qualified # 🏊‍♂ man swimming",
    "\uD83C\uDFCA\u200D\u2642",

    "1F3CA 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🏊🏻‍♂️ man swimming: light skin tone",
    "\uD83C\uDFCA\uD83C\uDFFB\u200D\u2642\uFE0F",

    "1F3CA 1F3FB 200D 2642                      ; non-fully-qualified # 🏊🏻‍♂ man swimming: light skin tone",
    "\uD83C\uDFCA\uD83C\uDFFB\u200D\u2642",

    "1F3CA 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🏊🏼‍♂️ man swimming: medium-light skin tone",
    "\uD83C\uDFCA\uD83C\uDFFC\u200D\u2642\uFE0F",

    "1F3CA 1F3FC 200D 2642                      ; non-fully-qualified # 🏊🏼‍♂ man swimming: medium-light skin tone",
    "\uD83C\uDFCA\uD83C\uDFFC\u200D\u2642",

    "1F3CA 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🏊🏽‍♂️ man swimming: medium skin tone",
    "\uD83C\uDFCA\uD83C\uDFFD\u200D\u2642\uFE0F",

    "1F3CA 1F3FD 200D 2642                      ; non-fully-qualified # 🏊🏽‍♂ man swimming: medium skin tone",
    "\uD83C\uDFCA\uD83C\uDFFD\u200D\u2642",

    "1F3CA 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🏊🏾‍♂️ man swimming: medium-dark skin tone",
    "\uD83C\uDFCA\uD83C\uDFFE\u200D\u2642\uFE0F",

    "1F3CA 1F3FE 200D 2642                      ; non-fully-qualified # 🏊🏾‍♂ man swimming: medium-dark skin tone",
    "\uD83C\uDFCA\uD83C\uDFFE\u200D\u2642",

    "1F3CA 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🏊🏿‍♂️ man swimming: dark skin tone",
    "\uD83C\uDFCA\uD83C\uDFFF\u200D\u2642\uFE0F",

    "1F3CA 1F3FF 200D 2642                      ; non-fully-qualified # 🏊🏿‍♂ man swimming: dark skin tone",
    "\uD83C\uDFCA\uD83C\uDFFF\u200D\u2642",

    "1F3CA 200D 2640 FE0F                       ; fully-qualified     # 🏊‍♀️ woman swimming",
    "\uD83C\uDFCA\u200D\u2640\uFE0F",

    "1F3CA 200D 2640                            ; non-fully-qualified # 🏊‍♀ woman swimming",
    "\uD83C\uDFCA\u200D\u2640",

    "1F3CA 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🏊🏻‍♀️ woman swimming: light skin tone",
    "\uD83C\uDFCA\uD83C\uDFFB\u200D\u2640\uFE0F",

    "1F3CA 1F3FB 200D 2640                      ; non-fully-qualified # 🏊🏻‍♀ woman swimming: light skin tone",
    "\uD83C\uDFCA\uD83C\uDFFB\u200D\u2640",

    "1F3CA 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🏊🏼‍♀️ woman swimming: medium-light skin tone",
    "\uD83C\uDFCA\uD83C\uDFFC\u200D\u2640\uFE0F",

    "1F3CA 1F3FC 200D 2640                      ; non-fully-qualified # 🏊🏼‍♀ woman swimming: medium-light skin tone",
    "\uD83C\uDFCA\uD83C\uDFFC\u200D\u2640",

    "1F3CA 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🏊🏽‍♀️ woman swimming: medium skin tone",
    "\uD83C\uDFCA\uD83C\uDFFD\u200D\u2640\uFE0F",

    "1F3CA 1F3FD 200D 2640                      ; non-fully-qualified # 🏊🏽‍♀ woman swimming: medium skin tone",
    "\uD83C\uDFCA\uD83C\uDFFD\u200D\u2640",

    "1F3CA 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🏊🏾‍♀️ woman swimming: medium-dark skin tone",
    "\uD83C\uDFCA\uD83C\uDFFE\u200D\u2640\uFE0F",

    "1F3CA 1F3FE 200D 2640                      ; non-fully-qualified # 🏊🏾‍♀ woman swimming: medium-dark skin tone",
    "\uD83C\uDFCA\uD83C\uDFFE\u200D\u2640",

    "1F3CA 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🏊🏿‍♀️ woman swimming: dark skin tone",
    "\uD83C\uDFCA\uD83C\uDFFF\u200D\u2640\uFE0F",

    "1F3CA 1F3FF 200D 2640                      ; non-fully-qualified # 🏊🏿‍♀ woman swimming: dark skin tone",
    "\uD83C\uDFCA\uD83C\uDFFF\u200D\u2640",

    "26F9 FE0F                                  ; fully-qualified     # ⛹️ person bouncing ball",
    "\u26F9\uFE0F",

    "26F9                                       ; non-fully-qualified # ⛹ person bouncing ball",
    "\u26F9",

    "26F9 1F3FB                                 ; fully-qualified     # ⛹🏻 person bouncing ball: light skin tone",
    "\u26F9\uD83C\uDFFB",

    "26F9 1F3FC                                 ; fully-qualified     # ⛹🏼 person bouncing ball: medium-light skin tone",
    "\u26F9\uD83C\uDFFC",

    "26F9 1F3FD                                 ; fully-qualified     # ⛹🏽 person bouncing ball: medium skin tone",
    "\u26F9\uD83C\uDFFD",

    "26F9 1F3FE                                 ; fully-qualified     # ⛹🏾 person bouncing ball: medium-dark skin tone",
    "\u26F9\uD83C\uDFFE",

    "26F9 1F3FF                                 ; fully-qualified     # ⛹🏿 person bouncing ball: dark skin tone",
    "\u26F9\uD83C\uDFFF",

    "26F9 FE0F 200D 2642 FE0F                   ; fully-qualified     # ⛹️‍♂️ man bouncing ball",
    "\u26F9\uFE0F\u200D\u2642\uFE0F",

    "26F9 200D 2642 FE0F                        ; non-fully-qualified # ⛹‍♂️ man bouncing ball",
    "\u26F9\u200D\u2642\uFE0F",

    "26F9 FE0F 200D 2642                        ; non-fully-qualified # ⛹️‍♂ man bouncing ball",
    "\u26F9\uFE0F\u200D\u2642",

    "26F9 200D 2642                             ; non-fully-qualified # ⛹‍♂ man bouncing ball",
    "\u26F9\u200D\u2642",

    "26F9 1F3FB 200D 2642 FE0F                  ; fully-qualified     # ⛹🏻‍♂️ man bouncing ball: light skin tone",
    "\u26F9\uD83C\uDFFB\u200D\u2642\uFE0F",

    "26F9 1F3FB 200D 2642                       ; non-fully-qualified # ⛹🏻‍♂ man bouncing ball: light skin tone",
    "\u26F9\uD83C\uDFFB\u200D\u2642",

    "26F9 1F3FC 200D 2642 FE0F                  ; fully-qualified     # ⛹🏼‍♂️ man bouncing ball: medium-light skin tone",
    "\u26F9\uD83C\uDFFC\u200D\u2642\uFE0F",

    "26F9 1F3FC 200D 2642                       ; non-fully-qualified # ⛹🏼‍♂ man bouncing ball: medium-light skin tone",
    "\u26F9\uD83C\uDFFC\u200D\u2642",

    "26F9 1F3FD 200D 2642 FE0F                  ; fully-qualified     # ⛹🏽‍♂️ man bouncing ball: medium skin tone",
    "\u26F9\uD83C\uDFFD\u200D\u2642\uFE0F",

    "26F9 1F3FD 200D 2642                       ; non-fully-qualified # ⛹🏽‍♂ man bouncing ball: medium skin tone",
    "\u26F9\uD83C\uDFFD\u200D\u2642",

    "26F9 1F3FE 200D 2642 FE0F                  ; fully-qualified     # ⛹🏾‍♂️ man bouncing ball: medium-dark skin tone",
    "\u26F9\uD83C\uDFFE\u200D\u2642\uFE0F",

    "26F9 1F3FE 200D 2642                       ; non-fully-qualified # ⛹🏾‍♂ man bouncing ball: medium-dark skin tone",
    "\u26F9\uD83C\uDFFE\u200D\u2642",

    "26F9 1F3FF 200D 2642 FE0F                  ; fully-qualified     # ⛹🏿‍♂️ man bouncing ball: dark skin tone",
    "\u26F9\uD83C\uDFFF\u200D\u2642\uFE0F",

    "26F9 1F3FF 200D 2642                       ; non-fully-qualified # ⛹🏿‍♂ man bouncing ball: dark skin tone",
    "\u26F9\uD83C\uDFFF\u200D\u2642",

    "26F9 FE0F 200D 2640 FE0F                   ; fully-qualified     # ⛹️‍♀️ woman bouncing ball",
    "\u26F9\uFE0F\u200D\u2640\uFE0F",

    "26F9 200D 2640 FE0F                        ; non-fully-qualified # ⛹‍♀️ woman bouncing ball",
    "\u26F9\u200D\u2640\uFE0F",

    "26F9 FE0F 200D 2640                        ; non-fully-qualified # ⛹️‍♀ woman bouncing ball",
    "\u26F9\uFE0F\u200D\u2640",

    "26F9 200D 2640                             ; non-fully-qualified # ⛹‍♀ woman bouncing ball",
    "\u26F9\u200D\u2640",

    "26F9 1F3FB 200D 2640 FE0F                  ; fully-qualified     # ⛹🏻‍♀️ woman bouncing ball: light skin tone",
    "\u26F9\uD83C\uDFFB\u200D\u2640\uFE0F",

    "26F9 1F3FB 200D 2640                       ; non-fully-qualified # ⛹🏻‍♀ woman bouncing ball: light skin tone",
    "\u26F9\uD83C\uDFFB\u200D\u2640",

    "26F9 1F3FC 200D 2640 FE0F                  ; fully-qualified     # ⛹🏼‍♀️ woman bouncing ball: medium-light skin tone",
    "\u26F9\uD83C\uDFFC\u200D\u2640\uFE0F",

    "26F9 1F3FC 200D 2640                       ; non-fully-qualified # ⛹🏼‍♀ woman bouncing ball: medium-light skin tone",
    "\u26F9\uD83C\uDFFC\u200D\u2640",

    "26F9 1F3FD 200D 2640 FE0F                  ; fully-qualified     # ⛹🏽‍♀️ woman bouncing ball: medium skin tone",
    "\u26F9\uD83C\uDFFD\u200D\u2640\uFE0F",

    "26F9 1F3FD 200D 2640                       ; non-fully-qualified # ⛹🏽‍♀ woman bouncing ball: medium skin tone",
    "\u26F9\uD83C\uDFFD\u200D\u2640",

    "26F9 1F3FE 200D 2640 FE0F                  ; fully-qualified     # ⛹🏾‍♀️ woman bouncing ball: medium-dark skin tone",
    "\u26F9\uD83C\uDFFE\u200D\u2640\uFE0F",

    "26F9 1F3FE 200D 2640                       ; non-fully-qualified # ⛹🏾‍♀ woman bouncing ball: medium-dark skin tone",
    "\u26F9\uD83C\uDFFE\u200D\u2640",

    "26F9 1F3FF 200D 2640 FE0F                  ; fully-qualified     # ⛹🏿‍♀️ woman bouncing ball: dark skin tone",
    "\u26F9\uD83C\uDFFF\u200D\u2640\uFE0F",

    "26F9 1F3FF 200D 2640                       ; non-fully-qualified # ⛹🏿‍♀ woman bouncing ball: dark skin tone",
    "\u26F9\uD83C\uDFFF\u200D\u2640",

    "1F3CB FE0F                                 ; fully-qualified     # 🏋️ person lifting weights",
    "\uD83C\uDFCB\uFE0F",

    "1F3CB                                      ; non-fully-qualified # 🏋 person lifting weights",
    "\uD83C\uDFCB",

    "1F3CB 1F3FB                                ; fully-qualified     # 🏋🏻 person lifting weights: light skin tone",
    "\uD83C\uDFCB\uD83C\uDFFB",

    "1F3CB 1F3FC                                ; fully-qualified     # 🏋🏼 person lifting weights: medium-light skin tone",
    "\uD83C\uDFCB\uD83C\uDFFC",

    "1F3CB 1F3FD                                ; fully-qualified     # 🏋🏽 person lifting weights: medium skin tone",
    "\uD83C\uDFCB\uD83C\uDFFD",

    "1F3CB 1F3FE                                ; fully-qualified     # 🏋🏾 person lifting weights: medium-dark skin tone",
    "\uD83C\uDFCB\uD83C\uDFFE",

    "1F3CB 1F3FF                                ; fully-qualified     # 🏋🏿 person lifting weights: dark skin tone",
    "\uD83C\uDFCB\uD83C\uDFFF",

    "1F3CB FE0F 200D 2642 FE0F                  ; fully-qualified     # 🏋️‍♂️ man lifting weights",
    "\uD83C\uDFCB\uFE0F\u200D\u2642\uFE0F",

    "1F3CB 200D 2642 FE0F                       ; non-fully-qualified # 🏋‍♂️ man lifting weights",
    "\uD83C\uDFCB\u200D\u2642\uFE0F",

    "1F3CB FE0F 200D 2642                       ; non-fully-qualified # 🏋️‍♂ man lifting weights",
    "\uD83C\uDFCB\uFE0F\u200D\u2642",

    "1F3CB 200D 2642                            ; non-fully-qualified # 🏋‍♂ man lifting weights",
    "\uD83C\uDFCB\u200D\u2642",

    "1F3CB 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🏋🏻‍♂️ man lifting weights: light skin tone",
    "\uD83C\uDFCB\uD83C\uDFFB\u200D\u2642\uFE0F",

    "1F3CB 1F3FB 200D 2642                      ; non-fully-qualified # 🏋🏻‍♂ man lifting weights: light skin tone",
    "\uD83C\uDFCB\uD83C\uDFFB\u200D\u2642",

    "1F3CB 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🏋🏼‍♂️ man lifting weights: medium-light skin tone",
    "\uD83C\uDFCB\uD83C\uDFFC\u200D\u2642\uFE0F",

    "1F3CB 1F3FC 200D 2642                      ; non-fully-qualified # 🏋🏼‍♂ man lifting weights: medium-light skin tone",
    "\uD83C\uDFCB\uD83C\uDFFC\u200D\u2642",

    "1F3CB 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🏋🏽‍♂️ man lifting weights: medium skin tone",
    "\uD83C\uDFCB\uD83C\uDFFD\u200D\u2642\uFE0F",

    "1F3CB 1F3FD 200D 2642                      ; non-fully-qualified # 🏋🏽‍♂ man lifting weights: medium skin tone",
    "\uD83C\uDFCB\uD83C\uDFFD\u200D\u2642",

    "1F3CB 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🏋🏾‍♂️ man lifting weights: medium-dark skin tone",
    "\uD83C\uDFCB\uD83C\uDFFE\u200D\u2642\uFE0F",

    "1F3CB 1F3FE 200D 2642                      ; non-fully-qualified # 🏋🏾‍♂ man lifting weights: medium-dark skin tone",
    "\uD83C\uDFCB\uD83C\uDFFE\u200D\u2642",

    "1F3CB 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🏋🏿‍♂️ man lifting weights: dark skin tone",
    "\uD83C\uDFCB\uD83C\uDFFF\u200D\u2642\uFE0F",

    "1F3CB 1F3FF 200D 2642                      ; non-fully-qualified # 🏋🏿‍♂ man lifting weights: dark skin tone",
    "\uD83C\uDFCB\uD83C\uDFFF\u200D\u2642",

    "1F3CB FE0F 200D 2640 FE0F                  ; fully-qualified     # 🏋️‍♀️ woman lifting weights",
    "\uD83C\uDFCB\uFE0F\u200D\u2640\uFE0F",

    "1F3CB 200D 2640 FE0F                       ; non-fully-qualified # 🏋‍♀️ woman lifting weights",
    "\uD83C\uDFCB\u200D\u2640\uFE0F",

    "1F3CB FE0F 200D 2640                       ; non-fully-qualified # 🏋️‍♀ woman lifting weights",
    "\uD83C\uDFCB\uFE0F\u200D\u2640",

    "1F3CB 200D 2640                            ; non-fully-qualified # 🏋‍♀ woman lifting weights",
    "\uD83C\uDFCB\u200D\u2640",

    "1F3CB 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🏋🏻‍♀️ woman lifting weights: light skin tone",
    "\uD83C\uDFCB\uD83C\uDFFB\u200D\u2640\uFE0F",

    "1F3CB 1F3FB 200D 2640                      ; non-fully-qualified # 🏋🏻‍♀ woman lifting weights: light skin tone",
    "\uD83C\uDFCB\uD83C\uDFFB\u200D\u2640",

    "1F3CB 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🏋🏼‍♀️ woman lifting weights: medium-light skin tone",
    "\uD83C\uDFCB\uD83C\uDFFC\u200D\u2640\uFE0F",

    "1F3CB 1F3FC 200D 2640                      ; non-fully-qualified # 🏋🏼‍♀ woman lifting weights: medium-light skin tone",
    "\uD83C\uDFCB\uD83C\uDFFC\u200D\u2640",

    "1F3CB 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🏋🏽‍♀️ woman lifting weights: medium skin tone",
    "\uD83C\uDFCB\uD83C\uDFFD\u200D\u2640\uFE0F",

    "1F3CB 1F3FD 200D 2640                      ; non-fully-qualified # 🏋🏽‍♀ woman lifting weights: medium skin tone",
    "\uD83C\uDFCB\uD83C\uDFFD\u200D\u2640",

    "1F3CB 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🏋🏾‍♀️ woman lifting weights: medium-dark skin tone",
    "\uD83C\uDFCB\uD83C\uDFFE\u200D\u2640\uFE0F",

    "1F3CB 1F3FE 200D 2640                      ; non-fully-qualified # 🏋🏾‍♀ woman lifting weights: medium-dark skin tone",
    "\uD83C\uDFCB\uD83C\uDFFE\u200D\u2640",

    "1F3CB 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🏋🏿‍♀️ woman lifting weights: dark skin tone",
    "\uD83C\uDFCB\uD83C\uDFFF\u200D\u2640\uFE0F",

    "1F3CB 1F3FF 200D 2640                      ; non-fully-qualified # 🏋🏿‍♀ woman lifting weights: dark skin tone",
    "\uD83C\uDFCB\uD83C\uDFFF\u200D\u2640",

    "1F6B4                                      ; fully-qualified     # 🚴 person biking",
    "\uD83D\uDEB4",

    "1F6B4 1F3FB                                ; fully-qualified     # 🚴🏻 person biking: light skin tone",
    "\uD83D\uDEB4\uD83C\uDFFB",

    "1F6B4 1F3FC                                ; fully-qualified     # 🚴🏼 person biking: medium-light skin tone",
    "\uD83D\uDEB4\uD83C\uDFFC",

    "1F6B4 1F3FD                                ; fully-qualified     # 🚴🏽 person biking: medium skin tone",
    "\uD83D\uDEB4\uD83C\uDFFD",

    "1F6B4 1F3FE                                ; fully-qualified     # 🚴🏾 person biking: medium-dark skin tone",
    "\uD83D\uDEB4\uD83C\uDFFE",

    "1F6B4 1F3FF                                ; fully-qualified     # 🚴🏿 person biking: dark skin tone",
    "\uD83D\uDEB4\uD83C\uDFFF",

    "1F6B4 200D 2642 FE0F                       ; fully-qualified     # 🚴‍♂️ man biking",
    "\uD83D\uDEB4\u200D\u2642\uFE0F",

    "1F6B4 200D 2642                            ; non-fully-qualified # 🚴‍♂ man biking",
    "\uD83D\uDEB4\u200D\u2642",

    "1F6B4 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🚴🏻‍♂️ man biking: light skin tone",
    "\uD83D\uDEB4\uD83C\uDFFB\u200D\u2642\uFE0F",

    "1F6B4 1F3FB 200D 2642                      ; non-fully-qualified # 🚴🏻‍♂ man biking: light skin tone",
    "\uD83D\uDEB4\uD83C\uDFFB\u200D\u2642",

    "1F6B4 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🚴🏼‍♂️ man biking: medium-light skin tone",
    "\uD83D\uDEB4\uD83C\uDFFC\u200D\u2642\uFE0F",

    "1F6B4 1F3FC 200D 2642                      ; non-fully-qualified # 🚴🏼‍♂ man biking: medium-light skin tone",
    "\uD83D\uDEB4\uD83C\uDFFC\u200D\u2642",

    "1F6B4 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🚴🏽‍♂️ man biking: medium skin tone",
    "\uD83D\uDEB4\uD83C\uDFFD\u200D\u2642\uFE0F",

    "1F6B4 1F3FD 200D 2642                      ; non-fully-qualified # 🚴🏽‍♂ man biking: medium skin tone",
    "\uD83D\uDEB4\uD83C\uDFFD\u200D\u2642",

    "1F6B4 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🚴🏾‍♂️ man biking: medium-dark skin tone",
    "\uD83D\uDEB4\uD83C\uDFFE\u200D\u2642\uFE0F",

    "1F6B4 1F3FE 200D 2642                      ; non-fully-qualified # 🚴🏾‍♂ man biking: medium-dark skin tone",
    "\uD83D\uDEB4\uD83C\uDFFE\u200D\u2642",

    "1F6B4 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🚴🏿‍♂️ man biking: dark skin tone",
    "\uD83D\uDEB4\uD83C\uDFFF\u200D\u2642\uFE0F",

    "1F6B4 1F3FF 200D 2642                      ; non-fully-qualified # 🚴🏿‍♂ man biking: dark skin tone",
    "\uD83D\uDEB4\uD83C\uDFFF\u200D\u2642",

    "1F6B4 200D 2640 FE0F                       ; fully-qualified     # 🚴‍♀️ woman biking",
    "\uD83D\uDEB4\u200D\u2640\uFE0F",

    "1F6B4 200D 2640                            ; non-fully-qualified # 🚴‍♀ woman biking",
    "\uD83D\uDEB4\u200D\u2640",

    "1F6B4 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🚴🏻‍♀️ woman biking: light skin tone",
    "\uD83D\uDEB4\uD83C\uDFFB\u200D\u2640\uFE0F",

    "1F6B4 1F3FB 200D 2640                      ; non-fully-qualified # 🚴🏻‍♀ woman biking: light skin tone",
    "\uD83D\uDEB4\uD83C\uDFFB\u200D\u2640",

    "1F6B4 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🚴🏼‍♀️ woman biking: medium-light skin tone",
    "\uD83D\uDEB4\uD83C\uDFFC\u200D\u2640\uFE0F",

    "1F6B4 1F3FC 200D 2640                      ; non-fully-qualified # 🚴🏼‍♀ woman biking: medium-light skin tone",
    "\uD83D\uDEB4\uD83C\uDFFC\u200D\u2640",

    "1F6B4 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🚴🏽‍♀️ woman biking: medium skin tone",
    "\uD83D\uDEB4\uD83C\uDFFD\u200D\u2640\uFE0F",

    "1F6B4 1F3FD 200D 2640                      ; non-fully-qualified # 🚴🏽‍♀ woman biking: medium skin tone",
    "\uD83D\uDEB4\uD83C\uDFFD\u200D\u2640",

    "1F6B4 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🚴🏾‍♀️ woman biking: medium-dark skin tone",
    "\uD83D\uDEB4\uD83C\uDFFE\u200D\u2640\uFE0F",

    "1F6B4 1F3FE 200D 2640                      ; non-fully-qualified # 🚴🏾‍♀ woman biking: medium-dark skin tone",
    "\uD83D\uDEB4\uD83C\uDFFE\u200D\u2640",

    "1F6B4 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🚴🏿‍♀️ woman biking: dark skin tone",
    "\uD83D\uDEB4\uD83C\uDFFF\u200D\u2640\uFE0F",

    "1F6B4 1F3FF 200D 2640                      ; non-fully-qualified # 🚴🏿‍♀ woman biking: dark skin tone",
    "\uD83D\uDEB4\uD83C\uDFFF\u200D\u2640",

    "1F6B5                                      ; fully-qualified     # 🚵 person mountain biking",
    "\uD83D\uDEB5",

    "1F6B5 1F3FB                                ; fully-qualified     # 🚵🏻 person mountain biking: light skin tone",
    "\uD83D\uDEB5\uD83C\uDFFB",

    "1F6B5 1F3FC                                ; fully-qualified     # 🚵🏼 person mountain biking: medium-light skin tone",
    "\uD83D\uDEB5\uD83C\uDFFC",

    "1F6B5 1F3FD                                ; fully-qualified     # 🚵🏽 person mountain biking: medium skin tone",
    "\uD83D\uDEB5\uD83C\uDFFD",

    "1F6B5 1F3FE                                ; fully-qualified     # 🚵🏾 person mountain biking: medium-dark skin tone",
    "\uD83D\uDEB5\uD83C\uDFFE",

    "1F6B5 1F3FF                                ; fully-qualified     # 🚵🏿 person mountain biking: dark skin tone",
    "\uD83D\uDEB5\uD83C\uDFFF",

    "1F6B5 200D 2642 FE0F                       ; fully-qualified     # 🚵‍♂️ man mountain biking",
    "\uD83D\uDEB5\u200D\u2642\uFE0F",

    "1F6B5 200D 2642                            ; non-fully-qualified # 🚵‍♂ man mountain biking",
    "\uD83D\uDEB5\u200D\u2642",

    "1F6B5 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🚵🏻‍♂️ man mountain biking: light skin tone",
    "\uD83D\uDEB5\uD83C\uDFFB\u200D\u2642\uFE0F",

    "1F6B5 1F3FB 200D 2642                      ; non-fully-qualified # 🚵🏻‍♂ man mountain biking: light skin tone",
    "\uD83D\uDEB5\uD83C\uDFFB\u200D\u2642",

    "1F6B5 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🚵🏼‍♂️ man mountain biking: medium-light skin tone",
    "\uD83D\uDEB5\uD83C\uDFFC\u200D\u2642\uFE0F",

    "1F6B5 1F3FC 200D 2642                      ; non-fully-qualified # 🚵🏼‍♂ man mountain biking: medium-light skin tone",
    "\uD83D\uDEB5\uD83C\uDFFC\u200D\u2642",

    "1F6B5 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🚵🏽‍♂️ man mountain biking: medium skin tone",
    "\uD83D\uDEB5\uD83C\uDFFD\u200D\u2642\uFE0F",

    "1F6B5 1F3FD 200D 2642                      ; non-fully-qualified # 🚵🏽‍♂ man mountain biking: medium skin tone",
    "\uD83D\uDEB5\uD83C\uDFFD\u200D\u2642",

    "1F6B5 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🚵🏾‍♂️ man mountain biking: medium-dark skin tone",
    "\uD83D\uDEB5\uD83C\uDFFE\u200D\u2642\uFE0F",

    "1F6B5 1F3FE 200D 2642                      ; non-fully-qualified # 🚵🏾‍♂ man mountain biking: medium-dark skin tone",
    "\uD83D\uDEB5\uD83C\uDFFE\u200D\u2642",

    "1F6B5 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🚵🏿‍♂️ man mountain biking: dark skin tone",
    "\uD83D\uDEB5\uD83C\uDFFF\u200D\u2642\uFE0F",

    "1F6B5 1F3FF 200D 2642                      ; non-fully-qualified # 🚵🏿‍♂ man mountain biking: dark skin tone",
    "\uD83D\uDEB5\uD83C\uDFFF\u200D\u2642",

    "1F6B5 200D 2640 FE0F                       ; fully-qualified     # 🚵‍♀️ woman mountain biking",
    "\uD83D\uDEB5\u200D\u2640\uFE0F",

    "1F6B5 200D 2640                            ; non-fully-qualified # 🚵‍♀ woman mountain biking",
    "\uD83D\uDEB5\u200D\u2640",

    "1F6B5 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🚵🏻‍♀️ woman mountain biking: light skin tone",
    "\uD83D\uDEB5\uD83C\uDFFB\u200D\u2640\uFE0F",

    "1F6B5 1F3FB 200D 2640                      ; non-fully-qualified # 🚵🏻‍♀ woman mountain biking: light skin tone",
    "\uD83D\uDEB5\uD83C\uDFFB\u200D\u2640",

    "1F6B5 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🚵🏼‍♀️ woman mountain biking: medium-light skin tone",
    "\uD83D\uDEB5\uD83C\uDFFC\u200D\u2640\uFE0F",

    "1F6B5 1F3FC 200D 2640                      ; non-fully-qualified # 🚵🏼‍♀ woman mountain biking: medium-light skin tone",
    "\uD83D\uDEB5\uD83C\uDFFC\u200D\u2640",

    "1F6B5 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🚵🏽‍♀️ woman mountain biking: medium skin tone",
    "\uD83D\uDEB5\uD83C\uDFFD\u200D\u2640\uFE0F",

    "1F6B5 1F3FD 200D 2640                      ; non-fully-qualified # 🚵🏽‍♀ woman mountain biking: medium skin tone",
    "\uD83D\uDEB5\uD83C\uDFFD\u200D\u2640",

    "1F6B5 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🚵🏾‍♀️ woman mountain biking: medium-dark skin tone",
    "\uD83D\uDEB5\uD83C\uDFFE\u200D\u2640\uFE0F",

    "1F6B5 1F3FE 200D 2640                      ; non-fully-qualified # 🚵🏾‍♀ woman mountain biking: medium-dark skin tone",
    "\uD83D\uDEB5\uD83C\uDFFE\u200D\u2640",

    "1F6B5 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🚵🏿‍♀️ woman mountain biking: dark skin tone",
    "\uD83D\uDEB5\uD83C\uDFFF\u200D\u2640\uFE0F",

    "1F6B5 1F3FF 200D 2640                      ; non-fully-qualified # 🚵🏿‍♀ woman mountain biking: dark skin tone",
    "\uD83D\uDEB5\uD83C\uDFFF\u200D\u2640",

    "1F3CE FE0F                                 ; fully-qualified     # 🏎️ racing car",
    "\uD83C\uDFCE\uFE0F",

    "1F3CE                                      ; non-fully-qualified # 🏎 racing car",
    "\uD83C\uDFCE",

    "1F3CD FE0F                                 ; fully-qualified     # 🏍️ motorcycle",
    "\uD83C\uDFCD\uFE0F",

    "1F3CD                                      ; non-fully-qualified # 🏍 motorcycle",
    "\uD83C\uDFCD",

    "1F938                                      ; fully-qualified     # 🤸 person cartwheeling",
    "\uD83E\uDD38",

    "1F938 1F3FB                                ; fully-qualified     # 🤸🏻 person cartwheeling: light skin tone",
    "\uD83E\uDD38\uD83C\uDFFB",

    "1F938 1F3FC                                ; fully-qualified     # 🤸🏼 person cartwheeling: medium-light skin tone",
    "\uD83E\uDD38\uD83C\uDFFC",

    "1F938 1F3FD                                ; fully-qualified     # 🤸🏽 person cartwheeling: medium skin tone",
    "\uD83E\uDD38\uD83C\uDFFD",

    "1F938 1F3FE                                ; fully-qualified     # 🤸🏾 person cartwheeling: medium-dark skin tone",
    "\uD83E\uDD38\uD83C\uDFFE",

    "1F938 1F3FF                                ; fully-qualified     # 🤸🏿 person cartwheeling: dark skin tone",
    "\uD83E\uDD38\uD83C\uDFFF",

    "1F938 200D 2642 FE0F                       ; fully-qualified     # 🤸‍♂️ man cartwheeling",
    "\uD83E\uDD38\u200D\u2642\uFE0F",

    "1F938 200D 2642                            ; non-fully-qualified # 🤸‍♂ man cartwheeling",
    "\uD83E\uDD38\u200D\u2642",

    "1F938 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🤸🏻‍♂️ man cartwheeling: light skin tone",
    "\uD83E\uDD38\uD83C\uDFFB\u200D\u2642\uFE0F",

    "1F938 1F3FB 200D 2642                      ; non-fully-qualified # 🤸🏻‍♂ man cartwheeling: light skin tone",
    "\uD83E\uDD38\uD83C\uDFFB\u200D\u2642",

    "1F938 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🤸🏼‍♂️ man cartwheeling: medium-light skin tone",
    "\uD83E\uDD38\uD83C\uDFFC\u200D\u2642\uFE0F",

    "1F938 1F3FC 200D 2642                      ; non-fully-qualified # 🤸🏼‍♂ man cartwheeling: medium-light skin tone",
    "\uD83E\uDD38\uD83C\uDFFC\u200D\u2642",

    "1F938 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🤸🏽‍♂️ man cartwheeling: medium skin tone",
    "\uD83E\uDD38\uD83C\uDFFD\u200D\u2642\uFE0F",

    "1F938 1F3FD 200D 2642                      ; non-fully-qualified # 🤸🏽‍♂ man cartwheeling: medium skin tone",
    "\uD83E\uDD38\uD83C\uDFFD\u200D\u2642",

    "1F938 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🤸🏾‍♂️ man cartwheeling: medium-dark skin tone",
    "\uD83E\uDD38\uD83C\uDFFE\u200D\u2642\uFE0F",

    "1F938 1F3FE 200D 2642                      ; non-fully-qualified # 🤸🏾‍♂ man cartwheeling: medium-dark skin tone",
    "\uD83E\uDD38\uD83C\uDFFE\u200D\u2642",

    "1F938 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🤸🏿‍♂️ man cartwheeling: dark skin tone",
    "\uD83E\uDD38\uD83C\uDFFF\u200D\u2642\uFE0F",

    "1F938 1F3FF 200D 2642                      ; non-fully-qualified # 🤸🏿‍♂ man cartwheeling: dark skin tone",
    "\uD83E\uDD38\uD83C\uDFFF\u200D\u2642",

    "1F938 200D 2640 FE0F                       ; fully-qualified     # 🤸‍♀️ woman cartwheeling",
    "\uD83E\uDD38\u200D\u2640\uFE0F",

    "1F938 200D 2640                            ; non-fully-qualified # 🤸‍♀ woman cartwheeling",
    "\uD83E\uDD38\u200D\u2640",

    "1F938 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🤸🏻‍♀️ woman cartwheeling: light skin tone",
    "\uD83E\uDD38\uD83C\uDFFB\u200D\u2640\uFE0F",

    "1F938 1F3FB 200D 2640                      ; non-fully-qualified # 🤸🏻‍♀ woman cartwheeling: light skin tone",
    "\uD83E\uDD38\uD83C\uDFFB\u200D\u2640",

    "1F938 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🤸🏼‍♀️ woman cartwheeling: medium-light skin tone",
    "\uD83E\uDD38\uD83C\uDFFC\u200D\u2640\uFE0F",

    "1F938 1F3FC 200D 2640                      ; non-fully-qualified # 🤸🏼‍♀ woman cartwheeling: medium-light skin tone",
    "\uD83E\uDD38\uD83C\uDFFC\u200D\u2640",

    "1F938 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🤸🏽‍♀️ woman cartwheeling: medium skin tone",
    "\uD83E\uDD38\uD83C\uDFFD\u200D\u2640\uFE0F",

    "1F938 1F3FD 200D 2640                      ; non-fully-qualified # 🤸🏽‍♀ woman cartwheeling: medium skin tone",
    "\uD83E\uDD38\uD83C\uDFFD\u200D\u2640",

    "1F938 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🤸🏾‍♀️ woman cartwheeling: medium-dark skin tone",
    "\uD83E\uDD38\uD83C\uDFFE\u200D\u2640\uFE0F",

    "1F938 1F3FE 200D 2640                      ; non-fully-qualified # 🤸🏾‍♀ woman cartwheeling: medium-dark skin tone",
    "\uD83E\uDD38\uD83C\uDFFE\u200D\u2640",

    "1F938 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🤸🏿‍♀️ woman cartwheeling: dark skin tone",
    "\uD83E\uDD38\uD83C\uDFFF\u200D\u2640\uFE0F",

    "1F938 1F3FF 200D 2640                      ; non-fully-qualified # 🤸🏿‍♀ woman cartwheeling: dark skin tone",
    "\uD83E\uDD38\uD83C\uDFFF\u200D\u2640",

    "1F93C                                      ; fully-qualified     # 🤼 people wrestling",
    "\uD83E\uDD3C",

    "1F93C 200D 2642 FE0F                       ; fully-qualified     # 🤼‍♂️ men wrestling",
    "\uD83E\uDD3C\u200D\u2642\uFE0F",

    "1F93C 200D 2642                            ; non-fully-qualified # 🤼‍♂ men wrestling",
    "\uD83E\uDD3C\u200D\u2642",

    "1F93C 200D 2640 FE0F                       ; fully-qualified     # 🤼‍♀️ women wrestling",
    "\uD83E\uDD3C\u200D\u2640\uFE0F",

    "1F93C 200D 2640                            ; non-fully-qualified # 🤼‍♀ women wrestling",
    "\uD83E\uDD3C\u200D\u2640",

    "1F93D                                      ; fully-qualified     # 🤽 person playing water polo",
    "\uD83E\uDD3D",

    "1F93D 1F3FB                                ; fully-qualified     # 🤽🏻 person playing water polo: light skin tone",
    "\uD83E\uDD3D\uD83C\uDFFB",

    "1F93D 1F3FC                                ; fully-qualified     # 🤽🏼 person playing water polo: medium-light skin tone",
    "\uD83E\uDD3D\uD83C\uDFFC",

    "1F93D 1F3FD                                ; fully-qualified     # 🤽🏽 person playing water polo: medium skin tone",
    "\uD83E\uDD3D\uD83C\uDFFD",

    "1F93D 1F3FE                                ; fully-qualified     # 🤽🏾 person playing water polo: medium-dark skin tone",
    "\uD83E\uDD3D\uD83C\uDFFE",

    "1F93D 1F3FF                                ; fully-qualified     # 🤽🏿 person playing water polo: dark skin tone",
    "\uD83E\uDD3D\uD83C\uDFFF",

    "1F93D 200D 2642 FE0F                       ; fully-qualified     # 🤽‍♂️ man playing water polo",
    "\uD83E\uDD3D\u200D\u2642\uFE0F",

    "1F93D 200D 2642                            ; non-fully-qualified # 🤽‍♂ man playing water polo",
    "\uD83E\uDD3D\u200D\u2642",

    "1F93D 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🤽🏻‍♂️ man playing water polo: light skin tone",
    "\uD83E\uDD3D\uD83C\uDFFB\u200D\u2642\uFE0F",

    "1F93D 1F3FB 200D 2642                      ; non-fully-qualified # 🤽🏻‍♂ man playing water polo: light skin tone",
    "\uD83E\uDD3D\uD83C\uDFFB\u200D\u2642",

    "1F93D 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🤽🏼‍♂️ man playing water polo: medium-light skin tone",
    "\uD83E\uDD3D\uD83C\uDFFC\u200D\u2642\uFE0F",

    "1F93D 1F3FC 200D 2642                      ; non-fully-qualified # 🤽🏼‍♂ man playing water polo: medium-light skin tone",
    "\uD83E\uDD3D\uD83C\uDFFC\u200D\u2642",

    "1F93D 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🤽🏽‍♂️ man playing water polo: medium skin tone",
    "\uD83E\uDD3D\uD83C\uDFFD\u200D\u2642\uFE0F",

    "1F93D 1F3FD 200D 2642                      ; non-fully-qualified # 🤽🏽‍♂ man playing water polo: medium skin tone",
    "\uD83E\uDD3D\uD83C\uDFFD\u200D\u2642",

    "1F93D 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🤽🏾‍♂️ man playing water polo: medium-dark skin tone",
    "\uD83E\uDD3D\uD83C\uDFFE\u200D\u2642\uFE0F",

    "1F93D 1F3FE 200D 2642                      ; non-fully-qualified # 🤽🏾‍♂ man playing water polo: medium-dark skin tone",
    "\uD83E\uDD3D\uD83C\uDFFE\u200D\u2642",

    "1F93D 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🤽🏿‍♂️ man playing water polo: dark skin tone",
    "\uD83E\uDD3D\uD83C\uDFFF\u200D\u2642\uFE0F",

    "1F93D 1F3FF 200D 2642                      ; non-fully-qualified # 🤽🏿‍♂ man playing water polo: dark skin tone",
    "\uD83E\uDD3D\uD83C\uDFFF\u200D\u2642",

    "1F93D 200D 2640 FE0F                       ; fully-qualified     # 🤽‍♀️ woman playing water polo",
    "\uD83E\uDD3D\u200D\u2640\uFE0F",

    "1F93D 200D 2640                            ; non-fully-qualified # 🤽‍♀ woman playing water polo",
    "\uD83E\uDD3D\u200D\u2640",

    "1F93D 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🤽🏻‍♀️ woman playing water polo: light skin tone",
    "\uD83E\uDD3D\uD83C\uDFFB\u200D\u2640\uFE0F",

    "1F93D 1F3FB 200D 2640                      ; non-fully-qualified # 🤽🏻‍♀ woman playing water polo: light skin tone",
    "\uD83E\uDD3D\uD83C\uDFFB\u200D\u2640",

    "1F93D 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🤽🏼‍♀️ woman playing water polo: medium-light skin tone",
    "\uD83E\uDD3D\uD83C\uDFFC\u200D\u2640\uFE0F",

    "1F93D 1F3FC 200D 2640                      ; non-fully-qualified # 🤽🏼‍♀ woman playing water polo: medium-light skin tone",
    "\uD83E\uDD3D\uD83C\uDFFC\u200D\u2640",

    "1F93D 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🤽🏽‍♀️ woman playing water polo: medium skin tone",
    "\uD83E\uDD3D\uD83C\uDFFD\u200D\u2640\uFE0F",

    "1F93D 1F3FD 200D 2640                      ; non-fully-qualified # 🤽🏽‍♀ woman playing water polo: medium skin tone",
    "\uD83E\uDD3D\uD83C\uDFFD\u200D\u2640",

    "1F93D 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🤽🏾‍♀️ woman playing water polo: medium-dark skin tone",
    "\uD83E\uDD3D\uD83C\uDFFE\u200D\u2640\uFE0F",

    "1F93D 1F3FE 200D 2640                      ; non-fully-qualified # 🤽🏾‍♀ woman playing water polo: medium-dark skin tone",
    "\uD83E\uDD3D\uD83C\uDFFE\u200D\u2640",

    "1F93D 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🤽🏿‍♀️ woman playing water polo: dark skin tone",
    "\uD83E\uDD3D\uD83C\uDFFF\u200D\u2640\uFE0F",

    "1F93D 1F3FF 200D 2640                      ; non-fully-qualified # 🤽🏿‍♀ woman playing water polo: dark skin tone",
    "\uD83E\uDD3D\uD83C\uDFFF\u200D\u2640",

    "1F93E                                      ; fully-qualified     # 🤾 person playing handball",
    "\uD83E\uDD3E",

    "1F93E 1F3FB                                ; fully-qualified     # 🤾🏻 person playing handball: light skin tone",
    "\uD83E\uDD3E\uD83C\uDFFB",

    "1F93E 1F3FC                                ; fully-qualified     # 🤾🏼 person playing handball: medium-light skin tone",
    "\uD83E\uDD3E\uD83C\uDFFC",

    "1F93E 1F3FD                                ; fully-qualified     # 🤾🏽 person playing handball: medium skin tone",
    "\uD83E\uDD3E\uD83C\uDFFD",

    "1F93E 1F3FE                                ; fully-qualified     # 🤾🏾 person playing handball: medium-dark skin tone",
    "\uD83E\uDD3E\uD83C\uDFFE",

    "1F93E 1F3FF                                ; fully-qualified     # 🤾🏿 person playing handball: dark skin tone",
    "\uD83E\uDD3E\uD83C\uDFFF",

    "1F93E 200D 2642 FE0F                       ; fully-qualified     # 🤾‍♂️ man playing handball",
    "\uD83E\uDD3E\u200D\u2642\uFE0F",

    "1F93E 200D 2642                            ; non-fully-qualified # 🤾‍♂ man playing handball",
    "\uD83E\uDD3E\u200D\u2642",

    "1F93E 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🤾🏻‍♂️ man playing handball: light skin tone",
    "\uD83E\uDD3E\uD83C\uDFFB\u200D\u2642\uFE0F",

    "1F93E 1F3FB 200D 2642                      ; non-fully-qualified # 🤾🏻‍♂ man playing handball: light skin tone",
    "\uD83E\uDD3E\uD83C\uDFFB\u200D\u2642",

    "1F93E 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🤾🏼‍♂️ man playing handball: medium-light skin tone",
    "\uD83E\uDD3E\uD83C\uDFFC\u200D\u2642\uFE0F",

    "1F93E 1F3FC 200D 2642                      ; non-fully-qualified # 🤾🏼‍♂ man playing handball: medium-light skin tone",
    "\uD83E\uDD3E\uD83C\uDFFC\u200D\u2642",

    "1F93E 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🤾🏽‍♂️ man playing handball: medium skin tone",
    "\uD83E\uDD3E\uD83C\uDFFD\u200D\u2642\uFE0F",

    "1F93E 1F3FD 200D 2642                      ; non-fully-qualified # 🤾🏽‍♂ man playing handball: medium skin tone",
    "\uD83E\uDD3E\uD83C\uDFFD\u200D\u2642",

    "1F93E 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🤾🏾‍♂️ man playing handball: medium-dark skin tone",
    "\uD83E\uDD3E\uD83C\uDFFE\u200D\u2642\uFE0F",

    "1F93E 1F3FE 200D 2642                      ; non-fully-qualified # 🤾🏾‍♂ man playing handball: medium-dark skin tone",
    "\uD83E\uDD3E\uD83C\uDFFE\u200D\u2642",

    "1F93E 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🤾🏿‍♂️ man playing handball: dark skin tone",
    "\uD83E\uDD3E\uD83C\uDFFF\u200D\u2642\uFE0F",

    "1F93E 1F3FF 200D 2642                      ; non-fully-qualified # 🤾🏿‍♂ man playing handball: dark skin tone",
    "\uD83E\uDD3E\uD83C\uDFFF\u200D\u2642",

    "1F93E 200D 2640 FE0F                       ; fully-qualified     # 🤾‍♀️ woman playing handball",
    "\uD83E\uDD3E\u200D\u2640\uFE0F",

    "1F93E 200D 2640                            ; non-fully-qualified # 🤾‍♀ woman playing handball",
    "\uD83E\uDD3E\u200D\u2640",

    "1F93E 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🤾🏻‍♀️ woman playing handball: light skin tone",
    "\uD83E\uDD3E\uD83C\uDFFB\u200D\u2640\uFE0F",

    "1F93E 1F3FB 200D 2640                      ; non-fully-qualified # 🤾🏻‍♀ woman playing handball: light skin tone",
    "\uD83E\uDD3E\uD83C\uDFFB\u200D\u2640",

    "1F93E 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🤾🏼‍♀️ woman playing handball: medium-light skin tone",
    "\uD83E\uDD3E\uD83C\uDFFC\u200D\u2640\uFE0F",

    "1F93E 1F3FC 200D 2640                      ; non-fully-qualified # 🤾🏼‍♀ woman playing handball: medium-light skin tone",
    "\uD83E\uDD3E\uD83C\uDFFC\u200D\u2640",

    "1F93E 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🤾🏽‍♀️ woman playing handball: medium skin tone",
    "\uD83E\uDD3E\uD83C\uDFFD\u200D\u2640\uFE0F",

    "1F93E 1F3FD 200D 2640                      ; non-fully-qualified # 🤾🏽‍♀ woman playing handball: medium skin tone",
    "\uD83E\uDD3E\uD83C\uDFFD\u200D\u2640",

    "1F93E 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🤾🏾‍♀️ woman playing handball: medium-dark skin tone",
    "\uD83E\uDD3E\uD83C\uDFFE\u200D\u2640\uFE0F",

    "1F93E 1F3FE 200D 2640                      ; non-fully-qualified # 🤾🏾‍♀ woman playing handball: medium-dark skin tone",
    "\uD83E\uDD3E\uD83C\uDFFE\u200D\u2640",

    "1F93E 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🤾🏿‍♀️ woman playing handball: dark skin tone",
    "\uD83E\uDD3E\uD83C\uDFFF\u200D\u2640\uFE0F",

    "1F93E 1F3FF 200D 2640                      ; non-fully-qualified # 🤾🏿‍♀ woman playing handball: dark skin tone",
    "\uD83E\uDD3E\uD83C\uDFFF\u200D\u2640",

    "1F939                                      ; fully-qualified     # 🤹 person juggling",
    "\uD83E\uDD39",

    "1F939 1F3FB                                ; fully-qualified     # 🤹🏻 person juggling: light skin tone",
    "\uD83E\uDD39\uD83C\uDFFB",

    "1F939 1F3FC                                ; fully-qualified     # 🤹🏼 person juggling: medium-light skin tone",
    "\uD83E\uDD39\uD83C\uDFFC",

    "1F939 1F3FD                                ; fully-qualified     # 🤹🏽 person juggling: medium skin tone",
    "\uD83E\uDD39\uD83C\uDFFD",

    "1F939 1F3FE                                ; fully-qualified     # 🤹🏾 person juggling: medium-dark skin tone",
    "\uD83E\uDD39\uD83C\uDFFE",

    "1F939 1F3FF                                ; fully-qualified     # 🤹🏿 person juggling: dark skin tone",
    "\uD83E\uDD39\uD83C\uDFFF",

    "1F939 200D 2642 FE0F                       ; fully-qualified     # 🤹‍♂️ man juggling",
    "\uD83E\uDD39\u200D\u2642\uFE0F",

    "1F939 200D 2642                            ; non-fully-qualified # 🤹‍♂ man juggling",
    "\uD83E\uDD39\u200D\u2642",

    "1F939 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🤹🏻‍♂️ man juggling: light skin tone",
    "\uD83E\uDD39\uD83C\uDFFB\u200D\u2642\uFE0F",

    "1F939 1F3FB 200D 2642                      ; non-fully-qualified # 🤹🏻‍♂ man juggling: light skin tone",
    "\uD83E\uDD39\uD83C\uDFFB\u200D\u2642",

    "1F939 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🤹🏼‍♂️ man juggling: medium-light skin tone",
    "\uD83E\uDD39\uD83C\uDFFC\u200D\u2642\uFE0F",

    "1F939 1F3FC 200D 2642                      ; non-fully-qualified # 🤹🏼‍♂ man juggling: medium-light skin tone",
    "\uD83E\uDD39\uD83C\uDFFC\u200D\u2642",

    "1F939 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🤹🏽‍♂️ man juggling: medium skin tone",
    "\uD83E\uDD39\uD83C\uDFFD\u200D\u2642\uFE0F",

    "1F939 1F3FD 200D 2642                      ; non-fully-qualified # 🤹🏽‍♂ man juggling: medium skin tone",
    "\uD83E\uDD39\uD83C\uDFFD\u200D\u2642",

    "1F939 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🤹🏾‍♂️ man juggling: medium-dark skin tone",
    "\uD83E\uDD39\uD83C\uDFFE\u200D\u2642\uFE0F",

    "1F939 1F3FE 200D 2642                      ; non-fully-qualified # 🤹🏾‍♂ man juggling: medium-dark skin tone",
    "\uD83E\uDD39\uD83C\uDFFE\u200D\u2642",

    "1F939 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🤹🏿‍♂️ man juggling: dark skin tone",
    "\uD83E\uDD39\uD83C\uDFFF\u200D\u2642\uFE0F",

    "1F939 1F3FF 200D 2642                      ; non-fully-qualified # 🤹🏿‍♂ man juggling: dark skin tone",
    "\uD83E\uDD39\uD83C\uDFFF\u200D\u2642",

    "1F939 200D 2640 FE0F                       ; fully-qualified     # 🤹‍♀️ woman juggling",
    "\uD83E\uDD39\u200D\u2640\uFE0F",

    "1F939 200D 2640                            ; non-fully-qualified # 🤹‍♀ woman juggling",
    "\uD83E\uDD39\u200D\u2640",

    "1F939 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🤹🏻‍♀️ woman juggling: light skin tone",
    "\uD83E\uDD39\uD83C\uDFFB\u200D\u2640\uFE0F",

    "1F939 1F3FB 200D 2640                      ; non-fully-qualified # 🤹🏻‍♀ woman juggling: light skin tone",
    "\uD83E\uDD39\uD83C\uDFFB\u200D\u2640",

    "1F939 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🤹🏼‍♀️ woman juggling: medium-light skin tone",
    "\uD83E\uDD39\uD83C\uDFFC\u200D\u2640\uFE0F",

    "1F939 1F3FC 200D 2640                      ; non-fully-qualified # 🤹🏼‍♀ woman juggling: medium-light skin tone",
    "\uD83E\uDD39\uD83C\uDFFC\u200D\u2640",

    "1F939 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🤹🏽‍♀️ woman juggling: medium skin tone",
    "\uD83E\uDD39\uD83C\uDFFD\u200D\u2640\uFE0F",

    "1F939 1F3FD 200D 2640                      ; non-fully-qualified # 🤹🏽‍♀ woman juggling: medium skin tone",
    "\uD83E\uDD39\uD83C\uDFFD\u200D\u2640",

    "1F939 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🤹🏾‍♀️ woman juggling: medium-dark skin tone",
    "\uD83E\uDD39\uD83C\uDFFE\u200D\u2640\uFE0F",

    "1F939 1F3FE 200D 2640                      ; non-fully-qualified # 🤹🏾‍♀ woman juggling: medium-dark skin tone",
    "\uD83E\uDD39\uD83C\uDFFE\u200D\u2640",

    "1F939 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🤹🏿‍♀️ woman juggling: dark skin tone",
    "\uD83E\uDD39\uD83C\uDFFF\u200D\u2640\uFE0F",

    "1F939 1F3FF 200D 2640                      ; non-fully-qualified # 🤹🏿‍♀ woman juggling: dark skin tone",
    "\uD83E\uDD39\uD83C\uDFFF\u200D\u2640",

    "1F46B                                      ; fully-qualified     # 👫 man and woman holding hands",
    "\uD83D\uDC6B",

    "1F46C                                      ; fully-qualified     # 👬 two men holding hands",
    "\uD83D\uDC6C",

    "1F46D                                      ; fully-qualified     # 👭 two women holding hands",
    "\uD83D\uDC6D",

    "1F48F                                      ; fully-qualified     # 💏 kiss",
    "\uD83D\uDC8F",

    "1F469 200D 2764 FE0F 200D 1F48B 200D 1F468 ; fully-qualified     # 👩‍❤️‍💋‍👨 kiss: woman, man",
    "\uD83D\uDC69\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68",

    "1F469 200D 2764 200D 1F48B 200D 1F468      ; non-fully-qualified # 👩‍❤‍💋‍👨 kiss: woman, man",
    "\uD83D\uDC69\u200D\u2764\u200D\uD83D\uDC8B\u200D\uD83D\uDC68",

    "1F468 200D 2764 FE0F 200D 1F48B 200D 1F468 ; fully-qualified     # 👨‍❤️‍💋‍👨 kiss: man, man",
    "\uD83D\uDC68\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68",

    "1F468 200D 2764 200D 1F48B 200D 1F468      ; non-fully-qualified # 👨‍❤‍💋‍👨 kiss: man, man",
    "\uD83D\uDC68\u200D\u2764\u200D\uD83D\uDC8B\u200D\uD83D\uDC68",

    "1F469 200D 2764 FE0F 200D 1F48B 200D 1F469 ; fully-qualified     # 👩‍❤️‍💋‍👩 kiss: woman, woman",
    "\uD83D\uDC69\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC69",

    "1F469 200D 2764 200D 1F48B 200D 1F469      ; non-fully-qualified # 👩‍❤‍💋‍👩 kiss: woman, woman",
    "\uD83D\uDC69\u200D\u2764\u200D\uD83D\uDC8B\u200D\uD83D\uDC69",

    "1F491                                      ; fully-qualified     # 💑 couple with heart",
    "\uD83D\uDC91",

    "1F469 200D 2764 FE0F 200D 1F468            ; fully-qualified     # 👩‍❤️‍👨 couple with heart: woman, man",
    "\uD83D\uDC69\u200D\u2764\uFE0F\u200D\uD83D\uDC68",

    "1F469 200D 2764 200D 1F468                 ; non-fully-qualified # 👩‍❤‍👨 couple with heart: woman, man",
    "\uD83D\uDC69\u200D\u2764\u200D\uD83D\uDC68",

    "1F468 200D 2764 FE0F 200D 1F468            ; fully-qualified     # 👨‍❤️‍👨 couple with heart: man, man",
    "\uD83D\uDC68\u200D\u2764\uFE0F\u200D\uD83D\uDC68",

    "1F468 200D 2764 200D 1F468                 ; non-fully-qualified # 👨‍❤‍👨 couple with heart: man, man",
    "\uD83D\uDC68\u200D\u2764\u200D\uD83D\uDC68",

    "1F469 200D 2764 FE0F 200D 1F469            ; fully-qualified     # 👩‍❤️‍👩 couple with heart: woman, woman",
    "\uD83D\uDC69\u200D\u2764\uFE0F\u200D\uD83D\uDC69",

    "1F469 200D 2764 200D 1F469                 ; non-fully-qualified # 👩‍❤‍👩 couple with heart: woman, woman",
    "\uD83D\uDC69\u200D\u2764\u200D\uD83D\uDC69",

    "1F46A                                      ; fully-qualified     # 👪 family",
    "\uD83D\uDC6A",

    "1F468 200D 1F469 200D 1F466                ; fully-qualified     # 👨‍👩‍👦 family: man, woman, boy",
    "\uD83D\uDC68\u200D\uD83D\uDC69\u200D\uD83D\uDC66",

    "1F468 200D 1F469 200D 1F467                ; fully-qualified     # 👨‍👩‍👧 family: man, woman, girl",
    "\uD83D\uDC68\u200D\uD83D\uDC69\u200D\uD83D\uDC67",

    "1F468 200D 1F469 200D 1F467 200D 1F466     ; fully-qualified     # 👨‍👩‍👧‍👦 family: man, woman, girl, boy",
    "\uD83D\uDC68\u200D\uD83D\uDC69\u200D\uD83D\uDC67\u200D\uD83D\uDC66",

    "1F468 200D 1F469 200D 1F466 200D 1F466     ; fully-qualified     # 👨‍👩‍👦‍👦 family: man, woman, boy, boy",
    "\uD83D\uDC68\u200D\uD83D\uDC69\u200D\uD83D\uDC66\u200D\uD83D\uDC66",

    "1F468 200D 1F469 200D 1F467 200D 1F467     ; fully-qualified     # 👨‍👩‍👧‍👧 family: man, woman, girl, girl",
    "\uD83D\uDC68\u200D\uD83D\uDC69\u200D\uD83D\uDC67\u200D\uD83D\uDC67",

    "1F468 200D 1F468 200D 1F466                ; fully-qualified     # 👨‍👨‍👦 family: man, man, boy",
    "\uD83D\uDC68\u200D\uD83D\uDC68\u200D\uD83D\uDC66",

    "1F468 200D 1F468 200D 1F467                ; fully-qualified     # 👨‍👨‍👧 family: man, man, girl",
    "\uD83D\uDC68\u200D\uD83D\uDC68\u200D\uD83D\uDC67",

    "1F468 200D 1F468 200D 1F467 200D 1F466     ; fully-qualified     # 👨‍👨‍👧‍👦 family: man, man, girl, boy",
    "\uD83D\uDC68\u200D\uD83D\uDC68\u200D\uD83D\uDC67\u200D\uD83D\uDC66",

    "1F468 200D 1F468 200D 1F466 200D 1F466     ; fully-qualified     # 👨‍👨‍👦‍👦 family: man, man, boy, boy",
    "\uD83D\uDC68\u200D\uD83D\uDC68\u200D\uD83D\uDC66\u200D\uD83D\uDC66",

    "1F468 200D 1F468 200D 1F467 200D 1F467     ; fully-qualified     # 👨‍👨‍👧‍👧 family: man, man, girl, girl",
    "\uD83D\uDC68\u200D\uD83D\uDC68\u200D\uD83D\uDC67\u200D\uD83D\uDC67",

    "1F469 200D 1F469 200D 1F466                ; fully-qualified     # 👩‍👩‍👦 family: woman, woman, boy",
    "\uD83D\uDC69\u200D\uD83D\uDC69\u200D\uD83D\uDC66",

    "1F469 200D 1F469 200D 1F467                ; fully-qualified     # 👩‍👩‍👧 family: woman, woman, girl",
    "\uD83D\uDC69\u200D\uD83D\uDC69\u200D\uD83D\uDC67",

    "1F469 200D 1F469 200D 1F467 200D 1F466     ; fully-qualified     # 👩‍👩‍👧‍👦 family: woman, woman, girl, boy",
    "\uD83D\uDC69\u200D\uD83D\uDC69\u200D\uD83D\uDC67\u200D\uD83D\uDC66",

    "1F469 200D 1F469 200D 1F466 200D 1F466     ; fully-qualified     # 👩‍👩‍👦‍👦 family: woman, woman, boy, boy",
    "\uD83D\uDC69\u200D\uD83D\uDC69\u200D\uD83D\uDC66\u200D\uD83D\uDC66",

    "1F469 200D 1F469 200D 1F467 200D 1F467     ; fully-qualified     # 👩‍👩‍👧‍👧 family: woman, woman, girl, girl",
    "\uD83D\uDC69\u200D\uD83D\uDC69\u200D\uD83D\uDC67\u200D\uD83D\uDC67",

    "1F468 200D 1F466                           ; fully-qualified     # 👨‍👦 family: man, boy",
    "\uD83D\uDC68\u200D\uD83D\uDC66",

    "1F468 200D 1F466 200D 1F466                ; fully-qualified     # 👨‍👦‍👦 family: man, boy, boy",
    "\uD83D\uDC68\u200D\uD83D\uDC66\u200D\uD83D\uDC66",

    "1F468 200D 1F467                           ; fully-qualified     # 👨‍👧 family: man, girl",
    "\uD83D\uDC68\u200D\uD83D\uDC67",

    "1F468 200D 1F467 200D 1F466                ; fully-qualified     # 👨‍👧‍👦 family: man, girl, boy",
    "\uD83D\uDC68\u200D\uD83D\uDC67\u200D\uD83D\uDC66",

    "1F468 200D 1F467 200D 1F467                ; fully-qualified     # 👨‍👧‍👧 family: man, girl, girl",
    "\uD83D\uDC68\u200D\uD83D\uDC67\u200D\uD83D\uDC67",

    "1F469 200D 1F466                           ; fully-qualified     # 👩‍👦 family: woman, boy",
    "\uD83D\uDC69\u200D\uD83D\uDC66",

    "1F469 200D 1F466 200D 1F466                ; fully-qualified     # 👩‍👦‍👦 family: woman, boy, boy",
    "\uD83D\uDC69\u200D\uD83D\uDC66\u200D\uD83D\uDC66",

    "1F469 200D 1F467                           ; fully-qualified     # 👩‍👧 family: woman, girl",
    "\uD83D\uDC69\u200D\uD83D\uDC67",

    "1F469 200D 1F467 200D 1F466                ; fully-qualified     # 👩‍👧‍👦 family: woman, girl, boy",
    "\uD83D\uDC69\u200D\uD83D\uDC67\u200D\uD83D\uDC66",

    "1F469 200D 1F467 200D 1F467                ; fully-qualified     # 👩‍👧‍👧 family: woman, girl, girl",
    "\uD83D\uDC69\u200D\uD83D\uDC67\u200D\uD83D\uDC67",

    "1F933                                      ; fully-qualified     # 🤳 selfie",
    "\uD83E\uDD33",

    "1F933 1F3FB                                ; fully-qualified     # 🤳🏻 selfie: light skin tone",
    "\uD83E\uDD33\uD83C\uDFFB",

    "1F933 1F3FC                                ; fully-qualified     # 🤳🏼 selfie: medium-light skin tone",
    "\uD83E\uDD33\uD83C\uDFFC",

    "1F933 1F3FD                                ; fully-qualified     # 🤳🏽 selfie: medium skin tone",
    "\uD83E\uDD33\uD83C\uDFFD",

    "1F933 1F3FE                                ; fully-qualified     # 🤳🏾 selfie: medium-dark skin tone",
    "\uD83E\uDD33\uD83C\uDFFE",

    "1F933 1F3FF                                ; fully-qualified     # 🤳🏿 selfie: dark skin tone",
    "\uD83E\uDD33\uD83C\uDFFF",

    "1F4AA                                      ; fully-qualified     # 💪 flexed biceps",
    "\uD83D\uDCAA",

    "1F4AA 1F3FB                                ; fully-qualified     # 💪🏻 flexed biceps: light skin tone",
    "\uD83D\uDCAA\uD83C\uDFFB",

    "1F4AA 1F3FC                                ; fully-qualified     # 💪🏼 flexed biceps: medium-light skin tone",
    "\uD83D\uDCAA\uD83C\uDFFC",

    "1F4AA 1F3FD                                ; fully-qualified     # 💪🏽 flexed biceps: medium skin tone",
    "\uD83D\uDCAA\uD83C\uDFFD",

    "1F4AA 1F3FE                                ; fully-qualified     # 💪🏾 flexed biceps: medium-dark skin tone",
    "\uD83D\uDCAA\uD83C\uDFFE",

    "1F4AA 1F3FF                                ; fully-qualified     # 💪🏿 flexed biceps: dark skin tone",
    "\uD83D\uDCAA\uD83C\uDFFF",

    "1F9B5                                      ; fully-qualified     # 🦵 leg",
    "\uD83E\uDDB5",

    "1F9B5 1F3FB                                ; fully-qualified     # 🦵🏻 leg: light skin tone",
    "\uD83E\uDDB5\uD83C\uDFFB",

    "1F9B5 1F3FC                                ; fully-qualified     # 🦵🏼 leg: medium-light skin tone",
    "\uD83E\uDDB5\uD83C\uDFFC",

    "1F9B5 1F3FD                                ; fully-qualified     # 🦵🏽 leg: medium skin tone",
    "\uD83E\uDDB5\uD83C\uDFFD",

    "1F9B5 1F3FE                                ; fully-qualified     # 🦵🏾 leg: medium-dark skin tone",
    "\uD83E\uDDB5\uD83C\uDFFE",

    "1F9B5 1F3FF                                ; fully-qualified     # 🦵🏿 leg: dark skin tone",
    "\uD83E\uDDB5\uD83C\uDFFF",

    "1F9B6                                      ; fully-qualified     # 🦶 foot",
    "\uD83E\uDDB6",

    "1F9B6 1F3FB                                ; fully-qualified     # 🦶🏻 foot: light skin tone",
    "\uD83E\uDDB6\uD83C\uDFFB",

    "1F9B6 1F3FC                                ; fully-qualified     # 🦶🏼 foot: medium-light skin tone",
    "\uD83E\uDDB6\uD83C\uDFFC",

    "1F9B6 1F3FD                                ; fully-qualified     # 🦶🏽 foot: medium skin tone",
    "\uD83E\uDDB6\uD83C\uDFFD",

    "1F9B6 1F3FE                                ; fully-qualified     # 🦶🏾 foot: medium-dark skin tone",
    "\uD83E\uDDB6\uD83C\uDFFE",

    "1F9B6 1F3FF                                ; fully-qualified     # 🦶🏿 foot: dark skin tone",
    "\uD83E\uDDB6\uD83C\uDFFF",

    "1F448                                      ; fully-qualified     # 👈 backhand index pointing left",
    "\uD83D\uDC48",

    "1F448 1F3FB                                ; fully-qualified     # 👈🏻 backhand index pointing left: light skin tone",
    "\uD83D\uDC48\uD83C\uDFFB",

    "1F448 1F3FC                                ; fully-qualified     # 👈🏼 backhand index pointing left: medium-light skin tone",
    "\uD83D\uDC48\uD83C\uDFFC",

    "1F448 1F3FD                                ; fully-qualified     # 👈🏽 backhand index pointing left: medium skin tone",
    "\uD83D\uDC48\uD83C\uDFFD",

    "1F448 1F3FE                                ; fully-qualified     # 👈🏾 backhand index pointing left: medium-dark skin tone",
    "\uD83D\uDC48\uD83C\uDFFE",

    "1F448 1F3FF                                ; fully-qualified     # 👈🏿 backhand index pointing left: dark skin tone",
    "\uD83D\uDC48\uD83C\uDFFF",

    "1F449                                      ; fully-qualified     # 👉 backhand index pointing right",
    "\uD83D\uDC49",

    "1F449 1F3FB                                ; fully-qualified     # 👉🏻 backhand index pointing right: light skin tone",
    "\uD83D\uDC49\uD83C\uDFFB",

    "1F449 1F3FC                                ; fully-qualified     # 👉🏼 backhand index pointing right: medium-light skin tone",
    "\uD83D\uDC49\uD83C\uDFFC",

    "1F449 1F3FD                                ; fully-qualified     # 👉🏽 backhand index pointing right: medium skin tone",
    "\uD83D\uDC49\uD83C\uDFFD",

    "1F449 1F3FE                                ; fully-qualified     # 👉🏾 backhand index pointing right: medium-dark skin tone",
    "\uD83D\uDC49\uD83C\uDFFE",

    "1F449 1F3FF                                ; fully-qualified     # 👉🏿 backhand index pointing right: dark skin tone",
    "\uD83D\uDC49\uD83C\uDFFF",

    "261D FE0F                                  ; fully-qualified     # ☝️ index pointing up",
    "\u261D\uFE0F",

    "261D                                       ; non-fully-qualified # ☝ index pointing up",
    "\u261D",

    "261D 1F3FB                                 ; fully-qualified     # ☝🏻 index pointing up: light skin tone",
    "\u261D\uD83C\uDFFB",

    "261D 1F3FC                                 ; fully-qualified     # ☝🏼 index pointing up: medium-light skin tone",
    "\u261D\uD83C\uDFFC",

    "261D 1F3FD                                 ; fully-qualified     # ☝🏽 index pointing up: medium skin tone",
    "\u261D\uD83C\uDFFD",

    "261D 1F3FE                                 ; fully-qualified     # ☝🏾 index pointing up: medium-dark skin tone",
    "\u261D\uD83C\uDFFE",

    "261D 1F3FF                                 ; fully-qualified     # ☝🏿 index pointing up: dark skin tone",
    "\u261D\uD83C\uDFFF",

    "1F446                                      ; fully-qualified     # 👆 backhand index pointing up",
    "\uD83D\uDC46",

    "1F446 1F3FB                                ; fully-qualified     # 👆🏻 backhand index pointing up: light skin tone",
    "\uD83D\uDC46\uD83C\uDFFB",

    "1F446 1F3FC                                ; fully-qualified     # 👆🏼 backhand index pointing up: medium-light skin tone",
    "\uD83D\uDC46\uD83C\uDFFC",

    "1F446 1F3FD                                ; fully-qualified     # 👆🏽 backhand index pointing up: medium skin tone",
    "\uD83D\uDC46\uD83C\uDFFD",

    "1F446 1F3FE                                ; fully-qualified     # 👆🏾 backhand index pointing up: medium-dark skin tone",
    "\uD83D\uDC46\uD83C\uDFFE",

    "1F446 1F3FF                                ; fully-qualified     # 👆🏿 backhand index pointing up: dark skin tone",
    "\uD83D\uDC46\uD83C\uDFFF",

    "1F595                                      ; fully-qualified     # 🖕 middle finger",
    "\uD83D\uDD95",

    "1F595 1F3FB                                ; fully-qualified     # 🖕🏻 middle finger: light skin tone",
    "\uD83D\uDD95\uD83C\uDFFB",

    "1F595 1F3FC                                ; fully-qualified     # 🖕🏼 middle finger: medium-light skin tone",
    "\uD83D\uDD95\uD83C\uDFFC",

    "1F595 1F3FD                                ; fully-qualified     # 🖕🏽 middle finger: medium skin tone",
    "\uD83D\uDD95\uD83C\uDFFD",

    "1F595 1F3FE                                ; fully-qualified     # 🖕🏾 middle finger: medium-dark skin tone",
    "\uD83D\uDD95\uD83C\uDFFE",

    "1F595 1F3FF                                ; fully-qualified     # 🖕🏿 middle finger: dark skin tone",
    "\uD83D\uDD95\uD83C\uDFFF",

    "1F447                                      ; fully-qualified     # 👇 backhand index pointing down",
    "\uD83D\uDC47",

    "1F447 1F3FB                                ; fully-qualified     # 👇🏻 backhand index pointing down: light skin tone",
    "\uD83D\uDC47\uD83C\uDFFB",

    "1F447 1F3FC                                ; fully-qualified     # 👇🏼 backhand index pointing down: medium-light skin tone",
    "\uD83D\uDC47\uD83C\uDFFC",

    "1F447 1F3FD                                ; fully-qualified     # 👇🏽 backhand index pointing down: medium skin tone",
    "\uD83D\uDC47\uD83C\uDFFD",

    "1F447 1F3FE                                ; fully-qualified     # 👇🏾 backhand index pointing down: medium-dark skin tone",
    "\uD83D\uDC47\uD83C\uDFFE",

    "1F447 1F3FF                                ; fully-qualified     # 👇🏿 backhand index pointing down: dark skin tone",
    "\uD83D\uDC47\uD83C\uDFFF",

    "270C FE0F                                  ; fully-qualified     # ✌️ victory hand",
    "\u270C\uFE0F",

    "270C                                       ; non-fully-qualified # ✌ victory hand",
    "\u270C",

    "270C 1F3FB                                 ; fully-qualified     # ✌🏻 victory hand: light skin tone",
    "\u270C\uD83C\uDFFB",

    "270C 1F3FC                                 ; fully-qualified     # ✌🏼 victory hand: medium-light skin tone",
    "\u270C\uD83C\uDFFC",

    "270C 1F3FD                                 ; fully-qualified     # ✌🏽 victory hand: medium skin tone",
    "\u270C\uD83C\uDFFD",

    "270C 1F3FE                                 ; fully-qualified     # ✌🏾 victory hand: medium-dark skin tone",
    "\u270C\uD83C\uDFFE",

    "270C 1F3FF                                 ; fully-qualified     # ✌🏿 victory hand: dark skin tone",
    "\u270C\uD83C\uDFFF",

    "1F91E                                      ; fully-qualified     # 🤞 crossed fingers",
    "\uD83E\uDD1E",

    "1F91E 1F3FB                                ; fully-qualified     # 🤞🏻 crossed fingers: light skin tone",
    "\uD83E\uDD1E\uD83C\uDFFB",

    "1F91E 1F3FC                                ; fully-qualified     # 🤞🏼 crossed fingers: medium-light skin tone",
    "\uD83E\uDD1E\uD83C\uDFFC",

    "1F91E 1F3FD                                ; fully-qualified     # 🤞🏽 crossed fingers: medium skin tone",
    "\uD83E\uDD1E\uD83C\uDFFD",

    "1F91E 1F3FE                                ; fully-qualified     # 🤞🏾 crossed fingers: medium-dark skin tone",
    "\uD83E\uDD1E\uD83C\uDFFE",

    "1F91E 1F3FF                                ; fully-qualified     # 🤞🏿 crossed fingers: dark skin tone",
    "\uD83E\uDD1E\uD83C\uDFFF",

    "1F596                                      ; fully-qualified     # 🖖 vulcan salute",
    "\uD83D\uDD96",

    "1F596 1F3FB                                ; fully-qualified     # 🖖🏻 vulcan salute: light skin tone",
    "\uD83D\uDD96\uD83C\uDFFB",

    "1F596 1F3FC                                ; fully-qualified     # 🖖🏼 vulcan salute: medium-light skin tone",
    "\uD83D\uDD96\uD83C\uDFFC",

    "1F596 1F3FD                                ; fully-qualified     # 🖖🏽 vulcan salute: medium skin tone",
    "\uD83D\uDD96\uD83C\uDFFD",

    "1F596 1F3FE                                ; fully-qualified     # 🖖🏾 vulcan salute: medium-dark skin tone",
    "\uD83D\uDD96\uD83C\uDFFE",

    "1F596 1F3FF                                ; fully-qualified     # 🖖🏿 vulcan salute: dark skin tone",
    "\uD83D\uDD96\uD83C\uDFFF",

    "1F918                                      ; fully-qualified     # 🤘 sign of the horns",
    "\uD83E\uDD18",

    "1F918 1F3FB                                ; fully-qualified     # 🤘🏻 sign of the horns: light skin tone",
    "\uD83E\uDD18\uD83C\uDFFB",

    "1F918 1F3FC                                ; fully-qualified     # 🤘🏼 sign of the horns: medium-light skin tone",
    "\uD83E\uDD18\uD83C\uDFFC",

    "1F918 1F3FD                                ; fully-qualified     # 🤘🏽 sign of the horns: medium skin tone",
    "\uD83E\uDD18\uD83C\uDFFD",

    "1F918 1F3FE                                ; fully-qualified     # 🤘🏾 sign of the horns: medium-dark skin tone",
    "\uD83E\uDD18\uD83C\uDFFE",

    "1F918 1F3FF                                ; fully-qualified     # 🤘🏿 sign of the horns: dark skin tone",
    "\uD83E\uDD18\uD83C\uDFFF",

    "1F919                                      ; fully-qualified     # 🤙 call me hand",
    "\uD83E\uDD19",

    "1F919 1F3FB                                ; fully-qualified     # 🤙🏻 call me hand: light skin tone",
    "\uD83E\uDD19\uD83C\uDFFB",

    "1F919 1F3FC                                ; fully-qualified     # 🤙🏼 call me hand: medium-light skin tone",
    "\uD83E\uDD19\uD83C\uDFFC",

    "1F919 1F3FD                                ; fully-qualified     # 🤙🏽 call me hand: medium skin tone",
    "\uD83E\uDD19\uD83C\uDFFD",

    "1F919 1F3FE                                ; fully-qualified     # 🤙🏾 call me hand: medium-dark skin tone",
    "\uD83E\uDD19\uD83C\uDFFE",

    "1F919 1F3FF                                ; fully-qualified     # 🤙🏿 call me hand: dark skin tone",
    "\uD83E\uDD19\uD83C\uDFFF",

    "1F590 FE0F                                 ; fully-qualified     # 🖐️ hand with fingers splayed",
    "\uD83D\uDD90\uFE0F",

    "1F590                                      ; non-fully-qualified # 🖐 hand with fingers splayed",
    "\uD83D\uDD90",

    "1F590 1F3FB                                ; fully-qualified     # 🖐🏻 hand with fingers splayed: light skin tone",
    "\uD83D\uDD90\uD83C\uDFFB",

    "1F590 1F3FC                                ; fully-qualified     # 🖐🏼 hand with fingers splayed: medium-light skin tone",
    "\uD83D\uDD90\uD83C\uDFFC",

    "1F590 1F3FD                                ; fully-qualified     # 🖐🏽 hand with fingers splayed: medium skin tone",
    "\uD83D\uDD90\uD83C\uDFFD",

    "1F590 1F3FE                                ; fully-qualified     # 🖐🏾 hand with fingers splayed: medium-dark skin tone",
    "\uD83D\uDD90\uD83C\uDFFE",

    "1F590 1F3FF                                ; fully-qualified     # 🖐🏿 hand with fingers splayed: dark skin tone",
    "\uD83D\uDD90\uD83C\uDFFF",

    "270B                                       ; fully-qualified     # ✋ raised hand",
    "\u270B",

    "270B 1F3FB                                 ; fully-qualified     # ✋🏻 raised hand: light skin tone",
    "\u270B\uD83C\uDFFB",

    "270B 1F3FC                                 ; fully-qualified     # ✋🏼 raised hand: medium-light skin tone",
    "\u270B\uD83C\uDFFC",

    "270B 1F3FD                                 ; fully-qualified     # ✋🏽 raised hand: medium skin tone",
    "\u270B\uD83C\uDFFD",

    "270B 1F3FE                                 ; fully-qualified     # ✋🏾 raised hand: medium-dark skin tone",
    "\u270B\uD83C\uDFFE",

    "270B 1F3FF                                 ; fully-qualified     # ✋🏿 raised hand: dark skin tone",
    "\u270B\uD83C\uDFFF",

    "1F44C                                      ; fully-qualified     # 👌 OK hand",
    "\uD83D\uDC4C",

    "1F44C 1F3FB                                ; fully-qualified     # 👌🏻 OK hand: light skin tone",
    "\uD83D\uDC4C\uD83C\uDFFB",

    "1F44C 1F3FC                                ; fully-qualified     # 👌🏼 OK hand: medium-light skin tone",
    "\uD83D\uDC4C\uD83C\uDFFC",

    "1F44C 1F3FD                                ; fully-qualified     # 👌🏽 OK hand: medium skin tone",
    "\uD83D\uDC4C\uD83C\uDFFD",

    "1F44C 1F3FE                                ; fully-qualified     # 👌🏾 OK hand: medium-dark skin tone",
    "\uD83D\uDC4C\uD83C\uDFFE",

    "1F44C 1F3FF                                ; fully-qualified     # 👌🏿 OK hand: dark skin tone",
    "\uD83D\uDC4C\uD83C\uDFFF",

    "1F44D                                      ; fully-qualified     # 👍 thumbs up",
    "\uD83D\uDC4D",

    "1F44D 1F3FB                                ; fully-qualified     # 👍🏻 thumbs up: light skin tone",
    "\uD83D\uDC4D\uD83C\uDFFB",

    "1F44D 1F3FC                                ; fully-qualified     # 👍🏼 thumbs up: medium-light skin tone",
    "\uD83D\uDC4D\uD83C\uDFFC",

    "1F44D 1F3FD                                ; fully-qualified     # 👍🏽 thumbs up: medium skin tone",
    "\uD83D\uDC4D\uD83C\uDFFD",

    "1F44D 1F3FE                                ; fully-qualified     # 👍🏾 thumbs up: medium-dark skin tone",
    "\uD83D\uDC4D\uD83C\uDFFE",

    "1F44D 1F3FF                                ; fully-qualified     # 👍🏿 thumbs up: dark skin tone",
    "\uD83D\uDC4D\uD83C\uDFFF",

    "1F44E                                      ; fully-qualified     # 👎 thumbs down",
    "\uD83D\uDC4E",

    "1F44E 1F3FB                                ; fully-qualified     # 👎🏻 thumbs down: light skin tone",
    "\uD83D\uDC4E\uD83C\uDFFB",

    "1F44E 1F3FC                                ; fully-qualified     # 👎🏼 thumbs down: medium-light skin tone",
    "\uD83D\uDC4E\uD83C\uDFFC",

    "1F44E 1F3FD                                ; fully-qualified     # 👎🏽 thumbs down: medium skin tone",
    "\uD83D\uDC4E\uD83C\uDFFD",

    "1F44E 1F3FE                                ; fully-qualified     # 👎🏾 thumbs down: medium-dark skin tone",
    "\uD83D\uDC4E\uD83C\uDFFE",

    "1F44E 1F3FF                                ; fully-qualified     # 👎🏿 thumbs down: dark skin tone",
    "\uD83D\uDC4E\uD83C\uDFFF",

    "270A                                       ; fully-qualified     # ✊ raised fist",
    "\u270A",

    "270A 1F3FB                                 ; fully-qualified     # ✊🏻 raised fist: light skin tone",
    "\u270A\uD83C\uDFFB",

    "270A 1F3FC                                 ; fully-qualified     # ✊🏼 raised fist: medium-light skin tone",
    "\u270A\uD83C\uDFFC",

    "270A 1F3FD                                 ; fully-qualified     # ✊🏽 raised fist: medium skin tone",
    "\u270A\uD83C\uDFFD",

    "270A 1F3FE                                 ; fully-qualified     # ✊🏾 raised fist: medium-dark skin tone",
    "\u270A\uD83C\uDFFE",

    "270A 1F3FF                                 ; fully-qualified     # ✊🏿 raised fist: dark skin tone",
    "\u270A\uD83C\uDFFF",

    "1F44A                                      ; fully-qualified     # 👊 oncoming fist",
    "\uD83D\uDC4A",

    "1F44A 1F3FB                                ; fully-qualified     # 👊🏻 oncoming fist: light skin tone",
    "\uD83D\uDC4A\uD83C\uDFFB",

    "1F44A 1F3FC                                ; fully-qualified     # 👊🏼 oncoming fist: medium-light skin tone",
    "\uD83D\uDC4A\uD83C\uDFFC",

    "1F44A 1F3FD                                ; fully-qualified     # 👊🏽 oncoming fist: medium skin tone",
    "\uD83D\uDC4A\uD83C\uDFFD",

    "1F44A 1F3FE                                ; fully-qualified     # 👊🏾 oncoming fist: medium-dark skin tone",
    "\uD83D\uDC4A\uD83C\uDFFE",

    "1F44A 1F3FF                                ; fully-qualified     # 👊🏿 oncoming fist: dark skin tone",
    "\uD83D\uDC4A\uD83C\uDFFF",

    "1F91B                                      ; fully-qualified     # 🤛 left-facing fist",
    "\uD83E\uDD1B",

    "1F91B 1F3FB                                ; fully-qualified     # 🤛🏻 left-facing fist: light skin tone",
    "\uD83E\uDD1B\uD83C\uDFFB",

    "1F91B 1F3FC                                ; fully-qualified     # 🤛🏼 left-facing fist: medium-light skin tone",
    "\uD83E\uDD1B\uD83C\uDFFC",

    "1F91B 1F3FD                                ; fully-qualified     # 🤛🏽 left-facing fist: medium skin tone",
    "\uD83E\uDD1B\uD83C\uDFFD",

    "1F91B 1F3FE                                ; fully-qualified     # 🤛🏾 left-facing fist: medium-dark skin tone",
    "\uD83E\uDD1B\uD83C\uDFFE",

    "1F91B 1F3FF                                ; fully-qualified     # 🤛🏿 left-facing fist: dark skin tone",
    "\uD83E\uDD1B\uD83C\uDFFF",

    "1F91C                                      ; fully-qualified     # 🤜 right-facing fist",
    "\uD83E\uDD1C",

    "1F91C 1F3FB                                ; fully-qualified     # 🤜🏻 right-facing fist: light skin tone",
    "\uD83E\uDD1C\uD83C\uDFFB",

    "1F91C 1F3FC                                ; fully-qualified     # 🤜🏼 right-facing fist: medium-light skin tone",
    "\uD83E\uDD1C\uD83C\uDFFC",

    "1F91C 1F3FD                                ; fully-qualified     # 🤜🏽 right-facing fist: medium skin tone",
    "\uD83E\uDD1C\uD83C\uDFFD",

    "1F91C 1F3FE                                ; fully-qualified     # 🤜🏾 right-facing fist: medium-dark skin tone",
    "\uD83E\uDD1C\uD83C\uDFFE",

    "1F91C 1F3FF                                ; fully-qualified     # 🤜🏿 right-facing fist: dark skin tone",
    "\uD83E\uDD1C\uD83C\uDFFF",

    "1F91A                                      ; fully-qualified     # 🤚 raised back of hand",
    "\uD83E\uDD1A",

    "1F91A 1F3FB                                ; fully-qualified     # 🤚🏻 raised back of hand: light skin tone",
    "\uD83E\uDD1A\uD83C\uDFFB",

    "1F91A 1F3FC                                ; fully-qualified     # 🤚🏼 raised back of hand: medium-light skin tone",
    "\uD83E\uDD1A\uD83C\uDFFC",

    "1F91A 1F3FD                                ; fully-qualified     # 🤚🏽 raised back of hand: medium skin tone",
    "\uD83E\uDD1A\uD83C\uDFFD",

    "1F91A 1F3FE                                ; fully-qualified     # 🤚🏾 raised back of hand: medium-dark skin tone",
    "\uD83E\uDD1A\uD83C\uDFFE",

    "1F91A 1F3FF                                ; fully-qualified     # 🤚🏿 raised back of hand: dark skin tone",
    "\uD83E\uDD1A\uD83C\uDFFF",

    "1F44B                                      ; fully-qualified     # 👋 waving hand",
    "\uD83D\uDC4B",

    "1F44B 1F3FB                                ; fully-qualified     # 👋🏻 waving hand: light skin tone",
    "\uD83D\uDC4B\uD83C\uDFFB",

    "1F44B 1F3FC                                ; fully-qualified     # 👋🏼 waving hand: medium-light skin tone",
    "\uD83D\uDC4B\uD83C\uDFFC",

    "1F44B 1F3FD                                ; fully-qualified     # 👋🏽 waving hand: medium skin tone",
    "\uD83D\uDC4B\uD83C\uDFFD",

    "1F44B 1F3FE                                ; fully-qualified     # 👋🏾 waving hand: medium-dark skin tone",
    "\uD83D\uDC4B\uD83C\uDFFE",

    "1F44B 1F3FF                                ; fully-qualified     # 👋🏿 waving hand: dark skin tone",
    "\uD83D\uDC4B\uD83C\uDFFF",

    "1F91F                                      ; fully-qualified     # 🤟 love-you gesture",
    "\uD83E\uDD1F",

    "1F91F 1F3FB                                ; fully-qualified     # 🤟🏻 love-you gesture: light skin tone",
    "\uD83E\uDD1F\uD83C\uDFFB",

    "1F91F 1F3FC                                ; fully-qualified     # 🤟🏼 love-you gesture: medium-light skin tone",
    "\uD83E\uDD1F\uD83C\uDFFC",

    "1F91F 1F3FD                                ; fully-qualified     # 🤟🏽 love-you gesture: medium skin tone",
    "\uD83E\uDD1F\uD83C\uDFFD",

    "1F91F 1F3FE                                ; fully-qualified     # 🤟🏾 love-you gesture: medium-dark skin tone",
    "\uD83E\uDD1F\uD83C\uDFFE",

    "1F91F 1F3FF                                ; fully-qualified     # 🤟🏿 love-you gesture: dark skin tone",
    "\uD83E\uDD1F\uD83C\uDFFF",

    "270D FE0F                                  ; fully-qualified     # ✍️ writing hand",
    "\u270D\uFE0F",

    "270D                                       ; non-fully-qualified # ✍ writing hand",
    "\u270D",

    "270D 1F3FB                                 ; fully-qualified     # ✍🏻 writing hand: light skin tone",
    "\u270D\uD83C\uDFFB",

    "270D 1F3FC                                 ; fully-qualified     # ✍🏼 writing hand: medium-light skin tone",
    "\u270D\uD83C\uDFFC",

    "270D 1F3FD                                 ; fully-qualified     # ✍🏽 writing hand: medium skin tone",
    "\u270D\uD83C\uDFFD",

    "270D 1F3FE                                 ; fully-qualified     # ✍🏾 writing hand: medium-dark skin tone",
    "\u270D\uD83C\uDFFE",

    "270D 1F3FF                                 ; fully-qualified     # ✍🏿 writing hand: dark skin tone",
    "\u270D\uD83C\uDFFF",

    "1F44F                                      ; fully-qualified     # 👏 clapping hands",
    "\uD83D\uDC4F",

    "1F44F 1F3FB                                ; fully-qualified     # 👏🏻 clapping hands: light skin tone",
    "\uD83D\uDC4F\uD83C\uDFFB",

    "1F44F 1F3FC                                ; fully-qualified     # 👏🏼 clapping hands: medium-light skin tone",
    "\uD83D\uDC4F\uD83C\uDFFC",

    "1F44F 1F3FD                                ; fully-qualified     # 👏🏽 clapping hands: medium skin tone",
    "\uD83D\uDC4F\uD83C\uDFFD",

    "1F44F 1F3FE                                ; fully-qualified     # 👏🏾 clapping hands: medium-dark skin tone",
    "\uD83D\uDC4F\uD83C\uDFFE",

    "1F44F 1F3FF                                ; fully-qualified     # 👏🏿 clapping hands: dark skin tone",
    "\uD83D\uDC4F\uD83C\uDFFF",

    "1F450                                      ; fully-qualified     # 👐 open hands",
    "\uD83D\uDC50",

    "1F450 1F3FB                                ; fully-qualified     # 👐🏻 open hands: light skin tone",
    "\uD83D\uDC50\uD83C\uDFFB",

    "1F450 1F3FC                                ; fully-qualified     # 👐🏼 open hands: medium-light skin tone",
    "\uD83D\uDC50\uD83C\uDFFC",

    "1F450 1F3FD                                ; fully-qualified     # 👐🏽 open hands: medium skin tone",
    "\uD83D\uDC50\uD83C\uDFFD",

    "1F450 1F3FE                                ; fully-qualified     # 👐🏾 open hands: medium-dark skin tone",
    "\uD83D\uDC50\uD83C\uDFFE",

    "1F450 1F3FF                                ; fully-qualified     # 👐🏿 open hands: dark skin tone",
    "\uD83D\uDC50\uD83C\uDFFF",

    "1F64C                                      ; fully-qualified     # 🙌 raising hands",
    "\uD83D\uDE4C",

    "1F64C 1F3FB                                ; fully-qualified     # 🙌🏻 raising hands: light skin tone",
    "\uD83D\uDE4C\uD83C\uDFFB",

    "1F64C 1F3FC                                ; fully-qualified     # 🙌🏼 raising hands: medium-light skin tone",
    "\uD83D\uDE4C\uD83C\uDFFC",

    "1F64C 1F3FD                                ; fully-qualified     # 🙌🏽 raising hands: medium skin tone",
    "\uD83D\uDE4C\uD83C\uDFFD",

    "1F64C 1F3FE                                ; fully-qualified     # 🙌🏾 raising hands: medium-dark skin tone",
    "\uD83D\uDE4C\uD83C\uDFFE",

    "1F64C 1F3FF                                ; fully-qualified     # 🙌🏿 raising hands: dark skin tone",
    "\uD83D\uDE4C\uD83C\uDFFF",

    "1F932                                      ; fully-qualified     # 🤲 palms up together",
    "\uD83E\uDD32",

    "1F932 1F3FB                                ; fully-qualified     # 🤲🏻 palms up together: light skin tone",
    "\uD83E\uDD32\uD83C\uDFFB",

    "1F932 1F3FC                                ; fully-qualified     # 🤲🏼 palms up together: medium-light skin tone",
    "\uD83E\uDD32\uD83C\uDFFC",

    "1F932 1F3FD                                ; fully-qualified     # 🤲🏽 palms up together: medium skin tone",
    "\uD83E\uDD32\uD83C\uDFFD",

    "1F932 1F3FE                                ; fully-qualified     # 🤲🏾 palms up together: medium-dark skin tone",
    "\uD83E\uDD32\uD83C\uDFFE",

    "1F932 1F3FF                                ; fully-qualified     # 🤲🏿 palms up together: dark skin tone",
    "\uD83E\uDD32\uD83C\uDFFF",

    "1F64F                                      ; fully-qualified     # 🙏 folded hands",
    "\uD83D\uDE4F",

    "1F64F 1F3FB                                ; fully-qualified     # 🙏🏻 folded hands: light skin tone",
    "\uD83D\uDE4F\uD83C\uDFFB",

    "1F64F 1F3FC                                ; fully-qualified     # 🙏🏼 folded hands: medium-light skin tone",
    "\uD83D\uDE4F\uD83C\uDFFC",

    "1F64F 1F3FD                                ; fully-qualified     # 🙏🏽 folded hands: medium skin tone",
    "\uD83D\uDE4F\uD83C\uDFFD",

    "1F64F 1F3FE                                ; fully-qualified     # 🙏🏾 folded hands: medium-dark skin tone",
    "\uD83D\uDE4F\uD83C\uDFFE",

    "1F64F 1F3FF                                ; fully-qualified     # 🙏🏿 folded hands: dark skin tone",
    "\uD83D\uDE4F\uD83C\uDFFF",

    "1F91D                                      ; fully-qualified     # 🤝 handshake",
    "\uD83E\uDD1D",

    "1F485                                      ; fully-qualified     # 💅 nail polish",
    "\uD83D\uDC85",

    "1F485 1F3FB                                ; fully-qualified     # 💅🏻 nail polish: light skin tone",
    "\uD83D\uDC85\uD83C\uDFFB",

    "1F485 1F3FC                                ; fully-qualified     # 💅🏼 nail polish: medium-light skin tone",
    "\uD83D\uDC85\uD83C\uDFFC",

    "1F485 1F3FD                                ; fully-qualified     # 💅🏽 nail polish: medium skin tone",
    "\uD83D\uDC85\uD83C\uDFFD",

    "1F485 1F3FE                                ; fully-qualified     # 💅🏾 nail polish: medium-dark skin tone",
    "\uD83D\uDC85\uD83C\uDFFE",

    "1F485 1F3FF                                ; fully-qualified     # 💅🏿 nail polish: dark skin tone",
    "\uD83D\uDC85\uD83C\uDFFF",

    "1F442                                      ; fully-qualified     # 👂 ear",
    "\uD83D\uDC42",

    "1F442 1F3FB                                ; fully-qualified     # 👂🏻 ear: light skin tone",
    "\uD83D\uDC42\uD83C\uDFFB",

    "1F442 1F3FC                                ; fully-qualified     # 👂🏼 ear: medium-light skin tone",
    "\uD83D\uDC42\uD83C\uDFFC",

    "1F442 1F3FD                                ; fully-qualified     # 👂🏽 ear: medium skin tone",
    "\uD83D\uDC42\uD83C\uDFFD",

    "1F442 1F3FE                                ; fully-qualified     # 👂🏾 ear: medium-dark skin tone",
    "\uD83D\uDC42\uD83C\uDFFE",

    "1F442 1F3FF                                ; fully-qualified     # 👂🏿 ear: dark skin tone",
    "\uD83D\uDC42\uD83C\uDFFF",

    "1F443                                      ; fully-qualified     # 👃 nose",
    "\uD83D\uDC43",

    "1F443 1F3FB                                ; fully-qualified     # 👃🏻 nose: light skin tone",
    "\uD83D\uDC43\uD83C\uDFFB",

    "1F443 1F3FC                                ; fully-qualified     # 👃🏼 nose: medium-light skin tone",
    "\uD83D\uDC43\uD83C\uDFFC",

    "1F443 1F3FD                                ; fully-qualified     # 👃🏽 nose: medium skin tone",
    "\uD83D\uDC43\uD83C\uDFFD",

    "1F443 1F3FE                                ; fully-qualified     # 👃🏾 nose: medium-dark skin tone",
    "\uD83D\uDC43\uD83C\uDFFE",

    "1F443 1F3FF                                ; fully-qualified     # 👃🏿 nose: dark skin tone",
    "\uD83D\uDC43\uD83C\uDFFF",

    "1F9B0                                      ; fully-qualified     # 🦰 red-haired",
    "\uD83E\uDDB0",

    "1F9B1                                      ; fully-qualified     # 🦱 curly-haired",
    "\uD83E\uDDB1",

    "1F9B2                                      ; fully-qualified     # 🦲 bald",
    "\uD83E\uDDB2",

    "1F9B3                                      ; fully-qualified     # 🦳 white-haired",
    "\uD83E\uDDB3",

    "1F463                                      ; fully-qualified     # 👣 footprints",
    "\uD83D\uDC63",

    "1F440                                      ; fully-qualified     # 👀 eyes",
    "\uD83D\uDC40",

    "1F441 FE0F                                 ; fully-qualified     # 👁️ eye",
    "\uD83D\uDC41\uFE0F",

    "1F441                                      ; non-fully-qualified # 👁 eye",
    "\uD83D\uDC41",

    "1F441 FE0F 200D 1F5E8 FE0F                 ; fully-qualified     # 👁️‍🗨️ eye in speech bubble",
    "\uD83D\uDC41\uFE0F\u200D\uD83D\uDDE8\uFE0F",

    "1F441 200D 1F5E8 FE0F                      ; non-fully-qualified # 👁‍🗨️ eye in speech bubble",
    "\uD83D\uDC41\u200D\uD83D\uDDE8\uFE0F",

    "1F441 FE0F 200D 1F5E8                      ; non-fully-qualified # 👁️‍🗨 eye in speech bubble",
    "\uD83D\uDC41\uFE0F\u200D\uD83D\uDDE8",

    "1F441 200D 1F5E8                           ; non-fully-qualified # 👁‍🗨 eye in speech bubble",
    "\uD83D\uDC41\u200D\uD83D\uDDE8",

    "1F9E0                                      ; fully-qualified     # 🧠 brain",
    "\uD83E\uDDE0",

    "1F9B4                                      ; fully-qualified     # 🦴 bone",
    "\uD83E\uDDB4",

    "1F9B7                                      ; fully-qualified     # 🦷 tooth",
    "\uD83E\uDDB7",

    "1F445                                      ; fully-qualified     # 👅 tongue",
    "\uD83D\uDC45",

    "1F444                                      ; fully-qualified     # 👄 mouth",
    "\uD83D\uDC44",

    "1F48B                                      ; fully-qualified     # 💋 kiss mark",
    "\uD83D\uDC8B",

    "1F498                                      ; fully-qualified     # 💘 heart with arrow",
    "\uD83D\uDC98",

    "2764 FE0F                                  ; fully-qualified     # ❤️ red heart",
    "\u2764\uFE0F",

    "2764                                       ; non-fully-qualified # ❤ red heart",
    "\u2764",

    "1F493                                      ; fully-qualified     # 💓 beating heart",
    "\uD83D\uDC93",

    "1F494                                      ; fully-qualified     # 💔 broken heart",
    "\uD83D\uDC94",

    "1F495                                      ; fully-qualified     # 💕 two hearts",
    "\uD83D\uDC95",

    "1F496                                      ; fully-qualified     # 💖 sparkling heart",
    "\uD83D\uDC96",

    "1F497                                      ; fully-qualified     # 💗 growing heart",
    "\uD83D\uDC97",

    "1F499                                      ; fully-qualified     # 💙 blue heart",
    "\uD83D\uDC99",

    "1F49A                                      ; fully-qualified     # 💚 green heart",
    "\uD83D\uDC9A",

    "1F49B                                      ; fully-qualified     # 💛 yellow heart",
    "\uD83D\uDC9B",

    "1F9E1                                      ; fully-qualified     # 🧡 orange heart",
    "\uD83E\uDDE1",

    "1F49C                                      ; fully-qualified     # 💜 purple heart",
    "\uD83D\uDC9C",

    "1F5A4                                      ; fully-qualified     # 🖤 black heart",
    "\uD83D\uDDA4",

    "1F49D                                      ; fully-qualified     # 💝 heart with ribbon",
    "\uD83D\uDC9D",

    "1F49E                                      ; fully-qualified     # 💞 revolving hearts",
    "\uD83D\uDC9E",

    "1F49F                                      ; fully-qualified     # 💟 heart decoration",
    "\uD83D\uDC9F",

    "2763 FE0F                                  ; fully-qualified     # ❣️ heavy heart exclamation",
    "\u2763\uFE0F",

    "2763                                       ; non-fully-qualified # ❣ heavy heart exclamation",
    "\u2763",

    "1F48C                                      ; fully-qualified     # 💌 love letter",
    "\uD83D\uDC8C",

    "1F4A4                                      ; fully-qualified     # 💤 zzz",
    "\uD83D\uDCA4",

    "1F4A2                                      ; fully-qualified     # 💢 anger symbol",
    "\uD83D\uDCA2",

    "1F4A3                                      ; fully-qualified     # 💣 bomb",
    "\uD83D\uDCA3",

    "1F4A5                                      ; fully-qualified     # 💥 collision",
    "\uD83D\uDCA5",

    "1F4A6                                      ; fully-qualified     # 💦 sweat droplets",
    "\uD83D\uDCA6",

    "1F4A8                                      ; fully-qualified     # 💨 dashing away",
    "\uD83D\uDCA8",

    "1F4AB                                      ; fully-qualified     # 💫 dizzy",
    "\uD83D\uDCAB",

    "1F4AC                                      ; fully-qualified     # 💬 speech balloon",
    "\uD83D\uDCAC",

    "1F5E8 FE0F                                 ; fully-qualified     # 🗨️ left speech bubble",
    "\uD83D\uDDE8\uFE0F",

    "1F5E8                                      ; non-fully-qualified # 🗨 left speech bubble",
    "\uD83D\uDDE8",

    "1F5EF FE0F                                 ; fully-qualified     # 🗯️ right anger bubble",
    "\uD83D\uDDEF\uFE0F",

    "1F5EF                                      ; non-fully-qualified # 🗯 right anger bubble",
    "\uD83D\uDDEF",

    "1F4AD                                      ; fully-qualified     # 💭 thought balloon",
    "\uD83D\uDCAD",

    "1F573 FE0F                                 ; fully-qualified     # 🕳️ hole",
    "\uD83D\uDD73\uFE0F",

    "1F573                                      ; non-fully-qualified # 🕳 hole",
    "\uD83D\uDD73",

    "1F453                                      ; fully-qualified     # 👓 glasses",
    "\uD83D\uDC53",

    "1F576 FE0F                                 ; fully-qualified     # 🕶️ sunglasses",
    "\uD83D\uDD76\uFE0F",

    "1F576                                      ; non-fully-qualified # 🕶 sunglasses",
    "\uD83D\uDD76",

    "1F97D                                      ; fully-qualified     # 🥽 goggles",
    "\uD83E\uDD7D",

    "1F97C                                      ; fully-qualified     # 🥼 lab coat",
    "\uD83E\uDD7C",

    "1F454                                      ; fully-qualified     # 👔 necktie",
    "\uD83D\uDC54",

    "1F455                                      ; fully-qualified     # 👕 t-shirt",
    "\uD83D\uDC55",

    "1F456                                      ; fully-qualified     # 👖 jeans",
    "\uD83D\uDC56",

    "1F9E3                                      ; fully-qualified     # 🧣 scarf",
    "\uD83E\uDDE3",

    "1F9E4                                      ; fully-qualified     # 🧤 gloves",
    "\uD83E\uDDE4",

    "1F9E5                                      ; fully-qualified     # 🧥 coat",
    "\uD83E\uDDE5",

    "1F9E6                                      ; fully-qualified     # 🧦 socks",
    "\uD83E\uDDE6",

    "1F457                                      ; fully-qualified     # 👗 dress",
    "\uD83D\uDC57",

    "1F458                                      ; fully-qualified     # 👘 kimono",
    "\uD83D\uDC58",

    "1F459                                      ; fully-qualified     # 👙 bikini",
    "\uD83D\uDC59",

    "1F45A                                      ; fully-qualified     # 👚 woman’s clothes",
    "\uD83D\uDC5A",

    "1F45B                                      ; fully-qualified     # 👛 purse",
    "\uD83D\uDC5B",

    "1F45C                                      ; fully-qualified     # 👜 handbag",
    "\uD83D\uDC5C",

    "1F45D                                      ; fully-qualified     # 👝 clutch bag",
    "\uD83D\uDC5D",

    "1F6CD FE0F                                 ; fully-qualified     # 🛍️ shopping bags",
    "\uD83D\uDECD\uFE0F",

    "1F6CD                                      ; non-fully-qualified # 🛍 shopping bags",
    "\uD83D\uDECD",

    "1F392                                      ; fully-qualified     # 🎒 school backpack",
    "\uD83C\uDF92",

    "1F45E                                      ; fully-qualified     # 👞 man’s shoe",
    "\uD83D\uDC5E",

    "1F45F                                      ; fully-qualified     # 👟 running shoe",
    "\uD83D\uDC5F",

    "1F97E                                      ; fully-qualified     # 🥾 hiking boot",
    "\uD83E\uDD7E",

    "1F97F                                      ; fully-qualified     # 🥿 woman’s flat shoe",
    "\uD83E\uDD7F",

    "1F460                                      ; fully-qualified     # 👠 high-heeled shoe",
    "\uD83D\uDC60",

    "1F461                                      ; fully-qualified     # 👡 woman’s sandal",
    "\uD83D\uDC61",

    "1F462                                      ; fully-qualified     # 👢 woman’s boot",
    "\uD83D\uDC62",

    "1F451                                      ; fully-qualified     # 👑 crown",
    "\uD83D\uDC51",

    "1F452                                      ; fully-qualified     # 👒 woman’s hat",
    "\uD83D\uDC52",

    "1F3A9                                      ; fully-qualified     # 🎩 top hat",
    "\uD83C\uDFA9",

    "1F393                                      ; fully-qualified     # 🎓 graduation cap",
    "\uD83C\uDF93",

    "1F9E2                                      ; fully-qualified     # 🧢 billed cap",
    "\uD83E\uDDE2",

    "26D1 FE0F                                  ; fully-qualified     # ⛑️ rescue worker’s helmet",
    "\u26D1\uFE0F",

    "26D1                                       ; non-fully-qualified # ⛑ rescue worker’s helmet",
    "\u26D1",

    "1F4FF                                      ; fully-qualified     # 📿 prayer beads",
    "\uD83D\uDCFF",

    "1F484                                      ; fully-qualified     # 💄 lipstick",
    "\uD83D\uDC84",

    "1F48D                                      ; fully-qualified     # 💍 ring",
    "\uD83D\uDC8D",

    "1F48E                                      ; fully-qualified     # 💎 gem stone",
    "\uD83D\uDC8E",

    "1F435                                      ; fully-qualified     # 🐵 monkey face",
    "\uD83D\uDC35",

    "1F412                                      ; fully-qualified     # 🐒 monkey",
    "\uD83D\uDC12",

    "1F98D                                      ; fully-qualified     # 🦍 gorilla",
    "\uD83E\uDD8D",

    "1F436                                      ; fully-qualified     # 🐶 dog face",
    "\uD83D\uDC36",

    "1F415                                      ; fully-qualified     # 🐕 dog",
    "\uD83D\uDC15",

    "1F429                                      ; fully-qualified     # 🐩 poodle",
    "\uD83D\uDC29",

    "1F43A                                      ; fully-qualified     # 🐺 wolf face",
    "\uD83D\uDC3A",

    "1F98A                                      ; fully-qualified     # 🦊 fox face",
    "\uD83E\uDD8A",

    "1F99D                                      ; fully-qualified     # 🦝 raccoon",
    "\uD83E\uDD9D",

    "1F431                                      ; fully-qualified     # 🐱 cat face",
    "\uD83D\uDC31",

    "1F408                                      ; fully-qualified     # 🐈 cat",
    "\uD83D\uDC08",

    "1F981                                      ; fully-qualified     # 🦁 lion face",
    "\uD83E\uDD81",

    "1F42F                                      ; fully-qualified     # 🐯 tiger face",
    "\uD83D\uDC2F",

    "1F405                                      ; fully-qualified     # 🐅 tiger",
    "\uD83D\uDC05",

    "1F406                                      ; fully-qualified     # 🐆 leopard",
    "\uD83D\uDC06",

    "1F434                                      ; fully-qualified     # 🐴 horse face",
    "\uD83D\uDC34",

    "1F40E                                      ; fully-qualified     # 🐎 horse",
    "\uD83D\uDC0E",

    "1F984                                      ; fully-qualified     # 🦄 unicorn face",
    "\uD83E\uDD84",

    "1F993                                      ; fully-qualified     # 🦓 zebra",
    "\uD83E\uDD93",

    "1F98C                                      ; fully-qualified     # 🦌 deer",
    "\uD83E\uDD8C",

    "1F42E                                      ; fully-qualified     # 🐮 cow face",
    "\uD83D\uDC2E",

    "1F402                                      ; fully-qualified     # 🐂 ox",
    "\uD83D\uDC02",

    "1F403                                      ; fully-qualified     # 🐃 water buffalo",
    "\uD83D\uDC03",

    "1F404                                      ; fully-qualified     # 🐄 cow",
    "\uD83D\uDC04",

    "1F437                                      ; fully-qualified     # 🐷 pig face",
    "\uD83D\uDC37",

    "1F416                                      ; fully-qualified     # 🐖 pig",
    "\uD83D\uDC16",

    "1F417                                      ; fully-qualified     # 🐗 boar",
    "\uD83D\uDC17",

    "1F43D                                      ; fully-qualified     # 🐽 pig nose",
    "\uD83D\uDC3D",

    "1F40F                                      ; fully-qualified     # 🐏 ram",
    "\uD83D\uDC0F",

    "1F411                                      ; fully-qualified     # 🐑 ewe",
    "\uD83D\uDC11",

    "1F410                                      ; fully-qualified     # 🐐 goat",
    "\uD83D\uDC10",

    "1F42A                                      ; fully-qualified     # 🐪 camel",
    "\uD83D\uDC2A",

    "1F42B                                      ; fully-qualified     # 🐫 two-hump camel",
    "\uD83D\uDC2B",

    "1F999                                      ; fully-qualified     # 🦙 llama",
    "\uD83E\uDD99",

    "1F992                                      ; fully-qualified     # 🦒 giraffe",
    "\uD83E\uDD92",

    "1F418                                      ; fully-qualified     # 🐘 elephant",
    "\uD83D\uDC18",

    "1F98F                                      ; fully-qualified     # 🦏 rhinoceros",
    "\uD83E\uDD8F",

    "1F99B                                      ; fully-qualified     # 🦛 hippopotamus",
    "\uD83E\uDD9B",

    "1F42D                                      ; fully-qualified     # 🐭 mouse face",
    "\uD83D\uDC2D",

    "1F401                                      ; fully-qualified     # 🐁 mouse",
    "\uD83D\uDC01",

    "1F400                                      ; fully-qualified     # 🐀 rat",
    "\uD83D\uDC00",

    "1F439                                      ; fully-qualified     # 🐹 hamster face",
    "\uD83D\uDC39",

    "1F430                                      ; fully-qualified     # 🐰 rabbit face",
    "\uD83D\uDC30",

    "1F407                                      ; fully-qualified     # 🐇 rabbit",
    "\uD83D\uDC07",

    "1F43F FE0F                                 ; fully-qualified     # 🐿️ chipmunk",
    "\uD83D\uDC3F\uFE0F",

    "1F43F                                      ; non-fully-qualified # 🐿 chipmunk",
    "\uD83D\uDC3F",

    "1F994                                      ; fully-qualified     # 🦔 hedgehog",
    "\uD83E\uDD94",

    "1F987                                      ; fully-qualified     # 🦇 bat",
    "\uD83E\uDD87",

    "1F43B                                      ; fully-qualified     # 🐻 bear face",
    "\uD83D\uDC3B",

    "1F428                                      ; fully-qualified     # 🐨 koala",
    "\uD83D\uDC28",

    "1F43C                                      ; fully-qualified     # 🐼 panda face",
    "\uD83D\uDC3C",

    "1F998                                      ; fully-qualified     # 🦘 kangaroo",
    "\uD83E\uDD98",

    "1F9A1                                      ; fully-qualified     # 🦡 badger",
    "\uD83E\uDDA1",

    "1F43E                                      ; fully-qualified     # 🐾 paw prints",
    "\uD83D\uDC3E",

    "1F983                                      ; fully-qualified     # 🦃 turkey",
    "\uD83E\uDD83",

    "1F414                                      ; fully-qualified     # 🐔 chicken",
    "\uD83D\uDC14",

    "1F413                                      ; fully-qualified     # 🐓 rooster",
    "\uD83D\uDC13",

    "1F423                                      ; fully-qualified     # 🐣 hatching chick",
    "\uD83D\uDC23",

    "1F424                                      ; fully-qualified     # 🐤 baby chick",
    "\uD83D\uDC24",

    "1F425                                      ; fully-qualified     # 🐥 front-facing baby chick",
    "\uD83D\uDC25",

    "1F426                                      ; fully-qualified     # 🐦 bird",
    "\uD83D\uDC26",

    "1F427                                      ; fully-qualified     # 🐧 penguin",
    "\uD83D\uDC27",

    "1F54A FE0F                                 ; fully-qualified     # 🕊️ dove",
    "\uD83D\uDD4A\uFE0F",

    "1F54A                                      ; non-fully-qualified # 🕊 dove",
    "\uD83D\uDD4A",

    "1F985                                      ; fully-qualified     # 🦅 eagle",
    "\uD83E\uDD85",

    "1F986                                      ; fully-qualified     # 🦆 duck",
    "\uD83E\uDD86",

    "1F9A2                                      ; fully-qualified     # 🦢 swan",
    "\uD83E\uDDA2",

    "1F989                                      ; fully-qualified     # 🦉 owl",
    "\uD83E\uDD89",

    "1F99A                                      ; fully-qualified     # 🦚 peacock",
    "\uD83E\uDD9A",

    "1F99C                                      ; fully-qualified     # 🦜 parrot",
    "\uD83E\uDD9C",

    "1F438                                      ; fully-qualified     # 🐸 frog face",
    "\uD83D\uDC38",

    "1F40A                                      ; fully-qualified     # 🐊 crocodile",
    "\uD83D\uDC0A",

    "1F422                                      ; fully-qualified     # 🐢 turtle",
    "\uD83D\uDC22",

    "1F98E                                      ; fully-qualified     # 🦎 lizard",
    "\uD83E\uDD8E",

    "1F40D                                      ; fully-qualified     # 🐍 snake",
    "\uD83D\uDC0D",

    "1F432                                      ; fully-qualified     # 🐲 dragon face",
    "\uD83D\uDC32",

    "1F409                                      ; fully-qualified     # 🐉 dragon",
    "\uD83D\uDC09",

    "1F995                                      ; fully-qualified     # 🦕 sauropod",
    "\uD83E\uDD95",

    "1F996                                      ; fully-qualified     # 🦖 T-Rex",
    "\uD83E\uDD96",

    "1F433                                      ; fully-qualified     # 🐳 spouting whale",
    "\uD83D\uDC33",

    "1F40B                                      ; fully-qualified     # 🐋 whale",
    "\uD83D\uDC0B",

    "1F42C                                      ; fully-qualified     # 🐬 dolphin",
    "\uD83D\uDC2C",

    "1F41F                                      ; fully-qualified     # 🐟 fish",
    "\uD83D\uDC1F",

    "1F420                                      ; fully-qualified     # 🐠 tropical fish",
    "\uD83D\uDC20",

    "1F421                                      ; fully-qualified     # 🐡 blowfish",
    "\uD83D\uDC21",

    "1F988                                      ; fully-qualified     # 🦈 shark",
    "\uD83E\uDD88",

    "1F419                                      ; fully-qualified     # 🐙 octopus",
    "\uD83D\uDC19",

    "1F41A                                      ; fully-qualified     # 🐚 spiral shell",
    "\uD83D\uDC1A",

    "1F980                                      ; fully-qualified     # 🦀 crab",
    "\uD83E\uDD80",

    "1F99E                                      ; fully-qualified     # 🦞 lobster",
    "\uD83E\uDD9E",

    "1F990                                      ; fully-qualified     # 🦐 shrimp",
    "\uD83E\uDD90",

    "1F991                                      ; fully-qualified     # 🦑 squid",
    "\uD83E\uDD91",

    "1F40C                                      ; fully-qualified     # 🐌 snail",
    "\uD83D\uDC0C",

    "1F98B                                      ; fully-qualified     # 🦋 butterfly",
    "\uD83E\uDD8B",

    "1F41B                                      ; fully-qualified     # 🐛 bug",
    "\uD83D\uDC1B",

    "1F41C                                      ; fully-qualified     # 🐜 ant",
    "\uD83D\uDC1C",

    "1F41D                                      ; fully-qualified     # 🐝 honeybee",
    "\uD83D\uDC1D",

    "1F41E                                      ; fully-qualified     # 🐞 lady beetle",
    "\uD83D\uDC1E",

    "1F997                                      ; fully-qualified     # 🦗 cricket",
    "\uD83E\uDD97",

    "1F577 FE0F                                 ; fully-qualified     # 🕷️ spider",
    "\uD83D\uDD77\uFE0F",

    "1F577                                      ; non-fully-qualified # 🕷 spider",
    "\uD83D\uDD77",

    "1F578 FE0F                                 ; fully-qualified     # 🕸️ spider web",
    "\uD83D\uDD78\uFE0F",

    "1F578                                      ; non-fully-qualified # 🕸 spider web",
    "\uD83D\uDD78",

    "1F982                                      ; fully-qualified     # 🦂 scorpion",
    "\uD83E\uDD82",

    "1F99F                                      ; fully-qualified     # 🦟 mosquito",
    "\uD83E\uDD9F",

    "1F9A0                                      ; fully-qualified     # 🦠 microbe",
    "\uD83E\uDDA0",

    "1F490                                      ; fully-qualified     # 💐 bouquet",
    "\uD83D\uDC90",

    "1F338                                      ; fully-qualified     # 🌸 cherry blossom",
    "\uD83C\uDF38",

    "1F4AE                                      ; fully-qualified     # 💮 white flower",
    "\uD83D\uDCAE",

    "1F3F5 FE0F                                 ; fully-qualified     # 🏵️ rosette",
    "\uD83C\uDFF5\uFE0F",

    "1F3F5                                      ; non-fully-qualified # 🏵 rosette",
    "\uD83C\uDFF5",

    "1F339                                      ; fully-qualified     # 🌹 rose",
    "\uD83C\uDF39",

    "1F940                                      ; fully-qualified     # 🥀 wilted flower",
    "\uD83E\uDD40",

    "1F33A                                      ; fully-qualified     # 🌺 hibiscus",
    "\uD83C\uDF3A",

    "1F33B                                      ; fully-qualified     # 🌻 sunflower",
    "\uD83C\uDF3B",

    "1F33C                                      ; fully-qualified     # 🌼 blossom",
    "\uD83C\uDF3C",

    "1F337                                      ; fully-qualified     # 🌷 tulip",
    "\uD83C\uDF37",

    "1F331                                      ; fully-qualified     # 🌱 seedling",
    "\uD83C\uDF31",

    "1F332                                      ; fully-qualified     # 🌲 evergreen tree",
    "\uD83C\uDF32",

    "1F333                                      ; fully-qualified     # 🌳 deciduous tree",
    "\uD83C\uDF33",

    "1F334                                      ; fully-qualified     # 🌴 palm tree",
    "\uD83C\uDF34",

    "1F335                                      ; fully-qualified     # 🌵 cactus",
    "\uD83C\uDF35",

    "1F33E                                      ; fully-qualified     # 🌾 sheaf of rice",
    "\uD83C\uDF3E",

    "1F33F                                      ; fully-qualified     # 🌿 herb",
    "\uD83C\uDF3F",

    "2618 FE0F                                  ; fully-qualified     # ☘️ shamrock",
    "\u2618\uFE0F",

    "2618                                       ; non-fully-qualified # ☘ shamrock",
    "\u2618",

    "1F340                                      ; fully-qualified     # 🍀 four leaf clover",
    "\uD83C\uDF40",

    "1F341                                      ; fully-qualified     # 🍁 maple leaf",
    "\uD83C\uDF41",

    "1F342                                      ; fully-qualified     # 🍂 fallen leaf",
    "\uD83C\uDF42",

    "1F343                                      ; fully-qualified     # 🍃 leaf fluttering in wind",
    "\uD83C\uDF43",

    "1F347                                      ; fully-qualified     # 🍇 grapes",
    "\uD83C\uDF47",

    "1F348                                      ; fully-qualified     # 🍈 melon",
    "\uD83C\uDF48",

    "1F349                                      ; fully-qualified     # 🍉 watermelon",
    "\uD83C\uDF49",

    "1F34A                                      ; fully-qualified     # 🍊 tangerine",
    "\uD83C\uDF4A",

    "1F34B                                      ; fully-qualified     # 🍋 lemon",
    "\uD83C\uDF4B",

    "1F34C                                      ; fully-qualified     # 🍌 banana",
    "\uD83C\uDF4C",

    "1F34D                                      ; fully-qualified     # 🍍 pineapple",
    "\uD83C\uDF4D",

    "1F96D                                      ; fully-qualified     # 🥭 mango",
    "\uD83E\uDD6D",

    "1F34E                                      ; fully-qualified     # 🍎 red apple",
    "\uD83C\uDF4E",

    "1F34F                                      ; fully-qualified     # 🍏 green apple",
    "\uD83C\uDF4F",

    "1F350                                      ; fully-qualified     # 🍐 pear",
    "\uD83C\uDF50",

    "1F351                                      ; fully-qualified     # 🍑 peach",
    "\uD83C\uDF51",

    "1F352                                      ; fully-qualified     # 🍒 cherries",
    "\uD83C\uDF52",

    "1F353                                      ; fully-qualified     # 🍓 strawberry",
    "\uD83C\uDF53",

    "1F95D                                      ; fully-qualified     # 🥝 kiwi fruit",
    "\uD83E\uDD5D",

    "1F345                                      ; fully-qualified     # 🍅 tomato",
    "\uD83C\uDF45",

    "1F965                                      ; fully-qualified     # 🥥 coconut",
    "\uD83E\uDD65",

    "1F951                                      ; fully-qualified     # 🥑 avocado",
    "\uD83E\uDD51",

    "1F346                                      ; fully-qualified     # 🍆 eggplant",
    "\uD83C\uDF46",

    "1F954                                      ; fully-qualified     # 🥔 potato",
    "\uD83E\uDD54",

    "1F955                                      ; fully-qualified     # 🥕 carrot",
    "\uD83E\uDD55",

    "1F33D                                      ; fully-qualified     # 🌽 ear of corn",
    "\uD83C\uDF3D",

    "1F336 FE0F                                 ; fully-qualified     # 🌶️ hot pepper",
    "\uD83C\uDF36\uFE0F",

    "1F336                                      ; non-fully-qualified # 🌶 hot pepper",
    "\uD83C\uDF36",

    "1F952                                      ; fully-qualified     # 🥒 cucumber",
    "\uD83E\uDD52",

    "1F96C                                      ; fully-qualified     # 🥬 leafy green",
    "\uD83E\uDD6C",

    "1F966                                      ; fully-qualified     # 🥦 broccoli",
    "\uD83E\uDD66",

    "1F344                                      ; fully-qualified     # 🍄 mushroom",
    "\uD83C\uDF44",

    "1F95C                                      ; fully-qualified     # 🥜 peanuts",
    "\uD83E\uDD5C",

    "1F330                                      ; fully-qualified     # 🌰 chestnut",
    "\uD83C\uDF30",

    "1F35E                                      ; fully-qualified     # 🍞 bread",
    "\uD83C\uDF5E",

    "1F950                                      ; fully-qualified     # 🥐 croissant",
    "\uD83E\uDD50",

    "1F956                                      ; fully-qualified     # 🥖 baguette bread",
    "\uD83E\uDD56",

    "1F968                                      ; fully-qualified     # 🥨 pretzel",
    "\uD83E\uDD68",

    "1F96F                                      ; fully-qualified     # 🥯 bagel",
    "\uD83E\uDD6F",

    "1F95E                                      ; fully-qualified     # 🥞 pancakes",
    "\uD83E\uDD5E",

    "1F9C0                                      ; fully-qualified     # 🧀 cheese wedge",
    "\uD83E\uDDC0",

    "1F356                                      ; fully-qualified     # 🍖 meat on bone",
    "\uD83C\uDF56",

    "1F357                                      ; fully-qualified     # 🍗 poultry leg",
    "\uD83C\uDF57",

    "1F969                                      ; fully-qualified     # 🥩 cut of meat",
    "\uD83E\uDD69",

    "1F953                                      ; fully-qualified     # 🥓 bacon",
    "\uD83E\uDD53",

    "1F354                                      ; fully-qualified     # 🍔 hamburger",
    "\uD83C\uDF54",

    "1F35F                                      ; fully-qualified     # 🍟 french fries",
    "\uD83C\uDF5F",

    "1F355                                      ; fully-qualified     # 🍕 pizza",
    "\uD83C\uDF55",

    "1F32D                                      ; fully-qualified     # 🌭 hot dog",
    "\uD83C\uDF2D",

    "1F96A                                      ; fully-qualified     # 🥪 sandwich",
    "\uD83E\uDD6A",

    "1F32E                                      ; fully-qualified     # 🌮 taco",
    "\uD83C\uDF2E",

    "1F32F                                      ; fully-qualified     # 🌯 burrito",
    "\uD83C\uDF2F",

    "1F959                                      ; fully-qualified     # 🥙 stuffed flatbread",
    "\uD83E\uDD59",

    "1F95A                                      ; fully-qualified     # 🥚 egg",
    "\uD83E\uDD5A",

    "1F373                                      ; fully-qualified     # 🍳 cooking",
    "\uD83C\uDF73",

    "1F958                                      ; fully-qualified     # 🥘 shallow pan of food",
    "\uD83E\uDD58",

    "1F372                                      ; fully-qualified     # 🍲 pot of food",
    "\uD83C\uDF72",

    "1F963                                      ; fully-qualified     # 🥣 bowl with spoon",
    "\uD83E\uDD63",

    "1F957                                      ; fully-qualified     # 🥗 green salad",
    "\uD83E\uDD57",

    "1F37F                                      ; fully-qualified     # 🍿 popcorn",
    "\uD83C\uDF7F",

    "1F9C2                                      ; fully-qualified     # 🧂 salt",
    "\uD83E\uDDC2",

    "1F96B                                      ; fully-qualified     # 🥫 canned food",
    "\uD83E\uDD6B",

    "1F371                                      ; fully-qualified     # 🍱 bento box",
    "\uD83C\uDF71",

    "1F358                                      ; fully-qualified     # 🍘 rice cracker",
    "\uD83C\uDF58",

    "1F359                                      ; fully-qualified     # 🍙 rice ball",
    "\uD83C\uDF59",

    "1F35A                                      ; fully-qualified     # 🍚 cooked rice",
    "\uD83C\uDF5A",

    "1F35B                                      ; fully-qualified     # 🍛 curry rice",
    "\uD83C\uDF5B",

    "1F35C                                      ; fully-qualified     # 🍜 steaming bowl",
    "\uD83C\uDF5C",

    "1F35D                                      ; fully-qualified     # 🍝 spaghetti",
    "\uD83C\uDF5D",

    "1F360                                      ; fully-qualified     # 🍠 roasted sweet potato",
    "\uD83C\uDF60",

    "1F362                                      ; fully-qualified     # 🍢 oden",
    "\uD83C\uDF62",

    "1F363                                      ; fully-qualified     # 🍣 sushi",
    "\uD83C\uDF63",

    "1F364                                      ; fully-qualified     # 🍤 fried shrimp",
    "\uD83C\uDF64",

    "1F365                                      ; fully-qualified     # 🍥 fish cake with swirl",
    "\uD83C\uDF65",

    "1F96E                                      ; fully-qualified     # 🥮 moon cake",
    "\uD83E\uDD6E",

    "1F361                                      ; fully-qualified     # 🍡 dango",
    "\uD83C\uDF61",

    "1F95F                                      ; fully-qualified     # 🥟 dumpling",
    "\uD83E\uDD5F",

    "1F960                                      ; fully-qualified     # 🥠 fortune cookie",
    "\uD83E\uDD60",

    "1F961                                      ; fully-qualified     # 🥡 takeout box",
    "\uD83E\uDD61",

    "1F366                                      ; fully-qualified     # 🍦 soft ice cream",
    "\uD83C\uDF66",

    "1F367                                      ; fully-qualified     # 🍧 shaved ice",
    "\uD83C\uDF67",

    "1F368                                      ; fully-qualified     # 🍨 ice cream",
    "\uD83C\uDF68",

    "1F369                                      ; fully-qualified     # 🍩 doughnut",
    "\uD83C\uDF69",

    "1F36A                                      ; fully-qualified     # 🍪 cookie",
    "\uD83C\uDF6A",

    "1F382                                      ; fully-qualified     # 🎂 birthday cake",
    "\uD83C\uDF82",

    "1F370                                      ; fully-qualified     # 🍰 shortcake",
    "\uD83C\uDF70",

    "1F9C1                                      ; fully-qualified     # 🧁 cupcake",
    "\uD83E\uDDC1",

    "1F967                                      ; fully-qualified     # 🥧 pie",
    "\uD83E\uDD67",

    "1F36B                                      ; fully-qualified     # 🍫 chocolate bar",
    "\uD83C\uDF6B",

    "1F36C                                      ; fully-qualified     # 🍬 candy",
    "\uD83C\uDF6C",

    "1F36D                                      ; fully-qualified     # 🍭 lollipop",
    "\uD83C\uDF6D",

    "1F36E                                      ; fully-qualified     # 🍮 custard",
    "\uD83C\uDF6E",

    "1F36F                                      ; fully-qualified     # 🍯 honey pot",
    "\uD83C\uDF6F",

    "1F37C                                      ; fully-qualified     # 🍼 baby bottle",
    "\uD83C\uDF7C",

    "1F95B                                      ; fully-qualified     # 🥛 glass of milk",
    "\uD83E\uDD5B",

    "2615                                       ; fully-qualified     # ☕ hot beverage",
    "\u2615",

    "1F375                                      ; fully-qualified     # 🍵 teacup without handle",
    "\uD83C\uDF75",

    "1F376                                      ; fully-qualified     # 🍶 sake",
    "\uD83C\uDF76",

    "1F37E                                      ; fully-qualified     # 🍾 bottle with popping cork",
    "\uD83C\uDF7E",

    "1F377                                      ; fully-qualified     # 🍷 wine glass",
    "\uD83C\uDF77",

    "1F378                                      ; fully-qualified     # 🍸 cocktail glass",
    "\uD83C\uDF78",

    "1F379                                      ; fully-qualified     # 🍹 tropical drink",
    "\uD83C\uDF79",

    "1F37A                                      ; fully-qualified     # 🍺 beer mug",
    "\uD83C\uDF7A",

    "1F37B                                      ; fully-qualified     # 🍻 clinking beer mugs",
    "\uD83C\uDF7B",

    "1F942                                      ; fully-qualified     # 🥂 clinking glasses",
    "\uD83E\uDD42",

    "1F943                                      ; fully-qualified     # 🥃 tumbler glass",
    "\uD83E\uDD43",

    "1F964                                      ; fully-qualified     # 🥤 cup with straw",
    "\uD83E\uDD64",

    "1F962                                      ; fully-qualified     # 🥢 chopsticks",
    "\uD83E\uDD62",

    "1F37D FE0F                                 ; fully-qualified     # 🍽️ fork and knife with plate",
    "\uD83C\uDF7D\uFE0F",

    "1F37D                                      ; non-fully-qualified # 🍽 fork and knife with plate",
    "\uD83C\uDF7D",

    "1F374                                      ; fully-qualified     # 🍴 fork and knife",
    "\uD83C\uDF74",

    "1F944                                      ; fully-qualified     # 🥄 spoon",
    "\uD83E\uDD44",

    "1F52A                                      ; fully-qualified     # 🔪 kitchen knife",
    "\uD83D\uDD2A",

    "1F3FA                                      ; fully-qualified     # 🏺 amphora",
    "\uD83C\uDFFA",

    "1F30D                                      ; fully-qualified     # 🌍 globe showing Europe-Africa",
    "\uD83C\uDF0D",

    "1F30E                                      ; fully-qualified     # 🌎 globe showing Americas",
    "\uD83C\uDF0E",

    "1F30F                                      ; fully-qualified     # 🌏 globe showing Asia-Australia",
    "\uD83C\uDF0F",

    "1F310                                      ; fully-qualified     # 🌐 globe with meridians",
    "\uD83C\uDF10",

    "1F5FA FE0F                                 ; fully-qualified     # 🗺️ world map",
    "\uD83D\uDDFA\uFE0F",

    "1F5FA                                      ; non-fully-qualified # 🗺 world map",
    "\uD83D\uDDFA",

    "1F5FE                                      ; fully-qualified     # 🗾 map of Japan",
    "\uD83D\uDDFE",

    "1F9ED                                      ; fully-qualified     # 🧭 compass",
    "\uD83E\uDDED",

    "1F3D4 FE0F                                 ; fully-qualified     # 🏔️ snow-capped mountain",
    "\uD83C\uDFD4\uFE0F",

    "1F3D4                                      ; non-fully-qualified # 🏔 snow-capped mountain",
    "\uD83C\uDFD4",

    "26F0 FE0F                                  ; fully-qualified     # ⛰️ mountain",
    "\u26F0\uFE0F",

    "26F0                                       ; non-fully-qualified # ⛰ mountain",
    "\u26F0",

    "1F30B                                      ; fully-qualified     # 🌋 volcano",
    "\uD83C\uDF0B",

    "1F5FB                                      ; fully-qualified     # 🗻 mount fuji",
    "\uD83D\uDDFB",

    "1F3D5 FE0F                                 ; fully-qualified     # 🏕️ camping",
    "\uD83C\uDFD5\uFE0F",

    "1F3D5                                      ; non-fully-qualified # 🏕 camping",
    "\uD83C\uDFD5",

    "1F3D6 FE0F                                 ; fully-qualified     # 🏖️ beach with umbrella",
    "\uD83C\uDFD6\uFE0F",

    "1F3D6                                      ; non-fully-qualified # 🏖 beach with umbrella",
    "\uD83C\uDFD6",

    "1F3DC FE0F                                 ; fully-qualified     # 🏜️ desert",
    "\uD83C\uDFDC\uFE0F",

    "1F3DC                                      ; non-fully-qualified # 🏜 desert",
    "\uD83C\uDFDC",

    "1F3DD FE0F                                 ; fully-qualified     # 🏝️ desert island",
    "\uD83C\uDFDD\uFE0F",

    "1F3DD                                      ; non-fully-qualified # 🏝 desert island",
    "\uD83C\uDFDD",

    "1F3DE FE0F                                 ; fully-qualified     # 🏞️ national park",
    "\uD83C\uDFDE\uFE0F",

    "1F3DE                                      ; non-fully-qualified # 🏞 national park",
    "\uD83C\uDFDE",

    "1F3DF FE0F                                 ; fully-qualified     # 🏟️ stadium",
    "\uD83C\uDFDF\uFE0F",

    "1F3DF                                      ; non-fully-qualified # 🏟 stadium",
    "\uD83C\uDFDF",

    "1F3DB FE0F                                 ; fully-qualified     # 🏛️ classical building",
    "\uD83C\uDFDB\uFE0F",

    "1F3DB                                      ; non-fully-qualified # 🏛 classical building",
    "\uD83C\uDFDB",

    "1F3D7 FE0F                                 ; fully-qualified     # 🏗️ building construction",
    "\uD83C\uDFD7\uFE0F",

    "1F3D7                                      ; non-fully-qualified # 🏗 building construction",
    "\uD83C\uDFD7",

    "1F9F1                                      ; fully-qualified     # 🧱 bricks",
    "\uD83E\uDDF1",

    "1F3D8 FE0F                                 ; fully-qualified     # 🏘️ houses",
    "\uD83C\uDFD8\uFE0F",

    "1F3D8                                      ; non-fully-qualified # 🏘 houses",
    "\uD83C\uDFD8",

    "1F3DA FE0F                                 ; fully-qualified     # 🏚️ derelict house",
    "\uD83C\uDFDA\uFE0F",

    "1F3DA                                      ; non-fully-qualified # 🏚 derelict house",
    "\uD83C\uDFDA",

    "1F3E0                                      ; fully-qualified     # 🏠 house",
    "\uD83C\uDFE0",

    "1F3E1                                      ; fully-qualified     # 🏡 house with garden",
    "\uD83C\uDFE1",

    "1F3E2                                      ; fully-qualified     # 🏢 office building",
    "\uD83C\uDFE2",

    "1F3E3                                      ; fully-qualified     # 🏣 Japanese post office",
    "\uD83C\uDFE3",

    "1F3E4                                      ; fully-qualified     # 🏤 post office",
    "\uD83C\uDFE4",

    "1F3E5                                      ; fully-qualified     # 🏥 hospital",
    "\uD83C\uDFE5",

    "1F3E6                                      ; fully-qualified     # 🏦 bank",
    "\uD83C\uDFE6",

    "1F3E8                                      ; fully-qualified     # 🏨 hotel",
    "\uD83C\uDFE8",

    "1F3E9                                      ; fully-qualified     # 🏩 love hotel",
    "\uD83C\uDFE9",

    "1F3EA                                      ; fully-qualified     # 🏪 convenience store",
    "\uD83C\uDFEA",

    "1F3EB                                      ; fully-qualified     # 🏫 school",
    "\uD83C\uDFEB",

    "1F3EC                                      ; fully-qualified     # 🏬 department store",
    "\uD83C\uDFEC",

    "1F3ED                                      ; fully-qualified     # 🏭 factory",
    "\uD83C\uDFED",

    "1F3EF                                      ; fully-qualified     # 🏯 Japanese castle",
    "\uD83C\uDFEF",

    "1F3F0                                      ; fully-qualified     # 🏰 castle",
    "\uD83C\uDFF0",

    "1F492                                      ; fully-qualified     # 💒 wedding",
    "\uD83D\uDC92",

    "1F5FC                                      ; fully-qualified     # 🗼 Tokyo tower",
    "\uD83D\uDDFC",

    "1F5FD                                      ; fully-qualified     # 🗽 Statue of Liberty",
    "\uD83D\uDDFD",

    "26EA                                       ; fully-qualified     # ⛪ church",
    "\u26EA",

    "1F54C                                      ; fully-qualified     # 🕌 mosque",
    "\uD83D\uDD4C",

    "1F54D                                      ; fully-qualified     # 🕍 synagogue",
    "\uD83D\uDD4D",

    "26E9 FE0F                                  ; fully-qualified     # ⛩️ shinto shrine",
    "\u26E9\uFE0F",

    "26E9                                       ; non-fully-qualified # ⛩ shinto shrine",
    "\u26E9",

    "1F54B                                      ; fully-qualified     # 🕋 kaaba",
    "\uD83D\uDD4B",

    "26F2                                       ; fully-qualified     # ⛲ fountain",
    "\u26F2",

    "26FA                                       ; fully-qualified     # ⛺ tent",
    "\u26FA",

    "1F301                                      ; fully-qualified     # 🌁 foggy",
    "\uD83C\uDF01",

    "1F303                                      ; fully-qualified     # 🌃 night with stars",
    "\uD83C\uDF03",

    "1F3D9 FE0F                                 ; fully-qualified     # 🏙️ cityscape",
    "\uD83C\uDFD9\uFE0F",

    "1F3D9                                      ; non-fully-qualified # 🏙 cityscape",
    "\uD83C\uDFD9",

    "1F304                                      ; fully-qualified     # 🌄 sunrise over mountains",
    "\uD83C\uDF04",

    "1F305                                      ; fully-qualified     # 🌅 sunrise",
    "\uD83C\uDF05",

    "1F306                                      ; fully-qualified     # 🌆 cityscape at dusk",
    "\uD83C\uDF06",

    "1F307                                      ; fully-qualified     # 🌇 sunset",
    "\uD83C\uDF07",

    "1F309                                      ; fully-qualified     # 🌉 bridge at night",
    "\uD83C\uDF09",

    "2668 FE0F                                  ; fully-qualified     # ♨️ hot springs",
    "\u2668\uFE0F",

    "2668                                       ; non-fully-qualified # ♨ hot springs",
    "\u2668",

    "1F30C                                      ; fully-qualified     # 🌌 milky way",
    "\uD83C\uDF0C",

    "1F3A0                                      ; fully-qualified     # 🎠 carousel horse",
    "\uD83C\uDFA0",

    "1F3A1                                      ; fully-qualified     # 🎡 ferris wheel",
    "\uD83C\uDFA1",

    "1F3A2                                      ; fully-qualified     # 🎢 roller coaster",
    "\uD83C\uDFA2",

    "1F488                                      ; fully-qualified     # 💈 barber pole",
    "\uD83D\uDC88",

    "1F3AA                                      ; fully-qualified     # 🎪 circus tent",
    "\uD83C\uDFAA",

    "1F682                                      ; fully-qualified     # 🚂 locomotive",
    "\uD83D\uDE82",

    "1F683                                      ; fully-qualified     # 🚃 railway car",
    "\uD83D\uDE83",

    "1F684                                      ; fully-qualified     # 🚄 high-speed train",
    "\uD83D\uDE84",

    "1F685                                      ; fully-qualified     # 🚅 bullet train",
    "\uD83D\uDE85",

    "1F686                                      ; fully-qualified     # 🚆 train",
    "\uD83D\uDE86",

    "1F687                                      ; fully-qualified     # 🚇 metro",
    "\uD83D\uDE87",

    "1F688                                      ; fully-qualified     # 🚈 light rail",
    "\uD83D\uDE88",

    "1F689                                      ; fully-qualified     # 🚉 station",
    "\uD83D\uDE89",

    "1F68A                                      ; fully-qualified     # 🚊 tram",
    "\uD83D\uDE8A",

    "1F69D                                      ; fully-qualified     # 🚝 monorail",
    "\uD83D\uDE9D",

    "1F69E                                      ; fully-qualified     # 🚞 mountain railway",
    "\uD83D\uDE9E",

    "1F68B                                      ; fully-qualified     # 🚋 tram car",
    "\uD83D\uDE8B",

    "1F68C                                      ; fully-qualified     # 🚌 bus",
    "\uD83D\uDE8C",

    "1F68D                                      ; fully-qualified     # 🚍 oncoming bus",
    "\uD83D\uDE8D",

    "1F68E                                      ; fully-qualified     # 🚎 trolleybus",
    "\uD83D\uDE8E",

    "1F690                                      ; fully-qualified     # 🚐 minibus",
    "\uD83D\uDE90",

    "1F691                                      ; fully-qualified     # 🚑 ambulance",
    "\uD83D\uDE91",

    "1F692                                      ; fully-qualified     # 🚒 fire engine",
    "\uD83D\uDE92",

    "1F693                                      ; fully-qualified     # 🚓 police car",
    "\uD83D\uDE93",

    "1F694                                      ; fully-qualified     # 🚔 oncoming police car",
    "\uD83D\uDE94",

    "1F695                                      ; fully-qualified     # 🚕 taxi",
    "\uD83D\uDE95",

    "1F696                                      ; fully-qualified     # 🚖 oncoming taxi",
    "\uD83D\uDE96",

    "1F697                                      ; fully-qualified     # 🚗 automobile",
    "\uD83D\uDE97",

    "1F698                                      ; fully-qualified     # 🚘 oncoming automobile",
    "\uD83D\uDE98",

    "1F699                                      ; fully-qualified     # 🚙 sport utility vehicle",
    "\uD83D\uDE99",

    "1F69A                                      ; fully-qualified     # 🚚 delivery truck",
    "\uD83D\uDE9A",

    "1F69B                                      ; fully-qualified     # 🚛 articulated lorry",
    "\uD83D\uDE9B",

    "1F69C                                      ; fully-qualified     # 🚜 tractor",
    "\uD83D\uDE9C",

    "1F6B2                                      ; fully-qualified     # 🚲 bicycle",
    "\uD83D\uDEB2",

    "1F6F4                                      ; fully-qualified     # 🛴 kick scooter",
    "\uD83D\uDEF4",

    "1F6F9                                      ; fully-qualified     # 🛹 skateboard",
    "\uD83D\uDEF9",

    "1F6F5                                      ; fully-qualified     # 🛵 motor scooter",
    "\uD83D\uDEF5",

    "1F68F                                      ; fully-qualified     # 🚏 bus stop",
    "\uD83D\uDE8F",

    "1F6E3 FE0F                                 ; fully-qualified     # 🛣️ motorway",
    "\uD83D\uDEE3\uFE0F",

    "1F6E3                                      ; non-fully-qualified # 🛣 motorway",
    "\uD83D\uDEE3",

    "1F6E4 FE0F                                 ; fully-qualified     # 🛤️ railway track",
    "\uD83D\uDEE4\uFE0F",

    "1F6E4                                      ; non-fully-qualified # 🛤 railway track",
    "\uD83D\uDEE4",

    "1F6E2 FE0F                                 ; fully-qualified     # 🛢️ oil drum",
    "\uD83D\uDEE2\uFE0F",

    "1F6E2                                      ; non-fully-qualified # 🛢 oil drum",
    "\uD83D\uDEE2",

    "26FD                                       ; fully-qualified     # ⛽ fuel pump",
    "\u26FD",

    "1F6A8                                      ; fully-qualified     # 🚨 police car light",
    "\uD83D\uDEA8",

    "1F6A5                                      ; fully-qualified     # 🚥 horizontal traffic light",
    "\uD83D\uDEA5",

    "1F6A6                                      ; fully-qualified     # 🚦 vertical traffic light",
    "\uD83D\uDEA6",

    "1F6D1                                      ; fully-qualified     # 🛑 stop sign",
    "\uD83D\uDED1",

    "1F6A7                                      ; fully-qualified     # 🚧 construction",
    "\uD83D\uDEA7",

    "2693                                       ; fully-qualified     # ⚓ anchor",
    "\u2693",

    "26F5                                       ; fully-qualified     # ⛵ sailboat",
    "\u26F5",

    "1F6F6                                      ; fully-qualified     # 🛶 canoe",
    "\uD83D\uDEF6",

    "1F6A4                                      ; fully-qualified     # 🚤 speedboat",
    "\uD83D\uDEA4",

    "1F6F3 FE0F                                 ; fully-qualified     # 🛳️ passenger ship",
    "\uD83D\uDEF3\uFE0F",

    "1F6F3                                      ; non-fully-qualified # 🛳 passenger ship",
    "\uD83D\uDEF3",

    "26F4 FE0F                                  ; fully-qualified     # ⛴️ ferry",
    "\u26F4\uFE0F",

    "26F4                                       ; non-fully-qualified # ⛴ ferry",
    "\u26F4",

    "1F6E5 FE0F                                 ; fully-qualified     # 🛥️ motor boat",
    "\uD83D\uDEE5\uFE0F",

    "1F6E5                                      ; non-fully-qualified # 🛥 motor boat",
    "\uD83D\uDEE5",

    "1F6A2                                      ; fully-qualified     # 🚢 ship",
    "\uD83D\uDEA2",

    "2708 FE0F                                  ; fully-qualified     # ✈️ airplane",
    "\u2708\uFE0F",

    "2708                                       ; non-fully-qualified # ✈ airplane",
    "\u2708",

    "1F6E9 FE0F                                 ; fully-qualified     # 🛩️ small airplane",
    "\uD83D\uDEE9\uFE0F",

    "1F6E9                                      ; non-fully-qualified # 🛩 small airplane",
    "\uD83D\uDEE9",

    "1F6EB                                      ; fully-qualified     # 🛫 airplane departure",
    "\uD83D\uDEEB",

    "1F6EC                                      ; fully-qualified     # 🛬 airplane arrival",
    "\uD83D\uDEEC",

    "1F4BA                                      ; fully-qualified     # 💺 seat",
    "\uD83D\uDCBA",

    "1F681                                      ; fully-qualified     # 🚁 helicopter",
    "\uD83D\uDE81",

    "1F69F                                      ; fully-qualified     # 🚟 suspension railway",
    "\uD83D\uDE9F",

    "1F6A0                                      ; fully-qualified     # 🚠 mountain cableway",
    "\uD83D\uDEA0",

    "1F6A1                                      ; fully-qualified     # 🚡 aerial tramway",
    "\uD83D\uDEA1",

    "1F6F0 FE0F                                 ; fully-qualified     # 🛰️ satellite",
    "\uD83D\uDEF0\uFE0F",

    "1F6F0                                      ; non-fully-qualified # 🛰 satellite",
    "\uD83D\uDEF0",

    "1F680                                      ; fully-qualified     # 🚀 rocket",
    "\uD83D\uDE80",

    "1F6F8                                      ; fully-qualified     # 🛸 flying saucer",
    "\uD83D\uDEF8",

    "1F6CE FE0F                                 ; fully-qualified     # 🛎️ bellhop bell",
    "\uD83D\uDECE\uFE0F",

    "1F6CE                                      ; non-fully-qualified # 🛎 bellhop bell",
    "\uD83D\uDECE",

    "1F9F3                                      ; fully-qualified     # 🧳 luggage",
    "\uD83E\uDDF3",

    "231B                                       ; fully-qualified     # ⌛ hourglass done",
    "\u231B",

    "23F3                                       ; fully-qualified     # ⏳ hourglass not done",
    "\u23F3",

    "231A                                       ; fully-qualified     # ⌚ watch",
    "\u231A",

    "23F0                                       ; fully-qualified     # ⏰ alarm clock",
    "\u23F0",

    "23F1 FE0F                                  ; fully-qualified     # ⏱️ stopwatch",
    "\u23F1\uFE0F",

    "23F1                                       ; non-fully-qualified # ⏱ stopwatch",
    "\u23F1",

    "23F2 FE0F                                  ; fully-qualified     # ⏲️ timer clock",
    "\u23F2\uFE0F",

    "23F2                                       ; non-fully-qualified # ⏲ timer clock",
    "\u23F2",

    "1F570 FE0F                                 ; fully-qualified     # 🕰️ mantelpiece clock",
    "\uD83D\uDD70\uFE0F",

    "1F570                                      ; non-fully-qualified # 🕰 mantelpiece clock",
    "\uD83D\uDD70",

    "1F55B                                      ; fully-qualified     # 🕛 twelve o’clock",
    "\uD83D\uDD5B",

    "1F567                                      ; fully-qualified     # 🕧 twelve-thirty",
    "\uD83D\uDD67",

    "1F550                                      ; fully-qualified     # 🕐 one o’clock",
    "\uD83D\uDD50",

    "1F55C                                      ; fully-qualified     # 🕜 one-thirty",
    "\uD83D\uDD5C",

    "1F551                                      ; fully-qualified     # 🕑 two o’clock",
    "\uD83D\uDD51",

    "1F55D                                      ; fully-qualified     # 🕝 two-thirty",
    "\uD83D\uDD5D",

    "1F552                                      ; fully-qualified     # 🕒 three o’clock",
    "\uD83D\uDD52",

    "1F55E                                      ; fully-qualified     # 🕞 three-thirty",
    "\uD83D\uDD5E",

    "1F553                                      ; fully-qualified     # 🕓 four o’clock",
    "\uD83D\uDD53",

    "1F55F                                      ; fully-qualified     # 🕟 four-thirty",
    "\uD83D\uDD5F",

    "1F554                                      ; fully-qualified     # 🕔 five o’clock",
    "\uD83D\uDD54",

    "1F560                                      ; fully-qualified     # 🕠 five-thirty",
    "\uD83D\uDD60",

    "1F555                                      ; fully-qualified     # 🕕 six o’clock",
    "\uD83D\uDD55",

    "1F561                                      ; fully-qualified     # 🕡 six-thirty",
    "\uD83D\uDD61",

    "1F556                                      ; fully-qualified     # 🕖 seven o’clock",
    "\uD83D\uDD56",

    "1F562                                      ; fully-qualified     # 🕢 seven-thirty",
    "\uD83D\uDD62",

    "1F557                                      ; fully-qualified     # 🕗 eight o’clock",
    "\uD83D\uDD57",

    "1F563                                      ; fully-qualified     # 🕣 eight-thirty",
    "\uD83D\uDD63",

    "1F558                                      ; fully-qualified     # 🕘 nine o’clock",
    "\uD83D\uDD58",

    "1F564                                      ; fully-qualified     # 🕤 nine-thirty",
    "\uD83D\uDD64",

    "1F559                                      ; fully-qualified     # 🕙 ten o’clock",
    "\uD83D\uDD59",

    "1F565                                      ; fully-qualified     # 🕥 ten-thirty",
    "\uD83D\uDD65",

    "1F55A                                      ; fully-qualified     # 🕚 eleven o’clock",
    "\uD83D\uDD5A",

    "1F566                                      ; fully-qualified     # 🕦 eleven-thirty",
    "\uD83D\uDD66",

    "1F311                                      ; fully-qualified     # 🌑 new moon",
    "\uD83C\uDF11",

    "1F312                                      ; fully-qualified     # 🌒 waxing crescent moon",
    "\uD83C\uDF12",

    "1F313                                      ; fully-qualified     # 🌓 first quarter moon",
    "\uD83C\uDF13",

    "1F314                                      ; fully-qualified     # 🌔 waxing gibbous moon",
    "\uD83C\uDF14",

    "1F315                                      ; fully-qualified     # 🌕 full moon",
    "\uD83C\uDF15",

    "1F316                                      ; fully-qualified     # 🌖 waning gibbous moon",
    "\uD83C\uDF16",

    "1F317                                      ; fully-qualified     # 🌗 last quarter moon",
    "\uD83C\uDF17",

    "1F318                                      ; fully-qualified     # 🌘 waning crescent moon",
    "\uD83C\uDF18",

    "1F319                                      ; fully-qualified     # 🌙 crescent moon",
    "\uD83C\uDF19",

    "1F31A                                      ; fully-qualified     # 🌚 new moon face",
    "\uD83C\uDF1A",

    "1F31B                                      ; fully-qualified     # 🌛 first quarter moon face",
    "\uD83C\uDF1B",

    "1F31C                                      ; fully-qualified     # 🌜 last quarter moon face",
    "\uD83C\uDF1C",

    "1F321 FE0F                                 ; fully-qualified     # 🌡️ thermometer",
    "\uD83C\uDF21\uFE0F",

    "1F321                                      ; non-fully-qualified # 🌡 thermometer",
    "\uD83C\uDF21",

    "2600 FE0F                                  ; fully-qualified     # ☀️ sun",
    "\u2600\uFE0F",

    "2600                                       ; non-fully-qualified # ☀ sun",
    "\u2600",

    "1F31D                                      ; fully-qualified     # 🌝 full moon face",
    "\uD83C\uDF1D",

    "1F31E                                      ; fully-qualified     # 🌞 sun with face",
    "\uD83C\uDF1E",

    "2B50                                       ; fully-qualified     # ⭐ star",
    "\u2B50",

    "1F31F                                      ; fully-qualified     # 🌟 glowing star",
    "\uD83C\uDF1F",

    "1F320                                      ; fully-qualified     # 🌠 shooting star",
    "\uD83C\uDF20",

    "2601 FE0F                                  ; fully-qualified     # ☁️ cloud",
    "\u2601\uFE0F",

    "2601                                       ; non-fully-qualified # ☁ cloud",
    "\u2601",

    "26C5                                       ; fully-qualified     # ⛅ sun behind cloud",
    "\u26C5",

    "26C8 FE0F                                  ; fully-qualified     # ⛈️ cloud with lightning and rain",
    "\u26C8\uFE0F",

    "26C8                                       ; non-fully-qualified # ⛈ cloud with lightning and rain",
    "\u26C8",

    "1F324 FE0F                                 ; fully-qualified     # 🌤️ sun behind small cloud",
    "\uD83C\uDF24\uFE0F",

    "1F324                                      ; non-fully-qualified # 🌤 sun behind small cloud",
    "\uD83C\uDF24",

    "1F325 FE0F                                 ; fully-qualified     # 🌥️ sun behind large cloud",
    "\uD83C\uDF25\uFE0F",

    "1F325                                      ; non-fully-qualified # 🌥 sun behind large cloud",
    "\uD83C\uDF25",

    "1F326 FE0F                                 ; fully-qualified     # 🌦️ sun behind rain cloud",
    "\uD83C\uDF26\uFE0F",

    "1F326                                      ; non-fully-qualified # 🌦 sun behind rain cloud",
    "\uD83C\uDF26",

    "1F327 FE0F                                 ; fully-qualified     # 🌧️ cloud with rain",
    "\uD83C\uDF27\uFE0F",

    "1F327                                      ; non-fully-qualified # 🌧 cloud with rain",
    "\uD83C\uDF27",

    "1F328 FE0F                                 ; fully-qualified     # 🌨️ cloud with snow",
    "\uD83C\uDF28\uFE0F",

    "1F328                                      ; non-fully-qualified # 🌨 cloud with snow",
    "\uD83C\uDF28",

    "1F329 FE0F                                 ; fully-qualified     # 🌩️ cloud with lightning",
    "\uD83C\uDF29\uFE0F",

    "1F329                                      ; non-fully-qualified # 🌩 cloud with lightning",
    "\uD83C\uDF29",

    "1F32A FE0F                                 ; fully-qualified     # 🌪️ tornado",
    "\uD83C\uDF2A\uFE0F",

    "1F32A                                      ; non-fully-qualified # 🌪 tornado",
    "\uD83C\uDF2A",

    "1F32B FE0F                                 ; fully-qualified     # 🌫️ fog",
    "\uD83C\uDF2B\uFE0F",

    "1F32B                                      ; non-fully-qualified # 🌫 fog",
    "\uD83C\uDF2B",

    "1F32C FE0F                                 ; fully-qualified     # 🌬️ wind face",
    "\uD83C\uDF2C\uFE0F",

    "1F32C                                      ; non-fully-qualified # 🌬 wind face",
    "\uD83C\uDF2C",

    "1F300                                      ; fully-qualified     # 🌀 cyclone",
    "\uD83C\uDF00",

    "1F308                                      ; fully-qualified     # 🌈 rainbow",
    "\uD83C\uDF08",

    "1F302                                      ; fully-qualified     # 🌂 closed umbrella",
    "\uD83C\uDF02",

    "2602 FE0F                                  ; fully-qualified     # ☂️ umbrella",
    "\u2602\uFE0F",

    "2602                                       ; non-fully-qualified # ☂ umbrella",
    "\u2602",

    "2614                                       ; fully-qualified     # ☔ umbrella with rain drops",
    "\u2614",

    "26F1 FE0F                                  ; fully-qualified     # ⛱️ umbrella on ground",
    "\u26F1\uFE0F",

    "26F1                                       ; non-fully-qualified # ⛱ umbrella on ground",
    "\u26F1",

    "26A1                                       ; fully-qualified     # ⚡ high voltage",
    "\u26A1",

    "2744 FE0F                                  ; fully-qualified     # ❄️ snowflake",
    "\u2744\uFE0F",

    "2744                                       ; non-fully-qualified # ❄ snowflake",
    "\u2744",

    "2603 FE0F                                  ; fully-qualified     # ☃️ snowman",
    "\u2603\uFE0F",

    "2603                                       ; non-fully-qualified # ☃ snowman",
    "\u2603",

    "26C4                                       ; fully-qualified     # ⛄ snowman without snow",
    "\u26C4",

    "2604 FE0F                                  ; fully-qualified     # ☄️ comet",
    "\u2604\uFE0F",

    "2604                                       ; non-fully-qualified # ☄ comet",
    "\u2604",

    "1F525                                      ; fully-qualified     # 🔥 fire",
    "\uD83D\uDD25",

    "1F4A7                                      ; fully-qualified     # 💧 droplet",
    "\uD83D\uDCA7",

    "1F30A                                      ; fully-qualified     # 🌊 water wave",
    "\uD83C\uDF0A",

    "1F383                                      ; fully-qualified     # 🎃 jack-o-lantern",
    "\uD83C\uDF83",

    "1F384                                      ; fully-qualified     # 🎄 Christmas tree",
    "\uD83C\uDF84",

    "1F386                                      ; fully-qualified     # 🎆 fireworks",
    "\uD83C\uDF86",

    "1F387                                      ; fully-qualified     # 🎇 sparkler",
    "\uD83C\uDF87",

    "1F9E8                                      ; fully-qualified     # 🧨 firecracker",
    "\uD83E\uDDE8",

    "2728                                       ; fully-qualified     # ✨ sparkles",
    "\u2728",

    "1F388                                      ; fully-qualified     # 🎈 balloon",
    "\uD83C\uDF88",

    "1F389                                      ; fully-qualified     # 🎉 party popper",
    "\uD83C\uDF89",

    "1F38A                                      ; fully-qualified     # 🎊 confetti ball",
    "\uD83C\uDF8A",

    "1F38B                                      ; fully-qualified     # 🎋 tanabata tree",
    "\uD83C\uDF8B",

    "1F38D                                      ; fully-qualified     # 🎍 pine decoration",
    "\uD83C\uDF8D",

    "1F38E                                      ; fully-qualified     # 🎎 Japanese dolls",
    "\uD83C\uDF8E",

    "1F38F                                      ; fully-qualified     # 🎏 carp streamer",
    "\uD83C\uDF8F",

    "1F390                                      ; fully-qualified     # 🎐 wind chime",
    "\uD83C\uDF90",

    "1F391                                      ; fully-qualified     # 🎑 moon viewing ceremony",
    "\uD83C\uDF91",

    "1F9E7                                      ; fully-qualified     # 🧧 red envelope",
    "\uD83E\uDDE7",

    "1F380                                      ; fully-qualified     # 🎀 ribbon",
    "\uD83C\uDF80",

    "1F381                                      ; fully-qualified     # 🎁 wrapped gift",
    "\uD83C\uDF81",

    "1F397 FE0F                                 ; fully-qualified     # 🎗️ reminder ribbon",
    "\uD83C\uDF97\uFE0F",

    "1F397                                      ; non-fully-qualified # 🎗 reminder ribbon",
    "\uD83C\uDF97",

    "1F39F FE0F                                 ; fully-qualified     # 🎟️ admission tickets",
    "\uD83C\uDF9F\uFE0F",

    "1F39F                                      ; non-fully-qualified # 🎟 admission tickets",
    "\uD83C\uDF9F",

    "1F3AB                                      ; fully-qualified     # 🎫 ticket",
    "\uD83C\uDFAB",

    "1F396 FE0F                                 ; fully-qualified     # 🎖️ military medal",
    "\uD83C\uDF96\uFE0F",

    "1F396                                      ; non-fully-qualified # 🎖 military medal",
    "\uD83C\uDF96",

    "1F3C6                                      ; fully-qualified     # 🏆 trophy",
    "\uD83C\uDFC6",

    "1F3C5                                      ; fully-qualified     # 🏅 sports medal",
    "\uD83C\uDFC5",

    "1F947                                      ; fully-qualified     # 🥇 1st place medal",
    "\uD83E\uDD47",

    "1F948                                      ; fully-qualified     # 🥈 2nd place medal",
    "\uD83E\uDD48",

    "1F949                                      ; fully-qualified     # 🥉 3rd place medal",
    "\uD83E\uDD49",

    "26BD                                       ; fully-qualified     # ⚽ soccer ball",
    "\u26BD",

    "26BE                                       ; fully-qualified     # ⚾ baseball",
    "\u26BE",

    "1F94E                                      ; fully-qualified     # 🥎 softball",
    "\uD83E\uDD4E",

    "1F3C0                                      ; fully-qualified     # 🏀 basketball",
    "\uD83C\uDFC0",

    "1F3D0                                      ; fully-qualified     # 🏐 volleyball",
    "\uD83C\uDFD0",

    "1F3C8                                      ; fully-qualified     # 🏈 american football",
    "\uD83C\uDFC8",

    "1F3C9                                      ; fully-qualified     # 🏉 rugby football",
    "\uD83C\uDFC9",

    "1F3BE                                      ; fully-qualified     # 🎾 tennis",
    "\uD83C\uDFBE",

    "1F94F                                      ; fully-qualified     # 🥏 flying disc",
    "\uD83E\uDD4F",

    "1F3B3                                      ; fully-qualified     # 🎳 bowling",
    "\uD83C\uDFB3",

    "1F3CF                                      ; fully-qualified     # 🏏 cricket game",
    "\uD83C\uDFCF",

    "1F3D1                                      ; fully-qualified     # 🏑 field hockey",
    "\uD83C\uDFD1",

    "1F3D2                                      ; fully-qualified     # 🏒 ice hockey",
    "\uD83C\uDFD2",

    "1F94D                                      ; fully-qualified     # 🥍 lacrosse",
    "\uD83E\uDD4D",

    "1F3D3                                      ; fully-qualified     # 🏓 ping pong",
    "\uD83C\uDFD3",

    "1F3F8                                      ; fully-qualified     # 🏸 badminton",
    "\uD83C\uDFF8",

    "1F94A                                      ; fully-qualified     # 🥊 boxing glove",
    "\uD83E\uDD4A",

    "1F94B                                      ; fully-qualified     # 🥋 martial arts uniform",
    "\uD83E\uDD4B",

    "1F945                                      ; fully-qualified     # 🥅 goal net",
    "\uD83E\uDD45",

    "26F3                                       ; fully-qualified     # ⛳ flag in hole",
    "\u26F3",

    "26F8 FE0F                                  ; fully-qualified     # ⛸️ ice skate",
    "\u26F8\uFE0F",

    "26F8                                       ; non-fully-qualified # ⛸ ice skate",
    "\u26F8",

    "1F3A3                                      ; fully-qualified     # 🎣 fishing pole",
    "\uD83C\uDFA3",

    "1F3BD                                      ; fully-qualified     # 🎽 running shirt",
    "\uD83C\uDFBD",

    "1F3BF                                      ; fully-qualified     # 🎿 skis",
    "\uD83C\uDFBF",

    "1F6F7                                      ; fully-qualified     # 🛷 sled",
    "\uD83D\uDEF7",

    "1F94C                                      ; fully-qualified     # 🥌 curling stone",
    "\uD83E\uDD4C",

    "1F3AF                                      ; fully-qualified     # 🎯 direct hit",
    "\uD83C\uDFAF",

    "1F3B1                                      ; fully-qualified     # 🎱 pool 8 ball",
    "\uD83C\uDFB1",

    "1F52E                                      ; fully-qualified     # 🔮 crystal ball",
    "\uD83D\uDD2E",

    "1F9FF                                      ; fully-qualified     # 🧿 nazar amulet",
    "\uD83E\uDDFF",

    "1F3AE                                      ; fully-qualified     # 🎮 video game",
    "\uD83C\uDFAE",

    "1F579 FE0F                                 ; fully-qualified     # 🕹️ joystick",
    "\uD83D\uDD79\uFE0F",

    "1F579                                      ; non-fully-qualified # 🕹 joystick",
    "\uD83D\uDD79",

    "1F3B0                                      ; fully-qualified     # 🎰 slot machine",
    "\uD83C\uDFB0",

    "1F3B2                                      ; fully-qualified     # 🎲 game die",
    "\uD83C\uDFB2",

    "1F9E9                                      ; fully-qualified     # 🧩 jigsaw",
    "\uD83E\uDDE9",

    "1F9F8                                      ; fully-qualified     # 🧸 teddy bear",
    "\uD83E\uDDF8",

    "2660 FE0F                                  ; fully-qualified     # ♠️ spade suit",
    "\u2660\uFE0F",

    "2660                                       ; non-fully-qualified # ♠ spade suit",
    "\u2660",

    "2665 FE0F                                  ; fully-qualified     # ♥️ heart suit",
    "\u2665\uFE0F",

    "2665                                       ; non-fully-qualified # ♥ heart suit",
    "\u2665",

    "2666 FE0F                                  ; fully-qualified     # ♦️ diamond suit",
    "\u2666\uFE0F",

    "2666                                       ; non-fully-qualified # ♦ diamond suit",
    "\u2666",

    "2663 FE0F                                  ; fully-qualified     # ♣️ club suit",
    "\u2663\uFE0F",

    "2663                                       ; non-fully-qualified # ♣ club suit",
    "\u2663",

    "265F FE0F                                  ; fully-qualified     # ♟️ chess pawn",
    "\u265F\uFE0F",

    "265F                                       ; non-fully-qualified # ♟ chess pawn",
    "\u265F",

    "1F0CF                                      ; fully-qualified     # 🃏 joker",
    "\uD83C\uDCCF",

    "1F004                                      ; fully-qualified     # 🀄 mahjong red dragon",
    "\uD83C\uDC04",

    "1F3B4                                      ; fully-qualified     # 🎴 flower playing cards",
    "\uD83C\uDFB4",

    "1F3AD                                      ; fully-qualified     # 🎭 performing arts",
    "\uD83C\uDFAD",

    "1F5BC FE0F                                 ; fully-qualified     # 🖼️ framed picture",
    "\uD83D\uDDBC\uFE0F",

    "1F5BC                                      ; non-fully-qualified # 🖼 framed picture",
    "\uD83D\uDDBC",

    "1F3A8                                      ; fully-qualified     # 🎨 artist palette",
    "\uD83C\uDFA8",

    "1F9F5                                      ; fully-qualified     # 🧵 thread",
    "\uD83E\uDDF5",

    "1F9F6                                      ; fully-qualified     # 🧶 yarn",
    "\uD83E\uDDF6",

    "1F507                                      ; fully-qualified     # 🔇 muted speaker",
    "\uD83D\uDD07",

    "1F508                                      ; fully-qualified     # 🔈 speaker low volume",
    "\uD83D\uDD08",

    "1F509                                      ; fully-qualified     # 🔉 speaker medium volume",
    "\uD83D\uDD09",

    "1F50A                                      ; fully-qualified     # 🔊 speaker high volume",
    "\uD83D\uDD0A",

    "1F4E2                                      ; fully-qualified     # 📢 loudspeaker",
    "\uD83D\uDCE2",

    "1F4E3                                      ; fully-qualified     # 📣 megaphone",
    "\uD83D\uDCE3",

    "1F4EF                                      ; fully-qualified     # 📯 postal horn",
    "\uD83D\uDCEF",

    "1F514                                      ; fully-qualified     # 🔔 bell",
    "\uD83D\uDD14",

    "1F515                                      ; fully-qualified     # 🔕 bell with slash",
    "\uD83D\uDD15",

    "1F3BC                                      ; fully-qualified     # 🎼 musical score",
    "\uD83C\uDFBC",

    "1F3B5                                      ; fully-qualified     # 🎵 musical note",
    "\uD83C\uDFB5",

    "1F3B6                                      ; fully-qualified     # 🎶 musical notes",
    "\uD83C\uDFB6",

    "1F399 FE0F                                 ; fully-qualified     # 🎙️ studio microphone",
    "\uD83C\uDF99\uFE0F",

    "1F399                                      ; non-fully-qualified # 🎙 studio microphone",
    "\uD83C\uDF99",

    "1F39A FE0F                                 ; fully-qualified     # 🎚️ level slider",
    "\uD83C\uDF9A\uFE0F",

    "1F39A                                      ; non-fully-qualified # 🎚 level slider",
    "\uD83C\uDF9A",

    "1F39B FE0F                                 ; fully-qualified     # 🎛️ control knobs",
    "\uD83C\uDF9B\uFE0F",

    "1F39B                                      ; non-fully-qualified # 🎛 control knobs",
    "\uD83C\uDF9B",

    "1F3A4                                      ; fully-qualified     # 🎤 microphone",
    "\uD83C\uDFA4",

    "1F3A7                                      ; fully-qualified     # 🎧 headphone",
    "\uD83C\uDFA7",

    "1F4FB                                      ; fully-qualified     # 📻 radio",
    "\uD83D\uDCFB",

    "1F3B7                                      ; fully-qualified     # 🎷 saxophone",
    "\uD83C\uDFB7",

    "1F3B8                                      ; fully-qualified     # 🎸 guitar",
    "\uD83C\uDFB8",

    "1F3B9                                      ; fully-qualified     # 🎹 musical keyboard",
    "\uD83C\uDFB9",

    "1F3BA                                      ; fully-qualified     # 🎺 trumpet",
    "\uD83C\uDFBA",

    "1F3BB                                      ; fully-qualified     # 🎻 violin",
    "\uD83C\uDFBB",

    "1F941                                      ; fully-qualified     # 🥁 drum",
    "\uD83E\uDD41",

    "1F4F1                                      ; fully-qualified     # 📱 mobile phone",
    "\uD83D\uDCF1",

    "1F4F2                                      ; fully-qualified     # 📲 mobile phone with arrow",
    "\uD83D\uDCF2",

    "260E FE0F                                  ; fully-qualified     # ☎️ telephone",
    "\u260E\uFE0F",

    "260E                                       ; non-fully-qualified # ☎ telephone",
    "\u260E",

    "1F4DE                                      ; fully-qualified     # 📞 telephone receiver",
    "\uD83D\uDCDE",

    "1F4DF                                      ; fully-qualified     # 📟 pager",
    "\uD83D\uDCDF",

    "1F4E0                                      ; fully-qualified     # 📠 fax machine",
    "\uD83D\uDCE0",

    "1F50B                                      ; fully-qualified     # 🔋 battery",
    "\uD83D\uDD0B",

    "1F50C                                      ; fully-qualified     # 🔌 electric plug",
    "\uD83D\uDD0C",

    "1F4BB                                      ; fully-qualified     # 💻 laptop computer",
    "\uD83D\uDCBB",

    "1F5A5 FE0F                                 ; fully-qualified     # 🖥️ desktop computer",
    "\uD83D\uDDA5\uFE0F",

    "1F5A5                                      ; non-fully-qualified # 🖥 desktop computer",
    "\uD83D\uDDA5",

    "1F5A8 FE0F                                 ; fully-qualified     # 🖨️ printer",
    "\uD83D\uDDA8\uFE0F",

    "1F5A8                                      ; non-fully-qualified # 🖨 printer",
    "\uD83D\uDDA8",

    "2328 FE0F                                  ; fully-qualified     # ⌨️ keyboard",
    "\u2328\uFE0F",

    "2328                                       ; non-fully-qualified # ⌨ keyboard",
    "\u2328",

    "1F5B1 FE0F                                 ; fully-qualified     # 🖱️ computer mouse",
    "\uD83D\uDDB1\uFE0F",

    "1F5B1                                      ; non-fully-qualified # 🖱 computer mouse",
    "\uD83D\uDDB1",

    "1F5B2 FE0F                                 ; fully-qualified     # 🖲️ trackball",
    "\uD83D\uDDB2\uFE0F",

    "1F5B2                                      ; non-fully-qualified # 🖲 trackball",
    "\uD83D\uDDB2",

    "1F4BD                                      ; fully-qualified     # 💽 computer disk",
    "\uD83D\uDCBD",

    "1F4BE                                      ; fully-qualified     # 💾 floppy disk",
    "\uD83D\uDCBE",

    "1F4BF                                      ; fully-qualified     # 💿 optical disk",
    "\uD83D\uDCBF",

    "1F4C0                                      ; fully-qualified     # 📀 dvd",
    "\uD83D\uDCC0",

    "1F9EE                                      ; fully-qualified     # 🧮 abacus",
    "\uD83E\uDDEE",

    "1F3A5                                      ; fully-qualified     # 🎥 movie camera",
    "\uD83C\uDFA5",

    "1F39E FE0F                                 ; fully-qualified     # 🎞️ film frames",
    "\uD83C\uDF9E\uFE0F",

    "1F39E                                      ; non-fully-qualified # 🎞 film frames",
    "\uD83C\uDF9E",

    "1F4FD FE0F                                 ; fully-qualified     # 📽️ film projector",
    "\uD83D\uDCFD\uFE0F",

    "1F4FD                                      ; non-fully-qualified # 📽 film projector",
    "\uD83D\uDCFD",

    "1F3AC                                      ; fully-qualified     # 🎬 clapper board",
    "\uD83C\uDFAC",

    "1F4FA                                      ; fully-qualified     # 📺 television",
    "\uD83D\uDCFA",

    "1F4F7                                      ; fully-qualified     # 📷 camera",
    "\uD83D\uDCF7",

    "1F4F8                                      ; fully-qualified     # 📸 camera with flash",
    "\uD83D\uDCF8",

    "1F4F9                                      ; fully-qualified     # 📹 video camera",
    "\uD83D\uDCF9",

    "1F4FC                                      ; fully-qualified     # 📼 videocassette",
    "\uD83D\uDCFC",

    "1F50D                                      ; fully-qualified     # 🔍 magnifying glass tilted left",
    "\uD83D\uDD0D",

    "1F50E                                      ; fully-qualified     # 🔎 magnifying glass tilted right",
    "\uD83D\uDD0E",

    "1F56F FE0F                                 ; fully-qualified     # 🕯️ candle",
    "\uD83D\uDD6F\uFE0F",

    "1F56F                                      ; non-fully-qualified # 🕯 candle",
    "\uD83D\uDD6F",

    "1F4A1                                      ; fully-qualified     # 💡 light bulb",
    "\uD83D\uDCA1",

    "1F526                                      ; fully-qualified     # 🔦 flashlight",
    "\uD83D\uDD26",

    "1F3EE                                      ; fully-qualified     # 🏮 red paper lantern",
    "\uD83C\uDFEE",

    "1F4D4                                      ; fully-qualified     # 📔 notebook with decorative cover",
    "\uD83D\uDCD4",

    "1F4D5                                      ; fully-qualified     # 📕 closed book",
    "\uD83D\uDCD5",

    "1F4D6                                      ; fully-qualified     # 📖 open book",
    "\uD83D\uDCD6",

    "1F4D7                                      ; fully-qualified     # 📗 green book",
    "\uD83D\uDCD7",

    "1F4D8                                      ; fully-qualified     # 📘 blue book",
    "\uD83D\uDCD8",

    "1F4D9                                      ; fully-qualified     # 📙 orange book",
    "\uD83D\uDCD9",

    "1F4DA                                      ; fully-qualified     # 📚 books",
    "\uD83D\uDCDA",

    "1F4D3                                      ; fully-qualified     # 📓 notebook",
    "\uD83D\uDCD3",

    "1F4D2                                      ; fully-qualified     # 📒 ledger",
    "\uD83D\uDCD2",

    "1F4C3                                      ; fully-qualified     # 📃 page with curl",
    "\uD83D\uDCC3",

    "1F4DC                                      ; fully-qualified     # 📜 scroll",
    "\uD83D\uDCDC",

    "1F4C4                                      ; fully-qualified     # 📄 page facing up",
    "\uD83D\uDCC4",

    "1F4F0                                      ; fully-qualified     # 📰 newspaper",
    "\uD83D\uDCF0",

    "1F5DE FE0F                                 ; fully-qualified     # 🗞️ rolled-up newspaper",
    "\uD83D\uDDDE\uFE0F",

    "1F5DE                                      ; non-fully-qualified # 🗞 rolled-up newspaper",
    "\uD83D\uDDDE",

    "1F4D1                                      ; fully-qualified     # 📑 bookmark tabs",
    "\uD83D\uDCD1",

    "1F516                                      ; fully-qualified     # 🔖 bookmark",
    "\uD83D\uDD16",

    "1F3F7 FE0F                                 ; fully-qualified     # 🏷️ label",
    "\uD83C\uDFF7\uFE0F",

    "1F3F7                                      ; non-fully-qualified # 🏷 label",
    "\uD83C\uDFF7",

    "1F4B0                                      ; fully-qualified     # 💰 money bag",
    "\uD83D\uDCB0",

    "1F4B4                                      ; fully-qualified     # 💴 yen banknote",
    "\uD83D\uDCB4",

    "1F4B5                                      ; fully-qualified     # 💵 dollar banknote",
    "\uD83D\uDCB5",

    "1F4B6                                      ; fully-qualified     # 💶 euro banknote",
    "\uD83D\uDCB6",

    "1F4B7                                      ; fully-qualified     # 💷 pound banknote",
    "\uD83D\uDCB7",

    "1F4B8                                      ; fully-qualified     # 💸 money with wings",
    "\uD83D\uDCB8",

    "1F4B3                                      ; fully-qualified     # 💳 credit card",
    "\uD83D\uDCB3",

    "1F9FE                                      ; fully-qualified     # 🧾 receipt",
    "\uD83E\uDDFE",

    "1F4B9                                      ; fully-qualified     # 💹 chart increasing with yen",
    "\uD83D\uDCB9",

    "1F4B1                                      ; fully-qualified     # 💱 currency exchange",
    "\uD83D\uDCB1",

    "1F4B2                                      ; fully-qualified     # 💲 heavy dollar sign",
    "\uD83D\uDCB2",

    "2709 FE0F                                  ; fully-qualified     # ✉️ envelope",
    "\u2709\uFE0F",

    "2709                                       ; non-fully-qualified # ✉ envelope",
    "\u2709",

    "1F4E7                                      ; fully-qualified     # 📧 e-mail",
    "\uD83D\uDCE7",

    "1F4E8                                      ; fully-qualified     # 📨 incoming envelope",
    "\uD83D\uDCE8",

    "1F4E9                                      ; fully-qualified     # 📩 envelope with arrow",
    "\uD83D\uDCE9",

    "1F4E4                                      ; fully-qualified     # 📤 outbox tray",
    "\uD83D\uDCE4",

    "1F4E5                                      ; fully-qualified     # 📥 inbox tray",
    "\uD83D\uDCE5",

    "1F4E6                                      ; fully-qualified     # 📦 package",
    "\uD83D\uDCE6",

    "1F4EB                                      ; fully-qualified     # 📫 closed mailbox with raised flag",
    "\uD83D\uDCEB",

    "1F4EA                                      ; fully-qualified     # 📪 closed mailbox with lowered flag",
    "\uD83D\uDCEA",

    "1F4EC                                      ; fully-qualified     # 📬 open mailbox with raised flag",
    "\uD83D\uDCEC",

    "1F4ED                                      ; fully-qualified     # 📭 open mailbox with lowered flag",
    "\uD83D\uDCED",

    "1F4EE                                      ; fully-qualified     # 📮 postbox",
    "\uD83D\uDCEE",

    "1F5F3 FE0F                                 ; fully-qualified     # 🗳️ ballot box with ballot",
    "\uD83D\uDDF3\uFE0F",

    "1F5F3                                      ; non-fully-qualified # 🗳 ballot box with ballot",
    "\uD83D\uDDF3",

    "270F FE0F                                  ; fully-qualified     # ✏️ pencil",
    "\u270F\uFE0F",

    "270F                                       ; non-fully-qualified # ✏ pencil",
    "\u270F",

    "2712 FE0F                                  ; fully-qualified     # ✒️ black nib",
    "\u2712\uFE0F",

    "2712                                       ; non-fully-qualified # ✒ black nib",
    "\u2712",

    "1F58B FE0F                                 ; fully-qualified     # 🖋️ fountain pen",
    "\uD83D\uDD8B\uFE0F",

    "1F58B                                      ; non-fully-qualified # 🖋 fountain pen",
    "\uD83D\uDD8B",

    "1F58A FE0F                                 ; fully-qualified     # 🖊️ pen",
    "\uD83D\uDD8A\uFE0F",

    "1F58A                                      ; non-fully-qualified # 🖊 pen",
    "\uD83D\uDD8A",

    "1F58C FE0F                                 ; fully-qualified     # 🖌️ paintbrush",
    "\uD83D\uDD8C\uFE0F",

    "1F58C                                      ; non-fully-qualified # 🖌 paintbrush",
    "\uD83D\uDD8C",

    "1F58D FE0F                                 ; fully-qualified     # 🖍️ crayon",
    "\uD83D\uDD8D\uFE0F",

    "1F58D                                      ; non-fully-qualified # 🖍 crayon",
    "\uD83D\uDD8D",

    "1F4DD                                      ; fully-qualified     # 📝 memo",
    "\uD83D\uDCDD",

    "1F4BC                                      ; fully-qualified     # 💼 briefcase",
    "\uD83D\uDCBC",

    "1F4C1                                      ; fully-qualified     # 📁 file folder",
    "\uD83D\uDCC1",

    "1F4C2                                      ; fully-qualified     # 📂 open file folder",
    "\uD83D\uDCC2",

    "1F5C2 FE0F                                 ; fully-qualified     # 🗂️ card index dividers",
    "\uD83D\uDDC2\uFE0F",

    "1F5C2                                      ; non-fully-qualified # 🗂 card index dividers",
    "\uD83D\uDDC2",

    "1F4C5                                      ; fully-qualified     # 📅 calendar",
    "\uD83D\uDCC5",

    "1F4C6                                      ; fully-qualified     # 📆 tear-off calendar",
    "\uD83D\uDCC6",

    "1F5D2 FE0F                                 ; fully-qualified     # 🗒️ spiral notepad",
    "\uD83D\uDDD2\uFE0F",

    "1F5D2                                      ; non-fully-qualified # 🗒 spiral notepad",
    "\uD83D\uDDD2",

    "1F5D3 FE0F                                 ; fully-qualified     # 🗓️ spiral calendar",
    "\uD83D\uDDD3\uFE0F",

    "1F5D3                                      ; non-fully-qualified # 🗓 spiral calendar",
    "\uD83D\uDDD3",

    "1F4C7                                      ; fully-qualified     # 📇 card index",
    "\uD83D\uDCC7",

    "1F4C8                                      ; fully-qualified     # 📈 chart increasing",
    "\uD83D\uDCC8",

    "1F4C9                                      ; fully-qualified     # 📉 chart decreasing",
    "\uD83D\uDCC9",

    "1F4CA                                      ; fully-qualified     # 📊 bar chart",
    "\uD83D\uDCCA",

    "1F4CB                                      ; fully-qualified     # 📋 clipboard",
    "\uD83D\uDCCB",

    "1F4CC                                      ; fully-qualified     # 📌 pushpin",
    "\uD83D\uDCCC",

    "1F4CD                                      ; fully-qualified     # 📍 round pushpin",
    "\uD83D\uDCCD",

    "1F4CE                                      ; fully-qualified     # 📎 paperclip",
    "\uD83D\uDCCE",

    "1F587 FE0F                                 ; fully-qualified     # 🖇️ linked paperclips",
    "\uD83D\uDD87\uFE0F",

    "1F587                                      ; non-fully-qualified # 🖇 linked paperclips",
    "\uD83D\uDD87",

    "1F4CF                                      ; fully-qualified     # 📏 straight ruler",
    "\uD83D\uDCCF",

    "1F4D0                                      ; fully-qualified     # 📐 triangular ruler",
    "\uD83D\uDCD0",

    "2702 FE0F                                  ; fully-qualified     # ✂️ scissors",
    "\u2702\uFE0F",

    "2702                                       ; non-fully-qualified # ✂ scissors",
    "\u2702",

    "1F5C3 FE0F                                 ; fully-qualified     # 🗃️ card file box",
    "\uD83D\uDDC3\uFE0F",

    "1F5C3                                      ; non-fully-qualified # 🗃 card file box",
    "\uD83D\uDDC3",

    "1F5C4 FE0F                                 ; fully-qualified     # 🗄️ file cabinet",
    "\uD83D\uDDC4\uFE0F",

    "1F5C4                                      ; non-fully-qualified # 🗄 file cabinet",
    "\uD83D\uDDC4",

    "1F5D1 FE0F                                 ; fully-qualified     # 🗑️ wastebasket",
    "\uD83D\uDDD1\uFE0F",

    "1F5D1                                      ; non-fully-qualified # 🗑 wastebasket",
    "\uD83D\uDDD1",

    "1F512                                      ; fully-qualified     # 🔒 locked",
    "\uD83D\uDD12",

    "1F513                                      ; fully-qualified     # 🔓 unlocked",
    "\uD83D\uDD13",

    "1F50F                                      ; fully-qualified     # 🔏 locked with pen",
    "\uD83D\uDD0F",

    "1F510                                      ; fully-qualified     # 🔐 locked with key",
    "\uD83D\uDD10",

    "1F511                                      ; fully-qualified     # 🔑 key",
    "\uD83D\uDD11",

    "1F5DD FE0F                                 ; fully-qualified     # 🗝️ old key",
    "\uD83D\uDDDD\uFE0F",

    "1F5DD                                      ; non-fully-qualified # 🗝 old key",
    "\uD83D\uDDDD",

    "1F528                                      ; fully-qualified     # 🔨 hammer",
    "\uD83D\uDD28",

    "26CF FE0F                                  ; fully-qualified     # ⛏️ pick",
    "\u26CF\uFE0F",

    "26CF                                       ; non-fully-qualified # ⛏ pick",
    "\u26CF",

    "2692 FE0F                                  ; fully-qualified     # ⚒️ hammer and pick",
    "\u2692\uFE0F",

    "2692                                       ; non-fully-qualified # ⚒ hammer and pick",
    "\u2692",

    "1F6E0 FE0F                                 ; fully-qualified     # 🛠️ hammer and wrench",
    "\uD83D\uDEE0\uFE0F",

    "1F6E0                                      ; non-fully-qualified # 🛠 hammer and wrench",
    "\uD83D\uDEE0",

    "1F5E1 FE0F                                 ; fully-qualified     # 🗡️ dagger",
    "\uD83D\uDDE1\uFE0F",

    "1F5E1                                      ; non-fully-qualified # 🗡 dagger",
    "\uD83D\uDDE1",

    "2694 FE0F                                  ; fully-qualified     # ⚔️ crossed swords",
    "\u2694\uFE0F",

    "2694                                       ; non-fully-qualified # ⚔ crossed swords",
    "\u2694",

    "1F52B                                      ; fully-qualified     # 🔫 pistol",
    "\uD83D\uDD2B",

    "1F3F9                                      ; fully-qualified     # 🏹 bow and arrow",
    "\uD83C\uDFF9",

    "1F6E1 FE0F                                 ; fully-qualified     # 🛡️ shield",
    "\uD83D\uDEE1\uFE0F",

    "1F6E1                                      ; non-fully-qualified # 🛡 shield",
    "\uD83D\uDEE1",

    "1F527                                      ; fully-qualified     # 🔧 wrench",
    "\uD83D\uDD27",

    "1F529                                      ; fully-qualified     # 🔩 nut and bolt",
    "\uD83D\uDD29",

    "2699 FE0F                                  ; fully-qualified     # ⚙️ gear",
    "\u2699\uFE0F",

    "2699                                       ; non-fully-qualified # ⚙ gear",
    "\u2699",

    "1F5DC FE0F                                 ; fully-qualified     # 🗜️ clamp",
    "\uD83D\uDDDC\uFE0F",

    "1F5DC                                      ; non-fully-qualified # 🗜 clamp",
    "\uD83D\uDDDC",

    "2696 FE0F                                  ; fully-qualified     # ⚖️ balance scale",
    "\u2696\uFE0F",

    "2696                                       ; non-fully-qualified # ⚖ balance scale",
    "\u2696",

    "1F517                                      ; fully-qualified     # 🔗 link",
    "\uD83D\uDD17",

    "26D3 FE0F                                  ; fully-qualified     # ⛓️ chains",
    "\u26D3\uFE0F",

    "26D3                                       ; non-fully-qualified # ⛓ chains",
    "\u26D3",

    "1F9F0                                      ; fully-qualified     # 🧰 toolbox",
    "\uD83E\uDDF0",

    "1F9F2                                      ; fully-qualified     # 🧲 magnet",
    "\uD83E\uDDF2",

    "2697 FE0F                                  ; fully-qualified     # ⚗️ alembic",
    "\u2697\uFE0F",

    "2697                                       ; non-fully-qualified # ⚗ alembic",
    "\u2697",

    "1F9EA                                      ; fully-qualified     # 🧪 test tube",
    "\uD83E\uDDEA",

    "1F9EB                                      ; fully-qualified     # 🧫 petri dish",
    "\uD83E\uDDEB",

    "1F9EC                                      ; fully-qualified     # 🧬 dna",
    "\uD83E\uDDEC",

    "1F52C                                      ; fully-qualified     # 🔬 microscope",
    "\uD83D\uDD2C",

    "1F52D                                      ; fully-qualified     # 🔭 telescope",
    "\uD83D\uDD2D",

    "1F4E1                                      ; fully-qualified     # 📡 satellite antenna",
    "\uD83D\uDCE1",

    "1F489                                      ; fully-qualified     # 💉 syringe",
    "\uD83D\uDC89",

    "1F48A                                      ; fully-qualified     # 💊 pill",
    "\uD83D\uDC8A",

    "1F6AA                                      ; fully-qualified     # 🚪 door",
    "\uD83D\uDEAA",

    "1F6CF FE0F                                 ; fully-qualified     # 🛏️ bed",
    "\uD83D\uDECF\uFE0F",

    "1F6CF                                      ; non-fully-qualified # 🛏 bed",
    "\uD83D\uDECF",

    "1F6CB FE0F                                 ; fully-qualified     # 🛋️ couch and lamp",
    "\uD83D\uDECB\uFE0F",

    "1F6CB                                      ; non-fully-qualified # 🛋 couch and lamp",
    "\uD83D\uDECB",

    "1F6BD                                      ; fully-qualified     # 🚽 toilet",
    "\uD83D\uDEBD",

    "1F6BF                                      ; fully-qualified     # 🚿 shower",
    "\uD83D\uDEBF",

    "1F6C1                                      ; fully-qualified     # 🛁 bathtub",
    "\uD83D\uDEC1",

    "1F9F4                                      ; fully-qualified     # 🧴 lotion bottle",
    "\uD83E\uDDF4",

    "1F9F7                                      ; fully-qualified     # 🧷 safety pin",
    "\uD83E\uDDF7",

    "1F9F9                                      ; fully-qualified     # 🧹 broom",
    "\uD83E\uDDF9",

    "1F9FA                                      ; fully-qualified     # 🧺 basket",
    "\uD83E\uDDFA",

    "1F9FB                                      ; fully-qualified     # 🧻 roll of paper",
    "\uD83E\uDDFB",

    "1F9FC                                      ; fully-qualified     # 🧼 soap",
    "\uD83E\uDDFC",

    "1F9FD                                      ; fully-qualified     # 🧽 sponge",
    "\uD83E\uDDFD",

    "1F9EF                                      ; fully-qualified     # 🧯 fire extinguisher",
    "\uD83E\uDDEF",

    "1F6D2                                      ; fully-qualified     # 🛒 shopping cart",
    "\uD83D\uDED2",

    "1F6AC                                      ; fully-qualified     # 🚬 cigarette",
    "\uD83D\uDEAC",

    "26B0 FE0F                                  ; fully-qualified     # ⚰️ coffin",
    "\u26B0\uFE0F",

    "26B0                                       ; non-fully-qualified # ⚰ coffin",
    "\u26B0",

    "26B1 FE0F                                  ; fully-qualified     # ⚱️ funeral urn",
    "\u26B1\uFE0F",

    "26B1                                       ; non-fully-qualified # ⚱ funeral urn",
    "\u26B1",

    "1F5FF                                      ; fully-qualified     # 🗿 moai",
    "\uD83D\uDDFF",

    "1F3E7                                      ; fully-qualified     # 🏧 ATM sign",
    "\uD83C\uDFE7",

    "1F6AE                                      ; fully-qualified     # 🚮 litter in bin sign",
    "\uD83D\uDEAE",

    "1F6B0                                      ; fully-qualified     # 🚰 potable water",
    "\uD83D\uDEB0",

    "267F                                       ; fully-qualified     # ♿ wheelchair symbol",
    "\u267F",

    "1F6B9                                      ; fully-qualified     # 🚹 men’s room",
    "\uD83D\uDEB9",

    "1F6BA                                      ; fully-qualified     # 🚺 women’s room",
    "\uD83D\uDEBA",

    "1F6BB                                      ; fully-qualified     # 🚻 restroom",
    "\uD83D\uDEBB",

    "1F6BC                                      ; fully-qualified     # 🚼 baby symbol",
    "\uD83D\uDEBC",

    "1F6BE                                      ; fully-qualified     # 🚾 water closet",
    "\uD83D\uDEBE",

    "1F6C2                                      ; fully-qualified     # 🛂 passport control",
    "\uD83D\uDEC2",

    "1F6C3                                      ; fully-qualified     # 🛃 customs",
    "\uD83D\uDEC3",

    "1F6C4                                      ; fully-qualified     # 🛄 baggage claim",
    "\uD83D\uDEC4",

    "1F6C5                                      ; fully-qualified     # 🛅 left luggage",
    "\uD83D\uDEC5",

    "26A0 FE0F                                  ; fully-qualified     # ⚠️ warning",
    "\u26A0\uFE0F",

    "26A0                                       ; non-fully-qualified # ⚠ warning",
    "\u26A0",

    "1F6B8                                      ; fully-qualified     # 🚸 children crossing",
    "\uD83D\uDEB8",

    "26D4                                       ; fully-qualified     # ⛔ no entry",
    "\u26D4",

    "1F6AB                                      ; fully-qualified     # 🚫 prohibited",
    "\uD83D\uDEAB",

    "1F6B3                                      ; fully-qualified     # 🚳 no bicycles",
    "\uD83D\uDEB3",

    "1F6AD                                      ; fully-qualified     # 🚭 no smoking",
    "\uD83D\uDEAD",

    "1F6AF                                      ; fully-qualified     # 🚯 no littering",
    "\uD83D\uDEAF",

    "1F6B1                                      ; fully-qualified     # 🚱 non-potable water",
    "\uD83D\uDEB1",

    "1F6B7                                      ; fully-qualified     # 🚷 no pedestrians",
    "\uD83D\uDEB7",

    "1F4F5                                      ; fully-qualified     # 📵 no mobile phones",
    "\uD83D\uDCF5",

    "1F51E                                      ; fully-qualified     # 🔞 no one under eighteen",
    "\uD83D\uDD1E",

    "2622 FE0F                                  ; fully-qualified     # ☢️ radioactive",
    "\u2622\uFE0F",

    "2622                                       ; non-fully-qualified # ☢ radioactive",
    "\u2622",

    "2623 FE0F                                  ; fully-qualified     # ☣️ biohazard",
    "\u2623\uFE0F",

    "2623                                       ; non-fully-qualified # ☣ biohazard",
    "\u2623",

    "2B06 FE0F                                  ; fully-qualified     # ⬆️ up arrow",
    "\u2B06\uFE0F",

    "2B06                                       ; non-fully-qualified # ⬆ up arrow",
    "\u2B06",

    "2197 FE0F                                  ; fully-qualified     # ↗️ up-right arrow",
    "\u2197\uFE0F",

    "2197                                       ; non-fully-qualified # ↗ up-right arrow",
    "\u2197",

    "27A1 FE0F                                  ; fully-qualified     # ➡️ right arrow",
    "\u27A1\uFE0F",

    "27A1                                       ; non-fully-qualified # ➡ right arrow",
    "\u27A1",

    "2198 FE0F                                  ; fully-qualified     # ↘️ down-right arrow",
    "\u2198\uFE0F",

    "2198                                       ; non-fully-qualified # ↘ down-right arrow",
    "\u2198",

    "2B07 FE0F                                  ; fully-qualified     # ⬇️ down arrow",
    "\u2B07\uFE0F",

    "2B07                                       ; non-fully-qualified # ⬇ down arrow",
    "\u2B07",

    "2199 FE0F                                  ; fully-qualified     # ↙️ down-left arrow",
    "\u2199\uFE0F",

    "2199                                       ; non-fully-qualified # ↙ down-left arrow",
    "\u2199",

    "2B05 FE0F                                  ; fully-qualified     # ⬅️ left arrow",
    "\u2B05\uFE0F",

    "2B05                                       ; non-fully-qualified # ⬅ left arrow",
    "\u2B05",

    "2196 FE0F                                  ; fully-qualified     # ↖️ up-left arrow",
    "\u2196\uFE0F",

    "2196                                       ; non-fully-qualified # ↖ up-left arrow",
    "\u2196",

    "2195 FE0F                                  ; fully-qualified     # ↕️ up-down arrow",
    "\u2195\uFE0F",

    "2195                                       ; non-fully-qualified # ↕ up-down arrow",
    "\u2195",

    "2194 FE0F                                  ; fully-qualified     # ↔️ left-right arrow",
    "\u2194\uFE0F",

    "2194                                       ; non-fully-qualified # ↔ left-right arrow",
    "\u2194",

    "21A9 FE0F                                  ; fully-qualified     # ↩️ right arrow curving left",
    "\u21A9\uFE0F",

    "21A9                                       ; non-fully-qualified # ↩ right arrow curving left",
    "\u21A9",

    "21AA FE0F                                  ; fully-qualified     # ↪️ left arrow curving right",
    "\u21AA\uFE0F",

    "21AA                                       ; non-fully-qualified # ↪ left arrow curving right",
    "\u21AA",

    "2934 FE0F                                  ; fully-qualified     # ⤴️ right arrow curving up",
    "\u2934\uFE0F",

    "2934                                       ; non-fully-qualified # ⤴ right arrow curving up",
    "\u2934",

    "2935 FE0F                                  ; fully-qualified     # ⤵️ right arrow curving down",
    "\u2935\uFE0F",

    "2935                                       ; non-fully-qualified # ⤵ right arrow curving down",
    "\u2935",

    "1F503                                      ; fully-qualified     # 🔃 clockwise vertical arrows",
    "\uD83D\uDD03",

    "1F504                                      ; fully-qualified     # 🔄 counterclockwise arrows button",
    "\uD83D\uDD04",

    "1F519                                      ; fully-qualified     # 🔙 BACK arrow",
    "\uD83D\uDD19",

    "1F51A                                      ; fully-qualified     # 🔚 END arrow",
    "\uD83D\uDD1A",

    "1F51B                                      ; fully-qualified     # 🔛 ON! arrow",
    "\uD83D\uDD1B",

    "1F51C                                      ; fully-qualified     # 🔜 SOON arrow",
    "\uD83D\uDD1C",

    "1F51D                                      ; fully-qualified     # 🔝 TOP arrow",
    "\uD83D\uDD1D",

    "1F6D0                                      ; fully-qualified     # 🛐 place of worship",
    "\uD83D\uDED0",

    "269B FE0F                                  ; fully-qualified     # ⚛️ atom symbol",
    "\u269B\uFE0F",

    "269B                                       ; non-fully-qualified # ⚛ atom symbol",
    "\u269B",

    "1F549 FE0F                                 ; fully-qualified     # 🕉️ om",
    "\uD83D\uDD49\uFE0F",

    "1F549                                      ; non-fully-qualified # 🕉 om",
    "\uD83D\uDD49",

    "2721 FE0F                                  ; fully-qualified     # ✡️ star of David",
    "\u2721\uFE0F",

    "2721                                       ; non-fully-qualified # ✡ star of David",
    "\u2721",

    "2638 FE0F                                  ; fully-qualified     # ☸️ wheel of dharma",
    "\u2638\uFE0F",

    "2638                                       ; non-fully-qualified # ☸ wheel of dharma",
    "\u2638",

    "262F FE0F                                  ; fully-qualified     # ☯️ yin yang",
    "\u262F\uFE0F",

    "262F                                       ; non-fully-qualified # ☯ yin yang",
    "\u262F",

    "271D FE0F                                  ; fully-qualified     # ✝️ latin cross",
    "\u271D\uFE0F",

    "271D                                       ; non-fully-qualified # ✝ latin cross",
    "\u271D",

    "2626 FE0F                                  ; fully-qualified     # ☦️ orthodox cross",
    "\u2626\uFE0F",

    "2626                                       ; non-fully-qualified # ☦ orthodox cross",
    "\u2626",

    "262A FE0F                                  ; fully-qualified     # ☪️ star and crescent",
    "\u262A\uFE0F",

    "262A                                       ; non-fully-qualified # ☪ star and crescent",
    "\u262A",

    "262E FE0F                                  ; fully-qualified     # ☮️ peace symbol",
    "\u262E\uFE0F",

    "262E                                       ; non-fully-qualified # ☮ peace symbol",
    "\u262E",

    "1F54E                                      ; fully-qualified     # 🕎 menorah",
    "\uD83D\uDD4E",

    "1F52F                                      ; fully-qualified     # 🔯 dotted six-pointed star",
    "\uD83D\uDD2F",

    "2648                                       ; fully-qualified     # ♈ Aries",
    "\u2648",

    "2649                                       ; fully-qualified     # ♉ Taurus",
    "\u2649",

    "264A                                       ; fully-qualified     # ♊ Gemini",
    "\u264A",

    "264B                                       ; fully-qualified     # ♋ Cancer",
    "\u264B",

    "264C                                       ; fully-qualified     # ♌ Leo",
    "\u264C",

    "264D                                       ; fully-qualified     # ♍ Virgo",
    "\u264D",

    "264E                                       ; fully-qualified     # ♎ Libra",
    "\u264E",

    "264F                                       ; fully-qualified     # ♏ Scorpio",
    "\u264F",

    "2650                                       ; fully-qualified     # ♐ Sagittarius",
    "\u2650",

    "2651                                       ; fully-qualified     # ♑ Capricorn",
    "\u2651",

    "2652                                       ; fully-qualified     # ♒ Aquarius",
    "\u2652",

    "2653                                       ; fully-qualified     # ♓ Pisces",
    "\u2653",

    "26CE                                       ; fully-qualified     # ⛎ Ophiuchus",
    "\u26CE",

    "1F500                                      ; fully-qualified     # 🔀 shuffle tracks button",
    "\uD83D\uDD00",

    "1F501                                      ; fully-qualified     # 🔁 repeat button",
    "\uD83D\uDD01",

    "1F502                                      ; fully-qualified     # 🔂 repeat single button",
    "\uD83D\uDD02",

    "25B6 FE0F                                  ; fully-qualified     # ▶️ play button",
    "\u25B6\uFE0F",

    "25B6                                       ; non-fully-qualified # ▶ play button",
    "\u25B6",

    "23E9                                       ; fully-qualified     # ⏩ fast-forward button",
    "\u23E9",

    "23ED FE0F                                  ; fully-qualified     # ⏭️ next track button",
    "\u23ED\uFE0F",

    "23ED                                       ; non-fully-qualified # ⏭ next track button",
    "\u23ED",

    "23EF FE0F                                  ; fully-qualified     # ⏯️ play or pause button",
    "\u23EF\uFE0F",

    "23EF                                       ; non-fully-qualified # ⏯ play or pause button",
    "\u23EF",

    "25C0 FE0F                                  ; fully-qualified     # ◀️ reverse button",
    "\u25C0\uFE0F",

    "25C0                                       ; non-fully-qualified # ◀ reverse button",
    "\u25C0",

    "23EA                                       ; fully-qualified     # ⏪ fast reverse button",
    "\u23EA",

    "23EE FE0F                                  ; fully-qualified     # ⏮️ last track button",
    "\u23EE\uFE0F",

    "23EE                                       ; non-fully-qualified # ⏮ last track button",
    "\u23EE",

    "1F53C                                      ; fully-qualified     # 🔼 upwards button",
    "\uD83D\uDD3C",

    "23EB                                       ; fully-qualified     # ⏫ fast up button",
    "\u23EB",

    "1F53D                                      ; fully-qualified     # 🔽 downwards button",
    "\uD83D\uDD3D",

    "23EC                                       ; fully-qualified     # ⏬ fast down button",
    "\u23EC",

    "23F8 FE0F                                  ; fully-qualified     # ⏸️ pause button",
    "\u23F8\uFE0F",

    "23F8                                       ; non-fully-qualified # ⏸ pause button",
    "\u23F8",

    "23F9 FE0F                                  ; fully-qualified     # ⏹️ stop button",
    "\u23F9\uFE0F",

    "23F9                                       ; non-fully-qualified # ⏹ stop button",
    "\u23F9",

    "23FA FE0F                                  ; fully-qualified     # ⏺️ record button",
    "\u23FA\uFE0F",

    "23FA                                       ; non-fully-qualified # ⏺ record button",
    "\u23FA",

    "23CF FE0F                                  ; fully-qualified     # ⏏️ eject button",
    "\u23CF\uFE0F",

    "23CF                                       ; non-fully-qualified # ⏏ eject button",
    "\u23CF",

    "1F3A6                                      ; fully-qualified     # 🎦 cinema",
    "\uD83C\uDFA6",

    "1F505                                      ; fully-qualified     # 🔅 dim button",
    "\uD83D\uDD05",

    "1F506                                      ; fully-qualified     # 🔆 bright button",
    "\uD83D\uDD06",

    "1F4F6                                      ; fully-qualified     # 📶 antenna bars",
    "\uD83D\uDCF6",

    "1F4F3                                      ; fully-qualified     # 📳 vibration mode",
    "\uD83D\uDCF3",

    "1F4F4                                      ; fully-qualified     # 📴 mobile phone off",
    "\uD83D\uDCF4",

    "2640 FE0F                                  ; fully-qualified     # ♀️ female sign",
    "\u2640\uFE0F",

    "2640                                       ; non-fully-qualified # ♀ female sign",
    "\u2640",

    "2642 FE0F                                  ; fully-qualified     # ♂️ male sign",
    "\u2642\uFE0F",

    "2642                                       ; non-fully-qualified # ♂ male sign",
    "\u2642",

    "2695 FE0F                                  ; fully-qualified     # ⚕️ medical symbol",
    "\u2695\uFE0F",

    "2695                                       ; non-fully-qualified # ⚕ medical symbol",
    "\u2695",

    "267E FE0F                                  ; fully-qualified     # ♾️ infinity",
    "\u267E\uFE0F",

    "267E                                       ; non-fully-qualified # ♾ infinity",
    "\u267E",

    "267B FE0F                                  ; fully-qualified     # ♻️ recycling symbol",
    "\u267B\uFE0F",

    "267B                                       ; non-fully-qualified # ♻ recycling symbol",
    "\u267B",

    "269C FE0F                                  ; fully-qualified     # ⚜️ fleur-de-lis",
    "\u269C\uFE0F",

    "269C                                       ; non-fully-qualified # ⚜ fleur-de-lis",
    "\u269C",

    "1F531                                      ; fully-qualified     # 🔱 trident emblem",
    "\uD83D\uDD31",

    "1F4DB                                      ; fully-qualified     # 📛 name badge",
    "\uD83D\uDCDB",

    "1F530                                      ; fully-qualified     # 🔰 Japanese symbol for beginner",
    "\uD83D\uDD30",

    "2B55                                       ; fully-qualified     # ⭕ heavy large circle",
    "\u2B55",

    "2705                                       ; fully-qualified     # ✅ white heavy check mark",
    "\u2705",

    "2611 FE0F                                  ; fully-qualified     # ☑️ ballot box with check",
    "\u2611\uFE0F",

    "2611                                       ; non-fully-qualified # ☑ ballot box with check",
    "\u2611",

    "2714 FE0F                                  ; fully-qualified     # ✔️ heavy check mark",
    "\u2714\uFE0F",

    "2714                                       ; non-fully-qualified # ✔ heavy check mark",
    "\u2714",

    "2716 FE0F                                  ; fully-qualified     # ✖️ heavy multiplication x",
    "\u2716\uFE0F",

    "2716                                       ; non-fully-qualified # ✖ heavy multiplication x",
    "\u2716",

    "274C                                       ; fully-qualified     # ❌ cross mark",
    "\u274C",

    "274E                                       ; fully-qualified     # ❎ cross mark button",
    "\u274E",

    "2795                                       ; fully-qualified     # ➕ heavy plus sign",
    "\u2795",

    "2796                                       ; fully-qualified     # ➖ heavy minus sign",
    "\u2796",

    "2797                                       ; fully-qualified     # ➗ heavy division sign",
    "\u2797",

    "27B0                                       ; fully-qualified     # ➰ curly loop",
    "\u27B0",

    "27BF                                       ; fully-qualified     # ➿ double curly loop",
    "\u27BF",

    "303D FE0F                                  ; fully-qualified     # 〽️ part alternation mark",
    "\u303D\uFE0F",

    "303D                                       ; non-fully-qualified # 〽 part alternation mark",
    "\u303D",

    "2733 FE0F                                  ; fully-qualified     # ✳️ eight-spoked asterisk",
    "\u2733\uFE0F",

    "2733                                       ; non-fully-qualified # ✳ eight-spoked asterisk",
    "\u2733",

    "2734 FE0F                                  ; fully-qualified     # ✴️ eight-pointed star",
    "\u2734\uFE0F",

    "2734                                       ; non-fully-qualified # ✴ eight-pointed star",
    "\u2734",

    "2747 FE0F                                  ; fully-qualified     # ❇️ sparkle",
    "\u2747\uFE0F",

    "2747                                       ; non-fully-qualified # ❇ sparkle",
    "\u2747",

    "203C FE0F                                  ; fully-qualified     # ‼️ double exclamation mark",
    "\u203C\uFE0F",

    "203C                                       ; non-fully-qualified # ‼ double exclamation mark",
    "\u203C",

    "2049 FE0F                                  ; fully-qualified     # ⁉️ exclamation question mark",
    "\u2049\uFE0F",

    "2049                                       ; non-fully-qualified # ⁉ exclamation question mark",
    "\u2049",

    "2753                                       ; fully-qualified     # ❓ question mark",
    "\u2753",

    "2754                                       ; fully-qualified     # ❔ white question mark",
    "\u2754",

    "2755                                       ; fully-qualified     # ❕ white exclamation mark",
    "\u2755",

    "2757                                       ; fully-qualified     # ❗ exclamation mark",
    "\u2757",

    "3030 FE0F                                  ; fully-qualified     # 〰️ wavy dash",
    "\u3030\uFE0F",

    "3030                                       ; non-fully-qualified # 〰 wavy dash",
    "\u3030",

    "00A9 FE0F                                  ; fully-qualified     # ©️ copyright",
    "\u00A9\uFE0F",

    "00A9                                       ; non-fully-qualified # © copyright",
    "\u00A9",

    "00AE FE0F                                  ; fully-qualified     # ®️ registered",
    "\u00AE\uFE0F",

    "00AE                                       ; non-fully-qualified # ® registered",
    "\u00AE",

    "2122 FE0F                                  ; fully-qualified     # ™️ trade mark",
    "\u2122\uFE0F",

    "2122                                       ; non-fully-qualified # ™ trade mark",
    "\u2122",

    "0023 FE0F 20E3                             ; fully-qualified     # #️⃣ keycap: #",
    "\u0023\uFE0F\u20E3",

    "0023 20E3                                  ; non-fully-qualified # #⃣ keycap: #",
    "\u0023\u20E3",

    "002A FE0F 20E3                             ; fully-qualified     # *️⃣ keycap: *",
    "\u002A\uFE0F\u20E3",

    "002A 20E3                                  ; non-fully-qualified # *⃣ keycap: *",
    "\u002A\u20E3",

    "0030 FE0F 20E3                             ; fully-qualified     # 0️⃣ keycap: 0",
    "\u0030\uFE0F\u20E3",

    "0030 20E3                                  ; non-fully-qualified # 0⃣ keycap: 0",
    "\u0030\u20E3",

    "0031 FE0F 20E3                             ; fully-qualified     # 1️⃣ keycap: 1",
    "\u0031\uFE0F\u20E3",

    "0031 20E3                                  ; non-fully-qualified # 1⃣ keycap: 1",
    "\u0031\u20E3",

    "0032 FE0F 20E3                             ; fully-qualified     # 2️⃣ keycap: 2",
    "\u0032\uFE0F\u20E3",

    "0032 20E3                                  ; non-fully-qualified # 2⃣ keycap: 2",
    "\u0032\u20E3",

    "0033 FE0F 20E3                             ; fully-qualified     # 3️⃣ keycap: 3",
    "\u0033\uFE0F\u20E3",

    "0033 20E3                                  ; non-fully-qualified # 3⃣ keycap: 3",
    "\u0033\u20E3",

    "0034 FE0F 20E3                             ; fully-qualified     # 4️⃣ keycap: 4",
    "\u0034\uFE0F\u20E3",

    "0034 20E3                                  ; non-fully-qualified # 4⃣ keycap: 4",
    "\u0034\u20E3",

    "0035 FE0F 20E3                             ; fully-qualified     # 5️⃣ keycap: 5",
    "\u0035\uFE0F\u20E3",

    "0035 20E3                                  ; non-fully-qualified # 5⃣ keycap: 5",
    "\u0035\u20E3",

    "0036 FE0F 20E3                             ; fully-qualified     # 6️⃣ keycap: 6",
    "\u0036\uFE0F\u20E3",

    "0036 20E3                                  ; non-fully-qualified # 6⃣ keycap: 6",
    "\u0036\u20E3",

    "0037 FE0F 20E3                             ; fully-qualified     # 7️⃣ keycap: 7",
    "\u0037\uFE0F\u20E3",

    "0037 20E3                                  ; non-fully-qualified # 7⃣ keycap: 7",
    "\u0037\u20E3",

    "0038 FE0F 20E3                             ; fully-qualified     # 8️⃣ keycap: 8",
    "\u0038\uFE0F\u20E3",

    "0038 20E3                                  ; non-fully-qualified # 8⃣ keycap: 8",
    "\u0038\u20E3",

    "0039 FE0F 20E3                             ; fully-qualified     # 9️⃣ keycap: 9",
    "\u0039\uFE0F\u20E3",

    "0039 20E3                                  ; non-fully-qualified # 9⃣ keycap: 9",
    "\u0039\u20E3",

    "1F51F                                      ; fully-qualified     # 🔟 keycap: 10",
    "\uD83D\uDD1F",

    "1F4AF                                      ; fully-qualified     # 💯 hundred points",
    "\uD83D\uDCAF",

    "1F520                                      ; fully-qualified     # 🔠 input latin uppercase",
    "\uD83D\uDD20",

    "1F521                                      ; fully-qualified     # 🔡 input latin lowercase",
    "\uD83D\uDD21",

    "1F522                                      ; fully-qualified     # 🔢 input numbers",
    "\uD83D\uDD22",

    "1F523                                      ; fully-qualified     # 🔣 input symbols",
    "\uD83D\uDD23",

    "1F524                                      ; fully-qualified     # 🔤 input latin letters",
    "\uD83D\uDD24",

    "1F170 FE0F                                 ; fully-qualified     # 🅰️ A button (blood type)",
    "\uD83C\uDD70\uFE0F",

    "1F170                                      ; non-fully-qualified # 🅰 A button (blood type)",
    "\uD83C\uDD70",

    "1F18E                                      ; fully-qualified     # 🆎 AB button (blood type)",
    "\uD83C\uDD8E",

    "1F171 FE0F                                 ; fully-qualified     # 🅱️ B button (blood type)",
    "\uD83C\uDD71\uFE0F",

    "1F171                                      ; non-fully-qualified # 🅱 B button (blood type)",
    "\uD83C\uDD71",

    "1F191                                      ; fully-qualified     # 🆑 CL button",
    "\uD83C\uDD91",

    "1F192                                      ; fully-qualified     # 🆒 COOL button",
    "\uD83C\uDD92",

    "1F193                                      ; fully-qualified     # 🆓 FREE button",
    "\uD83C\uDD93",

    "2139 FE0F                                  ; fully-qualified     # ℹ️ information",
    "\u2139\uFE0F",

    "2139                                       ; non-fully-qualified # ℹ information",
    "\u2139",

    "1F194                                      ; fully-qualified     # 🆔 ID button",
    "\uD83C\uDD94",

    "24C2 FE0F                                  ; fully-qualified     # Ⓜ️ circled M",
    "\u24C2\uFE0F",

    "24C2                                       ; non-fully-qualified # Ⓜ circled M",
    "\u24C2",

    "1F195                                      ; fully-qualified     # 🆕 NEW button",
    "\uD83C\uDD95",

    "1F196                                      ; fully-qualified     # 🆖 NG button",
    "\uD83C\uDD96",

    "1F17E FE0F                                 ; fully-qualified     # 🅾️ O button (blood type)",
    "\uD83C\uDD7E\uFE0F",

    "1F17E                                      ; non-fully-qualified # 🅾 O button (blood type)",
    "\uD83C\uDD7E",

    "1F197                                      ; fully-qualified     # 🆗 OK button",
    "\uD83C\uDD97",

    "1F17F FE0F                                 ; fully-qualified     # 🅿️ P button",
    "\uD83C\uDD7F\uFE0F",

    "1F17F                                      ; non-fully-qualified # 🅿 P button",
    "\uD83C\uDD7F",

    "1F198                                      ; fully-qualified     # 🆘 SOS button",
    "\uD83C\uDD98",

    "1F199                                      ; fully-qualified     # 🆙 UP! button",
    "\uD83C\uDD99",

    "1F19A                                      ; fully-qualified     # 🆚 VS button",
    "\uD83C\uDD9A",

    "1F201                                      ; fully-qualified     # 🈁 Japanese “here” button",
    "\uD83C\uDE01",

    "1F202 FE0F                                 ; fully-qualified     # 🈂️ Japanese “service charge” button",
    "\uD83C\uDE02\uFE0F",

    "1F202                                      ; non-fully-qualified # 🈂 Japanese “service charge” button",
    "\uD83C\uDE02",

    "1F237 FE0F                                 ; fully-qualified     # 🈷️ Japanese “monthly amount” button",
    "\uD83C\uDE37\uFE0F",

    "1F237                                      ; non-fully-qualified # 🈷 Japanese “monthly amount” button",
    "\uD83C\uDE37",

    "1F236                                      ; fully-qualified     # 🈶 Japanese “not free of charge” button",
    "\uD83C\uDE36",

    "1F22F                                      ; fully-qualified     # 🈯 Japanese “reserved” button",
    "\uD83C\uDE2F",

    "1F250                                      ; fully-qualified     # 🉐 Japanese “bargain” button",
    "\uD83C\uDE50",

    "1F239                                      ; fully-qualified     # 🈹 Japanese “discount” button",
    "\uD83C\uDE39",

    "1F21A                                      ; fully-qualified     # 🈚 Japanese “free of charge” button",
    "\uD83C\uDE1A",

    "1F232                                      ; fully-qualified     # 🈲 Japanese “prohibited” button",
    "\uD83C\uDE32",

    "1F251                                      ; fully-qualified     # 🉑 Japanese “acceptable” button",
    "\uD83C\uDE51",

    "1F238                                      ; fully-qualified     # 🈸 Japanese “application” button",
    "\uD83C\uDE38",

    "1F234                                      ; fully-qualified     # 🈴 Japanese “passing grade” button",
    "\uD83C\uDE34",

    "1F233                                      ; fully-qualified     # 🈳 Japanese “vacancy” button",
    "\uD83C\uDE33",

    "3297 FE0F                                  ; fully-qualified     # ㊗️ Japanese “congratulations” button",
    "\u3297\uFE0F",

    "3297                                       ; non-fully-qualified # ㊗ Japanese “congratulations” button",
    "\u3297",

    "3299 FE0F                                  ; fully-qualified     # ㊙️ Japanese “secret” button",
    "\u3299\uFE0F",

    "3299                                       ; non-fully-qualified # ㊙ Japanese “secret” button",
    "\u3299",

    "1F23A                                      ; fully-qualified     # 🈺 Japanese “open for business” button",
    "\uD83C\uDE3A",

    "1F235                                      ; fully-qualified     # 🈵 Japanese “no vacancy” button",
    "\uD83C\uDE35",

    "25AA FE0F                                  ; fully-qualified     # ▪️ black small square",
    "\u25AA\uFE0F",

    "25AA                                       ; non-fully-qualified # ▪ black small square",
    "\u25AA",

    "25AB FE0F                                  ; fully-qualified     # ▫️ white small square",
    "\u25AB\uFE0F",

    "25AB                                       ; non-fully-qualified # ▫ white small square",
    "\u25AB",

    "25FB FE0F                                  ; fully-qualified     # ◻️ white medium square",
    "\u25FB\uFE0F",

    "25FB                                       ; non-fully-qualified # ◻ white medium square",
    "\u25FB",

    "25FC FE0F                                  ; fully-qualified     # ◼️ black medium square",
    "\u25FC\uFE0F",

    "25FC                                       ; non-fully-qualified # ◼ black medium square",
    "\u25FC",

    "25FD                                       ; fully-qualified     # ◽ white medium-small square",
    "\u25FD",

    "25FE                                       ; fully-qualified     # ◾ black medium-small square",
    "\u25FE",

    "2B1B                                       ; fully-qualified     # ⬛ black large square",
    "\u2B1B",

    "2B1C                                       ; fully-qualified     # ⬜ white large square",
    "\u2B1C",

    "1F536                                      ; fully-qualified     # 🔶 large orange diamond",
    "\uD83D\uDD36",

    "1F537                                      ; fully-qualified     # 🔷 large blue diamond",
    "\uD83D\uDD37",

    "1F538                                      ; fully-qualified     # 🔸 small orange diamond",
    "\uD83D\uDD38",

    "1F539                                      ; fully-qualified     # 🔹 small blue diamond",
    "\uD83D\uDD39",

    "1F53A                                      ; fully-qualified     # 🔺 red triangle pointed up",
    "\uD83D\uDD3A",

    "1F53B                                      ; fully-qualified     # 🔻 red triangle pointed down",
    "\uD83D\uDD3B",

    "1F4A0                                      ; fully-qualified     # 💠 diamond with a dot",
    "\uD83D\uDCA0",

    "1F518                                      ; fully-qualified     # 🔘 radio button",
    "\uD83D\uDD18",

    "1F532                                      ; fully-qualified     # 🔲 black square button",
    "\uD83D\uDD32",

    "1F533                                      ; fully-qualified     # 🔳 white square button",
    "\uD83D\uDD33",

    "26AA                                       ; fully-qualified     # ⚪ white circle",
    "\u26AA",

    "26AB                                       ; fully-qualified     # ⚫ black circle",
    "\u26AB",

    "1F534                                      ; fully-qualified     # 🔴 red circle",
    "\uD83D\uDD34",

    "1F535                                      ; fully-qualified     # 🔵 blue circle",
    "\uD83D\uDD35",

    "1F3C1                                      ; fully-qualified     # 🏁 chequered flag",
    "\uD83C\uDFC1",

    "1F6A9                                      ; fully-qualified     # 🚩 triangular flag",
    "\uD83D\uDEA9",

    "1F38C                                      ; fully-qualified     # 🎌 crossed flags",
    "\uD83C\uDF8C",

    "1F3F4                                      ; fully-qualified     # 🏴 black flag",
    "\uD83C\uDFF4",

    "1F3F3 FE0F                                 ; fully-qualified     # 🏳️ white flag",
    "\uD83C\uDFF3\uFE0F",

    "1F3F3                                      ; non-fully-qualified # 🏳 white flag",
    "\uD83C\uDFF3",

    "1F3F3 FE0F 200D 1F308                      ; fully-qualified     # 🏳️‍🌈 rainbow flag",
    "\uD83C\uDFF3\uFE0F\u200D\uD83C\uDF08",

    "1F3F3 200D 1F308                           ; non-fully-qualified # 🏳‍🌈 rainbow flag",
    "\uD83C\uDFF3\u200D\uD83C\uDF08",

    "1F3F4 200D 2620 FE0F                       ; fully-qualified     # 🏴‍☠️ pirate flag",
    "\uD83C\uDFF4\u200D\u2620\uFE0F",

    "1F3F4 200D 2620                            ; non-fully-qualified # 🏴‍☠ pirate flag",
    "\uD83C\uDFF4\u200D\u2620",

    "1F1E6 1F1E8                                ; fully-qualified     # 🇦🇨 Ascension Island",
    "\uD83C\uDDE6\uD83C\uDDE8",

    "1F1E6 1F1E9                                ; fully-qualified     # 🇦🇩 Andorra",
    "\uD83C\uDDE6\uD83C\uDDE9",

    "1F1E6 1F1EA                                ; fully-qualified     # 🇦🇪 United Arab Emirates",
    "\uD83C\uDDE6\uD83C\uDDEA",

    "1F1E6 1F1EB                                ; fully-qualified     # 🇦🇫 Afghanistan",
    "\uD83C\uDDE6\uD83C\uDDEB",

    "1F1E6 1F1EC                                ; fully-qualified     # 🇦🇬 Antigua & Barbuda",
    "\uD83C\uDDE6\uD83C\uDDEC",

    "1F1E6 1F1EE                                ; fully-qualified     # 🇦🇮 Anguilla",
    "\uD83C\uDDE6\uD83C\uDDEE",

    "1F1E6 1F1F1                                ; fully-qualified     # 🇦🇱 Albania",
    "\uD83C\uDDE6\uD83C\uDDF1",

    "1F1E6 1F1F2                                ; fully-qualified     # 🇦🇲 Armenia",
    "\uD83C\uDDE6\uD83C\uDDF2",

    "1F1E6 1F1F4                                ; fully-qualified     # 🇦🇴 Angola",
    "\uD83C\uDDE6\uD83C\uDDF4",

    "1F1E6 1F1F6                                ; fully-qualified     # 🇦🇶 Antarctica",
    "\uD83C\uDDE6\uD83C\uDDF6",

    "1F1E6 1F1F7                                ; fully-qualified     # 🇦🇷 Argentina",
    "\uD83C\uDDE6\uD83C\uDDF7",

    "1F1E6 1F1F8                                ; fully-qualified     # 🇦🇸 American Samoa",
    "\uD83C\uDDE6\uD83C\uDDF8",

    "1F1E6 1F1F9                                ; fully-qualified     # 🇦🇹 Austria",
    "\uD83C\uDDE6\uD83C\uDDF9",

    "1F1E6 1F1FA                                ; fully-qualified     # 🇦🇺 Australia",
    "\uD83C\uDDE6\uD83C\uDDFA",

    "1F1E6 1F1FC                                ; fully-qualified     # 🇦🇼 Aruba",
    "\uD83C\uDDE6\uD83C\uDDFC",

    "1F1E6 1F1FD                                ; fully-qualified     # 🇦🇽 Åland Islands",
    "\uD83C\uDDE6\uD83C\uDDFD",

    "1F1E6 1F1FF                                ; fully-qualified     # 🇦🇿 Azerbaijan",
    "\uD83C\uDDE6\uD83C\uDDFF",

    "1F1E7 1F1E6                                ; fully-qualified     # 🇧🇦 Bosnia & Herzegovina",
    "\uD83C\uDDE7\uD83C\uDDE6",

    "1F1E7 1F1E7                                ; fully-qualified     # 🇧🇧 Barbados",
    "\uD83C\uDDE7\uD83C\uDDE7",

    "1F1E7 1F1E9                                ; fully-qualified     # 🇧🇩 Bangladesh",
    "\uD83C\uDDE7\uD83C\uDDE9",

    "1F1E7 1F1EA                                ; fully-qualified     # 🇧🇪 Belgium",
    "\uD83C\uDDE7\uD83C\uDDEA",

    "1F1E7 1F1EB                                ; fully-qualified     # 🇧🇫 Burkina Faso",
    "\uD83C\uDDE7\uD83C\uDDEB",

    "1F1E7 1F1EC                                ; fully-qualified     # 🇧🇬 Bulgaria",
    "\uD83C\uDDE7\uD83C\uDDEC",

    "1F1E7 1F1ED                                ; fully-qualified     # 🇧🇭 Bahrain",
    "\uD83C\uDDE7\uD83C\uDDED",

    "1F1E7 1F1EE                                ; fully-qualified     # 🇧🇮 Burundi",
    "\uD83C\uDDE7\uD83C\uDDEE",

    "1F1E7 1F1EF                                ; fully-qualified     # 🇧🇯 Benin",
    "\uD83C\uDDE7\uD83C\uDDEF",

    "1F1E7 1F1F1                                ; fully-qualified     # 🇧🇱 St. Barthélemy",
    "\uD83C\uDDE7\uD83C\uDDF1",

    "1F1E7 1F1F2                                ; fully-qualified     # 🇧🇲 Bermuda",
    "\uD83C\uDDE7\uD83C\uDDF2",

    "1F1E7 1F1F3                                ; fully-qualified     # 🇧🇳 Brunei",
    "\uD83C\uDDE7\uD83C\uDDF3",

    "1F1E7 1F1F4                                ; fully-qualified     # 🇧🇴 Bolivia",
    "\uD83C\uDDE7\uD83C\uDDF4",

    "1F1E7 1F1F6                                ; fully-qualified     # 🇧🇶 Caribbean Netherlands",
    "\uD83C\uDDE7\uD83C\uDDF6",

    "1F1E7 1F1F7                                ; fully-qualified     # 🇧🇷 Brazil",
    "\uD83C\uDDE7\uD83C\uDDF7",

    "1F1E7 1F1F8                                ; fully-qualified     # 🇧🇸 Bahamas",
    "\uD83C\uDDE7\uD83C\uDDF8",

    "1F1E7 1F1F9                                ; fully-qualified     # 🇧🇹 Bhutan",
    "\uD83C\uDDE7\uD83C\uDDF9",

    "1F1E7 1F1FB                                ; fully-qualified     # 🇧🇻 Bouvet Island",
    "\uD83C\uDDE7\uD83C\uDDFB",

    "1F1E7 1F1FC                                ; fully-qualified     # 🇧🇼 Botswana",
    "\uD83C\uDDE7\uD83C\uDDFC",

    "1F1E7 1F1FE                                ; fully-qualified     # 🇧🇾 Belarus",
    "\uD83C\uDDE7\uD83C\uDDFE",

    "1F1E7 1F1FF                                ; fully-qualified     # 🇧🇿 Belize",
    "\uD83C\uDDE7\uD83C\uDDFF",

    "1F1E8 1F1E6                                ; fully-qualified     # 🇨🇦 Canada",
    "\uD83C\uDDE8\uD83C\uDDE6",

    "1F1E8 1F1E8                                ; fully-qualified     # 🇨🇨 Cocos (Keeling) Islands",
    "\uD83C\uDDE8\uD83C\uDDE8",

    "1F1E8 1F1E9                                ; fully-qualified     # 🇨🇩 Congo - Kinshasa",
    "\uD83C\uDDE8\uD83C\uDDE9",

    "1F1E8 1F1EB                                ; fully-qualified     # 🇨🇫 Central African Republic",
    "\uD83C\uDDE8\uD83C\uDDEB",

    "1F1E8 1F1EC                                ; fully-qualified     # 🇨🇬 Congo - Brazzaville",
    "\uD83C\uDDE8\uD83C\uDDEC",

    "1F1E8 1F1ED                                ; fully-qualified     # 🇨🇭 Switzerland",
    "\uD83C\uDDE8\uD83C\uDDED",

    "1F1E8 1F1EE                                ; fully-qualified     # 🇨🇮 Côte d’Ivoire",
    "\uD83C\uDDE8\uD83C\uDDEE",

    "1F1E8 1F1F0                                ; fully-qualified     # 🇨🇰 Cook Islands",
    "\uD83C\uDDE8\uD83C\uDDF0",

    "1F1E8 1F1F1                                ; fully-qualified     # 🇨🇱 Chile",
    "\uD83C\uDDE8\uD83C\uDDF1",

    "1F1E8 1F1F2                                ; fully-qualified     # 🇨🇲 Cameroon",
    "\uD83C\uDDE8\uD83C\uDDF2",

    "1F1E8 1F1F3                                ; fully-qualified     # 🇨🇳 China",
    "\uD83C\uDDE8\uD83C\uDDF3",

    "1F1E8 1F1F4                                ; fully-qualified     # 🇨🇴 Colombia",
    "\uD83C\uDDE8\uD83C\uDDF4",

    "1F1E8 1F1F5                                ; fully-qualified     # 🇨🇵 Clipperton Island",
    "\uD83C\uDDE8\uD83C\uDDF5",

    "1F1E8 1F1F7                                ; fully-qualified     # 🇨🇷 Costa Rica",
    "\uD83C\uDDE8\uD83C\uDDF7",

    "1F1E8 1F1FA                                ; fully-qualified     # 🇨🇺 Cuba",
    "\uD83C\uDDE8\uD83C\uDDFA",

    "1F1E8 1F1FB                                ; fully-qualified     # 🇨🇻 Cape Verde",
    "\uD83C\uDDE8\uD83C\uDDFB",

    "1F1E8 1F1FC                                ; fully-qualified     # 🇨🇼 Curaçao",
    "\uD83C\uDDE8\uD83C\uDDFC",

    "1F1E8 1F1FD                                ; fully-qualified     # 🇨🇽 Christmas Island",
    "\uD83C\uDDE8\uD83C\uDDFD",

    "1F1E8 1F1FE                                ; fully-qualified     # 🇨🇾 Cyprus",
    "\uD83C\uDDE8\uD83C\uDDFE",

    "1F1E8 1F1FF                                ; fully-qualified     # 🇨🇿 Czechia",
    "\uD83C\uDDE8\uD83C\uDDFF",

    "1F1E9 1F1EA                                ; fully-qualified     # 🇩🇪 Germany",
    "\uD83C\uDDE9\uD83C\uDDEA",

    "1F1E9 1F1EC                                ; fully-qualified     # 🇩🇬 Diego Garcia",
    "\uD83C\uDDE9\uD83C\uDDEC",

    "1F1E9 1F1EF                                ; fully-qualified     # 🇩🇯 Djibouti",
    "\uD83C\uDDE9\uD83C\uDDEF",

    "1F1E9 1F1F0                                ; fully-qualified     # 🇩🇰 Denmark",
    "\uD83C\uDDE9\uD83C\uDDF0",

    "1F1E9 1F1F2                                ; fully-qualified     # 🇩🇲 Dominica",
    "\uD83C\uDDE9\uD83C\uDDF2",

    "1F1E9 1F1F4                                ; fully-qualified     # 🇩🇴 Dominican Republic",
    "\uD83C\uDDE9\uD83C\uDDF4",

    "1F1E9 1F1FF                                ; fully-qualified     # 🇩🇿 Algeria",
    "\uD83C\uDDE9\uD83C\uDDFF",

    "1F1EA 1F1E6                                ; fully-qualified     # 🇪🇦 Ceuta & Melilla",
    "\uD83C\uDDEA\uD83C\uDDE6",

    "1F1EA 1F1E8                                ; fully-qualified     # 🇪🇨 Ecuador",
    "\uD83C\uDDEA\uD83C\uDDE8",

    "1F1EA 1F1EA                                ; fully-qualified     # 🇪🇪 Estonia",
    "\uD83C\uDDEA\uD83C\uDDEA",

    "1F1EA 1F1EC                                ; fully-qualified     # 🇪🇬 Egypt",
    "\uD83C\uDDEA\uD83C\uDDEC",

    "1F1EA 1F1ED                                ; fully-qualified     # 🇪🇭 Western Sahara",
    "\uD83C\uDDEA\uD83C\uDDED",

    "1F1EA 1F1F7                                ; fully-qualified     # 🇪🇷 Eritrea",
    "\uD83C\uDDEA\uD83C\uDDF7",

    "1F1EA 1F1F8                                ; fully-qualified     # 🇪🇸 Spain",
    "\uD83C\uDDEA\uD83C\uDDF8",

    "1F1EA 1F1F9                                ; fully-qualified     # 🇪🇹 Ethiopia",
    "\uD83C\uDDEA\uD83C\uDDF9",

    "1F1EA 1F1FA                                ; fully-qualified     # 🇪🇺 European Union",
    "\uD83C\uDDEA\uD83C\uDDFA",

    "1F1EB 1F1EE                                ; fully-qualified     # 🇫🇮 Finland",
    "\uD83C\uDDEB\uD83C\uDDEE",

    "1F1EB 1F1EF                                ; fully-qualified     # 🇫🇯 Fiji",
    "\uD83C\uDDEB\uD83C\uDDEF",

    "1F1EB 1F1F0                                ; fully-qualified     # 🇫🇰 Falkland Islands",
    "\uD83C\uDDEB\uD83C\uDDF0",

    "1F1EB 1F1F2                                ; fully-qualified     # 🇫🇲 Micronesia",
    "\uD83C\uDDEB\uD83C\uDDF2",

    "1F1EB 1F1F4                                ; fully-qualified     # 🇫🇴 Faroe Islands",
    "\uD83C\uDDEB\uD83C\uDDF4",

    "1F1EB 1F1F7                                ; fully-qualified     # 🇫🇷 France",
    "\uD83C\uDDEB\uD83C\uDDF7",

    "1F1EC 1F1E6                                ; fully-qualified     # 🇬🇦 Gabon",
    "\uD83C\uDDEC\uD83C\uDDE6",

    "1F1EC 1F1E7                                ; fully-qualified     # 🇬🇧 United Kingdom",
    "\uD83C\uDDEC\uD83C\uDDE7",

    "1F1EC 1F1E9                                ; fully-qualified     # 🇬🇩 Grenada",
    "\uD83C\uDDEC\uD83C\uDDE9",

    "1F1EC 1F1EA                                ; fully-qualified     # 🇬🇪 Georgia",
    "\uD83C\uDDEC\uD83C\uDDEA",

    "1F1EC 1F1EB                                ; fully-qualified     # 🇬🇫 French Guiana",
    "\uD83C\uDDEC\uD83C\uDDEB",

    "1F1EC 1F1EC                                ; fully-qualified     # 🇬🇬 Guernsey",
    "\uD83C\uDDEC\uD83C\uDDEC",

    "1F1EC 1F1ED                                ; fully-qualified     # 🇬🇭 Ghana",
    "\uD83C\uDDEC\uD83C\uDDED",

    "1F1EC 1F1EE                                ; fully-qualified     # 🇬🇮 Gibraltar",
    "\uD83C\uDDEC\uD83C\uDDEE",

    "1F1EC 1F1F1                                ; fully-qualified     # 🇬🇱 Greenland",
    "\uD83C\uDDEC\uD83C\uDDF1",

    "1F1EC 1F1F2                                ; fully-qualified     # 🇬🇲 Gambia",
    "\uD83C\uDDEC\uD83C\uDDF2",

    "1F1EC 1F1F3                                ; fully-qualified     # 🇬🇳 Guinea",
    "\uD83C\uDDEC\uD83C\uDDF3",

    "1F1EC 1F1F5                                ; fully-qualified     # 🇬🇵 Guadeloupe",
    "\uD83C\uDDEC\uD83C\uDDF5",

    "1F1EC 1F1F6                                ; fully-qualified     # 🇬🇶 Equatorial Guinea",
    "\uD83C\uDDEC\uD83C\uDDF6",

    "1F1EC 1F1F7                                ; fully-qualified     # 🇬🇷 Greece",
    "\uD83C\uDDEC\uD83C\uDDF7",

    "1F1EC 1F1F8                                ; fully-qualified     # 🇬🇸 South Georgia & South Sandwich Islands",
    "\uD83C\uDDEC\uD83C\uDDF8",

    "1F1EC 1F1F9                                ; fully-qualified     # 🇬🇹 Guatemala",
    "\uD83C\uDDEC\uD83C\uDDF9",

    "1F1EC 1F1FA                                ; fully-qualified     # 🇬🇺 Guam",
    "\uD83C\uDDEC\uD83C\uDDFA",

    "1F1EC 1F1FC                                ; fully-qualified     # 🇬🇼 Guinea-Bissau",
    "\uD83C\uDDEC\uD83C\uDDFC",

    "1F1EC 1F1FE                                ; fully-qualified     # 🇬🇾 Guyana",
    "\uD83C\uDDEC\uD83C\uDDFE",

    "1F1ED 1F1F0                                ; fully-qualified     # 🇭🇰 Hong Kong SAR China",
    "\uD83C\uDDED\uD83C\uDDF0",

    "1F1ED 1F1F2                                ; fully-qualified     # 🇭🇲 Heard & McDonald Islands",
    "\uD83C\uDDED\uD83C\uDDF2",

    "1F1ED 1F1F3                                ; fully-qualified     # 🇭🇳 Honduras",
    "\uD83C\uDDED\uD83C\uDDF3",

    "1F1ED 1F1F7                                ; fully-qualified     # 🇭🇷 Croatia",
    "\uD83C\uDDED\uD83C\uDDF7",

    "1F1ED 1F1F9                                ; fully-qualified     # 🇭🇹 Haiti",
    "\uD83C\uDDED\uD83C\uDDF9",

    "1F1ED 1F1FA                                ; fully-qualified     # 🇭🇺 Hungary",
    "\uD83C\uDDED\uD83C\uDDFA",

    "1F1EE 1F1E8                                ; fully-qualified     # 🇮🇨 Canary Islands",
    "\uD83C\uDDEE\uD83C\uDDE8",

    "1F1EE 1F1E9                                ; fully-qualified     # 🇮🇩 Indonesia",
    "\uD83C\uDDEE\uD83C\uDDE9",

    "1F1EE 1F1EA                                ; fully-qualified     # 🇮🇪 Ireland",
    "\uD83C\uDDEE\uD83C\uDDEA",

    "1F1EE 1F1F1                                ; fully-qualified     # 🇮🇱 Israel",
    "\uD83C\uDDEE\uD83C\uDDF1",

    "1F1EE 1F1F2                                ; fully-qualified     # 🇮🇲 Isle of Man",
    "\uD83C\uDDEE\uD83C\uDDF2",

    "1F1EE 1F1F3                                ; fully-qualified     # 🇮🇳 India",
    "\uD83C\uDDEE\uD83C\uDDF3",

    "1F1EE 1F1F4                                ; fully-qualified     # 🇮🇴 British Indian Ocean Territory",
    "\uD83C\uDDEE\uD83C\uDDF4",

    "1F1EE 1F1F6                                ; fully-qualified     # 🇮🇶 Iraq",
    "\uD83C\uDDEE\uD83C\uDDF6",

    "1F1EE 1F1F7                                ; fully-qualified     # 🇮🇷 Iran",
    "\uD83C\uDDEE\uD83C\uDDF7",

    "1F1EE 1F1F8                                ; fully-qualified     # 🇮🇸 Iceland",
    "\uD83C\uDDEE\uD83C\uDDF8",

    "1F1EE 1F1F9                                ; fully-qualified     # 🇮🇹 Italy",
    "\uD83C\uDDEE\uD83C\uDDF9",

    "1F1EF 1F1EA                                ; fully-qualified     # 🇯🇪 Jersey",
    "\uD83C\uDDEF\uD83C\uDDEA",

    "1F1EF 1F1F2                                ; fully-qualified     # 🇯🇲 Jamaica",
    "\uD83C\uDDEF\uD83C\uDDF2",

    "1F1EF 1F1F4                                ; fully-qualified     # 🇯🇴 Jordan",
    "\uD83C\uDDEF\uD83C\uDDF4",

    "1F1EF 1F1F5                                ; fully-qualified     # 🇯🇵 Japan",
    "\uD83C\uDDEF\uD83C\uDDF5",

    "1F1F0 1F1EA                                ; fully-qualified     # 🇰🇪 Kenya",
    "\uD83C\uDDF0\uD83C\uDDEA",

    "1F1F0 1F1EC                                ; fully-qualified     # 🇰🇬 Kyrgyzstan",
    "\uD83C\uDDF0\uD83C\uDDEC",

    "1F1F0 1F1ED                                ; fully-qualified     # 🇰🇭 Cambodia",
    "\uD83C\uDDF0\uD83C\uDDED",

    "1F1F0 1F1EE                                ; fully-qualified     # 🇰🇮 Kiribati",
    "\uD83C\uDDF0\uD83C\uDDEE",

    "1F1F0 1F1F2                                ; fully-qualified     # 🇰🇲 Comoros",
    "\uD83C\uDDF0\uD83C\uDDF2",

    "1F1F0 1F1F3                                ; fully-qualified     # 🇰🇳 St. Kitts & Nevis",
    "\uD83C\uDDF0\uD83C\uDDF3",

    "1F1F0 1F1F5                                ; fully-qualified     # 🇰🇵 North Korea",
    "\uD83C\uDDF0\uD83C\uDDF5",

    "1F1F0 1F1F7                                ; fully-qualified     # 🇰🇷 South Korea",
    "\uD83C\uDDF0\uD83C\uDDF7",

    "1F1F0 1F1FC                                ; fully-qualified     # 🇰🇼 Kuwait",
    "\uD83C\uDDF0\uD83C\uDDFC",

    "1F1F0 1F1FE                                ; fully-qualified     # 🇰🇾 Cayman Islands",
    "\uD83C\uDDF0\uD83C\uDDFE",

    "1F1F0 1F1FF                                ; fully-qualified     # 🇰🇿 Kazakhstan",
    "\uD83C\uDDF0\uD83C\uDDFF",

    "1F1F1 1F1E6                                ; fully-qualified     # 🇱🇦 Laos",
    "\uD83C\uDDF1\uD83C\uDDE6",

    "1F1F1 1F1E7                                ; fully-qualified     # 🇱🇧 Lebanon",
    "\uD83C\uDDF1\uD83C\uDDE7",

    "1F1F1 1F1E8                                ; fully-qualified     # 🇱🇨 St. Lucia",
    "\uD83C\uDDF1\uD83C\uDDE8",

    "1F1F1 1F1EE                                ; fully-qualified     # 🇱🇮 Liechtenstein",
    "\uD83C\uDDF1\uD83C\uDDEE",

    "1F1F1 1F1F0                                ; fully-qualified     # 🇱🇰 Sri Lanka",
    "\uD83C\uDDF1\uD83C\uDDF0",

    "1F1F1 1F1F7                                ; fully-qualified     # 🇱🇷 Liberia",
    "\uD83C\uDDF1\uD83C\uDDF7",

    "1F1F1 1F1F8                                ; fully-qualified     # 🇱🇸 Lesotho",
    "\uD83C\uDDF1\uD83C\uDDF8",

    "1F1F1 1F1F9                                ; fully-qualified     # 🇱🇹 Lithuania",
    "\uD83C\uDDF1\uD83C\uDDF9",

    "1F1F1 1F1FA                                ; fully-qualified     # 🇱🇺 Luxembourg",
    "\uD83C\uDDF1\uD83C\uDDFA",

    "1F1F1 1F1FB                                ; fully-qualified     # 🇱🇻 Latvia",
    "\uD83C\uDDF1\uD83C\uDDFB",

    "1F1F1 1F1FE                                ; fully-qualified     # 🇱🇾 Libya",
    "\uD83C\uDDF1\uD83C\uDDFE",

    "1F1F2 1F1E6                                ; fully-qualified     # 🇲🇦 Morocco",
    "\uD83C\uDDF2\uD83C\uDDE6",

    "1F1F2 1F1E8                                ; fully-qualified     # 🇲🇨 Monaco",
    "\uD83C\uDDF2\uD83C\uDDE8",

    "1F1F2 1F1E9                                ; fully-qualified     # 🇲🇩 Moldova",
    "\uD83C\uDDF2\uD83C\uDDE9",

    "1F1F2 1F1EA                                ; fully-qualified     # 🇲🇪 Montenegro",
    "\uD83C\uDDF2\uD83C\uDDEA",

    "1F1F2 1F1EB                                ; fully-qualified     # 🇲🇫 St. Martin",
    "\uD83C\uDDF2\uD83C\uDDEB",

    "1F1F2 1F1EC                                ; fully-qualified     # 🇲🇬 Madagascar",
    "\uD83C\uDDF2\uD83C\uDDEC",

    "1F1F2 1F1ED                                ; fully-qualified     # 🇲🇭 Marshall Islands",
    "\uD83C\uDDF2\uD83C\uDDED",

    "1F1F2 1F1F0                                ; fully-qualified     # 🇲🇰 Macedonia",
    "\uD83C\uDDF2\uD83C\uDDF0",

    "1F1F2 1F1F1                                ; fully-qualified     # 🇲🇱 Mali",
    "\uD83C\uDDF2\uD83C\uDDF1",

    "1F1F2 1F1F2                                ; fully-qualified     # 🇲🇲 Myanmar (Burma)",
    "\uD83C\uDDF2\uD83C\uDDF2",

    "1F1F2 1F1F3                                ; fully-qualified     # 🇲🇳 Mongolia",
    "\uD83C\uDDF2\uD83C\uDDF3",

    "1F1F2 1F1F4                                ; fully-qualified     # 🇲🇴 Macau SAR China",
    "\uD83C\uDDF2\uD83C\uDDF4",

    "1F1F2 1F1F5                                ; fully-qualified     # 🇲🇵 Northern Mariana Islands",
    "\uD83C\uDDF2\uD83C\uDDF5",

    "1F1F2 1F1F6                                ; fully-qualified     # 🇲🇶 Martinique",
    "\uD83C\uDDF2\uD83C\uDDF6",

    "1F1F2 1F1F7                                ; fully-qualified     # 🇲🇷 Mauritania",
    "\uD83C\uDDF2\uD83C\uDDF7",

    "1F1F2 1F1F8                                ; fully-qualified     # 🇲🇸 Montserrat",
    "\uD83C\uDDF2\uD83C\uDDF8",

    "1F1F2 1F1F9                                ; fully-qualified     # 🇲🇹 Malta",
    "\uD83C\uDDF2\uD83C\uDDF9",

    "1F1F2 1F1FA                                ; fully-qualified     # 🇲🇺 Mauritius",
    "\uD83C\uDDF2\uD83C\uDDFA",

    "1F1F2 1F1FB                                ; fully-qualified     # 🇲🇻 Maldives",
    "\uD83C\uDDF2\uD83C\uDDFB",

    "1F1F2 1F1FC                                ; fully-qualified     # 🇲🇼 Malawi",
    "\uD83C\uDDF2\uD83C\uDDFC",

    "1F1F2 1F1FD                                ; fully-qualified     # 🇲🇽 Mexico",
    "\uD83C\uDDF2\uD83C\uDDFD",

    "1F1F2 1F1FE                                ; fully-qualified     # 🇲🇾 Malaysia",
    "\uD83C\uDDF2\uD83C\uDDFE",

    "1F1F2 1F1FF                                ; fully-qualified     # 🇲🇿 Mozambique",
    "\uD83C\uDDF2\uD83C\uDDFF",

    "1F1F3 1F1E6                                ; fully-qualified     # 🇳🇦 Namibia",
    "\uD83C\uDDF3\uD83C\uDDE6",

    "1F1F3 1F1E8                                ; fully-qualified     # 🇳🇨 New Caledonia",
    "\uD83C\uDDF3\uD83C\uDDE8",

    "1F1F3 1F1EA                                ; fully-qualified     # 🇳🇪 Niger",
    "\uD83C\uDDF3\uD83C\uDDEA",

    "1F1F3 1F1EB                                ; fully-qualified     # 🇳🇫 Norfolk Island",
    "\uD83C\uDDF3\uD83C\uDDEB",

    "1F1F3 1F1EC                                ; fully-qualified     # 🇳🇬 Nigeria",
    "\uD83C\uDDF3\uD83C\uDDEC",

    "1F1F3 1F1EE                                ; fully-qualified     # 🇳🇮 Nicaragua",
    "\uD83C\uDDF3\uD83C\uDDEE",

    "1F1F3 1F1F1                                ; fully-qualified     # 🇳🇱 Netherlands",
    "\uD83C\uDDF3\uD83C\uDDF1",

    "1F1F3 1F1F4                                ; fully-qualified     # 🇳🇴 Norway",
    "\uD83C\uDDF3\uD83C\uDDF4",

    "1F1F3 1F1F5                                ; fully-qualified     # 🇳🇵 Nepal",
    "\uD83C\uDDF3\uD83C\uDDF5",

    "1F1F3 1F1F7                                ; fully-qualified     # 🇳🇷 Nauru",
    "\uD83C\uDDF3\uD83C\uDDF7",

    "1F1F3 1F1FA                                ; fully-qualified     # 🇳🇺 Niue",
    "\uD83C\uDDF3\uD83C\uDDFA",

    "1F1F3 1F1FF                                ; fully-qualified     # 🇳🇿 New Zealand",
    "\uD83C\uDDF3\uD83C\uDDFF",

    "1F1F4 1F1F2                                ; fully-qualified     # 🇴🇲 Oman",
    "\uD83C\uDDF4\uD83C\uDDF2",

    "1F1F5 1F1E6                                ; fully-qualified     # 🇵🇦 Panama",
    "\uD83C\uDDF5\uD83C\uDDE6",

    "1F1F5 1F1EA                                ; fully-qualified     # 🇵🇪 Peru",
    "\uD83C\uDDF5\uD83C\uDDEA",

    "1F1F5 1F1EB                                ; fully-qualified     # 🇵🇫 French Polynesia",
    "\uD83C\uDDF5\uD83C\uDDEB",

    "1F1F5 1F1EC                                ; fully-qualified     # 🇵🇬 Papua New Guinea",
    "\uD83C\uDDF5\uD83C\uDDEC",

    "1F1F5 1F1ED                                ; fully-qualified     # 🇵🇭 Philippines",
    "\uD83C\uDDF5\uD83C\uDDED",

    "1F1F5 1F1F0                                ; fully-qualified     # 🇵🇰 Pakistan",
    "\uD83C\uDDF5\uD83C\uDDF0",

    "1F1F5 1F1F1                                ; fully-qualified     # 🇵🇱 Poland",
    "\uD83C\uDDF5\uD83C\uDDF1",

    "1F1F5 1F1F2                                ; fully-qualified     # 🇵🇲 St. Pierre & Miquelon",
    "\uD83C\uDDF5\uD83C\uDDF2",

    "1F1F5 1F1F3                                ; fully-qualified     # 🇵🇳 Pitcairn Islands",
    "\uD83C\uDDF5\uD83C\uDDF3",

    "1F1F5 1F1F7                                ; fully-qualified     # 🇵🇷 Puerto Rico",
    "\uD83C\uDDF5\uD83C\uDDF7",

    "1F1F5 1F1F8                                ; fully-qualified     # 🇵🇸 Palestinian Territories",
    "\uD83C\uDDF5\uD83C\uDDF8",

    "1F1F5 1F1F9                                ; fully-qualified     # 🇵🇹 Portugal",
    "\uD83C\uDDF5\uD83C\uDDF9",

    "1F1F5 1F1FC                                ; fully-qualified     # 🇵🇼 Palau",
    "\uD83C\uDDF5\uD83C\uDDFC",

    "1F1F5 1F1FE                                ; fully-qualified     # 🇵🇾 Paraguay",
    "\uD83C\uDDF5\uD83C\uDDFE",

    "1F1F6 1F1E6                                ; fully-qualified     # 🇶🇦 Qatar",
    "\uD83C\uDDF6\uD83C\uDDE6",

    "1F1F7 1F1EA                                ; fully-qualified     # 🇷🇪 Réunion",
    "\uD83C\uDDF7\uD83C\uDDEA",

    "1F1F7 1F1F4                                ; fully-qualified     # 🇷🇴 Romania",
    "\uD83C\uDDF7\uD83C\uDDF4",

    "1F1F7 1F1F8                                ; fully-qualified     # 🇷🇸 Serbia",
    "\uD83C\uDDF7\uD83C\uDDF8",

    "1F1F7 1F1FA                                ; fully-qualified     # 🇷🇺 Russia",
    "\uD83C\uDDF7\uD83C\uDDFA",

    "1F1F7 1F1FC                                ; fully-qualified     # 🇷🇼 Rwanda",
    "\uD83C\uDDF7\uD83C\uDDFC",

    "1F1F8 1F1E6                                ; fully-qualified     # 🇸🇦 Saudi Arabia",
    "\uD83C\uDDF8\uD83C\uDDE6",

    "1F1F8 1F1E7                                ; fully-qualified     # 🇸🇧 Solomon Islands",
    "\uD83C\uDDF8\uD83C\uDDE7",

    "1F1F8 1F1E8                                ; fully-qualified     # 🇸🇨 Seychelles",
    "\uD83C\uDDF8\uD83C\uDDE8",

    "1F1F8 1F1E9                                ; fully-qualified     # 🇸🇩 Sudan",
    "\uD83C\uDDF8\uD83C\uDDE9",

    "1F1F8 1F1EA                                ; fully-qualified     # 🇸🇪 Sweden",
    "\uD83C\uDDF8\uD83C\uDDEA",

    "1F1F8 1F1EC                                ; fully-qualified     # 🇸🇬 Singapore",
    "\uD83C\uDDF8\uD83C\uDDEC",

    "1F1F8 1F1ED                                ; fully-qualified     # 🇸🇭 St. Helena",
    "\uD83C\uDDF8\uD83C\uDDED",

    "1F1F8 1F1EE                                ; fully-qualified     # 🇸🇮 Slovenia",
    "\uD83C\uDDF8\uD83C\uDDEE",

    "1F1F8 1F1EF                                ; fully-qualified     # 🇸🇯 Svalbard & Jan Mayen",
    "\uD83C\uDDF8\uD83C\uDDEF",

    "1F1F8 1F1F0                                ; fully-qualified     # 🇸🇰 Slovakia",
    "\uD83C\uDDF8\uD83C\uDDF0",

    "1F1F8 1F1F1                                ; fully-qualified     # 🇸🇱 Sierra Leone",
    "\uD83C\uDDF8\uD83C\uDDF1",

    "1F1F8 1F1F2                                ; fully-qualified     # 🇸🇲 San Marino",
    "\uD83C\uDDF8\uD83C\uDDF2",

    "1F1F8 1F1F3                                ; fully-qualified     # 🇸🇳 Senegal",
    "\uD83C\uDDF8\uD83C\uDDF3",

    "1F1F8 1F1F4                                ; fully-qualified     # 🇸🇴 Somalia",
    "\uD83C\uDDF8\uD83C\uDDF4",

    "1F1F8 1F1F7                                ; fully-qualified     # 🇸🇷 Suriname",
    "\uD83C\uDDF8\uD83C\uDDF7",

    "1F1F8 1F1F8                                ; fully-qualified     # 🇸🇸 South Sudan",
    "\uD83C\uDDF8\uD83C\uDDF8",

    "1F1F8 1F1F9                                ; fully-qualified     # 🇸🇹 São Tomé & Príncipe",
    "\uD83C\uDDF8\uD83C\uDDF9",

    "1F1F8 1F1FB                                ; fully-qualified     # 🇸🇻 El Salvador",
    "\uD83C\uDDF8\uD83C\uDDFB",

    "1F1F8 1F1FD                                ; fully-qualified     # 🇸🇽 Sint Maarten",
    "\uD83C\uDDF8\uD83C\uDDFD",

    "1F1F8 1F1FE                                ; fully-qualified     # 🇸🇾 Syria",
    "\uD83C\uDDF8\uD83C\uDDFE",

    "1F1F8 1F1FF                                ; fully-qualified     # 🇸🇿 Swaziland",
    "\uD83C\uDDF8\uD83C\uDDFF",

    "1F1F9 1F1E6                                ; fully-qualified     # 🇹🇦 Tristan da Cunha",
    "\uD83C\uDDF9\uD83C\uDDE6",

    "1F1F9 1F1E8                                ; fully-qualified     # 🇹🇨 Turks & Caicos Islands",
    "\uD83C\uDDF9\uD83C\uDDE8",

    "1F1F9 1F1E9                                ; fully-qualified     # 🇹🇩 Chad",
    "\uD83C\uDDF9\uD83C\uDDE9",

    "1F1F9 1F1EB                                ; fully-qualified     # 🇹🇫 French Southern Territories",
    "\uD83C\uDDF9\uD83C\uDDEB",

    "1F1F9 1F1EC                                ; fully-qualified     # 🇹🇬 Togo",
    "\uD83C\uDDF9\uD83C\uDDEC",

    "1F1F9 1F1ED                                ; fully-qualified     # 🇹🇭 Thailand",
    "\uD83C\uDDF9\uD83C\uDDED",

    "1F1F9 1F1EF                                ; fully-qualified     # 🇹🇯 Tajikistan",
    "\uD83C\uDDF9\uD83C\uDDEF",

    "1F1F9 1F1F0                                ; fully-qualified     # 🇹🇰 Tokelau",
    "\uD83C\uDDF9\uD83C\uDDF0",

    "1F1F9 1F1F1                                ; fully-qualified     # 🇹🇱 Timor-Leste",
    "\uD83C\uDDF9\uD83C\uDDF1",

    "1F1F9 1F1F2                                ; fully-qualified     # 🇹🇲 Turkmenistan",
    "\uD83C\uDDF9\uD83C\uDDF2",

    "1F1F9 1F1F3                                ; fully-qualified     # 🇹🇳 Tunisia",
    "\uD83C\uDDF9\uD83C\uDDF3",

    "1F1F9 1F1F4                                ; fully-qualified     # 🇹🇴 Tonga",
    "\uD83C\uDDF9\uD83C\uDDF4",

    "1F1F9 1F1F7                                ; fully-qualified     # 🇹🇷 Turkey",
    "\uD83C\uDDF9\uD83C\uDDF7",

    "1F1F9 1F1F9                                ; fully-qualified     # 🇹🇹 Trinidad & Tobago",
    "\uD83C\uDDF9\uD83C\uDDF9",

    "1F1F9 1F1FB                                ; fully-qualified     # 🇹🇻 Tuvalu",
    "\uD83C\uDDF9\uD83C\uDDFB",

    "1F1F9 1F1FC                                ; fully-qualified     # 🇹🇼 Taiwan",
    "\uD83C\uDDF9\uD83C\uDDFC",

    "1F1F9 1F1FF                                ; fully-qualified     # 🇹🇿 Tanzania",
    "\uD83C\uDDF9\uD83C\uDDFF",

    "1F1FA 1F1E6                                ; fully-qualified     # 🇺🇦 Ukraine",
    "\uD83C\uDDFA\uD83C\uDDE6",

    "1F1FA 1F1EC                                ; fully-qualified     # 🇺🇬 Uganda",
    "\uD83C\uDDFA\uD83C\uDDEC",

    "1F1FA 1F1F2                                ; fully-qualified     # 🇺🇲 U.S. Outlying Islands",
    "\uD83C\uDDFA\uD83C\uDDF2",

    "1F1FA 1F1F3                                ; fully-qualified     # 🇺🇳 United Nations",
    "\uD83C\uDDFA\uD83C\uDDF3",

    "1F1FA 1F1F8                                ; fully-qualified     # 🇺🇸 United States",
    "\uD83C\uDDFA\uD83C\uDDF8",

    "1F1FA 1F1FE                                ; fully-qualified     # 🇺🇾 Uruguay",
    "\uD83C\uDDFA\uD83C\uDDFE",

    "1F1FA 1F1FF                                ; fully-qualified     # 🇺🇿 Uzbekistan",
    "\uD83C\uDDFA\uD83C\uDDFF",

    "1F1FB 1F1E6                                ; fully-qualified     # 🇻🇦 Vatican City",
    "\uD83C\uDDFB\uD83C\uDDE6",

    "1F1FB 1F1E8                                ; fully-qualified     # 🇻🇨 St. Vincent & Grenadines",
    "\uD83C\uDDFB\uD83C\uDDE8",

    "1F1FB 1F1EA                                ; fully-qualified     # 🇻🇪 Venezuela",
    "\uD83C\uDDFB\uD83C\uDDEA",

    "1F1FB 1F1EC                                ; fully-qualified     # 🇻🇬 British Virgin Islands",
    "\uD83C\uDDFB\uD83C\uDDEC",

    "1F1FB 1F1EE                                ; fully-qualified     # 🇻🇮 U.S. Virgin Islands",
    "\uD83C\uDDFB\uD83C\uDDEE",

    "1F1FB 1F1F3                                ; fully-qualified     # 🇻🇳 Vietnam",
    "\uD83C\uDDFB\uD83C\uDDF3",

    "1F1FB 1F1FA                                ; fully-qualified     # 🇻🇺 Vanuatu",
    "\uD83C\uDDFB\uD83C\uDDFA",

    "1F1FC 1F1EB                                ; fully-qualified     # 🇼🇫 Wallis & Futuna",
    "\uD83C\uDDFC\uD83C\uDDEB",

    "1F1FC 1F1F8                                ; fully-qualified     # 🇼🇸 Samoa",
    "\uD83C\uDDFC\uD83C\uDDF8",

    "1F1FD 1F1F0                                ; fully-qualified     # 🇽🇰 Kosovo",
    "\uD83C\uDDFD\uD83C\uDDF0",

    "1F1FE 1F1EA                                ; fully-qualified     # 🇾🇪 Yemen",
    "\uD83C\uDDFE\uD83C\uDDEA",

    "1F1FE 1F1F9                                ; fully-qualified     # 🇾🇹 Mayotte",
    "\uD83C\uDDFE\uD83C\uDDF9",

    "1F1FF 1F1E6                                ; fully-qualified     # 🇿🇦 South Africa",
    "\uD83C\uDDFF\uD83C\uDDE6",

    "1F1FF 1F1F2                                ; fully-qualified     # 🇿🇲 Zambia",
    "\uD83C\uDDFF\uD83C\uDDF2",

    "1F1FF 1F1FC                                ; fully-qualified     # 🇿🇼 Zimbabwe",
    "\uD83C\uDDFF\uD83C\uDDFC",

    "1F3F4 E0067 E0062 E0065 E006E E0067 E007F  ; fully-qualified     # 🏴󠁧󠁢󠁥󠁮󠁧󠁿 England",
    "\uD83C\uDFF4\uDB40\uDC67\uDB40\uDC62\uDB40\uDC65\uDB40\uDC6E\uDB40\uDC67\uDB40\uDC7F",

    "1F3F4 E0067 E0062 E0073 E0063 E0074 E007F  ; fully-qualified     # 🏴󠁧󠁢󠁳󠁣󠁴󠁿 Scotland",
    "\uD83C\uDFF4\uDB40\uDC67\uDB40\uDC62\uDB40\uDC73\uDB40\uDC63\uDB40\uDC74\uDB40\uDC7F",

    "1F3F4 E0067 E0062 E0077 E006C E0073 E007F  ; fully-qualified     # 🏴󠁧󠁢󠁷󠁬󠁳󠁿 Wales",
    "\uD83C\uDFF4\uDB40\uDC67\uDB40\uDC62\uDB40\uDC77\uDB40\uDC6C\uDB40\uDC73\uDB40\uDC7F"  };
}
