; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=reassociate -S | FileCheck %s

; Test that we can turn things like X*-(Y*Z) -> X*-1*Y*Z.

define i32 @test1(i32 %a, i32 %b, i32 %z) {
; CHECK-LABEL: @test1(
; CHECK-NEXT:    [[E:%.*]] = mul i32 [[A:%.*]], 12345
; CHECK-NEXT:    [[F:%.*]] = mul i32 [[E]], [[B:%.*]]
; CHECK-NEXT:    [[G:%.*]] = mul i32 [[F]], [[Z:%.*]]
; CHECK-NEXT:    ret i32 [[G]]
;
  %c = sub i32 0, %z
  %d = mul i32 %a, %b
  %e = mul i32 %c, %d
  %f = mul i32 %e, 12345
  %g = sub i32 0, %f
  ret i32 %g
}

define i32 @test2(i32 %a, i32 %b, i32 %z) {
; CHECK-LABEL: @test2(
; CHECK-NEXT:    [[E:%.*]] = mul i32 [[A:%.*]], 40
; CHECK-NEXT:    [[F:%.*]] = mul i32 [[E]], [[Z:%.*]]
; CHECK-NEXT:    ret i32 [[F]]
;
  %d = mul i32 %z, 40
  %c = sub i32 0, %d
  %e = mul i32 %a, %c
  %f = sub i32 0, %e
  ret i32 %f
}

define <2 x i32> @negate_vec_undefs(<2 x i32> %a, <2 x i32> %b, <2 x i32> %z) {
; CHECK-LABEL: @negate_vec_undefs(
; CHECK-NEXT:    [[E:%.*]] = mul <2 x i32> [[A:%.*]], <i32 40, i32 40>
; CHECK-NEXT:    [[F:%.*]] = mul <2 x i32> [[E]], [[Z:%.*]]
; CHECK-NEXT:    ret <2 x i32> [[F]]
;
  %d = mul <2 x i32> %z, <i32 40, i32 40>
  %c = sub <2 x i32> <i32 0, i32 undef>, %d
  %e = mul <2 x i32> %a, %c
  %f = sub <2 x i32> <i32 0, i32 undef>, %e
  ret <2 x i32> %f
}

; Replacing %x with a partial undef negation is a miscompile.

define <2 x i32> @PR57683(<2 x i32> %x) {
; CHECK-LABEL: @PR57683(
; CHECK-NEXT:    [[PARTIAL_NEG:%.*]] = sub <2 x i32> <i32 poison, i32 0>, [[X:%.*]]
; CHECK-NEXT:    [[SHUF:%.*]] = shufflevector <2 x i32> [[PARTIAL_NEG]], <2 x i32> [[X]], <2 x i32> <i32 1, i32 3>
; CHECK-NEXT:    [[X_NEG:%.*]] = sub <2 x i32> zeroinitializer, [[X]]
; CHECK-NEXT:    [[SUB:%.*]] = add <2 x i32> [[X_NEG]], <i32 1, i32 1>
; CHECK-NEXT:    [[R:%.*]] = add <2 x i32> [[SUB]], [[SHUF]]
; CHECK-NEXT:    ret <2 x i32> [[R]]
;
  %partial_neg = sub <2 x i32> <i32 poison, i32 0>, %x
  %shuf = shufflevector <2 x i32> %partial_neg, <2 x i32> %x, <2 x i32> <i32 1, i32 3>
  %sub = sub <2 x i32> <i32 1, i32 1>, %x
  %r = add <2 x i32> %sub, %shuf
  ret <2 x i32> %r
}

define <2 x float> @PR57683_FP(<2 x float> %x) {
; CHECK-LABEL: @PR57683_FP(
; CHECK-NEXT:    [[PARTIAL_NEG:%.*]] = fsub reassoc nsz <2 x float> <float poison, float 0.000000e+00>, [[X:%.*]]
; CHECK-NEXT:    [[SHUF:%.*]] = shufflevector <2 x float> [[PARTIAL_NEG]], <2 x float> [[X]], <2 x i32> <i32 1, i32 3>
; CHECK-NEXT:    [[X_NEG:%.*]] = fneg reassoc nsz <2 x float> [[X]]
; CHECK-NEXT:    [[SUB:%.*]] = fadd reassoc nsz <2 x float> [[X_NEG]], <float 1.000000e+00, float 1.000000e+00>
; CHECK-NEXT:    [[R:%.*]] = fadd reassoc nsz <2 x float> [[SUB]], [[SHUF]]
; CHECK-NEXT:    ret <2 x float> [[R]]
;
  %partial_neg = fsub reassoc nsz <2 x float> <float poison, float 0.0>, %x
  %shuf = shufflevector <2 x float> %partial_neg, <2 x float> %x, <2 x i32> <i32 1, i32 3>
  %sub = fsub reassoc nsz <2 x float> <float 1.0, float 1.0>, %x
  %r = fadd reassoc nsz <2 x float> %sub, %shuf
  ret <2 x float> %r
}
