// swift-tools-version:5.5
// The swift-tools-version declares the minimum version of Swift required to build this package.
import PackageDescription
import Foundation

var basePath = FileManager.default.fileExists(atPath: "native") ? "native" : "."

let package = Package(
  name: "gRPC",
  products: [
    .library(
      name: "gRPC-Core",
      targets: [
        "gRPC-Core",
      ]
    ),
    .library(
      name: "gRPC-cpp",
      targets: [
        "gRPC-cpp",
      ]
    )
  ],

  dependencies: [
    .package(url: "https://github.com/firebase/abseil-cpp-SwiftPM.git", "0.20220623.0"..<"0.20220624.0"),
    .package(url: "https://github.com/firebase/boringssl-SwiftPM.git", "0.9.0"..<"0.10.0"),
  ],

  targets: [
    .target(
      name: "gRPC-Core",
      dependencies: [
        .product(name:"abseil", package: "abseil-cpp-SwiftPM"),
        .product(name:"openssl_grpc", package: "boringssl-SwiftPM"),
      ],
      path: basePath,
      exclude: [
        "examples/",
        "src/objective-c/",
      ],
    
      sources: [
        "include/grpc/byte_buffer.h",
        "include/grpc/byte_buffer_reader.h",
        "include/grpc/census.h",
        "include/grpc/compression.h",
        "include/grpc/event_engine/endpoint_config.h",
        "include/grpc/event_engine/event_engine.h",
        "include/grpc/event_engine/internal/memory_allocator_impl.h",
        "include/grpc/event_engine/internal/slice_cast.h",
        "include/grpc/event_engine/memory_allocator.h",
        "include/grpc/event_engine/memory_request.h",
        "include/grpc/event_engine/port.h",
        "include/grpc/event_engine/slice.h",
        "include/grpc/event_engine/slice_buffer.h",
        "include/grpc/fork.h",
        "include/grpc/grpc.h",
        "include/grpc/grpc_audit_logging.h",
        "include/grpc/grpc_crl_provider.h",
        "include/grpc/grpc_posix.h",
        "include/grpc/grpc_security.h",
        "include/grpc/grpc_security_constants.h",
        "include/grpc/impl/channel_arg_names.h",
        "include/grpc/impl/codegen/atm.h",
        "include/grpc/impl/codegen/atm_gcc_atomic.h",
        "include/grpc/impl/codegen/atm_gcc_sync.h",
        "include/grpc/impl/codegen/atm_windows.h",
        "include/grpc/impl/codegen/byte_buffer.h",
        "include/grpc/impl/codegen/byte_buffer_reader.h",
        "include/grpc/impl/codegen/compression_types.h",
        "include/grpc/impl/codegen/connectivity_state.h",
        "include/grpc/impl/codegen/fork.h",
        "include/grpc/impl/codegen/gpr_types.h",
        "include/grpc/impl/codegen/grpc_types.h",
        "include/grpc/impl/codegen/log.h",
        "include/grpc/impl/codegen/port_platform.h",
        "include/grpc/impl/codegen/propagation_bits.h",
        "include/grpc/impl/codegen/slice.h",
        "include/grpc/impl/codegen/status.h",
        "include/grpc/impl/codegen/sync.h",
        "include/grpc/impl/codegen/sync_abseil.h",
        "include/grpc/impl/codegen/sync_custom.h",
        "include/grpc/impl/codegen/sync_generic.h",
        "include/grpc/impl/codegen/sync_posix.h",
        "include/grpc/impl/codegen/sync_windows.h",
        "include/grpc/impl/compression_types.h",
        "include/grpc/impl/connectivity_state.h",
        "include/grpc/impl/grpc_types.h",
        "include/grpc/impl/propagation_bits.h",
        "include/grpc/impl/slice_type.h",
        "include/grpc/load_reporting.h",
        "include/grpc/slice.h",
        "include/grpc/slice_buffer.h",
        "include/grpc/status.h",
        "include/grpc/support/alloc.h",
        "include/grpc/support/atm.h",
        "include/grpc/support/atm_gcc_atomic.h",
        "include/grpc/support/atm_gcc_sync.h",
        "include/grpc/support/atm_windows.h",
        "include/grpc/support/cpu.h",
        "include/grpc/support/json.h",
        "include/grpc/support/log.h",
        "include/grpc/support/log_windows.h",
        "include/grpc/support/port_platform.h",
        "include/grpc/support/string_util.h",
        "include/grpc/support/sync.h",
        "include/grpc/support/sync_abseil.h",
        "include/grpc/support/sync_custom.h",
        "include/grpc/support/sync_generic.h",
        "include/grpc/support/sync_posix.h",
        "include/grpc/support/sync_windows.h",
        "include/grpc/support/thd_id.h",
        "include/grpc/support/time.h",
        "include/grpc/support/workaround_list.h",
        "src/core/ext/filters/backend_metrics/backend_metric_filter.cc",
        "src/core/ext/filters/backend_metrics/backend_metric_filter.h",
        "src/core/ext/filters/backend_metrics/backend_metric_provider.h",
        "src/core/ext/filters/census/grpc_context.cc",
        "src/core/ext/filters/channel_idle/channel_idle_filter.cc",
        "src/core/ext/filters/channel_idle/channel_idle_filter.h",
        "src/core/ext/filters/channel_idle/idle_filter_state.cc",
        "src/core/ext/filters/channel_idle/idle_filter_state.h",
        "src/core/ext/filters/client_channel/backend_metric.cc",
        "src/core/ext/filters/client_channel/backend_metric.h",
        "src/core/ext/filters/client_channel/backup_poller.cc",
        "src/core/ext/filters/client_channel/backup_poller.h",
        "src/core/ext/filters/client_channel/channel_connectivity.cc",
        "src/core/ext/filters/client_channel/client_channel.cc",
        "src/core/ext/filters/client_channel/client_channel.h",
        "src/core/ext/filters/client_channel/client_channel_channelz.cc",
        "src/core/ext/filters/client_channel/client_channel_channelz.h",
        "src/core/ext/filters/client_channel/client_channel_factory.cc",
        "src/core/ext/filters/client_channel/client_channel_factory.h",
        "src/core/ext/filters/client_channel/client_channel_internal.h",
        "src/core/ext/filters/client_channel/client_channel_plugin.cc",
        "src/core/ext/filters/client_channel/client_channel_service_config.cc",
        "src/core/ext/filters/client_channel/client_channel_service_config.h",
        "src/core/ext/filters/client_channel/config_selector.cc",
        "src/core/ext/filters/client_channel/config_selector.h",
        "src/core/ext/filters/client_channel/connector.h",
        "src/core/ext/filters/client_channel/dynamic_filters.cc",
        "src/core/ext/filters/client_channel/dynamic_filters.h",
        "src/core/ext/filters/client_channel/global_subchannel_pool.cc",
        "src/core/ext/filters/client_channel/global_subchannel_pool.h",
        "src/core/ext/filters/client_channel/http_proxy_mapper.cc",
        "src/core/ext/filters/client_channel/http_proxy_mapper.h",
        "src/core/ext/filters/client_channel/lb_policy/address_filtering.cc",
        "src/core/ext/filters/client_channel/lb_policy/address_filtering.h",
        "src/core/ext/filters/client_channel/lb_policy/backend_metric_data.h",
        "src/core/ext/filters/client_channel/lb_policy/child_policy_handler.cc",
        "src/core/ext/filters/client_channel/lb_policy/child_policy_handler.h",
        "src/core/ext/filters/client_channel/lb_policy/endpoint_list.cc",
        "src/core/ext/filters/client_channel/lb_policy/endpoint_list.h",
        "src/core/ext/filters/client_channel/lb_policy/grpclb/client_load_reporting_filter.cc",
        "src/core/ext/filters/client_channel/lb_policy/grpclb/client_load_reporting_filter.h",
        "src/core/ext/filters/client_channel/lb_policy/grpclb/grpclb.cc",
        "src/core/ext/filters/client_channel/lb_policy/grpclb/grpclb.h",
        "src/core/ext/filters/client_channel/lb_policy/grpclb/grpclb_balancer_addresses.cc",
        "src/core/ext/filters/client_channel/lb_policy/grpclb/grpclb_balancer_addresses.h",
        "src/core/ext/filters/client_channel/lb_policy/grpclb/grpclb_client_stats.cc",
        "src/core/ext/filters/client_channel/lb_policy/grpclb/grpclb_client_stats.h",
        "src/core/ext/filters/client_channel/lb_policy/grpclb/load_balancer_api.cc",
        "src/core/ext/filters/client_channel/lb_policy/grpclb/load_balancer_api.h",
        "src/core/ext/filters/client_channel/lb_policy/health_check_client.cc",
        "src/core/ext/filters/client_channel/lb_policy/health_check_client.h",
        "src/core/ext/filters/client_channel/lb_policy/health_check_client_internal.h",
        "src/core/ext/filters/client_channel/lb_policy/oob_backend_metric.cc",
        "src/core/ext/filters/client_channel/lb_policy/oob_backend_metric.h",
        "src/core/ext/filters/client_channel/lb_policy/oob_backend_metric_internal.h",
        "src/core/ext/filters/client_channel/lb_policy/outlier_detection/outlier_detection.cc",
        "src/core/ext/filters/client_channel/lb_policy/outlier_detection/outlier_detection.h",
        "src/core/ext/filters/client_channel/lb_policy/pick_first/pick_first.cc",
        "src/core/ext/filters/client_channel/lb_policy/pick_first/pick_first.h",
        "src/core/ext/filters/client_channel/lb_policy/priority/priority.cc",
        "src/core/ext/filters/client_channel/lb_policy/ring_hash/ring_hash.cc",
        "src/core/ext/filters/client_channel/lb_policy/ring_hash/ring_hash.h",
        "src/core/ext/filters/client_channel/lb_policy/rls/rls.cc",
        "src/core/ext/filters/client_channel/lb_policy/round_robin/round_robin.cc",
        "src/core/ext/filters/client_channel/lb_policy/subchannel_list.h",
        "src/core/ext/filters/client_channel/lb_policy/weighted_round_robin/static_stride_scheduler.cc",
        "src/core/ext/filters/client_channel/lb_policy/weighted_round_robin/static_stride_scheduler.h",
        "src/core/ext/filters/client_channel/lb_policy/weighted_round_robin/weighted_round_robin.cc",
        "src/core/ext/filters/client_channel/lb_policy/weighted_target/weighted_target.cc",
        "src/core/ext/filters/client_channel/lb_policy/xds/cds.cc",
        "src/core/ext/filters/client_channel/lb_policy/xds/xds_channel_args.h",
        "src/core/ext/filters/client_channel/lb_policy/xds/xds_cluster_impl.cc",
        "src/core/ext/filters/client_channel/lb_policy/xds/xds_cluster_manager.cc",
        "src/core/ext/filters/client_channel/lb_policy/xds/xds_cluster_resolver.cc",
        "src/core/ext/filters/client_channel/lb_policy/xds/xds_override_host.cc",
        "src/core/ext/filters/client_channel/lb_policy/xds/xds_override_host.h",
        "src/core/ext/filters/client_channel/lb_policy/xds/xds_wrr_locality.cc",
        "src/core/ext/filters/client_channel/local_subchannel_pool.cc",
        "src/core/ext/filters/client_channel/local_subchannel_pool.h",
        "src/core/ext/filters/client_channel/resolver/binder/binder_resolver.cc",
        "src/core/ext/filters/client_channel/resolver/dns/c_ares/dns_resolver_ares.cc",
        "src/core/ext/filters/client_channel/resolver/dns/c_ares/dns_resolver_ares.h",
        "src/core/ext/filters/client_channel/resolver/dns/c_ares/grpc_ares_ev_driver.h",
        "src/core/ext/filters/client_channel/resolver/dns/c_ares/grpc_ares_ev_driver_posix.cc",
        "src/core/ext/filters/client_channel/resolver/dns/c_ares/grpc_ares_ev_driver_windows.cc",
        "src/core/ext/filters/client_channel/resolver/dns/c_ares/grpc_ares_wrapper.cc",
        "src/core/ext/filters/client_channel/resolver/dns/c_ares/grpc_ares_wrapper.h",
        "src/core/ext/filters/client_channel/resolver/dns/c_ares/grpc_ares_wrapper_posix.cc",
        "src/core/ext/filters/client_channel/resolver/dns/c_ares/grpc_ares_wrapper_windows.cc",
        "src/core/ext/filters/client_channel/resolver/dns/dns_resolver_plugin.cc",
        "src/core/ext/filters/client_channel/resolver/dns/dns_resolver_plugin.h",
        "src/core/ext/filters/client_channel/resolver/dns/event_engine/event_engine_client_channel_resolver.cc",
        "src/core/ext/filters/client_channel/resolver/dns/event_engine/event_engine_client_channel_resolver.h",
        "src/core/ext/filters/client_channel/resolver/dns/event_engine/service_config_helper.cc",
        "src/core/ext/filters/client_channel/resolver/dns/event_engine/service_config_helper.h",
        "src/core/ext/filters/client_channel/resolver/dns/native/dns_resolver.cc",
        "src/core/ext/filters/client_channel/resolver/dns/native/dns_resolver.h",
        "src/core/ext/filters/client_channel/resolver/fake/fake_resolver.cc",
        "src/core/ext/filters/client_channel/resolver/fake/fake_resolver.h",
        "src/core/ext/filters/client_channel/resolver/google_c2p/google_c2p_resolver.cc",
        "src/core/ext/filters/client_channel/resolver/polling_resolver.cc",
        "src/core/ext/filters/client_channel/resolver/polling_resolver.h",
        "src/core/ext/filters/client_channel/resolver/sockaddr/sockaddr_resolver.cc",
        "src/core/ext/filters/client_channel/resolver/xds/xds_resolver.cc",
        "src/core/ext/filters/client_channel/resolver/xds/xds_resolver.h",
        "src/core/ext/filters/client_channel/retry_filter.cc",
        "src/core/ext/filters/client_channel/retry_filter.h",
        "src/core/ext/filters/client_channel/retry_filter_legacy_call_data.cc",
        "src/core/ext/filters/client_channel/retry_filter_legacy_call_data.h",
        "src/core/ext/filters/client_channel/retry_service_config.cc",
        "src/core/ext/filters/client_channel/retry_service_config.h",
        "src/core/ext/filters/client_channel/retry_throttle.cc",
        "src/core/ext/filters/client_channel/retry_throttle.h",
        "src/core/ext/filters/client_channel/service_config_channel_arg_filter.cc",
        "src/core/ext/filters/client_channel/subchannel.cc",
        "src/core/ext/filters/client_channel/subchannel.h",
        "src/core/ext/filters/client_channel/subchannel_interface_internal.h",
        "src/core/ext/filters/client_channel/subchannel_pool_interface.cc",
        "src/core/ext/filters/client_channel/subchannel_pool_interface.h",
        "src/core/ext/filters/client_channel/subchannel_stream_client.cc",
        "src/core/ext/filters/client_channel/subchannel_stream_client.h",
        "src/core/ext/filters/deadline/deadline_filter.cc",
        "src/core/ext/filters/deadline/deadline_filter.h",
        "src/core/ext/filters/fault_injection/fault_injection_filter.cc",
        "src/core/ext/filters/fault_injection/fault_injection_filter.h",
        "src/core/ext/filters/fault_injection/fault_injection_service_config_parser.cc",
        "src/core/ext/filters/fault_injection/fault_injection_service_config_parser.h",
        "src/core/ext/filters/http/client/http_client_filter.cc",
        "src/core/ext/filters/http/client/http_client_filter.h",
        "src/core/ext/filters/http/client_authority_filter.cc",
        "src/core/ext/filters/http/client_authority_filter.h",
        "src/core/ext/filters/http/http_filters_plugin.cc",
        "src/core/ext/filters/http/message_compress/compression_filter.cc",
        "src/core/ext/filters/http/message_compress/compression_filter.h",
        "src/core/ext/filters/http/server/http_server_filter.cc",
        "src/core/ext/filters/http/server/http_server_filter.h",
        "src/core/ext/filters/message_size/message_size_filter.cc",
        "src/core/ext/filters/message_size/message_size_filter.h",
        "src/core/ext/filters/rbac/rbac_filter.cc",
        "src/core/ext/filters/rbac/rbac_filter.h",
        "src/core/ext/filters/rbac/rbac_service_config_parser.cc",
        "src/core/ext/filters/rbac/rbac_service_config_parser.h",
        "src/core/ext/filters/server_config_selector/server_config_selector.h",
        "src/core/ext/filters/server_config_selector/server_config_selector_filter.cc",
        "src/core/ext/filters/server_config_selector/server_config_selector_filter.h",
        "src/core/ext/filters/stateful_session/stateful_session_filter.cc",
        "src/core/ext/filters/stateful_session/stateful_session_filter.h",
        "src/core/ext/filters/stateful_session/stateful_session_service_config_parser.cc",
        "src/core/ext/filters/stateful_session/stateful_session_service_config_parser.h",
        "src/core/ext/gcp/metadata_query.cc",
        "src/core/ext/gcp/metadata_query.h",
        "src/core/ext/transport/chttp2/alpn/alpn.cc",
        "src/core/ext/transport/chttp2/alpn/alpn.h",
        "src/core/ext/transport/chttp2/client/chttp2_connector.cc",
        "src/core/ext/transport/chttp2/client/chttp2_connector.h",
        "src/core/ext/transport/chttp2/server/chttp2_server.cc",
        "src/core/ext/transport/chttp2/server/chttp2_server.h",
        "src/core/ext/transport/chttp2/transport/bin_decoder.cc",
        "src/core/ext/transport/chttp2/transport/bin_decoder.h",
        "src/core/ext/transport/chttp2/transport/bin_encoder.cc",
        "src/core/ext/transport/chttp2/transport/bin_encoder.h",
        "src/core/ext/transport/chttp2/transport/chttp2_transport.cc",
        "src/core/ext/transport/chttp2/transport/chttp2_transport.h",
        "src/core/ext/transport/chttp2/transport/context_list_entry.h",
        "src/core/ext/transport/chttp2/transport/decode_huff.cc",
        "src/core/ext/transport/chttp2/transport/decode_huff.h",
        "src/core/ext/transport/chttp2/transport/flow_control.cc",
        "src/core/ext/transport/chttp2/transport/flow_control.h",
        "src/core/ext/transport/chttp2/transport/frame_data.cc",
        "src/core/ext/transport/chttp2/transport/frame_data.h",
        "src/core/ext/transport/chttp2/transport/frame_goaway.cc",
        "src/core/ext/transport/chttp2/transport/frame_goaway.h",
        "src/core/ext/transport/chttp2/transport/frame_ping.cc",
        "src/core/ext/transport/chttp2/transport/frame_ping.h",
        "src/core/ext/transport/chttp2/transport/frame_rst_stream.cc",
        "src/core/ext/transport/chttp2/transport/frame_rst_stream.h",
        "src/core/ext/transport/chttp2/transport/frame_settings.cc",
        "src/core/ext/transport/chttp2/transport/frame_settings.h",
        "src/core/ext/transport/chttp2/transport/frame_window_update.cc",
        "src/core/ext/transport/chttp2/transport/frame_window_update.h",
        "src/core/ext/transport/chttp2/transport/hpack_constants.h",
        "src/core/ext/transport/chttp2/transport/hpack_encoder.cc",
        "src/core/ext/transport/chttp2/transport/hpack_encoder.h",
        "src/core/ext/transport/chttp2/transport/hpack_encoder_table.cc",
        "src/core/ext/transport/chttp2/transport/hpack_encoder_table.h",
        "src/core/ext/transport/chttp2/transport/hpack_parse_result.cc",
        "src/core/ext/transport/chttp2/transport/hpack_parse_result.h",
        "src/core/ext/transport/chttp2/transport/hpack_parser.cc",
        "src/core/ext/transport/chttp2/transport/hpack_parser.h",
        "src/core/ext/transport/chttp2/transport/hpack_parser_table.cc",
        "src/core/ext/transport/chttp2/transport/hpack_parser_table.h",
        "src/core/ext/transport/chttp2/transport/http2_settings.cc",
        "src/core/ext/transport/chttp2/transport/http2_settings.h",
        "src/core/ext/transport/chttp2/transport/http_trace.cc",
        "src/core/ext/transport/chttp2/transport/http_trace.h",
        "src/core/ext/transport/chttp2/transport/huffsyms.cc",
        "src/core/ext/transport/chttp2/transport/huffsyms.h",
        "src/core/ext/transport/chttp2/transport/internal.h",
        "src/core/ext/transport/chttp2/transport/legacy_frame.h",
        "src/core/ext/transport/chttp2/transport/max_concurrent_streams_policy.cc",
        "src/core/ext/transport/chttp2/transport/max_concurrent_streams_policy.h",
        "src/core/ext/transport/chttp2/transport/parsing.cc",
        "src/core/ext/transport/chttp2/transport/ping_abuse_policy.cc",
        "src/core/ext/transport/chttp2/transport/ping_abuse_policy.h",
        "src/core/ext/transport/chttp2/transport/ping_callbacks.cc",
        "src/core/ext/transport/chttp2/transport/ping_callbacks.h",
        "src/core/ext/transport/chttp2/transport/ping_rate_policy.cc",
        "src/core/ext/transport/chttp2/transport/ping_rate_policy.h",
        "src/core/ext/transport/chttp2/transport/stream_lists.cc",
        "src/core/ext/transport/chttp2/transport/varint.cc",
        "src/core/ext/transport/chttp2/transport/varint.h",
        "src/core/ext/transport/chttp2/transport/write_size_policy.cc",
        "src/core/ext/transport/chttp2/transport/write_size_policy.h",
        "src/core/ext/transport/chttp2/transport/writing.cc",
        "src/core/ext/transport/inproc/inproc_plugin.cc",
        "src/core/ext/transport/inproc/inproc_transport.cc",
        "src/core/ext/transport/inproc/inproc_transport.h",
        "src/core/ext/upb-generated/envoy/admin/v3/certs.upb.c",
        "src/core/ext/upb-generated/envoy/admin/v3/certs.upb.h",
        "src/core/ext/upb-generated/envoy/admin/v3/clusters.upb.c",
        "src/core/ext/upb-generated/envoy/admin/v3/clusters.upb.h",
        "src/core/ext/upb-generated/envoy/admin/v3/config_dump.upb.c",
        "src/core/ext/upb-generated/envoy/admin/v3/config_dump.upb.h",
        "src/core/ext/upb-generated/envoy/admin/v3/config_dump_shared.upb.c",
        "src/core/ext/upb-generated/envoy/admin/v3/config_dump_shared.upb.h",
        "src/core/ext/upb-generated/envoy/admin/v3/init_dump.upb.c",
        "src/core/ext/upb-generated/envoy/admin/v3/init_dump.upb.h",
        "src/core/ext/upb-generated/envoy/admin/v3/listeners.upb.c",
        "src/core/ext/upb-generated/envoy/admin/v3/listeners.upb.h",
        "src/core/ext/upb-generated/envoy/admin/v3/memory.upb.c",
        "src/core/ext/upb-generated/envoy/admin/v3/memory.upb.h",
        "src/core/ext/upb-generated/envoy/admin/v3/metrics.upb.c",
        "src/core/ext/upb-generated/envoy/admin/v3/metrics.upb.h",
        "src/core/ext/upb-generated/envoy/admin/v3/mutex_stats.upb.c",
        "src/core/ext/upb-generated/envoy/admin/v3/mutex_stats.upb.h",
        "src/core/ext/upb-generated/envoy/admin/v3/server_info.upb.c",
        "src/core/ext/upb-generated/envoy/admin/v3/server_info.upb.h",
        "src/core/ext/upb-generated/envoy/admin/v3/tap.upb.c",
        "src/core/ext/upb-generated/envoy/admin/v3/tap.upb.h",
        "src/core/ext/upb-generated/envoy/annotations/deprecation.upb.c",
        "src/core/ext/upb-generated/envoy/annotations/deprecation.upb.h",
        "src/core/ext/upb-generated/envoy/annotations/resource.upb.c",
        "src/core/ext/upb-generated/envoy/annotations/resource.upb.h",
        "src/core/ext/upb-generated/envoy/config/accesslog/v3/accesslog.upb.c",
        "src/core/ext/upb-generated/envoy/config/accesslog/v3/accesslog.upb.h",
        "src/core/ext/upb-generated/envoy/config/bootstrap/v3/bootstrap.upb.c",
        "src/core/ext/upb-generated/envoy/config/bootstrap/v3/bootstrap.upb.h",
        "src/core/ext/upb-generated/envoy/config/cluster/v3/circuit_breaker.upb.c",
        "src/core/ext/upb-generated/envoy/config/cluster/v3/circuit_breaker.upb.h",
        "src/core/ext/upb-generated/envoy/config/cluster/v3/cluster.upb.c",
        "src/core/ext/upb-generated/envoy/config/cluster/v3/cluster.upb.h",
        "src/core/ext/upb-generated/envoy/config/cluster/v3/filter.upb.c",
        "src/core/ext/upb-generated/envoy/config/cluster/v3/filter.upb.h",
        "src/core/ext/upb-generated/envoy/config/cluster/v3/outlier_detection.upb.c",
        "src/core/ext/upb-generated/envoy/config/cluster/v3/outlier_detection.upb.h",
        "src/core/ext/upb-generated/envoy/config/common/matcher/v3/matcher.upb.c",
        "src/core/ext/upb-generated/envoy/config/common/matcher/v3/matcher.upb.h",
        "src/core/ext/upb-generated/envoy/config/core/v3/address.upb.c",
        "src/core/ext/upb-generated/envoy/config/core/v3/address.upb.h",
        "src/core/ext/upb-generated/envoy/config/core/v3/backoff.upb.c",
        "src/core/ext/upb-generated/envoy/config/core/v3/backoff.upb.h",
        "src/core/ext/upb-generated/envoy/config/core/v3/base.upb.c",
        "src/core/ext/upb-generated/envoy/config/core/v3/base.upb.h",
        "src/core/ext/upb-generated/envoy/config/core/v3/config_source.upb.c",
        "src/core/ext/upb-generated/envoy/config/core/v3/config_source.upb.h",
        "src/core/ext/upb-generated/envoy/config/core/v3/event_service_config.upb.c",
        "src/core/ext/upb-generated/envoy/config/core/v3/event_service_config.upb.h",
        "src/core/ext/upb-generated/envoy/config/core/v3/extension.upb.c",
        "src/core/ext/upb-generated/envoy/config/core/v3/extension.upb.h",
        "src/core/ext/upb-generated/envoy/config/core/v3/grpc_method_list.upb.c",
        "src/core/ext/upb-generated/envoy/config/core/v3/grpc_method_list.upb.h",
        "src/core/ext/upb-generated/envoy/config/core/v3/grpc_service.upb.c",
        "src/core/ext/upb-generated/envoy/config/core/v3/grpc_service.upb.h",
        "src/core/ext/upb-generated/envoy/config/core/v3/health_check.upb.c",
        "src/core/ext/upb-generated/envoy/config/core/v3/health_check.upb.h",
        "src/core/ext/upb-generated/envoy/config/core/v3/http_uri.upb.c",
        "src/core/ext/upb-generated/envoy/config/core/v3/http_uri.upb.h",
        "src/core/ext/upb-generated/envoy/config/core/v3/protocol.upb.c",
        "src/core/ext/upb-generated/envoy/config/core/v3/protocol.upb.h",
        "src/core/ext/upb-generated/envoy/config/core/v3/proxy_protocol.upb.c",
        "src/core/ext/upb-generated/envoy/config/core/v3/proxy_protocol.upb.h",
        "src/core/ext/upb-generated/envoy/config/core/v3/resolver.upb.c",
        "src/core/ext/upb-generated/envoy/config/core/v3/resolver.upb.h",
        "src/core/ext/upb-generated/envoy/config/core/v3/socket_option.upb.c",
        "src/core/ext/upb-generated/envoy/config/core/v3/socket_option.upb.h",
        "src/core/ext/upb-generated/envoy/config/core/v3/substitution_format_string.upb.c",
        "src/core/ext/upb-generated/envoy/config/core/v3/substitution_format_string.upb.h",
        "src/core/ext/upb-generated/envoy/config/core/v3/udp_socket_config.upb.c",
        "src/core/ext/upb-generated/envoy/config/core/v3/udp_socket_config.upb.h",
        "src/core/ext/upb-generated/envoy/config/endpoint/v3/endpoint.upb.c",
        "src/core/ext/upb-generated/envoy/config/endpoint/v3/endpoint.upb.h",
        "src/core/ext/upb-generated/envoy/config/endpoint/v3/endpoint_components.upb.c",
        "src/core/ext/upb-generated/envoy/config/endpoint/v3/endpoint_components.upb.h",
        "src/core/ext/upb-generated/envoy/config/endpoint/v3/load_report.upb.c",
        "src/core/ext/upb-generated/envoy/config/endpoint/v3/load_report.upb.h",
        "src/core/ext/upb-generated/envoy/config/listener/v3/api_listener.upb.c",
        "src/core/ext/upb-generated/envoy/config/listener/v3/api_listener.upb.h",
        "src/core/ext/upb-generated/envoy/config/listener/v3/listener.upb.c",
        "src/core/ext/upb-generated/envoy/config/listener/v3/listener.upb.h",
        "src/core/ext/upb-generated/envoy/config/listener/v3/listener_components.upb.c",
        "src/core/ext/upb-generated/envoy/config/listener/v3/listener_components.upb.h",
        "src/core/ext/upb-generated/envoy/config/listener/v3/quic_config.upb.c",
        "src/core/ext/upb-generated/envoy/config/listener/v3/quic_config.upb.h",
        "src/core/ext/upb-generated/envoy/config/listener/v3/udp_listener_config.upb.c",
        "src/core/ext/upb-generated/envoy/config/listener/v3/udp_listener_config.upb.h",
        "src/core/ext/upb-generated/envoy/config/metrics/v3/metrics_service.upb.c",
        "src/core/ext/upb-generated/envoy/config/metrics/v3/metrics_service.upb.h",
        "src/core/ext/upb-generated/envoy/config/metrics/v3/stats.upb.c",
        "src/core/ext/upb-generated/envoy/config/metrics/v3/stats.upb.h",
        "src/core/ext/upb-generated/envoy/config/overload/v3/overload.upb.c",
        "src/core/ext/upb-generated/envoy/config/overload/v3/overload.upb.h",
        "src/core/ext/upb-generated/envoy/config/rbac/v3/rbac.upb.c",
        "src/core/ext/upb-generated/envoy/config/rbac/v3/rbac.upb.h",
        "src/core/ext/upb-generated/envoy/config/route/v3/route.upb.c",
        "src/core/ext/upb-generated/envoy/config/route/v3/route.upb.h",
        "src/core/ext/upb-generated/envoy/config/route/v3/route_components.upb.c",
        "src/core/ext/upb-generated/envoy/config/route/v3/route_components.upb.h",
        "src/core/ext/upb-generated/envoy/config/route/v3/scoped_route.upb.c",
        "src/core/ext/upb-generated/envoy/config/route/v3/scoped_route.upb.h",
        "src/core/ext/upb-generated/envoy/config/tap/v3/common.upb.c",
        "src/core/ext/upb-generated/envoy/config/tap/v3/common.upb.h",
        "src/core/ext/upb-generated/envoy/config/trace/v3/datadog.upb.c",
        "src/core/ext/upb-generated/envoy/config/trace/v3/datadog.upb.h",
        "src/core/ext/upb-generated/envoy/config/trace/v3/dynamic_ot.upb.c",
        "src/core/ext/upb-generated/envoy/config/trace/v3/dynamic_ot.upb.h",
        "src/core/ext/upb-generated/envoy/config/trace/v3/http_tracer.upb.c",
        "src/core/ext/upb-generated/envoy/config/trace/v3/http_tracer.upb.h",
        "src/core/ext/upb-generated/envoy/config/trace/v3/lightstep.upb.c",
        "src/core/ext/upb-generated/envoy/config/trace/v3/lightstep.upb.h",
        "src/core/ext/upb-generated/envoy/config/trace/v3/opencensus.upb.c",
        "src/core/ext/upb-generated/envoy/config/trace/v3/opencensus.upb.h",
        "src/core/ext/upb-generated/envoy/config/trace/v3/opentelemetry.upb.c",
        "src/core/ext/upb-generated/envoy/config/trace/v3/opentelemetry.upb.h",
        "src/core/ext/upb-generated/envoy/config/trace/v3/service.upb.c",
        "src/core/ext/upb-generated/envoy/config/trace/v3/service.upb.h",
        "src/core/ext/upb-generated/envoy/config/trace/v3/skywalking.upb.c",
        "src/core/ext/upb-generated/envoy/config/trace/v3/skywalking.upb.h",
        "src/core/ext/upb-generated/envoy/config/trace/v3/trace.upb.c",
        "src/core/ext/upb-generated/envoy/config/trace/v3/trace.upb.h",
        "src/core/ext/upb-generated/envoy/config/trace/v3/xray.upb.c",
        "src/core/ext/upb-generated/envoy/config/trace/v3/xray.upb.h",
        "src/core/ext/upb-generated/envoy/config/trace/v3/zipkin.upb.c",
        "src/core/ext/upb-generated/envoy/config/trace/v3/zipkin.upb.h",
        "src/core/ext/upb-generated/envoy/data/accesslog/v3/accesslog.upb.c",
        "src/core/ext/upb-generated/envoy/data/accesslog/v3/accesslog.upb.h",
        "src/core/ext/upb-generated/envoy/extensions/clusters/aggregate/v3/cluster.upb.c",
        "src/core/ext/upb-generated/envoy/extensions/clusters/aggregate/v3/cluster.upb.h",
        "src/core/ext/upb-generated/envoy/extensions/filters/common/fault/v3/fault.upb.c",
        "src/core/ext/upb-generated/envoy/extensions/filters/common/fault/v3/fault.upb.h",
        "src/core/ext/upb-generated/envoy/extensions/filters/http/fault/v3/fault.upb.c",
        "src/core/ext/upb-generated/envoy/extensions/filters/http/fault/v3/fault.upb.h",
        "src/core/ext/upb-generated/envoy/extensions/filters/http/rbac/v3/rbac.upb.c",
        "src/core/ext/upb-generated/envoy/extensions/filters/http/rbac/v3/rbac.upb.h",
        "src/core/ext/upb-generated/envoy/extensions/filters/http/router/v3/router.upb.c",
        "src/core/ext/upb-generated/envoy/extensions/filters/http/router/v3/router.upb.h",
        "src/core/ext/upb-generated/envoy/extensions/filters/http/stateful_session/v3/stateful_session.upb.c",
        "src/core/ext/upb-generated/envoy/extensions/filters/http/stateful_session/v3/stateful_session.upb.h",
        "src/core/ext/upb-generated/envoy/extensions/filters/network/http_connection_manager/v3/http_connection_manager.upb.c",
        "src/core/ext/upb-generated/envoy/extensions/filters/network/http_connection_manager/v3/http_connection_manager.upb.h",
        "src/core/ext/upb-generated/envoy/extensions/http/stateful_session/cookie/v3/cookie.upb.c",
        "src/core/ext/upb-generated/envoy/extensions/http/stateful_session/cookie/v3/cookie.upb.h",
        "src/core/ext/upb-generated/envoy/extensions/load_balancing_policies/client_side_weighted_round_robin/v3/client_side_weighted_round_robin.upb.c",
        "src/core/ext/upb-generated/envoy/extensions/load_balancing_policies/client_side_weighted_round_robin/v3/client_side_weighted_round_robin.upb.h",
        "src/core/ext/upb-generated/envoy/extensions/load_balancing_policies/common/v3/common.upb.c",
        "src/core/ext/upb-generated/envoy/extensions/load_balancing_policies/common/v3/common.upb.h",
        "src/core/ext/upb-generated/envoy/extensions/load_balancing_policies/pick_first/v3/pick_first.upb.c",
        "src/core/ext/upb-generated/envoy/extensions/load_balancing_policies/pick_first/v3/pick_first.upb.h",
        "src/core/ext/upb-generated/envoy/extensions/load_balancing_policies/ring_hash/v3/ring_hash.upb.c",
        "src/core/ext/upb-generated/envoy/extensions/load_balancing_policies/ring_hash/v3/ring_hash.upb.h",
        "src/core/ext/upb-generated/envoy/extensions/load_balancing_policies/wrr_locality/v3/wrr_locality.upb.c",
        "src/core/ext/upb-generated/envoy/extensions/load_balancing_policies/wrr_locality/v3/wrr_locality.upb.h",
        "src/core/ext/upb-generated/envoy/extensions/transport_sockets/tls/v3/cert.upb.c",
        "src/core/ext/upb-generated/envoy/extensions/transport_sockets/tls/v3/cert.upb.h",
        "src/core/ext/upb-generated/envoy/extensions/transport_sockets/tls/v3/common.upb.c",
        "src/core/ext/upb-generated/envoy/extensions/transport_sockets/tls/v3/common.upb.h",
        "src/core/ext/upb-generated/envoy/extensions/transport_sockets/tls/v3/secret.upb.c",
        "src/core/ext/upb-generated/envoy/extensions/transport_sockets/tls/v3/secret.upb.h",
        "src/core/ext/upb-generated/envoy/extensions/transport_sockets/tls/v3/tls.upb.c",
        "src/core/ext/upb-generated/envoy/extensions/transport_sockets/tls/v3/tls.upb.h",
        "src/core/ext/upb-generated/envoy/extensions/transport_sockets/tls/v3/tls_spiffe_validator_config.upb.c",
        "src/core/ext/upb-generated/envoy/extensions/transport_sockets/tls/v3/tls_spiffe_validator_config.upb.h",
        "src/core/ext/upb-generated/envoy/service/discovery/v3/ads.upb.c",
        "src/core/ext/upb-generated/envoy/service/discovery/v3/ads.upb.h",
        "src/core/ext/upb-generated/envoy/service/discovery/v3/discovery.upb.c",
        "src/core/ext/upb-generated/envoy/service/discovery/v3/discovery.upb.h",
        "src/core/ext/upb-generated/envoy/service/load_stats/v3/lrs.upb.c",
        "src/core/ext/upb-generated/envoy/service/load_stats/v3/lrs.upb.h",
        "src/core/ext/upb-generated/envoy/service/status/v3/csds.upb.c",
        "src/core/ext/upb-generated/envoy/service/status/v3/csds.upb.h",
        "src/core/ext/upb-generated/envoy/type/http/v3/cookie.upb.c",
        "src/core/ext/upb-generated/envoy/type/http/v3/cookie.upb.h",
        "src/core/ext/upb-generated/envoy/type/http/v3/path_transformation.upb.c",
        "src/core/ext/upb-generated/envoy/type/http/v3/path_transformation.upb.h",
        "src/core/ext/upb-generated/envoy/type/matcher/v3/filter_state.upb.c",
        "src/core/ext/upb-generated/envoy/type/matcher/v3/filter_state.upb.h",
        "src/core/ext/upb-generated/envoy/type/matcher/v3/http_inputs.upb.c",
        "src/core/ext/upb-generated/envoy/type/matcher/v3/http_inputs.upb.h",
        "src/core/ext/upb-generated/envoy/type/matcher/v3/metadata.upb.c",
        "src/core/ext/upb-generated/envoy/type/matcher/v3/metadata.upb.h",
        "src/core/ext/upb-generated/envoy/type/matcher/v3/node.upb.c",
        "src/core/ext/upb-generated/envoy/type/matcher/v3/node.upb.h",
        "src/core/ext/upb-generated/envoy/type/matcher/v3/number.upb.c",
        "src/core/ext/upb-generated/envoy/type/matcher/v3/number.upb.h",
        "src/core/ext/upb-generated/envoy/type/matcher/v3/path.upb.c",
        "src/core/ext/upb-generated/envoy/type/matcher/v3/path.upb.h",
        "src/core/ext/upb-generated/envoy/type/matcher/v3/regex.upb.c",
        "src/core/ext/upb-generated/envoy/type/matcher/v3/regex.upb.h",
        "src/core/ext/upb-generated/envoy/type/matcher/v3/status_code_input.upb.c",
        "src/core/ext/upb-generated/envoy/type/matcher/v3/status_code_input.upb.h",
        "src/core/ext/upb-generated/envoy/type/matcher/v3/string.upb.c",
        "src/core/ext/upb-generated/envoy/type/matcher/v3/string.upb.h",
        "src/core/ext/upb-generated/envoy/type/matcher/v3/struct.upb.c",
        "src/core/ext/upb-generated/envoy/type/matcher/v3/struct.upb.h",
        "src/core/ext/upb-generated/envoy/type/matcher/v3/value.upb.c",
        "src/core/ext/upb-generated/envoy/type/matcher/v3/value.upb.h",
        "src/core/ext/upb-generated/envoy/type/metadata/v3/metadata.upb.c",
        "src/core/ext/upb-generated/envoy/type/metadata/v3/metadata.upb.h",
        "src/core/ext/upb-generated/envoy/type/tracing/v3/custom_tag.upb.c",
        "src/core/ext/upb-generated/envoy/type/tracing/v3/custom_tag.upb.h",
        "src/core/ext/upb-generated/envoy/type/v3/hash_policy.upb.c",
        "src/core/ext/upb-generated/envoy/type/v3/hash_policy.upb.h",
        "src/core/ext/upb-generated/envoy/type/v3/http.upb.c",
        "src/core/ext/upb-generated/envoy/type/v3/http.upb.h",
        "src/core/ext/upb-generated/envoy/type/v3/http_status.upb.c",
        "src/core/ext/upb-generated/envoy/type/v3/http_status.upb.h",
        "src/core/ext/upb-generated/envoy/type/v3/percent.upb.c",
        "src/core/ext/upb-generated/envoy/type/v3/percent.upb.h",
        "src/core/ext/upb-generated/envoy/type/v3/range.upb.c",
        "src/core/ext/upb-generated/envoy/type/v3/range.upb.h",
        "src/core/ext/upb-generated/envoy/type/v3/ratelimit_strategy.upb.c",
        "src/core/ext/upb-generated/envoy/type/v3/ratelimit_strategy.upb.h",
        "src/core/ext/upb-generated/envoy/type/v3/ratelimit_unit.upb.c",
        "src/core/ext/upb-generated/envoy/type/v3/ratelimit_unit.upb.h",
        "src/core/ext/upb-generated/envoy/type/v3/semantic_version.upb.c",
        "src/core/ext/upb-generated/envoy/type/v3/semantic_version.upb.h",
        "src/core/ext/upb-generated/envoy/type/v3/token_bucket.upb.c",
        "src/core/ext/upb-generated/envoy/type/v3/token_bucket.upb.h",
        "src/core/ext/upb-generated/google/api/annotations.upb.c",
        "src/core/ext/upb-generated/google/api/annotations.upb.h",
        "src/core/ext/upb-generated/google/api/expr/v1alpha1/checked.upb.c",
        "src/core/ext/upb-generated/google/api/expr/v1alpha1/checked.upb.h",
        "src/core/ext/upb-generated/google/api/expr/v1alpha1/syntax.upb.c",
        "src/core/ext/upb-generated/google/api/expr/v1alpha1/syntax.upb.h",
        "src/core/ext/upb-generated/google/api/http.upb.c",
        "src/core/ext/upb-generated/google/api/http.upb.h",
        "src/core/ext/upb-generated/google/api/httpbody.upb.c",
        "src/core/ext/upb-generated/google/api/httpbody.upb.h",
        "src/core/ext/upb-generated/google/protobuf/any.upb.c",
        "src/core/ext/upb-generated/google/protobuf/any.upb.h",
        "src/core/ext/upb-generated/google/protobuf/descriptor.upb.c",
        "src/core/ext/upb-generated/google/protobuf/descriptor.upb.h",
        "src/core/ext/upb-generated/google/protobuf/duration.upb.c",
        "src/core/ext/upb-generated/google/protobuf/duration.upb.h",
        "src/core/ext/upb-generated/google/protobuf/empty.upb.c",
        "src/core/ext/upb-generated/google/protobuf/empty.upb.h",
        "src/core/ext/upb-generated/google/protobuf/struct.upb.c",
        "src/core/ext/upb-generated/google/protobuf/struct.upb.h",
        "src/core/ext/upb-generated/google/protobuf/timestamp.upb.c",
        "src/core/ext/upb-generated/google/protobuf/timestamp.upb.h",
        "src/core/ext/upb-generated/google/protobuf/wrappers.upb.c",
        "src/core/ext/upb-generated/google/protobuf/wrappers.upb.h",
        "src/core/ext/upb-generated/google/rpc/status.upb.c",
        "src/core/ext/upb-generated/google/rpc/status.upb.h",
        "src/core/ext/upb-generated/opencensus/proto/trace/v1/trace_config.upb.c",
        "src/core/ext/upb-generated/opencensus/proto/trace/v1/trace_config.upb.h",
        "src/core/ext/upb-generated/src/proto/grpc/gcp/altscontext.upb.c",
        "src/core/ext/upb-generated/src/proto/grpc/gcp/altscontext.upb.h",
        "src/core/ext/upb-generated/src/proto/grpc/gcp/handshaker.upb.c",
        "src/core/ext/upb-generated/src/proto/grpc/gcp/handshaker.upb.h",
        "src/core/ext/upb-generated/src/proto/grpc/gcp/transport_security_common.upb.c",
        "src/core/ext/upb-generated/src/proto/grpc/gcp/transport_security_common.upb.h",
        "src/core/ext/upb-generated/src/proto/grpc/health/v1/health.upb.c",
        "src/core/ext/upb-generated/src/proto/grpc/health/v1/health.upb.h",
        "src/core/ext/upb-generated/src/proto/grpc/lb/v1/load_balancer.upb.c",
        "src/core/ext/upb-generated/src/proto/grpc/lb/v1/load_balancer.upb.h",
        "src/core/ext/upb-generated/src/proto/grpc/lookup/v1/rls.upb.c",
        "src/core/ext/upb-generated/src/proto/grpc/lookup/v1/rls.upb.h",
        "src/core/ext/upb-generated/src/proto/grpc/lookup/v1/rls_config.upb.c",
        "src/core/ext/upb-generated/src/proto/grpc/lookup/v1/rls_config.upb.h",
        "src/core/ext/upb-generated/udpa/annotations/migrate.upb.c",
        "src/core/ext/upb-generated/udpa/annotations/migrate.upb.h",
        "src/core/ext/upb-generated/udpa/annotations/security.upb.c",
        "src/core/ext/upb-generated/udpa/annotations/security.upb.h",
        "src/core/ext/upb-generated/udpa/annotations/sensitive.upb.c",
        "src/core/ext/upb-generated/udpa/annotations/sensitive.upb.h",
        "src/core/ext/upb-generated/udpa/annotations/status.upb.c",
        "src/core/ext/upb-generated/udpa/annotations/status.upb.h",
        "src/core/ext/upb-generated/udpa/annotations/versioning.upb.c",
        "src/core/ext/upb-generated/udpa/annotations/versioning.upb.h",
        "src/core/ext/upb-generated/validate/validate.upb.c",
        "src/core/ext/upb-generated/validate/validate.upb.h",
        "src/core/ext/upb-generated/xds/annotations/v3/migrate.upb.c",
        "src/core/ext/upb-generated/xds/annotations/v3/migrate.upb.h",
        "src/core/ext/upb-generated/xds/annotations/v3/security.upb.c",
        "src/core/ext/upb-generated/xds/annotations/v3/security.upb.h",
        "src/core/ext/upb-generated/xds/annotations/v3/sensitive.upb.c",
        "src/core/ext/upb-generated/xds/annotations/v3/sensitive.upb.h",
        "src/core/ext/upb-generated/xds/annotations/v3/status.upb.c",
        "src/core/ext/upb-generated/xds/annotations/v3/status.upb.h",
        "src/core/ext/upb-generated/xds/annotations/v3/versioning.upb.c",
        "src/core/ext/upb-generated/xds/annotations/v3/versioning.upb.h",
        "src/core/ext/upb-generated/xds/core/v3/authority.upb.c",
        "src/core/ext/upb-generated/xds/core/v3/authority.upb.h",
        "src/core/ext/upb-generated/xds/core/v3/cidr.upb.c",
        "src/core/ext/upb-generated/xds/core/v3/cidr.upb.h",
        "src/core/ext/upb-generated/xds/core/v3/collection_entry.upb.c",
        "src/core/ext/upb-generated/xds/core/v3/collection_entry.upb.h",
        "src/core/ext/upb-generated/xds/core/v3/context_params.upb.c",
        "src/core/ext/upb-generated/xds/core/v3/context_params.upb.h",
        "src/core/ext/upb-generated/xds/core/v3/extension.upb.c",
        "src/core/ext/upb-generated/xds/core/v3/extension.upb.h",
        "src/core/ext/upb-generated/xds/core/v3/resource.upb.c",
        "src/core/ext/upb-generated/xds/core/v3/resource.upb.h",
        "src/core/ext/upb-generated/xds/core/v3/resource_locator.upb.c",
        "src/core/ext/upb-generated/xds/core/v3/resource_locator.upb.h",
        "src/core/ext/upb-generated/xds/core/v3/resource_name.upb.c",
        "src/core/ext/upb-generated/xds/core/v3/resource_name.upb.h",
        "src/core/ext/upb-generated/xds/data/orca/v3/orca_load_report.upb.c",
        "src/core/ext/upb-generated/xds/data/orca/v3/orca_load_report.upb.h",
        "src/core/ext/upb-generated/xds/service/orca/v3/orca.upb.c",
        "src/core/ext/upb-generated/xds/service/orca/v3/orca.upb.h",
        "src/core/ext/upb-generated/xds/type/matcher/v3/cel.upb.c",
        "src/core/ext/upb-generated/xds/type/matcher/v3/cel.upb.h",
        "src/core/ext/upb-generated/xds/type/matcher/v3/domain.upb.c",
        "src/core/ext/upb-generated/xds/type/matcher/v3/domain.upb.h",
        "src/core/ext/upb-generated/xds/type/matcher/v3/http_inputs.upb.c",
        "src/core/ext/upb-generated/xds/type/matcher/v3/http_inputs.upb.h",
        "src/core/ext/upb-generated/xds/type/matcher/v3/ip.upb.c",
        "src/core/ext/upb-generated/xds/type/matcher/v3/ip.upb.h",
        "src/core/ext/upb-generated/xds/type/matcher/v3/matcher.upb.c",
        "src/core/ext/upb-generated/xds/type/matcher/v3/matcher.upb.h",
        "src/core/ext/upb-generated/xds/type/matcher/v3/range.upb.c",
        "src/core/ext/upb-generated/xds/type/matcher/v3/range.upb.h",
        "src/core/ext/upb-generated/xds/type/matcher/v3/regex.upb.c",
        "src/core/ext/upb-generated/xds/type/matcher/v3/regex.upb.h",
        "src/core/ext/upb-generated/xds/type/matcher/v3/string.upb.c",
        "src/core/ext/upb-generated/xds/type/matcher/v3/string.upb.h",
        "src/core/ext/upb-generated/xds/type/v3/cel.upb.c",
        "src/core/ext/upb-generated/xds/type/v3/cel.upb.h",
        "src/core/ext/upb-generated/xds/type/v3/range.upb.c",
        "src/core/ext/upb-generated/xds/type/v3/range.upb.h",
        "src/core/ext/upb-generated/xds/type/v3/typed_struct.upb.c",
        "src/core/ext/upb-generated/xds/type/v3/typed_struct.upb.h",
        "src/core/ext/upbdefs-generated/envoy/admin/v3/certs.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/admin/v3/certs.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/admin/v3/clusters.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/admin/v3/clusters.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/admin/v3/config_dump.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/admin/v3/config_dump.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/admin/v3/config_dump_shared.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/admin/v3/config_dump_shared.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/admin/v3/init_dump.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/admin/v3/init_dump.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/admin/v3/listeners.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/admin/v3/listeners.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/admin/v3/memory.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/admin/v3/memory.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/admin/v3/metrics.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/admin/v3/metrics.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/admin/v3/mutex_stats.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/admin/v3/mutex_stats.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/admin/v3/server_info.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/admin/v3/server_info.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/admin/v3/tap.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/admin/v3/tap.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/annotations/deprecation.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/annotations/deprecation.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/annotations/resource.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/annotations/resource.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/config/accesslog/v3/accesslog.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/config/accesslog/v3/accesslog.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/config/bootstrap/v3/bootstrap.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/config/bootstrap/v3/bootstrap.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/config/cluster/v3/circuit_breaker.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/config/cluster/v3/circuit_breaker.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/config/cluster/v3/cluster.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/config/cluster/v3/cluster.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/config/cluster/v3/filter.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/config/cluster/v3/filter.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/config/cluster/v3/outlier_detection.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/config/cluster/v3/outlier_detection.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/config/common/matcher/v3/matcher.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/config/common/matcher/v3/matcher.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/config/core/v3/address.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/config/core/v3/address.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/config/core/v3/backoff.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/config/core/v3/backoff.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/config/core/v3/base.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/config/core/v3/base.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/config/core/v3/config_source.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/config/core/v3/config_source.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/config/core/v3/event_service_config.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/config/core/v3/event_service_config.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/config/core/v3/extension.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/config/core/v3/extension.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/config/core/v3/grpc_method_list.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/config/core/v3/grpc_method_list.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/config/core/v3/grpc_service.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/config/core/v3/grpc_service.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/config/core/v3/health_check.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/config/core/v3/health_check.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/config/core/v3/http_uri.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/config/core/v3/http_uri.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/config/core/v3/protocol.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/config/core/v3/protocol.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/config/core/v3/proxy_protocol.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/config/core/v3/proxy_protocol.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/config/core/v3/resolver.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/config/core/v3/resolver.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/config/core/v3/socket_option.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/config/core/v3/socket_option.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/config/core/v3/substitution_format_string.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/config/core/v3/substitution_format_string.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/config/core/v3/udp_socket_config.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/config/core/v3/udp_socket_config.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/config/endpoint/v3/endpoint.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/config/endpoint/v3/endpoint.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/config/endpoint/v3/endpoint_components.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/config/endpoint/v3/endpoint_components.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/config/endpoint/v3/load_report.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/config/endpoint/v3/load_report.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/config/listener/v3/api_listener.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/config/listener/v3/api_listener.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/config/listener/v3/listener.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/config/listener/v3/listener.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/config/listener/v3/listener_components.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/config/listener/v3/listener_components.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/config/listener/v3/quic_config.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/config/listener/v3/quic_config.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/config/listener/v3/udp_listener_config.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/config/listener/v3/udp_listener_config.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/config/metrics/v3/metrics_service.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/config/metrics/v3/metrics_service.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/config/metrics/v3/stats.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/config/metrics/v3/stats.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/config/overload/v3/overload.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/config/overload/v3/overload.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/config/rbac/v3/rbac.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/config/rbac/v3/rbac.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/config/route/v3/route.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/config/route/v3/route.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/config/route/v3/route_components.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/config/route/v3/route_components.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/config/route/v3/scoped_route.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/config/route/v3/scoped_route.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/config/tap/v3/common.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/config/tap/v3/common.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/config/trace/v3/datadog.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/config/trace/v3/datadog.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/config/trace/v3/dynamic_ot.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/config/trace/v3/dynamic_ot.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/config/trace/v3/http_tracer.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/config/trace/v3/http_tracer.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/config/trace/v3/lightstep.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/config/trace/v3/lightstep.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/config/trace/v3/opencensus.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/config/trace/v3/opencensus.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/config/trace/v3/opentelemetry.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/config/trace/v3/opentelemetry.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/config/trace/v3/service.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/config/trace/v3/service.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/config/trace/v3/skywalking.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/config/trace/v3/skywalking.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/config/trace/v3/trace.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/config/trace/v3/trace.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/config/trace/v3/xray.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/config/trace/v3/xray.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/config/trace/v3/zipkin.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/config/trace/v3/zipkin.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/data/accesslog/v3/accesslog.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/data/accesslog/v3/accesslog.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/extensions/clusters/aggregate/v3/cluster.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/extensions/clusters/aggregate/v3/cluster.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/extensions/filters/common/fault/v3/fault.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/extensions/filters/common/fault/v3/fault.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/extensions/filters/http/fault/v3/fault.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/extensions/filters/http/fault/v3/fault.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/extensions/filters/http/rbac/v3/rbac.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/extensions/filters/http/rbac/v3/rbac.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/extensions/filters/http/router/v3/router.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/extensions/filters/http/router/v3/router.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/extensions/filters/http/stateful_session/v3/stateful_session.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/extensions/filters/http/stateful_session/v3/stateful_session.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/extensions/filters/network/http_connection_manager/v3/http_connection_manager.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/extensions/filters/network/http_connection_manager/v3/http_connection_manager.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/extensions/http/stateful_session/cookie/v3/cookie.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/extensions/http/stateful_session/cookie/v3/cookie.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/extensions/transport_sockets/tls/v3/cert.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/extensions/transport_sockets/tls/v3/cert.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/extensions/transport_sockets/tls/v3/common.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/extensions/transport_sockets/tls/v3/common.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/extensions/transport_sockets/tls/v3/secret.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/extensions/transport_sockets/tls/v3/secret.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/extensions/transport_sockets/tls/v3/tls.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/extensions/transport_sockets/tls/v3/tls.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/extensions/transport_sockets/tls/v3/tls_spiffe_validator_config.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/extensions/transport_sockets/tls/v3/tls_spiffe_validator_config.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/service/discovery/v3/ads.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/service/discovery/v3/ads.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/service/discovery/v3/discovery.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/service/discovery/v3/discovery.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/service/load_stats/v3/lrs.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/service/load_stats/v3/lrs.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/service/status/v3/csds.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/service/status/v3/csds.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/type/http/v3/cookie.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/type/http/v3/cookie.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/type/http/v3/path_transformation.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/type/http/v3/path_transformation.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/type/matcher/v3/filter_state.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/type/matcher/v3/filter_state.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/type/matcher/v3/http_inputs.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/type/matcher/v3/http_inputs.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/type/matcher/v3/metadata.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/type/matcher/v3/metadata.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/type/matcher/v3/node.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/type/matcher/v3/node.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/type/matcher/v3/number.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/type/matcher/v3/number.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/type/matcher/v3/path.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/type/matcher/v3/path.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/type/matcher/v3/regex.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/type/matcher/v3/regex.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/type/matcher/v3/status_code_input.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/type/matcher/v3/status_code_input.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/type/matcher/v3/string.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/type/matcher/v3/string.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/type/matcher/v3/struct.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/type/matcher/v3/struct.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/type/matcher/v3/value.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/type/matcher/v3/value.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/type/metadata/v3/metadata.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/type/metadata/v3/metadata.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/type/tracing/v3/custom_tag.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/type/tracing/v3/custom_tag.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/type/v3/hash_policy.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/type/v3/hash_policy.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/type/v3/http.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/type/v3/http.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/type/v3/http_status.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/type/v3/http_status.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/type/v3/percent.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/type/v3/percent.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/type/v3/range.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/type/v3/range.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/type/v3/ratelimit_strategy.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/type/v3/ratelimit_strategy.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/type/v3/ratelimit_unit.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/type/v3/ratelimit_unit.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/type/v3/semantic_version.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/type/v3/semantic_version.upbdefs.h",
        "src/core/ext/upbdefs-generated/envoy/type/v3/token_bucket.upbdefs.c",
        "src/core/ext/upbdefs-generated/envoy/type/v3/token_bucket.upbdefs.h",
        "src/core/ext/upbdefs-generated/google/api/annotations.upbdefs.c",
        "src/core/ext/upbdefs-generated/google/api/annotations.upbdefs.h",
        "src/core/ext/upbdefs-generated/google/api/expr/v1alpha1/checked.upbdefs.c",
        "src/core/ext/upbdefs-generated/google/api/expr/v1alpha1/checked.upbdefs.h",
        "src/core/ext/upbdefs-generated/google/api/expr/v1alpha1/syntax.upbdefs.c",
        "src/core/ext/upbdefs-generated/google/api/expr/v1alpha1/syntax.upbdefs.h",
        "src/core/ext/upbdefs-generated/google/api/http.upbdefs.c",
        "src/core/ext/upbdefs-generated/google/api/http.upbdefs.h",
        "src/core/ext/upbdefs-generated/google/api/httpbody.upbdefs.c",
        "src/core/ext/upbdefs-generated/google/api/httpbody.upbdefs.h",
        "src/core/ext/upbdefs-generated/google/protobuf/any.upbdefs.c",
        "src/core/ext/upbdefs-generated/google/protobuf/any.upbdefs.h",
        "src/core/ext/upbdefs-generated/google/protobuf/descriptor.upbdefs.c",
        "src/core/ext/upbdefs-generated/google/protobuf/descriptor.upbdefs.h",
        "src/core/ext/upbdefs-generated/google/protobuf/duration.upbdefs.c",
        "src/core/ext/upbdefs-generated/google/protobuf/duration.upbdefs.h",
        "src/core/ext/upbdefs-generated/google/protobuf/empty.upbdefs.c",
        "src/core/ext/upbdefs-generated/google/protobuf/empty.upbdefs.h",
        "src/core/ext/upbdefs-generated/google/protobuf/struct.upbdefs.c",
        "src/core/ext/upbdefs-generated/google/protobuf/struct.upbdefs.h",
        "src/core/ext/upbdefs-generated/google/protobuf/timestamp.upbdefs.c",
        "src/core/ext/upbdefs-generated/google/protobuf/timestamp.upbdefs.h",
        "src/core/ext/upbdefs-generated/google/protobuf/wrappers.upbdefs.c",
        "src/core/ext/upbdefs-generated/google/protobuf/wrappers.upbdefs.h",
        "src/core/ext/upbdefs-generated/google/rpc/status.upbdefs.c",
        "src/core/ext/upbdefs-generated/google/rpc/status.upbdefs.h",
        "src/core/ext/upbdefs-generated/opencensus/proto/trace/v1/trace_config.upbdefs.c",
        "src/core/ext/upbdefs-generated/opencensus/proto/trace/v1/trace_config.upbdefs.h",
        "src/core/ext/upbdefs-generated/src/proto/grpc/lookup/v1/rls_config.upbdefs.c",
        "src/core/ext/upbdefs-generated/src/proto/grpc/lookup/v1/rls_config.upbdefs.h",
        "src/core/ext/upbdefs-generated/udpa/annotations/migrate.upbdefs.c",
        "src/core/ext/upbdefs-generated/udpa/annotations/migrate.upbdefs.h",
        "src/core/ext/upbdefs-generated/udpa/annotations/security.upbdefs.c",
        "src/core/ext/upbdefs-generated/udpa/annotations/security.upbdefs.h",
        "src/core/ext/upbdefs-generated/udpa/annotations/sensitive.upbdefs.c",
        "src/core/ext/upbdefs-generated/udpa/annotations/sensitive.upbdefs.h",
        "src/core/ext/upbdefs-generated/udpa/annotations/status.upbdefs.c",
        "src/core/ext/upbdefs-generated/udpa/annotations/status.upbdefs.h",
        "src/core/ext/upbdefs-generated/udpa/annotations/versioning.upbdefs.c",
        "src/core/ext/upbdefs-generated/udpa/annotations/versioning.upbdefs.h",
        "src/core/ext/upbdefs-generated/validate/validate.upbdefs.c",
        "src/core/ext/upbdefs-generated/validate/validate.upbdefs.h",
        "src/core/ext/upbdefs-generated/xds/annotations/v3/migrate.upbdefs.c",
        "src/core/ext/upbdefs-generated/xds/annotations/v3/migrate.upbdefs.h",
        "src/core/ext/upbdefs-generated/xds/annotations/v3/security.upbdefs.c",
        "src/core/ext/upbdefs-generated/xds/annotations/v3/security.upbdefs.h",
        "src/core/ext/upbdefs-generated/xds/annotations/v3/sensitive.upbdefs.c",
        "src/core/ext/upbdefs-generated/xds/annotations/v3/sensitive.upbdefs.h",
        "src/core/ext/upbdefs-generated/xds/annotations/v3/status.upbdefs.c",
        "src/core/ext/upbdefs-generated/xds/annotations/v3/status.upbdefs.h",
        "src/core/ext/upbdefs-generated/xds/annotations/v3/versioning.upbdefs.c",
        "src/core/ext/upbdefs-generated/xds/annotations/v3/versioning.upbdefs.h",
        "src/core/ext/upbdefs-generated/xds/core/v3/authority.upbdefs.c",
        "src/core/ext/upbdefs-generated/xds/core/v3/authority.upbdefs.h",
        "src/core/ext/upbdefs-generated/xds/core/v3/cidr.upbdefs.c",
        "src/core/ext/upbdefs-generated/xds/core/v3/cidr.upbdefs.h",
        "src/core/ext/upbdefs-generated/xds/core/v3/collection_entry.upbdefs.c",
        "src/core/ext/upbdefs-generated/xds/core/v3/collection_entry.upbdefs.h",
        "src/core/ext/upbdefs-generated/xds/core/v3/context_params.upbdefs.c",
        "src/core/ext/upbdefs-generated/xds/core/v3/context_params.upbdefs.h",
        "src/core/ext/upbdefs-generated/xds/core/v3/extension.upbdefs.c",
        "src/core/ext/upbdefs-generated/xds/core/v3/extension.upbdefs.h",
        "src/core/ext/upbdefs-generated/xds/core/v3/resource.upbdefs.c",
        "src/core/ext/upbdefs-generated/xds/core/v3/resource.upbdefs.h",
        "src/core/ext/upbdefs-generated/xds/core/v3/resource_locator.upbdefs.c",
        "src/core/ext/upbdefs-generated/xds/core/v3/resource_locator.upbdefs.h",
        "src/core/ext/upbdefs-generated/xds/core/v3/resource_name.upbdefs.c",
        "src/core/ext/upbdefs-generated/xds/core/v3/resource_name.upbdefs.h",
        "src/core/ext/upbdefs-generated/xds/type/matcher/v3/cel.upbdefs.c",
        "src/core/ext/upbdefs-generated/xds/type/matcher/v3/cel.upbdefs.h",
        "src/core/ext/upbdefs-generated/xds/type/matcher/v3/domain.upbdefs.c",
        "src/core/ext/upbdefs-generated/xds/type/matcher/v3/domain.upbdefs.h",
        "src/core/ext/upbdefs-generated/xds/type/matcher/v3/http_inputs.upbdefs.c",
        "src/core/ext/upbdefs-generated/xds/type/matcher/v3/http_inputs.upbdefs.h",
        "src/core/ext/upbdefs-generated/xds/type/matcher/v3/ip.upbdefs.c",
        "src/core/ext/upbdefs-generated/xds/type/matcher/v3/ip.upbdefs.h",
        "src/core/ext/upbdefs-generated/xds/type/matcher/v3/matcher.upbdefs.c",
        "src/core/ext/upbdefs-generated/xds/type/matcher/v3/matcher.upbdefs.h",
        "src/core/ext/upbdefs-generated/xds/type/matcher/v3/range.upbdefs.c",
        "src/core/ext/upbdefs-generated/xds/type/matcher/v3/range.upbdefs.h",
        "src/core/ext/upbdefs-generated/xds/type/matcher/v3/regex.upbdefs.c",
        "src/core/ext/upbdefs-generated/xds/type/matcher/v3/regex.upbdefs.h",
        "src/core/ext/upbdefs-generated/xds/type/matcher/v3/string.upbdefs.c",
        "src/core/ext/upbdefs-generated/xds/type/matcher/v3/string.upbdefs.h",
        "src/core/ext/upbdefs-generated/xds/type/v3/cel.upbdefs.c",
        "src/core/ext/upbdefs-generated/xds/type/v3/cel.upbdefs.h",
        "src/core/ext/upbdefs-generated/xds/type/v3/range.upbdefs.c",
        "src/core/ext/upbdefs-generated/xds/type/v3/range.upbdefs.h",
        "src/core/ext/upbdefs-generated/xds/type/v3/typed_struct.upbdefs.c",
        "src/core/ext/upbdefs-generated/xds/type/v3/typed_struct.upbdefs.h",
        "src/core/ext/xds/certificate_provider_store.cc",
        "src/core/ext/xds/certificate_provider_store.h",
        "src/core/ext/xds/file_watcher_certificate_provider_factory.cc",
        "src/core/ext/xds/file_watcher_certificate_provider_factory.h",
        "src/core/ext/xds/upb_utils.h",
        "src/core/ext/xds/xds_api.cc",
        "src/core/ext/xds/xds_api.h",
        "src/core/ext/xds/xds_audit_logger_registry.cc",
        "src/core/ext/xds/xds_audit_logger_registry.h",
        "src/core/ext/xds/xds_bootstrap.cc",
        "src/core/ext/xds/xds_bootstrap.h",
        "src/core/ext/xds/xds_bootstrap_grpc.cc",
        "src/core/ext/xds/xds_bootstrap_grpc.h",
        "src/core/ext/xds/xds_certificate_provider.cc",
        "src/core/ext/xds/xds_certificate_provider.h",
        "src/core/ext/xds/xds_channel_args.h",
        "src/core/ext/xds/xds_channel_stack_modifier.cc",
        "src/core/ext/xds/xds_channel_stack_modifier.h",
        "src/core/ext/xds/xds_client.cc",
        "src/core/ext/xds/xds_client.h",
        "src/core/ext/xds/xds_client_grpc.cc",
        "src/core/ext/xds/xds_client_grpc.h",
        "src/core/ext/xds/xds_client_stats.cc",
        "src/core/ext/xds/xds_client_stats.h",
        "src/core/ext/xds/xds_cluster.cc",
        "src/core/ext/xds/xds_cluster.h",
        "src/core/ext/xds/xds_cluster_specifier_plugin.cc",
        "src/core/ext/xds/xds_cluster_specifier_plugin.h",
        "src/core/ext/xds/xds_common_types.cc",
        "src/core/ext/xds/xds_common_types.h",
        "src/core/ext/xds/xds_endpoint.cc",
        "src/core/ext/xds/xds_endpoint.h",
        "src/core/ext/xds/xds_health_status.cc",
        "src/core/ext/xds/xds_health_status.h",
        "src/core/ext/xds/xds_http_fault_filter.cc",
        "src/core/ext/xds/xds_http_fault_filter.h",
        "src/core/ext/xds/xds_http_filters.cc",
        "src/core/ext/xds/xds_http_filters.h",
        "src/core/ext/xds/xds_http_rbac_filter.cc",
        "src/core/ext/xds/xds_http_rbac_filter.h",
        "src/core/ext/xds/xds_http_stateful_session_filter.cc",
        "src/core/ext/xds/xds_http_stateful_session_filter.h",
        "src/core/ext/xds/xds_lb_policy_registry.cc",
        "src/core/ext/xds/xds_lb_policy_registry.h",
        "src/core/ext/xds/xds_listener.cc",
        "src/core/ext/xds/xds_listener.h",
        "src/core/ext/xds/xds_resource_type.h",
        "src/core/ext/xds/xds_resource_type_impl.h",
        "src/core/ext/xds/xds_route_config.cc",
        "src/core/ext/xds/xds_route_config.h",
        "src/core/ext/xds/xds_routing.cc",
        "src/core/ext/xds/xds_routing.h",
        "src/core/ext/xds/xds_server_config_fetcher.cc",
        "src/core/ext/xds/xds_transport.h",
        "src/core/ext/xds/xds_transport_grpc.cc",
        "src/core/ext/xds/xds_transport_grpc.h",
        "src/core/lib/address_utils/parse_address.cc",
        "src/core/lib/address_utils/parse_address.h",
        "src/core/lib/address_utils/sockaddr_utils.cc",
        "src/core/lib/address_utils/sockaddr_utils.h",
        "src/core/lib/avl/avl.h",
        "src/core/lib/backoff/backoff.cc",
        "src/core/lib/backoff/backoff.h",
        "src/core/lib/backoff/random_early_detection.cc",
        "src/core/lib/backoff/random_early_detection.h",
        "src/core/lib/channel/call_finalization.h",
        "src/core/lib/channel/call_tracer.cc",
        "src/core/lib/channel/call_tracer.h",
        "src/core/lib/channel/channel_args.cc",
        "src/core/lib/channel/channel_args.h",
        "src/core/lib/channel/channel_args_preconditioning.cc",
        "src/core/lib/channel/channel_args_preconditioning.h",
        "src/core/lib/channel/channel_fwd.h",
        "src/core/lib/channel/channel_stack.cc",
        "src/core/lib/channel/channel_stack.h",
        "src/core/lib/channel/channel_stack_builder.cc",
        "src/core/lib/channel/channel_stack_builder.h",
        "src/core/lib/channel/channel_stack_builder_impl.cc",
        "src/core/lib/channel/channel_stack_builder_impl.h",
        "src/core/lib/channel/channel_trace.cc",
        "src/core/lib/channel/channel_trace.h",
        "src/core/lib/channel/channelz.cc",
        "src/core/lib/channel/channelz.h",
        "src/core/lib/channel/channelz_registry.cc",
        "src/core/lib/channel/channelz_registry.h",
        "src/core/lib/channel/connected_channel.cc",
        "src/core/lib/channel/connected_channel.h",
        "src/core/lib/channel/context.h",
        "src/core/lib/channel/promise_based_filter.cc",
        "src/core/lib/channel/promise_based_filter.h",
        "src/core/lib/channel/server_call_tracer_filter.cc",
        "src/core/lib/channel/status_util.cc",
        "src/core/lib/channel/status_util.h",
        "src/core/lib/compression/compression.cc",
        "src/core/lib/compression/compression_internal.cc",
        "src/core/lib/compression/compression_internal.h",
        "src/core/lib/compression/message_compress.cc",
        "src/core/lib/compression/message_compress.h",
        "src/core/lib/config/config_vars.cc",
        "src/core/lib/config/config_vars.h",
        "src/core/lib/config/config_vars_non_generated.cc",
        "src/core/lib/config/core_configuration.cc",
        "src/core/lib/config/core_configuration.h",
        "src/core/lib/config/load_config.cc",
        "src/core/lib/config/load_config.h",
        "src/core/lib/debug/event_log.cc",
        "src/core/lib/debug/event_log.h",
        "src/core/lib/debug/histogram_view.cc",
        "src/core/lib/debug/histogram_view.h",
        "src/core/lib/debug/stats.cc",
        "src/core/lib/debug/stats.h",
        "src/core/lib/debug/stats_data.cc",
        "src/core/lib/debug/stats_data.h",
        "src/core/lib/debug/trace.cc",
        "src/core/lib/debug/trace.h",
        "src/core/lib/event_engine/ares_resolver.cc",
        "src/core/lib/event_engine/ares_resolver.h",
        "src/core/lib/event_engine/cf_engine/cf_engine.cc",
        "src/core/lib/event_engine/cf_engine/cf_engine.h",
        "src/core/lib/event_engine/cf_engine/cfstream_endpoint.cc",
        "src/core/lib/event_engine/cf_engine/cfstream_endpoint.h",
        "src/core/lib/event_engine/cf_engine/cftype_unique_ref.h",
        "src/core/lib/event_engine/cf_engine/dns_service_resolver.cc",
        "src/core/lib/event_engine/cf_engine/dns_service_resolver.h",
        "src/core/lib/event_engine/channel_args_endpoint_config.cc",
        "src/core/lib/event_engine/channel_args_endpoint_config.h",
        "src/core/lib/event_engine/common_closures.h",
        "src/core/lib/event_engine/default_event_engine.cc",
        "src/core/lib/event_engine/default_event_engine.h",
        "src/core/lib/event_engine/default_event_engine_factory.cc",
        "src/core/lib/event_engine/default_event_engine_factory.h",
        "src/core/lib/event_engine/event_engine.cc",
        "src/core/lib/event_engine/forkable.cc",
        "src/core/lib/event_engine/forkable.h",
        "src/core/lib/event_engine/grpc_polled_fd.h",
        "src/core/lib/event_engine/handle_containers.h",
        "src/core/lib/event_engine/memory_allocator.cc",
        "src/core/lib/event_engine/memory_allocator_factory.h",
        "src/core/lib/event_engine/nameser.h",
        "src/core/lib/event_engine/poller.h",
        "src/core/lib/event_engine/posix.h",
        "src/core/lib/event_engine/posix_engine/ev_epoll1_linux.cc",
        "src/core/lib/event_engine/posix_engine/ev_epoll1_linux.h",
        "src/core/lib/event_engine/posix_engine/ev_poll_posix.cc",
        "src/core/lib/event_engine/posix_engine/ev_poll_posix.h",
        "src/core/lib/event_engine/posix_engine/event_poller.h",
        "src/core/lib/event_engine/posix_engine/event_poller_posix_default.cc",
        "src/core/lib/event_engine/posix_engine/event_poller_posix_default.h",
        "src/core/lib/event_engine/posix_engine/grpc_polled_fd_posix.h",
        "src/core/lib/event_engine/posix_engine/internal_errqueue.cc",
        "src/core/lib/event_engine/posix_engine/internal_errqueue.h",
        "src/core/lib/event_engine/posix_engine/lockfree_event.cc",
        "src/core/lib/event_engine/posix_engine/lockfree_event.h",
        "src/core/lib/event_engine/posix_engine/posix_endpoint.cc",
        "src/core/lib/event_engine/posix_engine/posix_endpoint.h",
        "src/core/lib/event_engine/posix_engine/posix_engine.cc",
        "src/core/lib/event_engine/posix_engine/posix_engine.h",
        "src/core/lib/event_engine/posix_engine/posix_engine_closure.h",
        "src/core/lib/event_engine/posix_engine/posix_engine_listener.cc",
        "src/core/lib/event_engine/posix_engine/posix_engine_listener.h",
        "src/core/lib/event_engine/posix_engine/posix_engine_listener_utils.cc",
        "src/core/lib/event_engine/posix_engine/posix_engine_listener_utils.h",
        "src/core/lib/event_engine/posix_engine/tcp_socket_utils.cc",
        "src/core/lib/event_engine/posix_engine/tcp_socket_utils.h",
        "src/core/lib/event_engine/posix_engine/timer.cc",
        "src/core/lib/event_engine/posix_engine/timer.h",
        "src/core/lib/event_engine/posix_engine/timer_heap.cc",
        "src/core/lib/event_engine/posix_engine/timer_heap.h",
        "src/core/lib/event_engine/posix_engine/timer_manager.cc",
        "src/core/lib/event_engine/posix_engine/timer_manager.h",
        "src/core/lib/event_engine/posix_engine/traced_buffer_list.cc",
        "src/core/lib/event_engine/posix_engine/traced_buffer_list.h",
        "src/core/lib/event_engine/posix_engine/wakeup_fd_eventfd.cc",
        "src/core/lib/event_engine/posix_engine/wakeup_fd_eventfd.h",
        "src/core/lib/event_engine/posix_engine/wakeup_fd_pipe.cc",
        "src/core/lib/event_engine/posix_engine/wakeup_fd_pipe.h",
        "src/core/lib/event_engine/posix_engine/wakeup_fd_posix.h",
        "src/core/lib/event_engine/posix_engine/wakeup_fd_posix_default.cc",
        "src/core/lib/event_engine/posix_engine/wakeup_fd_posix_default.h",
        "src/core/lib/event_engine/resolved_address.cc",
        "src/core/lib/event_engine/resolved_address_internal.h",
        "src/core/lib/event_engine/shim.cc",
        "src/core/lib/event_engine/shim.h",
        "src/core/lib/event_engine/slice.cc",
        "src/core/lib/event_engine/slice_buffer.cc",
        "src/core/lib/event_engine/tcp_socket_utils.cc",
        "src/core/lib/event_engine/tcp_socket_utils.h",
        "src/core/lib/event_engine/thread_local.cc",
        "src/core/lib/event_engine/thread_local.h",
        "src/core/lib/event_engine/thread_pool/thread_count.cc",
        "src/core/lib/event_engine/thread_pool/thread_count.h",
        "src/core/lib/event_engine/thread_pool/thread_pool.h",
        "src/core/lib/event_engine/thread_pool/thread_pool_factory.cc",
        "src/core/lib/event_engine/thread_pool/work_stealing_thread_pool.cc",
        "src/core/lib/event_engine/thread_pool/work_stealing_thread_pool.h",
        "src/core/lib/event_engine/thready_event_engine/thready_event_engine.cc",
        "src/core/lib/event_engine/thready_event_engine/thready_event_engine.h",
        "src/core/lib/event_engine/time_util.cc",
        "src/core/lib/event_engine/time_util.h",
        "src/core/lib/event_engine/trace.cc",
        "src/core/lib/event_engine/trace.h",
        "src/core/lib/event_engine/utils.cc",
        "src/core/lib/event_engine/utils.h",
        "src/core/lib/event_engine/windows/iocp.cc",
        "src/core/lib/event_engine/windows/iocp.h",
        "src/core/lib/event_engine/windows/win_socket.cc",
        "src/core/lib/event_engine/windows/win_socket.h",
        "src/core/lib/event_engine/windows/windows_endpoint.cc",
        "src/core/lib/event_engine/windows/windows_endpoint.h",
        "src/core/lib/event_engine/windows/windows_engine.cc",
        "src/core/lib/event_engine/windows/windows_engine.h",
        "src/core/lib/event_engine/windows/windows_listener.cc",
        "src/core/lib/event_engine/windows/windows_listener.h",
        "src/core/lib/event_engine/work_queue/basic_work_queue.cc",
        "src/core/lib/event_engine/work_queue/basic_work_queue.h",
        "src/core/lib/event_engine/work_queue/work_queue.h",
        "src/core/lib/experiments/config.cc",
        "src/core/lib/experiments/config.h",
        "src/core/lib/experiments/experiments.cc",
        "src/core/lib/experiments/experiments.h",
        "src/core/lib/gpr/alloc.cc",
        "src/core/lib/gpr/alloc.h",
        "src/core/lib/gpr/android/log.cc",
        "src/core/lib/gpr/atm.cc",
        "src/core/lib/gpr/iphone/cpu.cc",
        "src/core/lib/gpr/linux/cpu.cc",
        "src/core/lib/gpr/linux/log.cc",
        "src/core/lib/gpr/log.cc",
        "src/core/lib/gpr/log_internal.h",
        "src/core/lib/gpr/msys/tmpfile.cc",
        "src/core/lib/gpr/posix/cpu.cc",
        "src/core/lib/gpr/posix/log.cc",
        "src/core/lib/gpr/posix/string.cc",
        "src/core/lib/gpr/posix/sync.cc",
        "src/core/lib/gpr/posix/time.cc",
        "src/core/lib/gpr/posix/tmpfile.cc",
        "src/core/lib/gpr/spinlock.h",
        "src/core/lib/gpr/string.cc",
        "src/core/lib/gpr/string.h",
        "src/core/lib/gpr/sync.cc",
        "src/core/lib/gpr/sync_abseil.cc",
        "src/core/lib/gpr/time.cc",
        "src/core/lib/gpr/time_precise.cc",
        "src/core/lib/gpr/time_precise.h",
        "src/core/lib/gpr/tmpfile.h",
        "src/core/lib/gpr/useful.h",
        "src/core/lib/gpr/windows/cpu.cc",
        "src/core/lib/gpr/windows/log.cc",
        "src/core/lib/gpr/windows/string.cc",
        "src/core/lib/gpr/windows/string_util.cc",
        "src/core/lib/gpr/windows/sync.cc",
        "src/core/lib/gpr/windows/time.cc",
        "src/core/lib/gpr/windows/tmpfile.cc",
        "src/core/lib/gpr/wrap_memcpy.cc",
        "src/core/lib/gprpp/atomic_utils.h",
        "src/core/lib/gprpp/bitset.h",
        "src/core/lib/gprpp/chunked_vector.h",
        "src/core/lib/gprpp/construct_destruct.h",
        "src/core/lib/gprpp/cpp_impl_of.h",
        "src/core/lib/gprpp/crash.cc",
        "src/core/lib/gprpp/crash.h",
        "src/core/lib/gprpp/debug_location.h",
        "src/core/lib/gprpp/directory_reader.h",
        "src/core/lib/gprpp/dual_ref_counted.h",
        "src/core/lib/gprpp/env.h",
        "src/core/lib/gprpp/examine_stack.cc",
        "src/core/lib/gprpp/examine_stack.h",
        "src/core/lib/gprpp/fork.cc",
        "src/core/lib/gprpp/fork.h",
        "src/core/lib/gprpp/host_port.cc",
        "src/core/lib/gprpp/host_port.h",
        "src/core/lib/gprpp/if_list.h",
        "src/core/lib/gprpp/linux/env.cc",
        "src/core/lib/gprpp/load_file.cc",
        "src/core/lib/gprpp/load_file.h",
        "src/core/lib/gprpp/manual_constructor.h",
        "src/core/lib/gprpp/match.h",
        "src/core/lib/gprpp/memory.h",
        "src/core/lib/gprpp/mpscq.cc",
        "src/core/lib/gprpp/mpscq.h",
        "src/core/lib/gprpp/no_destruct.h",
        "src/core/lib/gprpp/notification.h",
        "src/core/lib/gprpp/orphanable.h",
        "src/core/lib/gprpp/overload.h",
        "src/core/lib/gprpp/packed_table.h",
        "src/core/lib/gprpp/per_cpu.cc",
        "src/core/lib/gprpp/per_cpu.h",
        "src/core/lib/gprpp/posix/directory_reader.cc",
        "src/core/lib/gprpp/posix/env.cc",
        "src/core/lib/gprpp/posix/stat.cc",
        "src/core/lib/gprpp/posix/thd.cc",
        "src/core/lib/gprpp/ref_counted.h",
        "src/core/lib/gprpp/ref_counted_ptr.h",
        "src/core/lib/gprpp/ref_counted_string.cc",
        "src/core/lib/gprpp/ref_counted_string.h",
        "src/core/lib/gprpp/single_set_ptr.h",
        "src/core/lib/gprpp/sorted_pack.h",
        "src/core/lib/gprpp/stat.h",
        "src/core/lib/gprpp/status_helper.cc",
        "src/core/lib/gprpp/status_helper.h",
        "src/core/lib/gprpp/strerror.cc",
        "src/core/lib/gprpp/strerror.h",
        "src/core/lib/gprpp/sync.h",
        "src/core/lib/gprpp/table.h",
        "src/core/lib/gprpp/tchar.cc",
        "src/core/lib/gprpp/tchar.h",
        "src/core/lib/gprpp/thd.h",
        "src/core/lib/gprpp/time.cc",
        "src/core/lib/gprpp/time.h",
        "src/core/lib/gprpp/time_averaged_stats.cc",
        "src/core/lib/gprpp/time_averaged_stats.h",
        "src/core/lib/gprpp/time_util.cc",
        "src/core/lib/gprpp/time_util.h",
        "src/core/lib/gprpp/type_list.h",
        "src/core/lib/gprpp/unique_type_name.h",
        "src/core/lib/gprpp/validation_errors.cc",
        "src/core/lib/gprpp/validation_errors.h",
        "src/core/lib/gprpp/windows/directory_reader.cc",
        "src/core/lib/gprpp/windows/env.cc",
        "src/core/lib/gprpp/windows/stat.cc",
        "src/core/lib/gprpp/windows/thd.cc",
        "src/core/lib/gprpp/work_serializer.cc",
        "src/core/lib/gprpp/work_serializer.h",
        "src/core/lib/handshaker/proxy_mapper.h",
        "src/core/lib/handshaker/proxy_mapper_registry.cc",
        "src/core/lib/handshaker/proxy_mapper_registry.h",
        "src/core/lib/http/format_request.cc",
        "src/core/lib/http/format_request.h",
        "src/core/lib/http/httpcli.cc",
        "src/core/lib/http/httpcli.h",
        "src/core/lib/http/httpcli_security_connector.cc",
        "src/core/lib/http/httpcli_ssl_credentials.h",
        "src/core/lib/http/parser.cc",
        "src/core/lib/http/parser.h",
        "src/core/lib/iomgr/block_annotate.h",
        "src/core/lib/iomgr/buffer_list.cc",
        "src/core/lib/iomgr/buffer_list.h",
        "src/core/lib/iomgr/call_combiner.cc",
        "src/core/lib/iomgr/call_combiner.h",
        "src/core/lib/iomgr/cfstream_handle.cc",
        "src/core/lib/iomgr/cfstream_handle.h",
        "src/core/lib/iomgr/closure.cc",
        "src/core/lib/iomgr/closure.h",
        "src/core/lib/iomgr/combiner.cc",
        "src/core/lib/iomgr/combiner.h",
        "src/core/lib/iomgr/dualstack_socket_posix.cc",
        "src/core/lib/iomgr/dynamic_annotations.h",
        "src/core/lib/iomgr/endpoint.cc",
        "src/core/lib/iomgr/endpoint.h",
        "src/core/lib/iomgr/endpoint_cfstream.cc",
        "src/core/lib/iomgr/endpoint_cfstream.h",
        "src/core/lib/iomgr/endpoint_pair.h",
        "src/core/lib/iomgr/endpoint_pair_posix.cc",
        "src/core/lib/iomgr/endpoint_pair_windows.cc",
        "src/core/lib/iomgr/error.cc",
        "src/core/lib/iomgr/error.h",
        "src/core/lib/iomgr/error_cfstream.cc",
        "src/core/lib/iomgr/error_cfstream.h",
        "src/core/lib/iomgr/ev_apple.cc",
        "src/core/lib/iomgr/ev_apple.h",
        "src/core/lib/iomgr/ev_epoll1_linux.cc",
        "src/core/lib/iomgr/ev_epoll1_linux.h",
        "src/core/lib/iomgr/ev_poll_posix.cc",
        "src/core/lib/iomgr/ev_poll_posix.h",
        "src/core/lib/iomgr/ev_posix.cc",
        "src/core/lib/iomgr/ev_posix.h",
        "src/core/lib/iomgr/ev_windows.cc",
        "src/core/lib/iomgr/event_engine_shims/closure.cc",
        "src/core/lib/iomgr/event_engine_shims/closure.h",
        "src/core/lib/iomgr/event_engine_shims/endpoint.cc",
        "src/core/lib/iomgr/event_engine_shims/endpoint.h",
        "src/core/lib/iomgr/event_engine_shims/tcp_client.cc",
        "src/core/lib/iomgr/event_engine_shims/tcp_client.h",
        "src/core/lib/iomgr/exec_ctx.cc",
        "src/core/lib/iomgr/exec_ctx.h",
        "src/core/lib/iomgr/executor.cc",
        "src/core/lib/iomgr/executor.h",
        "src/core/lib/iomgr/fork_posix.cc",
        "src/core/lib/iomgr/fork_windows.cc",
        "src/core/lib/iomgr/gethostname.h",
        "src/core/lib/iomgr/gethostname_fallback.cc",
        "src/core/lib/iomgr/gethostname_host_name_max.cc",
        "src/core/lib/iomgr/gethostname_sysconf.cc",
        "src/core/lib/iomgr/grpc_if_nametoindex.h",
        "src/core/lib/iomgr/grpc_if_nametoindex_posix.cc",
        "src/core/lib/iomgr/grpc_if_nametoindex_unsupported.cc",
        "src/core/lib/iomgr/internal_errqueue.cc",
        "src/core/lib/iomgr/internal_errqueue.h",
        "src/core/lib/iomgr/iocp_windows.cc",
        "src/core/lib/iomgr/iocp_windows.h",
        "src/core/lib/iomgr/iomgr.cc",
        "src/core/lib/iomgr/iomgr.h",
        "src/core/lib/iomgr/iomgr_fwd.h",
        "src/core/lib/iomgr/iomgr_internal.cc",
        "src/core/lib/iomgr/iomgr_internal.h",
        "src/core/lib/iomgr/iomgr_posix.cc",
        "src/core/lib/iomgr/iomgr_posix_cfstream.cc",
        "src/core/lib/iomgr/iomgr_windows.cc",
        "src/core/lib/iomgr/load_file.cc",
        "src/core/lib/iomgr/load_file.h",
        "src/core/lib/iomgr/lockfree_event.cc",
        "src/core/lib/iomgr/lockfree_event.h",
        "src/core/lib/iomgr/nameser.h",
        "src/core/lib/iomgr/polling_entity.cc",
        "src/core/lib/iomgr/polling_entity.h",
        "src/core/lib/iomgr/pollset.cc",
        "src/core/lib/iomgr/pollset.h",
        "src/core/lib/iomgr/pollset_set.cc",
        "src/core/lib/iomgr/pollset_set.h",
        "src/core/lib/iomgr/pollset_set_windows.cc",
        "src/core/lib/iomgr/pollset_set_windows.h",
        "src/core/lib/iomgr/pollset_windows.cc",
        "src/core/lib/iomgr/pollset_windows.h",
        "src/core/lib/iomgr/port.h",
        "src/core/lib/iomgr/python_util.h",
        "src/core/lib/iomgr/resolve_address.cc",
        "src/core/lib/iomgr/resolve_address.h",
        "src/core/lib/iomgr/resolve_address_impl.h",
        "src/core/lib/iomgr/resolve_address_posix.cc",
        "src/core/lib/iomgr/resolve_address_posix.h",
        "src/core/lib/iomgr/resolve_address_windows.cc",
        "src/core/lib/iomgr/resolve_address_windows.h",
        "src/core/lib/iomgr/resolved_address.h",
        "src/core/lib/iomgr/sockaddr.h",
        "src/core/lib/iomgr/sockaddr_posix.h",
        "src/core/lib/iomgr/sockaddr_utils_posix.cc",
        "src/core/lib/iomgr/sockaddr_windows.h",
        "src/core/lib/iomgr/socket_factory_posix.cc",
        "src/core/lib/iomgr/socket_factory_posix.h",
        "src/core/lib/iomgr/socket_mutator.cc",
        "src/core/lib/iomgr/socket_mutator.h",
        "src/core/lib/iomgr/socket_utils.h",
        "src/core/lib/iomgr/socket_utils_common_posix.cc",
        "src/core/lib/iomgr/socket_utils_linux.cc",
        "src/core/lib/iomgr/socket_utils_posix.cc",
        "src/core/lib/iomgr/socket_utils_posix.h",
        "src/core/lib/iomgr/socket_utils_windows.cc",
        "src/core/lib/iomgr/socket_windows.cc",
        "src/core/lib/iomgr/socket_windows.h",
        "src/core/lib/iomgr/systemd_utils.cc",
        "src/core/lib/iomgr/systemd_utils.h",
        "src/core/lib/iomgr/tcp_client.cc",
        "src/core/lib/iomgr/tcp_client.h",
        "src/core/lib/iomgr/tcp_client_cfstream.cc",
        "src/core/lib/iomgr/tcp_client_posix.cc",
        "src/core/lib/iomgr/tcp_client_posix.h",
        "src/core/lib/iomgr/tcp_client_windows.cc",
        "src/core/lib/iomgr/tcp_posix.cc",
        "src/core/lib/iomgr/tcp_posix.h",
        "src/core/lib/iomgr/tcp_server.cc",
        "src/core/lib/iomgr/tcp_server.h",
        "src/core/lib/iomgr/tcp_server_posix.cc",
        "src/core/lib/iomgr/tcp_server_utils_posix.h",
        "src/core/lib/iomgr/tcp_server_utils_posix_common.cc",
        "src/core/lib/iomgr/tcp_server_utils_posix_ifaddrs.cc",
        "src/core/lib/iomgr/tcp_server_utils_posix_noifaddrs.cc",
        "src/core/lib/iomgr/tcp_server_windows.cc",
        "src/core/lib/iomgr/tcp_windows.cc",
        "src/core/lib/iomgr/tcp_windows.h",
        "src/core/lib/iomgr/timer.cc",
        "src/core/lib/iomgr/timer.h",
        "src/core/lib/iomgr/timer_generic.cc",
        "src/core/lib/iomgr/timer_generic.h",
        "src/core/lib/iomgr/timer_heap.cc",
        "src/core/lib/iomgr/timer_heap.h",
        "src/core/lib/iomgr/timer_manager.cc",
        "src/core/lib/iomgr/timer_manager.h",
        "src/core/lib/iomgr/unix_sockets_posix.cc",
        "src/core/lib/iomgr/unix_sockets_posix.h",
        "src/core/lib/iomgr/unix_sockets_posix_noop.cc",
        "src/core/lib/iomgr/vsock.cc",
        "src/core/lib/iomgr/vsock.h",
        "src/core/lib/iomgr/wakeup_fd_eventfd.cc",
        "src/core/lib/iomgr/wakeup_fd_nospecial.cc",
        "src/core/lib/iomgr/wakeup_fd_pipe.cc",
        "src/core/lib/iomgr/wakeup_fd_pipe.h",
        "src/core/lib/iomgr/wakeup_fd_posix.cc",
        "src/core/lib/iomgr/wakeup_fd_posix.h",
        "src/core/lib/json/json.h",
        "src/core/lib/json/json_args.h",
        "src/core/lib/json/json_channel_args.h",
        "src/core/lib/json/json_object_loader.cc",
        "src/core/lib/json/json_object_loader.h",
        "src/core/lib/json/json_reader.cc",
        "src/core/lib/json/json_reader.h",
        "src/core/lib/json/json_util.cc",
        "src/core/lib/json/json_util.h",
        "src/core/lib/json/json_writer.cc",
        "src/core/lib/json/json_writer.h",
        "src/core/lib/load_balancing/delegating_helper.h",
        "src/core/lib/load_balancing/lb_policy.cc",
        "src/core/lib/load_balancing/lb_policy.h",
        "src/core/lib/load_balancing/lb_policy_factory.h",
        "src/core/lib/load_balancing/lb_policy_registry.cc",
        "src/core/lib/load_balancing/lb_policy_registry.h",
        "src/core/lib/load_balancing/subchannel_interface.h",
        "src/core/lib/matchers/matchers.cc",
        "src/core/lib/matchers/matchers.h",
        "src/core/lib/promise/activity.cc",
        "src/core/lib/promise/activity.h",
        "src/core/lib/promise/arena_promise.h",
        "src/core/lib/promise/cancel_callback.h",
        "src/core/lib/promise/context.h",
        "src/core/lib/promise/detail/basic_seq.h",
        "src/core/lib/promise/detail/promise_factory.h",
        "src/core/lib/promise/detail/promise_like.h",
        "src/core/lib/promise/detail/seq_state.h",
        "src/core/lib/promise/detail/status.h",
        "src/core/lib/promise/exec_ctx_wakeup_scheduler.h",
        "src/core/lib/promise/for_each.h",
        "src/core/lib/promise/if.h",
        "src/core/lib/promise/interceptor_list.h",
        "src/core/lib/promise/latch.h",
        "src/core/lib/promise/loop.h",
        "src/core/lib/promise/map.h",
        "src/core/lib/promise/party.cc",
        "src/core/lib/promise/party.h",
        "src/core/lib/promise/pipe.h",
        "src/core/lib/promise/poll.h",
        "src/core/lib/promise/prioritized_race.h",
        "src/core/lib/promise/promise.h",
        "src/core/lib/promise/race.h",
        "src/core/lib/promise/seq.h",
        "src/core/lib/promise/sleep.cc",
        "src/core/lib/promise/sleep.h",
        "src/core/lib/promise/trace.cc",
        "src/core/lib/promise/trace.h",
        "src/core/lib/promise/try_seq.h",
        "src/core/lib/resolver/resolver.cc",
        "src/core/lib/resolver/resolver.h",
        "src/core/lib/resolver/resolver_factory.h",
        "src/core/lib/resolver/resolver_registry.cc",
        "src/core/lib/resolver/resolver_registry.h",
        "src/core/lib/resolver/server_address.cc",
        "src/core/lib/resolver/server_address.h",
        "src/core/lib/resource_quota/api.cc",
        "src/core/lib/resource_quota/api.h",
        "src/core/lib/resource_quota/arena.cc",
        "src/core/lib/resource_quota/arena.h",
        "src/core/lib/resource_quota/memory_quota.cc",
        "src/core/lib/resource_quota/memory_quota.h",
        "src/core/lib/resource_quota/periodic_update.cc",
        "src/core/lib/resource_quota/periodic_update.h",
        "src/core/lib/resource_quota/resource_quota.cc",
        "src/core/lib/resource_quota/resource_quota.h",
        "src/core/lib/resource_quota/thread_quota.cc",
        "src/core/lib/resource_quota/thread_quota.h",
        "src/core/lib/resource_quota/trace.cc",
        "src/core/lib/resource_quota/trace.h",
        "src/core/lib/security/authorization/audit_logging.cc",
        "src/core/lib/security/authorization/audit_logging.h",
        "src/core/lib/security/authorization/authorization_engine.h",
        "src/core/lib/security/authorization/authorization_policy_provider.h",
        "src/core/lib/security/authorization/authorization_policy_provider_vtable.cc",
        "src/core/lib/security/authorization/evaluate_args.cc",
        "src/core/lib/security/authorization/evaluate_args.h",
        "src/core/lib/security/authorization/grpc_authorization_engine.cc",
        "src/core/lib/security/authorization/grpc_authorization_engine.h",
        "src/core/lib/security/authorization/grpc_authorization_policy_provider.cc",
        "src/core/lib/security/authorization/grpc_authorization_policy_provider.h",
        "src/core/lib/security/authorization/grpc_server_authz_filter.cc",
        "src/core/lib/security/authorization/grpc_server_authz_filter.h",
        "src/core/lib/security/authorization/matchers.cc",
        "src/core/lib/security/authorization/matchers.h",
        "src/core/lib/security/authorization/rbac_policy.cc",
        "src/core/lib/security/authorization/rbac_policy.h",
        "src/core/lib/security/authorization/rbac_translator.cc",
        "src/core/lib/security/authorization/rbac_translator.h",
        "src/core/lib/security/authorization/stdout_logger.cc",
        "src/core/lib/security/authorization/stdout_logger.h",
        "src/core/lib/security/certificate_provider/certificate_provider_factory.h",
        "src/core/lib/security/certificate_provider/certificate_provider_registry.cc",
        "src/core/lib/security/certificate_provider/certificate_provider_registry.h",
        "src/core/lib/security/context/security_context.cc",
        "src/core/lib/security/context/security_context.h",
        "src/core/lib/security/credentials/alts/alts_credentials.cc",
        "src/core/lib/security/credentials/alts/alts_credentials.h",
        "src/core/lib/security/credentials/alts/check_gcp_environment.cc",
        "src/core/lib/security/credentials/alts/check_gcp_environment.h",
        "src/core/lib/security/credentials/alts/check_gcp_environment_linux.cc",
        "src/core/lib/security/credentials/alts/check_gcp_environment_no_op.cc",
        "src/core/lib/security/credentials/alts/check_gcp_environment_windows.cc",
        "src/core/lib/security/credentials/alts/grpc_alts_credentials_client_options.cc",
        "src/core/lib/security/credentials/alts/grpc_alts_credentials_options.cc",
        "src/core/lib/security/credentials/alts/grpc_alts_credentials_options.h",
        "src/core/lib/security/credentials/alts/grpc_alts_credentials_server_options.cc",
        "src/core/lib/security/credentials/call_creds_util.cc",
        "src/core/lib/security/credentials/call_creds_util.h",
        "src/core/lib/security/credentials/channel_creds_registry.h",
        "src/core/lib/security/credentials/channel_creds_registry_init.cc",
        "src/core/lib/security/credentials/composite/composite_credentials.cc",
        "src/core/lib/security/credentials/composite/composite_credentials.h",
        "src/core/lib/security/credentials/credentials.cc",
        "src/core/lib/security/credentials/credentials.h",
        "src/core/lib/security/credentials/external/aws_external_account_credentials.cc",
        "src/core/lib/security/credentials/external/aws_external_account_credentials.h",
        "src/core/lib/security/credentials/external/aws_request_signer.cc",
        "src/core/lib/security/credentials/external/aws_request_signer.h",
        "src/core/lib/security/credentials/external/external_account_credentials.cc",
        "src/core/lib/security/credentials/external/external_account_credentials.h",
        "src/core/lib/security/credentials/external/file_external_account_credentials.cc",
        "src/core/lib/security/credentials/external/file_external_account_credentials.h",
        "src/core/lib/security/credentials/external/url_external_account_credentials.cc",
        "src/core/lib/security/credentials/external/url_external_account_credentials.h",
        "src/core/lib/security/credentials/fake/fake_credentials.cc",
        "src/core/lib/security/credentials/fake/fake_credentials.h",
        "src/core/lib/security/credentials/google_default/credentials_generic.cc",
        "src/core/lib/security/credentials/google_default/google_default_credentials.cc",
        "src/core/lib/security/credentials/google_default/google_default_credentials.h",
        "src/core/lib/security/credentials/iam/iam_credentials.cc",
        "src/core/lib/security/credentials/iam/iam_credentials.h",
        "src/core/lib/security/credentials/insecure/insecure_credentials.cc",
        "src/core/lib/security/credentials/insecure/insecure_credentials.h",
        "src/core/lib/security/credentials/jwt/json_token.cc",
        "src/core/lib/security/credentials/jwt/json_token.h",
        "src/core/lib/security/credentials/jwt/jwt_credentials.cc",
        "src/core/lib/security/credentials/jwt/jwt_credentials.h",
        "src/core/lib/security/credentials/jwt/jwt_verifier.cc",
        "src/core/lib/security/credentials/jwt/jwt_verifier.h",
        "src/core/lib/security/credentials/local/local_credentials.cc",
        "src/core/lib/security/credentials/local/local_credentials.h",
        "src/core/lib/security/credentials/oauth2/oauth2_credentials.cc",
        "src/core/lib/security/credentials/oauth2/oauth2_credentials.h",
        "src/core/lib/security/credentials/plugin/plugin_credentials.cc",
        "src/core/lib/security/credentials/plugin/plugin_credentials.h",
        "src/core/lib/security/credentials/ssl/ssl_credentials.cc",
        "src/core/lib/security/credentials/ssl/ssl_credentials.h",
        "src/core/lib/security/credentials/tls/grpc_tls_certificate_distributor.cc",
        "src/core/lib/security/credentials/tls/grpc_tls_certificate_distributor.h",
        "src/core/lib/security/credentials/tls/grpc_tls_certificate_match.cc",
        "src/core/lib/security/credentials/tls/grpc_tls_certificate_provider.cc",
        "src/core/lib/security/credentials/tls/grpc_tls_certificate_provider.h",
        "src/core/lib/security/credentials/tls/grpc_tls_certificate_verifier.cc",
        "src/core/lib/security/credentials/tls/grpc_tls_certificate_verifier.h",
        "src/core/lib/security/credentials/tls/grpc_tls_credentials_options.cc",
        "src/core/lib/security/credentials/tls/grpc_tls_credentials_options.h",
        "src/core/lib/security/credentials/tls/grpc_tls_crl_provider.cc",
        "src/core/lib/security/credentials/tls/grpc_tls_crl_provider.h",
        "src/core/lib/security/credentials/tls/tls_credentials.cc",
        "src/core/lib/security/credentials/tls/tls_credentials.h",
        "src/core/lib/security/credentials/tls/tls_utils.cc",
        "src/core/lib/security/credentials/tls/tls_utils.h",
        "src/core/lib/security/credentials/xds/xds_credentials.cc",
        "src/core/lib/security/credentials/xds/xds_credentials.h",
        "src/core/lib/security/security_connector/alts/alts_security_connector.cc",
        "src/core/lib/security/security_connector/alts/alts_security_connector.h",
        "src/core/lib/security/security_connector/fake/fake_security_connector.cc",
        "src/core/lib/security/security_connector/fake/fake_security_connector.h",
        "src/core/lib/security/security_connector/insecure/insecure_security_connector.cc",
        "src/core/lib/security/security_connector/insecure/insecure_security_connector.h",
        "src/core/lib/security/security_connector/load_system_roots.h",
        "src/core/lib/security/security_connector/load_system_roots_fallback.cc",
        "src/core/lib/security/security_connector/load_system_roots_supported.cc",
        "src/core/lib/security/security_connector/load_system_roots_supported.h",
        "src/core/lib/security/security_connector/local/local_security_connector.cc",
        "src/core/lib/security/security_connector/local/local_security_connector.h",
        "src/core/lib/security/security_connector/security_connector.cc",
        "src/core/lib/security/security_connector/security_connector.h",
        "src/core/lib/security/security_connector/ssl/ssl_security_connector.cc",
        "src/core/lib/security/security_connector/ssl/ssl_security_connector.h",
        "src/core/lib/security/security_connector/ssl_utils.cc",
        "src/core/lib/security/security_connector/ssl_utils.h",
        "src/core/lib/security/security_connector/tls/tls_security_connector.cc",
        "src/core/lib/security/security_connector/tls/tls_security_connector.h",
        "src/core/lib/security/transport/auth_filters.h",
        "src/core/lib/security/transport/client_auth_filter.cc",
        "src/core/lib/security/transport/secure_endpoint.cc",
        "src/core/lib/security/transport/secure_endpoint.h",
        "src/core/lib/security/transport/security_handshaker.cc",
        "src/core/lib/security/transport/security_handshaker.h",
        "src/core/lib/security/transport/server_auth_filter.cc",
        "src/core/lib/security/transport/tsi_error.cc",
        "src/core/lib/security/transport/tsi_error.h",
        "src/core/lib/security/util/json_util.cc",
        "src/core/lib/security/util/json_util.h",
        "src/core/lib/service_config/service_config.h",
        "src/core/lib/service_config/service_config_call_data.h",
        "src/core/lib/service_config/service_config_impl.cc",
        "src/core/lib/service_config/service_config_impl.h",
        "src/core/lib/service_config/service_config_parser.cc",
        "src/core/lib/service_config/service_config_parser.h",
        "src/core/lib/slice/b64.cc",
        "src/core/lib/slice/b64.h",
        "src/core/lib/slice/percent_encoding.cc",
        "src/core/lib/slice/percent_encoding.h",
        "src/core/lib/slice/slice.cc",
        "src/core/lib/slice/slice.h",
        "src/core/lib/slice/slice_buffer.cc",
        "src/core/lib/slice/slice_buffer.h",
        "src/core/lib/slice/slice_internal.h",
        "src/core/lib/slice/slice_refcount.cc",
        "src/core/lib/slice/slice_refcount.h",
        "src/core/lib/slice/slice_string_helpers.cc",
        "src/core/lib/slice/slice_string_helpers.h",
        "src/core/lib/surface/api_trace.cc",
        "src/core/lib/surface/api_trace.h",
        "src/core/lib/surface/builtins.cc",
        "src/core/lib/surface/builtins.h",
        "src/core/lib/surface/byte_buffer.cc",
        "src/core/lib/surface/byte_buffer_reader.cc",
        "src/core/lib/surface/call.cc",
        "src/core/lib/surface/call.h",
        "src/core/lib/surface/call_details.cc",
        "src/core/lib/surface/call_log_batch.cc",
        "src/core/lib/surface/call_test_only.h",
        "src/core/lib/surface/call_trace.cc",
        "src/core/lib/surface/call_trace.h",
        "src/core/lib/surface/channel.cc",
        "src/core/lib/surface/channel.h",
        "src/core/lib/surface/channel_init.cc",
        "src/core/lib/surface/channel_init.h",
        "src/core/lib/surface/channel_ping.cc",
        "src/core/lib/surface/channel_stack_type.cc",
        "src/core/lib/surface/channel_stack_type.h",
        "src/core/lib/surface/completion_queue.cc",
        "src/core/lib/surface/completion_queue.h",
        "src/core/lib/surface/completion_queue_factory.cc",
        "src/core/lib/surface/completion_queue_factory.h",
        "src/core/lib/surface/event_string.cc",
        "src/core/lib/surface/event_string.h",
        "src/core/lib/surface/init.cc",
        "src/core/lib/surface/init.h",
        "src/core/lib/surface/init_internally.cc",
        "src/core/lib/surface/init_internally.h",
        "src/core/lib/surface/lame_client.cc",
        "src/core/lib/surface/lame_client.h",
        "src/core/lib/surface/metadata_array.cc",
        "src/core/lib/surface/server.cc",
        "src/core/lib/surface/server.h",
        "src/core/lib/surface/validate_metadata.cc",
        "src/core/lib/surface/validate_metadata.h",
        "src/core/lib/surface/version.cc",
        "src/core/lib/transport/batch_builder.cc",
        "src/core/lib/transport/batch_builder.h",
        "src/core/lib/transport/bdp_estimator.cc",
        "src/core/lib/transport/bdp_estimator.h",
        "src/core/lib/transport/connectivity_state.cc",
        "src/core/lib/transport/connectivity_state.h",
        "src/core/lib/transport/custom_metadata.h",
        "src/core/lib/transport/error_utils.cc",
        "src/core/lib/transport/error_utils.h",
        "src/core/lib/transport/handshaker.cc",
        "src/core/lib/transport/handshaker.h",
        "src/core/lib/transport/handshaker_factory.h",
        "src/core/lib/transport/handshaker_registry.cc",
        "src/core/lib/transport/handshaker_registry.h",
        "src/core/lib/transport/http2_errors.h",
        "src/core/lib/transport/http_connect_handshaker.cc",
        "src/core/lib/transport/http_connect_handshaker.h",
        "src/core/lib/transport/metadata_batch.cc",
        "src/core/lib/transport/metadata_batch.h",
        "src/core/lib/transport/metadata_compression_traits.h",
        "src/core/lib/transport/parsed_metadata.cc",
        "src/core/lib/transport/parsed_metadata.h",
        "src/core/lib/transport/pid_controller.cc",
        "src/core/lib/transport/pid_controller.h",
        "src/core/lib/transport/simple_slice_based_metadata.h",
        "src/core/lib/transport/status_conversion.cc",
        "src/core/lib/transport/status_conversion.h",
        "src/core/lib/transport/tcp_connect_handshaker.cc",
        "src/core/lib/transport/tcp_connect_handshaker.h",
        "src/core/lib/transport/timeout_encoding.cc",
        "src/core/lib/transport/timeout_encoding.h",
        "src/core/lib/transport/transport.cc",
        "src/core/lib/transport/transport.h",
        "src/core/lib/transport/transport_fwd.h",
        "src/core/lib/transport/transport_impl.h",
        "src/core/lib/transport/transport_op_string.cc",
        "src/core/lib/uri/uri_parser.cc",
        "src/core/lib/uri/uri_parser.h",
        "src/core/plugin_registry/grpc_plugin_registry.cc",
        "src/core/plugin_registry/grpc_plugin_registry_extra.cc",
        "src/core/tsi/alts/crypt/aes_gcm.cc",
        "src/core/tsi/alts/crypt/gsec.cc",
        "src/core/tsi/alts/crypt/gsec.h",
        "src/core/tsi/alts/frame_protector/alts_counter.cc",
        "src/core/tsi/alts/frame_protector/alts_counter.h",
        "src/core/tsi/alts/frame_protector/alts_crypter.cc",
        "src/core/tsi/alts/frame_protector/alts_crypter.h",
        "src/core/tsi/alts/frame_protector/alts_frame_protector.cc",
        "src/core/tsi/alts/frame_protector/alts_frame_protector.h",
        "src/core/tsi/alts/frame_protector/alts_record_protocol_crypter_common.cc",
        "src/core/tsi/alts/frame_protector/alts_record_protocol_crypter_common.h",
        "src/core/tsi/alts/frame_protector/alts_seal_privacy_integrity_crypter.cc",
        "src/core/tsi/alts/frame_protector/alts_unseal_privacy_integrity_crypter.cc",
        "src/core/tsi/alts/frame_protector/frame_handler.cc",
        "src/core/tsi/alts/frame_protector/frame_handler.h",
        "src/core/tsi/alts/handshaker/alts_handshaker_client.cc",
        "src/core/tsi/alts/handshaker/alts_handshaker_client.h",
        "src/core/tsi/alts/handshaker/alts_shared_resource.cc",
        "src/core/tsi/alts/handshaker/alts_shared_resource.h",
        "src/core/tsi/alts/handshaker/alts_tsi_handshaker.cc",
        "src/core/tsi/alts/handshaker/alts_tsi_handshaker.h",
        "src/core/tsi/alts/handshaker/alts_tsi_handshaker_private.h",
        "src/core/tsi/alts/handshaker/alts_tsi_utils.cc",
        "src/core/tsi/alts/handshaker/alts_tsi_utils.h",
        "src/core/tsi/alts/handshaker/transport_security_common_api.cc",
        "src/core/tsi/alts/handshaker/transport_security_common_api.h",
        "src/core/tsi/alts/zero_copy_frame_protector/alts_grpc_integrity_only_record_protocol.cc",
        "src/core/tsi/alts/zero_copy_frame_protector/alts_grpc_integrity_only_record_protocol.h",
        "src/core/tsi/alts/zero_copy_frame_protector/alts_grpc_privacy_integrity_record_protocol.cc",
        "src/core/tsi/alts/zero_copy_frame_protector/alts_grpc_privacy_integrity_record_protocol.h",
        "src/core/tsi/alts/zero_copy_frame_protector/alts_grpc_record_protocol.h",
        "src/core/tsi/alts/zero_copy_frame_protector/alts_grpc_record_protocol_common.cc",
        "src/core/tsi/alts/zero_copy_frame_protector/alts_grpc_record_protocol_common.h",
        "src/core/tsi/alts/zero_copy_frame_protector/alts_iovec_record_protocol.cc",
        "src/core/tsi/alts/zero_copy_frame_protector/alts_iovec_record_protocol.h",
        "src/core/tsi/alts/zero_copy_frame_protector/alts_zero_copy_grpc_protector.cc",
        "src/core/tsi/alts/zero_copy_frame_protector/alts_zero_copy_grpc_protector.h",
        "src/core/tsi/fake_transport_security.cc",
        "src/core/tsi/fake_transport_security.h",
        "src/core/tsi/local_transport_security.cc",
        "src/core/tsi/local_transport_security.h",
        "src/core/tsi/ssl/key_logging/ssl_key_logging.cc",
        "src/core/tsi/ssl/key_logging/ssl_key_logging.h",
        "src/core/tsi/ssl/session_cache/ssl_session.h",
        "src/core/tsi/ssl/session_cache/ssl_session_boringssl.cc",
        "src/core/tsi/ssl/session_cache/ssl_session_cache.cc",
        "src/core/tsi/ssl/session_cache/ssl_session_cache.h",
        "src/core/tsi/ssl/session_cache/ssl_session_openssl.cc",
        "src/core/tsi/ssl_transport_security.cc",
        "src/core/tsi/ssl_transport_security.h",
        "src/core/tsi/ssl_transport_security_utils.cc",
        "src/core/tsi/ssl_transport_security_utils.h",
        "src/core/tsi/ssl_types.h",
        "src/core/tsi/transport_security.cc",
        "src/core/tsi/transport_security.h",
        "src/core/tsi/transport_security_grpc.cc",
        "src/core/tsi/transport_security_grpc.h",
        "src/core/tsi/transport_security_interface.h",
        "third_party/re2/re2/bitmap256.h",
        "third_party/re2/re2/bitstate.cc",
        "third_party/re2/re2/compile.cc",
        "third_party/re2/re2/dfa.cc",
        "third_party/re2/re2/filtered_re2.cc",
        "third_party/re2/re2/filtered_re2.h",
        "third_party/re2/re2/mimics_pcre.cc",
        "third_party/re2/re2/nfa.cc",
        "third_party/re2/re2/onepass.cc",
        "third_party/re2/re2/parse.cc",
        "third_party/re2/re2/perl_groups.cc",
        "third_party/re2/re2/pod_array.h",
        "third_party/re2/re2/prefilter.cc",
        "third_party/re2/re2/prefilter.h",
        "third_party/re2/re2/prefilter_tree.cc",
        "third_party/re2/re2/prefilter_tree.h",
        "third_party/re2/re2/prog.cc",
        "third_party/re2/re2/prog.h",
        "third_party/re2/re2/re2.cc",
        "third_party/re2/re2/re2.h",
        "third_party/re2/re2/regexp.cc",
        "third_party/re2/re2/regexp.h",
        "third_party/re2/re2/set.cc",
        "third_party/re2/re2/set.h",
        "third_party/re2/re2/simplify.cc",
        "third_party/re2/re2/sparse_array.h",
        "third_party/re2/re2/sparse_set.h",
        "third_party/re2/re2/stringpiece.cc",
        "third_party/re2/re2/stringpiece.h",
        "third_party/re2/re2/tostring.cc",
        "third_party/re2/re2/unicode_casefold.cc",
        "third_party/re2/re2/unicode_casefold.h",
        "third_party/re2/re2/unicode_groups.cc",
        "third_party/re2/re2/unicode_groups.h",
        "third_party/re2/re2/walker-inl.h",
        "third_party/re2/util/logging.h",
        "third_party/re2/util/mix.h",
        "third_party/re2/util/mutex.h",
        "third_party/re2/util/rune.cc",
        "third_party/re2/util/strutil.cc",
        "third_party/re2/util/strutil.h",
        "third_party/re2/util/utf.h",
        "third_party/re2/util/util.h",
        "third_party/upb/upb/alloc.h",
        "third_party/upb/upb/arena.h",
        "third_party/upb/upb/array.h",
        "third_party/upb/upb/base/descriptor_constants.h",
        "third_party/upb/upb/base/log2.h",
        "third_party/upb/upb/base/status.c",
        "third_party/upb/upb/base/status.h",
        "third_party/upb/upb/base/string_view.h",
        "third_party/upb/upb/collections/array.c",
        "third_party/upb/upb/collections/array.h",
        "third_party/upb/upb/collections/array_internal.h",
        "third_party/upb/upb/collections/map.c",
        "third_party/upb/upb/collections/map.h",
        "third_party/upb/upb/collections/map_gencode_util.h",
        "third_party/upb/upb/collections/map_internal.h",
        "third_party/upb/upb/collections/map_sorter.c",
        "third_party/upb/upb/collections/map_sorter_internal.h",
        "third_party/upb/upb/collections/message_value.h",
        "third_party/upb/upb/decode.h",
        "third_party/upb/upb/def.h",
        "third_party/upb/upb/def.hpp",
        "third_party/upb/upb/encode.h",
        "third_party/upb/upb/extension_registry.h",
        "third_party/upb/upb/generated_code_support.h",
        "third_party/upb/upb/hash/common.c",
        "third_party/upb/upb/hash/common.h",
        "third_party/upb/upb/hash/int_table.h",
        "third_party/upb/upb/hash/str_table.h",
        "third_party/upb/upb/json/decode.c",
        "third_party/upb/upb/json/decode.h",
        "third_party/upb/upb/json/encode.c",
        "third_party/upb/upb/json/encode.h",
        "third_party/upb/upb/lex/atoi.c",
        "third_party/upb/upb/lex/atoi.h",
        "third_party/upb/upb/lex/round_trip.c",
        "third_party/upb/upb/lex/round_trip.h",
        "third_party/upb/upb/lex/strtod.c",
        "third_party/upb/upb/lex/strtod.h",
        "third_party/upb/upb/lex/unicode.c",
        "third_party/upb/upb/lex/unicode.h",
        "third_party/upb/upb/map.h",
        "third_party/upb/upb/mem/alloc.c",
        "third_party/upb/upb/mem/alloc.h",
        "third_party/upb/upb/mem/arena.c",
        "third_party/upb/upb/mem/arena.h",
        "third_party/upb/upb/mem/arena_internal.h",
        "third_party/upb/upb/message/accessors.c",
        "third_party/upb/upb/message/accessors.h",
        "third_party/upb/upb/message/accessors_internal.h",
        "third_party/upb/upb/message/extension_internal.h",
        "third_party/upb/upb/message/internal.h",
        "third_party/upb/upb/message/internal/map_entry.h",
        "third_party/upb/upb/message/message.c",
        "third_party/upb/upb/message/message.h",
        "third_party/upb/upb/message/tagged_ptr.h",
        "third_party/upb/upb/mini_descriptor/build_enum.c",
        "third_party/upb/upb/mini_descriptor/build_enum.h",
        "third_party/upb/upb/mini_descriptor/decode.c",
        "third_party/upb/upb/mini_descriptor/decode.h",
        "third_party/upb/upb/mini_descriptor/internal/base92.c",
        "third_party/upb/upb/mini_descriptor/internal/base92.h",
        "third_party/upb/upb/mini_descriptor/internal/decoder.h",
        "third_party/upb/upb/mini_descriptor/internal/encode.c",
        "third_party/upb/upb/mini_descriptor/internal/encode.h",
        "third_party/upb/upb/mini_descriptor/internal/encode.hpp",
        "third_party/upb/upb/mini_descriptor/internal/modifiers.h",
        "third_party/upb/upb/mini_descriptor/internal/wire_constants.h",
        "third_party/upb/upb/mini_descriptor/link.c",
        "third_party/upb/upb/mini_descriptor/link.h",
        "third_party/upb/upb/mini_table/enum.h",
        "third_party/upb/upb/mini_table/extension.h",
        "third_party/upb/upb/mini_table/extension_registry.c",
        "third_party/upb/upb/mini_table/extension_registry.h",
        "third_party/upb/upb/mini_table/field.h",
        "third_party/upb/upb/mini_table/file.h",
        "third_party/upb/upb/mini_table/internal/enum.h",
        "third_party/upb/upb/mini_table/internal/extension.h",
        "third_party/upb/upb/mini_table/internal/field.h",
        "third_party/upb/upb/mini_table/internal/file.h",
        "third_party/upb/upb/mini_table/internal/message.c",
        "third_party/upb/upb/mini_table/internal/message.h",
        "third_party/upb/upb/mini_table/internal/sub.h",
        "third_party/upb/upb/mini_table/message.c",
        "third_party/upb/upb/mini_table/message.h",
        "third_party/upb/upb/mini_table/sub.h",
        "third_party/upb/upb/msg.h",
        "third_party/upb/upb/port/atomic.h",
        "third_party/upb/upb/port/def.inc",
        "third_party/upb/upb/port/undef.inc",
        "third_party/upb/upb/port/vsnprintf_compat.h",
        "third_party/upb/upb/reflection.h",
        "third_party/upb/upb/reflection.hpp",
        "third_party/upb/upb/reflection/common.h",
        "third_party/upb/upb/reflection/def.h",
        "third_party/upb/upb/reflection/def.hpp",
        "third_party/upb/upb/reflection/def_builder.c",
        "third_party/upb/upb/reflection/def_builder_internal.h",
        "third_party/upb/upb/reflection/def_pool.c",
        "third_party/upb/upb/reflection/def_pool.h",
        "third_party/upb/upb/reflection/def_pool_internal.h",
        "third_party/upb/upb/reflection/def_type.c",
        "third_party/upb/upb/reflection/def_type.h",
        "third_party/upb/upb/reflection/desc_state.c",
        "third_party/upb/upb/reflection/desc_state_internal.h",
        "third_party/upb/upb/reflection/enum_def.c",
        "third_party/upb/upb/reflection/enum_def.h",
        "third_party/upb/upb/reflection/enum_def_internal.h",
        "third_party/upb/upb/reflection/enum_reserved_range.c",
        "third_party/upb/upb/reflection/enum_reserved_range.h",
        "third_party/upb/upb/reflection/enum_reserved_range_internal.h",
        "third_party/upb/upb/reflection/enum_value_def.c",
        "third_party/upb/upb/reflection/enum_value_def.h",
        "third_party/upb/upb/reflection/enum_value_def_internal.h",
        "third_party/upb/upb/reflection/extension_range.c",
        "third_party/upb/upb/reflection/extension_range.h",
        "third_party/upb/upb/reflection/extension_range_internal.h",
        "third_party/upb/upb/reflection/field_def.c",
        "third_party/upb/upb/reflection/field_def.h",
        "third_party/upb/upb/reflection/field_def_internal.h",
        "third_party/upb/upb/reflection/file_def.c",
        "third_party/upb/upb/reflection/file_def.h",
        "third_party/upb/upb/reflection/file_def_internal.h",
        "third_party/upb/upb/reflection/message.c",
        "third_party/upb/upb/reflection/message.h",
        "third_party/upb/upb/reflection/message.hpp",
        "third_party/upb/upb/reflection/message_def.c",
        "third_party/upb/upb/reflection/message_def.h",
        "third_party/upb/upb/reflection/message_def_internal.h",
        "third_party/upb/upb/reflection/message_reserved_range.c",
        "third_party/upb/upb/reflection/message_reserved_range.h",
        "third_party/upb/upb/reflection/message_reserved_range_internal.h",
        "third_party/upb/upb/reflection/method_def.c",
        "third_party/upb/upb/reflection/method_def.h",
        "third_party/upb/upb/reflection/method_def_internal.h",
        "third_party/upb/upb/reflection/oneof_def.c",
        "third_party/upb/upb/reflection/oneof_def.h",
        "third_party/upb/upb/reflection/oneof_def_internal.h",
        "third_party/upb/upb/reflection/service_def.c",
        "third_party/upb/upb/reflection/service_def.h",
        "third_party/upb/upb/reflection/service_def_internal.h",
        "third_party/upb/upb/status.h",
        "third_party/upb/upb/string_view.h",
        "third_party/upb/upb/text/encode.c",
        "third_party/upb/upb/text/encode.h",
        "third_party/upb/upb/text_encode.h",
        "third_party/upb/upb/upb.h",
        "third_party/upb/upb/upb.hpp",
        "third_party/upb/upb/wire/common.h",
        "third_party/upb/upb/wire/common_internal.h",
        "third_party/upb/upb/wire/decode.c",
        "third_party/upb/upb/wire/decode.h",
        "third_party/upb/upb/wire/decode_fast.c",
        "third_party/upb/upb/wire/decode_fast.h",
        "third_party/upb/upb/wire/decode_internal.h",
        "third_party/upb/upb/wire/encode.c",
        "third_party/upb/upb/wire/encode.h",
        "third_party/upb/upb/wire/eps_copy_input_stream.c",
        "third_party/upb/upb/wire/eps_copy_input_stream.h",
        "third_party/upb/upb/wire/reader.c",
        "third_party/upb/upb/wire/reader.h",
        "third_party/upb/upb/wire/swap_internal.h",
        "third_party/upb/upb/wire/types.h",
        "third_party/utf8_range/naive.c",
        "third_party/utf8_range/range2-neon.c",
        "third_party/utf8_range/range2-sse.c",
        "third_party/utf8_range/utf8_range.h",
        "third_party/xxhash/xxhash.h",
      ],
      publicHeadersPath: "spm-core-include",
      cSettings: [
        .headerSearchPath("./"),
        .headerSearchPath("include/"),
        .headerSearchPath("third_party/re2/"),
        .headerSearchPath("third_party/upb/"),
        .headerSearchPath("third_party/utf8_range/"),
        .headerSearchPath("third_party/xxhash/"),
        .headerSearchPath("src/core/ext/upb-generated/"),
        .headerSearchPath("src/core/ext/upbdefs-generated/"),
        .define("GRPC_ARES", to: "0"),
      ],
      linkerSettings: [
        .linkedFramework("CoreFoundation"),
        .linkedLibrary("z"),
      ]
    ),
    .target(
      name: "gRPC-cpp",
      dependencies: [
        .product(name:"abseil", package: "abseil-cpp-SwiftPM"),
        "gRPC-Core",
      ],
      path: basePath,
      exclude: [
        "examples/",
        "src/cpp/client/cronet_credentials.cc",
        "src/cpp/client/channel_test_peer.cc",
        "src/cpp/common/alts_util.cc",
        "src/cpp/common/alts_context.cc",
        "src/cpp/common/insecure_create_auth_context.cc",
        "src/cpp/server/admin/",
        "src/cpp/server/channelz/",
        "src/cpp/server/csds/",
        "src/cpp/server/load_reporter/",
        "src/cpp/ext/",
        "src/cpp/util/core_stats.cc",
        "src/cpp/util/core_stats.h",
        "src/cpp/util/error_details.cc",
        "src/objective-c/examples/",
        "src/objective-c/manual_tests/",
        "src/objective-c/tests/",
      ],
      sources: [
        "src/cpp/",
      ],
      publicHeadersPath: "spm-cpp-include",
      cSettings: [
        .headerSearchPath("./"),
        .headerSearchPath("include/"),
        .headerSearchPath("third_party/upb/"),
        .headerSearchPath("src/core/ext/upb-generated"),
      ]
    ),
    .testTarget(
      name: "build-test",
      dependencies: [
        "gRPC-cpp",
      ],
      path: basePath + "/test/spm_build"
    ),
  ],
  cLanguageStandard: .gnu11,
  cxxLanguageStandard: .cxx14
)
