// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"fmt"
	smithy "github.com/aws/smithy-go"
)

// Returned if the request is malformed or contains an error such as an invalid
// parameter value or a missing required parameter.
type BadRequestException struct {
	Message *string

	Code *string

	noSmithyDocumentSerde
}

func (e *BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *BadRequestException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *BadRequestException) ErrorCode() string             { return "BadRequestException" }
func (e *BadRequestException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Returned when the request exceeds the processing capacity of the ledger.
type CapacityExceededException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *CapacityExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CapacityExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CapacityExceededException) ErrorCode() string             { return "CapacityExceededException" }
func (e *CapacityExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultServer }

// Returned if the session doesn't exist anymore because it timed out or expired.
type InvalidSessionException struct {
	Message *string

	Code *string

	noSmithyDocumentSerde
}

func (e *InvalidSessionException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidSessionException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidSessionException) ErrorCode() string             { return "InvalidSessionException" }
func (e *InvalidSessionException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Returned if a resource limit such as number of active sessions is exceeded.
type LimitExceededException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *LimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *LimitExceededException) ErrorCode() string             { return "LimitExceededException" }
func (e *LimitExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Returned when a transaction cannot be written to the journal due to a failure in
// the verification phase of optimistic concurrency control (OCC).
type OccConflictException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *OccConflictException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OccConflictException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OccConflictException) ErrorCode() string             { return "OccConflictException" }
func (e *OccConflictException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Returned when the rate of requests exceeds the allowed throughput.
type RateExceededException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *RateExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *RateExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *RateExceededException) ErrorCode() string             { return "RateExceededException" }
func (e *RateExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }
