// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
)

// An unusual cost pattern. This consists of the detailed metadata and the current
// status of the anomaly object.
type Anomaly struct {

	// The unique identifier for the anomaly.
	//
	// This member is required.
	AnomalyId *string

	// The latest and maximum score for the anomaly.
	//
	// This member is required.
	AnomalyScore *AnomalyScore

	// The dollar impact for the anomaly.
	//
	// This member is required.
	Impact *Impact

	// The Amazon Resource Name (ARN) for the cost monitor that generated this anomaly.
	//
	// This member is required.
	MonitorArn *string

	// The last day the anomaly is detected.
	AnomalyEndDate *string

	// The first day the anomaly is detected.
	AnomalyStartDate *string

	// The dimension for the anomaly (for example, an Amazon Web Service in a service
	// monitor).
	DimensionValue *string

	// The feedback value.
	Feedback AnomalyFeedbackType

	// The list of identified root causes for the anomaly.
	RootCauses []RootCause

	noSmithyDocumentSerde
}

// The time period for an anomaly.
type AnomalyDateInterval struct {

	// The first date an anomaly was observed.
	//
	// This member is required.
	StartDate *string

	// The last date an anomaly was observed.
	EndDate *string

	noSmithyDocumentSerde
}

// This object continuously inspects your account's cost data for anomalies. It's
// based on MonitorType and MonitorSpecification. The content consists of detailed
// metadata and the current status of the monitor object.
type AnomalyMonitor struct {

	// The name of the monitor.
	//
	// This member is required.
	MonitorName *string

	// The possible type values.
	//
	// This member is required.
	MonitorType MonitorType

	// The date when the monitor was created.
	CreationDate *string

	// The value for evaluated dimensions.
	DimensionalValueCount int32

	// The date when the monitor last evaluated for anomalies.
	LastEvaluatedDate *string

	// The date when the monitor was last updated.
	LastUpdatedDate *string

	// The Amazon Resource Name (ARN) value.
	MonitorArn *string

	// The dimensions to evaluate.
	MonitorDimension MonitorDimension

	// Use Expression to filter by cost or by usage. There are two patterns:
	//
	// * Simple
	// dimension values - You can set the dimension name and values for the filters
	// that you plan to use. For example, you can filter for REGION==us-east-1 OR
	// REGION==us-west-1. For GetRightsizingRecommendation, the Region is a full name
	// (for example, REGION==US East (N. Virginia). The Expression example is as
	// follows: { "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", “us-west-1”
	// ] } } The list of dimension values are OR'd together to retrieve cost or usage
	// data. You can create Expression and DimensionValues objects using either with*
	// methods or set* methods in multiple lines.
	//
	// * Compound dimension values with
	// logical operations - You can use multiple Expression types and the logical
	// operators AND/OR/NOT to create a list of one or more Expression objects. By
	// doing this, you can filter on more advanced options. For example, you can filter
	// on ((REGION == us-east-1 OR REGION == us-west-1) OR (TAG.Type == Type1)) AND
	// (USAGE_TYPE != DataTransfer). The Expression for that is as follows: { "And": [
	// {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1"
	// ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not":
	// {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] }
	// Because each Expression can have only one operator, the service returns an error
	// if more than one is specified. The following example shows an Expression object
	// that creates an error.  { "And": [ ... ], "DimensionValues": { "Dimension":
	// "USAGE_TYPE", "Values": [ "DataTransfer" ] } }
	//
	// For the
	// GetRightsizingRecommendation action, a combination of OR and NOT isn't
	// supported. OR isn't supported between different dimensions, or dimensions and
	// tags. NOT operators aren't supported. Dimensions are also limited to
	// LINKED_ACCOUNT, REGION, or RIGHTSIZING_TYPE. For the
	// GetReservationPurchaseRecommendation action, only NOT is supported. AND and OR
	// aren't supported. Dimensions are limited to LINKED_ACCOUNT.
	MonitorSpecification *Expression

	noSmithyDocumentSerde
}

// Quantifies the anomaly. The higher score means that it's more anomalous.
type AnomalyScore struct {

	// The last observed score.
	//
	// This member is required.
	CurrentScore float64

	// The maximum score that's observed during the AnomalyDateInterval.
	//
	// This member is required.
	MaxScore float64

	noSmithyDocumentSerde
}

// The association between a monitor, threshold, and list of subscribers used to
// deliver notifications about anomalies detected by a monitor that exceeds a
// threshold. The content consists of the detailed metadata and the current status
// of the AnomalySubscription object.
type AnomalySubscription struct {

	// The frequency that anomaly reports are sent over email.
	//
	// This member is required.
	Frequency AnomalySubscriptionFrequency

	// A list of cost anomaly monitors.
	//
	// This member is required.
	MonitorArnList []string

	// A list of subscribers to notify.
	//
	// This member is required.
	Subscribers []Subscriber

	// The name for the subscription.
	//
	// This member is required.
	SubscriptionName *string

	// The dollar value that triggers a notification if the threshold is exceeded.
	//
	// This member is required.
	Threshold *float64

	// Your unique account identifier.
	AccountId *string

	// The AnomalySubscription Amazon Resource Name (ARN).
	SubscriptionArn *string

	noSmithyDocumentSerde
}

// The cost allocation tag structure. This includes detailed metadata for the
// CostAllocationTag object.
type CostAllocationTag struct {

	// The status of a cost allocation tag.
	//
	// This member is required.
	Status CostAllocationTagStatus

	// The key for the cost allocation tag.
	//
	// This member is required.
	TagKey *string

	// The type of cost allocation tag. You can use AWSGenerated or UserDefined type
	// tags. AWSGenerated type tags are tags that Amazon Web Services defines and
	// applies to support Amazon Web Services resources for cost allocation purposes.
	// UserDefined type tags are tags that you define, create, and apply to resources.
	//
	// This member is required.
	Type CostAllocationTagType

	noSmithyDocumentSerde
}

// The cost allocation tag status. The status of a key can either be active or
// inactive.
type CostAllocationTagStatusEntry struct {

	// The status of a cost allocation tag.
	//
	// This member is required.
	Status CostAllocationTagStatus

	// The key for the cost allocation tag.
	//
	// This member is required.
	TagKey *string

	noSmithyDocumentSerde
}

// The structure of Cost Categories. This includes detailed metadata and the set of
// rules for the CostCategory object.
type CostCategory struct {

	// The unique identifier for your Cost Category.
	//
	// This member is required.
	CostCategoryArn *string

	// The effective start date of your Cost Category.
	//
	// This member is required.
	EffectiveStart *string

	// The unique name of the Cost Category.
	//
	// This member is required.
	Name *string

	// The rule schema version in this particular Cost Category.
	//
	// This member is required.
	RuleVersion CostCategoryRuleVersion

	// The rules are processed in order. If there are multiple rules that match the
	// line item, then the first rule to match is used to determine that Cost Category
	// value.
	//
	// This member is required.
	Rules []CostCategoryRule

	// The default value for the cost category.
	DefaultValue *string

	// The effective end date of your Cost Category.
	EffectiveEnd *string

	// The list of processing statuses for Cost Management products for a specific cost
	// category.
	ProcessingStatus []CostCategoryProcessingStatus

	// The split charge rules that are used to allocate your charges between your Cost
	// Category values.
	SplitChargeRules []CostCategorySplitChargeRule

	noSmithyDocumentSerde
}

// When you create or update a cost category, you can define the CostCategoryRule
// rule type as INHERITED_VALUE. This rule type adds the flexibility to define a
// rule that dynamically inherits the cost category value from the dimension value
// that's defined by CostCategoryInheritedValueDimension. For example, suppose that
// you want to dynamically group costs that are based on the value of a specific
// tag key. First, choose an inherited value rule type, and then choose the tag
// dimension and specify the tag key to use.
type CostCategoryInheritedValueDimension struct {

	// The key to extract cost category values.
	DimensionKey *string

	// The name of the dimension that's used to group costs. If you specify
	// LINKED_ACCOUNT_NAME, the cost category value is based on account name. If you
	// specify TAG, the cost category value is based on the value of the specified tag
	// key.
	DimensionName CostCategoryInheritedValueDimensionName

	noSmithyDocumentSerde
}

// The list of processing statuses for Cost Management products for a specific cost
// category.
type CostCategoryProcessingStatus struct {

	// The Cost Management product name of the applied status.
	Component CostCategoryStatusComponent

	// The process status for a specific cost category.
	Status CostCategoryStatus

	noSmithyDocumentSerde
}

// A reference to a Cost Category containing only enough information to identify
// the Cost Category. You can use this information to retrieve the full Cost
// Category information using DescribeCostCategory.
type CostCategoryReference struct {

	// The unique identifier for your Cost Category.
	CostCategoryArn *string

	// The default value for the cost category.
	DefaultValue *string

	// The Cost Category's effective end date.
	EffectiveEnd *string

	// The Cost Category's effective start date.
	EffectiveStart *string

	// The unique name of the Cost Category.
	Name *string

	// The number of rules that are associated with a specific Cost Category.
	NumberOfRules int32

	// The list of processing statuses for Cost Management products for a specific cost
	// category.
	ProcessingStatus []CostCategoryProcessingStatus

	// A list of unique cost category values in a specific cost category.
	Values []string

	noSmithyDocumentSerde
}

// Rules are processed in order. If there are multiple rules that match the line
// item, then the first rule to match is used to determine that Cost Category
// value.
type CostCategoryRule struct {

	// The value the line item is categorized as if the line item contains the matched
	// dimension.
	InheritedValue *CostCategoryInheritedValueDimension

	// An Expression
	// (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html)
	// object used to categorize costs. This supports dimensions, tags, and nested
	// expressions. Currently the only dimensions supported are LINKED_ACCOUNT,
	// SERVICE_CODE, RECORD_TYPE, and LINKED_ACCOUNT_NAME. Root level OR isn't
	// supported. We recommend that you create a separate rule instead. RECORD_TYPE is
	// a dimension used for Cost Explorer APIs, and is also supported for Cost Category
	// expressions. This dimension uses different terms, depending on whether you're
	// using the console or API/JSON editor. For a detailed comparison, see Term
	// Comparisons
	// (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/manage-cost-categories.html#cost-categories-terms)
	// in the Billing and Cost Management User Guide.
	Rule *Expression

	// You can define the CostCategoryRule rule type as either REGULAR or
	// INHERITED_VALUE. The INHERITED_VALUE rule type adds the flexibility to define a
	// rule that dynamically inherits the cost category value. This value is from the
	// dimension value that's defined by CostCategoryInheritedValueDimension. For
	// example, suppose that you want to costs to be dynamically grouped based on the
	// value of a specific tag key. First, choose an inherited value rule type, and
	// then choose the tag dimension and specify the tag key to use.
	Type CostCategoryRuleType

	// The default value for the cost category.
	Value *string

	noSmithyDocumentSerde
}

// Use the split charge rule to split the cost of one Cost Category value across
// several other target values.
type CostCategorySplitChargeRule struct {

	// The method that's used to define how to split your source costs across your
	// targets. Proportional - Allocates charges across your targets based on the
	// proportional weighted cost of each target. Fixed - Allocates charges across your
	// targets based on your defined allocation percentage. >Even - Allocates costs
	// evenly across all targets.
	//
	// This member is required.
	Method CostCategorySplitChargeMethod

	// The Cost Category value that you want to split. That value can't be used as a
	// source or a target in other split charge rules. To indicate uncategorized costs,
	// you can use an empty string as the source.
	//
	// This member is required.
	Source *string

	// The Cost Category values that you want to split costs across. These values can't
	// be used as a source in other split charge rules.
	//
	// This member is required.
	Targets []string

	// The parameters for a split charge method. This is only required for the FIXED
	// method.
	Parameters []CostCategorySplitChargeRuleParameter

	noSmithyDocumentSerde
}

// The parameters for a split charge method.
type CostCategorySplitChargeRuleParameter struct {

	// The parameter type.
	//
	// This member is required.
	Type CostCategorySplitChargeRuleParameterType

	// The parameter values.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// The Cost Categories values used for filtering the costs. If Values and Key are
// not specified, the ABSENTMatchOption is applied to all Cost Categories. That is,
// it filters on resources that aren't mapped to any Cost Categories. If Values is
// provided and Key isn't specified, the ABSENTMatchOption is applied to the Cost
// Categories Key only. That is, it filters on resources without the given Cost
// Categories key.
type CostCategoryValues struct {

	// The unique name of the Cost Category.
	Key *string

	// The match options that you can use to filter your results. MatchOptions is only
	// applicable for actions related to cost category. The default values for
	// MatchOptions is EQUALS and CASE_SENSITIVE.
	MatchOptions []MatchOption

	// The specific value of the Cost Category.
	Values []string

	noSmithyDocumentSerde
}

// The amount of instance usage that a reservation covered.
type Coverage struct {

	// The amount of cost that the reservation covered.
	CoverageCost *CoverageCost

	// The amount of instance usage that the reservation covered, in hours.
	CoverageHours *CoverageHours

	// The amount of instance usage that the reservation covered, in normalized units.
	CoverageNormalizedUnits *CoverageNormalizedUnits

	noSmithyDocumentSerde
}

// Reservation coverage for a specified period, in hours.
type CoverageByTime struct {

	// The groups of instances that the reservation covered.
	Groups []ReservationCoverageGroup

	// The period that this coverage was used over.
	TimePeriod *DateInterval

	// The total reservation coverage, in hours.
	Total *Coverage

	noSmithyDocumentSerde
}

// How much it costs to run an instance.
type CoverageCost struct {

	// How much an On-Demand Instance costs.
	OnDemandCost *string

	noSmithyDocumentSerde
}

// How long a running instance either used a reservation or was On-Demand.
type CoverageHours struct {

	// The percentage of instance hours that a reservation covered.
	CoverageHoursPercentage *string

	// The number of instance running hours that On-Demand Instances covered.
	OnDemandHours *string

	// The number of instance running hours that reservations covered.
	ReservedHours *string

	// The total instance usage, in hours.
	TotalRunningHours *string

	noSmithyDocumentSerde
}

// The amount of instance usage, in normalized units. You can use normalized units
// to see your EC2 usage for multiple sizes of instances in a uniform way. For
// example, suppose that you run an xlarge instance and a 2xlarge instance. If you
// run both instances for the same amount of time, the 2xlarge instance uses twice
// as much of your reservation as the xlarge instance, even though both instances
// show only one instance-hour. When you use normalized units instead of
// instance-hours, the xlarge instance used 8 normalized units, and the 2xlarge
// instance used 16 normalized units. For more information, see Modifying Reserved
// Instances
// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-modifying.html) in the
// Amazon Elastic Compute Cloud User Guide for Linux Instances.
type CoverageNormalizedUnits struct {

	// The percentage of your used instance normalized units that a reservation covers.
	CoverageNormalizedUnitsPercentage *string

	// The number of normalized units that are covered by On-Demand Instances instead
	// of a reservation.
	OnDemandNormalizedUnits *string

	// The number of normalized units that a reservation covers.
	ReservedNormalizedUnits *string

	// The total number of normalized units that you used.
	TotalRunningNormalizedUnits *string

	noSmithyDocumentSerde
}

// Context about the current instance.
type CurrentInstance struct {

	// The currency code that Amazon Web Services used to calculate the costs for this
	// instance.
	CurrencyCode *string

	// The name that you given an instance. This field shows as blank if you haven't
	// given the instance a name.
	InstanceName *string

	// The current On-Demand cost of operating this instance on a monthly basis.
	MonthlyCost *string

	// The number of hours during the lookback period that's billed at On-Demand rates.
	OnDemandHoursInLookbackPeriod *string

	// The number of hours during the lookback period that's covered by reservations.
	ReservationCoveredHoursInLookbackPeriod *string

	// Details about the resource and utilization.
	ResourceDetails *ResourceDetails

	// Resource ID of the current instance.
	ResourceId *string

	// Utilization information of the current instance during the lookback period.
	ResourceUtilization *ResourceUtilization

	// The number of hours during the lookback period that's covered by Savings Plans.
	SavingsPlansCoveredHoursInLookbackPeriod *string

	// Cost allocation resource tags that are applied to the instance.
	Tags []TagValues

	// The total number of hours that the instance ran during the lookback period.
	TotalRunningHoursInLookbackPeriod *string

	noSmithyDocumentSerde
}

// The time period of the request.
type DateInterval struct {

	// The end of the time period. The end date is exclusive. For example, if end is
	// 2017-05-01, Amazon Web Services retrieves cost and usage data from the start
	// date up to, but not including, 2017-05-01.
	//
	// This member is required.
	End *string

	// The beginning of the time period. The start date is inclusive. For example, if
	// start is 2017-01-01, Amazon Web Services retrieves cost and usage data starting
	// at 2017-01-01 up to the end date. The start date must be equal to or no later
	// than the current date to avoid a validation error.
	//
	// This member is required.
	Start *string

	noSmithyDocumentSerde
}

// The metadata that you can use to filter and group your results. You can use
// GetDimensionValues to find specific values.
type DimensionValues struct {

	// The names of the metadata types that you can use to filter and group your
	// results. For example, AZ returns a list of Availability Zones. LINK_ACCOUNT_NAME
	// and SERVICE_CODE can only be used in CostCategoryRule
	// (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/AAPI_CostCategoryRule.html).
	Key Dimension

	// The match options that you can use to filter your results. MatchOptions is only
	// applicable for actions related to Cost Category. The default values for
	// MatchOptions are EQUALS and CASE_SENSITIVE.
	MatchOptions []MatchOption

	// The metadata values that you can use to filter and group your results. You can
	// use GetDimensionValues to find specific values.
	Values []string

	noSmithyDocumentSerde
}

// The metadata of a specific type that you can use to filter and group your
// results. You can use GetDimensionValues to find specific values.
type DimensionValuesWithAttributes struct {

	// The attribute that applies to a specific Dimension.
	Attributes map[string]string

	// The value of a dimension with a specific attribute.
	Value *string

	noSmithyDocumentSerde
}

// The field that contains a list of disk (local storage) metrics that are
// associated with the current instance.
type DiskResourceUtilization struct {

	// The maximum read throughput operations per second.
	DiskReadBytesPerSecond *string

	// The maximum number of read operations per second.
	DiskReadOpsPerSecond *string

	// The maximum write throughput operations per second.
	DiskWriteBytesPerSecond *string

	// The maximum number of write operations per second.
	DiskWriteOpsPerSecond *string

	noSmithyDocumentSerde
}

// The EBS field that contains a list of EBS metrics that are associated with the
// current instance.
type EBSResourceUtilization struct {

	// The maximum size of read operations per second
	EbsReadBytesPerSecond *string

	// The maximum number of read operations per second.
	EbsReadOpsPerSecond *string

	// The maximum size of write operations per second.
	EbsWriteBytesPerSecond *string

	// The maximum number of write operations per second.
	EbsWriteOpsPerSecond *string

	noSmithyDocumentSerde
}

// Details about the Amazon EC2 instances that Amazon Web Services recommends that
// you purchase.
type EC2InstanceDetails struct {

	// The Availability Zone of the recommended reservation.
	AvailabilityZone *string

	// Determines whether the recommendation is for a current-generation instance.
	CurrentGeneration bool

	// The instance family of the recommended reservation.
	Family *string

	// The type of instance that Amazon Web Services recommends.
	InstanceType *string

	// The platform of the recommended reservation. The platform is the specific
	// combination of operating system, license model, and software on an instance.
	Platform *string

	// The Amazon Web Services Region of the recommended reservation.
	Region *string

	// Determines whether the recommended reservation is size flexible.
	SizeFlexEligible bool

	// Determines whether the recommended reservation is dedicated or shared.
	Tenancy *string

	noSmithyDocumentSerde
}

// Details on the Amazon EC2 Resource.
type EC2ResourceDetails struct {

	// The hourly public On-Demand rate for the instance type.
	HourlyOnDemandRate *string

	// The type of Amazon Web Services instance.
	InstanceType *string

	// The memory capacity of the Amazon Web Services instance.
	Memory *string

	// The network performance capacity of the Amazon Web Services instance.
	NetworkPerformance *string

	// The platform of the Amazon Web Services instance. The platform is the specific
	// combination of operating system, license model, and software on an instance.
	Platform *string

	// The Amazon Web Services Region of the instance.
	Region *string

	// The SKU of the product.
	Sku *string

	// The disk storage of the Amazon Web Services instance. This doesn't include EBS
	// storage.
	Storage *string

	// The number of VCPU cores in the Amazon Web Services instance type.
	Vcpu *string

	noSmithyDocumentSerde
}

// Utilization metrics for the instance.
type EC2ResourceUtilization struct {

	// The field that contains a list of disk (local storage) metrics that are
	// associated with the current instance.
	DiskResourceUtilization *DiskResourceUtilization

	// The EBS field that contains a list of EBS metrics that are associated with the
	// current instance.
	EBSResourceUtilization *EBSResourceUtilization

	// The maximum observed or expected CPU utilization of the instance.
	MaxCpuUtilizationPercentage *string

	// The maximum observed or expected memory utilization of the instance.
	MaxMemoryUtilizationPercentage *string

	// The maximum observed or expected storage utilization of the instance. This
	// doesn't include EBS storage.
	MaxStorageUtilizationPercentage *string

	// The network field that contains a list of network metrics that are associated
	// with the current instance.
	NetworkResourceUtilization *NetworkResourceUtilization

	noSmithyDocumentSerde
}

// The Amazon EC2 hardware specifications that you want Amazon Web Services to
// provide recommendations for.
type EC2Specification struct {

	// Indicates whether you want a recommendation for standard or convertible
	// reservations.
	OfferingClass OfferingClass

	noSmithyDocumentSerde
}

// Details about the Amazon ElastiCache instances that Amazon Web Services
// recommends that you purchase.
type ElastiCacheInstanceDetails struct {

	// Determines whether the recommendation is for a current generation instance.
	CurrentGeneration bool

	// The instance family of the recommended reservation.
	Family *string

	// The type of node that Amazon Web Services recommends.
	NodeType *string

	// The description of the recommended reservation.
	ProductDescription *string

	// The Amazon Web Services Region of the recommended reservation.
	Region *string

	// Determines whether the recommended reservation is size flexible.
	SizeFlexEligible bool

	noSmithyDocumentSerde
}

// Details about the Amazon OpenSearch Service instances that Amazon Web Services
// recommends that you purchase.
type ESInstanceDetails struct {

	// Determines whether the recommendation is for a current-generation instance.
	CurrentGeneration bool

	// The class of instance that Amazon Web Services recommends.
	InstanceClass *string

	// The size of instance that Amazon Web Services recommends.
	InstanceSize *string

	// The Amazon Web Services Region of the recommended reservation.
	Region *string

	// Determines whether the recommended reservation is size flexible.
	SizeFlexEligible bool

	noSmithyDocumentSerde
}

// Use Expression to filter by cost or by usage. There are two patterns:
//
// * Simple
// dimension values - You can set the dimension name and values for the filters
// that you plan to use. For example, you can filter for REGION==us-east-1 OR
// REGION==us-west-1. For GetRightsizingRecommendation, the Region is a full name
// (for example, REGION==US East (N. Virginia). The Expression example is as
// follows: { "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", “us-west-1”
// ] } } The list of dimension values are OR'd together to retrieve cost or usage
// data. You can create Expression and DimensionValues objects using either with*
// methods or set* methods in multiple lines.
//
// * Compound dimension values with
// logical operations - You can use multiple Expression types and the logical
// operators AND/OR/NOT to create a list of one or more Expression objects. By
// doing this, you can filter on more advanced options. For example, you can filter
// on ((REGION == us-east-1 OR REGION == us-west-1) OR (TAG.Type == Type1)) AND
// (USAGE_TYPE != DataTransfer). The Expression for that is as follows: { "And": [
// {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1"
// ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not":
// {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] }
// Because each Expression can have only one operator, the service returns an error
// if more than one is specified. The following example shows an Expression object
// that creates an error.  { "And": [ ... ], "DimensionValues": { "Dimension":
// "USAGE_TYPE", "Values": [ "DataTransfer" ] } }
//
// For the
// GetRightsizingRecommendation action, a combination of OR and NOT isn't
// supported. OR isn't supported between different dimensions, or dimensions and
// tags. NOT operators aren't supported. Dimensions are also limited to
// LINKED_ACCOUNT, REGION, or RIGHTSIZING_TYPE. For the
// GetReservationPurchaseRecommendation action, only NOT is supported. AND and OR
// aren't supported. Dimensions are limited to LINKED_ACCOUNT.
type Expression struct {

	// Return results that match both Dimension objects.
	And []Expression

	// The filter that's based on CostCategory values.
	CostCategories *CostCategoryValues

	// The specific Dimension to use for Expression.
	Dimensions *DimensionValues

	// Return results that don't match a Dimension object.
	Not *Expression

	// Return results that match either Dimension object.
	Or []Expression

	// The specific Tag to use for Expression.
	Tags *TagValues

	noSmithyDocumentSerde
}

// The forecast that's created for your query.
type ForecastResult struct {

	// The mean value of the forecast.
	MeanValue *string

	// The lower limit for the prediction interval.
	PredictionIntervalLowerBound *string

	// The upper limit for the prediction interval.
	PredictionIntervalUpperBound *string

	// The period of time that the forecast covers.
	TimePeriod *DateInterval

	noSmithyDocumentSerde
}

// One level of grouped data in the results.
type Group struct {

	// The keys that are included in this group.
	Keys []string

	// The metrics that are included in this group.
	Metrics map[string]MetricValue

	noSmithyDocumentSerde
}

// Represents a group when you specify a group by criteria or in the response to a
// query with a specific grouping.
type GroupDefinition struct {

	// The string that represents a key for a specified group.
	Key *string

	// The string that represents the type of group.
	Type GroupDefinitionType

	noSmithyDocumentSerde
}

// The dollar value of the anomaly.
type Impact struct {

	// The maximum dollar value that's observed for an anomaly.
	//
	// This member is required.
	MaxImpact float64

	// The cumulative dollar value that's observed for an anomaly.
	TotalImpact float64

	noSmithyDocumentSerde
}

// Details about the instances that Amazon Web Services recommends that you
// purchase.
type InstanceDetails struct {

	// The Amazon EC2 instances that Amazon Web Services recommends that you purchase.
	EC2InstanceDetails *EC2InstanceDetails

	// The Amazon OpenSearch Service instances that Amazon Web Services recommends that
	// you purchase.
	ESInstanceDetails *ESInstanceDetails

	// The ElastiCache instances that Amazon Web Services recommends that you purchase.
	ElastiCacheInstanceDetails *ElastiCacheInstanceDetails

	// The Amazon RDS instances that Amazon Web Services recommends that you purchase.
	RDSInstanceDetails *RDSInstanceDetails

	// The Amazon Redshift instances that Amazon Web Services recommends that you
	// purchase.
	RedshiftInstanceDetails *RedshiftInstanceDetails

	noSmithyDocumentSerde
}

// The aggregated value for a metric.
type MetricValue struct {

	// The actual number that represents the metric.
	Amount *string

	// The unit that the metric is given in.
	Unit *string

	noSmithyDocumentSerde
}

// Details for the modification recommendation.
type ModifyRecommendationDetail struct {

	// Determines whether this instance type is the Amazon Web Services default
	// recommendation.
	TargetInstances []TargetInstance

	noSmithyDocumentSerde
}

// The network field that contains a list of network metrics that are associated
// with the current instance.
type NetworkResourceUtilization struct {

	// The network inbound throughput utilization measured in Bytes per second (Bps).
	NetworkInBytesPerSecond *string

	// The network outbound throughput utilization measured in Bytes per second (Bps).
	NetworkOutBytesPerSecond *string

	// The network inbound packets that are measured in packets per second.
	NetworkPacketsInPerSecond *string

	// The network outbound packets that are measured in packets per second.
	NetworkPacketsOutPerSecond *string

	noSmithyDocumentSerde
}

// Details about the Amazon RDS instances that Amazon Web Services recommends that
// you purchase.
type RDSInstanceDetails struct {

	// Determines whether the recommendation is for a current-generation instance.
	CurrentGeneration bool

	// The database edition that the recommended reservation supports.
	DatabaseEdition *string

	// The database engine that the recommended reservation supports.
	DatabaseEngine *string

	// Determines whether the recommendation is for a reservation in a single
	// Availability Zone or a reservation with a backup in a second Availability Zone.
	DeploymentOption *string

	// The instance family of the recommended reservation.
	Family *string

	// The type of instance that Amazon Web Services recommends.
	InstanceType *string

	// The license model that the recommended reservation supports.
	LicenseModel *string

	// The Amazon Web Services Region of the recommended reservation.
	Region *string

	// Determines whether the recommended reservation is size flexible.
	SizeFlexEligible bool

	noSmithyDocumentSerde
}

// Details about the Amazon Redshift instances that Amazon Web Services recommends
// that you purchase.
type RedshiftInstanceDetails struct {

	// Determines whether the recommendation is for a current-generation instance.
	CurrentGeneration bool

	// The instance family of the recommended reservation.
	Family *string

	// The type of node that Amazon Web Services recommends.
	NodeType *string

	// The Amazon Web Services Region of the recommended reservation.
	Region *string

	// Determines whether the recommended reservation is size flexible.
	SizeFlexEligible bool

	noSmithyDocumentSerde
}

// The aggregated numbers for your reservation usage.
type ReservationAggregates struct {

	// The monthly cost of your reservation. It's amortized over the reservation
	// period.
	AmortizedRecurringFee *string

	// The upfront cost of your reservation. It's amortized over the reservation
	// period.
	AmortizedUpfrontFee *string

	// How much you saved due to purchasing and utilizing reservation. Amazon Web
	// Services calculates this by subtracting TotalAmortizedFee from
	// OnDemandCostOfRIHoursUsed.
	NetRISavings *string

	// How much your reservation costs if charged On-Demand rates.
	OnDemandCostOfRIHoursUsed *string

	// How many reservation hours that you purchased.
	PurchasedHours *string

	// The number of Amazon EC2 reservation hours that you purchased. It's converted to
	// normalized units. Normalized units are available only for Amazon EC2 usage after
	// November 11, 2017.
	PurchasedUnits *string

	// The cost of unused hours for your reservation.
	RICostForUnusedHours *string

	// The realized savings because of purchasing and using a reservation.
	RealizedSavings *string

	// The total number of reservation hours that you used.
	TotalActualHours *string

	// The total number of Amazon EC2 reservation hours that you used. It's converted
	// to normalized units. Normalized units are available only for Amazon EC2 usage
	// after November 11, 2017.
	TotalActualUnits *string

	// The total cost of your reservation. It's amortized over the reservation period.
	TotalAmortizedFee *string

	// How much you might save if you use your entire reservation.
	TotalPotentialRISavings *string

	// The unrealized savings because of purchasing and using a reservation.
	UnrealizedSavings *string

	// The number of reservation hours that you didn't use.
	UnusedHours *string

	// The number of Amazon EC2 reservation hours that you didn't use. It's converted
	// to normalized units. Normalized units are available only for Amazon EC2 usage
	// after November 11, 2017.
	UnusedUnits *string

	// The percentage of reservation time that you used.
	UtilizationPercentage *string

	// The percentage of Amazon EC2 reservation time that you used. It's converted to
	// normalized units. Normalized units are available only for Amazon EC2 usage after
	// November 11, 2017.
	UtilizationPercentageInUnits *string

	noSmithyDocumentSerde
}

// A group of reservations that share a set of attributes.
type ReservationCoverageGroup struct {

	// The attributes for this group of reservations.
	Attributes map[string]string

	// How much instance usage this group of reservations covered.
	Coverage *Coverage

	noSmithyDocumentSerde
}

// A specific reservation that Amazon Web Services recommends for purchase.
type ReservationPurchaseRecommendation struct {

	// The account scope that Amazon Web Services recommends that you purchase this
	// instance for. For example, you can purchase this reservation for an entire
	// organization in Amazon Web Services Organizations.
	AccountScope AccountScope

	// How many days of previous usage that Amazon Web Services considers when making
	// this recommendation.
	LookbackPeriodInDays LookbackPeriodInDays

	// The payment option for the reservation (for example, AllUpfront or NoUpfront).
	PaymentOption PaymentOption

	// Details about the recommended purchases.
	RecommendationDetails []ReservationPurchaseRecommendationDetail

	// A summary about the recommended purchase.
	RecommendationSummary *ReservationPurchaseRecommendationSummary

	// Hardware specifications for the service that you want recommendations for.
	ServiceSpecification *ServiceSpecification

	// The term of the reservation that you want recommendations for, in years.
	TermInYears TermInYears

	noSmithyDocumentSerde
}

// Details about your recommended reservation purchase.
type ReservationPurchaseRecommendationDetail struct {

	// The account that this Reserved Instance (RI) recommendation is for.
	AccountId *string

	// The average number of normalized units that you used in an hour during the
	// historical period. Amazon Web Services uses this to calculate your recommended
	// reservation purchases.
	AverageNormalizedUnitsUsedPerHour *string

	// The average number of instances that you used in an hour during the historical
	// period. Amazon Web Services uses this to calculate your recommended reservation
	// purchases.
	AverageNumberOfInstancesUsedPerHour *string

	// The average utilization of your instances. Amazon Web Services uses this to
	// calculate your recommended reservation purchases.
	AverageUtilization *string

	// The currency code that Amazon Web Services used to calculate the costs for this
	// instance.
	CurrencyCode *string

	// How long Amazon Web Services estimates that it takes for this instance to start
	// saving you money, in months.
	EstimatedBreakEvenInMonths *string

	// How much Amazon Web Services estimates that you spend on On-Demand Instances in
	// a month.
	EstimatedMonthlyOnDemandCost *string

	// How much Amazon Web Services estimates that this specific recommendation might
	// save you in a month.
	EstimatedMonthlySavingsAmount *string

	// How much Amazon Web Services estimates that this specific recommendation might
	// save you in a month, as a percentage of your overall costs.
	EstimatedMonthlySavingsPercentage *string

	// How much Amazon Web Services estimates that you might spend for all usage during
	// the specified historical period if you had a reservation.
	EstimatedReservationCostForLookbackPeriod *string

	// Details about the instances that Amazon Web Services recommends that you
	// purchase.
	InstanceDetails *InstanceDetails

	// The maximum number of normalized units that you used in an hour during the
	// historical period. Amazon Web Services uses this to calculate your recommended
	// reservation purchases.
	MaximumNormalizedUnitsUsedPerHour *string

	// The maximum number of instances that you used in an hour during the historical
	// period. Amazon Web Services uses this to calculate your recommended reservation
	// purchases.
	MaximumNumberOfInstancesUsedPerHour *string

	// The minimum number of normalized units that you used in an hour during the
	// historical period. Amazon Web Services uses this to calculate your recommended
	// reservation purchases.
	MinimumNormalizedUnitsUsedPerHour *string

	// The minimum number of instances that you used in an hour during the historical
	// period. Amazon Web Services uses this to calculate your recommended reservation
	// purchases.
	MinimumNumberOfInstancesUsedPerHour *string

	// The number of normalized units that Amazon Web Services recommends that you
	// purchase.
	RecommendedNormalizedUnitsToPurchase *string

	// The number of instances that Amazon Web Services recommends that you purchase.
	RecommendedNumberOfInstancesToPurchase *string

	// How much purchasing this instance costs you on a monthly basis.
	RecurringStandardMonthlyCost *string

	// How much purchasing this instance costs you upfront.
	UpfrontCost *string

	noSmithyDocumentSerde
}

// Information about this specific recommendation, such as the timestamp for when
// Amazon Web Services made a specific recommendation.
type ReservationPurchaseRecommendationMetadata struct {

	// The timestamp for when Amazon Web Services made this recommendation.
	GenerationTimestamp *string

	// The ID for this specific recommendation.
	RecommendationId *string

	noSmithyDocumentSerde
}

// A summary about this recommendation, such as the currency code, the amount that
// Amazon Web Services estimates that you could save, and the total amount of
// reservation to purchase.
type ReservationPurchaseRecommendationSummary struct {

	// The currency code used for this recommendation.
	CurrencyCode *string

	// The total amount that Amazon Web Services estimates that this recommendation
	// could save you in a month.
	TotalEstimatedMonthlySavingsAmount *string

	// The total amount that Amazon Web Services estimates that this recommendation
	// could save you in a month, as a percentage of your costs.
	TotalEstimatedMonthlySavingsPercentage *string

	noSmithyDocumentSerde
}

// A group of reservations that share a set of attributes.
type ReservationUtilizationGroup struct {

	// The attributes for this group of reservations.
	Attributes map[string]string

	// The key for a specific reservation attribute.
	Key *string

	// How much you used this group of reservations.
	Utilization *ReservationAggregates

	// The value of a specific reservation attribute.
	Value *string

	noSmithyDocumentSerde
}

// Details for the resource.
type ResourceDetails struct {

	// Details for the Amazon EC2 resource.
	EC2ResourceDetails *EC2ResourceDetails

	noSmithyDocumentSerde
}

// The tag structure that contains a tag key and value. Tagging is supported only
// for the following Cost Explorer resource types: AnomalyMonitor
// (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AnomalyMonitor.html),
// AnomalySubscription
// (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AnomalySubscription.html),
// CostCategory
// (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostCategory.html).
type ResourceTag struct {

	// The key that's associated with the tag.
	//
	// This member is required.
	Key *string

	// The value that's associated with the tag.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Resource utilization of current resource.
type ResourceUtilization struct {

	// The utilization of current Amazon EC2 instance.
	EC2ResourceUtilization *EC2ResourceUtilization

	noSmithyDocumentSerde
}

// The result that's associated with a time period.
type ResultByTime struct {

	// Determines whether the result is estimated.
	Estimated bool

	// The groups that this time period includes.
	Groups []Group

	// The time period that the result covers.
	TimePeriod *DateInterval

	// The total amount of cost or usage accrued during the time period.
	Total map[string]MetricValue

	noSmithyDocumentSerde
}

// Recommendations to rightsize resources.
type RightsizingRecommendation struct {

	// The account that this recommendation is for.
	AccountId *string

	// Context regarding the current instance.
	CurrentInstance *CurrentInstance

	// The list of possible reasons why the recommendation is generated, such as under-
	// or over-utilization of specific metrics (for example, CPU, Memory, Network).
	FindingReasonCodes []FindingReasonCode

	// The details for the modification recommendations.
	ModifyRecommendationDetail *ModifyRecommendationDetail

	// A recommendation to either terminate or modify the resource.
	RightsizingType RightsizingType

	// The details for termination recommendations.
	TerminateRecommendationDetail *TerminateRecommendationDetail

	noSmithyDocumentSerde
}

// You can use RightsizingRecommendationConfiguration to customize recommendations
// across two attributes. You can choose to view recommendations for instances
// within the same instance families or across different instance families. You can
// also choose to view your estimated savings that are associated with
// recommendations with consideration of existing Savings Plans or Reserved
// Instance (RI) benefits, or neither.
type RightsizingRecommendationConfiguration struct {

	// The option to consider RI or Savings Plans discount benefits in your savings
	// calculation. The default value is TRUE.
	//
	// This member is required.
	BenefitsConsidered bool

	// The option to see recommendations within the same instance family or
	// recommendations for instances across other families. The default value is
	// SAME_INSTANCE_FAMILY.
	//
	// This member is required.
	RecommendationTarget RecommendationTarget

	noSmithyDocumentSerde
}

// Metadata for this recommendation set.
type RightsizingRecommendationMetadata struct {

	// Additional metadata that might be applicable to the recommendation.
	AdditionalMetadata *string

	// The timestamp for when Amazon Web Services made this recommendation.
	GenerationTimestamp *string

	// The number of days of previous usage that Amazon Web Services considers when
	// making this recommendation.
	LookbackPeriodInDays LookbackPeriodInDays

	// The ID for this specific recommendation.
	RecommendationId *string

	noSmithyDocumentSerde
}

// The summary of rightsizing recommendations
type RightsizingRecommendationSummary struct {

	// The estimated total savings resulting from modifications, on a monthly basis.
	EstimatedTotalMonthlySavingsAmount *string

	// The currency code that Amazon Web Services used to calculate the savings.
	SavingsCurrencyCode *string

	// The savings percentage based on the recommended modifications. It's relative to
	// the total On-Demand costs that are associated with these instances.
	SavingsPercentage *string

	// The total number of instance recommendations.
	TotalRecommendationCount *string

	noSmithyDocumentSerde
}

// The combination of Amazon Web Service, linked account, Region, and usage type
// where a cost anomaly is observed.
type RootCause struct {

	// The member account value that's associated with the cost anomaly.
	LinkedAccount *string

	// The Amazon Web Services Region that's associated with the cost anomaly.
	Region *string

	// The Amazon Web Service name that's associated with the cost anomaly.
	Service *string

	// The UsageType value that's associated with the cost anomaly.
	UsageType *string

	noSmithyDocumentSerde
}

// The amortized amount of Savings Plans purchased in a specific account during a
// specific time interval.
type SavingsPlansAmortizedCommitment struct {

	// The amortized amount of your Savings Plans commitment that was purchased with
	// either a Partial or a NoUpfront.
	AmortizedRecurringCommitment *string

	// The amortized amount of your Savings Plans commitment that was purchased with an
	// Upfront or PartialUpfront Savings Plans.
	AmortizedUpfrontCommitment *string

	// The total amortized amount of your Savings Plans commitment, regardless of your
	// Savings Plans purchase method.
	TotalAmortizedCommitment *string

	noSmithyDocumentSerde
}

// The amount of Savings Plans eligible usage that's covered by Savings Plans. All
// calculations consider the On-Demand equivalent of your Savings Plans usage.
type SavingsPlansCoverage struct {

	// The attribute that applies to a specific Dimension.
	Attributes map[string]string

	// The amount of Savings Plans eligible usage that the Savings Plans covered.
	Coverage *SavingsPlansCoverageData

	// The time period of the request.
	TimePeriod *DateInterval

	noSmithyDocumentSerde
}

// Specific coverage percentage, On-Demand costs, and spend covered by Savings
// Plans, and total Savings Plans costs for an account.
type SavingsPlansCoverageData struct {

	// The percentage of your existing Savings Plans covered usage, divided by all of
	// your eligible Savings Plans usage in an account (or set of accounts).
	CoveragePercentage *string

	// The cost of your Amazon Web Services usage at the public On-Demand rate.
	OnDemandCost *string

	// The amount of your Amazon Web Services usage that's covered by a Savings Plans.
	SpendCoveredBySavingsPlans *string

	// The total cost of your Amazon Web Services usage, regardless of your purchase
	// option.
	TotalCost *string

	noSmithyDocumentSerde
}

// The attribute details on a specific Savings Plan.
type SavingsPlansDetails struct {

	// A group of instance types that Savings Plans applies to.
	InstanceFamily *string

	// The unique ID that's used to distinguish Savings Plans from one another.
	OfferingId *string

	// A collection of Amazon Web Services resources in a geographic area. Each Amazon
	// Web Services Region is isolated and independent of the other Regions.
	Region *string

	noSmithyDocumentSerde
}

// Contains your request parameters, Savings Plan Recommendations Summary, and
// Details.
type SavingsPlansPurchaseRecommendation struct {

	// The account scope that you want your recommendations for. Amazon Web Services
	// calculates recommendations that include the management account and member
	// accounts if the value is set to PAYER. If the value is LINKED, recommendations
	// are calculated for individual member accounts only.
	AccountScope AccountScope

	// The lookback period in days that's used to generate the recommendation.
	LookbackPeriodInDays LookbackPeriodInDays

	// The payment option that's used to generate the recommendation.
	PaymentOption PaymentOption

	// Details for the Savings Plans that we recommend that you purchase to cover
	// existing Savings Plans eligible workloads.
	SavingsPlansPurchaseRecommendationDetails []SavingsPlansPurchaseRecommendationDetail

	// Summary metrics for your Savings Plans Recommendations.
	SavingsPlansPurchaseRecommendationSummary *SavingsPlansPurchaseRecommendationSummary

	// The requested Savings Plans recommendation type.
	SavingsPlansType SupportedSavingsPlansType

	// The Savings Plans recommendation term in years. It's used to generate the
	// recommendation.
	TermInYears TermInYears

	noSmithyDocumentSerde
}

// Details for your recommended Savings Plans.
type SavingsPlansPurchaseRecommendationDetail struct {

	// The AccountID the recommendation is generated for.
	AccountId *string

	// The currency code that Amazon Web Services used to generate the recommendations
	// and present potential savings.
	CurrencyCode *string

	// The average value of hourly On-Demand spend over the lookback period of the
	// applicable usage type.
	CurrentAverageHourlyOnDemandSpend *string

	// The highest value of hourly On-Demand spend over the lookback period of the
	// applicable usage type.
	CurrentMaximumHourlyOnDemandSpend *string

	// The lowest value of hourly On-Demand spend over the lookback period of the
	// applicable usage type.
	CurrentMinimumHourlyOnDemandSpend *string

	// The estimated utilization of the recommended Savings Plans.
	EstimatedAverageUtilization *string

	// The estimated monthly savings amount based on the recommended Savings Plans.
	EstimatedMonthlySavingsAmount *string

	// The remaining On-Demand cost estimated to not be covered by the recommended
	// Savings Plans, over the length of the lookback period.
	EstimatedOnDemandCost *string

	// The estimated On-Demand costs you expect with no additional commitment, based on
	// your usage of the selected time period and the Savings Plans you own.
	EstimatedOnDemandCostWithCurrentCommitment *string

	// The estimated return on investment that's based on the recommended Savings Plans
	// that you purchased. This is calculated as estimatedSavingsAmount/
	// estimatedSPCost*100.
	EstimatedROI *string

	// The cost of the recommended Savings Plans over the length of the lookback
	// period.
	EstimatedSPCost *string

	// The estimated savings amount that's based on the recommended Savings Plans over
	// the length of the lookback period.
	EstimatedSavingsAmount *string

	// The estimated savings percentage relative to the total cost of applicable
	// On-Demand usage over the lookback period.
	EstimatedSavingsPercentage *string

	// The recommended hourly commitment level for the Savings Plans type and the
	// configuration that's based on the usage during the lookback period.
	HourlyCommitmentToPurchase *string

	// Details for your recommended Savings Plans.
	SavingsPlansDetails *SavingsPlansDetails

	// The upfront cost of the recommended Savings Plans, based on the selected payment
	// option.
	UpfrontCost *string

	noSmithyDocumentSerde
}

// Metadata about your Savings Plans Purchase Recommendations.
type SavingsPlansPurchaseRecommendationMetadata struct {

	// Additional metadata that might be applicable to the recommendation.
	AdditionalMetadata *string

	// The timestamp that shows when the recommendations were generated.
	GenerationTimestamp *string

	// The unique identifier for the recommendation set.
	RecommendationId *string

	noSmithyDocumentSerde
}

// Summary metrics for your Savings Plans Purchase Recommendations.
type SavingsPlansPurchaseRecommendationSummary struct {

	// The currency code that Amazon Web Services used to generate the recommendations
	// and present potential savings.
	CurrencyCode *string

	// The current total on demand spend of the applicable usage types over the
	// lookback period.
	CurrentOnDemandSpend *string

	// The recommended Savings Plans cost on a daily (24 hourly) basis.
	DailyCommitmentToPurchase *string

	// The estimated monthly savings amount that's based on the recommended Savings
	// Plans purchase.
	EstimatedMonthlySavingsAmount *string

	// The estimated On-Demand costs you expect with no additional commitment. It's
	// based on your usage of the selected time period and the Savings Plans you own.
	EstimatedOnDemandCostWithCurrentCommitment *string

	// The estimated return on investment that's based on the recommended Savings Plans
	// and estimated savings.
	EstimatedROI *string

	// The estimated total savings over the lookback period, based on the purchase of
	// the recommended Savings Plans.
	EstimatedSavingsAmount *string

	// The estimated savings relative to the total cost of On-Demand usage, over the
	// lookback period. This is calculated as estimatedSavingsAmount/
	// CurrentOnDemandSpend*100.
	EstimatedSavingsPercentage *string

	// The estimated total cost of the usage after purchasing the recommended Savings
	// Plans. This is a sum of the cost of Savings Plans during this term, and the
	// remaining On-Demand usage.
	EstimatedTotalCost *string

	// The recommended hourly commitment that's based on the recommendation parameters.
	HourlyCommitmentToPurchase *string

	// The aggregate number of Savings Plans recommendations that exist for your
	// account.
	TotalRecommendationCount *string

	noSmithyDocumentSerde
}

// The amount of savings that you're accumulating, against the public On-Demand
// rate of the usage accrued in an account.
type SavingsPlansSavings struct {

	// The savings amount that you're accumulating for the usage that's covered by a
	// Savings Plans, when compared to the On-Demand equivalent of the same usage.
	NetSavings *string

	// How much the amount that the usage would have cost if it was accrued at the
	// On-Demand rate.
	OnDemandCostEquivalent *string

	noSmithyDocumentSerde
}

// The measurement of how well you're using your existing Savings Plans.
type SavingsPlansUtilization struct {

	// The total amount of Savings Plans commitment that's been purchased in an account
	// (or set of accounts).
	TotalCommitment *string

	// The amount of your Savings Plans commitment that wasn't consumed from Savings
	// Plans eligible usage in a specific period.
	UnusedCommitment *string

	// The amount of your Savings Plans commitment that was consumed from Savings Plans
	// eligible usage in a specific period.
	UsedCommitment *string

	// The amount of UsedCommitment divided by the TotalCommitment for your Savings
	// Plans.
	UtilizationPercentage *string

	noSmithyDocumentSerde
}

// The aggregated utilization metrics for your Savings Plans usage.
type SavingsPlansUtilizationAggregates struct {

	// A ratio of your effectiveness of using existing Savings Plans to apply to
	// workloads that are Savings Plans eligible.
	//
	// This member is required.
	Utilization *SavingsPlansUtilization

	// The total amortized commitment for a Savings Plans. This includes the sum of the
	// upfront and recurring Savings Plans fees.
	AmortizedCommitment *SavingsPlansAmortizedCommitment

	// The amount that's saved by using existing Savings Plans. Savings returns both
	// net savings from Savings Plans and also the onDemandCostEquivalent of the
	// Savings Plans when considering the utilization rate.
	Savings *SavingsPlansSavings

	noSmithyDocumentSerde
}

// The amount of Savings Plans utilization (in hours).
type SavingsPlansUtilizationByTime struct {

	// The time period of the request.
	//
	// This member is required.
	TimePeriod *DateInterval

	// A ratio of your effectiveness of using existing Savings Plans to apply to
	// workloads that are Savings Plans eligible.
	//
	// This member is required.
	Utilization *SavingsPlansUtilization

	// The total amortized commitment for a Savings Plans. This includes the sum of the
	// upfront and recurring Savings Plans fees.
	AmortizedCommitment *SavingsPlansAmortizedCommitment

	// The amount that's saved by using existing Savings Plans. Savings returns both
	// net savings from Savings Plans and also the onDemandCostEquivalent of the
	// Savings Plans when considering the utilization rate.
	Savings *SavingsPlansSavings

	noSmithyDocumentSerde
}

// A single daily or monthly Savings Plans utilization rate and details for your
// account. A management account in an organization have access to member accounts.
// You can use GetDimensionValues to determine the possible dimension values.
type SavingsPlansUtilizationDetail struct {

	// The total amortized commitment for a Savings Plans. Includes the sum of the
	// upfront and recurring Savings Plans fees.
	AmortizedCommitment *SavingsPlansAmortizedCommitment

	// The attribute that applies to a specific Dimension.
	Attributes map[string]string

	// The amount saved by using existing Savings Plans. Savings returns both net
	// savings from savings plans and also the onDemandCostEquivalent of the Savings
	// Plans when considering the utilization rate.
	Savings *SavingsPlansSavings

	// The unique Amazon Resource Name (ARN) for a particular Savings Plan.
	SavingsPlanArn *string

	// A ratio of your effectiveness of using existing Savings Plans to apply to
	// workloads that are Savings Plans eligible.
	Utilization *SavingsPlansUtilization

	noSmithyDocumentSerde
}

// Hardware specifications for the service that you want recommendations for.
type ServiceSpecification struct {

	// The Amazon EC2 hardware specifications that you want Amazon Web Services to
	// provide recommendations for.
	EC2Specification *EC2Specification

	noSmithyDocumentSerde
}

// The details for how to sort the data.
type SortDefinition struct {

	// The key that's used to sort the data.
	//
	// This member is required.
	Key *string

	// The order that's used to sort the data.
	SortOrder SortOrder

	noSmithyDocumentSerde
}

// The recipient of AnomalySubscription notifications.
type Subscriber struct {

	// The email address or SNS Amazon Resource Name (ARN). This depends on the Type.
	Address *string

	// Indicates if the subscriber accepts the notifications.
	Status SubscriberStatus

	// The notification delivery channel.
	Type SubscriberType

	noSmithyDocumentSerde
}

// The values that are available for a tag. If Values and Key aren't specified, the
// ABSENTMatchOption is applied to all tags. That is, it's filtered on resources
// with no tags. If Key is provided and Values isn't specified, the
// ABSENTMatchOption is applied to the tag Key only. That is, it's filtered on
// resources without the given tag key.
type TagValues struct {

	// The key for the tag.
	Key *string

	// The match options that you can use to filter your results. MatchOptions is only
	// applicable for actions related to Cost Category. The default values for
	// MatchOptions are EQUALS and CASE_SENSITIVE.
	MatchOptions []MatchOption

	// The specific value of the tag.
	Values []string

	noSmithyDocumentSerde
}

// Details on recommended instance.
type TargetInstance struct {

	// The currency code that Amazon Web Services used to calculate the costs for this
	// instance.
	CurrencyCode *string

	// Determines whether this recommendation is the defaulted Amazon Web Services
	// recommendation.
	DefaultTargetInstance bool

	// The expected cost to operate this instance type on a monthly basis.
	EstimatedMonthlyCost *string

	// The estimated savings that result from modification, on a monthly basis.
	EstimatedMonthlySavings *string

	// The expected utilization metrics for target instance type.
	ExpectedResourceUtilization *ResourceUtilization

	// Explains the actions that you might need to take to successfully migrate your
	// workloads from the current instance type to the recommended instance type.
	PlatformDifferences []PlatformDifference

	// Details on the target instance type.
	ResourceDetails *ResourceDetails

	noSmithyDocumentSerde
}

// Details on termination recommendation.
type TerminateRecommendationDetail struct {

	// The currency code that Amazon Web Services used to calculate the costs for this
	// instance.
	CurrencyCode *string

	// The estimated savings that result from modification, on a monthly basis.
	EstimatedMonthlySavings *string

	noSmithyDocumentSerde
}

// Filters cost anomalies based on the total impact.
type TotalImpactFilter struct {

	// The comparing value that's used in the filter.
	//
	// This member is required.
	NumericOperator NumericOperator

	// The lower bound dollar value that's used in the filter.
	//
	// This member is required.
	StartValue float64

	// The upper bound dollar value that's used in the filter.
	EndValue float64

	noSmithyDocumentSerde
}

// Gives a detailed description of the result of an action. It's on each cost
// allocation tag entry in the request.
type UpdateCostAllocationTagsStatusError struct {

	// An error code representing why the action failed on this entry.
	Code *string

	// A message explaining why the action failed on this entry.
	Message *string

	// The key for the cost allocation tag.
	TagKey *string

	noSmithyDocumentSerde
}

// The amount of utilization, in hours.
type UtilizationByTime struct {

	// The groups that this utilization result uses.
	Groups []ReservationUtilizationGroup

	// The period of time that this utilization was used for.
	TimePeriod *DateInterval

	// The total number of reservation hours that were used.
	Total *ReservationAggregates

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
