// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package options

import (
	"fmt"
	"strings"
)

type (
	Factory   func() Interface
	Factories map[string]Factory
)

var factories = make(Factories, 10)

func GetFactories() Factories {
	return factories
}

func RegisterFactory(name string, factory Factory) {
	name = strings.ToLower(name)
	factories[name] = factory
}

func GetFactory(name string) Factory {
	name = strings.ToLower(name)
	factory, ok := factories[name]
	if !ok {
		panic(fmt.Errorf("no options factory registered for %s", name))
	}
	return factory
}
