/* GKrellM  mailwatch plugin
|  Copyright (C) 1999-2000 Sjoerd Simons
|
|  Author:  Sjoerd Simons <sjoerd@luon.net>
|
|  This program is free software which I release under the GNU General Public
|  License. You may redistribute and/or modify this program under the terms
|  of that license as published by the Free Software Foundation; either
|  version 2 of the License, or (at your option) any later version.
|
|  This program is distributed in the hope that it will be useful,
|  but WITHOUT ANY WARRANTY; without even the implied warranty of
|  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
|  GNU General Public License for more details.
|
|  To get a copy of the GNU General Puplic License,  write to the
|  Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
|  02111-1307 USA
*/
#include <gkrellm2/gkrellm.h>
#include <time.h>

/* version stuff */
#define MAILWATCH_MAJOR_VERSION 2
#define MAILWATCH_MINOR_VERSION 4
#define MAILWATCH_EXTRA_VERSION ".3"

/* define stuff for the config tab is_modified*/
#define NMODIFIED 0
#define MODIFIED 1
#define NEW 3
#define DELETED 4

/* define some stuff for the toggles */
#define SHOW_TOTAL 1 << 0
#define O_IS_NEW   1 << 1
#define SHOW_TIPS  1 << 2
#define HLIGHT_NEW 1 << 3

/*--*/
#define CONFIG_KEYWORD "mailwatch_plugin_config"
#define MW_STYLE_NAME  "mailwatch"

#ifdef MON_INSERT_AFTER
  #define LOCATION (MON_MAIL | MON_INSERT_AFTER)
#else
  #define LOCATION MON_APM 
#endif

/* The location of the plugin, choose between :
|*   MON_CLOCK, MON_CPU, MON_PROC, MON_DISK,
|*   MON_INET, MON_NET, MON_FS, MON_MAIL,       
|*   MON_APM, or MON_UPTIME                    
*/


#define ANIMATION_STEPS 5

typedef struct {
  gchar   *path;
  time_t  last_checktime;
  gint    mail_count;
  gint    new_mail_count;
  gint    old_new_mail_count;
  gint    old_mail_count;
  gint    is_internal;
  time_t  last_mtime;
  off_t   last_size;
} Mailbox ;

typedef struct {
  gchar *path;
  GList *mailbox_list;
} Mailpath;

typedef struct Mailpanel Mailpanel; 

  struct Mailpanel {
  gchar     *name;
  Mailpanel *next;
  GkrellmPanel     *panel;
  GkrellmDecal     *nametext;
  GkrellmDecal     *statstext;
  GtkTooltips *tip;
  gboolean  update_tooltip;
  GList     *mailpath_list;
  gchar     *command;
  gint      ticks,ticks_left;
  gint      animation_step;
} ;

typedef struct Configtab Configtab;

struct Configtab {
  gchar *name; 
  Configtab *next;
  GtkWidget *entry;
  GtkWidget *list;
  GtkWidget *tabs;
  GList     *mailbox_list;
  gint      row;
  gint      is_mailpanel;
  gint      is_modified;
  gchar     *command;
  gint      ticks;
  } ;

