---
stage: none
group: unassigned
description: Runners, jobs, pipelines, variables.
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Use CI/CD to build your application

Use CI/CD to generate your application.

|  |  |  |
|--|--|--|
| [**Getting started**](../ci/index.md)<br>Overview of how CI/CD features fit together.                                | [**CI/CD YAML syntax reference**](../ci/yaml/index.md)<br>Pipeline configuration keywords, syntax, examples, inputs.           | [**Runners**](https://docs.gitlab.com/runner/)<br>Installation, configuration, job execution. |
| [**Pipelines**](../ci/pipelines/index.md)<br>Configuration, automation, stages, schedules, efficiency.               | [**Jobs**](../ci/jobs/index.md)<br>Configuration, rules, caching, artifacts, logs.                                             | [**CI/CD components**](../ci/components/index.md)<br>Reusable, versioned CI/CD components for pipelines. |
| [**CI/CD variables**](../ci/variables/index.md)<br>Configuration, usage, security.                                   | [**Pipeline security**](../ci/pipelines/pipeline_security.md)<br>Secrets management, job tokens, secure files, cloud security. | [**Debugging**](../ci/debugging.md)<br>Configuration validation, warnings, errors, troubleshooting. |
| [**Auto DevOps**](autodevops/index.md)<br>Automated DevOps, language detection, deployment, customization.           | [**Testing**](../ci/testing/index.md)<br>Unit tests, integration tests, test reports, coverage, quality assurance.             | [**Google cloud integration**](../ci/gitlab_google_cloud_integration/index.md)<br>Cloud services, Kubernetes deployments. |
| [**Migrate to GitLab CI/CD**](../ci/migration/plan_a_migration.md)<br> Migrate from Jenkins, GitHub Actions, others. | [**External repository integrations**](../ci/ci_cd_for_external_repos/index.md)<br>GitHub, Bitbucket, external sources, mirroring, cross-platform. |  |
