//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdeviceprovisioningservices

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// IotDpsResourceClient contains the methods for the IotDpsResource group.
// Don't use this type directly, use NewIotDpsResourceClient() instead.
type IotDpsResourceClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewIotDpsResourceClient creates a new instance of IotDpsResourceClient with the specified values.
// subscriptionID - The subscription identifier.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewIotDpsResourceClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*IotDpsResourceClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &IotDpsResourceClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// CheckProvisioningServiceNameAvailability - Check if a provisioning service name is available. This will validate if the
// name is syntactically valid and if the name is usable
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-02-05
// arguments - Set the name parameter in the OperationInputs structure to the name of the provisioning service to check.
// options - IotDpsResourceClientCheckProvisioningServiceNameAvailabilityOptions contains the optional parameters for the
// IotDpsResourceClient.CheckProvisioningServiceNameAvailability method.
func (client *IotDpsResourceClient) CheckProvisioningServiceNameAvailability(ctx context.Context, arguments OperationInputs, options *IotDpsResourceClientCheckProvisioningServiceNameAvailabilityOptions) (IotDpsResourceClientCheckProvisioningServiceNameAvailabilityResponse, error) {
	req, err := client.checkProvisioningServiceNameAvailabilityCreateRequest(ctx, arguments, options)
	if err != nil {
		return IotDpsResourceClientCheckProvisioningServiceNameAvailabilityResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return IotDpsResourceClientCheckProvisioningServiceNameAvailabilityResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return IotDpsResourceClientCheckProvisioningServiceNameAvailabilityResponse{}, runtime.NewResponseError(resp)
	}
	return client.checkProvisioningServiceNameAvailabilityHandleResponse(resp)
}

// checkProvisioningServiceNameAvailabilityCreateRequest creates the CheckProvisioningServiceNameAvailability request.
func (client *IotDpsResourceClient) checkProvisioningServiceNameAvailabilityCreateRequest(ctx context.Context, arguments OperationInputs, options *IotDpsResourceClientCheckProvisioningServiceNameAvailabilityOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Devices/checkProvisioningServiceNameAvailability"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-02-05")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, arguments)
}

// checkProvisioningServiceNameAvailabilityHandleResponse handles the CheckProvisioningServiceNameAvailability response.
func (client *IotDpsResourceClient) checkProvisioningServiceNameAvailabilityHandleResponse(resp *http.Response) (IotDpsResourceClientCheckProvisioningServiceNameAvailabilityResponse, error) {
	result := IotDpsResourceClientCheckProvisioningServiceNameAvailabilityResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.NameAvailabilityInfo); err != nil {
		return IotDpsResourceClientCheckProvisioningServiceNameAvailabilityResponse{}, err
	}
	return result, nil
}

// BeginCreateOrUpdate - Create or update the metadata of the provisioning service. The usual pattern to modify a property
// is to retrieve the provisioning service metadata and security metadata, and then combine them with the
// modified values in a new body to update the provisioning service.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-02-05
// resourceGroupName - Resource group identifier.
// provisioningServiceName - Name of provisioning service to create or update.
// iotDpsDescription - Description of the provisioning service to create or update.
// options - IotDpsResourceClientBeginCreateOrUpdateOptions contains the optional parameters for the IotDpsResourceClient.BeginCreateOrUpdate
// method.
func (client *IotDpsResourceClient) BeginCreateOrUpdate(ctx context.Context, resourceGroupName string, provisioningServiceName string, iotDpsDescription ProvisioningServiceDescription, options *IotDpsResourceClientBeginCreateOrUpdateOptions) (*runtime.Poller[IotDpsResourceClientCreateOrUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdate(ctx, resourceGroupName, provisioningServiceName, iotDpsDescription, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[IotDpsResourceClientCreateOrUpdateResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[IotDpsResourceClientCreateOrUpdateResponse](options.ResumeToken, client.pl, nil)
	}
}

// CreateOrUpdate - Create or update the metadata of the provisioning service. The usual pattern to modify a property is to
// retrieve the provisioning service metadata and security metadata, and then combine them with the
// modified values in a new body to update the provisioning service.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-02-05
func (client *IotDpsResourceClient) createOrUpdate(ctx context.Context, resourceGroupName string, provisioningServiceName string, iotDpsDescription ProvisioningServiceDescription, options *IotDpsResourceClientBeginCreateOrUpdateOptions) (*http.Response, error) {
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, provisioningServiceName, iotDpsDescription, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *IotDpsResourceClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, provisioningServiceName string, iotDpsDescription ProvisioningServiceDescription, options *IotDpsResourceClientBeginCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/provisioningServices/{provisioningServiceName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if provisioningServiceName == "" {
		return nil, errors.New("parameter provisioningServiceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{provisioningServiceName}", url.PathEscape(provisioningServiceName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-02-05")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, iotDpsDescription)
}

// BeginCreateOrUpdatePrivateEndpointConnection - Create or update the status of a private endpoint connection with the specified
// name
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-02-05
// resourceGroupName - The name of the resource group that contains the provisioning service.
// resourceName - The name of the provisioning service.
// privateEndpointConnectionName - The name of the private endpoint connection
// privateEndpointConnection - The private endpoint connection with updated properties
// options - IotDpsResourceClientBeginCreateOrUpdatePrivateEndpointConnectionOptions contains the optional parameters for
// the IotDpsResourceClient.BeginCreateOrUpdatePrivateEndpointConnection method.
func (client *IotDpsResourceClient) BeginCreateOrUpdatePrivateEndpointConnection(ctx context.Context, resourceGroupName string, resourceName string, privateEndpointConnectionName string, privateEndpointConnection PrivateEndpointConnection, options *IotDpsResourceClientBeginCreateOrUpdatePrivateEndpointConnectionOptions) (*runtime.Poller[IotDpsResourceClientCreateOrUpdatePrivateEndpointConnectionResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdatePrivateEndpointConnection(ctx, resourceGroupName, resourceName, privateEndpointConnectionName, privateEndpointConnection, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[IotDpsResourceClientCreateOrUpdatePrivateEndpointConnectionResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[IotDpsResourceClientCreateOrUpdatePrivateEndpointConnectionResponse](options.ResumeToken, client.pl, nil)
	}
}

// CreateOrUpdatePrivateEndpointConnection - Create or update the status of a private endpoint connection with the specified
// name
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-02-05
func (client *IotDpsResourceClient) createOrUpdatePrivateEndpointConnection(ctx context.Context, resourceGroupName string, resourceName string, privateEndpointConnectionName string, privateEndpointConnection PrivateEndpointConnection, options *IotDpsResourceClientBeginCreateOrUpdatePrivateEndpointConnectionOptions) (*http.Response, error) {
	req, err := client.createOrUpdatePrivateEndpointConnectionCreateRequest(ctx, resourceGroupName, resourceName, privateEndpointConnectionName, privateEndpointConnection, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// createOrUpdatePrivateEndpointConnectionCreateRequest creates the CreateOrUpdatePrivateEndpointConnection request.
func (client *IotDpsResourceClient) createOrUpdatePrivateEndpointConnectionCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, privateEndpointConnectionName string, privateEndpointConnection PrivateEndpointConnection, options *IotDpsResourceClientBeginCreateOrUpdatePrivateEndpointConnectionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/provisioningServices/{resourceName}/privateEndpointConnections/{privateEndpointConnectionName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if privateEndpointConnectionName == "" {
		return nil, errors.New("parameter privateEndpointConnectionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{privateEndpointConnectionName}", url.PathEscape(privateEndpointConnectionName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-02-05")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, privateEndpointConnection)
}

// BeginDelete - Deletes the Provisioning Service.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-02-05
// provisioningServiceName - Name of provisioning service to delete.
// resourceGroupName - Resource group identifier.
// options - IotDpsResourceClientBeginDeleteOptions contains the optional parameters for the IotDpsResourceClient.BeginDelete
// method.
func (client *IotDpsResourceClient) BeginDelete(ctx context.Context, provisioningServiceName string, resourceGroupName string, options *IotDpsResourceClientBeginDeleteOptions) (*runtime.Poller[IotDpsResourceClientDeleteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteOperation(ctx, provisioningServiceName, resourceGroupName, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[IotDpsResourceClientDeleteResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[IotDpsResourceClientDeleteResponse](options.ResumeToken, client.pl, nil)
	}
}

// Delete - Deletes the Provisioning Service.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-02-05
func (client *IotDpsResourceClient) deleteOperation(ctx context.Context, provisioningServiceName string, resourceGroupName string, options *IotDpsResourceClientBeginDeleteOptions) (*http.Response, error) {
	req, err := client.deleteCreateRequest(ctx, provisioningServiceName, resourceGroupName, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted, http.StatusNoContent, http.StatusNotFound) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// deleteCreateRequest creates the Delete request.
func (client *IotDpsResourceClient) deleteCreateRequest(ctx context.Context, provisioningServiceName string, resourceGroupName string, options *IotDpsResourceClientBeginDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/provisioningServices/{provisioningServiceName}"
	if provisioningServiceName == "" {
		return nil, errors.New("parameter provisioningServiceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{provisioningServiceName}", url.PathEscape(provisioningServiceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-02-05")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// BeginDeletePrivateEndpointConnection - Delete private endpoint connection with the specified name
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-02-05
// resourceGroupName - The name of the resource group that contains the provisioning service.
// resourceName - The name of the provisioning service.
// privateEndpointConnectionName - The name of the private endpoint connection
// options - IotDpsResourceClientBeginDeletePrivateEndpointConnectionOptions contains the optional parameters for the IotDpsResourceClient.BeginDeletePrivateEndpointConnection
// method.
func (client *IotDpsResourceClient) BeginDeletePrivateEndpointConnection(ctx context.Context, resourceGroupName string, resourceName string, privateEndpointConnectionName string, options *IotDpsResourceClientBeginDeletePrivateEndpointConnectionOptions) (*runtime.Poller[IotDpsResourceClientDeletePrivateEndpointConnectionResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deletePrivateEndpointConnection(ctx, resourceGroupName, resourceName, privateEndpointConnectionName, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[IotDpsResourceClientDeletePrivateEndpointConnectionResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[IotDpsResourceClientDeletePrivateEndpointConnectionResponse](options.ResumeToken, client.pl, nil)
	}
}

// DeletePrivateEndpointConnection - Delete private endpoint connection with the specified name
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-02-05
func (client *IotDpsResourceClient) deletePrivateEndpointConnection(ctx context.Context, resourceGroupName string, resourceName string, privateEndpointConnectionName string, options *IotDpsResourceClientBeginDeletePrivateEndpointConnectionOptions) (*http.Response, error) {
	req, err := client.deletePrivateEndpointConnectionCreateRequest(ctx, resourceGroupName, resourceName, privateEndpointConnectionName, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted, http.StatusNoContent) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// deletePrivateEndpointConnectionCreateRequest creates the DeletePrivateEndpointConnection request.
func (client *IotDpsResourceClient) deletePrivateEndpointConnectionCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, privateEndpointConnectionName string, options *IotDpsResourceClientBeginDeletePrivateEndpointConnectionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/provisioningServices/{resourceName}/privateEndpointConnections/{privateEndpointConnectionName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if privateEndpointConnectionName == "" {
		return nil, errors.New("parameter privateEndpointConnectionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{privateEndpointConnectionName}", url.PathEscape(privateEndpointConnectionName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-02-05")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Get the metadata of the provisioning service without SAS keys.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-02-05
// provisioningServiceName - Name of the provisioning service to retrieve.
// resourceGroupName - Resource group name.
// options - IotDpsResourceClientGetOptions contains the optional parameters for the IotDpsResourceClient.Get method.
func (client *IotDpsResourceClient) Get(ctx context.Context, provisioningServiceName string, resourceGroupName string, options *IotDpsResourceClientGetOptions) (IotDpsResourceClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, provisioningServiceName, resourceGroupName, options)
	if err != nil {
		return IotDpsResourceClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return IotDpsResourceClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return IotDpsResourceClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *IotDpsResourceClient) getCreateRequest(ctx context.Context, provisioningServiceName string, resourceGroupName string, options *IotDpsResourceClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/provisioningServices/{provisioningServiceName}"
	if provisioningServiceName == "" {
		return nil, errors.New("parameter provisioningServiceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{provisioningServiceName}", url.PathEscape(provisioningServiceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-02-05")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *IotDpsResourceClient) getHandleResponse(resp *http.Response) (IotDpsResourceClientGetResponse, error) {
	result := IotDpsResourceClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ProvisioningServiceDescription); err != nil {
		return IotDpsResourceClientGetResponse{}, err
	}
	return result, nil
}

// GetOperationResult - Gets the status of a long running operation, such as create, update or delete a provisioning service.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-02-05
// operationID - Operation id corresponding to long running operation. Use this to poll for the status.
// resourceGroupName - Resource group identifier.
// provisioningServiceName - Name of provisioning service that the operation is running on.
// asyncinfo - Async header used to poll on the status of the operation, obtained while creating the long running operation.
// options - IotDpsResourceClientGetOperationResultOptions contains the optional parameters for the IotDpsResourceClient.GetOperationResult
// method.
func (client *IotDpsResourceClient) GetOperationResult(ctx context.Context, operationID string, resourceGroupName string, provisioningServiceName string, asyncinfo string, options *IotDpsResourceClientGetOperationResultOptions) (IotDpsResourceClientGetOperationResultResponse, error) {
	req, err := client.getOperationResultCreateRequest(ctx, operationID, resourceGroupName, provisioningServiceName, asyncinfo, options)
	if err != nil {
		return IotDpsResourceClientGetOperationResultResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return IotDpsResourceClientGetOperationResultResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return IotDpsResourceClientGetOperationResultResponse{}, runtime.NewResponseError(resp)
	}
	return client.getOperationResultHandleResponse(resp)
}

// getOperationResultCreateRequest creates the GetOperationResult request.
func (client *IotDpsResourceClient) getOperationResultCreateRequest(ctx context.Context, operationID string, resourceGroupName string, provisioningServiceName string, asyncinfo string, options *IotDpsResourceClientGetOperationResultOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/provisioningServices/{provisioningServiceName}/operationresults/{operationId}"
	if operationID == "" {
		return nil, errors.New("parameter operationID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{operationId}", url.PathEscape(operationID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if provisioningServiceName == "" {
		return nil, errors.New("parameter provisioningServiceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{provisioningServiceName}", url.PathEscape(provisioningServiceName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("asyncinfo", asyncinfo)
	reqQP.Set("api-version", "2022-02-05")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getOperationResultHandleResponse handles the GetOperationResult response.
func (client *IotDpsResourceClient) getOperationResultHandleResponse(resp *http.Response) (IotDpsResourceClientGetOperationResultResponse, error) {
	result := IotDpsResourceClientGetOperationResultResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AsyncOperationResult); err != nil {
		return IotDpsResourceClientGetOperationResultResponse{}, err
	}
	return result, nil
}

// GetPrivateEndpointConnection - Get private endpoint connection properties
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-02-05
// resourceGroupName - The name of the resource group that contains the provisioning service.
// resourceName - The name of the provisioning service.
// privateEndpointConnectionName - The name of the private endpoint connection
// options - IotDpsResourceClientGetPrivateEndpointConnectionOptions contains the optional parameters for the IotDpsResourceClient.GetPrivateEndpointConnection
// method.
func (client *IotDpsResourceClient) GetPrivateEndpointConnection(ctx context.Context, resourceGroupName string, resourceName string, privateEndpointConnectionName string, options *IotDpsResourceClientGetPrivateEndpointConnectionOptions) (IotDpsResourceClientGetPrivateEndpointConnectionResponse, error) {
	req, err := client.getPrivateEndpointConnectionCreateRequest(ctx, resourceGroupName, resourceName, privateEndpointConnectionName, options)
	if err != nil {
		return IotDpsResourceClientGetPrivateEndpointConnectionResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return IotDpsResourceClientGetPrivateEndpointConnectionResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return IotDpsResourceClientGetPrivateEndpointConnectionResponse{}, runtime.NewResponseError(resp)
	}
	return client.getPrivateEndpointConnectionHandleResponse(resp)
}

// getPrivateEndpointConnectionCreateRequest creates the GetPrivateEndpointConnection request.
func (client *IotDpsResourceClient) getPrivateEndpointConnectionCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, privateEndpointConnectionName string, options *IotDpsResourceClientGetPrivateEndpointConnectionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/provisioningServices/{resourceName}/privateEndpointConnections/{privateEndpointConnectionName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if privateEndpointConnectionName == "" {
		return nil, errors.New("parameter privateEndpointConnectionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{privateEndpointConnectionName}", url.PathEscape(privateEndpointConnectionName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-02-05")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getPrivateEndpointConnectionHandleResponse handles the GetPrivateEndpointConnection response.
func (client *IotDpsResourceClient) getPrivateEndpointConnectionHandleResponse(resp *http.Response) (IotDpsResourceClientGetPrivateEndpointConnectionResponse, error) {
	result := IotDpsResourceClientGetPrivateEndpointConnectionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PrivateEndpointConnection); err != nil {
		return IotDpsResourceClientGetPrivateEndpointConnectionResponse{}, err
	}
	return result, nil
}

// GetPrivateLinkResources - Get the specified private link resource for the given provisioning service
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-02-05
// resourceGroupName - The name of the resource group that contains the provisioning service.
// resourceName - The name of the provisioning service.
// groupID - The name of the private link resource
// options - IotDpsResourceClientGetPrivateLinkResourcesOptions contains the optional parameters for the IotDpsResourceClient.GetPrivateLinkResources
// method.
func (client *IotDpsResourceClient) GetPrivateLinkResources(ctx context.Context, resourceGroupName string, resourceName string, groupID string, options *IotDpsResourceClientGetPrivateLinkResourcesOptions) (IotDpsResourceClientGetPrivateLinkResourcesResponse, error) {
	req, err := client.getPrivateLinkResourcesCreateRequest(ctx, resourceGroupName, resourceName, groupID, options)
	if err != nil {
		return IotDpsResourceClientGetPrivateLinkResourcesResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return IotDpsResourceClientGetPrivateLinkResourcesResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return IotDpsResourceClientGetPrivateLinkResourcesResponse{}, runtime.NewResponseError(resp)
	}
	return client.getPrivateLinkResourcesHandleResponse(resp)
}

// getPrivateLinkResourcesCreateRequest creates the GetPrivateLinkResources request.
func (client *IotDpsResourceClient) getPrivateLinkResourcesCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, groupID string, options *IotDpsResourceClientGetPrivateLinkResourcesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/provisioningServices/{resourceName}/privateLinkResources/{groupId}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if groupID == "" {
		return nil, errors.New("parameter groupID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{groupId}", url.PathEscape(groupID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-02-05")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getPrivateLinkResourcesHandleResponse handles the GetPrivateLinkResources response.
func (client *IotDpsResourceClient) getPrivateLinkResourcesHandleResponse(resp *http.Response) (IotDpsResourceClientGetPrivateLinkResourcesResponse, error) {
	result := IotDpsResourceClientGetPrivateLinkResourcesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.GroupIDInformation); err != nil {
		return IotDpsResourceClientGetPrivateLinkResourcesResponse{}, err
	}
	return result, nil
}

// NewListByResourceGroupPager - Get a list of all provisioning services in the given resource group.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-02-05
// resourceGroupName - Resource group identifier.
// options - IotDpsResourceClientListByResourceGroupOptions contains the optional parameters for the IotDpsResourceClient.ListByResourceGroup
// method.
func (client *IotDpsResourceClient) NewListByResourceGroupPager(resourceGroupName string, options *IotDpsResourceClientListByResourceGroupOptions) *runtime.Pager[IotDpsResourceClientListByResourceGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[IotDpsResourceClientListByResourceGroupResponse]{
		More: func(page IotDpsResourceClientListByResourceGroupResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *IotDpsResourceClientListByResourceGroupResponse) (IotDpsResourceClientListByResourceGroupResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listByResourceGroupCreateRequest(ctx, resourceGroupName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return IotDpsResourceClientListByResourceGroupResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return IotDpsResourceClientListByResourceGroupResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return IotDpsResourceClientListByResourceGroupResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByResourceGroupHandleResponse(resp)
		},
	})
}

// listByResourceGroupCreateRequest creates the ListByResourceGroup request.
func (client *IotDpsResourceClient) listByResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, options *IotDpsResourceClientListByResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/provisioningServices"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-02-05")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByResourceGroupHandleResponse handles the ListByResourceGroup response.
func (client *IotDpsResourceClient) listByResourceGroupHandleResponse(resp *http.Response) (IotDpsResourceClientListByResourceGroupResponse, error) {
	result := IotDpsResourceClientListByResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ProvisioningServiceDescriptionListResult); err != nil {
		return IotDpsResourceClientListByResourceGroupResponse{}, err
	}
	return result, nil
}

// NewListBySubscriptionPager - List all the provisioning services for a given subscription id.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-02-05
// options - IotDpsResourceClientListBySubscriptionOptions contains the optional parameters for the IotDpsResourceClient.ListBySubscription
// method.
func (client *IotDpsResourceClient) NewListBySubscriptionPager(options *IotDpsResourceClientListBySubscriptionOptions) *runtime.Pager[IotDpsResourceClientListBySubscriptionResponse] {
	return runtime.NewPager(runtime.PagingHandler[IotDpsResourceClientListBySubscriptionResponse]{
		More: func(page IotDpsResourceClientListBySubscriptionResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *IotDpsResourceClientListBySubscriptionResponse) (IotDpsResourceClientListBySubscriptionResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listBySubscriptionCreateRequest(ctx, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return IotDpsResourceClientListBySubscriptionResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return IotDpsResourceClientListBySubscriptionResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return IotDpsResourceClientListBySubscriptionResponse{}, runtime.NewResponseError(resp)
			}
			return client.listBySubscriptionHandleResponse(resp)
		},
	})
}

// listBySubscriptionCreateRequest creates the ListBySubscription request.
func (client *IotDpsResourceClient) listBySubscriptionCreateRequest(ctx context.Context, options *IotDpsResourceClientListBySubscriptionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Devices/provisioningServices"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-02-05")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listBySubscriptionHandleResponse handles the ListBySubscription response.
func (client *IotDpsResourceClient) listBySubscriptionHandleResponse(resp *http.Response) (IotDpsResourceClientListBySubscriptionResponse, error) {
	result := IotDpsResourceClientListBySubscriptionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ProvisioningServiceDescriptionListResult); err != nil {
		return IotDpsResourceClientListBySubscriptionResponse{}, err
	}
	return result, nil
}

// NewListKeysPager - List the primary and secondary keys for a provisioning service.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-02-05
// provisioningServiceName - The provisioning service name to get the shared access keys for.
// resourceGroupName - resource group name
// options - IotDpsResourceClientListKeysOptions contains the optional parameters for the IotDpsResourceClient.ListKeys method.
func (client *IotDpsResourceClient) NewListKeysPager(provisioningServiceName string, resourceGroupName string, options *IotDpsResourceClientListKeysOptions) *runtime.Pager[IotDpsResourceClientListKeysResponse] {
	return runtime.NewPager(runtime.PagingHandler[IotDpsResourceClientListKeysResponse]{
		More: func(page IotDpsResourceClientListKeysResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *IotDpsResourceClientListKeysResponse) (IotDpsResourceClientListKeysResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listKeysCreateRequest(ctx, provisioningServiceName, resourceGroupName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return IotDpsResourceClientListKeysResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return IotDpsResourceClientListKeysResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return IotDpsResourceClientListKeysResponse{}, runtime.NewResponseError(resp)
			}
			return client.listKeysHandleResponse(resp)
		},
	})
}

// listKeysCreateRequest creates the ListKeys request.
func (client *IotDpsResourceClient) listKeysCreateRequest(ctx context.Context, provisioningServiceName string, resourceGroupName string, options *IotDpsResourceClientListKeysOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/provisioningServices/{provisioningServiceName}/listkeys"
	if provisioningServiceName == "" {
		return nil, errors.New("parameter provisioningServiceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{provisioningServiceName}", url.PathEscape(provisioningServiceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-02-05")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listKeysHandleResponse handles the ListKeys response.
func (client *IotDpsResourceClient) listKeysHandleResponse(resp *http.Response) (IotDpsResourceClientListKeysResponse, error) {
	result := IotDpsResourceClientListKeysResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SharedAccessSignatureAuthorizationRuleListResult); err != nil {
		return IotDpsResourceClientListKeysResponse{}, err
	}
	return result, nil
}

// ListKeysForKeyName - List primary and secondary keys for a specific key name
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-02-05
// provisioningServiceName - Name of the provisioning service.
// keyName - Logical key name to get key-values for.
// resourceGroupName - The name of the resource group that contains the provisioning service.
// options - IotDpsResourceClientListKeysForKeyNameOptions contains the optional parameters for the IotDpsResourceClient.ListKeysForKeyName
// method.
func (client *IotDpsResourceClient) ListKeysForKeyName(ctx context.Context, provisioningServiceName string, keyName string, resourceGroupName string, options *IotDpsResourceClientListKeysForKeyNameOptions) (IotDpsResourceClientListKeysForKeyNameResponse, error) {
	req, err := client.listKeysForKeyNameCreateRequest(ctx, provisioningServiceName, keyName, resourceGroupName, options)
	if err != nil {
		return IotDpsResourceClientListKeysForKeyNameResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return IotDpsResourceClientListKeysForKeyNameResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return IotDpsResourceClientListKeysForKeyNameResponse{}, runtime.NewResponseError(resp)
	}
	return client.listKeysForKeyNameHandleResponse(resp)
}

// listKeysForKeyNameCreateRequest creates the ListKeysForKeyName request.
func (client *IotDpsResourceClient) listKeysForKeyNameCreateRequest(ctx context.Context, provisioningServiceName string, keyName string, resourceGroupName string, options *IotDpsResourceClientListKeysForKeyNameOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/provisioningServices/{provisioningServiceName}/keys/{keyName}/listkeys"
	if provisioningServiceName == "" {
		return nil, errors.New("parameter provisioningServiceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{provisioningServiceName}", url.PathEscape(provisioningServiceName))
	if keyName == "" {
		return nil, errors.New("parameter keyName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{keyName}", url.PathEscape(keyName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-02-05")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listKeysForKeyNameHandleResponse handles the ListKeysForKeyName response.
func (client *IotDpsResourceClient) listKeysForKeyNameHandleResponse(resp *http.Response) (IotDpsResourceClientListKeysForKeyNameResponse, error) {
	result := IotDpsResourceClientListKeysForKeyNameResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SharedAccessSignatureAuthorizationRuleAccessRightsDescription); err != nil {
		return IotDpsResourceClientListKeysForKeyNameResponse{}, err
	}
	return result, nil
}

// ListPrivateEndpointConnections - List private endpoint connection properties
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-02-05
// resourceGroupName - The name of the resource group that contains the provisioning service.
// resourceName - The name of the provisioning service.
// options - IotDpsResourceClientListPrivateEndpointConnectionsOptions contains the optional parameters for the IotDpsResourceClient.ListPrivateEndpointConnections
// method.
func (client *IotDpsResourceClient) ListPrivateEndpointConnections(ctx context.Context, resourceGroupName string, resourceName string, options *IotDpsResourceClientListPrivateEndpointConnectionsOptions) (IotDpsResourceClientListPrivateEndpointConnectionsResponse, error) {
	req, err := client.listPrivateEndpointConnectionsCreateRequest(ctx, resourceGroupName, resourceName, options)
	if err != nil {
		return IotDpsResourceClientListPrivateEndpointConnectionsResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return IotDpsResourceClientListPrivateEndpointConnectionsResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return IotDpsResourceClientListPrivateEndpointConnectionsResponse{}, runtime.NewResponseError(resp)
	}
	return client.listPrivateEndpointConnectionsHandleResponse(resp)
}

// listPrivateEndpointConnectionsCreateRequest creates the ListPrivateEndpointConnections request.
func (client *IotDpsResourceClient) listPrivateEndpointConnectionsCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, options *IotDpsResourceClientListPrivateEndpointConnectionsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/provisioningServices/{resourceName}/privateEndpointConnections"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-02-05")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listPrivateEndpointConnectionsHandleResponse handles the ListPrivateEndpointConnections response.
func (client *IotDpsResourceClient) listPrivateEndpointConnectionsHandleResponse(resp *http.Response) (IotDpsResourceClientListPrivateEndpointConnectionsResponse, error) {
	result := IotDpsResourceClientListPrivateEndpointConnectionsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PrivateEndpointConnectionArray); err != nil {
		return IotDpsResourceClientListPrivateEndpointConnectionsResponse{}, err
	}
	return result, nil
}

// ListPrivateLinkResources - List private link resources for the given provisioning service
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-02-05
// resourceGroupName - The name of the resource group that contains the provisioning service.
// resourceName - The name of the provisioning service.
// options - IotDpsResourceClientListPrivateLinkResourcesOptions contains the optional parameters for the IotDpsResourceClient.ListPrivateLinkResources
// method.
func (client *IotDpsResourceClient) ListPrivateLinkResources(ctx context.Context, resourceGroupName string, resourceName string, options *IotDpsResourceClientListPrivateLinkResourcesOptions) (IotDpsResourceClientListPrivateLinkResourcesResponse, error) {
	req, err := client.listPrivateLinkResourcesCreateRequest(ctx, resourceGroupName, resourceName, options)
	if err != nil {
		return IotDpsResourceClientListPrivateLinkResourcesResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return IotDpsResourceClientListPrivateLinkResourcesResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return IotDpsResourceClientListPrivateLinkResourcesResponse{}, runtime.NewResponseError(resp)
	}
	return client.listPrivateLinkResourcesHandleResponse(resp)
}

// listPrivateLinkResourcesCreateRequest creates the ListPrivateLinkResources request.
func (client *IotDpsResourceClient) listPrivateLinkResourcesCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, options *IotDpsResourceClientListPrivateLinkResourcesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/provisioningServices/{resourceName}/privateLinkResources"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-02-05")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listPrivateLinkResourcesHandleResponse handles the ListPrivateLinkResources response.
func (client *IotDpsResourceClient) listPrivateLinkResourcesHandleResponse(resp *http.Response) (IotDpsResourceClientListPrivateLinkResourcesResponse, error) {
	result := IotDpsResourceClientListPrivateLinkResourcesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PrivateLinkResources); err != nil {
		return IotDpsResourceClientListPrivateLinkResourcesResponse{}, err
	}
	return result, nil
}

// NewListValidSKUsPager - Gets the list of valid SKUs and tiers for a provisioning service.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-02-05
// provisioningServiceName - Name of provisioning service.
// resourceGroupName - Name of resource group.
// options - IotDpsResourceClientListValidSKUsOptions contains the optional parameters for the IotDpsResourceClient.ListValidSKUs
// method.
func (client *IotDpsResourceClient) NewListValidSKUsPager(provisioningServiceName string, resourceGroupName string, options *IotDpsResourceClientListValidSKUsOptions) *runtime.Pager[IotDpsResourceClientListValidSKUsResponse] {
	return runtime.NewPager(runtime.PagingHandler[IotDpsResourceClientListValidSKUsResponse]{
		More: func(page IotDpsResourceClientListValidSKUsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *IotDpsResourceClientListValidSKUsResponse) (IotDpsResourceClientListValidSKUsResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listValidSKUsCreateRequest(ctx, provisioningServiceName, resourceGroupName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return IotDpsResourceClientListValidSKUsResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return IotDpsResourceClientListValidSKUsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return IotDpsResourceClientListValidSKUsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listValidSKUsHandleResponse(resp)
		},
	})
}

// listValidSKUsCreateRequest creates the ListValidSKUs request.
func (client *IotDpsResourceClient) listValidSKUsCreateRequest(ctx context.Context, provisioningServiceName string, resourceGroupName string, options *IotDpsResourceClientListValidSKUsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/provisioningServices/{provisioningServiceName}/skus"
	if provisioningServiceName == "" {
		return nil, errors.New("parameter provisioningServiceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{provisioningServiceName}", url.PathEscape(provisioningServiceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-02-05")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listValidSKUsHandleResponse handles the ListValidSKUs response.
func (client *IotDpsResourceClient) listValidSKUsHandleResponse(resp *http.Response) (IotDpsResourceClientListValidSKUsResponse, error) {
	result := IotDpsResourceClientListValidSKUsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.IotDpsSKUDefinitionListResult); err != nil {
		return IotDpsResourceClientListValidSKUsResponse{}, err
	}
	return result, nil
}

// BeginUpdate - Update an existing provisioning service's tags. to update other fields use the CreateOrUpdate method
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-02-05
// resourceGroupName - Resource group identifier.
// provisioningServiceName - Name of provisioning service to create or update.
// provisioningServiceTags - Updated tag information to set into the provisioning service instance.
// options - IotDpsResourceClientBeginUpdateOptions contains the optional parameters for the IotDpsResourceClient.BeginUpdate
// method.
func (client *IotDpsResourceClient) BeginUpdate(ctx context.Context, resourceGroupName string, provisioningServiceName string, provisioningServiceTags TagsResource, options *IotDpsResourceClientBeginUpdateOptions) (*runtime.Poller[IotDpsResourceClientUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.update(ctx, resourceGroupName, provisioningServiceName, provisioningServiceTags, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[IotDpsResourceClientUpdateResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[IotDpsResourceClientUpdateResponse](options.ResumeToken, client.pl, nil)
	}
}

// Update - Update an existing provisioning service's tags. to update other fields use the CreateOrUpdate method
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-02-05
func (client *IotDpsResourceClient) update(ctx context.Context, resourceGroupName string, provisioningServiceName string, provisioningServiceTags TagsResource, options *IotDpsResourceClientBeginUpdateOptions) (*http.Response, error) {
	req, err := client.updateCreateRequest(ctx, resourceGroupName, provisioningServiceName, provisioningServiceTags, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// updateCreateRequest creates the Update request.
func (client *IotDpsResourceClient) updateCreateRequest(ctx context.Context, resourceGroupName string, provisioningServiceName string, provisioningServiceTags TagsResource, options *IotDpsResourceClientBeginUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/provisioningServices/{provisioningServiceName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if provisioningServiceName == "" {
		return nil, errors.New("parameter provisioningServiceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{provisioningServiceName}", url.PathEscape(provisioningServiceName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-02-05")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, provisioningServiceTags)
}
