//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armazurearcdata

import "time"

// ActiveDirectoryConnectorDNSDetails - DNS server details
type ActiveDirectoryConnectorDNSDetails struct {
	// REQUIRED; List of Active Directory DNS server IP addresses.
	NameserverIPAddresses []*string `json:"nameserverIPAddresses,omitempty"`

	// DNS domain name for which DNS lookups should be forwarded to the Active Directory DNS servers.
	DomainName *string `json:"domainName,omitempty"`

	// Flag indicating whether to prefer Kubernetes DNS server response over AD DNS server response for IP address lookups.
	PreferK8SDNSForPtrLookups *bool `json:"preferK8sDnsForPtrLookups,omitempty"`

	// Replica count for DNS proxy service. Default value is 1.
	Replicas *int64 `json:"replicas,omitempty"`
}

// ActiveDirectoryConnectorDomainDetails - Active Directory domain details
type ActiveDirectoryConnectorDomainDetails struct {
	// REQUIRED; null
	DomainControllers *ActiveDirectoryDomainControllers `json:"domainControllers,omitempty"`

	// REQUIRED; Name (uppercase) of the Active Directory domain that this AD connector will be associated with.
	Realm *string `json:"realm,omitempty"`

	// NETBIOS name of the Active Directory domain.
	NetbiosDomainName *string `json:"netbiosDomainName,omitempty"`

	// The distinguished name of the Active Directory Organizational Unit.
	OuDistinguishedName *string `json:"ouDistinguishedName,omitempty"`

	// The service account provisioning mode for this Active Directory connector.
	ServiceAccountProvisioning *AccountProvisioningMode `json:"serviceAccountProvisioning,omitempty"`
}

// ActiveDirectoryConnectorListResult - A list of active directory connectors
type ActiveDirectoryConnectorListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*ActiveDirectoryConnectorResource `json:"value,omitempty" azure:"ro"`
}

// ActiveDirectoryConnectorProperties - The properties of an Active Directory connector resource
type ActiveDirectoryConnectorProperties struct {
	// REQUIRED; null
	Spec *ActiveDirectoryConnectorSpec `json:"spec,omitempty"`

	// Username and password for domain service account authentication.
	DomainServiceAccountLoginInformation *BasicLoginInformation `json:"domainServiceAccountLoginInformation,omitempty"`

	// null
	Status *ActiveDirectoryConnectorStatus `json:"status,omitempty"`

	// READ-ONLY; The provisioning state of the Active Directory connector resource.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// ActiveDirectoryConnectorResource - Active directory connector resource
type ActiveDirectoryConnectorResource struct {
	// REQUIRED; null
	Properties *ActiveDirectoryConnectorProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ActiveDirectoryConnectorSpec - The specifications of the AD Kubernetes resource.
type ActiveDirectoryConnectorSpec struct {
	// REQUIRED; null
	ActiveDirectory *ActiveDirectoryConnectorDomainDetails `json:"activeDirectory,omitempty"`

	// REQUIRED; null
	DNS *ActiveDirectoryConnectorDNSDetails `json:"dns,omitempty"`
}

// ActiveDirectoryConnectorStatus - The status of the Kubernetes custom resource.
type ActiveDirectoryConnectorStatus struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// The time that the custom resource was last updated.
	LastUpdateTime *string `json:"lastUpdateTime,omitempty"`

	// The version of the replicaSet associated with the AD connector custom resource.
	ObservedGeneration *int64 `json:"observedGeneration,omitempty"`

	// The state of the AD connector custom resource.
	State *string `json:"state,omitempty"`
}

// ActiveDirectoryConnectorsClientBeginCreateOptions contains the optional parameters for the ActiveDirectoryConnectorsClient.BeginCreate
// method.
type ActiveDirectoryConnectorsClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ActiveDirectoryConnectorsClientBeginDeleteOptions contains the optional parameters for the ActiveDirectoryConnectorsClient.BeginDelete
// method.
type ActiveDirectoryConnectorsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ActiveDirectoryConnectorsClientGetOptions contains the optional parameters for the ActiveDirectoryConnectorsClient.Get
// method.
type ActiveDirectoryConnectorsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ActiveDirectoryConnectorsClientListOptions contains the optional parameters for the ActiveDirectoryConnectorsClient.List
// method.
type ActiveDirectoryConnectorsClientListOptions struct {
	// placeholder for future optional parameters
}

// ActiveDirectoryDomainController - Information about a domain controller in the AD domain.
type ActiveDirectoryDomainController struct {
	// REQUIRED; Fully-qualified domain name of a domain controller in the AD domain.
	Hostname *string `json:"hostname,omitempty"`
}

// ActiveDirectoryDomainControllers - Details about the Active Directory domain controllers associated with this AD connector
// instance
type ActiveDirectoryDomainControllers struct {
	// Information about the Primary Domain Controller (PDC) in the AD domain.
	PrimaryDomainController *ActiveDirectoryDomainController `json:"primaryDomainController,omitempty"`

	// null
	SecondaryDomainControllers []*ActiveDirectoryDomainController `json:"secondaryDomainControllers,omitempty"`
}

// ActiveDirectoryInformation - Active Directory information that related to the resource.
type ActiveDirectoryInformation struct {
	// Keytab information that is used for the Sql Managed Instance when Active Directory authentication is used.
	KeytabInformation *KeytabInformation `json:"keytabInformation,omitempty"`
}

// BasicLoginInformation - Username and password for basic login authentication.
type BasicLoginInformation struct {
	// Login password.
	Password *string `json:"password,omitempty"`

	// Login username.
	Username *string `json:"username,omitempty"`
}

// CommonSKU - The resource model definition representing SKU for ARM resources
type CommonSKU struct {
	// REQUIRED; The name of the SKU. It is typically a letter+number code
	Name *string `json:"name,omitempty"`

	// If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the
	// resource this may be omitted.
	Capacity *int32 `json:"capacity,omitempty"`

	// Whether dev/test is enabled. When the dev field is set to true, the resource is used for dev/test purpose.
	Dev *bool `json:"dev,omitempty"`

	// If the service has different generations of hardware, for the same SKU, then that can be captured here.
	Family *string `json:"family,omitempty"`

	// The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code.
	Size *string `json:"size,omitempty"`
}

// DataControllerProperties - The data controller properties.
type DataControllerProperties struct {
	// Deprecated. Azure Arc Data Services data controller no longer expose any endpoint. All traffic are exposed through Kubernetes
	// native API.
	BasicLoginInformation *BasicLoginInformation `json:"basicLoginInformation,omitempty"`

	// If a CustomLocation is provided, this contains the ARM id of the connected cluster the custom location belongs to.
	ClusterID *string `json:"clusterId,omitempty"`

	// If a CustomLocation is provided, this contains the ARM id of the extension the custom location belongs to.
	ExtensionID *string `json:"extensionId,omitempty"`

	// The infrastructure the data controller is running on.
	Infrastructure *Infrastructure `json:"infrastructure,omitempty"`

	// The raw kubernetes information
	K8SRaw interface{} `json:"k8sRaw,omitempty"`

	// Last uploaded date from Kubernetes cluster. Defaults to current date time
	LastUploadedDate *time.Time `json:"lastUploadedDate,omitempty"`

	// Log analytics workspace id and primary key
	LogAnalyticsWorkspaceConfig *LogAnalyticsWorkspaceConfig `json:"logAnalyticsWorkspaceConfig,omitempty"`

	// Login credential for logs dashboard on the Kubernetes cluster.
	LogsDashboardCredential *BasicLoginInformation `json:"logsDashboardCredential,omitempty"`

	// Login credential for metrics dashboard on the Kubernetes cluster.
	MetricsDashboardCredential *BasicLoginInformation `json:"metricsDashboardCredential,omitempty"`

	// Properties from the Kubernetes data controller
	OnPremiseProperty *OnPremiseProperty `json:"onPremiseProperty,omitempty"`

	// Deprecated. Service principal is deprecated in favor of Arc Kubernetes service extension managed identity.
	UploadServicePrincipal *UploadServicePrincipal `json:"uploadServicePrincipal,omitempty"`

	// Properties on upload watermark. Mostly timestamp for each upload data type
	UploadWatermark *UploadWatermark `json:"uploadWatermark,omitempty"`

	// READ-ONLY; The provisioning state of the Arc Data Controller resource.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// DataControllerResource - Data controller resource
type DataControllerResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// REQUIRED; The data controller's properties
	Properties *DataControllerProperties `json:"properties,omitempty"`

	// The extendedLocation of the resource.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DataControllerUpdate - Used for updating a data controller resource.
type DataControllerUpdate struct {
	// The data controller's properties
	Properties *DataControllerProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// DataControllersClientBeginDeleteDataControllerOptions contains the optional parameters for the DataControllersClient.BeginDeleteDataController
// method.
type DataControllersClientBeginDeleteDataControllerOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DataControllersClientBeginPatchDataControllerOptions contains the optional parameters for the DataControllersClient.BeginPatchDataController
// method.
type DataControllersClientBeginPatchDataControllerOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DataControllersClientBeginPutDataControllerOptions contains the optional parameters for the DataControllersClient.BeginPutDataController
// method.
type DataControllersClientBeginPutDataControllerOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DataControllersClientGetDataControllerOptions contains the optional parameters for the DataControllersClient.GetDataController
// method.
type DataControllersClientGetDataControllerOptions struct {
	// placeholder for future optional parameters
}

// DataControllersClientListInGroupOptions contains the optional parameters for the DataControllersClient.ListInGroup method.
type DataControllersClientListInGroupOptions struct {
	// placeholder for future optional parameters
}

// DataControllersClientListInSubscriptionOptions contains the optional parameters for the DataControllersClient.ListInSubscription
// method.
type DataControllersClientListInSubscriptionOptions struct {
	// placeholder for future optional parameters
}

// ErrorResponse - An error response from the Azure Data on Azure Arc service.
type ErrorResponse struct {
	// null
	Error *ErrorResponseBody `json:"error,omitempty"`
}

// ErrorResponseBody - An error response from the Batch service.
type ErrorResponseBody struct {
	// An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`

	// A list of additional details about the error.
	Details []*ErrorResponseBody `json:"details,omitempty"`

	// A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`

	// The target of the particular error. For example, the name of the property in error.
	Target *string `json:"target,omitempty"`
}

// ExtendedLocation - The complex type of the extended location.
type ExtendedLocation struct {
	// The name of the extended location.
	Name *string `json:"name,omitempty"`

	// The type of the extended location.
	Type *ExtendedLocationTypes `json:"type,omitempty"`
}

// K8SResourceRequirements - The kubernetes resource limits and requests used to restrict or reserve resource usage.
type K8SResourceRequirements struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Limits for a kubernetes resource type (e.g 'cpu', 'memory'). The 'cpu' request must be less than or equal to 'cpu' limit.
	// Default 'cpu' is 2, minimum is 1. Default 'memory' is '4Gi', minimum is '2Gi.
	// If sku.tier is GeneralPurpose, maximum 'cpu' is 24 and maximum 'memory' is '128Gi'.
	Limits map[string]*string `json:"limits,omitempty"`

	// Requests for a kubernetes resource type (e.g 'cpu', 'memory'). The 'cpu' request must be less than or equal to 'cpu' limit.
	// Default 'cpu' is 2, minimum is 1. Default 'memory' is '4Gi', minimum is
	// '2Gi. If sku.tier is GeneralPurpose, maximum 'cpu' is 24 and maximum 'memory' is '128Gi'.
	Requests map[string]*string `json:"requests,omitempty"`
}

// K8SScheduling - The kubernetes scheduling information.
type K8SScheduling struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// The kubernetes scheduling options. It describes restrictions used to help Kubernetes select appropriate nodes to host the
	// database service
	Default *K8SSchedulingOptions `json:"default,omitempty"`
}

// K8SSchedulingOptions - The kubernetes scheduling options. It describes restrictions used to help Kubernetes select appropriate
// nodes to host the database service
type K8SSchedulingOptions struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// The kubernetes resource limits and requests used to restrict or reserve resource usage.
	Resources *K8SResourceRequirements `json:"resources,omitempty"`
}

// KeytabInformation - Keytab used for authenticate with Active Directory.
type KeytabInformation struct {
	// A base64-encoded keytab.
	Keytab *string `json:"keytab,omitempty"`
}

// LogAnalyticsWorkspaceConfig - Log analytics workspace id and primary key
type LogAnalyticsWorkspaceConfig struct {
	// Primary key of the workspace
	PrimaryKey *string `json:"primaryKey,omitempty"`

	// Azure Log Analytics workspace ID
	WorkspaceID *string `json:"workspaceId,omitempty"`
}

// OnPremiseProperty - Properties from the Kubernetes data controller
type OnPremiseProperty struct {
	// REQUIRED; A globally unique ID identifying the associated Kubernetes cluster
	ID *string `json:"id,omitempty"`

	// REQUIRED; Certificate that contains the Kubernetes cluster public key used to verify signing
	PublicSigningKey *string `json:"publicSigningKey,omitempty"`

	// Unique thumbprint returned to customer to verify the certificate being uploaded
	SigningCertificateThumbprint *string `json:"signingCertificateThumbprint,omitempty"`
}

// Operation - Azure Data Services on Azure Arc operation definition.
type Operation struct {
	// REQUIRED; The localized display information for this particular operation / action.
	Display *OperationDisplay `json:"display,omitempty"`

	// REQUIRED; Indicates whether the operation is a data action
	IsDataAction *bool `json:"isDataAction,omitempty"`

	// REQUIRED; The name of the operation being performed on this particular object.
	Name *string `json:"name,omitempty"`

	// READ-ONLY; The intended executor of the operation.
	Origin *OperationOrigin `json:"origin,omitempty" azure:"ro"`

	// READ-ONLY; Additional descriptions for the operation.
	Properties map[string]interface{} `json:"properties,omitempty" azure:"ro"`
}

// OperationDisplay - Display metadata associated with the operation.
type OperationDisplay struct {
	// REQUIRED; The localized friendly description for the operation.
	Description *string `json:"description,omitempty"`

	// REQUIRED; The localized friendly name for the operation.
	Operation *string `json:"operation,omitempty"`

	// REQUIRED; The localized friendly form of the resource provider name.
	Provider *string `json:"provider,omitempty"`

	// REQUIRED; The localized friendly form of the resource type related to this action/operation.
	Resource *string `json:"resource,omitempty"`
}

// OperationListResult - Result of the request to list Azure Data Services on Azure Arc operations.
type OperationListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*Operation `json:"value,omitempty" azure:"ro"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// PageOfDataControllerResource - A list of data controllers.
type PageOfDataControllerResource struct {
	// Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`

	// Array of results.
	Value []*DataControllerResource `json:"value,omitempty"`
}

// PostgresInstance - A Postgres Instance.
type PostgresInstance struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// REQUIRED; null
	Properties *PostgresInstanceProperties `json:"properties,omitempty"`

	// The extendedLocation of the resource.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`

	// Resource sku.
	SKU *PostgresInstanceSKU `json:"sku,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PostgresInstanceListResult - A list of PostgresInstance.
type PostgresInstanceListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*PostgresInstance `json:"value,omitempty" azure:"ro"`
}

// PostgresInstanceProperties - Postgres Instance properties.
type PostgresInstanceProperties struct {
	// The instance admin
	Admin *string `json:"admin,omitempty"`

	// Username and password for basic authentication.
	BasicLoginInformation *BasicLoginInformation `json:"basicLoginInformation,omitempty"`

	// The data controller id
	DataControllerID *string `json:"dataControllerId,omitempty"`

	// The raw kubernetes information
	K8SRaw interface{} `json:"k8sRaw,omitempty"`

	// Last uploaded date from Kubernetes cluster. Defaults to current date time
	LastUploadedDate *time.Time `json:"lastUploadedDate,omitempty"`

	// READ-ONLY; The provisioning state of the Azure Arc-enabled PostgreSQL instance.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// PostgresInstanceSKU - The resource model definition representing SKU for Azure Database for PostgresSQL - Azure Arc
type PostgresInstanceSKU struct {
	// REQUIRED; The name of the SKU. It is typically a letter+number code
	Name *string `json:"name,omitempty"`

	// If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the
	// resource this may be omitted.
	Capacity *int32 `json:"capacity,omitempty"`

	// Whether dev/test is enabled. When the dev field is set to true, the resource is used for dev/test purpose.
	Dev *bool `json:"dev,omitempty"`

	// If the service has different generations of hardware, for the same SKU, then that can be captured here.
	Family *string `json:"family,omitempty"`

	// The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code.
	Size *string `json:"size,omitempty"`

	// This field is required to be implemented by the Resource Provider if the service has more than one tier.
	Tier *string `json:"tier,omitempty"`
}

// PostgresInstanceUpdate - An update to a Postgres Instance.
type PostgresInstanceUpdate struct {
	// Postgres Instance properties.
	Properties *PostgresInstanceProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// PostgresInstancesClientBeginCreateOptions contains the optional parameters for the PostgresInstancesClient.BeginCreate
// method.
type PostgresInstancesClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PostgresInstancesClientBeginDeleteOptions contains the optional parameters for the PostgresInstancesClient.BeginDelete
// method.
type PostgresInstancesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PostgresInstancesClientGetOptions contains the optional parameters for the PostgresInstancesClient.Get method.
type PostgresInstancesClientGetOptions struct {
	// placeholder for future optional parameters
}

// PostgresInstancesClientListByResourceGroupOptions contains the optional parameters for the PostgresInstancesClient.ListByResourceGroup
// method.
type PostgresInstancesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// PostgresInstancesClientListOptions contains the optional parameters for the PostgresInstancesClient.List method.
type PostgresInstancesClientListOptions struct {
	// placeholder for future optional parameters
}

// PostgresInstancesClientUpdateOptions contains the optional parameters for the PostgresInstancesClient.Update method.
type PostgresInstancesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ProxyResource - The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a
// location
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SQLManagedInstance - A SqlManagedInstance.
type SQLManagedInstance struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// REQUIRED; null
	Properties *SQLManagedInstanceProperties `json:"properties,omitempty"`

	// The extendedLocation of the resource.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`

	// Resource sku.
	SKU *SQLManagedInstanceSKU `json:"sku,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SQLManagedInstanceK8SRaw - The raw kubernetes information.
type SQLManagedInstanceK8SRaw struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// The kubernetes spec information.
	Spec *SQLManagedInstanceK8SSpec `json:"spec,omitempty"`
}

// SQLManagedInstanceK8SSpec - The kubernetes spec information.
type SQLManagedInstanceK8SSpec struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// This option specifies the number of SQL Managed Instance replicas that will be deployed in your Kubernetes cluster for
	// high availability purposes. If sku.tier is BusinessCritical, allowed values are
	// '2' or '3' with default of '3'. If sku.tier is GeneralPurpose, replicas must be '1'.
	Replicas *int32 `json:"replicas,omitempty"`

	// The kubernetes scheduling information.
	Scheduling *K8SScheduling `json:"scheduling,omitempty"`
}

// SQLManagedInstanceListResult - A list of SqlManagedInstance.
type SQLManagedInstanceListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*SQLManagedInstance `json:"value,omitempty" azure:"ro"`
}

// SQLManagedInstanceProperties - Properties of sqlManagedInstance.
type SQLManagedInstanceProperties struct {
	// Active Directory information related to this SQL Managed Instance.
	ActiveDirectoryInformation *ActiveDirectoryInformation `json:"activeDirectoryInformation,omitempty"`

	// The instance admin user
	Admin *string `json:"admin,omitempty"`

	// Username and password for basic authentication.
	BasicLoginInformation *BasicLoginInformation `json:"basicLoginInformation,omitempty"`

	// If a CustomLocation is provided, this contains the ARM id of the connected cluster the custom location belongs to.
	ClusterID *string `json:"clusterId,omitempty"`

	// null
	DataControllerID *string `json:"dataControllerId,omitempty"`

	// The instance end time
	EndTime *string `json:"endTime,omitempty"`

	// If a CustomLocation is provided, this contains the ARM id of the extension the custom location belongs to.
	ExtensionID *string `json:"extensionId,omitempty"`

	// The raw kubernetes information
	K8SRaw *SQLManagedInstanceK8SRaw `json:"k8sRaw,omitempty"`

	// Last uploaded date from Kubernetes cluster. Defaults to current date time
	LastUploadedDate *time.Time `json:"lastUploadedDate,omitempty"`

	// The license type to apply for this managed instance.
	LicenseType *ArcSQLManagedInstanceLicenseType `json:"licenseType,omitempty"`

	// The instance start time
	StartTime *string `json:"startTime,omitempty"`

	// READ-ONLY; The provisioning state of the Arc-enabled SQL Managed Instance resource.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// SQLManagedInstanceSKU - The resource model definition representing SKU for Azure Managed Instance - Azure Arc
type SQLManagedInstanceSKU struct {
	// REQUIRED; The name of the SKU.
	Name *string `json:"name,omitempty"`

	// The SKU capacity
	Capacity *int32 `json:"capacity,omitempty"`

	// Whether dev/test is enabled. When the dev field is set to true, the resource is used for dev/test purpose.
	Dev *bool `json:"dev,omitempty"`

	// The SKU family
	Family *string `json:"family,omitempty"`

	// The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code.
	Size *string `json:"size,omitempty"`

	// The pricing tier for the instance.
	Tier *SQLManagedInstanceSKUTier `json:"tier,omitempty"`
}

// SQLManagedInstanceUpdate - An update to a SQL Managed Instance.
type SQLManagedInstanceUpdate struct {
	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// SQLManagedInstancesClientBeginCreateOptions contains the optional parameters for the SQLManagedInstancesClient.BeginCreate
// method.
type SQLManagedInstancesClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SQLManagedInstancesClientBeginDeleteOptions contains the optional parameters for the SQLManagedInstancesClient.BeginDelete
// method.
type SQLManagedInstancesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SQLManagedInstancesClientGetOptions contains the optional parameters for the SQLManagedInstancesClient.Get method.
type SQLManagedInstancesClientGetOptions struct {
	// placeholder for future optional parameters
}

// SQLManagedInstancesClientListByResourceGroupOptions contains the optional parameters for the SQLManagedInstancesClient.ListByResourceGroup
// method.
type SQLManagedInstancesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// SQLManagedInstancesClientListOptions contains the optional parameters for the SQLManagedInstancesClient.List method.
type SQLManagedInstancesClientListOptions struct {
	// placeholder for future optional parameters
}

// SQLManagedInstancesClientUpdateOptions contains the optional parameters for the SQLManagedInstancesClient.Update method.
type SQLManagedInstancesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// SQLServerInstance - A SqlServerInstance.
type SQLServerInstance struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// null
	Properties *SQLServerInstanceProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SQLServerInstanceListResult - A list of SqlServerInstance.
type SQLServerInstanceListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*SQLServerInstance `json:"value,omitempty" azure:"ro"`
}

// SQLServerInstanceProperties - Properties of SqlServerInstance.
type SQLServerInstanceProperties struct {
	// REQUIRED; ARM Resource id of the container resource (Azure Arc for Servers).
	ContainerResourceID *string `json:"containerResourceId,omitempty"`

	// REQUIRED; The cloud connectivity status.
	Status *ConnectionStatus `json:"status,omitempty"`

	// Status of Azure Defender.
	AzureDefenderStatus *DefenderStatus `json:"azureDefenderStatus,omitempty"`

	// Timestamp of last Azure Defender status update.
	AzureDefenderStatusLastUpdated *time.Time `json:"azureDefenderStatusLastUpdated,omitempty"`

	// SQL Server collation.
	Collation *string `json:"collation,omitempty"`

	// SQL Server current version.
	CurrentVersion *string `json:"currentVersion,omitempty"`

	// SQL Server edition.
	Edition *EditionType `json:"edition,omitempty"`

	// Type of host for Azure Arc SQL Server
	HostType *HostType `json:"hostType,omitempty"`

	// SQL Server instance name.
	InstanceName *string `json:"instanceName,omitempty"`

	// SQL Server license type.
	LicenseType *ArcSQLServerLicenseType `json:"licenseType,omitempty"`

	// SQL Server update level.
	PatchLevel *string `json:"patchLevel,omitempty"`

	// SQL Server product ID.
	ProductID *string `json:"productId,omitempty"`

	// Dynamic TCP ports used by SQL Server.
	TCPDynamicPorts *string `json:"tcpDynamicPorts,omitempty"`

	// Static TCP ports used by SQL Server.
	TCPStaticPorts *string `json:"tcpStaticPorts,omitempty"`

	// The number of logical processors used by the SQL Server instance.
	VCore *string `json:"vCore,omitempty"`

	// SQL Server version.
	Version *SQLVersion `json:"version,omitempty"`

	// READ-ONLY; The time when the resource was created.
	CreateTime *string `json:"createTime,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the Arc-enabled SQL Server resource.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// SQLServerInstanceUpdate - An update to a SQL Server Instance.
type SQLServerInstanceUpdate struct {
	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// SQLServerInstancesClientBeginCreateOptions contains the optional parameters for the SQLServerInstancesClient.BeginCreate
// method.
type SQLServerInstancesClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SQLServerInstancesClientBeginDeleteOptions contains the optional parameters for the SQLServerInstancesClient.BeginDelete
// method.
type SQLServerInstancesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SQLServerInstancesClientGetOptions contains the optional parameters for the SQLServerInstancesClient.Get method.
type SQLServerInstancesClientGetOptions struct {
	// placeholder for future optional parameters
}

// SQLServerInstancesClientListByResourceGroupOptions contains the optional parameters for the SQLServerInstancesClient.ListByResourceGroup
// method.
type SQLServerInstancesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// SQLServerInstancesClientListOptions contains the optional parameters for the SQLServerInstancesClient.List method.
type SQLServerInstancesClientListOptions struct {
	// placeholder for future optional parameters
}

// SQLServerInstancesClientUpdateOptions contains the optional parameters for the SQLServerInstancesClient.Update method.
type SQLServerInstancesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// TrackedResource - The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags'
// and a 'location'
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// UploadServicePrincipal - Service principal for uploading billing, metrics and logs.
type UploadServicePrincipal struct {
	// Authority for the service principal. Example: https://login.microsoftonline.com/
	Authority *string `json:"authority,omitempty"`

	// Client ID of the service principal for uploading data.
	ClientID *string `json:"clientId,omitempty"`

	// Secret of the service principal
	ClientSecret *string `json:"clientSecret,omitempty"`

	// Tenant ID of the service principal.
	TenantID *string `json:"tenantId,omitempty"`
}

// UploadWatermark - Properties on upload watermark. Mostly timestamp for each upload data type
type UploadWatermark struct {
	// Last uploaded date for logs from kubernetes cluster. Defaults to current date time
	Logs *time.Time `json:"logs,omitempty"`

	// Last uploaded date for metrics from kubernetes cluster. Defaults to current date time
	Metrics *time.Time `json:"metrics,omitempty"`

	// Last uploaded date for usages from kubernetes cluster. Defaults to current date time
	Usages *time.Time `json:"usages,omitempty"`
}
