<!--
%CopyrightBegin%

SPDX-License-Identifier: Apache-2.0

Copyright Ericsson AB 2023-2025. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

%CopyrightEnd%
-->
# Reltool Release Notes

This document describes the changes made to the Reltool system from version to
version. The intention of this document is to list all incompatibilities as well
as all enhancements and bugfixes for every release of Reltool. Each release of
Reltool thus constitutes one section in this document. The title of each section
is the version number of Reltool.

## Reltool 1.0.2

### Improvements and New Features

- The license and copyright header has changed format to include an `SPDX-License-Identifier`. At the same time, most files have been updated to follow a uniform standard for license headers.

  Own Id: OTP-19575 Aux Id: [PR-9670]

[PR-9670]: https://github.com/erlang/otp/pull/9670

## Reltool 1.0.1

### Fixed Bugs and Malfunctions

- The dependencies for this application are now listed in the app file.

  Own Id: OTP-18831 Aux Id: [PR-7441]

[PR-7441]: https://github.com/erlang/otp/pull/7441

### Improvements and New Features

- The documentation has been migrated to use Markdown and ExDoc.

  Own Id: OTP-18955 Aux Id: [PR-8026]

[PR-8026]: https://github.com/erlang/otp/pull/8026

## Reltool 1.0

### Improvements and New Features

- Add possibility to strip specific chunks from beam files included in a
  release. Before this change it was only possible to strip all chunks from the
  beam files.

  Own Id: OTP-18230 Aux Id: PR-5936

- Runtime dependencies have been updated.

  Own Id: OTP-18350

- Support for the experimental code archives feature has been removed from
  `reltool`.

  \*** POTENTIAL INCOMPATIBILITY \***

  Own Id: OTP-18488 Aux Id: PR-6836

- The implementation has been fixed to use `proc_lib:init_fail/2,3` where
  appropriate, instead of `proc_lib:init_ack/1,2`.

  \*** POTENTIAL INCOMPATIBILITY \***

  Own Id: OTP-18490 Aux Id: OTP-18471, GH-6339, PR-6843

## Reltool 0.9.1.1

### Fixed Bugs and Malfunctions

* Fixed runtime dependencies.

  Own Id: OTP-19064

## Reltool 0.9.1

### Fixed Bugs and Malfunctions

- Fixed a bug that would cause analysis to crash.

  Own Id: OTP-18372 Aux Id: GH-6580

## Reltool 0.9

### Improvements and New Features

- Recognize new key 'optional_applications' in application resource files.

  Own Id: OTP-17189 Aux Id: PR-2675

- Removed timestamps from files generated by `sasl` and `reltool` to enable
  deterministic builds.

  Own Id: OTP-17292 Aux Id: PR-4685, PR-4684

## Reltool 0.8

### Improvements and New Features

- A new element, `Opts`, can now be included in a `rel` tuple in the reltool
  release specific configuration format: \{rel, Name, Vsn, RelApps, Opts\}.

  This supports the use of
  `{rel, Name, Vsn, RelApps, [{load_dot_erlang, false}]}` to prevent the boot
  script from running the `.erlang` file.

  The incompatibilities are as follows:

  \* The return from `reltool:get_config/1` and `reltool:get_config/3` includes
  the new `rel` tuple for all releases where the `load_dot_erlang` option is set
  to `false`.  
  \* The return from `reltool:get_config/3` includes the new `rel` tuple for ALL
  releases if the `InclDefs` parameter is set to `true`.

  \*** POTENTIAL INCOMPATIBILITY \***

  Own Id: OTP-15571

## Reltool 0.7.8

### Fixed Bugs and Malfunctions

- Reltool would earlier erroneously split paths like `"c:\foo"` into
  `["c","\foo"]` when reading the `$ERL_LIBS` variable on windows. This is now
  corrected.

  Own Id: OTP-15454

## Reltool 0.7.7

### Fixed Bugs and Malfunctions

- Improved documentation.

  Own Id: OTP-15190

## Reltool 0.7.6

### Improvements and New Features

- Calls to `erlang:get_stacktrace()` are removed.

  Own Id: OTP-14861

## Reltool 0.7.5

### Improvements and New Features

- Files generated by `release_handler` and `reltool`, which might contain
  Unicode characters, are now encoded as UTF-8 and written with format "~tp" or
  "~ts". If the file is to be read by `file:consult/1`, an encoding comment is
  added.

  Own Id: OTP-14463

## Reltool 0.7.4

### Improvements and New Features

- The User's Guide examples are updated after removal of support for Dets files
  created with Erlang/OTP R7 and earlier.

  Own Id: OTP-14422 Aux Id: OTP-13830

## Reltool 0.7.3

### Fixed Bugs and Malfunctions

- Fixed xml issues in old release notes

  Own Id: OTP-14269

## Reltool 0.7.2

### Fixed Bugs and Malfunctions

- Dependencies specified in .app files would earlier only be followed for
  applications that are included in a 'rel' spec in the reltool config. For
  other applications, only xref would decide the dependencies.

  Some dependency chains would even be missed for applications that are included
  in a 'rel' spec in the reltool config. E.g.

  - Application x has y as included application, and y in turn has z as included
    application. Then z is not included.
  - Application x has y in its 'applications' tag in the .app file, and y in
    turn has z as included application. Then z is not included.

  These bugs are now corrected.

  Own Id: OTP-11993

## Reltool 0.7.1

### Improvements and New Features

- Modify the code as motivated by a change of the Erlang Parser (`undefined` is
  no longer automatically inserted to the type of record fields without an
  initializer).

  Own Id: OTP-13033 Aux Id: OTP-12719

## Reltool 0.7

### Improvements and New Features

- Change license text from Erlang Public License to Apache Public License v2

  Own Id: OTP-12845

## Reltool 0.6.6

### Fixed Bugs and Malfunctions

- Fixed a minor typo in an error message from reltool_server.

  Own Id: OTP-11977

## Reltool 0.6.5

### Fixed Bugs and Malfunctions

- When adding a regexp to a filter in reltool using \{add,Regexp\}, and the
  existing regexp was undefined, reltool would crash since it got an improper
  list. This has been corrected. (Thanks to Håkan Mattsson)

  Own Id: OTP-11591

- Adapted reltool test server to common test usage of tc_status. (Note that this
  code is not used by OTP daily test runs.) (Thanks to Håkan Mattsson)

  Own Id: OTP-11592

- Application upgrade (appup) files are corrected for the following
  applications:

  `asn1, common_test, compiler, crypto, debugger, dialyzer, edoc, eldap, erl_docgen, et, eunit, gs, hipe, inets, observer, odbc, os_mon, otp_mibs, parsetools, percept, public_key, reltool, runtime_tools, ssh, syntax_tools, test_server, tools, typer, webtool, wx, xmerl`

  A new test utility for testing appup files is added to test_server. This is
  now used by most applications in OTP.

  (Thanks to Tobias Schlager)

  Own Id: OTP-11744

## Reltool 0.6.4.1

### Improvements and New Features

- The encoding of the `notes.xml` file has been changed from latin1 to utf-8 to
  avoid future merge problems.

  Own Id: OTP-11310

## Reltool 0.6.4

### Fixed Bugs and Malfunctions

- Fix receive support in erl_eval with a BEAM module. Thanks to Anthony Ramine.

  Own Id: OTP-11137

### Improvements and New Features

- Reltool used to fail if an application was mentioned in the config file which
  was not found in the file system, even if the application was explicitly
  excluded in the config. This has been changed and will only produce a warning.
  If the application is not explicitly excluded it will still cause reltool to
  fail. Thanks to Håkan Mattsson\!

  Own Id: OTP-10988

- Fix possibly "not owner" error while file copy with reltool. Thanks to Alexey
  Saltanov.

  Own Id: OTP-11099

## Reltool 0.6.3

### Improvements and New Features

- Some updates are made to reltool for handling unicode.

  Own Id: OTP-10781

## Reltool 0.6.2

### Fixed Bugs and Malfunctions

- - If `incl_cond` was set to `derived` on module level, then reltool_server
    would crash with a `case_clause`. This has been corrected. `incl_cond` on
    module level now overwrites `mod_cond` on app or sys level as described in
    the documentation.
  - If a `rel` spec in the reltool config does not contain all applications that
    are listed as `{applications,Applications}` in a `.app` file, then these
    applications are automatically added when creating the `.rel` file. For
    'included_applications', the behaviour was not the same. I.e. if a `rel`
    spec in the reltool config did not contain all applications that are listed
    as `{included_applications,InclApplications}` in a `.app` file, then reltool
    would fail with reason "Undefined applications" when creating the `.rel`
    file. This has been corrected, so both `applications` and
    `included_applications` are now automatically added if not already in the
    `rel` spec.
  - The `rel` specification now dictates the order in which included and used
    applications (specified in the `.app` file as `included_applications` and
    `applications` respectively) are loaded/started by the boot file. If the
    applications are not specified in the `rel` spec, then the order from the
    `.app` file is used. This was a bug earlier reported on systools, and is now
    also implemented in reltool.
  - Instead of only looking at the directory name, reltool now first looks for a
    `.app` file in order to figure out the name of an application.

  Own Id: OTP-10012 Aux Id: kunagi-171 \[82]

### Improvements and New Features

- Some examples overflowing the width of PDF pages have been corrected.

  Own Id: OTP-10665

## Reltool 0.6.1

### Improvements and New Features

- A new sys level configuration parameter `{excl_lib,otp_root}` is added. When
  this is set, the target system will not contain anything from `$OTPROOT`. It
  will only contain a releases directory with rel, script and boot files, and a
  lib directory with applications found outside of `$OTPROOT` (i.e. "your own"
  applications).

  Own Id: OTP-9743

## Reltool 0.6

### Fixed Bugs and Malfunctions

- Miscellaneous corrections:

  - Start of reltool GUI would sometimes crash with a badmatch in
    reltool_sys_win:do_init. This has been corrected.
  - Minor corrections of documentation and type specifications of app() and
    mod() are done.
  - If a module name is duplicated in an app file reltool would return an error.
    This is now changed to a warning.
  - Reltool would earlier not necessarily keep the order of applications as
    listed in the rel specification in the configuration. This has been
    corrected.
  - Reltool would earlier set the default for included applications to an empty
    list if it was not set in the rel specification in the configuration. This
    was correct according to sasl/systools documentation, but not according to
    sasl/systools implementation. We decided to change the documentation and
    reltool to use the value of included_applications from the .app file as
    default instead of the empty list, since this seems more intuitive and since
    systools always has done the same.
  - The value of included applications in the rel specification in the
    configuration did not overwrite included_applications in the .app file if it
    was set to an empty list. This has been corrected.
  - Reltool would earlier add load instructions in the script/boot files for ALL
    modules in the ebin directory of an application even if mod_cond was set to
    app (include only modules listed in the .app file). This has been corrected.
  - Reltool would earlier add start instructions in the script/boot file for
    included applications. This has been corrected - included applications shall
    only be loaded since the including application is responsible for starting
    them.
  - Status bar now indicates that reltool is working (Processing libraries...)
    for all configuration changes, and when generating target system.
  - Title of dependencies column in app and mod window is changed from "Modules
    used by others" to "Modules using this".

  Own Id: OTP-9792

- Configuration changes via the GUI had a few bugs related to error handling,
  rollback and undo. A major re-write of the reltool_server has been done in
  order to align the way reltool_server updates and uses its state and tables
  for all different kinds of configuration change.

  All configuration changes (except undo) now cause a re-read of the file
  system, meaning that if something has changed in the file system it will be
  reflected in the result of the configuration change.

  When loading a new configuration file via the GUI, the old configuration is
  now completely scratched, and only the new is valid.

  \*** POTENTIAL INCOMPATIBILITY \***

  Own Id: OTP-9794

- Some bug fixes related to the handling of escripts:

  - Reltool could not handle escripts with inlined applications. This has been
    corrected. Inlined applications will be visible in the GUI, but not possible
    to include/exclude separately.
  - Loading a config which contains an escript via the GUI menu did not produce
    the same result as when using the same configuration at reltool start.
    Paths, version and label could differ. This has been corrected.
  - Loading config with same escript (source) twice caused reltool to add same
    module twice. This has been corrected.
  - Loading config with same escript (inlined beam) twice caused reltool to fail
    saying module is included by two different applications. This has been
    corrected.
  - Loading config which in addition to an existing escript also adds another
    escript, for which the name sorts before the existing one, would cause
    reltool to fail saying "Application name clash". This has been corrected.

  Own Id: OTP-9968

- Reltool would sometimes generate a .app file containing
  `{start_phases,undefined}`, which would cause an exception in systools at
  parse time. This has been corrected so reltool now omits the `start_phases`
  entry if the value is `undefined`. (Thanks to Juan Jose Comellas)

  In order to align with reltool, sasl will also omit `start_phases` entries
  with value `undefined` in .script files.

  Own Id: OTP-10003

### Improvements and New Features

- A warning list is added to the sys window of the reltool GUI. This list will
  continuously show all warnings produced by the current configuration.

  Own Id: OTP-9967

- As a way of specifying one specific version of an application, the following
  configuration parameter is added on application level:

  \{lib_dir,Dir\}, Dir = string()

  This can be useful if the parent directory of the application directory is not
  suitable to use as a lib dir on system level.

  Own Id: OTP-9977

## Reltool 0.5.7.1

### Improvements and New Features

- Added recommendation about `RootDir` parameter to
  `reltool:eval_target_spec/3`.

  Own Id: OTP-9742

## Reltool 0.5.7

### Fixed Bugs and Malfunctions

- If a module was duplicated in the library directories visible to reltool, and
  the configuration did not point out which file to use, then reltool:start
  would always fail. A pop-up is added which asks if you want to continue with a
  safe and minimal configuration.

  Own Id: OTP-9383

- wx would sometimes crash due to an empty radiobox on the 'releases' tab of the
  system window. This radiobox is removed, and replaced by a listbox which will
  always contain at least kernel and stdlib applications.

  Own Id: OTP-9384

## Reltool 0.5.6

### Fixed Bugs and Malfunctions

- The system level option `app_files` is documented to allow the values
  `keep | strip | all`, but it only allowed `keep`. This is corrected.

  Own Id: OTP-9135

- Allow the same module name in multiple applications visible to reltool, as
  long as all but one of the applications/modules are explicitly excluded.
  (Thanks to Andrew Gopienko and Jay Nelson)

  Own Id: OTP-9229

## Reltool 0.5.5

### Fixed Bugs and Malfunctions

- The reltool module contained two seriously erroneous specs which caused bogus
  warnings when dialyzing reltool and some correct code of users. These were
  fixed (specs for start_link/1 and eval_server/3)

  \- Code cleanups and simplifications - Fix a bug in the calculation of
  circular dependencies - Eliminate two dialyzer warnings - Put files
  alphabetically

  Own Id: OTP-9120

## Reltool 0.5.4

### Improvements and New Features

- Added function `zip:foldl/3` to iterate over zip archives.

  Added functions to create and extract escripts. See `escript:create/2` and
  `escript:extract/2`.

  The undocumented function `escript:foldl/3` has been removed. The same
  functionality can be achieved with the more flexible functions
  `escript:extract/2` and `zip:foldl/3`.

  Record fields has been annotated with type info. Source files as been adapted
  to fit within 80 chars and trailing whitespace has been removed.

  Own Id: OTP-8521

- A new escript, called `reltool`, has been introduced in order to simplify the
  usage of the reltool application from makefiles.

  The handling of applications included in releases has been improved.
  Applications that are required to be started before other applications in a
  release are now automatically included in the release. The Kernel and STDLIB
  applications are always included as they are mandatory.

  Applications that are (explicitly or implicitly) included in a release are now
  automatically included as if they were explicitly included with the incl_cond
  flag.

  A new `embedded_app_type` option has been introduced. It is intended to be
  used for embedded systems where all included applications must be loaded from
  the boot script, as these systems does not utilize dynamic code loading. If
  `embedded_app_type `is set to something else than `undefined`, all included
  applications will be included in both the release as well as in the boot
  script. If the `profile` is `embedded` the `embedded_app_type` option defaults
  to `load`.

  A new function called `reltool:get_status/1` has been introduced. It returns
  status about the configuration in the server.

  The API functions that may take `PidOrOptions` as input and actually gets
  `Options` does now print out warnings.

  The internal error handling has been improved. For example `{error,Reason}` is
  always returned in case of errors even when the server dies.

  `app` and `appup` files has been added as well as a corresponding test suite.

  Various cleanups has been made in the code and in the documentation.

  Own Id: OTP-8590

## Reltool 0.5.3

### Improvements and New Features

- Removed spurious documentation files.

  Own Id: OTP-8057

## Reltool 0.5.2

### Improvements and New Features

- The documentation is now built with open source tools (xsltproc and fop) that
  exists on most platforms. One visible change is that the HTML frames are
  removed.

  Own Id: OTP-8254

## Reltool 0.5.1

### Fixed Bugs and Malfunctions

- In the new release of Reltool (0.5) there is a severe bug that may cause your
  source files to be deleted. The bug is triggered when you generate a target
  system WITH archive files AND your library directories are given with absolute
  paths. (Library directories are given with the ERL_LIBS environment variable
  or with the lib_dirs configuration parameter.)

  Own Id: OTP-8199

## Reltool 0.5

### Improvements and New Features

- The tool is still experimental. Feedback is appreciated.

  Major improvements of the target system generation has been performed. Now it
  is possible to generate a relocatable target system that does not need to be
  re-installed if it is moved to a new location. Archive files are automatically
  generated. A detailed specification of the target system can be generated
  without actually creating the target system. Relocatable escripts are put in
  the bin directory of the target system. etc. etc.

  Some new functions has been introduced in the `reltool` module:
  `start/1, start_link/1, get_config/3, get_target_spec/1 and eval_target_spec/3`.

  Some new configuration parameters has been introduced:
  `profile, incl_sys_filters, excl_sys_filters, incl_app_filters, excl_app_filters, incl_archive_filters, excl_archive_filters, archive_opts, escript and relocatable`.

  Some parameters have been obsoleted and given new semantics:
  `incl_erts_dirs (incl_sys_filters), excl_erts_dirs (excl_sys_filters), incl_app_dirs (incl_app_filters), excl_app_dirs (excl_app_filters) and escripts (escript).`

  \*** POTENTIAL INCOMPATIBILITY \***

  Own Id: OTP-7949

### Known Bugs and Problems

- The application is experimental. Feedback is appreciated.

## Reltool 0.2.2

### Fixed Bugs and Malfunctions

- The tool crashed when rel, script and boot files were generated via the GUI.
  This has been fixed.

  Own Id: OTP-7999

## Reltool 0.2.1

### Improvements and New Features

- Minor GUI fixes

  Own Id: OTP-7840

## Reltool 0.2

### Improvements and new features

This is the first (experimental) release of Reltool.

### Known Bugs and Problems

- The application is experimental.
