#!/usr/bin/perl

use strict;
use warnings;

if (@ARGV != 1 or $ARGV[0] !~ /^--(directories|files)$/) {
    die "usage: $0 { --directories | --files }\n";
}
my $files = $ARGV[0] eq "--files";

my $svn;
open $svn, 'svn status --verbose |'
    or die "Cannot spawn svn: $!\n";

my @files;

while (my $line = <$svn>) {
    chomp $line;
    my ($status, $mod, $locked, $history, $switched, $ood,
        $working, $committed, $comitter, $path)
        = ($line =~ /^([ ADMCIX?!~])([ MC])([ L])([ +])([ S])\ \ ([ *])\ +
           (\d*|\?)\ +(\d*|\?)\ +([^ ]*)\ +([^\n]+)$/x);
    die "Unexpected line: $line\n" unless $path;
    die "$path: file with conflicts\n" if $status eq 'C';
    die "$path: file is missing or incomplete\n" if $status eq '!';
    die "$path: versioned item is obstructed\n" if $status eq '~';
    print STDERR "$path: warning: unknown file\n" if $status eq '?';
    next if $path eq '.';

    push @files, $path if $status =~ /[ AM]/;
}

close $svn;

for my $file (@files) {
    if ($files) {
        print "$file\n" if -f $file;
    } else {
        print "$file\n" if -d $file;
    }
}
