/*
 * Copyright (C) 2009, 2010 Florian Weimer <fw@deneb.enyo.de>
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation files
 * (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#include <diagnostics/extensions/stacktrace/frame_visitor.hpp>

#include <unwind.h>

DIAGNOSTICS_NAMESPACE_BEGIN;
STACKTRACE_NAMESAPCE_BEGIN;

Traceback::FrameVisitor::~FrameVisitor()
{
}

namespace {
  struct state {
    bool first;
    Traceback::FrameVisitor *visitor;

    state(Traceback::FrameVisitor * v)
      : first(true), visitor(v)
    {
    }
  };
}

static _Unwind_Reason_Code
get_unwind_info_cb(struct _Unwind_Context *context, void *data)
{
  state *v = static_cast<state *>(data);

  // See libjava/stacktrace.cpp.
  _Unwind_Ptr ip;
  int ip_before_insn;
  ip = _Unwind_GetIPInfo(context, &ip_before_insn);
  if (!ip_before_insn) {
    --ip;
  }

  // Skip the Walk() frame.
  if (v->first) {
    v->first = false;
    return _URC_NO_REASON;
  }

  if (v->visitor->frame(reinterpret_cast<void *>(ip))) {
    return _URC_NO_REASON;
  } else {
    return _URC_NORMAL_STOP;
  }
}

void
Traceback::FrameVisitor::Walk()
{
  state st(this);
  _Unwind_Backtrace(get_unwind_info_cb, &st);
  // The following prevents tail call optimization, so we know that
  // this frame is always on the stack.
  __asm__ ("");
}

STACKTRACE_NAMESAPCE_END;
DIAGNOSTICS_NAMESPACE_END;

