/* Dia -- an diagram creation/manipulation program
 * Copyright (C) 1998 Alexander Larsson
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#pragma once

#include <gtk/gtk.h>

#include "color.h"
#include "dia-autoptr.h"

G_BEGIN_DECLS


#define DIA_TYPE_COLOUR_AREA (dia_colour_area_get_type ())
G_DECLARE_FINAL_TYPE (DiaColourArea, dia_colour_area, DIA, COLOUR_AREA, GtkEventBox)

struct _DiaColourArea
{
  GtkEventBox parent;
  int active_color;

  GdkPixbuf *reset;
  GdkPixbuf *swap;

  GtkWidget *color_select;
  int color_select_active;
  int edit_color;
  Color stored_foreground;
  Color stored_background;
};

GtkWidget *dia_colour_area_new (int width, int height);

G_END_DECLS
