#!/bin/sh

set -e

doit () {
    ( cd ben && env OMP_THREAD_LIMIT=1 DEB_BUILD_OPTIONS="parallel=1 $DEB_BUILD_OPTIONS" ben rebuild ../usr/ben/rebuild.ben -o ../missing.txt -j $(nproc) )

    HAS_CHANGES=0
    for u in build/*.changes; do
        if [ -f "$u" ]; then
            HAS_CHANGES=1
            dcmd mv "$u" pool
        fi
    done
    for u in build/*.log; do
        if [ -f "$u" ]; then
            mv "$u" pool
        fi
    done

    if [ $HAS_CHANGES -eq 1 ]; then
        touch pool/stamp && make -C pool -f ../usr/lib/Makefile.pool
        usr/bin/update-chroot.sh
    fi

    return $HAS_CHANGES
}

while ! doit; do
    true
done
