/*-
 * SPDX-License-Identifier: BSD-2-Clause-FreeBSD
 *
 * Copyright (C) 1996
 *	David L. Nugent.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY DAVID L. NUGENT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL DAVID L. NUGENT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char rcsid[] =
  "$FreeBSD: stable/12/usr.sbin/pw/rm_r.c 365454 2020-09-08 12:38:34Z markj $";
#endif /* not lint */

#include <sys/stat.h>

#include <dirent.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>

#include "pwupd.h"

void
rm_r(int rootfd, const char *path, uid_t uid)
{
	int dirfd;
	DIR *d;
	struct dirent  *e;
	struct stat     st;

	if (*path == '/')
		path++;

	dirfd = openat(rootfd, path, O_DIRECTORY);
	if (dirfd == -1) {
		return;
	}

	d = fdopendir(dirfd);
	if (d == NULL) {
		(void)close(dirfd);
		return;
	}
	while ((e = readdir(d)) != NULL) {
		if (strcmp(e->d_name, ".") == 0 || strcmp(e->d_name, "..") == 0)
			continue;

		if (fstatat(dirfd, e->d_name, &st, AT_SYMLINK_NOFOLLOW) != 0)
			continue;
		if (S_ISDIR(st.st_mode))
			rm_r(dirfd, e->d_name, uid);
		else if (S_ISLNK(st.st_mode) || st.st_uid == uid)
			unlinkat(dirfd, e->d_name, 0);
	}
	closedir(d);
	if (fstatat(rootfd, path, &st, AT_SYMLINK_NOFOLLOW) != 0)
		return;
	if (S_ISLNK(st.st_mode))
		unlinkat(rootfd, path, 0);
	else if (st.st_uid == uid)
		unlinkat(rootfd, path, AT_REMOVEDIR);
}
