# $FreeBSD: stable/12/lib/libsecureboot/Makefile.inc 347759 2019-05-16 16:15:41Z sjg $

.if empty(BEARSSL)
.include "../libbearssl/Makefile.inc"
.endif

.if !target(_${__this}_)
_${__this}_:

libsecureboot_src:= ${.PARSEDIR}

CFLAGS+= -I${libsecureboot_src}/h

.PATH: ${.PARSEDIR}

SRCS+= \
	readfile.c \
	brf.c \
	vesigned.c \
	vets.c

.if ${.CURDIR:M*libsecureboot*} != ""
SRCS+= veta.c
.endif

CFLAGS+= ${XCFLAGS.${.TARGET:T:R}:U}

# we use a couple of files from ${BEARSSL}/tools
BRSSL_CFLAGS+= -I${BEARSSL}/tools
BRSSL_SRCS+= \
	${BEARSSL}/tools/xmem.c \
	${BEARSSL}/tools/vector.c

BRSSL_DEPS= \
	brf.c \
	vets.c \
	veta.c

.if ${MK_LOADER_EFI_SECUREBOOT} != "no"
BRSSL_DEPS+= \
	efi_init.c \
	efi_variables.c
.endif

# we do not need/want nested objdirs
OBJS_SRCS_FILTER = T R

SRCS+= ${BRSSL_SRCS}


# extract the last cert from a chain (should be rootCA)
_LAST_PEM_USE: .USE
	sed "1,`grep -n .-END ${.ALLSRC:M*.pem} | tail -2 | head -1 | sed 's,:.*,,'`d" ${.ALLSRC:M*.pem} > ${.TARGET}

# extract 2nd last cert from chain - we use this for self-test
_2ndLAST_PEM_USE: .USE
	sed -n "`grep -n .-BEGIN ${.ALLSRC:M*.pem} | tail -2 | \
	sed 's,:.*,,' | xargs | (read a b; echo $$a,$$(($$b - 1)))`p" ${.ALLSRC:M*.pem} > ${.TARGET}

# list of hashes we support
VE_HASH_LIST?= SHA256

# list of signatures we support
# some people don't trust ECDSA
VE_SIGNATURE_LIST?= RSA

# this list controls our search for signatures so will not be sorted
# note: for X509 signatures we assume we can replace the trailing
# "sig" with "certs" to find the certificate chain
# eg. for manifest.esig we use manifest.ecerts
VE_SIGNATURE_EXT_LIST?= sig

# needs to be yes for FIPS 140-2 compliance
VE_SELF_TESTS?= no

# rules to populate the [tv]*.pem files we use to generate ta.h
# and can add/alter VE_*_LIST as desired.
.-include "local.trust.mk"

# this is what we use as our trust anchor
CFLAGS+= -I. -DTRUST_ANCHOR_STR=ta_PEM

.if ${VE_SELF_TESTS} != "no"
XCFLAGS.vets+= -DVERIFY_CERTS_STR=vc_PEM
.endif

# clean these up
VE_HASH_LIST:= ${VE_HASH_LIST:tu:O:u}
VE_SIGNATURE_LIST:= ${VE_SIGNATURE_LIST:tu:O:u}

# define what we are supporting
CFLAGS+= ${VE_HASH_LIST:@H@-DVE_$H_SUPPORT@} \
	${VE_SIGNATURE_LIST:@S@-DVE_$S_SUPPORT@}

.if ${VE_SIGNATURE_LIST:MOPENPGP} != ""
.include "openpgp/Makefile.inc"
.endif

.if ${VE_SELF_TESTS} != "no"
# The input used for hash KATs
# we use a string by default so it is independent of any other test
VE_HASH_KAT_STRLEN?= strlen
.if ${VE_HASH_KAT_STRLEN} == "strlen"
VE_HASH_KAT_STR?= self-tests-are-good
VE_HASH_KAT_STR_INPUT= echo -n
XCFLAGS.vets+= -DVE_HASH_KAT_STR=\"${VE_HASH_KAT_STR}\"
.else
VE_HASH_KAT_STR?= vc_PEM
VE_HASH_KAT_STR_INPUT= cat
VE_HASH_KAT_STRLEN= sizeof
XCFLAGS.vets+= -DVE_HASH_KAT_STR=${VE_HASH_KAT_STR}
.endif
XCFLAGS.vets+= -DVE_HASH_KAT_STRLEN=${VE_HASH_KAT_STRLEN}
.endif

# this should be updated occassionally this is 2019-01-01Z
SOURCE_DATE_EPOCH?= 1546329600
.if ${MK_REPRODUCIBLE_BUILD} == "yes"
BUILD_UTC?= ${SOURCE_DATE_EPOCH}
.endif
# BUILD_UTC provides a basis for the loader's notion of time
# By default we use the mtime of BUILD_UTC_FILE
.if empty(BUILD_UTC_FILE)
BUILD_UTC_FILE:= ${.PARSEDIR:tA}/${.PARSEFILE}
.endif
# you can of course set BUILD_UTC to any value you like
BUILD_UTC?= ${${STAT:Ustat} -f %m ${BUILD_UTC_FILE}:L:sh}

# Generate ta.h containing one or more PEM encoded trust anchors in ta_PEM.
#
# If we are doing self-tests, we define another arrary vc_PEM
# containing certificates that we can verify for each trust anchor.
# This is typically a subordinate CA cert.
# Finally we generate a hash of VE_HASH_KAT_STR
# using each supported hash method
# to use as a Known Answer Test (needed for FIPS 140-2)
#
TA_PEM_LIST ?= ${.ALLSRC:N*crl*:Mt*.pem}
VC_PEM_LIST ?= ${.ALLSRC:N*crl*:Mv*.pem}
vets.o vets.po vets.pico: ta.h
ta.h:
	@( echo '/* Autogenerated - DO NOT EDIT!!! */'; echo; \
	cat ${TA_PEM_LIST:O:u} /dev/null | \
	file2c -sx 'static const char ta_PEM[] = {' '};'; \
	echo "${.newline}${VE_HASH_LIST:O:u:@H@static char vh_$H[] = \"`${VE_HASH_KAT_STR_INPUT} ${VE_HASH_KAT_STR} | ${$H:U${H:tl}}`\";${.newline}@}"; ) > ${.TARGET}
.if ${VE_SELF_TESTS} != "no"
	( cat ${VC_PEM_LIST:O:u} /dev/null | \
	file2c -sx 'static const char vc_PEM[] = {' '};'; echo ) >> ${.TARGET}
.endif
	echo '#define BUILD_UTC ${BUILD_UTC}' >> ${.TARGET} ${.OODATE:MNOMETA_CMP}

# This header records our preference for signature extensions.
vesigned.o vesigned.po vesigned.pico: vse.h
vse.h:
	@( echo '/* Autogenerated - DO NOT EDIT!!! */'; echo; \
	echo "static const char *signature_exts[] = {"; \
	echo '${VE_SIGNATURE_EXT_LIST:O:u:@e@"$e",${.newline}@}'; \
	echo 'NULL };' ) > ${.TARGET}


.for s in ${BRSSL_SRCS} ${BRSSL_DEPS}
.ifdef BRSSL_SED
$s: brssl.h
.endif
XCFLAGS.${s:R}+= ${BRSSL_CFLAGS}
.endfor

.endif
