--- deps/llvm.mk.orig	2023-12-03 21:24:39 UTC
+++ deps/llvm.mk
@@ -60,7 +60,10 @@ endif
 LLVM_ENABLE_PROJECTS := $(LLVM_ENABLE_PROJECTS);lld
 endif
 
+LLVM_BUILD_BENCHMARKS?=1
+LLVM_INCLUDE_BENCHMARKS?=1
 
+
 LLVM_LIB_FILE := libLLVMCodeGen.a
 
 # Figure out which targets to build
@@ -76,6 +79,8 @@ LLVM_CMAKE += -DLLVM_ENABLE_RUNTIMES="$(LLVM_ENABLE_RU
 LLVM_CMAKE += -DLLVM_ENABLE_PROJECTS="$(LLVM_ENABLE_PROJECTS)"
 LLVM_CMAKE += -DLLVM_EXTERNAL_PROJECTS="$(LLVM_EXTERNAL_PROJECTS)"
 LLVM_CMAKE += -DLLVM_ENABLE_RUNTIMES="$(LLVM_ENABLE_RUNTIMES)"
+LLVM_CMAKE += -DLLVM_ENABLE_BENCHMARKS="$(LLVM_ENABLE_BENCHMARKS)"
+LLVM_CMAKE += -DLLVM_INCLUDE_BENCHMARKS="$(LLVM_INCLUDE_BENCHMARKS)"
 
 ifeq ($(USE_RV),1)
 LLVM_CMAKE += -DLLVM_EXTERNAL_RV_SOURCE_DIR=$(LLVM_MONOSRC_DIR)/rv
@@ -90,6 +95,9 @@ LLVM_LDFLAGS += $(LDFLAGS)
 LLVM_CXXFLAGS += $(CXXFLAGS)
 LLVM_CPPFLAGS += $(CPPFLAGS)
 LLVM_LDFLAGS += $(LDFLAGS)
+LLVM_CFLAGS += -I$(SRCCACHE)/$(LLVM_SRC_DIR)/third-party/benchmark/include
+LLVM_LDFLAGS += -L$(LLVM_BUILDDIR_withtype)/lib
+LLVM_CPPFLAGS += -I$(SRCCACHE)/$(LLVM_SRC_DIR)/third-party/benchmark/include
 LLVM_CMAKE += -DLLVM_TARGETS_TO_BUILD:STRING="$(LLVM_TARGETS)" -DCMAKE_BUILD_TYPE="$(LLVM_CMAKE_BUILDTYPE)"
 LLVM_CMAKE += -DLLVM_EXPERIMENTAL_TARGETS_TO_BUILD:STRING="$(LLVM_EXPERIMENTAL_TARGETS)"
 LLVM_CMAKE += -DLLVM_ENABLE_LIBXML2=OFF -DLLVM_HOST_TRIPLE="$(or $(XC_HOST),$(BUILD_MACHINE))"
@@ -231,6 +239,12 @@ $(eval $(call LLVM_PATCH,llvm-ittapi-cmake))
 endef
 
 $(eval $(call LLVM_PATCH,llvm-ittapi-cmake))
+
+$(SRCCACHE)/$(LLVM_SRC_DIR)/verfix.patch-applied: $(SRCCACHE)/$(LLVM_SRC_DIR)/source-extracted $(LLVM_PATCH_VERSIONFIXES)
+	cd $(SRCCACHE)/$(LLVM_SRC_DIR) && patch < $(LLVM_PATCH_VERSIONFIXES)
+	echo 1 > $@
+
+$(LLVM_BUILDDIR_withtype)/build-configured: | $(SRCCACHE)/$(LLVM_SRC_DIR)/verfix.patch-applied
 
 ifeq ($(USE_SYSTEM_ZLIB), 0)
 $(LLVM_BUILDDIR_withtype)/build-configured: | $(build_prefix)/manifest/zlib
